/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.database.DataBase;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.Main;
import dk.hkj.main.StatValues;
import dk.hkj.main.Support;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.table.TableCellRenderer;

public class PaneRange
extends FocusAdapter
implements Main.PaneInterface,
ActionListener {
    private JPanel mainPanel = null;
    private JPanel bottomPanel = null;
    private JTable table = null;
    private JTextField firstSampleTextField = null;
    private JTextField lastSampleTextField = null;
    private JRadioButton displaySlopeSecondsRadioButton = null;
    private JRadioButton displaySlopeMinutesRadioButton = null;
    private JRadioButton displaySlopeHoursRadioButton = null;
    private JLabel rangeLabel = null;
    private DataBase.DataBaseRange dataBaseRange = Support.dataBase.getRange();
    private boolean isTimeBased = false;
    private int domainColumn = -1;
    private Timer timer = null;
    private String rowId = null;
    private Boolean rowColor = false;
    StatValues statValues = new StatValues(false){

        @Override
        public void updater() {
            int first;
            if (Support.dataBase.rows() == 0) {
                return;
            }
            int last = PaneRange.this.dataBaseRange.getLastIndex() - 1;
            if (last < (first = PaneRange.this.dataBaseRange.getFirstIndex())) {
                last = Support.dataBase.rows() - 1;
                first = 0;
            }
            double time = Support.dataBase.getValue(last, PaneRange.this.domainColumn) - Support.dataBase.getValue(first, PaneRange.this.domainColumn);
            for (StatValues.StatValue st : PaneRange.this.statValues) {
                st.update(Support.dataBase.getColumnRange(PaneRange.this.dataBaseRange, st.getColumnNo()), time);
            }
            String s = "Range: ";
            if (PaneRange.this.isTimeBased) {
                s = String.valueOf(s) + Support.showPeriod(time) + " / ";
            }
            s = String.valueOf(s) + (last - first + 1) + " samples";
            PaneRange.this.rangeLabel.setText(s);
        }
    };
    SlopeListener slopeListener = new SlopeListener();

    PaneRange() {
        this.timer = new Timer(300, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PaneRange.this.updateTime();
            }
        });
    }

    @Override
    public int getHotKey() {
        return 82;
    }

    public void setRange(String fs, String ls) {
        this.firstSampleTextField.setText(fs);
        this.lastSampleTextField.setText(ls);
        this.updateInput();
    }

    public void setSlope(char slope) {
        if (!this.isTimeBased) {
            this.statValues.setSlopeMode(' ');
            slope = (char)32;
        } else {
            switch (slope) {
                case 's': {
                    this.displaySlopeSecondsRadioButton.setSelected(true);
                    break;
                }
                case 'm': {
                    this.displaySlopeMinutesRadioButton.setSelected(true);
                    break;
                }
                case 'h': {
                    this.displaySlopeHoursRadioButton.setSelected(true);
                }
            }
        }
        this.statValues.setSlopeMode(slope);
        this.updateTime();
    }

    @Override
    public String getTitle() {
        return "Range";
    }

    @Override
    public JPanel getPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.table = new FontAdjust.FontTable(this.statValues){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                JLabel comp = (JLabel)super.prepareRenderer(renderer, row, col);
                if (col == 0) {
                    comp.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
                    comp.setHorizontalAlignment(2);
                } else {
                    comp.setHorizontalAlignment(0);
                }
                if (!comp.getBackground().equals(Support.colorScheme.selectedCellbackground)) {
                    switch (Support.systemSettings.deviceTableBackground) {
                        case Alternate: {
                            String id = PaneRange.this.statValues.getEntry(row).getName();
                            id = id.substring(0, id.indexOf(46));
                            if (row == 0) {
                                PaneRange.this.rowId = id;
                                PaneRange.this.rowColor = false;
                                break;
                            }
                            if (id.equals(PaneRange.this.rowId)) break;
                            PaneRange.this.rowId = id;
                            PaneRange.this.rowColor = PaneRange.this.rowColor == false;
                            break;
                        }
                        case First: {
                            PaneRange.this.rowColor = false;
                            String id = PaneRange.this.statValues.getEntry(row).getName();
                            int n = id.indexOf(46);
                            id = id.substring(0, n);
                            if (row != 0 && id.equals(PaneRange.this.statValues.getEntry(row - 1).getName().substring(0, n))) break;
                            PaneRange.this.rowId = id;
                            PaneRange.this.rowColor = true;
                            break;
                        }
                        case OneInFour: {
                            PaneRange.this.rowColor = row % 4 == 0;
                            break;
                        }
                    }
                    comp.setBackground(PaneRange.this.rowColor != false ? Support.colorScheme.tableGridAlternateBackground : Support.colorScheme.textBackground);
                }
                return comp;
            }
        };
        Support.colorScheme.selectedCellbackground = this.table.getSelectionBackground();
        Support.colorScheme.selectedCellForeground = this.table.getSelectionForeground();
        this.table.setAutoResizeMode(0);
        this.table.setColumnModel(new Support.WidthTableColumnModel(new int[]{200, 50, 90, 90, 90, 90, 90, 90, 90}));
        this.table.setModel(this.statValues);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.mainPanel.add(new JScrollPane(this.table));
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new GridBagLayout());
        this.mainPanel.add((Component)this.bottomPanel, "South");
        FontAdjust.FontLabel label = new FontAdjust.FontLabel("First sample:");
        label.setToolTipText("<html>Formats supported:<br>Empty: All data<br>seconds from start<br>h:m:s hour minutes seconds<br>postfix with h/m for hours/minutes<br>#sampleNumber<br>Prefix with - means from end of data<br>Prefix with w for width/lenght of data, only in last field");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.weightx = 1.0;
        c.anchor = 13;
        c.insets = new Insets(5, 5, 5, 5);
        this.bottomPanel.add((Component)label, c);
        this.firstSampleTextField = new FontAdjust.FontTextField(8);
        this.firstSampleTextField.setToolTipText("<html>Formats supported:<br>Empty: All data<br>seconds from start<br>h:m:s hour minutes seconds<br>postfix with h/m for hours/minutes<br>#sampleNumber<br>Prefix with - means from end of data<br>Prefix with w for width/lenght of data, only in last field");
        this.firstSampleTextField.addActionListener(this);
        this.firstSampleTextField.addFocusListener(this);
        this.firstSampleTextField.setMinimumSize(new Dimension(30, 20));
        c = new GridBagConstraints();
        c.gridx = 1;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(5, 5, 5, 5);
        this.bottomPanel.add((Component)this.firstSampleTextField, c);
        label = new FontAdjust.FontLabel("Last sample:");
        label.setToolTipText("<html>Formats supported:<br>Empty: All data<br>seconds from start<br>h:m:s hour minutes seconds<br>postfix with h/m for hours/minutes<br>#sampleNumber<br>Prefix with - means from end of data<br>Prefix with w for width/lenght of data, only in last field");
        c = new GridBagConstraints();
        c.gridx = 2;
        c.weightx = 1.0;
        c.anchor = 13;
        c.insets = new Insets(5, 5, 5, 5);
        this.bottomPanel.add((Component)label, c);
        this.lastSampleTextField = new FontAdjust.FontTextField(8);
        this.lastSampleTextField.setToolTipText("<html>Formats supported:<br>Empty: All data<br>seconds from start<br>h:m:s hour minutes seconds<br>postfix with h/m for hours/minutes<br>#sampleNumber<br>Prefix with - means from end of data<br>Prefix with w for width/lenght of data, only in last field");
        this.lastSampleTextField.addActionListener(this);
        this.lastSampleTextField.addFocusListener(this);
        this.lastSampleTextField.setMinimumSize(new Dimension(30, 20));
        c = new GridBagConstraints();
        c.gridx = 3;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(5, 5, 5, 5);
        this.bottomPanel.add((Component)this.lastSampleTextField, c);
        c = new GridBagConstraints();
        c.gridx = 4;
        c.weightx = 0.1;
        c.anchor = 10;
        c.insets = new Insets(2, 2, 2, 2);
        this.bottomPanel.add((Component)new FontAdjust.FontLabel("Slope:"), c);
        ButtonGroup displayGroup = new ButtonGroup();
        this.displaySlopeSecondsRadioButton = new FontAdjust.FontRadioButton("/s");
        this.displaySlopeSecondsRadioButton.setActionCommand("s");
        this.displaySlopeSecondsRadioButton.addActionListener(this.slopeListener);
        c = new GridBagConstraints();
        c.gridx = 5;
        c.weightx = 0.1;
        c.anchor = 10;
        c.insets = new Insets(2, 2, 2, 2);
        this.bottomPanel.add((Component)this.displaySlopeSecondsRadioButton, c);
        displayGroup.add(this.displaySlopeSecondsRadioButton);
        this.displaySlopeMinutesRadioButton = new FontAdjust.FontRadioButton("/m");
        this.displaySlopeMinutesRadioButton.setActionCommand("m");
        this.displaySlopeMinutesRadioButton.addActionListener(this.slopeListener);
        c = new GridBagConstraints();
        c.gridx = 6;
        c.weightx = 0.1;
        c.anchor = 10;
        c.insets = new Insets(2, 2, 2, 2);
        this.bottomPanel.add((Component)this.displaySlopeMinutesRadioButton, c);
        displayGroup.add(this.displaySlopeMinutesRadioButton);
        this.displaySlopeHoursRadioButton = new FontAdjust.FontRadioButton("/h");
        this.displaySlopeHoursRadioButton.setActionCommand("h");
        this.displaySlopeHoursRadioButton.addActionListener(this.slopeListener);
        c = new GridBagConstraints();
        c.gridx = 7;
        c.weightx = 0.1;
        c.anchor = 10;
        c.insets = new Insets(2, 2, 2, 2);
        this.bottomPanel.add((Component)this.displaySlopeHoursRadioButton, c);
        displayGroup.add(this.displaySlopeHoursRadioButton);
        this.displaySlopeSecondsRadioButton.setSelected(true);
        this.rangeLabel = new FontAdjust.FontLabel();
        c = new GridBagConstraints();
        c.gridx = 8;
        c.weightx = 1.0;
        c.anchor = 13;
        c.insets = new Insets(5, 5, 5, 5);
        this.bottomPanel.add((Component)this.rangeLabel, c);
        JPopupMenu popup = new JPopupMenu();
        FontAdjust.FontMenuItem mi = new FontAdjust.FontMenuItem("Copy to clipboard");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PaneRange.this.statValues.copyToClipboard();
            }
        });
        popup.add(mi);
        this.table.setComponentPopupMenu(popup);
        return this.mainPanel;
    }

    @Override
    public void changeDevicesOrTable(Support.UpdateType type) {
        if (type.equals((Object)Support.UpdateType.StartInit)) {
            return;
        }
        if (type == Support.UpdateType.ColumnsTable) {
            this.setupLayout();
        }
    }

    private void updateTime() {
        this.statValues.update();
    }

    private void updateInput() {
        try {
            this.dataBaseRange = Support.dataBase.getRange(this.domainColumn, this.firstSampleTextField.getText(), this.lastSampleTextField.getText());
            this.firstSampleTextField.setBackground(Support.colorScheme.textBackground);
            this.lastSampleTextField.setBackground(Support.colorScheme.textBackground);
        }
        catch (Exception exception) {
            this.firstSampleTextField.setBackground(Support.colorScheme.errorBackground);
            this.lastSampleTextField.setBackground(Support.colorScheme.errorBackground);
        }
    }

    @Override
    public void select() {
        this.timer.start();
        this.updateTime();
    }

    @Override
    public void deselect() {
        this.timer.stop();
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.updateInput();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateInput();
    }

    private void setupLayout() {
        if (InterfaceThreads.getDevices() == null) {
            return;
        }
        this.domainColumn = Support.dataBase.header().getDomainColumn();
        this.isTimeBased = Support.dataBase.header().isTimeColumn(this.domainColumn);
        this.statValues.clear();
        this.statValues.addAll(Support.dataBase.header().getDataColumnsList());
        this.statValues.update();
        this.statValues.setSlopeMode(this.isTimeBased ? (char)'\u0000' : ' ');
    }

    private void slopeChanged(String cmd) {
        if (!this.isTimeBased) {
            this.statValues.setSlopeMode(' ');
        } else if (cmd == "s") {
            this.statValues.setSlopeMode('s');
        } else if (cmd == "m") {
            this.statValues.setSlopeMode('m');
        } else if (cmd == "h") {
            this.statValues.setSlopeMode('h');
        }
        this.updateTime();
    }

    public List<String> generateScript() {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        sb.append("#RangeOptions ");
        sb.append("/" + this.statValues.getSlopeMode());
        list.add("#RangeSamples " + Support.conditionalQuote(this.firstSampleTextField.getText().trim()) + " " + Support.conditionalQuote(this.lastSampleTextField.getText().trim()));
        list.add(sb.toString());
        return list;
    }

    private class SlopeListener
    implements ActionListener {
        private SlopeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PaneRange.this.slopeChanged(e.getActionCommand());
        }
    }
}

