/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.FontAdjust;
import dk.hkj.main.HelpLoader;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.Main;
import dk.hkj.main.Mathematics;
import dk.hkj.main.Support;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.table.TableCellRenderer;

public class PaneMath
implements Main.PaneInterface {
    private JTable table = null;
    private JPanel mainPanel = null;
    private JScrollPane scrollPane = null;
    private static Map<String, String> help = null;

    @Override
    public String getTitle() {
        return "Math";
    }

    @Override
    public int getHotKey() {
        return 77;
    }

    @Override
    public JPanel getPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.table = new FontAdjust.FontTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                Component comp = super.prepareRenderer(renderer, row, col);
                if (!comp.getBackground().equals(Support.colorScheme.selectedCellbackground)) {
                    comp.setBackground(row % 4 == 0 ? Support.colorScheme.tableGridAlternateBackground : Support.colorScheme.textBackground);
                }
                if (comp instanceof JLabel) {
                    JLabel label = (JLabel)comp;
                    if (col == 0) {
                        label.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
                        label.setHorizontalAlignment(2);
                    } else if (col == 5) {
                        label.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
                        label.setHorizontalAlignment(2);
                        Mathematics.MathEntry me = ((Mathematics.MathTableModel)PaneMath.this.table.getModel()).getMathEntry(row);
                        if (me.isError()) {
                            label.setBackground(Support.colorScheme.errorBackground);
                            label.setToolTipText(me.errorMessage());
                        }
                    } else {
                        label.setHorizontalAlignment(0);
                    }
                }
                return comp;
            }

            @Override
            public String getToolTipText(MouseEvent e) {
                String tip = null;
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                try {
                    switch (this.columnModel.getColumn(colIndex).getModelIndex()) {
                        case 3: {
                            tip = ((String)this.getValueAt(rowIndex, colIndex)).trim().toLowerCase();
                            tip = (String)help.get(tip);
                            break;
                        }
                        case 5: {
                            tip = (String)help.get("formulas");
                        }
                    }
                }
                catch (RuntimeException runtimeException) {}
                return tip != null && tip.length() > 0 ? tip : null;
            }
        };
        this.table.setAutoResizeMode(0);
        this.table.setColumnModel(new Support.WidthTableColumnModel(new int[]{100, 60, 60, 100, 60, 540}));
        this.table.setModel(Support.math.getTableModel());
        Support.colorScheme.selectedCellbackground = this.table.getSelectionBackground();
        Support.colorScheme.selectedCellForeground = this.table.getSelectionForeground();
        this.table.setDefaultEditor(String.class, new StringTypeCellEditor());
        this.table.setDefaultEditor(Integer.class, new Support.AutoSelectCellEditor());
        this.table.setDefaultEditor(Mathematics.MathType.class, new MathTypeCellEditor());
        this.table.getTableHeader().setReorderingAllowed(false);
        Support.chartScales.setTable(this.table);
        this.scrollPane = new JScrollPane(this.table);
        this.mainPanel.add(this.scrollPane);
        this.table.setFillsViewportHeight(true);
        this.table.addNotify();
        JPanel bottomPanel = new JPanel();
        this.mainPanel.add((Component)bottomPanel, "South");
        FontAdjust.FontButton addButton = new FontAdjust.FontButton("Add");
        bottomPanel.add(addButton);
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Support.math.addNewEntry();
            }
        });
        FontAdjust.FontButton deleteButton = new FontAdjust.FontButton("Delete");
        bottomPanel.add(deleteButton);
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<Integer> toRemove = new ArrayList<Integer>();
                int i = PaneMath.this.table.getRowCount() - 1;
                while (i >= 0) {
                    if (PaneMath.this.table.isRowSelected(i)) {
                        toRemove.add(i);
                    }
                    --i;
                }
                if (toRemove.size() <= 1 || JOptionPane.showConfirmDialog(PaneMath.this.mainPanel, "Confirm", "Remove all marked entries", 0) == 0) {
                    Iterator iterator = toRemove.iterator();
                    while (iterator.hasNext()) {
                        i = (Integer)iterator.next();
                        Support.math.deleteEntry(i);
                    }
                }
            }
        });
        return this.mainPanel;
    }

    @Override
    public void changeDevicesOrTable(Support.UpdateType type) {
        if (type.equals((Object)Support.UpdateType.StartInit)) {
            return;
        }
    }

    private void putHelp(String key, String value) {
        help.put(key.trim().toLowerCase(), "<html>" + value.replace("\n", "<br>") + "</html>");
    }

    @Override
    public void select() {
        if (help == null) {
            List<String> list = HelpLoader.getHelpFile("MathFilterHelp");
            StringBuilder sb = new StringBuilder();
            String key = "";
            help = new HashMap<String, String>();
            for (String s : list) {
                if (s.length() > 0 && Character.isAlphabetic(s.charAt(0))) {
                    if (key.length() > 0) {
                        this.putHelp(key, sb.toString());
                        sb.setLength(0);
                    }
                    key = s;
                    continue;
                }
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(s.trim());
            }
            if (key.length() > 0) {
                this.putHelp(key, sb.toString());
                sb.setLength(0);
            }
        }
    }

    @Override
    public void deselect() {
        if (Support.math.isChanged() && !InterfaceThreads.isLogging()) {
            Support.math.clearErrors();
            Support.math.saveDefault();
            Support.math.calcMathAllRows(Support.dataBase.header().getDomainColumn());
        }
    }

    public static class MathTypeCellEditor
    extends DefaultCellEditor {
        public MathTypeCellEditor() {
            super(new FontAdjust.FontComboBox());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component editor = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (editor instanceof JComboBox) {
                JComboBox cb = (JComboBox)editor;
                if (cb.getItemCount() == 0) {
                    cb.setMaximumRowCount(20);
                    cb.setRenderer(new MyComboBoxRenderer());
                    for (String s : Mathematics.getTypeList()) {
                        cb.addItem(s);
                    }
                }
                cb.setSelectedItem(value);
            }
            return editor;
        }
    }

    private static class MyComboBoxRenderer
    extends BasicComboBoxRenderer {
        private MyComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                if (-1 < index) {
                    String s = (String)list.getModel().getElementAt(index);
                    if (s != null) {
                        s = (String)help.get(s.trim().toLowerCase());
                    }
                    list.setToolTipText(s != null && s.length() > 0 ? s : null);
                } else {
                    list.setToolTipText(null);
                }
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }

    public static class StringTypeCellEditor
    extends Support.AutoSelectCellEditor
    implements ActionListener {
        private int n = 0;
        private JTextField tf = null;

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component editor = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (editor instanceof JTextField) {
                this.tf = (JTextField)editor;
                if (column == 5) {
                    this.tf.setComponentPopupMenu(Support.getPopupMenu(true, this));
                    this.tf.addKeyListener(new KeyAdapter(){

                        @Override
                        public void keyPressed(KeyEvent arg0) {
                            if (!(arg0.getKeyCode() != 155 && arg0.getKeyCode() != 525 || arg0.isAltDown() || arg0.isShiftDown() || arg0.isControlDown())) {
                                this.popupMenu();
                            }
                        }
                    });
                } else {
                    this.tf.setComponentPopupMenu(null);
                    this.tf = null;
                }
            }
            return editor;
        }

        private void popupMenu() {
            this.tf.getComponentPopupMenu().show(this.tf, 0, 0);
        }

        private void insert(String value) {
            this.n = this.tf.getCaretPosition();
            String s = this.tf.getText();
            if (this.tf.getSelectionStart() < this.tf.getSelectionEnd()) {
                s = String.valueOf(s.substring(0, this.tf.getSelectionStart())) + value + s.substring(this.tf.getSelectionEnd());
                this.n = this.tf.getSelectionStart() + value.length();
                this.tf.setText(s);
            } else {
                this.tf.setText(String.valueOf(s.substring(0, this.n)) + value + s.substring(this.n));
                this.n += value.length();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    tf.setCaretPosition(n);
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent value) {
            this.insert(value.getActionCommand());
        }
    }
}

