/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.comm.CommInterface;
import dk.hkj.comm.SerialInterface;
import dk.hkj.comm.VXI11Discovery;
import dk.hkj.devices.LoadDeviceConfig;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.Main;
import dk.hkj.main.PopupGpibConfig;
import dk.hkj.main.PopupImage;
import dk.hkj.main.PopupNewDevice;
import dk.hkj.main.PopupNotes;
import dk.hkj.main.PopupTestInterface;
import dk.hkj.main.Support;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.table.TableCellRenderer;

public class PaneLoadDevices
implements Main.PaneInterface,
ActionListener {
    private JPanel mainPanel = null;
    private JTable table = null;
    private JCheckBox serialScanCheckBox = null;
    private JTextField excludeSerialTextField = null;
    private JTextField filterTextField = null;
    private JComboBox<String> deviceSelectComboBox = null;
    private JButton reconnectButton = null;
    private boolean starting = true;
    private Timer timer = new Timer(500, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PaneLoadDevices.this.timerUpdate();
        }
    });
    private JPopupMenu popupMenu = null;
    private PopupNotes popupNotes = null;
    private JPopupMenu newPopupMenu = null;
    private JMenuItem previewMenuItem = null;
    private PopupNewDevice popupNewDevice = null;
    private PopupGpibConfig popupGpibConfig = null;

    PaneLoadDevices() {
    }

    @Override
    public int getHotKey() {
        return 76;
    }

    private void fillComboBox(String filter) {
        this.deviceSelectComboBox.removeAllItems();
        if (filter.length() == 0) {
            this.deviceSelectComboBox.addItem("Search socket");
            for (String s : Support.manageDeviceDefinitions.getDeviceList()) {
                this.deviceSelectComboBox.addItem(s);
            }
        } else {
            for (String s : Support.manageDeviceDefinitions.getFilteredDeviceList(this.filterTextField.getText())) {
                this.deviceSelectComboBox.addItem(s);
            }
        }
    }

    public void errorNotification(List<String> list) {
        if (this.mainPanel == null || !this.mainPanel.isVisible()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            if (sb.length() > 0) {
                sb.append("<br>");
            }
            sb.append(s);
        }
        sb.insert(0, "<html>");
        JOptionPane.showMessageDialog(this.mainPanel, new JLabel(sb.toString()), "Error", 0);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        String cmd = arg0.getActionCommand();
        if (cmd.equals("Filter")) {
            this.fillComboBox(this.filterTextField.getText().trim());
        } else if (cmd.equals("Add")) {
            String s = (String)this.deviceSelectComboBox.getSelectedItem();
            LoadDeviceConfig.LoadDevice ld = InterfaceThreads.loadDeviceConfig.addDevice(s);
            this.selectedDevice(ld);
        } else if (cmd.equals("Remove")) {
            ArrayList<Integer> toRemove = new ArrayList<Integer>();
            int i = this.table.getRowCount() - 1;
            while (i >= 0) {
                if (this.table.isRowSelected(i)) {
                    toRemove.add(i);
                }
                --i;
            }
            if (toRemove.size() <= 1 || JOptionPane.showConfirmDialog(this.mainPanel, "Confirm", "Remove all marked devices", 0) == 0) {
                Iterator iterator = toRemove.iterator();
                while (iterator.hasNext()) {
                    i = (Integer)iterator.next();
                    InterfaceThreads.loadDeviceConfig.removeDevice(i);
                }
            }
            this.table.clearSelection();
            if (InterfaceThreads.loadDeviceConfig.getRowCount() == 0) {
                this.showHelpPopup();
            }
        } else if (cmd.equals("SortDevice")) {
            InterfaceThreads.loadDeviceConfig.sortDevice();
        } else if (cmd.equals("SortAddres")) {
            InterfaceThreads.loadDeviceConfig.sortAddress();
        } else if (cmd.equals("Reconnect")) {
            List<String> list = InterfaceThreads.loadDeviceConfig.getErrors();
            if (list != null && list.size() > 0) {
                this.errorNotification(list);
            } else {
                InterfaceThreads.loadDeviceConfig.saveDefault();
                InterfaceThreads.startInterface();
                Main.selectPane("Commands");
            }
        } else if (cmd.equals("Scan")) {
            InterfaceThreads.loadDeviceConfig.setSearchSerialPorts(this.serialScanCheckBox.isSelected());
            InterfaceThreads.loadDeviceConfig.setExcludedSerialPorts(this.excludeSerialTextField.getText());
        } else if (cmd.equals("New")) {
            if (this.popupNewDevice != null) {
                this.popupNewDevice.setVisible(false);
                this.popupNewDevice.dispose();
            }
            this.popupNewDevice = new PopupNewDevice();
            this.popupNewDevice.setLocationRelativeTo(this.mainPanel);
            this.popupNewDevice.setVisible(true);
        } else if (cmd.equals("Setup")) {
            this.previewSetup();
        } else if (cmd.equals("GPIB")) {
            if (this.popupGpibConfig != null) {
                this.popupGpibConfig.setVisible(false);
                this.popupGpibConfig.dispose();
            }
            this.popupGpibConfig = new PopupGpibConfig();
            this.popupGpibConfig.setLocationRelativeTo(this.mainPanel);
            this.popupGpibConfig.setVisible(true);
        } else if (cmd.equals("Doc")) {
            Desktop dt = Desktop.getDesktop();
            if (dt != null) {
                try {
                    dt.browse(new URI("https://lygte-info.dk/project/TestControllerFunctions%20UK.html"));
                    dt.browse(new URI("https://lygte-info.dk/project/TestControllerConfigDevice%20UK.html"));
                    dt.browse(new URI("https://lygte-info.dk/project/TestControllerConfigDevice2%20UK.html"));
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                }
            }
        } else if (cmd.equals("ChangedDevice")) {
            this.previewMenuItem.setEnabled(this.hasPreview());
        }
    }

    private void previewSetup() {
        String name = (String)this.deviceSelectComboBox.getSelectedItem();
        if (name == null || name.length() == 0) {
            return;
        }
        ManageDeviceDefinitions.DeviceDefinition def = Support.manageDeviceDefinitions.findDeviceDefintionFromName(name);
        if (def == null) {
            return;
        }
        DeviceInterface di = InterfaceThreads.findDeviceInterfaceFromDeviceDefinition(def);
        if (di == null) {
            return;
        }
        di.setDef(def);
        di.showModesPopup(Support.paneCommand.modeButton);
        di.showSetupPopup(Support.paneCommand.modeButton);
        this.showNotes(def);
        PopupTestInterface testInterfacePopup = new PopupTestInterface(Support.paneCommand.modeButton, di, true);
        testInterfacePopup.setVisible(true);
    }

    private boolean hasPreview() {
        String name = (String)this.deviceSelectComboBox.getSelectedItem();
        if (name == null || name.length() == 0) {
            return false;
        }
        ManageDeviceDefinitions.DeviceDefinition def = Support.manageDeviceDefinitions.findDeviceDefintionFromName(name);
        if (def == null) {
            return false;
        }
        DeviceInterface di = InterfaceThreads.findDeviceInterfaceFromDeviceDefinition(def);
        if (di == null) {
            return false;
        }
        di.setDef(def);
        return true;
    }

    private boolean hasNotes(ManageDeviceDefinitions.DeviceDefinition def) {
        if (def == null) {
            return false;
        }
        String noteImages = def.getItem("#noteImages");
        if (noteImages != null && noteImages.length() > 0) {
            return true;
        }
        String notes = def.getItem("#notes");
        return notes != null && notes.length() != 0;
    }

    private void showNotes(ManageDeviceDefinitions.DeviceDefinition def) {
        String notes;
        if (def == null) {
            return;
        }
        String noteImages = def.getItem("#noteImages");
        if (noteImages != null && noteImages.length() > 0) {
            PopupImage pi = PopupImage.getPopup();
            pi.setShowFirstLoaded();
            String[] stringArray = noteImages.split("[\n]");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                String[] stringArray2 = Support.splitWithQuotes(line);
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String s = stringArray2[n4];
                    pi.addImage(s);
                    ++n4;
                }
                ++n2;
            }
            pi.showDefault(false);
        }
        if ((notes = def.getItem("#notes")) == null || notes.length() == 0) {
            return;
        }
        if (this.popupNotes != null) {
            this.popupNotes.setVisible(false);
            this.popupNotes.dispose();
        }
        this.popupNotes = new PopupNotes(def);
        this.popupNotes.setLocationRelativeTo(this.mainPanel);
        this.popupNotes.setVisible(true);
    }

    private void selectedDevice(LoadDeviceConfig.LoadDevice device) {
        int i = 0;
        while (i < InterfaceThreads.loadDeviceConfig.getRowCount()) {
            if (InterfaceThreads.loadDeviceConfig.getIndex(i).equals(device)) {
                this.table.setRowSelectionInterval(i, i);
                this.table.scrollRectToVisible(this.table.getCellRect(this.table.getRowCount() - 1, 0, true));
            }
            ++i;
        }
    }

    public void scrollTable() {
        this.table.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                PaneLoadDevices.this.table.setRowSelectionInterval(PaneLoadDevices.this.table.getRowCount() - 1, PaneLoadDevices.this.table.getRowCount() - 1);
                PaneLoadDevices.this.table.scrollRectToVisible(PaneLoadDevices.this.table.getCellRect(PaneLoadDevices.this.table.getRowCount() - 1, 0, true));
                PaneLoadDevices.this.table.invalidate();
            }
        });
    }

    private void showComPopup(final JTextField target) {
        this.popupMenu.removeAll();
        for (CommInterface port : SerialInterface.getSerialPorts(".*", false)) {
            FontAdjust.FontMenuItem mi = new FontAdjust.FontMenuItem(port.getName());
            mi.setActionCommand(port.getDeviceName());
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    target.setText(e.getActionCommand());
                }
            });
            this.popupMenu.add(mi);
        }
        this.popupMenu.show(target, 180, 0);
    }

    private void showSocketPopup(final JTextField target) {
        this.popupMenu.removeAll();
        String s = target.getText().trim();
        if (s.length() == 0) {
            return;
        }
        InetAddress ia = null;
        try {
            ia = InetAddress.getByName(s);
        }
        catch (UnknownHostException unknownHostException) {
            return;
        }
        FontAdjust.FontMenuItem mi = new FontAdjust.FontMenuItem("IP: " + ia.getHostAddress());
        mi.setActionCommand(ia.getHostAddress());
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                target.setText(e.getActionCommand());
            }
        });
        this.popupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Name: " + ia.getHostName());
        mi.setActionCommand(ia.getHostName());
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                target.setText(e.getActionCommand());
            }
        });
        this.popupMenu.add(mi);
        this.popupMenu.show(target, 180, 0);
    }

    @Override
    public String getTitle() {
        return "Load devices";
    }

    @Override
    public JPanel getPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        JPanel serialPanel = new JPanel();
        this.serialScanCheckBox = new FontAdjust.FontCheckBox("Scan serial ports");
        this.serialScanCheckBox.setActionCommand("Scan");
        this.serialScanCheckBox.addActionListener(this);
        this.serialScanCheckBox.setSelected(InterfaceThreads.loadDeviceConfig.isSearchSerialPorts());
        this.serialScanCheckBox.setToolTipText("Scan serial port for 9600 baud devices that answer on *IDN? command");
        this.serialScanCheckBox.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                PaneLoadDevices.this.actionPerformed(new ActionEvent(PaneLoadDevices.this.serialScanCheckBox, 0, "Scan"));
            }
        });
        serialPanel.add(this.serialScanCheckBox);
        serialPanel.add(Box.createHorizontalStrut(50));
        FontAdjust.FontLabel label = new FontAdjust.FontLabel("Exclude these ports from scan:");
        serialPanel.add(label);
        this.excludeSerialTextField = new FontAdjust.FontTextField(50);
        this.excludeSerialTextField.setText(InterfaceThreads.loadDeviceConfig.getExcludedSerialPorts());
        this.excludeSerialTextField.setActionCommand("Scan");
        this.excludeSerialTextField.addActionListener(this);
        this.excludeSerialTextField.setToolTipText("These ports are not scanned, they can be assigned in the table below");
        this.excludeSerialTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                PaneLoadDevices.this.actionPerformed(new ActionEvent(PaneLoadDevices.this.excludeSerialTextField, 0, "Scan"));
            }
        });
        serialPanel.add(this.excludeSerialTextField);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 10;
        c.fill = 1;
        this.mainPanel.add((Component)serialPanel, c);
        this.table = new FontAdjust.FontTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                Component comp = super.prepareRenderer(renderer, row, col);
                if (comp instanceof JLabel) {
                    JLabel label = (JLabel)comp;
                    if (col == 0) {
                        label.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
                        label.setHorizontalAlignment(2);
                    } else {
                        label.setHorizontalAlignment(0);
                    }
                }
                if (!comp.getBackground().equals(Support.colorScheme.selectedCellbackground)) {
                    comp.setBackground(row % 4 == 0 ? Support.colorScheme.tableGridAlternateBackground : Support.colorScheme.textBackground);
                }
                if (col == 2 && !InterfaceThreads.loadDeviceConfig.getIndex(row).isValid()) {
                    comp.setBackground(Support.colorScheme.errorBackground);
                }
                return comp;
            }
        };
        Support.AutoSelectCellEditor ce = new Support.AutoSelectCellEditor();
        ce.getComponent().addMouseListener(new MouseAdapter(){

            private void trig(MouseEvent e) {
                int row = PaneLoadDevices.this.table.getSelectedRow();
                int column = PaneLoadDevices.this.table.getSelectedColumn();
                LoadDeviceConfig.LoadDevice di = InterfaceThreads.loadDeviceConfig.getIndex(row);
                if (column == 2 && (di.getPortType() == ManageDeviceDefinitions.PortType.Serial || di.getPortType() == ManageDeviceDefinitions.PortType.SerialFixedBaud || di.getPortType() == ManageDeviceDefinitions.PortType.SerialNoBaud)) {
                    JTextField tf = ((Support.AutoSelectCellEditor)PaneLoadDevices.this.table.getCellEditor(row, column)).getEditorComponent();
                    PaneLoadDevices.this.showComPopup(tf);
                } else if (column == 2 && (di.getPortType() == ManageDeviceDefinitions.PortType.Socket || di.getPortType() == ManageDeviceDefinitions.PortType.LXI || di.getPortType() == ManageDeviceDefinitions.PortType.UDP)) {
                    ((Support.AutoSelectCellEditor)PaneLoadDevices.this.table.getCellEditor(row, column)).getEditorComponent();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.trig(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.trig(e);
                }
            }
        });
        this.table.setDefaultEditor(String.class, ce);
        Support.colorScheme.selectedCellbackground = this.table.getSelectionBackground();
        Support.colorScheme.selectedCellForeground = this.table.getSelectionForeground();
        this.table.setAutoResizeMode(0);
        this.table.setColumnModel(new Support.WidthTableColumnModel(new int[]{200, 150, 200, 80, 80, 60}));
        this.table.setModel(InterfaceThreads.loadDeviceConfig);
        this.table.setDefaultEditor(JComboBox.class, new PortTypeCellEditor());
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 1) {
                    JTable source = (JTable)e.getSource();
                    int row = source.rowAtPoint(e.getPoint());
                    int column = source.columnAtPoint(e.getPoint());
                    switch (column) {
                        case 5: {
                            LoadDeviceConfig.LoadDevice loadDevice = InterfaceThreads.loadDeviceConfig.getIndex(row);
                            if (!loadDevice.hasNotes()) {
                                return;
                            }
                            ManageDeviceDefinitions.DeviceDefinition def = Support.manageDeviceDefinitions.findDeviceDefintionFromName(loadDevice.getDevice());
                            PaneLoadDevices.this.showNotes(def);
                        }
                    }
                }
            }
        });
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 10;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 1;
        this.mainPanel.add((Component)new JScrollPane(this.table), c);
        int n = 0;
        label = new FontAdjust.FontLabel("Filter: ");
        c = new GridBagConstraints();
        c.gridx = n++;
        c.gridy = 2;
        c.weightx = 0.0;
        c.insets = new Insets(2, 2, 2, 2);
        this.mainPanel.add((Component)label, c);
        this.filterTextField = new FontAdjust.FontTextField(10);
        this.filterTextField.setActionCommand("Filter");
        this.filterTextField.addActionListener(this);
        this.filterTextField.setToolTipText("Filter the list of devices");
        this.filterTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                PaneLoadDevices.this.actionPerformed(new ActionEvent(PaneLoadDevices.this.filterTextField, 0, "Filter"));
            }
        });
        this.newPopupMenu = new JPopupMenu();
        this.previewMenuItem = new FontAdjust.FontMenuItem("Preview mode, setup and notes popups");
        this.previewMenuItem.addActionListener(this);
        this.previewMenuItem.setActionCommand("Setup");
        this.newPopupMenu.add(this.previewMenuItem);
        FontAdjust.FontMenuItem mi = new FontAdjust.FontMenuItem("Create new SCPI device definition");
        mi.addActionListener(this);
        mi.setActionCommand("New");
        this.newPopupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Open definition documentation");
        mi.addActionListener(this);
        mi.setActionCommand("Doc");
        this.newPopupMenu.add(mi);
        c = new GridBagConstraints();
        c.gridx = n++;
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 0.3;
        c.insets = new Insets(2, 2, 2, 2);
        this.filterTextField.setComponentPopupMenu(this.newPopupMenu);
        this.mainPanel.add((Component)this.filterTextField, c);
        this.deviceSelectComboBox = new FontAdjust.FontComboBox<String>();
        this.deviceSelectComboBox.setMaximumRowCount(20);
        this.deviceSelectComboBox.setToolTipText("All known devices");
        this.deviceSelectComboBox.setActionCommand("ChangedDevice");
        this.deviceSelectComboBox.addActionListener(this);
        c = new GridBagConstraints();
        c.gridx = n++;
        c.gridy = 2;
        c.weightx = 0.3;
        c.fill = 2;
        c.insets = new Insets(2, 2, 2, 2);
        this.deviceSelectComboBox.setComponentPopupMenu(this.newPopupMenu);
        this.mainPanel.add(this.deviceSelectComboBox, c);
        FontAdjust.FontButton addButton = new FontAdjust.FontButton("Add");
        addButton.addActionListener(this);
        addButton.setActionCommand("Add");
        addButton.setToolTipText("Add selected device to table");
        c = new GridBagConstraints();
        c.gridx = n++;
        c.gridy = 2;
        c.weightx = 0.1;
        c.insets = new Insets(2, 2, 2, 2);
        this.mainPanel.add((Component)addButton, c);
        FontAdjust.FontButton removeButton = new FontAdjust.FontButton("Remove");
        removeButton.addActionListener(this);
        removeButton.setActionCommand("Remove");
        removeButton.setToolTipText("Remove one or more selected lines from the table");
        c = new GridBagConstraints();
        c.gridx = n++;
        c.gridy = 2;
        c.weightx = 0.1;
        c.insets = new Insets(2, 2, 2, 2);
        this.mainPanel.add((Component)removeButton, c);
        FontAdjust.FontButton gpibButton = new FontAdjust.FontButton("GPIB");
        gpibButton.addActionListener(this);
        gpibButton.setActionCommand("GPIB");
        gpibButton.setToolTipText("Configure GPIB interfaces");
        c = new GridBagConstraints();
        c.gridx = n++;
        c.gridy = 2;
        c.weightx = 0.1;
        c.insets = new Insets(2, 2, 2, 2);
        this.mainPanel.add((Component)gpibButton, c);
        FontAdjust.FontButton sortDeviceButton = new FontAdjust.FontButton("Sort device");
        sortDeviceButton.addActionListener(this);
        sortDeviceButton.setActionCommand("SortDevice");
        sortDeviceButton.setToolTipText("Sort table on device name");
        c = new GridBagConstraints();
        c.gridx = n++;
        c.gridy = 2;
        c.weightx = 0.1;
        c.insets = new Insets(2, 2, 2, 2);
        this.mainPanel.add((Component)sortDeviceButton, c);
        FontAdjust.FontButton sortAddressButton = new FontAdjust.FontButton("Sort address");
        sortAddressButton.addActionListener(this);
        sortAddressButton.setActionCommand("SortAddres");
        sortAddressButton.setToolTipText("Sort table on device address");
        c = new GridBagConstraints();
        c.gridx = n++;
        c.gridy = 2;
        c.weightx = 0.1;
        c.insets = new Insets(2, 2, 2, 2);
        this.mainPanel.add((Component)sortAddressButton, c);
        this.reconnectButton = new FontAdjust.FontButton("Reconnect");
        this.reconnectButton.addActionListener(this);
        this.reconnectButton.setActionCommand("Reconnect");
        this.reconnectButton.setToolTipText("Disconnect all devices and reconnect using the current table");
        c = new GridBagConstraints();
        c.gridx = n++;
        c.gridy = 2;
        c.weightx = 0.1;
        c.insets = new Insets(2, 2, 2, 2);
        this.mainPanel.add((Component)this.reconnectButton, c);
        this.popupMenu = new JPopupMenu();
        this.mainPanel.add(this.popupMenu);
        return this.mainPanel;
    }

    private void inititalDeviceInit() {
        if (this.starting && !InterfaceThreads.inInitialization()) {
            this.fillComboBox("");
            this.starting = false;
        }
    }

    @Override
    public void changeDevicesOrTable(Support.UpdateType type) {
        if (type.equals((Object)Support.UpdateType.StartInit)) {
            return;
        }
        this.inititalDeviceInit();
    }

    private void timerUpdate() {
        this.reconnectButton.setEnabled(!InterfaceThreads.isLogging());
        this.inititalDeviceInit();
    }

    public void showHelpPopup() {
        int i = JOptionPane.showConfirmDialog(this.mainPanel, "<html>Use combobox and Add button at the bottom to add equipment.<br>Then fill the address field with a IP address or serial port name.<br><br>To automatic add LXI compliant network connected devices:<ul><li>Turn them on<li>Wait until they are ready<li>Press OK button<li>Wait a few seconds</ul>", "Add devices", 2);
        if (i == 0) {
            VXI11Discovery dis = new VXI11Discovery();
            for (VXI11Discovery.Device d : dis.getDevices()) {
                ManageDeviceDefinitions.DeviceDefinition def = d.getDeviceDefinition();
                if (def == null) continue;
                LoadDeviceConfig.LoadDevice ld = InterfaceThreads.loadDeviceConfig.addDevice(def.getDeviceName());
                ld.setAddress(d.getSerialAddress());
            }
        }
    }

    @Override
    public void select() {
        this.timer.start();
        this.timerUpdate();
        if (InterfaceThreads.loadDeviceConfig.getRowCount() == 0) {
            this.showHelpPopup();
        }
    }

    @Override
    public void deselect() {
        InterfaceThreads.loadDeviceConfig.saveDefault();
        this.timer.stop();
    }

    public static class PortTypeCellEditor
    extends DefaultCellEditor {
        public PortTypeCellEditor() {
            super(new FontAdjust.FontComboBox());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component editor = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (editor instanceof JComboBox) {
                JComboBox cb = (JComboBox)editor;
                cb.removeAllItems();
                cb.setMaximumRowCount(20);
                for (String s : InterfaceThreads.loadDeviceConfig.getIndex(row).getPortList()) {
                    cb.addItem(s);
                }
                cb.setSelectedItem(value);
            }
            return editor;
        }
    }
}

