/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.database.DataBase;
import dk.hkj.main.ChartAnnotations;
import dk.hkj.main.ChartSaveResolutionPanel;
import dk.hkj.main.ChartScales;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.Main;
import dk.hkj.main.PopupValuesHistogram;
import dk.hkj.main.Support;
import dk.hkj.util.MySwingUtil;
import dk.hkj.util.StringUtil;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYLineAnnotation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.statistics.HistogramType;

public class PaneHistogram
implements Main.PaneInterface {
    public static final String sampleTip = "<html>Formats supported:<br>Empty: All data<br>seconds from start<br>h:m:s hour minutes seconds<br>postfix with h/m for hours/minutes<br>#sampleNumber<br>Prefix with - means from end of data<br>Prefix with w for width/lenght of data, only in last field";
    private final int MAX_CURVES = 3;
    private ChartPanel[] chartPanel = new ChartPanel[3];
    private JPanel checkboxPanel;
    private JCheckBox percentCheckBox = null;
    private JTextField binsTextField = null;
    private List<JCheckBox> checkBoxList = new ArrayList<JCheckBox>();
    public Support.StringList checkedColumns = new Support.StringList();
    private List<CurveIndex> curveIndexs = new ArrayList<CurveIndex>();
    private JPanel mainPanel = null;
    private JPanel sidePanel = null;
    private JTextField firstSampleTextField = null;
    private JTextField lastSampleTextField = null;
    private int dataSamples = -1;
    private DataBase.DataBaseRange dataBaseRange = Support.dataBase.getRange();
    private int dataAtLastUpdate = 0;
    private int missiedLastUpdates = 0;
    private int histogramBins = 50;
    private boolean usePercent = false;
    private NumberFormat nf = null;
    private int domainColumnIndex = -1;
    private XYLineAnnotation cursorLine = null;
    private int cursorChart = -1;
    public ChartAnnotations annotations = new ChartAnnotations();
    private Timer timer;
    ActionListener checkBoxListener = new ActionListener(){

        private void removeCurveIndex(String name) {
            int i = 0;
            while (i < PaneHistogram.this.curveIndexs.size()) {
                if (((CurveIndex)PaneHistogram.this.curveIndexs.get(i)).name.equals(name)) {
                    PaneHistogram.this.curveIndexs.remove(i);
                    PaneHistogram.this.checkedColumns.remove(name);
                    return;
                }
                ++i;
            }
        }

        private void addCurveIndex(String name) throws Exception {
            if (name == null) {
                return;
            }
            int i = 0;
            while (i < PaneHistogram.this.curveIndexs.size()) {
                if (((CurveIndex)PaneHistogram.this.curveIndexs.get(i)).name.equals(name)) {
                    return;
                }
                ++i;
            }
            PaneHistogram.this.curveIndexs.add(new CurveIndex(name));
            PaneHistogram.this.checkedColumns.add(name);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            PaneHistogram.this.hideCursor();
            for (JCheckBox cb : PaneHistogram.this.checkBoxList) {
                if (cb.isSelected()) continue;
                this.removeCurveIndex(cb.getActionCommand());
            }
            for (JCheckBox cb : PaneHistogram.this.checkBoxList) {
                if (!cb.isSelected()) continue;
                try {
                    this.addCurveIndex(cb.getActionCommand());
                }
                catch (Exception exception) {
                    cb.setEnabled(false);
                }
            }
            int i = 0;
            while (i < PaneHistogram.this.curveIndexs.size()) {
                ((CurveIndex)PaneHistogram.this.curveIndexs.get(i)).chartIndex = i;
                ++i;
            }
            for (JCheckBox cb : PaneHistogram.this.checkBoxList) {
                if (!cb.isSelected() && PaneHistogram.this.curveIndexs.size() >= 3) {
                    cb.setEnabled(false);
                    continue;
                }
                cb.setEnabled(true);
            }
            PaneHistogram.this.setupSizes();
            PaneHistogram.this.updateData(true);
        }
    };
    InputChanged inputChanged = new InputChanged();
    InputChangedFocus inputChangedFocus = new InputChangedFocus();

    @Override
    public int getHotKey() {
        return 72;
    }

    public void setRange(String fs, String ls) {
        this.firstSampleTextField.setText(fs);
        this.lastSampleTextField.setText(ls);
        this.parseInput();
    }

    public void selectCurves(List<String> curves) {
        for (JCheckBox cb : this.checkBoxList) {
            boolean found = false;
            for (String name : curves) {
                if (!cb.getText().equals(name)) continue;
                found = true;
                break;
            }
            cb.setSelected(found);
        }
        this.checkBoxListener.actionPerformed(null);
    }

    public void setBins(int bins) {
        this.histogramBins = bins;
        if (bins < 5) {
            bins = 5;
        }
        if (bins > 1000) {
            bins = 1000;
        }
        this.binsTextField.setText(Integer.toString(bins));
        this.inputChanged.actionPerformed(new ActionEvent(this.firstSampleTextField, 0, ""));
    }

    public void setPercent(boolean usePercent) {
        this.usePercent = usePercent;
        this.percentCheckBox.setSelected(usePercent);
        this.inputChanged.actionPerformed(new ActionEvent(this.firstSampleTextField, 0, ""));
    }

    public void setSamples(String first, String last) {
        this.firstSampleTextField.setText(first);
        this.lastSampleTextField.setText(last);
        this.inputChanged.actionPerformed(new ActionEvent(this.firstSampleTextField, 0, ""));
    }

    JFreeChart getEmptyChart() {
        JFreeChart chart = ChartFactory.createHistogram("", "", this.usePercent ? Support.chartScales.getPercentName() : Support.chartScales.getCountName(), null, PlotOrientation.VERTICAL, false, true, false);
        FontAdjust.fontSizes.chartTheme.apply(chart);
        if (Support.chartColor != null) {
            chart.getPlot().setBackgroundPaint(Support.chartColor);
        }
        if (Support.chartBorderColor != null) {
            chart.setBackgroundPaint(Support.chartBorderColor);
        }
        if (Support.chartGridColor != null) {
            chart.getXYPlot().setDomainGridlinePaint(Support.chartGridColor);
            chart.getXYPlot().setRangeGridlinePaint(Support.chartGridColor);
        }
        if (Support.chartFontColor != null) {
            chart.getLegend().setBackgroundPaint(Support.chartBorderColor);
        }
        return chart;
    }

    public PaneHistogram() {
        this.nf = (DecimalFormat)NumberFormat.getNumberInstance(Locale.ENGLISH);
        this.nf.setGroupingUsed(false);
        this.nf.setMaximumFractionDigits(0);
    }

    @Override
    public String getTitle() {
        return "Histogram";
    }

    private void setupSizes() {
        int n = this.curveIndexs.size();
        if (n == 0) {
            n = 1;
        }
        int w = this.chartPanel[0].getWidth();
        int h = this.chartPanel[0].getHeight();
        int i = 0;
        while (i < 3) {
            this.chartPanel[i].setMaximumDrawHeight(h);
            this.chartPanel[i].setMaximumDrawWidth(w);
            this.chartPanel[i].setMinimumDrawHeight(h);
            this.chartPanel[i].setMinimumDrawWidth(w);
            ++i;
        }
        this.mainPanel.validate();
        this.dataSamples = -1;
    }

    @Override
    public JPanel getPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                PaneHistogram.this.setupSizes();
            }
        });
        this.mainPanel.setLayout(new BorderLayout());
        JPanel chart3Panel = new JPanel();
        chart3Panel.setLayout(new BoxLayout(chart3Panel, 3));
        int i = 0;
        while (i < 3) {
            this.chartPanel[i] = new ChartPanel(this.getEmptyChart(), 10, 10, 10, 10, 10, 10, true, false, false, false, false, false);
            this.chartPanel[i].setDomainZoomable(false);
            this.chartPanel[i].setRangeZoomable(false);
            this.chartPanel[i].setMouseZoomable(false);
            if (Support.chartBorderColor != null) {
                this.chartPanel[i].setBackground(Support.chartBorderColor);
            }
            this.chartPanel[i].addChartMouseListener(new MyChartMouseListener(i));
            chart3Panel.add(this.chartPanel[i]);
            ++i;
        }
        this.chartPanel[0].addComponentListener(new MySwingUtil.ResizeListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                PaneHistogram.this.setupSizes();
            }
        });
        this.sidePanel = new FontAdjust.FontPanel();
        ((FontAdjust.FontPanel)this.sidePanel).setScaleWidth(150);
        this.sidePanel.setLayout(new GridBagLayout());
        JSplitPane splitPane = new JSplitPane(1, chart3Panel, this.sidePanel);
        chart3Panel.setMinimumSize(new Dimension(700, 400));
        this.sidePanel.setMinimumSize(new Dimension(150, 400));
        splitPane.setContinuousLayout(true);
        splitPane.setResizeWeight(1.0);
        this.mainPanel.add(splitPane);
        this.checkboxPanel = new JPanel();
        this.checkboxPanel.setLayout(new BoxLayout(this.checkboxPanel, 3));
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.fill = 1;
        c.anchor = 11;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.sidePanel.add((Component)new JScrollPane(this.checkboxPanel), c);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new GridBagLayout());
        this.mainPanel.add((Component)bottomPanel, "South");
        FontAdjust.FontLabel label = new FontAdjust.FontLabel("First sample to display:");
        label.setToolTipText(sampleTip);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.weightx = 1.0;
        c.anchor = 13;
        c.insets = new Insets(5, 5, 5, 5);
        bottomPanel.add((Component)label, c);
        this.firstSampleTextField = new FontAdjust.FontTextField(8);
        this.firstSampleTextField.setToolTipText(sampleTip);
        this.firstSampleTextField.addActionListener(this.inputChanged);
        this.firstSampleTextField.addFocusListener(this.inputChangedFocus);
        this.firstSampleTextField.setMinimumSize(new Dimension(30, 20));
        c = new GridBagConstraints();
        c.gridx = 1;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(5, 5, 5, 5);
        bottomPanel.add((Component)this.firstSampleTextField, c);
        label = new FontAdjust.FontLabel("Last sample to display:");
        label.setToolTipText(sampleTip);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.weightx = 1.0;
        c.anchor = 13;
        c.insets = new Insets(5, 5, 5, 5);
        bottomPanel.add((Component)label, c);
        this.lastSampleTextField = new FontAdjust.FontTextField(8);
        this.lastSampleTextField.setToolTipText(sampleTip);
        this.lastSampleTextField.addActionListener(this.inputChanged);
        this.lastSampleTextField.addFocusListener(this.inputChangedFocus);
        this.lastSampleTextField.setMinimumSize(new Dimension(30, 20));
        c = new GridBagConstraints();
        c.gridx = 3;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(5, 5, 5, 5);
        bottomPanel.add((Component)this.lastSampleTextField, c);
        this.percentCheckBox = new FontAdjust.FontCheckBox("Show in percent");
        this.percentCheckBox.addActionListener(this.inputChanged);
        c = new GridBagConstraints();
        c.gridx = 4;
        c.weightx = 1.0;
        c.anchor = 10;
        c.insets = new Insets(5, 5, 5, 5);
        bottomPanel.add((Component)this.percentCheckBox, c);
        label = new FontAdjust.FontLabel("Bins:");
        c = new GridBagConstraints();
        c.gridx = 5;
        c.weightx = 1.0;
        c.anchor = 13;
        c.insets = new Insets(5, 5, 5, 5);
        bottomPanel.add((Component)label, c);
        this.binsTextField = new FontAdjust.FontTextField(4);
        this.binsTextField.setText("" + this.histogramBins);
        this.binsTextField.addActionListener(this.inputChanged);
        this.binsTextField.addFocusListener(this.inputChangedFocus);
        this.binsTextField.setMinimumSize(new Dimension(30, 20));
        c = new GridBagConstraints();
        c.gridx = 6;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(5, 5, 5, 5);
        bottomPanel.add((Component)this.binsTextField, c);
        FontAdjust.FontButton saveButton = new FontAdjust.FontButton("Save");
        saveButton.setToolTipText("Save chart in PNG format with any resoltuon");
        c = new GridBagConstraints();
        c.gridx = 7;
        c.weightx = 1.0;
        c.anchor = 13;
        c.insets = new Insets(5, 5, 5, 5);
        bottomPanel.add((Component)saveButton, c);
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaneHistogram.this.saveChart();
            }
        });
        this.timer = new Timer(50, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ((double)Support.dataBase.rows() > (double)PaneHistogram.this.dataAtLastUpdate * 1.1 || PaneHistogram.this.missiedLastUpdates > 10) {
                    PaneHistogram.this.dataAtLastUpdate = Support.dataBase.rows();
                    PaneHistogram.this.missiedLastUpdates = 0;
                    PaneHistogram.this.timerUpdate();
                } else {
                    PaneHistogram paneHistogram = PaneHistogram.this;
                    paneHistogram.missiedLastUpdates = paneHistogram.missiedLastUpdates + 1;
                }
            }
        });
        return this.mainPanel;
    }

    private void addCheckboxes() {
        Support.StringList newCheckedColumns = new Support.StringList();
        this.checkBoxList.clear();
        this.curveIndexs.clear();
        this.checkboxPanel.removeAll();
        int[] nArray = Support.dataBase.header().getDataColumns();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            String columnName = Support.dataBase.header().getColumnName(i);
            int j = Support.dataBase.format().get((int)i).format.digitalValues();
            if (columnName != null && columnName.length() > 0 && j == 0) {
                FontAdjust.FontCheckBox box = new FontAdjust.FontCheckBox(columnName);
                if (this.checkedColumns.contains(columnName)) {
                    box.setSelected(true);
                    newCheckedColumns.add(columnName);
                }
                this.checkBoxList.add(box);
                this.checkboxPanel.add(box);
                box.addActionListener(this.checkBoxListener);
                box.setActionCommand(columnName);
            }
            ++n2;
        }
        this.checkedColumns = newCheckedColumns;
        if (this.checkedColumns.size() == 0 && this.checkBoxList.size() > 0) {
            this.checkBoxList.get(0).setSelected(true);
            this.checkedColumns.add(this.checkBoxList.get(0).getText());
        }
        this.checkBoxListener.actionPerformed(null);
    }

    private void updateData(boolean force) {
        if (!force && this.dataSamples == Support.dataBase.rows()) {
            return;
        }
        int i = 0;
        while (i < this.curveIndexs.size()) {
            this.curveIndexs.get(i).chartIndex = i;
            ++i;
        }
        i = 0;
        while (i < 3) {
            this.chartPanel[i].setVisible(i < this.curveIndexs.size() || i == 0);
            ++i;
        }
        this.dataSamples = Support.dataBase.rows();
        for (CurveIndex ci : this.curveIndexs) {
            ci.updateDataset();
        }
        if (this.curveIndexs.size() == 0) {
            this.chartPanel[0].setChart(this.getEmptyChart());
        }
    }

    private void timerUpdate() {
        this.updateData(false);
    }

    @Override
    public void changeDevicesOrTable(Support.UpdateType type) {
        if (type.equals((Object)Support.UpdateType.StartInit)) {
            return;
        }
        if (type.equals((Object)Support.UpdateType.Devices) || type.equals((Object)Support.UpdateType.ColumnsSource)) {
            this.annotations.clear();
        }
        this.domainColumnIndex = Support.dataBase.header().getDomainColumn();
        this.addCheckboxes();
        this.updateData(true);
        this.hideCursor();
    }

    @Override
    public void select() {
        this.parseInput();
        this.updateData(true);
        this.timer.start();
    }

    @Override
    public void deselect() {
        this.timer.stop();
        this.hideCursor();
    }

    private void removeCursor() {
        if (this.cursorChart < 0 || this.cursorLine == null) {
            return;
        }
        this.chartPanel[this.cursorChart].getChart().getXYPlot().removeAnnotation(this.cursorLine);
        this.cursorLine = null;
    }

    private void hideCursor() {
        if (PopupValuesHistogram.popupValues != null) {
            PopupValuesHistogram.popupValues.setVisible(false);
            PopupValuesHistogram.popupValues = null;
        }
        this.removeCursor();
        this.cursorChart = -1;
    }

    private void setCursor(int channel, double x) {
        CurveIndex ci;
        int i;
        this.removeCursor();
        XYPlot plot = (XYPlot)this.chartPanel[channel].getChart().getPlot();
        double lower = plot.getRangeAxis().getLowerBound();
        double upper = plot.getRangeAxis().getUpperBound();
        if (PopupValuesHistogram.popupValues != null && (i = (ci = this.curveIndexs.get(channel)).findEntry(x)) >= 0) {
            PopupValuesHistogram.HistogramValues values = new PopupValuesHistogram.HistogramValues();
            values.value = x;
            values.center = (Double)ci.dataset.getX(0, i);
            values.start = (Double)ci.dataset.getStartX(0, i);
            values.end = (Double)ci.dataset.getEndX(0, i);
            double v = (Double)ci.dataset.getY(0, i);
            if (this.usePercent) {
                v = Math.rint(v * (double)ci.getSampleCount());
            }
            values.count = (int)v;
            values.totalCount = ci.getSampleCount();
            PopupValuesHistogram.popupValues.updataValues(ci.dbIndex, values);
        }
        this.cursorLine = new XYLineAnnotation(x, lower, x, upper, new BasicStroke(2.0f), Color.CYAN);
        this.cursorChart = channel;
        plot.addAnnotation(this.cursorLine);
        this.chartPanel[channel].getChart().setNotify(true);
    }

    private void handleChartMouseEvent(int channel, boolean click, ChartMouseEvent me) {
        this.removeCursor();
        if (!click && this.cursorChart < 0) {
            return;
        }
        if (click && this.cursorChart >= 0) {
            this.hideCursor();
            return;
        }
        if (PopupValuesHistogram.popupValues == null) {
            PopupValuesHistogram.popupValues = new PopupValuesHistogram((Component)Main.main.frame);
            PopupValuesHistogram.popupValues.setVisible(true);
        }
        Point2D p = this.chartPanel[channel].translateScreenToJava2D(new Point(0, 0));
        double x = p.getX() + me.getTrigger().getPoint().getX();
        double y = p.getY() + me.getTrigger().getPoint().getY();
        p = new Point((int)x, (int)y);
        Rectangle2D plotArea = this.chartPanel[channel].getScreenDataArea();
        XYPlot plot = (XYPlot)this.chartPanel[channel].getChart().getPlot();
        this.setCursor(channel, plot.getDomainAxis().java2DToValue(p.getX(), plotArea, plot.getDomainAxisEdge()));
    }

    private void parseInput() {
        this.usePercent = this.percentCheckBox.isSelected();
        try {
            this.binsTextField.setBackground(Support.colorScheme.textBackground);
            this.histogramBins = StringUtil.parseInt(this.binsTextField.getText().trim());
            if (this.histogramBins < 5) {
                this.histogramBins = 5;
                this.binsTextField.setBackground(Support.colorScheme.errorBackground);
            } else if (this.histogramBins > 1000) {
                this.histogramBins = 1000;
                this.binsTextField.setBackground(Support.colorScheme.errorBackground);
            }
        }
        catch (Exception exception) {
            this.binsTextField.setBackground(Support.colorScheme.errorBackground);
        }
        String fs = this.firstSampleTextField.getText().trim();
        String ls = this.lastSampleTextField.getText().trim();
        this.dataBaseRange = Support.dataBase.getRange(this.domainColumnIndex, fs, ls);
        this.updateData(true);
    }

    private BufferedImage generateImage(int w, int h, String fname) {
        this.hideCursor();
        BufferedImage image = new BufferedImage(w, h, 1);
        Graphics g = image.getGraphics();
        g.setColor(Support.colorScheme.textBackground);
        g.fillRect(0, 0, w, h);
        int n = this.curveIndexs.size();
        int i = 0;
        while (i < n) {
            BufferedImage subImage = new BufferedImage(w, h / n, 1);
            JFreeChart chart = this.curveIndexs.get(i).generateChart();
            if (n == 1) {
                int j = fname.lastIndexOf(46);
                if (j > 0) {
                    fname = fname.substring(0, j);
                }
                if (fname.length() > 0) {
                    chart.setTitle(fname);
                } else {
                    chart.setTitle("Test controller");
                }
                if (Support.chartFontColor != null) {
                    chart.getTitle().setPaint(Support.chartFontColor);
                }
                if (Support.chartHeaderColor != null) {
                    chart.getTitle().setPaint(Support.chartHeaderColor);
                }
            }
            chart.draw(subImage.createGraphics(), new Rectangle(w, h / n));
            if (n == 1) {
                return subImage;
            }
            g.drawImage(subImage, 0, h * i / n, w, h / n, null);
            ++i;
        }
        return image;
    }

    private void copyChart(int w, int h) {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new TransferableImage(this.generateImage(w, h, "")), null);
        }
        catch (Exception exception) {}
    }

    public void saveChart(String fname, int w, int h) {
        this.updateData(true);
        try {
            File f = Support.fileWithOptinalDefaults(fname, Support.getDataPath(), ".png");
            ImageIO.write((RenderedImage)this.generateImage(w, h, Support.chartTitle != null ? Support.chartTitle : f.getName()), "png", f);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public void saveChart() {
        if (this.curveIndexs.size() == 0) {
            return;
        }
        ChartSaveResolutionPanel savePanel = new ChartSaveResolutionPanel();
        FontAdjust.FontFileChooser fc = new FontAdjust.FontFileChooser();
        try {
            fc.setCurrentDirectory(new File(Support.getDataPath()));
        }
        catch (Exception exception) {
            System.out.println("Failed to set director: " + Support.getDataPath());
        }
        fc.setFileFilter(new FileNameExtensionFilter("PNG", "png"));
        fc.setAcceptAllFileFilterUsed(false);
        fc.setAccessory(savePanel.getPanel());
        while (true) {
            int option = 0;
            if (fc.showDialog(null, "Save chart") != 0) break;
            File f = Support.fileWithOptinalDefaults(fc.getSelectedFile().getAbsolutePath(), null, ".png");
            if (!savePanel.isValid()) {
                option = 1;
            }
            if (f.exists() && option == 0 && (option = JOptionPane.showConfirmDialog(null, "File exists, overwrite?", "File exists", 1)) == 2) {
                return;
            }
            if (option != 0) continue;
            Dimension dim = savePanel.getSize();
            try {
                ImageIO.write((RenderedImage)this.generateImage(dim.width, dim.height, Support.chartTitle != null ? Support.chartTitle : f.getName()), "png", f);
                Support.setDataPath(fc.getCurrentDirectory().getPath());
                return;
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    public List<String> generateScript() {
        ArrayList<String> list = new ArrayList<String>();
        if (Support.dataBase.header().columns() == 0) {
            list.add(";; No table data present to select curves");
        } else {
            StringBuilder sb = new StringBuilder();
            for (String s : this.checkedColumns) {
                if (s.length() > 0) {
                    sb.append(" ");
                }
                sb.append(s);
            }
            sb.insert(0, "#HistogramCurves ");
            list.add(sb.toString());
        }
        list.add(0, "#HistogramOptions " + (this.usePercent ? "%" : "Count") + " " + this.histogramBins);
        list.add("#HistogramSamples \"" + Support.conditionalQuote(this.firstSampleTextField.getText().trim()) + " " + Support.conditionalQuote(this.lastSampleTextField.getText().trim()));
        return list;
    }

    private class CurveIndex {
        private int chartIndex = -1;
        private int dbIndex;
        private String name;
        private HistogramDataset dataset = null;
        private int sampleCount = 0;

        private CurveIndex(String name) throws Exception {
            this.name = name;
            this.dbIndex = Support.dataBase.header().getIndex(name);
            if (this.dbIndex < 0) {
                throw new IndexOutOfRangeException();
            }
        }

        public int findEntry(double value) {
            if (this.dataset == null) {
                return -1;
            }
            int found = -1;
            int i = 0;
            while (i < this.dataset.getItemCount(0)) {
                if (value > (Double)this.dataset.getStartX(0, i) && value < (Double)this.dataset.getEndX(0, i)) {
                    found = i;
                    break;
                }
                ++i;
            }
            return found;
        }

        public int getSampleCount() {
            return this.sampleCount;
        }

        public JFreeChart generateChart() {
            double[] data = Support.dataBase.getColumnRange(PaneHistogram.this.dataBaseRange, this.dbIndex);
            this.sampleCount = data.length;
            if (data.length > 0) {
                ChartScales.ChartScale cs = Support.chartScales.getScale(this.name);
                NumberAxis axisy = new NumberAxis(cs.getAxisName());
                cs.setAxisScale(axisy, data);
                this.dataset = new HistogramDataset();
                this.dataset.addSeries((Comparable)((Object)this.name), data, PaneHistogram.this.histogramBins, axisy.getLowerBound(), axisy.getUpperBound());
                if (PaneHistogram.this.usePercent) {
                    this.dataset.setType(HistogramType.RELATIVE_FREQUENCY);
                }
                JFreeChart chart = ChartFactory.createHistogram("", "", PaneHistogram.this.usePercent ? Support.chartScales.getPercentName() : Support.chartScales.getCountName(), this.dataset, PlotOrientation.VERTICAL, false, true, false);
                XYBarRenderer renderer = (XYBarRenderer)chart.getXYPlot().getRenderer();
                chart.getXYPlot().setDomainAxis(axisy);
                ((NumberAxis)chart.getXYPlot().getRangeAxis()).setNumberFormatOverride(new ScaleFormatter());
                FontAdjust.fontSizes.chartTheme.apply(chart);
                renderer.setMargin(PaneHistogram.this.histogramBins > 100 ? 0.0 : 0.1);
                if (PaneHistogram.this.histogramBins > 100) {
                    renderer.setBarPainter(new StandardXYBarPainter());
                    renderer.setShadowVisible(false);
                }
                renderer.setSeriesPaint(0, Support.chartLineColor[0]);
                if (Support.chartColor != null) {
                    chart.getPlot().setBackgroundPaint(Support.chartColor);
                }
                if (Support.chartBorderColor != null) {
                    chart.setBackgroundPaint(Support.chartBorderColor);
                }
                if (Support.chartGridColor != null) {
                    chart.getXYPlot().setDomainGridlinePaint(Support.chartGridColor);
                    chart.getXYPlot().setRangeGridlinePaint(Support.chartGridColor);
                }
                if (Support.chartFontColor != null) {
                    renderer.setDefaultLegendTextPaint(Support.chartFontColor);
                    if (Support.chartFontColor != null) {
                        ValueAxis a = chart.getXYPlot().getDomainAxis();
                        a.setTickLabelPaint(Support.chartFontColor);
                        a.setTickMarkPaint(Support.chartFontColor);
                        a.setLabelPaint(Support.chartFontColor);
                        a.setAxisLinePaint(Support.chartFontColor);
                        a = chart.getXYPlot().getRangeAxis();
                        a.setTickLabelPaint(Support.chartFontColor);
                        a.setTickMarkPaint(Support.chartFontColor);
                        a.setLabelPaint(Support.chartFontColor);
                        a.setAxisLinePaint(Support.chartFontColor);
                    }
                }
                HashMap<String, Integer> chartMap = new HashMap<String, Integer>();
                chartMap.put(this.name, 0);
                PaneHistogram.this.annotations.addToChart(chartMap, "", chart.getXYPlot());
                return chart;
            }
            return PaneHistogram.this.getEmptyChart();
        }

        private void updateDataset() {
            PaneHistogram.this.chartPanel[this.chartIndex].setChart(this.generateChart());
            PaneHistogram.this.chartPanel[this.chartIndex].setDomainZoomable(false);
            PaneHistogram.this.chartPanel[this.chartIndex].setRangeZoomable(false);
            PaneHistogram.this.chartPanel[this.chartIndex].setMouseZoomable(false);
        }
    }

    class IndexOutOfRangeException
    extends Exception {
        IndexOutOfRangeException() {
        }
    }

    private class InputChanged
    implements ActionListener {
        private InputChanged() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PaneHistogram.this.parseInput();
        }
    }

    private class InputChangedFocus
    implements FocusListener {
        private InputChangedFocus() {
        }

        @Override
        public void focusGained(FocusEvent arg0) {
        }

        @Override
        public void focusLost(FocusEvent arg0) {
            PaneHistogram.this.parseInput();
        }
    }

    class MaskNotFoundException
    extends Exception {
        MaskNotFoundException() {
        }
    }

    private class MyChartMouseListener
    implements ChartMouseListener {
        private int channel;

        MyChartMouseListener(int channel) {
            this.channel = channel;
        }

        @Override
        public void chartMouseClicked(ChartMouseEvent me) {
            PaneHistogram.this.handleChartMouseEvent(this.channel, true, me);
        }

        @Override
        public void chartMouseMoved(ChartMouseEvent me) {
            PaneHistogram.this.handleChartMouseEvent(this.channel, false, me);
        }
    }

    private class ScaleFormatter
    extends NumberFormat {
        private ScaleFormatter() {
        }

        @Override
        public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
            int n = PaneHistogram.this.histogramBins / Math.max(1, PaneHistogram.this.curveIndexs.size());
            if (!PaneHistogram.this.usePercent) {
                PaneHistogram.this.nf.setMinimumFractionDigits(0);
                PaneHistogram.this.nf.setMaximumFractionDigits(0);
            } else if (n < 12) {
                PaneHistogram.this.nf.setMinimumFractionDigits(0);
                PaneHistogram.this.nf.setMaximumFractionDigits(0);
                number *= 100.0;
            } else if (n < 120) {
                PaneHistogram.this.nf.setMinimumFractionDigits(1);
                PaneHistogram.this.nf.setMaximumFractionDigits(1);
                number *= 100.0;
            } else {
                PaneHistogram.this.nf.setMinimumFractionDigits(2);
                PaneHistogram.this.nf.setMaximumFractionDigits(2);
                number *= 100.0;
            }
            return PaneHistogram.this.nf.format(number, toAppendTo, pos);
        }

        @Override
        public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
            toAppendTo.append(number);
            return toAppendTo;
        }

        @Override
        public Number parse(String source, ParsePosition parsePosition) {
            return PaneHistogram.this.nf.parse(source, parsePosition);
        }
    }

    private class TransferableImage
    implements Transferable {
        Image i;

        public TransferableImage(Image i) {
            this.i = i;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(DataFlavor.imageFlavor) && this.i != null) {
                return this.i;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] flavors = new DataFlavor[]{DataFlavor.imageFlavor};
            return flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            DataFlavor[] flavors = this.getTransferDataFlavors();
            int i = 0;
            while (i < flavors.length) {
                if (flavor.equals(flavors[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

