/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.database.DataBase;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.Main;
import dk.hkj.main.Mathematics;
import dk.hkj.main.StatValues;
import dk.hkj.main.Support;
import dk.hkj.main.ValueFormat;
import dk.hkj.util.MySwingUtil;
import dk.hkj.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.table.TableCellRenderer;

public class PaneCurrentValues
implements Main.PaneInterface {
    private final int NAX_BUFFER_SAMPLES = 1000;
    private JTable table = null;
    private JPanel mainPanel = null;
    private JScrollPane scrollPane = null;
    private Timer timer;
    private JLabel dataSourceLabel;
    private boolean useDatabase = false;
    private int timeColumn = -1;
    private JRadioButton samples30RadioButton = null;
    private JRadioButton samples100RadioButton = null;
    private JRadioButton samples300RadioButton = null;
    private JRadioButton samples1000RadioButton = null;
    private ButtonGroup samplesGroup = null;
    private JRadioButton displaySlopeSecondsRadioButton = null;
    private JRadioButton displaySlopeMinutesRadioButton = null;
    private JRadioButton displaySlopeHoursRadioButton = null;
    private JCheckBox largeFontCheckBox = null;
    private JLabel actualSampleTimeLabel = null;
    private double actualSampleTime;
    private NumberFormat nf;
    private int statSamples = 100;
    private boolean asyncBusy = false;
    private String rowId = null;
    private Boolean rowColor = false;
    SlopeListener slopeListener = new SlopeListener();
    StatValues statValues = new StatValues(true){

        public void updaterInternalBuffer() {
            PaneCurrentValues.this.actualSampleTime = ((Values)PaneCurrentValues.this.statValues.getEntry(0)).getTimeRange();
            if (PaneCurrentValues.this.actualSampleTime == 0.0) {
                return;
            }
            for (StatValues.StatValue st : PaneCurrentValues.this.statValues) {
                st.update(((Values)st).getData(), PaneCurrentValues.this.actualSampleTime);
            }
        }

        public void updaterDatabase() {
            if (Support.dataBase.rows() == 0) {
                return;
            }
            int last = Support.dataBase.rows();
            int first = last - PaneCurrentValues.this.statSamples;
            if (first < 0) {
                first = 0;
            }
            DataBase.DataBaseRange range = Support.dataBase.getRange(first, last);
            PaneCurrentValues.this.actualSampleTime = Support.dataBase.getValue(last - 1, PaneCurrentValues.this.timeColumn) - Support.dataBase.getValue(first, PaneCurrentValues.this.timeColumn);
            for (StatValues.StatValue st : PaneCurrentValues.this.statValues) {
                ((Values)st).update(Support.dataBase.getColumnRange(range, st.getColumnNo()), PaneCurrentValues.this.actualSampleTime);
            }
        }

        @Override
        public void updater() {
            if (PaneCurrentValues.this.statValues.getRowCount() == 0) {
                return;
            }
            if (PaneCurrentValues.this.useDatabase) {
                this.updaterDatabase();
            } else {
                this.updaterInternalBuffer();
            }
        }
    };

    PaneCurrentValues() {
        this.nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        this.nf.setGroupingUsed(false);
        this.nf.setMaximumFractionDigits(0);
        this.timer = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaneCurrentValues.this.timerUpdate();
            }
        });
    }

    private void setLargeInternal(boolean large) {
        if (large) {
            this.table.setRowHeight(FontAdjust.fontSizes.tableLargeRowHeight);
            this.table.setFont(FontAdjust.fontSizes.tableLargeFont);
        } else {
            this.table.setRowHeight(FontAdjust.fontSizes.tableRowHeight);
            this.table.setFont(FontAdjust.fontSizes.textFont);
        }
    }

    public void setLarge(boolean large) {
        this.largeFontCheckBox.setSelected(large);
        this.setLargeInternal(large);
    }

    public void setSlope(char slope) {
        switch (slope) {
            case 's': {
                this.displaySlopeSecondsRadioButton.setSelected(true);
                break;
            }
            case 'm': {
                this.displaySlopeMinutesRadioButton.setSelected(true);
                break;
            }
            case 'h': {
                this.displaySlopeHoursRadioButton.setSelected(true);
            }
        }
        this.statValues.setSlopeMode(slope);
        this.timerUpdate();
    }

    public void setSamples(int samples) {
        if (samples > 1000) {
            samples = 1000;
        }
        if (samples < 10) {
            samples = 10;
        }
        switch (samples) {
            case 30: {
                this.samples30RadioButton.setSelected(true);
                break;
            }
            case 100: {
                this.samples100RadioButton.setSelected(true);
                break;
            }
            case 300: {
                this.samples300RadioButton.setSelected(true);
                break;
            }
            case 1000: {
                this.samples1000RadioButton.setSelected(true);
                break;
            }
            default: {
                this.samplesGroup.clearSelection();
            }
        }
        this.statSamples = samples;
        this.timerUpdate();
    }

    @Override
    public int getHotKey() {
        return 86;
    }

    @Override
    public String getTitle() {
        return "Current values";
    }

    private void setupSizes() {
        int w = this.mainPanel.getSize().width - 20;
        int h = this.mainPanel.getSize().height - 10;
        Dimension d = new Dimension(w, h);
        this.scrollPane.setMaximumSize(d);
        this.scrollPane.setMinimumSize(d);
        this.scrollPane.setPreferredSize(d);
        this.mainPanel.validate();
    }

    private JPanel makeSlopePanel() {
        FontAdjust.FontPanel slopePanel = new FontAdjust.FontPanel();
        slopePanel.setLayout(new GridBagLayout());
        slopePanel.setBorder(BorderFactory.createTitledBorder("Slope time"));
        slopePanel.setScaleWidth(110);
        slopePanel.setScaleHeight(100);
        slopePanel.setAlignmentX(0.5f);
        slopePanel.setToolTipText("Show slope for seconds/minutes/hours periode, this is just a scaling");
        ButtonGroup displayGroup = new ButtonGroup();
        this.displaySlopeSecondsRadioButton = new FontAdjust.FontRadioButton("/seconds");
        this.displaySlopeSecondsRadioButton.setActionCommand("s");
        this.displaySlopeSecondsRadioButton.addActionListener(this.slopeListener);
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.weightx = 1.0;
        c.anchor = 18;
        slopePanel.add((Component)this.displaySlopeSecondsRadioButton, c);
        displayGroup.add(this.displaySlopeSecondsRadioButton);
        this.displaySlopeMinutesRadioButton = new FontAdjust.FontRadioButton("/minute");
        this.displaySlopeMinutesRadioButton.setActionCommand("m");
        this.displaySlopeMinutesRadioButton.addActionListener(this.slopeListener);
        c = new GridBagConstraints();
        c.gridy = 1;
        c.weightx = 1.0;
        c.anchor = 18;
        slopePanel.add((Component)this.displaySlopeMinutesRadioButton, c);
        displayGroup.add(this.displaySlopeMinutesRadioButton);
        this.displaySlopeHoursRadioButton = new FontAdjust.FontRadioButton("/hour");
        this.displaySlopeHoursRadioButton.setActionCommand("h");
        this.displaySlopeHoursRadioButton.addActionListener(this.slopeListener);
        c = new GridBagConstraints();
        c.gridy = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 18;
        slopePanel.add((Component)this.displaySlopeHoursRadioButton, c);
        displayGroup.add(this.displaySlopeHoursRadioButton);
        this.displaySlopeSecondsRadioButton.setSelected(true);
        return slopePanel;
    }

    private JPanel makeSamplesPanel() {
        FontAdjust.FontPanel samplesPanel = new FontAdjust.FontPanel();
        samplesPanel.setLayout(new GridBagLayout());
        samplesPanel.setBorder(BorderFactory.createTitledBorder("Samples"));
        samplesPanel.setToolTipText("Samples used for calculataions");
        samplesPanel.setScaleWidth(110);
        samplesPanel.setScaleHeight(150);
        samplesPanel.setAlignmentX(0.5f);
        this.samplesGroup = new ButtonGroup();
        this.samples30RadioButton = new FontAdjust.FontRadioButton("30");
        this.samples30RadioButton.setActionCommand("30");
        this.samples30RadioButton.addActionListener(this.slopeListener);
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.weightx = 1.0;
        c.anchor = 18;
        samplesPanel.add((Component)this.samples30RadioButton, c);
        this.samplesGroup.add(this.samples30RadioButton);
        this.samples100RadioButton = new FontAdjust.FontRadioButton("100");
        this.samples100RadioButton.setActionCommand("100");
        this.samples100RadioButton.addActionListener(this.slopeListener);
        c = new GridBagConstraints();
        c.gridy = 1;
        c.weightx = 1.0;
        c.anchor = 18;
        samplesPanel.add((Component)this.samples100RadioButton, c);
        this.samplesGroup.add(this.samples100RadioButton);
        this.samples300RadioButton = new FontAdjust.FontRadioButton("300");
        this.samples300RadioButton.setActionCommand("300");
        this.samples300RadioButton.addActionListener(this.slopeListener);
        c = new GridBagConstraints();
        c.gridy = 2;
        c.weightx = 1.0;
        c.anchor = 18;
        samplesPanel.add((Component)this.samples300RadioButton, c);
        this.samplesGroup.add(this.samples300RadioButton);
        this.samples1000RadioButton = new FontAdjust.FontRadioButton("1000");
        this.samples1000RadioButton.setActionCommand("1000");
        this.samples1000RadioButton.addActionListener(this.slopeListener);
        c = new GridBagConstraints();
        c.gridy = 4;
        c.weightx = 1.0;
        c.anchor = 18;
        samplesPanel.add((Component)this.samples1000RadioButton, c);
        this.samplesGroup.add(this.samples1000RadioButton);
        this.actualSampleTimeLabel = new FontAdjust.FontLabel();
        c = new GridBagConstraints();
        c.gridy = 5;
        c.weightx = 1.0;
        c.anchor = 18;
        samplesPanel.add((Component)this.actualSampleTimeLabel, c);
        this.samples100RadioButton.setSelected(true);
        return samplesPanel;
    }

    @Override
    public JPanel getPanel() {
        this.mainPanel = new FontAdjust.FontPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.addComponentListener(new MySwingUtil.ResizeListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                PaneCurrentValues.this.setupSizes();
            }
        });
        this.table = new FontAdjust.FontTable(this.statValues){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                JLabel comp = (JLabel)super.prepareRenderer(renderer, row, col);
                if (col == 0) {
                    comp.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
                    comp.setHorizontalAlignment(2);
                } else {
                    comp.setHorizontalAlignment(0);
                }
                if (!comp.getBackground().equals(Support.colorScheme.selectedCellbackground)) {
                    switch (Support.systemSettings.deviceTableBackground) {
                        case Alternate: {
                            String id = PaneCurrentValues.this.statValues.getEntry(row).getName();
                            id = id.substring(0, id.indexOf(46));
                            if (row == 0) {
                                PaneCurrentValues.this.rowId = id;
                                PaneCurrentValues.this.rowColor = false;
                                break;
                            }
                            if (id.equals(PaneCurrentValues.this.rowId)) break;
                            PaneCurrentValues.this.rowId = id;
                            PaneCurrentValues.this.rowColor = PaneCurrentValues.this.rowColor == false;
                            break;
                        }
                        case First: {
                            PaneCurrentValues.this.rowColor = false;
                            String id = PaneCurrentValues.this.statValues.getEntry(row).getName();
                            int n = id.indexOf(46);
                            id = id.substring(0, n);
                            if (row != 0 && id.equals(PaneCurrentValues.this.statValues.getEntry(row - 1).getName().substring(0, n))) break;
                            PaneCurrentValues.this.rowId = id;
                            PaneCurrentValues.this.rowColor = true;
                            break;
                        }
                        case OneInFour: {
                            PaneCurrentValues.this.rowColor = row % 4 == 0;
                            break;
                        }
                    }
                    comp.setBackground(PaneCurrentValues.this.rowColor != false ? Support.colorScheme.tableGridAlternateBackground : Support.colorScheme.textBackground);
                }
                return comp;
            }
        };
        Support.colorScheme.selectedCellbackground = this.table.getSelectionBackground();
        Support.colorScheme.selectedCellForeground = this.table.getSelectionForeground();
        GridBagConstraints c = new GridBagConstraints();
        this.table.setColumnModel(new Support.WidthTableColumnModel(new int[]{200, 50, 95, 95, 95, 95, 95, 95}));
        this.table.setModel(this.statValues);
        this.table.setAutoResizeMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.scrollPane = new JScrollPane(this.table);
        this.mainPanel.add(this.scrollPane);
        this.table.setFillsViewportHeight(true);
        this.table.addNotify();
        FontAdjust.FontPanel sidePanel = new FontAdjust.FontPanel();
        this.mainPanel.add((Component)sidePanel, "East");
        sidePanel.setLayout(new GridBagLayout());
        sidePanel.setAlignmentY(0.0f);
        sidePanel.setScaleWidth(110);
        this.dataSourceLabel = new FontAdjust.FontLabel("Direct");
        this.dataSourceLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.dataSourceLabel.setHorizontalAlignment(0);
        c = new GridBagConstraints();
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 11;
        sidePanel.add((Component)this.dataSourceLabel, c);
        sidePanel.add(Box.createVerticalStrut(10));
        c = new GridBagConstraints();
        c.gridy = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 18;
        sidePanel.add((Component)this.makeSamplesPanel(), c);
        c = new GridBagConstraints();
        c.gridy = 2;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 18;
        sidePanel.add((Component)this.makeSlopePanel(), c);
        this.largeFontCheckBox = new FontAdjust.FontCheckBox("Large text");
        this.largeFontCheckBox.setToolTipText("Use larger text for all measured values");
        this.largeFontCheckBox.setAlignmentX(0.5f);
        c = new GridBagConstraints();
        c.gridy = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 2;
        c.anchor = 14;
        sidePanel.add((Component)this.largeFontCheckBox, c);
        this.largeFontCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PaneCurrentValues.this.setLarge(PaneCurrentValues.this.largeFontCheckBox.isSelected());
            }
        });
        this.setupSizes();
        this.table.addMouseListener(new MouseAdapter(){

            public void popupShow(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JTable source = (JTable)e.getSource();
                    int row = source.rowAtPoint(e.getPoint());
                    int column = source.columnAtPoint(e.getPoint());
                    if (!source.isRowSelected(row)) {
                        source.changeSelection(row, column, false, false);
                    }
                    final StatValues.StatValue value = PaneCurrentValues.this.statValues.getEntry(row);
                    JPopupMenu popupMenu = new JPopupMenu();
                    FontAdjust.FontMenuItem mi = new FontAdjust.FontMenuItem("Copy to clipboard");
                    mi.setToolTipText("Copy all values to clipboard, result can be pasted into a document or spreadsheet");
                    mi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            (this).PaneCurrentValues.this.statValues.copyToClipboard();
                        }
                    });
                    popupMenu.add(mi);
                    ValueFormat.formatMenu(popupMenu, "Format", "", value.getFormat().format, false, false, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PaneCurrentValues.this.setDecimals(value, e.getActionCommand());
                        }
                    });
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.popupShow(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.popupShow(e);
            }
        });
        return this.mainPanel;
    }

    private void setDecimals(StatValues.StatValue value, String format) {
        if (value.getFormat().format instanceof ValueFormat.ValueFormatterDigital) {
            return;
        }
        value.getFormat().format = ValueFormat.getFormatter(format);
        this.statValues.sendNotificationData();
    }

    private void slopeChanged(String cmd) {
        if (cmd == "s") {
            this.statValues.setSlopeMode('s');
        } else if (cmd == "m") {
            this.statValues.setSlopeMode('m');
        } else if (cmd == "h") {
            this.statValues.setSlopeMode('h');
        } else {
            this.statSamples = StringUtil.parseInt(cmd);
        }
        this.timerUpdate();
    }

    @Override
    public void changeDevicesOrTable(Support.UpdateType type) {
        if (type.equals((Object)Support.UpdateType.StartInit)) {
            return;
        }
        this.timeColumn = Support.dataBase.header().getDomainColumn();
        this.setupFields();
        if (this.mainPanel.isVisible()) {
            this.timerUpdate();
        }
    }

    private void timerUpdate() {
        if (!this.useDatabase) {
            this.asyncUpdate();
        } else {
            this.statValues.update();
            this.actualSampleTimeLabel.setText("Time: " + (int)(0.5 + this.actualSampleTime) + " sec");
        }
    }

    private void asyncUpdate() {
        AsyncUpdate au = new AsyncUpdate();
        au.setDaemon(true);
        au.start();
    }

    private void updateDirect() {
        double time = (double)System.currentTimeMillis() / 1000.0;
        for (InterfaceThreads.ThreadCommand tc : InterfaceThreads.sampleAllDeviceValues()) {
            List<Double> vv = tc.getAnswerDoubles();
            int i = 0;
            while (i < vv.size()) {
                Values v = (Values)this.statValues.getEntry(tc.getValueName(i));
                if (v != null) {
                    v.updateValue(time, vv.get(i));
                }
                ++i;
            }
        }
        for (Mathematics.MathEntry me : Support.math.getEnabledMathEntries()) {
            Values v = (Values)this.statValues.getEntry(me.getFullName());
            v.updateValue(time, me.calcDirect("Current", time));
        }
    }

    private void setupFields() {
        this.statValues.clear();
        int n = 0;
        if (InterfaceThreads.getDevices() == null) {
            return;
        }
        this.useDatabase = InterfaceThreads.isLogging() && InterfaceThreads.loggingInterval < 1500L;
        this.dataSourceLabel.setText(this.useDatabase ? "Table" : "Direct");
        if (this.useDatabase) {
            int[] nArray = Support.dataBase.header().getDataColumns();
            int n2 = nArray.length;
            int n3 = 0;
            while (n3 < n2) {
                int columnNo = nArray[n3];
                Values v = new Values(Support.dataBase.header().getColumnName(columnNo), columnNo, Support.dataBase.format().get(columnNo));
                this.statValues.add(v);
                ++n3;
            }
        } else {
            for (InterfaceThreads.DeviceThread dt : InterfaceThreads.getDevices()) {
                for (String name : dt.getValueNames()) {
                    DeviceInterface di = dt.getDeviceInterface();
                    Values v = new Values(name, n++, di.getValueFormat(name));
                    this.statValues.add(v);
                }
            }
            Support.math.resetCalc("Current");
            for (Mathematics.MathEntry me : Support.math.getEnabledMathEntries()) {
                Values v = new Values(me.getFullName(), n++, me.getValueFormat());
                this.statValues.add(v);
            }
        }
        this.statValues.update();
    }

    @Override
    public void select() {
        InterfaceThreads.initAllColumns();
        this.setupFields();
        this.timerUpdate();
        this.timer.start();
    }

    @Override
    public void deselect() {
        this.timer.stop();
        Support.math.removeDomain("Current");
    }

    public List<String> generateScript() {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        sb.append("#CurrentValuesOptions ");
        sb.append(this.statSamples);
        sb.append(" ");
        sb.append(this.largeFontCheckBox.isSelected() ? "large" : "small");
        sb.append(" ");
        sb.append("/" + this.statValues.getSlopeMode());
        list.add(sb.toString());
        return list;
    }

    private class AsyncUpdate
    extends Thread {
        private AsyncUpdate() {
        }

        @Override
        public void run() {
            this.setName("Async update");
            if (PaneCurrentValues.this.asyncBusy || PaneCurrentValues.this.useDatabase) {
                return;
            }
            PaneCurrentValues.this.asyncBusy = true;
            try {
                try {
                    PaneCurrentValues.this.updateDirect();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (PaneCurrentValues.this.useDatabase) {
                                return;
                            }
                            ((AsyncUpdate)AsyncUpdate.this).PaneCurrentValues.this.statValues.update();
                            PaneCurrentValues.this.actualSampleTimeLabel.setText("Time: " + (int)(0.5 + PaneCurrentValues.this.actualSampleTime) + " sec");
                        }
                    });
                }
                finally {
                    PaneCurrentValues.this.asyncBusy = false;
                }
            }
            catch (Exception exception) {}
        }
    }

    private class SlopeListener
    implements ActionListener {
        private SlopeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PaneCurrentValues.this.slopeChanged(e.getActionCommand());
        }
    }

    private class Values
    extends StatValues.StatValue {
        private double[][] last = new double[1000][2];
        private int samples = 0;

        Values(String name, int column, ValueFormat fmt) {
            this.define(name, column, fmt);
        }

        void updateValue(double time, double v) {
            int i = 0;
            while (i < 999) {
                this.last[i][0] = this.last[i + 1][0];
                this.last[i][1] = this.last[i + 1][1];
                ++i;
            }
            this.last[999][0] = time;
            this.last[999][1] = v;
            if (this.samples < 1000) {
                ++this.samples;
            }
        }

        public double[] getData() {
            int nn = Math.min(PaneCurrentValues.this.statSamples, this.samples);
            double[] v = new double[nn];
            if (nn == 0) {
                return v;
            }
            int n = 0;
            int i = 1000 - nn;
            while (i < 1000) {
                v[n++] = this.last[i][1];
                ++i;
            }
            return v;
        }

        public double getTimeRange() {
            if (this.samples == 0) {
                return 0.0;
            }
            return this.last[999][0] - this.last[1000 - Math.min(PaneCurrentValues.this.statSamples, this.samples)][0];
        }
    }
}

