/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.FontAdjust;
import dk.hkj.main.Main;
import dk.hkj.main.PopupAbout;
import dk.hkj.main.Support;
import dk.hkj.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PaneConfig
implements Main.PaneInterface,
ActionListener {
    private JPanel mainPanel = new JPanel();
    private JTextField delayOverflowTextField = null;
    private JTextField delayTimeoutTextField = null;
    private JTextField lowLogTextField = null;
    private JLabel startupLabel = null;
    private JButton startupButton = null;
    private JCheckBox restorePopupLocations = null;
    private JTextField[] imageWidth = new JTextField[5];
    private JTextField[] imageHeight = new JTextField[5];

    @Override
    public String getTitle() {
        return "Configuration";
    }

    private JPanel makeOverloadPanel() {
        FontAdjust.FontPanel panel = new FontAdjust.FontPanel();
        panel.setScaleHeight(130);
        panel.setScaleWidth(230);
        panel.setLayout(new BoxLayout(panel, 3));
        panel.setBorder(BorderFactory.createTitledBorder("Overload handling"));
        panel.setToolTipText("This overflow handling is for the table");
        ButtonGroup gp = new ButtonGroup();
        FontAdjust.FontRadioButton rb = new FontAdjust.FontRadioButton("Return: 0");
        rb.setActionCommand("OV0");
        rb.addActionListener(this);
        rb.setAlignmentX(0.0f);
        if (Support.systemSettings.overflowHandling == Support.OverflowHandling.zero) {
            rb.setSelected(true);
        }
        gp.add(rb);
        panel.add(rb);
        rb = new FontAdjust.FontRadioButton("Return: 1E99");
        rb.setActionCommand("OVhigh");
        rb.addActionListener(this);
        rb.setAlignmentX(0.0f);
        if (Support.systemSettings.overflowHandling == Support.OverflowHandling.highValue) {
            rb.setSelected(true);
        }
        gp.add(rb);
        panel.add(rb);
        rb = new FontAdjust.FontRadioButton("Return: Infinite");
        rb.setToolTipText("This may cause problems importing into other software");
        rb.setActionCommand("OVunl");
        rb.addActionListener(this);
        rb.setAlignmentX(0.0f);
        if (Support.systemSettings.overflowHandling == Support.OverflowHandling.infinite) {
            rb.setSelected(true);
        }
        gp.add(rb);
        panel.add(rb);
        JPanel p1 = new JPanel();
        p1.add(new FontAdjust.FontLabel("Delay overflow by:"));
        this.delayOverflowTextField = new FontAdjust.FontTextField(4);
        this.delayOverflowTextField.setMinimumSize(new Dimension(50, 20));
        this.delayOverflowTextField.setText(Integer.toString(Support.systemSettings.delayOverflow));
        this.delayOverflowTextField.setActionCommand("Delay");
        this.delayOverflowTextField.setToolTipText("Some meters will return OV when autoranging, using this delay prevents strange jumps in the data");
        this.delayOverflowTextField.addActionListener(this);
        this.delayOverflowTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                PaneConfig.this.actionPerformed(new ActionEvent(PaneConfig.this.delayOverflowTextField, 1001, "Delay"));
            }
        });
        p1.setAlignmentX(0.0f);
        p1.add(this.delayOverflowTextField);
        p1.add(new FontAdjust.FontLabel("samples"));
        panel.add(p1);
        return panel;
    }

    private JPanel makeTimeoutPanel() {
        FontAdjust.FontPanel panel = new FontAdjust.FontPanel();
        panel.setScaleHeight(110);
        panel.setScaleWidth(230);
        panel.setLayout(new BoxLayout(panel, 3));
        panel.setBorder(BorderFactory.createTitledBorder("Timeout handling"));
        panel.setToolTipText("This timeout handling is for the table");
        ButtonGroup gp = new ButtonGroup();
        FontAdjust.FontRadioButton rb = new FontAdjust.FontRadioButton("Return: 0");
        rb.setActionCommand("T0");
        rb.addActionListener(this);
        rb.setAlignmentX(0.0f);
        if (Support.systemSettings.timeoutValue == 0.0) {
            rb.setSelected(true);
        }
        gp.add(rb);
        panel.add(rb);
        rb = new FontAdjust.FontRadioButton("Return: Not a number (NaN)");
        rb.setToolTipText("This may cause problems importing into other software");
        rb.setActionCommand("Tnan");
        rb.addActionListener(this);
        rb.setAlignmentX(0.0f);
        if (Double.isNaN(Support.systemSettings.timeoutValue)) {
            rb.setSelected(true);
        }
        gp.add(rb);
        panel.add(rb);
        JPanel p1 = new JPanel();
        p1.add(new FontAdjust.FontLabel("Delay timeout by:"));
        this.delayTimeoutTextField = new FontAdjust.FontTextField(4);
        this.delayTimeoutTextField.setMinimumSize(new Dimension(50, 20));
        this.delayTimeoutTextField.setText(Integer.toString(Support.systemSettings.delayTimeout));
        this.delayTimeoutTextField.setActionCommand("Timeout");
        this.delayTimeoutTextField.setToolTipText("This setting will prevent short dropouts in the log");
        this.delayTimeoutTextField.addActionListener(this);
        this.delayTimeoutTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                PaneConfig.this.actionPerformed(new ActionEvent(PaneConfig.this.delayTimeoutTextField, 1001, "Timeout"));
            }
        });
        p1.setAlignmentX(0.0f);
        p1.add(this.delayTimeoutTextField);
        p1.add(new FontAdjust.FontLabel("samples"));
        panel.add(p1);
        return panel;
    }

    private JPanel makeDeviceMarkingPanel() {
        FontAdjust.FontPanel panel = new FontAdjust.FontPanel();
        panel.setScaleHeight(110);
        panel.setScaleWidth(230);
        panel.setLayout(new BoxLayout(panel, 3));
        panel.setBorder(BorderFactory.createTitledBorder("Device marking"));
        panel.setToolTipText("How to mark devices in \"Current Values\" and \"Range\" pages");
        ButtonGroup gp = new ButtonGroup();
        FontAdjust.FontRadioButton rb = new FontAdjust.FontRadioButton("One in four");
        rb.setToolTipText("Every fourth line is marked");
        rb.setActionCommand("Dev-14");
        rb.addActionListener(this);
        rb.setAlignmentX(0.0f);
        if (Support.systemSettings.deviceTableBackground == Support.DeviceTableBackground.OneInFour) {
            rb.setSelected(true);
        }
        gp.add(rb);
        panel.add(rb);
        rb = new FontAdjust.FontRadioButton("First line");
        rb.setToolTipText("First line of each device is marked, most useful when only devices with multiple lines are loaded");
        rb.setActionCommand("Dev-1");
        rb.addActionListener(this);
        rb.setAlignmentX(0.0f);
        if (Support.systemSettings.deviceTableBackground == Support.DeviceTableBackground.First) {
            rb.setSelected(true);
        }
        gp.add(rb);
        panel.add(rb);
        rb = new FontAdjust.FontRadioButton("Alternate");
        rb.setToolTipText("Alternate devices is marked");
        rb.setActionCommand("Dev-Alt");
        rb.addActionListener(this);
        rb.setAlignmentX(0.0f);
        if (Support.systemSettings.deviceTableBackground == Support.DeviceTableBackground.Alternate) {
            rb.setSelected(true);
        }
        gp.add(rb);
        panel.add(rb);
        return panel;
    }

    private JPanel makeOverloadChartPanel() {
        FontAdjust.FontPanel panel = new FontAdjust.FontPanel();
        panel.setScaleHeight(110);
        panel.setScaleWidth(230);
        panel.setLayout(new BoxLayout(panel, 3));
        panel.setBorder(BorderFactory.createTitledBorder("Infinite/NaN Chart handling"));
        panel.setToolTipText("This is how the chart handles infinite/overload and NaN values");
        ButtonGroup gp = new ButtonGroup();
        FontAdjust.FontRadioButton rb = new FontAdjust.FontRadioButton("Return fixed value");
        rb.setToolTipText("This will be 0 for linear scales and defined below for logarithmic scales");
        rb.setActionCommand("OVCFixed");
        rb.addActionListener(this);
        rb.setAlignmentX(0.0f);
        if (Support.systemSettings.overflowChartHandling == Support.OverflowChartHandling.fixedValue) {
            rb.setSelected(true);
        }
        gp.add(rb);
        panel.add(rb);
        rb = new FontAdjust.FontRadioButton("Filter");
        rb.setToolTipText("Invalid samples will be removed, but there will not be a gab in the curve");
        rb.setActionCommand("OVCFilter");
        rb.addActionListener(this);
        rb.setAlignmentX(0.0f);
        if (Support.systemSettings.overflowChartHandling == Support.OverflowChartHandling.filter) {
            rb.setSelected(true);
        }
        gp.add(rb);
        panel.add(rb);
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(0));
        FontAdjust.FontLabel l = new FontAdjust.FontLabel("Low log limit:");
        p1.add(l);
        this.lowLogTextField = new FontAdjust.FontTextField(6);
        this.lowLogTextField.setText(Double.toString(Support.systemSettings.chartLowLog));
        this.lowLogTextField.setActionCommand("LowLog");
        this.lowLogTextField.setMinimumSize(new Dimension(50, 20));
        this.lowLogTextField.setToolTipText("Minimum value to show in a logarithmic chart");
        this.lowLogTextField.addActionListener(this);
        this.lowLogTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                PaneConfig.this.actionPerformed(new ActionEvent(PaneConfig.this.lowLogTextField, 1001, "LowLog"));
            }
        });
        p1.setAlignmentX(0.0f);
        p1.add(this.lowLogTextField);
        panel.add(p1);
        return panel;
    }

    private JPanel makeFontSizePanel() {
        final FontAdjust.FontPanel panel = new FontAdjust.FontPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Font size"));
        panel.setLayout(new BorderLayout());
        panel.setScaleHeight(70);
        panel.setScaleWidth(230);
        final FontAdjust.FontSlider slider = new FontAdjust.FontSlider(15, 40);
        slider.setValue(Support.systemSettings.fontSize / 5);
        slider.setMajorTickSpacing(25);
        slider.setMinorTickSpacing(5);
        slider.setPaintLabels(true);
        slider.setPaintTicks(true);
        slider.setMinimumSize(new Dimension(120, 30));
        slider.setToolTipText("Large font sizes will require that the form is large or some elements will be hidden");
        Hashtable<Integer, FontAdjust.FontLabel> labels = new Hashtable<Integer, FontAdjust.FontLabel>();
        labels.put(20, new FontAdjust.FontLabel("100%"));
        labels.put(30, new FontAdjust.FontLabel("150%"));
        labels.put(40, new FontAdjust.FontLabel("200%"));
        slider.setLabelTable(labels);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                Support.systemSettings.fontSize = slider.getValue() * 5;
                FontAdjust.setFontScale((double)Support.systemSettings.fontSize / 100.0);
                panel.invalidate();
            }
        });
        panel.add(slider);
        return panel;
    }

    private void setLocationText() {
        String labelText = "";
        String buttonText = "";
        if (Support.systemSettings.screenSize.width > 900) {
            labelText = "X:" + Support.systemSettings.screenUpperLeft.x + "  Y:" + Support.systemSettings.screenUpperLeft.y + "  W:" + Support.systemSettings.screenSize.width + "  H:" + Support.systemSettings.screenSize.height;
            buttonText = "Default";
        } else {
            labelText = "Default";
            buttonText = "Use current";
        }
        this.startupLabel.setText(labelText);
        this.startupButton.setText(buttonText);
    }

    private JPanel makeLocationAndSizePanel() {
        FontAdjust.FontPanel panel = new FontAdjust.FontPanel();
        panel.setScaleHeight(100);
        panel.setScaleWidth(200);
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Startup position & size"));
        this.startupLabel = new FontAdjust.FontLabel();
        this.startupLabel.setHorizontalAlignment(0);
        panel.add(this.startupLabel);
        this.startupButton = new FontAdjust.FontButton();
        this.startupButton.setActionCommand("Location");
        this.startupButton.addActionListener(this);
        JPanel optPanel = new JPanel();
        optPanel.setLayout(new GridLayout(2, 1));
        panel.add((Component)optPanel, "South");
        optPanel.add(this.startupButton);
        this.setLocationText();
        this.restorePopupLocations = new JCheckBox("Restore popup locations");
        this.restorePopupLocations.setSelected(Support.systemSettings.restorePopupLocations);
        this.restorePopupLocations.setActionCommand("RestorePopupLocations");
        this.restorePopupLocations.addActionListener(this);
        optPanel.add(this.restorePopupLocations);
        return panel;
    }

    private boolean parseImagePanel(boolean save) {
        boolean ok = true;
        int i = 0;
        while (i < 5) {
            int w = 0;
            int h = 0;
            try {
                w = Integer.parseInt(this.imageWidth[i].getText());
                if (w < 400 || w > 15000) {
                    this.imageWidth[i].setBackground(Support.colorScheme.errorBackground);
                    ok = false;
                } else {
                    this.imageWidth[i].setBackground(Support.colorScheme.textBackground);
                }
            }
            catch (Exception exception) {
                this.imageWidth[i].setBackground(Support.colorScheme.errorBackground);
                ok = false;
            }
            try {
                h = Integer.parseInt(this.imageHeight[i].getText());
                if (h < 250 || h > 10000) {
                    this.imageHeight[i].setBackground(Support.colorScheme.errorBackground);
                    ok = false;
                } else {
                    this.imageHeight[i].setBackground(Support.colorScheme.textBackground);
                }
            }
            catch (Exception exception) {
                this.imageHeight[i].setBackground(Support.colorScheme.errorBackground);
                ok = false;
            }
            if (ok && save && w > 0 && h > 0) {
                Support.systemSettings.imageResolution[i] = new Dimension(w, h);
            }
            ++i;
        }
        return ok;
    }

    private JPanel makeImagePanel() {
        FontAdjust.FontPanel panel = new FontAdjust.FontPanel();
        panel.setScaleHeight(140);
        panel.setScaleWidth(200);
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Save image sizes"));
        Dimension minDim = new Dimension(60, 20);
        int i = 0;
        while (i < 5) {
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = i;
            c.weightx = 1.0;
            c.weighty = 1.0;
            panel.add((Component)new FontAdjust.FontLabel(i == 4 ? "Custom:" : i + 1 + ":"), c);
            this.imageWidth[i] = new FontAdjust.FontTextField(5);
            this.imageWidth[i].setText(Integer.toString(Support.systemSettings.imageResolution[i].width));
            this.imageWidth[i].setMinimumSize(minDim);
            this.imageWidth[i].setToolTipText("Image width, range is 400 to 15000");
            this.imageWidth[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PaneConfig.this.parseImagePanel(false);
                }
            });
            this.imageWidth[i].addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent arg0) {
                    ((JTextField)arg0.getComponent()).selectAll();
                }

                @Override
                public void focusLost(FocusEvent arg0) {
                    PaneConfig.this.parseImagePanel(false);
                }
            });
            c.gridx = 1;
            c.gridy = i;
            panel.add((Component)this.imageWidth[i], c);
            c.gridx = 2;
            c.gridy = i;
            c.weightx = 1.0;
            panel.add((Component)new FontAdjust.FontLabel("x"), c);
            this.imageHeight[i] = new FontAdjust.FontTextField(5);
            this.imageHeight[i].setText(Integer.toString(Support.systemSettings.imageResolution[i].height));
            this.imageHeight[i].setMinimumSize(minDim);
            this.imageHeight[i].setToolTipText("Image height, range is 250 to 10000");
            this.imageHeight[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PaneConfig.this.parseImagePanel(false);
                }
            });
            this.imageHeight[i].addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent arg0) {
                    ((JTextField)arg0.getComponent()).selectAll();
                }

                @Override
                public void focusLost(FocusEvent arg0) {
                    PaneConfig.this.parseImagePanel(false);
                }
            });
            c.gridx = 3;
            c.gridy = i;
            panel.add((Component)this.imageHeight[i], c);
            ++i;
        }
        return panel;
    }

    @Override
    public JPanel getPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.mainPanel.add((Component)this.makeOverloadPanel(), c);
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.mainPanel.add((Component)this.makeOverloadChartPanel(), c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.mainPanel.add((Component)this.makeFontSizePanel(), c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.mainPanel.add((Component)this.makeTimeoutPanel(), c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.mainPanel.add((Component)this.makeDeviceMarkingPanel(), c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.mainPanel.add((Component)this.makeImagePanel(), c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.mainPanel.add((Component)this.makeLocationAndSizePanel(), c);
        FontAdjust.FontButton aboutButton = new FontAdjust.FontButton("About");
        aboutButton.addActionListener(this);
        aboutButton.setActionCommand("About");
        c = new GridBagConstraints();
        c.gridx = 5;
        c.gridy = 5;
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 26;
        this.mainPanel.add((Component)aboutButton, c);
        return this.mainPanel;
    }

    @Override
    public int getHotKey() {
        return 79;
    }

    @Override
    public void changeDevicesOrTable(Support.UpdateType type) {
        if (type.equals((Object)Support.UpdateType.StartInit)) {
            return;
        }
    }

    @Override
    public void select() {
    }

    @Override
    public void deselect() {
        this.parseImagePanel(true);
        Support.systemSettings.saveDefault();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block40: {
            String cmd = e.getActionCommand();
            if (cmd.equals("About")) {
                PopupAbout pop = new PopupAbout();
                pop.setLocationRelativeTo(this.mainPanel);
                pop.setVisible(true);
            } else if (cmd.equals("OV0")) {
                Support.systemSettings.overflowHandling = Support.OverflowHandling.zero;
            } else if (cmd.equals("OVhigh")) {
                Support.systemSettings.overflowHandling = Support.OverflowHandling.highValue;
            } else if (cmd.equals("OVunl")) {
                Support.systemSettings.overflowHandling = Support.OverflowHandling.infinite;
            } else if (cmd.equals("OVCFixed")) {
                Support.systemSettings.overflowChartHandling = Support.OverflowChartHandling.fixedValue;
            } else if (cmd.equals("OVCFilter")) {
                Support.systemSettings.overflowChartHandling = Support.OverflowChartHandling.filter;
            } else if (cmd.equals("Delay")) {
                try {
                    Support.systemSettings.delayOverflow = Integer.parseInt(this.delayOverflowTextField.getText());
                    this.delayOverflowTextField.setBackground(Support.colorScheme.textBackground);
                }
                catch (Exception exception) {
                    this.delayOverflowTextField.setBackground(Support.colorScheme.errorBackground);
                }
            } else if (cmd.equals("T0")) {
                Support.systemSettings.timeoutValue = 0.0;
            } else if (cmd.equals("Tnan")) {
                Support.systemSettings.timeoutValue = Double.NaN;
                Support.systemSettings.overflowChartHandling = Support.OverflowChartHandling.filter;
            } else if (cmd.equals("Timeout")) {
                try {
                    Support.systemSettings.delayTimeout = Integer.parseInt(this.delayTimeoutTextField.getText());
                    this.delayTimeoutTextField.setBackground(Support.colorScheme.textBackground);
                }
                catch (Exception exception) {
                    this.delayTimeoutTextField.setBackground(Support.colorScheme.errorBackground);
                }
            } else if (cmd.equals("LowLog")) {
                try {
                    double v = StringUtil.parseDoubleEE(this.lowLogTextField.getText());
                    if (Double.isFinite(v) && v >= 1.0E-99 && v < 1.0E99) {
                        Support.systemSettings.chartLowLog = v;
                        this.lowLogTextField.setBackground(Support.colorScheme.textBackground);
                        break block40;
                    }
                    this.lowLogTextField.setBackground(Support.colorScheme.errorBackground);
                }
                catch (Exception exception) {
                    this.lowLogTextField.setBackground(Support.colorScheme.errorBackground);
                }
            } else if (cmd.equals("Dev-14")) {
                Support.systemSettings.deviceTableBackground = Support.DeviceTableBackground.OneInFour;
            } else if (cmd.equals("Dev-1")) {
                Support.systemSettings.deviceTableBackground = Support.DeviceTableBackground.First;
            } else if (cmd.equals("Dev-Alt")) {
                Support.systemSettings.deviceTableBackground = Support.DeviceTableBackground.Alternate;
            } else if (cmd.equals("Location")) {
                if (Support.systemSettings.screenSize.width > 900) {
                    Support.systemSettings.screenSize = new Dimension(0, 0);
                } else {
                    Support.systemSettings.screenSize = new Dimension(Main.main.frame.getSize());
                    Support.systemSettings.screenUpperLeft = new Point(Main.main.frame.getLocation());
                }
                this.setLocationText();
            } else if (cmd.equals("RestorePopupLocations")) {
                Support.systemSettings.restorePopupLocations = this.restorePopupLocations.isSelected();
            }
        }
    }
}

