/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.database.DataBase;
import dk.hkj.database.Exporter;
import dk.hkj.main.CommandProcessor;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.HelpLoader;
import dk.hkj.main.HotKeyLoader;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.Main;
import dk.hkj.main.PopupAdjustScale;
import dk.hkj.main.PopupAdvancedLog;
import dk.hkj.main.PopupAlarm;
import dk.hkj.main.PopupAutoAdjust;
import dk.hkj.main.PopupAutoHold;
import dk.hkj.main.PopupCalculator;
import dk.hkj.main.PopupCameraInput;
import dk.hkj.main.PopupChartLayout;
import dk.hkj.main.PopupFFTView;
import dk.hkj.main.PopupGridPanel;
import dk.hkj.main.PopupImage;
import dk.hkj.main.PopupLogEvent;
import dk.hkj.main.PopupLogTrigger;
import dk.hkj.main.PopupMPPT;
import dk.hkj.main.PopupNotes;
import dk.hkj.main.PopupParamAdjuster;
import dk.hkj.main.PopupParamSweeper;
import dk.hkj.main.PopupReadout;
import dk.hkj.main.PopupScriptList;
import dk.hkj.main.PopupShowDevices;
import dk.hkj.main.PopupTestInterface;
import dk.hkj.main.PopupTimer;
import dk.hkj.main.PopupTimerCounter;
import dk.hkj.main.ScriptMenu;
import dk.hkj.main.SetupScriptGenerator;
import dk.hkj.main.Support;
import dk.hkj.util.AudibleAlarm;
import dk.hkj.util.FileUtil;
import dk.hkj.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.BadLocationException;

public class PaneCommand
implements Main.PaneInterface {
    private JTextArea listTextArea;
    private JTextField commandTextField;
    private JTextArea helpTextArea;
    private JPopupMenu commandPopupMenu;
    private JPopupMenu logPopupMenu;
    private JPopupMenu devicePopupMenu;
    private JPopupMenu popupPopupMenu;
    private JPopupMenu savePopupMenu;
    private JPopupMenu logWindowPopupMenu;
    private JPopupMenu otherPopupMenu;
    private JLabel deviceLabel;
    private JLabel versionLabel;
    private JButton runButton;
    private JButton loadButton;
    private JButton saveButton;
    private JButton cleanButton;
    private JButton clearButton;
    private JButton abortButton;
    private JButton logButton;
    private JMenuItem directToDiskMenuItem = null;
    private JButton outputOffButton;
    public JButton popupsButton;
    private List<String> lastCommands = new ArrayList<String>();
    private String lastCommandLine;
    private String lastCommandsSearch = null;
    private int lastCommandsIndex = -1;
    JButton modeButton;
    private JButton setupButton;
    private JButton otherButton;
    private List<String> currentHelpList = null;
    private Timer timer1;
    private Timer timer2;
    private HotKeyLoader hotKeyLoader;
    private String savedProgram = null;
    private boolean firstTime = true;
    private JCheckBoxMenuItem menuScriptOptimize = null;
    public ScriptMenu scriptMenu = null;
    private List<String> versionList = null;
    private ActionListener allButtonActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("AllMode")) {
                PaneCommand.this.showAllPopups(true, false);
            } else if (e.getActionCommand().equals("AllSetup")) {
                PaneCommand.this.showAllPopups(false, true);
            } else if (e.getActionCommand().equals("All")) {
                PaneCommand.this.showAllPopups(true, true);
            } else if (e.getActionCommand().equals("CloseAll")) {
                InterfaceThreads.closeAll(false);
            } else if (e.getActionCommand().equals("OnTop")) {
                for (InterfaceThreads.DeviceThread dt : InterfaceThreads.getDevices()) {
                    dt.getDeviceInterface().setPopupsOnTop(true);
                }
            } else if (e.getActionCommand().equals("NoTop")) {
                for (InterfaceThreads.DeviceThread dt : InterfaceThreads.getDevices()) {
                    dt.getDeviceInterface().setPopupsOnTop(false);
                }
            } else if (e.getActionCommand().equals("List")) {
                new PopupShowDevices(PaneCommand.this.popupsButton).setVisible(true);
            } else if (e.getActionCommand().equals("TestInterface")) {
                DeviceInterface di = InterfaceThreads.getLoadedDeviceInterfaceHandle(Support.cmdEnvironment.getDeviceHandle());
                if (di != null) {
                    new PopupTestInterface(PaneCommand.this.popupsButton, di, false).setVisible(true);
                }
            } else if (e.getActionCommand().equals("Calc")) {
                if (!PopupCalculator.reShow()) {
                    PopupCalculator pc = new PopupCalculator();
                    Point p = PaneCommand.this.popupsButton.getLocationOnScreen();
                    p.translate(-200, -100);
                    pc.setLocation(p);
                    pc.setVisible(true);
                }
            } else if (e.getActionCommand().equals("Timer")) {
                if (!PopupTimer.reShow()) {
                    PopupTimer pt = new PopupTimer();
                    Point p = PaneCommand.this.popupsButton.getLocationOnScreen();
                    p.translate(-200, -100);
                    pt.setLocation(p);
                    pt.setVisible(true);
                }
            } else if (e.getActionCommand().equals("Readout")) {
                PaneCommand.this.showReadoutPopup();
            } else if (e.getActionCommand().equals("AdjustScale")) {
                PopupAdjustScale.getPopup().selectDevice(Support.cmdEnvironment.getDeviceHandle());
            } else if (e.getActionCommand().equals("ParamAdjuster")) {
                PopupParamAdjuster.getPopup().selectDevice(Support.cmdEnvironment.getDeviceHandle());
            } else if (e.getActionCommand().equals("ParamSweeper")) {
                PopupParamSweeper.getPopup();
            } else if (e.getActionCommand().equals("GridPanel")) {
                PopupGridPanel.getPopup();
            } else if (e.getActionCommand().equals("AutoHold")) {
                PopupAutoHold.getPopup();
            } else if (e.getActionCommand().equals("TimerCounter")) {
                PopupTimerCounter.getPopup();
            } else if (e.getActionCommand().equals("TimerCounter")) {
                PopupTimerCounter.getPopup();
            } else if (e.getActionCommand().equals("Alarm")) {
                PaneCommand.this.showAlarmPopup();
            } else if (e.getActionCommand().equals("LogTrigger")) {
                PaneCommand.this.showLogTriggerPopup();
            } else if (e.getActionCommand().equals("LogEvent")) {
                PaneCommand.this.showLogEvent();
            } else if (e.getActionCommand().equals("image")) {
                PopupImage pi = PopupImage.getPopup();
                pi.showDefault(true);
            } else if (e.getActionCommand().equals("FFTView")) {
                PopupFFTView.getPopup();
            } else if (e.getActionCommand().equals("MPPT")) {
                PopupMPPT.getPopup(-1);
            } else if (e.getActionCommand().equals("Camera")) {
                PopupCameraInput.getPopup();
            } else if (e.getActionCommand().equals("AutoAdjust")) {
                PopupAutoAdjust.getPopup();
            }
        }
    };
    MenuActionListener menuActionListener = new MenuActionListener();
    private ActionListener savePopupActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("SaveLog")) {
                PaneCommand.this.buttonSave(true);
            } else if (e.getActionCommand().equals("SaveScript")) {
                PaneCommand.this.buttonSave(false);
            } else if (e.getActionCommand().equals("SaveMenu")) {
                List<String> list = StringUtil.stringToList(PaneCommand.this.listTextArea.getText(), "\n");
                PaneCommand.this.removeDoubleComments(list);
                PaneCommand.this.saveScript(list, false, false, false);
            } else if (e.getActionCommand().equals("SaveMenuEdit")) {
                List<String> list = StringUtil.stringToList(PaneCommand.this.listTextArea.getText(), "\n");
                PaneCommand.this.removeDoubleComments(list);
                PaneCommand.this.saveScript(list, false, false, true);
            }
        }
    };
    private ActionListener logPopupActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (arg0.getActionCommand().equals("Save")) {
                PaneCommand.this.LogToDisk();
            } else if (arg0.getActionCommand().equals("Advanced")) {
                PopupAdvancedLog al = new PopupAdvancedLog(false);
                al.setLocation(((PaneCommand)PaneCommand.this).logButton.getLocationOnScreen().x - 250, ((PaneCommand)PaneCommand.this).logButton.getLocationOnScreen().y - 100);
                al.setVisible(true);
            } else {
                PaneCommand.this.buttonLog(Double.parseDouble(arg0.getActionCommand()));
            }
        }
    };
    private ActionListener devicePopupActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Support.cmdEnvironment.setDeviceHandle(arg0.getActionCommand());
            PaneCommand.this.timer1Update(true);
        }
    };

    public PaneCommand() {
        this.timer1 = new Timer(50, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaneCommand.this.timer1Update(false);
            }
        });
        this.timer1.setRepeats(true);
        this.timer1.start();
        this.timer2 = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaneCommand.this.timer2Update();
            }
        });
        this.timer2.setRepeats(true);
        DeviceOutputCheck doc = new DeviceOutputCheck();
        doc.setDaemon(true);
        doc.start();
    }

    private void focusPopups() {
        PopupImage.windowShow();
        for (InterfaceThreads.DeviceThread dt : InterfaceThreads.getDevices()) {
            dt.getDeviceInterface().focusPopup();
        }
        Main.main.frame.toFront();
    }

    @Override
    public int getHotKey() {
        return 67;
    }

    public void setVersionLabel(List<String> msg) {
        boolean first = true;
        boolean found = false;
        int i = 0;
        while (i < msg.size()) {
            String line = msg.get(i);
            if (line.length() > 1 && Character.toLowerCase(line.charAt(0)) == 'v') {
                String v = Support.formatVersion(line);
                if (v.equals(Support.formatVersion("2.38"))) {
                    if (first) {
                        return;
                    }
                    msg.set(i, String.valueOf(line.trim()) + "    <<--- Currently running program is this version");
                    found = true;
                } else if (v.compareTo(Support.formatVersion("2.38")) < 0 && !found) {
                    if (first) {
                        return;
                    }
                    msg.set(i, String.valueOf(line.trim()) + "    <<--- Currently running program is between this version and next official version");
                    found = true;
                } else if (first) {
                    msg.set(i, String.valueOf(line.trim()) + "   -- Newest version, press F1 for download page --");
                }
                first = false;
            }
            ++i;
        }
        if (!found) {
            msg.add("");
            msg.add("-- Current version is not on the above list --");
        }
        this.versionList = msg;
        this.versionLabel.setText("New version");
        this.versionLabel.setOpaque(true);
        this.versionLabel.setBackground(Color.yellow);
        this.versionLabel.setVisible(true);
    }

    void timer1Update(boolean force) {
        String s;
        while ((s = InterfaceThreads.readLog()) != null) {
            this.logDirect(s);
            force = true;
        }
        if (force) {
            this.deviceLabel.setText(Support.cmdEnvironment.getDeviceHandleLabel());
        }
    }

    private void defaultDevice() {
        if (InterfaceThreads.getDevices() == null || InterfaceThreads.getDevices().size() == 0) {
            return;
        }
        InterfaceThreads.DeviceThread dt = InterfaceThreads.getDevices().get(0);
        if (dt != null && InterfaceThreads.getLoadedDeviceInterfaceHandle(Support.cmdEnvironment.getDeviceHandle()) == null) {
            Support.cmdEnvironment.setDeviceHandle(dt.getHandleName());
            this.deviceLabel.setText(Support.cmdEnvironment.getDeviceHandleLabel());
        }
    }

    void timer2Update() {
        if (this.firstTime && !InterfaceThreads.inInitialization()) {
            try {
                this.defaultDevice();
                String fname = String.valueOf(Support.getConfigPath()) + "/autorun.txt";
                if (Support.startupScript != null) {
                    fname = new File(Support.startupScript).isAbsolute() ? Support.startupScript : Paths.get(Support.getConfigPath(), Support.startupScript).toString();
                }
                List<String> list = FileUtil.readFileAsList(new File(fname));
                this.removeDoubleComments(list);
                CommandProcessor.runBackground(list, false);
                if (this.directToDiskMenuItem != null) {
                    this.directToDiskMenuItem.setEnabled(!InterfaceThreads.isLogging());
                }
            }
            catch (Exception exception) {}
            if (InterfaceThreads.getDevices() == null || InterfaceThreads.getDevices().size() == 0) {
                this.logDirect("\n;; Use \"Load devices\" page for selecting devices to load. Most devices will only load if they are connected and ready.");
            }
            this.scriptMenu = new ScriptMenu();
            this.firstTime = false;
        }
        if (CommandProcessor.isRestore() && this.savedProgram != null) {
            this.runButton.setText("Restore");
            this.runButton.setBackground(new Color(250, 130, 130));
        } else {
            this.runButton.setBackground(null);
            this.runButton.setText("Run");
        }
        this.runButton.setEnabled(!CommandProcessor.isBackground());
        this.loadButton.setEnabled(!CommandProcessor.isBackground() && !CommandProcessor.isRestore());
        if (CommandProcessor.isBackground()) {
            this.abortButton.setBackground(new Color(250, 130, 130));
        } else {
            this.abortButton.setBackground(null);
        }
        this.abortButton.setEnabled(CommandProcessor.isAnyBackground() || AudibleAlarm.isAnyPlaying() || PopupParamSweeper.isSweeping());
        if (InterfaceThreads.isLogging()) {
            this.logButton.setText("Stop log");
            this.logButton.setBackground(new Color(250, 130, 130));
        } else {
            this.logButton.setBackground(null);
            this.logButton.setText("Log");
        }
        this.outputOffButton.setEnabled(!InterfaceThreads.inInitialization());
        InterfaceThreads.DeviceThread dt = InterfaceThreads.deviceMap.get(Support.cmdEnvironment.getDeviceHandle().toUpperCase().trim());
        if (dt != null) {
            this.modeButton.setEnabled(dt.getDeviceInterface().haveModesPopup() && !InterfaceThreads.isLogging());
            this.setupButton.setEnabled(dt.getDeviceInterface().haveSetupPopup());
            this.otherButton.setVisible(dt.getDeviceInterface().otherVisible());
        } else {
            this.modeButton.setEnabled(false);
            this.setupButton.setEnabled(false);
            this.otherButton.setVisible(false);
        }
    }

    public void enableUI(boolean enable) {
        this.listTextArea.setEnabled(enable);
        this.commandTextField.setEnabled(enable);
        this.saveButton.setEnabled(enable);
        this.cleanButton.setEnabled(enable);
        this.clearButton.setEnabled(enable);
        this.logButton.setEnabled(enable);
        this.popupsButton.setEnabled(enable);
    }

    @Override
    public void changeDevicesOrTable(Support.UpdateType type) {
        if (type == Support.UpdateType.StartInit) {
            Main.busyReconnecting = true;
            this.enableUI(false);
        }
        this.commandTextField.requestFocusInWindow();
        this.timer2Update();
        this.processHelp();
        this.timer2.start();
        if (type == Support.UpdateType.Devices) {
            this.enableUI(true);
            this.defaultDevice();
            this.lastCommandLine = String.valueOf(this.lastCommandLine) + "X";
            this.processHelp();
            Main.busyReconnecting = false;
        }
    }

    @Override
    public String getTitle() {
        return "Commands";
    }

    public List<String> getLogText() {
        return StringUtil.stringToList(this.listTextArea.getText(), "\n");
    }

    private JComponent makeListPanel() {
        this.listTextArea = new FontAdjust.FontTextArea();
        this.listTextArea.setEnabled(false);
        this.listTextArea.setLineWrap(true);
        JScrollPane scroll1 = new JScrollPane(this.listTextArea);
        this.hotKeyLoader = new HotKeyLoader(scroll1, this.listTextArea);
        this.logWindowPopupMenu = new JPopupMenu();
        this.listTextArea.setComponentPopupMenu(this.logWindowPopupMenu);
        this.logWindowPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent arg0) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
                PaneCommand.this.makeListPanelPopup();
            }
        });
        return scroll1;
    }

    private void saveScript(List<String> script, boolean setup, boolean autorun, boolean edit) {
        String sname;
        String name = "";
        if (script == null || script.size() == 0) {
            return;
        }
        while (true) {
            if ((name = (String)JOptionPane.showInputDialog(Main.main.frame, "Menu entry name:", setup ? "Add setup menu entry" : "Add menu entry (Use ; for submenu)", 3, null, null, name)) == null) {
                return;
            }
            sname = StringUtil.sanitiseFilename(name);
            if (sname.length() <= 0) continue;
            int option = 0;
            if (this.scriptMenu.fileExists(sname)) {
                option = JOptionPane.showConfirmDialog(null, "File exists, overwrite?", "File exists", 1);
            }
            if (option == 1) {
                return;
            }
            if (option == 0) break;
        }
        if (autorun) {
            script.add(0, "#autorun");
            if (!script.get(script.size() - 1).trim().equalsIgnoreCase("#clear 1")) {
                script.add("#clear 1");
            }
        }
        this.scriptMenu.saveScript(sname, String.valueOf(setup ? "Setup;" : "") + name.trim(), script, edit);
    }

    private void addScriptMenu(JMenu menu, String name, final List<String> script) {
        if (script.size() == 0) {
            return;
        }
        FontAdjust.FontMenu submenu = new FontAdjust.FontMenu(name);
        menu.add(submenu);
        FontAdjust.FontMenuItem mi = new FontAdjust.FontMenuItem("In log window");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommandProcessor.clearRestore();
                PaneCommand.this.listTextArea.setText(StringUtil.listToString(script, "\n"));
            }
        });
        submenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Save as menu");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaneCommand.this.saveScript(script, true, true, false);
            }
        });
        submenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Save as menu and edit");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaneCommand.this.saveScript(script, true, true, true);
            }
        });
        submenu.add(mi);
    }

    public void makeListPanelPopup() {
        if (this.hotKeyLoader == null) {
            return;
        }
        this.logWindowPopupMenu.removeAll();
        this.logWindowPopupMenu.add(this.hotKeyLoader.makeHotKeyMenu());
        FontAdjust.FontMenu menu = new FontAdjust.FontMenu("Generate scripts");
        this.logWindowPopupMenu.add(menu);
        this.addScriptMenu(menu, "Layout", new SetupScriptGenerator().getScript());
        if (Support.commandList.generateScript(false, false).size() > 0) {
            FontAdjust.FontMenu submenu = new FontAdjust.FontMenu("Mode & setup");
            menu.add(submenu);
            FontAdjust.FontMenuItem mi = new FontAdjust.FontMenuItem("In log window");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PaneCommand.this.listTextArea.setText(StringUtil.listToString(Support.commandList.generateScript(false, PaneCommand.this.menuScriptOptimize.isSelected()), "\n"));
                }
            });
            submenu.add(mi);
            mi = new FontAdjust.FontMenuItem("Save as menu");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PaneCommand.this.saveScript(Support.commandList.generateScript(true, PaneCommand.this.menuScriptOptimize.isSelected()), false, true, false);
                }
            });
            submenu.add(mi);
            mi = new FontAdjust.FontMenuItem("Save as menu and edit");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PaneCommand.this.saveScript(Support.commandList.generateScript(true, PaneCommand.this.menuScriptOptimize.isSelected()), false, true, true);
                }
            });
            submenu.add(mi);
            this.menuScriptOptimize = new FontAdjust.FontCheckBoxMenuItem("Optimize");
            this.menuScriptOptimize.setToolTipText("Will generate script to send command in parallel to the devices");
            submenu.add(this.menuScriptOptimize);
            mi = new FontAdjust.FontMenuItem("Clear saved commands");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Support.commandList.clearList();
                }
            });
            submenu.add(mi);
        }
        this.addScriptMenu(menu, "Grid Panel", PopupGridPanel.generateScript());
        this.addScriptMenu(menu, "Param sweeper", PopupParamSweeper.generateScript());
        this.addScriptMenu(menu, "Log Event as script", PopupLogEvent.generateLogScript());
        this.addScriptMenu(menu, "Chart layout", PopupChartLayout.generateScript());
        FontAdjust.FontMenuItem mi = new FontAdjust.FontMenuItem("Chart/Hist/Range script");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<String> list = new SetupScriptGenerator().getScaleScript();
                list.add(0, "; Configuration of chart, histogram and range, this script is typically place after a #log command");
                list.add(";");
                list.add("; Selection of curves only works when there is some table data");
                list.addAll(Support.paneChart.generateScript());
                list.add(";");
                list.addAll(Support.paneHistogram.generateScript());
                list.add(";");
                list.addAll(Support.paneRange.generateScript());
                PaneCommand.this.listTextArea.setText(StringUtil.listToString(list, "\n"));
            }
        });
        menu.add(mi);
        mi = new FontAdjust.FontMenuItem("Value formats");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<String> list = new SetupScriptGenerator().getValueFormatScript();
                PaneCommand.this.listTextArea.setText(StringUtil.listToString(list, "\n"));
            }
        });
        menu.add(mi);
        if (PopupImage.generateScript().size() > 0) {
            mi = new FontAdjust.FontMenuItem("Loaded images");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    List<String> list = PopupImage.generateScript();
                    PaneCommand.this.listTextArea.setText(StringUtil.listToString(list, "\n"));
                }
            });
            menu.add(mi);
        }
        if (Exporter.getExporter().generateScript().size() > 0) {
            mi = new FontAdjust.FontMenuItem("Export script");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    List<String> list = Exporter.getExporter().generateScript();
                    PaneCommand.this.listTextArea.setText(StringUtil.listToString(list, "\n"));
                }
            });
            menu.add(mi);
        }
        mi = new FontAdjust.FontMenuItem("List and manage scripts");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupScriptList.getPopup();
            }
        });
        menu.add(mi);
        mi = new FontAdjust.FontMenuItem("Open script directory");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaneCommand.this.scriptMenu.openDirectory();
            }
        });
        menu.add(mi);
        if (this.scriptMenu != null && this.scriptMenu.isScriptsLoaded()) {
            this.logWindowPopupMenu.addSeparator();
            this.scriptMenu.add(this.logWindowPopupMenu, "", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    ScriptMenu.ScriptEntry script = PaneCommand.this.scriptMenu.getScript(arg0.getActionCommand(), true);
                    if (script.isAutorun()) {
                        PaneCommand.this.buttonRun(script.getFilteredScript(), true);
                    } else {
                        PaneCommand.this.listTextArea.setText(script.getFilteredScript());
                        PaneCommand.this.listTextArea.setCaretPosition(0);
                    }
                }
            });
        }
    }

    private JPanel makeTopButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(8, 1, 5, 5));
        this.runButton = new FontAdjust.FontButton("Run");
        this.runButton.setEnabled(false);
        this.runButton.setToolTipText("Rerun the commands in the log window or restore the log window to the state before running it");
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PaneCommand.this.buttonRun(null, false);
            }
        });
        buttonPanel.add(this.runButton);
        this.loadButton = new FontAdjust.FontButton("Load and run");
        this.loadButton.setEnabled(false);
        this.loadButton.setToolTipText("Load a list of commands and run them");
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PaneCommand.this.buttonLoadAndRun();
            }
        });
        buttonPanel.add(this.loadButton);
        this.savePopupMenu = new JPopupMenu();
        FontAdjust.FontMenuItem mi = new FontAdjust.FontMenuItem("Save as log");
        mi.setActionCommand("SaveLog");
        mi.addActionListener(this.savePopupActionListener);
        this.savePopupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Save as script");
        mi.setActionCommand("SaveScript");
        mi.addActionListener(this.savePopupActionListener);
        this.savePopupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Save as menu");
        mi.setActionCommand("SaveMenu");
        mi.addActionListener(this.savePopupActionListener);
        this.savePopupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Save as menu and edit");
        mi.setActionCommand("SaveMenuEdit");
        mi.addActionListener(this.savePopupActionListener);
        this.savePopupMenu.add(mi);
        this.saveButton = new FontAdjust.FontButton("Save");
        this.saveButton.setEnabled(false);
        this.saveButton.setToolTipText("Save log window, all lines starting with ;; is removed first");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PaneCommand.this.savePopupMenu.show(PaneCommand.this.saveButton, -10, -50);
            }
        });
        buttonPanel.add(this.saveButton);
        this.cleanButton = new FontAdjust.FontButton("Clean");
        this.cleanButton.setEnabled(false);
        this.cleanButton.setToolTipText("Remove all lines starting with ;;");
        this.cleanButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PaneCommand.this.buttonClean();
            }
        });
        buttonPanel.add(this.cleanButton);
        this.clearButton = new FontAdjust.FontButton("Clear");
        this.clearButton.setEnabled(false);
        this.clearButton.setToolTipText("Clear the log window");
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PaneCommand.this.buttonClear();
            }
        });
        buttonPanel.add(this.clearButton);
        this.abortButton = new FontAdjust.FontButton("Abort");
        this.abortButton.setEnabled(false);
        this.abortButton.setToolTipText("Stop any running program or command");
        this.abortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PaneCommand.this.buttonAbort();
            }
        });
        buttonPanel.add(this.abortButton);
        this.logButton = new FontAdjust.FontButton("Log");
        this.logButton.setEnabled(false);
        this.logButton.setToolTipText("Start logging or stop logging");
        this.logButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (InterfaceThreads.isLogging()) {
                    CommandProcessor.sysCmdLog(0.0, null, false);
                } else {
                    PaneCommand.this.logPopupMenu.show(PaneCommand.this.logButton, -10, -50);
                }
            }
        });
        buttonPanel.add(this.logButton);
        this.logPopupMenu = new JPopupMenu();
        mi = new FontAdjust.FontMenuItem("0.01 sec");
        mi.setActionCommand("0.01");
        mi.addActionListener(this.logPopupActionListener);
        this.logPopupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("0.03 sec");
        mi.setActionCommand("0.03");
        mi.addActionListener(this.logPopupActionListener);
        this.logPopupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("0.1 sec");
        mi.setActionCommand("0.1");
        mi.addActionListener(this.logPopupActionListener);
        this.logPopupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("0.3 sec");
        mi.setActionCommand("0.3");
        mi.addActionListener(this.logPopupActionListener);
        this.logPopupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("1 sec");
        mi.setActionCommand("1");
        mi.addActionListener(this.logPopupActionListener);
        this.logPopupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("3 sec");
        mi.setActionCommand("3");
        mi.addActionListener(this.logPopupActionListener);
        this.logPopupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("10 sec");
        mi.setActionCommand("10");
        mi.addActionListener(this.logPopupActionListener);
        this.logPopupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Advanced");
        mi.setActionCommand("Advanced");
        mi.addActionListener(this.logPopupActionListener);
        this.logPopupMenu.add(mi);
        this.directToDiskMenuItem = new FontAdjust.FontMenuItem("Direct to disk");
        this.directToDiskMenuItem.setActionCommand("Save");
        this.directToDiskMenuItem.addActionListener(this.logPopupActionListener);
        this.logPopupMenu.add(this.directToDiskMenuItem);
        this.outputOffButton = new FontAdjust.FontButton("Outputs off");
        this.outputOffButton.setEnabled(false);
        this.outputOffButton.setToolTipText("Turn all outputs, loads, relays, etc. off (i.e. anything that can be turned off)");
        this.outputOffButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PaneCommand.this.buttonOutputOff();
            }
        });
        buttonPanel.add(this.outputOffButton);
        return buttonPanel;
    }

    private JPanel makeCommandPanel() {
        JPanel cmdPanel = new JPanel();
        cmdPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        Dimension d = new Dimension(820, 35);
        cmdPanel.setMinimumSize(d);
        cmdPanel.setPreferredSize(d);
        this.devicePopupMenu = new JPopupMenu();
        this.deviceLabel = new FontAdjust.FontLabel();
        this.deviceLabel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.deviceLabel.addMouseListener(new MouseAdapter(){

            private void showPopupMenu() {
                PaneCommand.this.devicePopupMenu.removeAll();
                for (InterfaceThreads.DeviceThread dt : InterfaceThreads.getDevices()) {
                    FontAdjust.FontMenuItem mi = new FontAdjust.FontMenuItem(dt.getHandleName());
                    mi.setActionCommand(dt.getHandleName());
                    mi.addActionListener(PaneCommand.this.devicePopupActionListener);
                    PaneCommand.this.devicePopupMenu.add(mi);
                }
                PaneCommand.this.devicePopupMenu.show(PaneCommand.this.deviceLabel, 30, -30);
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
                if (arg0.isPopupTrigger()) {
                    this.showPopupMenu();
                }
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
                if (arg0.isPopupTrigger()) {
                    this.showPopupMenu();
                }
            }
        });
        this.deviceLabel.setHorizontalAlignment(4);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 0.05;
        cmdPanel.add((Component)this.deviceLabel, c);
        d = new Dimension(600, 30);
        this.commandTextField = new FontAdjust.FontTextField();
        this.commandTextField.setToolTipText("<html>Up/Down for command history<br>Shift-Up/Down to search history.<br>INS to insert command/variable from a list<br>Ctrl-INS to insert currently selected device handle");
        this.commandTextField.setMinimumSize(d);
        this.commandTextField.setPreferredSize(d);
        this.commandTextField.setEnabled(false);
        this.commandTextField.addKeyListener(new KeyListener(){

            private void cmdSearch(int dir) {
                int j = PaneCommand.this.lastCommandsIndex;
                if (PaneCommand.this.lastCommandsSearch == null || PaneCommand.this.lastCommands.size() == 0) {
                    PaneCommand.this.lastCommandsSearch = PaneCommand.this.commandTextField.getText().trim().toLowerCase();
                    if (PaneCommand.this.lastCommandsIndex == -1) {
                        PaneCommand.this.lastCommandsIndex = dir < 0 ? PaneCommand.this.lastCommands.size() - 1 : 0;
                    }
                    j = PaneCommand.this.lastCommandsIndex - dir;
                }
                int i = 0;
                while (i < PaneCommand.this.lastCommands.size()) {
                    if ((j += dir) < 0) {
                        j = PaneCommand.this.lastCommands.size() - 1;
                    }
                    if (j >= PaneCommand.this.lastCommands.size()) {
                        j = 0;
                    }
                    if (((String)PaneCommand.this.lastCommands.get(j)).toLowerCase().contains(PaneCommand.this.lastCommandsSearch)) {
                        PaneCommand.this.commandTextField.setText((String)PaneCommand.this.lastCommands.get(j));
                        PaneCommand.this.lastCommandsIndex = j;
                        return;
                    }
                    ++i;
                }
            }

            private void cmdRoll(int dir) {
                if (PaneCommand.this.lastCommands.size() == 0) {
                    return;
                }
                if (PaneCommand.this.lastCommandsIndex == -1) {
                    PaneCommand.this.lastCommandsIndex = dir < 0 ? PaneCommand.this.lastCommands.size() - 1 : 0;
                }
                PaneCommand.this.commandTextField.setText((String)PaneCommand.this.lastCommands.get(PaneCommand.this.lastCommandsIndex));
                PaneCommand paneCommand = PaneCommand.this;
                paneCommand.lastCommandsIndex = paneCommand.lastCommandsIndex + dir;
                if (PaneCommand.this.lastCommandsIndex < 0) {
                    PaneCommand.this.lastCommandsIndex = PaneCommand.this.lastCommands.size() - 1;
                }
                if (PaneCommand.this.lastCommandsIndex >= PaneCommand.this.lastCommands.size()) {
                    PaneCommand.this.lastCommandsIndex = 0;
                }
            }

            private void clearSearch() {
                PaneCommand.this.lastCommandsSearch = null;
                PaneCommand.this.lastCommandsIndex = -1;
            }

            @Override
            public void keyPressed(KeyEvent event) {
                if (PaneCommand.this.devicePopupMenu.isVisible()) {
                    PaneCommand.this.devicePopupMenu.setVisible(false);
                }
                if (event.getKeyCode() == 8 || event.getKeyCode() == 127) {
                    this.clearSearch();
                }
                if (!(event.isShiftDown() || event.isAltDown() || event.isControlDown())) {
                    if (event.getKeyCode() == 155 || event.getKeyCode() == 525) {
                        PaneCommand.this.showPopupMenu();
                    }
                    if (event.getKeyCode() == 40) {
                        this.cmdRoll(-1);
                    }
                    if (event.getKeyCode() == 38) {
                        this.cmdRoll(1);
                    }
                } else if (event.isShiftDown() && !event.isAltDown() && !event.isControlDown()) {
                    if (event.getKeyCode() == 40) {
                        this.cmdSearch(-1);
                    }
                    if (event.getKeyCode() == 38) {
                        this.cmdSearch(1);
                    }
                }
                if (event.isControlDown() && !event.isShiftDown() && !event.isAltDown() && event.getKeyCode() == 155) {
                    int pos = PaneCommand.this.commandTextField.getCaretPosition();
                    String txt = PaneCommand.this.commandTextField.getText();
                    txt = String.valueOf(txt.substring(0, pos)) + Support.cmdEnvironment.getDeviceHandle() + txt.substring(pos);
                    PaneCommand.this.commandTextField.setText(txt);
                    PaneCommand.this.commandTextField.setCaretPosition(pos + Support.cmdEnvironment.getDeviceHandle().length());
                }
                ((PaneCommand)PaneCommand.this).hotKeyLoader.keyAdapter.keyPressed(event);
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent event) {
                if (event.getKeyChar() >= ' ' || event.getKeyChar() == '\n') {
                    this.clearSearch();
                }
                if (event.getKeyChar() == '\u0012') {
                    this.cmdSearch(1);
                }
                if (event.getKeyChar() == '\n') {
                    PaneCommand.this.processCommand(PaneCommand.this.commandTextField.getText().toString());
                }
                PaneCommand.this.processHelp();
            }
        });
        this.commandTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent arg0) {
                if (arg0.isPopupTrigger()) {
                    PaneCommand.this.showPopupMenu();
                }
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
                if (arg0.isPopupTrigger()) {
                    PaneCommand.this.showPopupMenu();
                }
            }
        });
        this.commandTextField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent arg0) {
                PaneCommand.this.processHelp();
            }
        });
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 0.9;
        cmdPanel.add((Component)this.commandTextField, c);
        this.commandPopupMenu = new JPopupMenu();
        return cmdPanel;
    }

    public JComponent makeBottomPanel() {
        this.helpTextArea = new FontAdjust.FontTextArea();
        this.helpTextArea.setEditable(false);
        this.helpTextArea.setLineWrap(true);
        this.helpTextArea.setToolTipText("Possible commands and help for them is shown here");
        this.helpTextArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int v = PaneCommand.this.helpTextArea.viewToModel(e.getPoint());
                    try {
                        int l = PaneCommand.this.helpTextArea.getLineOfOffset(v);
                        int l1 = PaneCommand.this.helpTextArea.getLineStartOffset(l);
                        int l2 = PaneCommand.this.helpTextArea.getLineEndOffset(l);
                        String line = PaneCommand.this.helpTextArea.getText(l1, l2 - l1);
                        if (line.length() > 0 && !Character.isWhitespace(line.charAt(0))) {
                            int i = line.indexOf(32);
                            if (i > 0) {
                                line = line.substring(0, i);
                            }
                            PaneCommand.this.menuActionListener.typeCommand(line.trim());
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
        });
        JScrollPane scroll2 = new JScrollPane(this.helpTextArea);
        return scroll2;
    }

    private JPanel makeBottomButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(4, 1, 5, 5));
        this.modeButton = new FontAdjust.FontButton("Mode");
        this.modeButton.setEnabled(false);
        this.modeButton.setToolTipText("A panel with buttons to change modes (Mostly used for multimeters)");
        this.modeButton.addMouseListener(new MouseAdapter(){

            void popup(MouseEvent me) {
                if (me.isPopupTrigger()) {
                    PaneCommand.this.showModeSelectionMenu();
                }
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
                this.popup(arg0);
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
                this.popup(arg0);
            }
        });
        this.modeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PaneCommand.this.showModeSelectionPopup();
            }
        });
        buttonPanel.add(this.modeButton);
        this.setupButton = new FontAdjust.FontButton("Setup");
        this.setupButton.setEnabled(false);
        this.setupButton.setToolTipText("A panel to adjust some settings on the device, use for loads, power supplies, generators etc.");
        buttonPanel.add(this.setupButton);
        this.setupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PaneCommand.this.showSetupSelectionPopup();
            }
        });
        this.otherButton = new FontAdjust.FontButton("Other");
        this.otherButton.setVisible(false);
        this.otherButton.setToolTipText("Functions like screendump and download of data");
        buttonPanel.add(this.otherButton);
        this.otherPopupMenu = new JPopupMenu();
        this.otherButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PaneCommand.this.otherPopupMenu.removeAll();
                InterfaceThreads.DeviceThread dt = InterfaceThreads.deviceMap.get(Support.cmdEnvironment.getDeviceHandle().toUpperCase().trim());
                if (dt != null) {
                    dt.getDeviceInterface().otherPreparePopup(PaneCommand.this.otherPopupMenu);
                    PaneCommand.this.otherPopupMenu.show(PaneCommand.this.otherButton, 10, -30);
                }
            }
        });
        this.versionLabel = new FontAdjust.FontLabel("");
        this.versionLabel.setVisible(false);
        this.versionLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                PopupNotes notes = new PopupNotes("Version changes", PaneCommand.this.versionList);
                notes.setLocationRelativeTo(PaneCommand.this.versionLabel);
                notes.setVisible(true);
            }
        });
        buttonPanel.add(this.versionLabel);
        return buttonPanel;
    }

    private JComponent makeAllButton() {
        JPanel panel = new JPanel();
        this.popupsButton = new FontAdjust.FontButton("Popups");
        this.popupsButton.setToolTipText("Show & control popups, right-click to bring popups to front");
        this.popupsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaneCommand.this.popupPopupMenu.show(PaneCommand.this.popupsButton, -80, -200);
            }
        });
        this.popupsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    PaneCommand.this.focusPopups();
                }
            }
        });
        this.popupsButton.setEnabled(false);
        panel.add(this.popupsButton);
        this.popupPopupMenu = new JPopupMenu();
        FontAdjust.FontMenu ms = new FontAdjust.FontMenu("Device...");
        this.popupPopupMenu.add(ms);
        FontAdjust.FontMenuItem mi = new FontAdjust.FontMenuItem("Show all mode popups");
        mi.addActionListener(this.allButtonActionListener);
        mi.setActionCommand("AllMode");
        ms.add(mi);
        mi = new FontAdjust.FontMenuItem("Show all setup popups");
        mi.addActionListener(this.allButtonActionListener);
        mi.setActionCommand("AllSetup");
        ms.add(mi);
        mi = new FontAdjust.FontMenuItem("Show all device popups");
        mi.addActionListener(this.allButtonActionListener);
        mi.setActionCommand("All");
        ms.add(mi);
        mi = new FontAdjust.FontMenuItem("Close all popups");
        mi.addActionListener(this.allButtonActionListener);
        mi.setActionCommand("CloseAll");
        ms.add(mi);
        mi = new FontAdjust.FontMenuItem("Force all open device popups to on top state");
        mi.addActionListener(this.allButtonActionListener);
        mi.setActionCommand("OnTop");
        ms.add(mi);
        mi = new FontAdjust.FontMenuItem("Remove on top from all open device popups");
        mi.addActionListener(this.allButtonActionListener);
        mi.setActionCommand("NoTop");
        ms.add(mi);
        mi = new FontAdjust.FontMenuItem("List all connected devices");
        mi.setToolTipText("Used to document devices used for a test");
        mi.addActionListener(this.allButtonActionListener);
        mi.setActionCommand("List");
        ms.add(mi);
        mi = new FontAdjust.FontMenuItem("Test interface for currently selected device");
        mi.setToolTipText("Used to verify the #interface functions of a device");
        mi.addActionListener(this.allButtonActionListener);
        mi.setActionCommand("TestInterface");
        ms.add(mi);
        mi = new FontAdjust.FontMenuItem("Calculator");
        mi.setToolTipText("A general purpose calculator");
        mi.addActionListener(this.allButtonActionListener);
        mi.setActionCommand("Calc");
        this.popupPopupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Timer");
        mi.setToolTipText("A general purpose stop watch to manually time events");
        mi.addActionListener(this.allButtonActionListener);
        mi.setActionCommand("Timer");
        this.popupPopupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Readout");
        mi.setToolTipText("Customable readouts, can show small or large digits in any color");
        mi.addActionListener(this.allButtonActionListener);
        mi.setActionCommand("Readout");
        this.popupPopupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Adjust scale");
        mi.setToolTipText("A analog and digital scale designed to assist when adjusting a parameter");
        mi.addActionListener(this.allButtonActionListener);
        mi.setActionCommand("AdjustScale");
        this.popupPopupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Param adjuster");
        mi.setToolTipText("A analog slider that can adjust any device value from the setup popups");
        mi.addActionListener(this.allButtonActionListener);
        mi.setActionCommand("ParamAdjuster");
        this.popupPopupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Param sweeper");
        mi.setToolTipText("Automatic test function that can step/slide between values, support automatic adjusting up to 3 values");
        mi.addActionListener(this.allButtonActionListener);
        mi.setActionCommand("ParamSweeper");
        this.popupPopupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Grid panel");
        mi.setToolTipText("Customable user display, a grid can be configured with many types of readouts and controls");
        mi.addActionListener(this.allButtonActionListener);
        mi.setActionCommand("GridPanel");
        this.popupPopupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Auto hold");
        mi.setToolTipText("Will lock its readout and optionally type value into another program each time a value is stable");
        mi.addActionListener(this.allButtonActionListener);
        mi.setActionCommand("AutoHold");
        this.popupPopupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Timer Counter");
        mi.setToolTipText("Count events and time between events");
        mi.addActionListener(this.allButtonActionListener);
        mi.setActionCommand("TimerCounter");
        this.popupPopupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Alarm");
        mi.setToolTipText("A audio/visual alarm that be used on values or end of tests");
        mi.addActionListener(this.allButtonActionListener);
        mi.setActionCommand("Alarm");
        this.popupPopupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Image viewer");
        mi.setToolTipText("A image viewer, can show jpg/png files. Schematics etc. can be loaded from scripts");
        mi.addActionListener(this.allButtonActionListener);
        mi.setActionCommand("image");
        this.popupPopupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Log event");
        mi.setToolTipText("Automatic test function that will log for a fixed time or until a specified value");
        mi.addActionListener(this.allButtonActionListener);
        mi.setActionCommand("LogEvent");
        this.popupPopupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Log trigger");
        mi.setToolTipText("Used with some of the advanced log functions to manuelly trigger logging");
        mi.addActionListener(this.allButtonActionListener);
        mi.setActionCommand("LogTrigger");
        this.popupPopupMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("FFT View");
        mi.setToolTipText("Show table data in a frequency view (FFT)");
        mi.addActionListener(this.allButtonActionListener);
        mi.setActionCommand("FFTView");
        this.popupPopupMenu.add(mi);
        if (Support.devlop) {
            mi = new FontAdjust.FontMenuItem("MPPT");
            mi.setToolTipText("Adjust a electronic load for max. power transfer");
            mi.addActionListener(this.allButtonActionListener);
            mi.setActionCommand("MPPT");
            this.popupPopupMenu.add(mi);
        }
        if (Support.devlop) {
            mi = new FontAdjust.FontMenuItem("Camera");
            mi.setToolTipText("Use a camera for reading numbers from a device");
            mi.addActionListener(this.allButtonActionListener);
            mi.setActionCommand("Camera");
            this.popupPopupMenu.add(mi);
        }
        mi = new FontAdjust.FontMenuItem("Auto adjust");
        mi.setToolTipText("Automatic adjust a parameter for min, max or value");
        mi.addActionListener(this.allButtonActionListener);
        mi.setActionCommand("AutoAdjust");
        this.popupPopupMenu.add(mi);
        return panel;
    }

    public PopupReadout showReadoutPopup() {
        Point p = this.popupsButton.getLocationOnScreen();
        p.translate(-200, -100);
        PopupReadout pr = new PopupReadout();
        pr.setLocation(p);
        pr.setVisible(true);
        return pr;
    }

    public PopupAlarm showAlarmPopup() {
        Point p = this.popupsButton.getLocationOnScreen();
        p.translate(-750, -450);
        PopupAlarm pa = new PopupAlarm();
        pa.setLocation(p);
        pa.setVisible(true);
        return pa;
    }

    public PopupLogEvent showLogEvent() {
        Point p = this.popupsButton.getLocationOnScreen();
        p.translate(-150, -150);
        PopupLogEvent ple = PopupLogEvent.getPopup();
        ple.setLocation(p);
        ple.setVisible(true);
        return ple;
    }

    public PopupLogTrigger showLogTriggerPopup() {
        Point p = this.popupsButton.getLocationOnScreen();
        p.translate(-200, -100);
        PopupLogTrigger plt = new PopupLogTrigger();
        plt.setLocation(p);
        plt.setVisible(true);
        return plt;
    }

    @Override
    public JPanel getPanel() {
        GridBagLayout layout = new GridBagLayout();
        JPanel mainPanel = new JPanel(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 19;
        mainPanel.add((Component)this.makeListPanel(), c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 19;
        mainPanel.add((Component)this.makeTopButtonPanel(), c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 17;
        mainPanel.add((Component)this.makeCommandPanel(), c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.insets = new Insets(5, 5, 5, 5);
        mainPanel.add((Component)this.makeAllButton(), c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.fill = 1;
        c.anchor = 11;
        mainPanel.add((Component)this.makeBottomPanel(), c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 11;
        mainPanel.add((Component)this.makeBottomButtonPanel(), c);
        this.hotKeyLoader.assign();
        Support.colorScheme.setTextBackground(this.commandTextField.getBackground());
        return mainPanel;
    }

    private void showAllPopups(boolean mode, boolean setup) {
        for (InterfaceThreads.DeviceThread dt : InterfaceThreads.getDevices()) {
            if (mode) {
                dt.getDeviceInterface().showModesPopup(this.modeButton);
            }
            if (!setup) continue;
            dt.getDeviceInterface().showSetupPopup(this.modeButton);
        }
    }

    private void showPopupMenu() {
        if (this.devicePopupMenu.isVisible()) {
            this.devicePopupMenu.setVisible(false);
        }
        this.commandPopupMenu.removeAll();
        int n = 0;
        FontAdjust.FontMenuItem mi = null;
        String s = this.commandTextField.getText();
        if (s.length() >= 1 && s.charAt(0) == '=' || Support.cmdEnvironment.commandLineCalcMode) {
            for (String ss : InterfaceThreads.listChannels(true)) {
                mi = new FontAdjust.FontMenuItem(ss);
                mi.addActionListener(this.menuActionListener);
                ++n;
                this.commandPopupMenu.add(mi);
            }
        } else {
            for (String item : this.currentHelpList) {
                if (item.length() <= 0 || Character.isWhitespace(item.charAt(0))) continue;
                int i = item.indexOf(32);
                if (i > 0) {
                    item = item.substring(0, i);
                }
                mi = new FontAdjust.FontMenuItem(item);
                mi.addActionListener(this.menuActionListener);
                ++n;
                this.commandPopupMenu.add(mi);
            }
        }
        if (n == 0) {
            return;
        }
        if (n == 1) {
            this.menuActionListener.typeCommand(mi.getText());
        } else {
            this.commandPopupMenu.show(this.commandTextField, 0, 0);
        }
    }

    private void processHelp() {
        InterfaceThreads.DeviceThread dt;
        String cmdLine = this.commandTextField.getText();
        if (cmdLine.equals(this.lastCommandLine)) {
            return;
        }
        this.lastCommandLine = cmdLine;
        String helpFilter = cmdLine;
        int i = helpFilter.indexOf(32);
        if (i > 0) {
            helpFilter = helpFilter.substring(0, i + 1);
        }
        if (cmdLine.startsWith("#") || cmdLine.startsWith("=")) {
            this.currentHelpList = HelpLoader.filterList(Support.systemCommands, helpFilter);
            this.helpTextArea.setText(StringUtil.listToString(this.currentHelpList, "\r\n"));
            this.helpTextArea.setCaretPosition(0);
            return;
        }
        if (Support.cmdEnvironment.getDeviceHandle().length() == 0 && cmdLine.indexOf(58) < 0) {
            List<String> list = InterfaceThreads.listDevices();
            list = HelpLoader.filterList(list, helpFilter);
            this.currentHelpList = list;
            if (cmdLine.length() == 0) {
                this.currentHelpList.add("#...");
                this.currentHelpList.add("=");
            }
            this.helpTextArea.setText(StringUtil.listToString(this.currentHelpList, "\r\n"));
            return;
        }
        if (cmdLine.indexOf(58) < 0) {
            List<String> list = InterfaceThreads.listDevices();
            list = HelpLoader.filterList(list, helpFilter);
            this.currentHelpList = list;
        } else {
            this.currentHelpList = new ArrayList<String>();
        }
        String cd = Support.cmdEnvironment.getDeviceHandle();
        int c = cmdLine.indexOf(58);
        if (c > 0) {
            cd = cmdLine.substring(0, c).trim();
        }
        if ((dt = InterfaceThreads.deviceMap.get(cd.toUpperCase().trim())) != null) {
            String line = cmdLine.substring(c + 1);
            int ii = line.indexOf(32);
            if (ii > 0) {
                line = line.substring(0, ii + 1);
            }
            List<String> list = dt.supportedCommands();
            list = HelpLoader.filterList(list, line);
            this.currentHelpList.addAll(list);
            if (cmdLine.length() == 0) {
                this.currentHelpList.add("#...");
                this.currentHelpList.add("=");
            }
        } else {
            this.helpTextArea.setText("Unknown command");
        }
        this.helpTextArea.setText(StringUtil.listToString(this.currentHelpList, "\r\n"));
        this.helpTextArea.setCaretPosition(0);
    }

    private void processCommand(String cmds) {
        try {
            if (CommandProcessor.processCommands(Support.cmdEnvironment, cmds)) {
                this.deviceLabel.setText(Support.cmdEnvironment.getDeviceHandleLabel());
                if (cmds.trim().length() > 0) {
                    this.lastCommands.add(0, cmds);
                    while (this.lastCommands.size() > 100) {
                        this.lastCommands.remove(100);
                    }
                }
                this.commandTextField.setText("");
            }
            this.commandTextField.setBackground(Support.colorScheme.textBackground);
        }
        catch (Exception e) {
            if (InterfaceThreads.debugAll) {
                e.printStackTrace(System.out);
            }
            this.commandTextField.setBackground(Support.colorScheme.errorBackground);
        }
    }

    private void logDirect(String line) {
        if (line != null && line.trim().length() > 0) {
            this.listTextArea.append(String.valueOf(line) + "\r\n");
        }
    }

    void removeDoubleComments(List<String> list) {
        int i = list.size() - 1;
        while (i >= 0) {
            if (list.get(i).startsWith(";;")) {
                list.remove(i);
            }
            --i;
        }
    }

    void buttonClean() {
        CommandProcessor.clearRestore();
        this.savedProgram = null;
        List<String> list = this.getLogText();
        this.removeDoubleComments(list);
        this.listTextArea.setText(StringUtil.listToString(list, "\r\n"));
    }

    void buttonRun(String pgm, boolean force) {
        if (CommandProcessor.isBackground()) {
            return;
        }
        if (force) {
            CommandProcessor.clearRestore();
            List<String> list = StringUtil.stringToList(pgm, "\n");
            this.removeDoubleComments(list);
            Support.addUsedFunction("scriptMenu");
            CommandProcessor.runBackground(list, false);
        } else if (this.runButton.getText().equalsIgnoreCase("Run")) {
            this.savedProgram = this.listTextArea.getText();
            CommandProcessor.clearRestore();
            List<String> list = StringUtil.stringToList(pgm == null ? this.listTextArea.getText() : pgm, "\n");
            this.removeDoubleComments(list);
            this.listTextArea.setText("");
            Support.addUsedFunction("script");
            CommandProcessor.runBackground(list, true);
        } else {
            this.listTextArea.setText(this.savedProgram);
            this.savedProgram = null;
            CommandProcessor.clearRestore();
        }
    }

    void buttonLoadAndRun() {
        this.savedProgram = this.listTextArea.getText();
        List<String> list = null;
        FontAdjust.FontFileChooser fileChooser = new FontAdjust.FontFileChooser();
        fileChooser.setFileFilter(new FileNameExtensionFilter("TXT", "txt"));
        fileChooser.setAcceptAllFileFilterUsed(true);
        try {
            fileChooser.setCurrentDirectory(new File(Support.getDataPath()));
        }
        catch (Exception exception) {
            System.out.println("Failed to set director: " + Support.getDataPath());
        }
        if (fileChooser.showOpenDialog(this.listTextArea) == 0) {
            File file = fileChooser.getSelectedFile();
            try {
                Support.setDataPath(fileChooser.getCurrentDirectory().getPath());
                list = FileUtil.readFileAsList(file);
                ScriptMenu.showImage(list);
                int i = 0;
                while (i < Math.min(10, list.size())) {
                    if (list.get(i).toLowerCase().startsWith("#autorun")) {
                        CommandProcessor.runBackground(list, false);
                        return;
                    }
                    ++i;
                }
                this.listTextArea.setText(StringUtil.listToString(list, "\n"));
            }
            catch (IOException iOException) {}
        }
    }

    void buttonSave(boolean log) {
        FontAdjust.FontFileChooser fileChooser = new FontAdjust.FontFileChooser();
        try {
            fileChooser.setCurrentDirectory(new File(Support.getDataPath()));
        }
        catch (Exception exception) {
            System.out.println("Failed to set director: " + Support.getDataPath());
        }
        fileChooser.setFileFilter(log ? new FileNameExtensionFilter("LOG", "log") : new FileNameExtensionFilter("TXT", "txt"));
        fileChooser.setAcceptAllFileFilterUsed(true);
        while (true) {
            int option = 0;
            if (fileChooser.showSaveDialog(this.listTextArea) != 0) break;
            File file = Support.fileWithOptinalDefaults(fileChooser.getSelectedFile().getAbsolutePath(), null, log ? ".log" : ".txt");
            if (file.exists() && (option = JOptionPane.showConfirmDialog(null, "File exists, overwrite?", "File exists", 1)) == 2) {
                return;
            }
            if (option != 0) continue;
            List<String> list = StringUtil.stringToList(this.listTextArea.getText(), "\n");
            if (!log) {
                this.removeDoubleComments(list);
            }
            try {
                FileUtil.writeFile(file, list);
                Support.setDataPath(fileChooser.getCurrentDirectory().getPath());
                return;
            }
            catch (IOException e) {
                e.printStackTrace(System.out);
                continue;
            }
            break;
        }
    }

    private void LogToDisk() {
        block20: {
            double interval;
            File file;
            int option;
            FontAdjust.FontFileChooser fileChooser = new FontAdjust.FontFileChooser();
            try {
                fileChooser.setCurrentDirectory(new File(Support.getDataPath()));
            }
            catch (Exception exception) {
                System.out.println("Failed to set director: " + Support.getDataPath());
            }
            DataBase.FileFormat ff = Support.dataBase.getFileFormat();
            fileChooser.setDialogTitle("Log directly to disk");
            JPanel savePanel = new JPanel();
            BoxLayout bl = new BoxLayout(savePanel, 3);
            savePanel.setLayout(bl);
            JPanel textPanel = new JPanel();
            savePanel.add(textPanel);
            textPanel.add(new JLabel("Interval: "));
            final FontAdjust.FontTextField intervalText = new FontAdjust.FontTextField(6);
            intervalText.setText("1.0");
            intervalText.setToolTipText("Logging interval in seconds, range is 0.01 to 3600");
            intervalText.selectAll();
            intervalText.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent arg0) {
                }

                @Override
                public void focusLost(FocusEvent arg0) {
                    try {
                        Double t = Double.parseDouble(intervalText.getText().replace(',', '.'));
                        if (t < 0.01 || t > 3600.0) {
                            intervalText.setBackground(Support.colorScheme.errorBackground);
                        } else {
                            intervalText.setBackground(Support.colorScheme.textBackground);
                        }
                    }
                    catch (Exception exception) {
                        intervalText.setBackground(Support.colorScheme.errorBackground);
                    }
                }
            });
            intervalText.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Double t = Double.parseDouble(intervalText.getText());
                        if (t < 0.01 || t > 3600.0) {
                            intervalText.setBackground(Support.colorScheme.errorBackground);
                        } else {
                            intervalText.setBackground(Support.colorScheme.textBackground);
                        }
                    }
                    catch (Exception exception) {
                        intervalText.setBackground(Support.colorScheme.errorBackground);
                    }
                }
            });
            textPanel.add(intervalText);
            FontAdjust.FontButton advancedButton = new FontAdjust.FontButton("Advanced");
            advancedButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PopupAdvancedLog al = new PopupAdvancedLog(true);
                    al.setLocation(((PaneCommand)PaneCommand.this).logButton.getLocationOnScreen().x - 250, ((PaneCommand)PaneCommand.this).logButton.getLocationOnScreen().y - 100);
                    al.setVisible(true);
                }
            });
            savePanel.add(advancedButton);
            savePanel.add(Box.createVerticalStrut(50));
            ButtonGroup bg = new ButtonGroup();
            FontAdjust.FontRadioButton formatTabRadioButton = new FontAdjust.FontRadioButton("TAB format");
            bg.add(formatTabRadioButton);
            savePanel.add(formatTabRadioButton);
            FontAdjust.FontRadioButton formatCTabRadioButton = new FontAdjust.FontRadioButton("CTAB format");
            formatCTabRadioButton.setToolTipText("Use tab delimeter with comma as decimal point");
            bg.add(formatCTabRadioButton);
            savePanel.add(formatCTabRadioButton);
            FontAdjust.FontRadioButton formatUsRadioButton = new FontAdjust.FontRadioButton(". , format");
            bg.add(formatUsRadioButton);
            savePanel.add(formatUsRadioButton);
            FontAdjust.FontRadioButton formatEuRadioButton = new FontAdjust.FontRadioButton(", ; format");
            bg.add(formatEuRadioButton);
            savePanel.add(formatEuRadioButton);
            if (ff == DataBase.FileFormat.tab) {
                formatTabRadioButton.setSelected(true);
            } else if (ff == DataBase.FileFormat.ctab) {
                formatCTabRadioButton.setSelected(true);
            } else if (ff == DataBase.FileFormat.us) {
                formatUsRadioButton.setSelected(true);
            } else {
                formatEuRadioButton.setSelected(true);
            }
            fileChooser.setAccessory(savePanel);
            fileChooser.setFileFilter(new FileNameExtensionFilter("CSV", "csv"));
            fileChooser.setAcceptAllFileFilterUsed(true);
            do {
                option = 0;
                if (fileChooser.showSaveDialog(this.logButton) != 0) break block20;
                file = fileChooser.getSelectedFile();
                if (!file.getName().contains(".")) {
                    file = new File(String.valueOf(file.getPath()) + ".csv");
                }
                interval = 1.0;
                try {
                    interval = Double.parseDouble(intervalText.getText().replace(',', '.'));
                    if (interval < 0.01 || interval > 3600.0) {
                        option = 1;
                    }
                }
                catch (Exception exception) {
                    option = 1;
                }
                if (option != 0 || !file.exists() || (option = JOptionPane.showConfirmDialog(null, "File exists, overwrite?", "File exists", 1)) != 2) continue;
                return;
            } while (option != 0);
            if (formatTabRadioButton.isSelected()) {
                Support.dataBase.setFileFormat(DataBase.FileFormat.tab);
            } else if (formatCTabRadioButton.isSelected()) {
                Support.dataBase.setFileFormat(DataBase.FileFormat.ctab);
            } else if (formatUsRadioButton.isSelected()) {
                Support.dataBase.setFileFormat(DataBase.FileFormat.us);
            } else if (formatEuRadioButton.isSelected()) {
                Support.dataBase.setFileFormat(DataBase.FileFormat.euro);
            }
            CommandProcessor.sysCmdLog(interval, file.getAbsolutePath(), false);
            Support.setDataPath(fileChooser.getCurrentDirectory().getPath());
            return;
        }
    }

    public void clearLogWindow() {
        this.listTextArea.setText("");
    }

    void buttonClear() {
        CommandProcessor.clearRestore();
        this.savedProgram = null;
        this.listTextArea.setText("");
    }

    void buttonAbort() {
        CommandProcessor.stopBackground();
        AudibleAlarm.stopAllSound();
        PopupParamSweeper.abort();
    }

    void buttonLog(double interval) {
        if (InterfaceThreads.isLogging()) {
            CommandProcessor.sysCmdLog(0.0, null, false);
        } else {
            CommandProcessor.sysCmdLog(interval, null, false);
        }
    }

    public void buttonOutputOff() {
        CommandProcessor.stopBackground();
        CommandProcessor.sysCmdOutputOff();
    }

    @Override
    public void select() {
        if (InterfaceThreads.getDevices() != null) {
            this.timer2.start();
        }
        this.commandTextField.requestFocusInWindow();
    }

    @Override
    public void deselect() {
        this.timer2.stop();
    }

    public void showModeSelectionMenu() {
        InterfaceThreads.DeviceThread dt = InterfaceThreads.deviceMap.get(Support.cmdEnvironment.getDeviceHandle().toUpperCase().trim());
        if (dt != null) {
            dt.getDeviceInterface().showModesMenu(this.modeButton);
        }
    }

    public void showModeSelectionPopup() {
        InterfaceThreads.DeviceThread dt = InterfaceThreads.deviceMap.get(Support.cmdEnvironment.getDeviceHandle().toUpperCase().trim());
        if (dt != null) {
            dt.getDeviceInterface().showModesPopup(this.modeButton);
        }
    }

    public void showSetupSelectionPopup() {
        InterfaceThreads.DeviceThread dt = InterfaceThreads.deviceMap.get(Support.cmdEnvironment.getDeviceHandle().toUpperCase().trim());
        if (dt != null) {
            dt.getDeviceInterface().showSetupPopup(this.modeButton);
        }
    }

    private class DeviceOutputCheck
    extends Thread {
        private DeviceOutputCheck() {
        }

        @Override
        public void run() {
            this.setName("Input to log mover");
            String s = "";
            while (true) {
                try {
                    while (true) {
                        if (InterfaceThreads.getDevices() != null && !InterfaceThreads.inInitialization()) {
                            for (InterfaceThreads.DeviceThread dt : InterfaceThreads.getDevices()) {
                                while ((s = dt.cPort.anyRead()) != null) {
                                    InterfaceThreads.log(";;" + s);
                                }
                            }
                        }
                        Thread.sleep(50L);
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    }

    class MenuActionListener
    implements ActionListener {
        MenuActionListener() {
        }

        private boolean isPart(String cmd, char c) {
            cmd = cmd.toUpperCase();
            int i = 0;
            while (i < cmd.length()) {
                if (cmd.charAt(i) == Character.toUpperCase(c)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public void typeCommand(String cmd) {
            int i = PaneCommand.this.commandTextField.getCaretPosition();
            String cmdLine = PaneCommand.this.commandTextField.getText();
            boolean calc = cmdLine.length() >= 1 && cmdLine.charAt(0) == '=' || Support.cmdEnvironment.commandLineCalcMode;
            int j = i - 1;
            if (!calc) {
                while (j >= 0 && this.isPart(cmd, cmdLine.charAt(j))) {
                    --j;
                }
            }
            cmdLine = String.valueOf(cmdLine.substring(0, j + 1)) + cmd + cmdLine.substring(i);
            PaneCommand.this.commandTextField.setText(cmdLine);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.typeCommand(((FontAdjust.FontMenuItem)e.getSource()).getText());
        }
    }
}

