/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.database.DataBase;
import dk.hkj.database.DataRow;
import dk.hkj.main.ChartAnnotations;
import dk.hkj.main.ChartSaveResolutionPanel;
import dk.hkj.main.ChartScales;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.Main;
import dk.hkj.main.MyLogarithmicAxis;
import dk.hkj.main.PopupChartLayout;
import dk.hkj.main.PopupValues;
import dk.hkj.main.Support;
import dk.hkj.main.ValueFormat;
import dk.hkj.util.MathUtil;
import dk.hkj.util.MySwingUtil;
import dk.hkj.util.StringUtil;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYLineAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.Range;
import org.jfree.data.xy.DefaultXYDataset;

public class PaneChart
implements Main.PaneInterface {
    private final int MAX_CURVES = 8;
    private final int MAX_DATAPOINTS = 5000;
    private ChartPanel chartPanel;
    private JFreeChart chart;
    private JPanel checkboxPanel;
    private List<JCheckBox> checkBoxList = new ArrayList<JCheckBox>();
    public Support.StringList checkedColumns = new Support.StringList();
    private JButton toExportButton = null;
    private int domainColumn = 0;
    private int timeColumn = 0;
    private List<CurveIndex> curveIndexs = new ArrayList<CurveIndex>();
    private List<String> maskNames = new ArrayList<String>();
    private int chartRangeAxisForMask = -1;
    private int chartMaskCount = 0;
    private TimeUnit currentTimeUnit = TimeUnit.seconds;
    private JPanel mainPanel = null;
    private JPanel sidePanel = null;
    private JTextField firstSampleTextField = null;
    private JTextField lastSampleTextField = null;
    private JCheckBox timeStampCheckBox = null;
    private int dataSamples = -1;
    private DataBase.DataBaseRange dataBaseRange = Support.dataBase.getRange();
    private boolean useTimeStamp = false;
    private int dataAtLastUpdate = 0;
    private int missedLastUpdates = 0;
    private XYLineAnnotation cursorLine;
    private XYLineAnnotation markerLine;
    private XYTextAnnotation markerText;
    private double cursorPosition;
    private double markerPosition;
    private double cursorLeftPosition;
    private double cursorRightPosition;
    private CursorState cursorState = CursorState.off;
    private List<JMenu> chartSubmenus = new ArrayList<JMenu>();
    private String lastSearchValue = "";
    private JPopupMenu chartMenu = null;
    private PopupValues popupValues = null;
    private int popupNextUpdateSamples = 0;
    private JPopupMenu yAxisPopupMenu = null;
    private boolean cursorPossible = true;
    private boolean domainLog = false;
    public String lastDomainColumn = "";
    public ChartAnnotations annotations = new ChartAnnotations();
    private Timer timer;
    ActionListener checkBoxListener = new ActionListener(){
        int cnt = 0;

        private boolean mustDisable(JCheckBox cb) {
            try {
                CurveIndex curveIndex = new CurveIndex(cb.getActionCommand());
                return this.cnt >= 8 && (PaneChart.this.chartMaskCount <= 0 || curveIndex.mask == 0);
            }
            catch (Exception exception) {
                return true;
            }
        }

        private void removeCurveIndex(String name) {
            int i = 0;
            while (i < PaneChart.this.curveIndexs.size()) {
                if (((CurveIndex)PaneChart.this.curveIndexs.get(i)).name.equals(name)) {
                    PaneChart.this.curveIndexs.remove(i);
                    PaneChart.this.checkedColumns.remove(name);
                    return;
                }
                ++i;
            }
        }

        private void addCurveIndex(String name) throws Exception {
            if (name == null || name.length() == 0) {
                return;
            }
            int i = 0;
            while (i < PaneChart.this.curveIndexs.size()) {
                if (((CurveIndex)PaneChart.this.curveIndexs.get(i)).name.equals(name)) {
                    return;
                }
                ++i;
            }
            PaneChart.this.curveIndexs.add(new CurveIndex(name));
            PaneChart.this.checkedColumns.add(name);
        }

        private void setChartIndex() {
            int i = 0;
            while (i < PaneChart.this.curveIndexs.size()) {
                ((CurveIndex)PaneChart.this.curveIndexs.get(i)).chartIndex = i;
                ++i;
            }
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            for (JCheckBox cb : PaneChart.this.checkBoxList) {
                if (cb.isSelected()) continue;
                this.removeCurveIndex(cb.getActionCommand());
            }
            for (JCheckBox cb : PaneChart.this.checkBoxList) {
                if (!cb.isSelected()) continue;
                try {
                    this.addCurveIndex(cb.getActionCommand());
                }
                catch (Exception exception) {
                    cb.setEnabled(false);
                }
            }
            this.setChartIndex();
            this.cnt = 0;
            PaneChart.this.chartMaskCount = 0;
            for (CurveIndex ci : PaneChart.this.curveIndexs) {
                if (ci.mask != 0) {
                    PaneChart paneChart = PaneChart.this;
                    paneChart.chartMaskCount = paneChart.chartMaskCount + 1;
                    continue;
                }
                ++this.cnt;
            }
            if (PaneChart.this.chartMaskCount > 0) {
                ++this.cnt;
            }
            for (JCheckBox cb : PaneChart.this.checkBoxList) {
                if (!cb.isSelected() && this.mustDisable(cb)) {
                    cb.setEnabled(false);
                    continue;
                }
                cb.setEnabled(true);
            }
            PaneChart.this.setupCurveIndexes();
            if (PaneChart.this.popupValues != null) {
                PaneChart.this.popupValues.setVisible(false);
                PaneChart.this.popupValues = null;
            }
        }
    };
    InputChanged inputChanged = new InputChanged();
    InputChangedFocus inputChangedFocus = new InputChangedFocus();
    private ActionListener chartActionListener = new ActionListener(){

        private void placeMarker() {
            if (PaneChart.this.markerLine != null) {
                PaneChart.this.chart.getXYPlot().removeAnnotation(PaneChart.this.markerLine);
                PaneChart.this.chart.getXYPlot().removeAnnotation(PaneChart.this.markerText);
            }
            XYPlot plot = (XYPlot)PaneChart.this.chart.getPlot();
            double lower = plot.getRangeAxis().getLowerBound();
            double upper = plot.getRangeAxis().getUpperBound();
            PaneChart.this.markerLine = new XYLineAnnotation(PaneChart.this.markerPosition, lower, PaneChart.this.markerPosition, upper, new BasicStroke(2.0f), Color.MAGENTA);
            boolean isDT = Support.dataBase.header().getColumnName(PaneChart.this.domainColumn).equals("dateTime");
            int row = Support.dataBase.findSampleIndex(PaneChart.this.domainColumn, PaneChart.this.markerPosition / (double)(isDT ? 1000 : 1));
            double time = Support.dataBase.getValue(row, PaneChart.this.timeColumn);
            String s = "";
            s = Support.dataBase.header().getColumnName(PaneChart.this.timeColumn).equals("time") ? String.valueOf(Support.formatTime(time)) + "s" : Integer.toString((int)time);
            PaneChart.this.markerText = new XYTextAnnotation(" " + s + " ", PaneChart.this.markerPosition, upper - (upper - lower) * 0.01);
            PaneChart.this.markerText.setTextAnchor(PaneChart.this.markerPosition < (PaneChart.this.cursorLeftPosition + PaneChart.this.cursorRightPosition) / 2.0 ? TextAnchor.TOP_LEFT : TextAnchor.TOP_RIGHT);
            PaneChart.this.markerText.setFont(FontAdjust.fontSizes.chartTheme.getLargeFont());
            PaneChart.this.markerText.setPaint(Color.MAGENTA);
            PaneChart.this.chart.getXYPlot().addAnnotation(PaneChart.this.markerLine);
            PaneChart.this.chart.getXYPlot().addAnnotation(PaneChart.this.markerText);
            PaneChart.this.moveCursor(PaneChart.this.markerPosition);
            PaneChart.this.chart.setNotify(true);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            String cmd = arg0.getActionCommand();
            if (cmd == "First") {
                PaneChart.this.firstSampleTextField.setText(Support.formatTime(PaneChart.this.cursorPositionToSeconds()));
            } else if (cmd == "Last") {
                PaneChart.this.lastSampleTextField.setText(Support.formatTime(PaneChart.this.cursorPositionToSeconds()));
            } else if (cmd == "Marker") {
                PaneChart.this.markerPosition = PaneChart.this.cursorPosition;
                this.placeMarker();
            } else if (cmd.startsWith("Zoom:")) {
                PaneChart.this.zoomChart(cmd);
                if (PaneChart.this.markerLine != null) {
                    this.placeMarker();
                }
            } else if (cmd.startsWith("Y:")) {
                PaneChart.this.selectDomainColumn(cmd.substring(2));
            } else if (cmd.equals("Layout")) {
                PopupChartLayout pcl = new PopupChartLayout();
                Point p = PaneChart.this.chartPanel.getLocationOnScreen();
                p.y += ((PaneChart)PaneChart.this).chartPanel.getSize().height;
                pcl.setLocation(p);
                pcl.setVisible(true);
            } else {
                PaneChart.this.moveCursor(cmd);
            }
        }
    };

    public boolean usedScale(String name) {
        return this.checkedColumns.contains(name) || Support.dataBase.header().getColumnName(this.domainColumn).equals(name);
    }

    @Override
    public int getHotKey() {
        return 65;
    }

    private Color getColor(int no) {
        return Support.chartLineColor[(no + Support.chartLineColor.length) % Support.chartLineColor.length];
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    private boolean isValid(boolean isLog, double v) {
        if (isLog) {
            return Double.isFinite(v) && v < 1.0E99 && v > Support.systemSettings.chartLowLog;
        }
        return Double.isFinite(v) && Math.abs(v) < 1.0E99;
    }

    private void filterSeries(boolean isLogDomain, boolean isLogRange, double[][] series) {
        if (Support.systemSettings.overflowChartHandling == Support.OverflowChartHandling.filter) {
            int j = 0;
            int i = 0;
            while (i < series[0].length) {
                if (this.isValid(isLogDomain, series[0][i]) && this.isValid(isLogRange, series[1][i])) {
                    series[0][j] = series[0][i];
                    series[1][j] = series[1][i];
                    ++j;
                }
                ++i;
            }
            if (j != series[0].length) {
                series[0] = Arrays.copyOf(series[0], j);
                series[1] = Arrays.copyOf(series[1], j);
            }
        } else {
            int i = 0;
            while (i < series[0].length) {
                if (!this.isValid(isLogDomain, series[0][i])) {
                    double d = series[0][i] = isLogDomain ? Support.systemSettings.chartLowLog : 0.0;
                }
                if (!this.isValid(isLogRange, series[1][i])) {
                    series[1][i] = isLogRange ? Support.systemSettings.chartLowLog : 0.0;
                }
                ++i;
            }
        }
    }

    public void selectCurves(List<String> curves) {
        for (JCheckBox cb : this.checkBoxList) {
            cb.setSelected(false);
        }
        this.checkBoxListener.actionPerformed(null);
        block1: for (String name : curves) {
            for (JCheckBox cb : this.checkBoxList) {
                if (!cb.getText().equals(name)) continue;
                cb.setSelected(true);
                this.checkBoxListener.actionPerformed(null);
                continue block1;
            }
        }
    }

    public void setAxisX(String axisName) {
        boolean ts = this.timeStampCheckBox.isSelected();
        this.timeStampCheckBox.setSelected(false);
        if (axisName.equalsIgnoreCase("hms") || axisName.equalsIgnoreCase("hhmmss") || axisName.equalsIgnoreCase("hh:mm:ss")) {
            this.timeStampCheckBox.setSelected(true);
            ts = !ts;
            this.chartActionListener.actionPerformed(new ActionEvent(this.yAxisPopupMenu, 0, "Y:time"));
        } else {
            this.chartActionListener.actionPerformed(new ActionEvent(this.yAxisPopupMenu, 0, "Y:" + axisName.trim()));
        }
        if (ts) {
            this.inputChanged.actionPerformed(new ActionEvent(this.timeStampCheckBox, 0, ""));
        }
    }

    public void setSamples(String first, String last) {
        this.firstSampleTextField.setText(first);
        this.lastSampleTextField.setText(last);
        this.inputChanged.actionPerformed(new ActionEvent(this.firstSampleTextField, 0, ""));
    }

    @Override
    public String getTitle() {
        return "Chart";
    }

    private void setupSizes() {
        int w = this.chartPanel.getWidth() - 5;
        int h = this.chartPanel.getHeight() - 5;
        this.chartPanel.setMaximumDrawHeight(h);
        this.chartPanel.setMaximumDrawWidth(w);
        this.chartPanel.setMinimumDrawHeight(h);
        this.chartPanel.setMinimumDrawWidth(w);
        this.mainPanel.validate();
        this.dataSamples = -1;
    }

    @Override
    public JPanel getPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.addComponentListener(new MySwingUtil.ResizeListener(){

            @Override
            public void componentResized(ComponentEvent e) {
            }
        });
        this.mainPanel.setLayout(new BorderLayout());
        this.chart = ChartFactory.createXYLineChart(null, "", "", null);
        FontAdjust.fontSizes.chartTheme.apply(this.chart);
        this.chartPanel = new ChartPanel(this.chart, 10, 10, 10, 10, 10, 10, true, false, false, false, false, false);
        this.chartPanel.addComponentListener(new MySwingUtil.ResizeListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                PaneChart.this.setupSizes();
            }
        });
        this.sidePanel = new FontAdjust.FontPanel();
        ((FontAdjust.FontPanel)this.sidePanel).setScaleWidth(150);
        this.sidePanel.setLayout(new BoxLayout(this.sidePanel, 3));
        JSplitPane splitPane = new JSplitPane(1, this.chartPanel, this.sidePanel);
        this.chartPanel.setMinimumSize(new Dimension(700, 400));
        this.sidePanel.setMinimumSize(new Dimension(150, 400));
        splitPane.setContinuousLayout(true);
        splitPane.setResizeWeight(1.0);
        this.mainPanel.add(splitPane);
        this.checkboxPanel = new JPanel();
        this.checkboxPanel.setLayout(new BoxLayout(this.checkboxPanel, 3));
        this.sidePanel.add(new JScrollPane(this.checkboxPanel));
        if (Support.chartColor != null) {
            this.chart.getPlot().setBackgroundPaint(Support.chartColor);
        }
        if (Support.chartBorderColor != null) {
            this.chart.setBackgroundPaint(Support.chartBorderColor);
            this.chartPanel.setBackground(Support.chartBorderColor);
        }
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new GridBagLayout());
        this.mainPanel.add((Component)bottomPanel, "South");
        FontAdjust.FontLabel label = new FontAdjust.FontLabel("First sample to display:");
        label.setToolTipText("<html>Formats supported:<br>Empty: All data<br>seconds from start<br>h:m:s hour minutes seconds<br>postfix with h/m for hours/minutes<br>#sampleNumber<br>Prefix with - means from end of data<br>Prefix with w for width/lenght of data, only in last field");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.anchor = 13;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(5, 5, 5, 5);
        bottomPanel.add((Component)label, c);
        this.firstSampleTextField = new FontAdjust.FontTextField(8);
        this.firstSampleTextField.setToolTipText("<html>Formats supported:<br>Empty: All data<br>seconds from start<br>h:m:s hour minutes seconds<br>postfix with h/m for hours/minutes<br>#sampleNumber<br>Prefix with - means from end of data<br>Prefix with w for width/lenght of data, only in last field");
        this.firstSampleTextField.addActionListener(this.inputChanged);
        this.firstSampleTextField.addFocusListener(this.inputChangedFocus);
        this.firstSampleTextField.setMinimumSize(new Dimension(30, 20));
        c = new GridBagConstraints();
        c.gridx = 1;
        c.anchor = 17;
        c.weightx = 1.0;
        c.insets = new Insets(5, 5, 5, 5);
        bottomPanel.add((Component)this.firstSampleTextField, c);
        label = new FontAdjust.FontLabel("Last sample to display:");
        label.setToolTipText("<html>Formats supported:<br>Empty: All data<br>seconds from start<br>h:m:s hour minutes seconds<br>postfix with h/m for hours/minutes<br>#sampleNumber<br>Prefix with - means from end of data<br>Prefix with w for width/lenght of data, only in last field");
        c = new GridBagConstraints();
        c.gridx = 2;
        c.anchor = 13;
        c.weightx = 1.0;
        c.insets = new Insets(5, 5, 5, 5);
        bottomPanel.add((Component)label, c);
        this.lastSampleTextField = new FontAdjust.FontTextField(8);
        this.lastSampleTextField.setToolTipText("<html>Formats supported:<br>Empty: All data<br>seconds from start<br>h:m:s hour minutes seconds<br>postfix with h/m for hours/minutes<br>#sampleNumber<br>Prefix with - means from end of data<br>Prefix with w for width/lenght of data, only in last field");
        this.lastSampleTextField.addActionListener(this.inputChanged);
        this.lastSampleTextField.addFocusListener(this.inputChangedFocus);
        this.lastSampleTextField.setMinimumSize(new Dimension(30, 20));
        c = new GridBagConstraints();
        c.gridx = 3;
        c.anchor = 17;
        c.weightx = 1.0;
        c.insets = new Insets(5, 5, 5, 5);
        bottomPanel.add((Component)this.lastSampleTextField, c);
        FontAdjust.FontButton toHistogramButton = new FontAdjust.FontButton("To hist.");
        toHistogramButton.setActionCommand("ToHist");
        toHistogramButton.addActionListener(this.inputChanged);
        toHistogramButton.setToolTipText("Copy the selected range to histogram page and select it");
        c = new GridBagConstraints();
        c.gridx = 4;
        c.anchor = 10;
        c.weightx = 1.0;
        c.insets = new Insets(5, 5, 5, 5);
        bottomPanel.add((Component)toHistogramButton, c);
        FontAdjust.FontButton toRangeButton = new FontAdjust.FontButton("To Range");
        toRangeButton.setActionCommand("ToRange");
        toRangeButton.addActionListener(this.inputChanged);
        toRangeButton.setToolTipText("Copy the selected range to range page and select it");
        c = new GridBagConstraints();
        c.gridx = 5;
        c.anchor = 10;
        c.weightx = 1.0;
        c.insets = new Insets(5, 5, 5, 5);
        bottomPanel.add((Component)toRangeButton, c);
        this.toExportButton = new FontAdjust.FontButton("To Export");
        this.toExportButton.setActionCommand("ToExport");
        this.toExportButton.addActionListener(this.inputChanged);
        this.toExportButton.setToolTipText("Copy the selected range to export dialog and open it");
        c = new GridBagConstraints();
        c.gridx = 6;
        c.anchor = 10;
        c.weightx = 1.0;
        c.insets = new Insets(5, 5, 5, 5);
        bottomPanel.add((Component)this.toExportButton, c);
        this.timeStampCheckBox = new FontAdjust.FontCheckBox("hh:mm:ss");
        this.timeStampCheckBox.setToolTipText("Time scale will use hh:mm:ss format, right click to select y-scale");
        this.timeStampCheckBox.addActionListener(this.inputChanged);
        c = new GridBagConstraints();
        c.gridx = 7;
        c.anchor = 10;
        c.weightx = 1.0;
        c.insets = new Insets(5, 5, 5, 5);
        bottomPanel.add((Component)this.timeStampCheckBox, c);
        this.yAxisPopupMenu = new JPopupMenu();
        this.timeStampCheckBox.setComponentPopupMenu(this.yAxisPopupMenu);
        FontAdjust.FontButton saveButton = new FontAdjust.FontButton("Save");
        saveButton.setToolTipText("Save chart in PNG format with any resoltuon");
        c = new GridBagConstraints();
        c.gridx = 8;
        c.anchor = 13;
        c.weightx = 1.0;
        c.insets = new Insets(5, 5, 5, 5);
        bottomPanel.add((Component)saveButton, c);
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaneChart.this.saveChart();
            }
        });
        this.timer = new Timer(50, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ((double)Support.dataBase.rows() > (double)PaneChart.this.dataAtLastUpdate * 1.1 || PaneChart.this.missedLastUpdates > 10) {
                    PaneChart.this.dataAtLastUpdate = Support.dataBase.rows();
                    PaneChart.this.missedLastUpdates = 0;
                    PaneChart.this.timerUpdate();
                } else {
                    PaneChart paneChart = PaneChart.this;
                    paneChart.missedLastUpdates = paneChart.missedLastUpdates + 1;
                }
            }
        });
        this.modifyChartPanel();
        return this.mainPanel;
    }

    private void addCheckboxes() {
        Support.StringList newCheckedColumns = new Support.StringList();
        this.checkboxPanel.removeAll();
        this.checkBoxList.clear();
        this.curveIndexs.clear();
        this.domainColumn = -1;
        this.currentTimeUnit = TimeUnit.seconds;
        if (this.popupValues != null) {
            this.popupValues.setVisible(false);
            this.popupValues = null;
        }
        this.timeColumn = Support.dataBase.header().getTimeColumn();
        if (this.timeColumn < 0) {
            this.timeColumn = Support.dataBase.header().getIndexColumn();
            this.currentTimeUnit = TimeUnit.index;
        }
        this.domainColumn = this.timeColumn;
        int[] nArray = Support.dataBase.header().getDataColumns();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            String columnName = Support.dataBase.header().getColumnName(i);
            int digitalValues = Support.dataBase.format().get((int)i).format.digitalValues();
            if (digitalValues > 0) {
                int n3 = 0;
                while (n3 < digitalValues) {
                    String ss = Support.dataBase.format().get((int)i).format.getValueName(n3);
                    if (ss != null) {
                        ss = String.valueOf(columnName) + " " + ss;
                        FontAdjust.FontCheckBox box = new FontAdjust.FontCheckBox(ss);
                        if (this.checkedColumns.contains(ss)) {
                            box.setSelected(true);
                            newCheckedColumns.add(ss);
                        }
                        this.checkBoxList.add(box);
                        this.checkboxPanel.add(box);
                        box.addActionListener(this.checkBoxListener);
                        box.setActionCommand(ss);
                    }
                    ++n3;
                }
            } else if (columnName != null && columnName.length() > 0) {
                FontAdjust.FontCheckBox box = new FontAdjust.FontCheckBox(columnName);
                if (this.checkedColumns.contains(columnName) && !newCheckedColumns.contains(columnName)) {
                    box.setSelected(true);
                    newCheckedColumns.add(columnName);
                }
                this.checkBoxList.add(box);
                this.checkboxPanel.add(box);
                box.addActionListener(this.checkBoxListener);
                box.setActionCommand(columnName);
            }
            ++n2;
        }
        this.checkedColumns = newCheckedColumns;
        if (this.checkedColumns.size() == 0 && this.checkBoxList.size() > 0) {
            this.checkBoxList.get(0).setSelected(true);
            this.checkedColumns.add(this.checkBoxList.get(0).getText());
        }
        this.cursorPosition = -1.0;
        this.checkBoxListener.actionPerformed(null);
        this.yAxisPopupMenu.removeAll();
        int col = 0;
        while (col < Support.dataBase.columns()) {
            if (Support.dataBase.format().get((int)col).format.digitalValues() == 0) {
                FontAdjust.FontMenuItem mi = new FontAdjust.FontMenuItem(Support.dataBase.header().getColumnName(col));
                mi.setActionCommand("Y:" + Support.dataBase.header().getColumnName(col));
                mi.addActionListener(this.chartActionListener);
                this.yAxisPopupMenu.add(mi);
            }
            ++col;
        }
        if (this.lastDomainColumn != null && this.lastDomainColumn.length() > 0 && Support.dataBase.header().getIndex(this.lastDomainColumn) >= 0) {
            this.selectDomainColumn(this.lastDomainColumn);
        }
    }

    private void setupCurveIndexes() {
        this.chartPanel.restoreAutoBounds();
        this.dataSamples = -1;
        if (this.timeColumn >= 0 && this.timeColumn == this.domainColumn) {
            this.chart = ChartFactory.createXYLineChart(null, this.currentTimeUnit == TimeUnit.index ? "Index" : Support.chartScales.getTimeName(), "", null);
        } else {
            ChartScales.ChartScale cs = Support.chartScales.getScale(Support.dataBase.header().getColumnName(this.domainColumn));
            this.chart = ChartFactory.createXYLineChart(null, cs.getAxisName(), "", null);
        }
        FontAdjust.fontSizes.chartTheme.apply(this.chart);
        if (Support.chartColor != null) {
            this.chart.getPlot().setBackgroundPaint(Support.chartColor);
        }
        if (Support.chartBorderColor != null) {
            this.chart.setBackgroundPaint(Support.chartBorderColor);
            this.chartPanel.setBackground(Support.chartBorderColor);
        }
        if (Support.chartGridColor != null) {
            this.chart.getXYPlot().setDomainGridlinePaint(Support.chartGridColor);
            this.chart.getXYPlot().setRangeGridlinePaint(Support.chartGridColor);
        }
        this.chart.setNotify(false);
        this.chartPanel.setChart(this.chart);
        this.chartPanel.setDomainZoomable(false);
        this.chartPanel.setRangeZoomable(false);
        this.chartPanel.setMouseZoomable(false);
        this.chart.getXYPlot().getDomainAxis().setAutoRange(true);
        this.chart.getXYPlot().getDomainAxis().setLowerMargin(0.0);
        this.chart.getXYPlot().getDomainAxis().setUpperMargin(0.0);
        ValueAxis daxis = this.chart.getXYPlot().getDomainAxis();
        daxis.setLabelFont(FontAdjust.fontSizes.chartTheme.getLargeFont());
        daxis.setTickLabelFont(FontAdjust.fontSizes.chartTheme.getRegularFont());
        if (this.timeColumn == this.domainColumn) {
            ((NumberAxis)daxis).setNumberFormatOverride(new TimeFormat());
            this.domainLog = false;
            daxis.setAutoRange(true);
        } else if (Support.dataBase.header().getColumnName(this.domainColumn).equals("dateTime")) {
            daxis = new DateAxis(Support.chartScales.getDateTimeName());
            daxis.setAutoRange(true);
            this.domainLog = false;
            ((DateAxis)daxis).setDateFormatOverride(new ValueFormat.ValueFormatterDateTime().getFormatter());
            this.chart.getXYPlot().setDomainAxis(daxis);
        } else {
            ChartScales.ChartScale cs = Support.chartScales.getScale(Support.dataBase.header().getColumnName(this.domainColumn));
            if (cs != null) {
                double[][] series = Support.dataBase.getSeries(this.dataBaseRange, 5000, this.domainColumn, this.domainColumn, 0, 0.0, 0.0);
                this.domainLog = cs.isLog();
                this.filterSeries(this.domainLog, this.domainLog, series);
                Support.MyDecimalFormat nf = new Support.MyDecimalFormat();
                nf.setMaximumFractionDigits(cs.getDecimals());
                if (this.domainLog) {
                    daxis = new MyLogarithmicAxis(this.chart.getXYPlot().getDomainAxis().getLabel());
                    daxis.setLowerMargin(0.0);
                    daxis.setUpperMargin(0.0);
                    daxis.setLabelFont(FontAdjust.fontSizes.chartTheme.getLargeFont());
                    daxis.setTickLabelFont(FontAdjust.fontSizes.chartTheme.getRegularFont());
                    this.chart.getXYPlot().setDomainAxis(daxis);
                }
                daxis.setAutoRange(false);
                ((NumberAxis)daxis).setNumberFormatOverride(nf);
                nf.setSIFormat(cs.isSi());
                cs.setAxisScale((ValueAxis)((NumberAxis)daxis), series);
            } else {
                daxis.setAutoRange(true);
            }
        }
        if (Support.chartFontColor != null) {
            daxis.setTickLabelPaint(Support.chartFontColor);
            daxis.setTickMarkPaint(Support.chartFontColor);
            daxis.setLabelPaint(Support.chartFontColor);
            daxis.setAxisLinePaint(Support.chartFontColor);
        }
        this.cursorState = CursorState.off;
        if (this.popupValues != null) {
            this.popupValues.setVisible(false);
            this.popupValues = null;
        }
        daxis.setLabelFont(FontAdjust.fontSizes.chartTheme.getLargeFont());
        daxis.setTickLabelFont(FontAdjust.fontSizes.chartTheme.getRegularFont());
        int maskCount = 0;
        this.chartRangeAxisForMask = -1;
        this.maskNames.clear();
        for (CurveIndex ci : this.curveIndexs) {
            if (ci.mask == 0) continue;
            this.maskNames.add(ci.getMaskName());
            ++maskCount;
        }
        if (maskCount > 0) {
            this.chartRangeAxisForMask = this.curveIndexs.get(0).mask != 0 ? 0 : this.curveIndexs.size();
        }
        boolean firstMask = true;
        HashMap<String, Integer> curveMap = new HashMap<String, Integer>();
        for (CurveIndex ci : this.curveIndexs) {
            curveMap.put(ci.dbName, ci.chartIndex);
            ci.setupAxis(firstMask && ci.mask != 0);
            if (ci.mask == 0) continue;
            firstMask = false;
        }
        this.placeAutoCurves();
        this.setupPopupMenu();
        this.updateMenus();
        this.updateData(false);
        this.popupNextUpdateSamples = 0;
        this.annotations.addToChart(curveMap, Support.dataBase.header().getColumnName(this.domainColumn), this.chart.getXYPlot());
        this.chart.setNotify(true);
    }

    private void placeAutoCurves() {
        int n = 0;
        for (CurveIndex ci : this.curveIndexs) {
            ChartScales.ChartScale cs = Support.chartScales.getScale(ci.name);
            if (ci.mask != 0 || cs == null || !cs.isAuto()) continue;
            ++n;
        }
        int i = 0;
        for (CurveIndex ci : this.curveIndexs) {
            ChartScales.ChartScale cs = Support.chartScales.getScale(ci.name);
            if (ci.mask != 0 || cs == null || !cs.isAuto()) continue;
            cs.setChartPosition(1.0 * (double)i / (double)n + 0.5 / (double)n);
            ++i;
        }
    }

    private void updateData(boolean force) {
        ChartScales.ChartScale cs;
        DataRow row;
        if (!force && this.dataSamples == Support.dataBase.rows()) {
            return;
        }
        this.dataSamples = Support.dataBase.rows();
        this.chart.setNotify(false);
        double offset = 0.0;
        for (CurveIndex ci : this.curveIndexs) {
            ci.updateDataset(offset);
            if (ci.mask == 0) continue;
            offset += 1.0;
        }
        if (this.currentTimeUnit != TimeUnit.index && (row = Support.dataBase.getLastRow()) != null && this.timeColumn >= 0) {
            int t = (int)row.getValue(this.timeColumn);
            this.currentTimeUnit = t < 600 ? TimeUnit.seconds : (t < 36000 ? TimeUnit.minutes : (t < 864000 ? TimeUnit.hours : TimeUnit.days));
        }
        ValueAxis daxis = this.chart.getXYPlot().getDomainAxis();
        if (this.domainColumn != this.timeColumn && !Support.dataBase.header().getColumnName(this.domainColumn).equals("dateTime") && (cs = Support.chartScales.getScale(Support.dataBase.header().getColumnName(this.domainColumn))) != null) {
            double[][] series = Support.dataBase.getSeries(this.dataBaseRange, 5000, this.domainColumn, this.domainColumn, 0, 0.0, 0.0);
            this.domainLog = cs.isLog();
            this.filterSeries(this.domainLog, this.domainLog, series);
            cs.setAxisScale((ValueAxis)((NumberAxis)daxis), series);
        }
        Range range = daxis.getRange();
        this.cursorLeftPosition = range.getLowerBound();
        this.cursorRightPosition = range.getUpperBound();
        this.chart.setNotify(true);
    }

    private void timerUpdate() {
        this.updateData(false);
        this.toExportButton.setEnabled(Support.dataBase.rows() > 0 && !Support.dataBase.isOptimizing());
        if (Support.dataBase.rows() > this.popupNextUpdateSamples) {
            this.setupPopupMenu();
        }
    }

    @Override
    public void changeDevicesOrTable(Support.UpdateType type) {
        if (type.equals((Object)Support.UpdateType.StartInit)) {
            return;
        }
        if (type.equals((Object)Support.UpdateType.Devices) || type.equals((Object)Support.UpdateType.ColumnsSource)) {
            this.lastDomainColumn = "";
            this.annotations.clear();
        }
        this.addCheckboxes();
        this.setupCurveIndexes();
        this.updateData(true);
        this.setupPopupMenu();
    }

    @Override
    public void select() {
        this.parseInput();
        this.setupCurveIndexes();
        this.updateData(true);
        this.timer.start();
    }

    public void update() {
        this.setupCurveIndexes();
        this.updateData(true);
    }

    public void updateAnnotations() {
        this.setupCurveIndexes();
    }

    @Override
    public void deselect() {
        this.timer.stop();
        if (this.popupValues != null) {
            this.popupValues.setVisible(false);
            this.popupValues = null;
        }
    }

    private void parseInput() {
        String fs = this.firstSampleTextField.getText().trim();
        String ls = this.lastSampleTextField.getText().trim();
        this.dataBaseRange = Support.dataBase.getRange(this.timeColumn, fs, ls);
        boolean uts = this.timeStampCheckBox.isSelected();
        if (uts != this.useTimeStamp) {
            this.useTimeStamp = uts;
            this.domainColumn = this.timeColumn;
            this.cursorPossible = true;
            this.lastDomainColumn = "";
            this.setupCurveIndexes();
        }
        this.updateData(true);
    }

    private void setupPopupMenu() {
        this.chartMenu = this.chartPanel.getPopupMenu();
        if (!this.cursorPossible) {
            this.chartMenu.removeAll();
            return;
        }
        if (Support.dataBase.rows() < this.popupNextUpdateSamples) {
            return;
        }
        if (this.chartMenu == null) {
            return;
        }
        if (this.chartMenu.isVisible()) {
            return;
        }
        double range = 600.0;
        int samples = 600;
        if (Support.dataBase.rows() > 0) {
            range = Support.dataBase.getValue(Support.dataBase.rows() - 1, this.timeColumn) - Support.dataBase.getValue(0, this.timeColumn);
            samples = Support.dataBase.rows();
        }
        this.popupNextUpdateSamples = samples * 2 + 100;
        this.chartMenu.removeAll();
        FontAdjust.FontMenuItem mi = new FontAdjust.FontMenuItem("To first sample");
        mi.setToolTipText("Copy current position into \"First sample\" textbox");
        mi.setActionCommand("First");
        mi.addActionListener(this.chartActionListener);
        this.chartMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("To last sample");
        mi.setToolTipText("Copy current position into \"Last sample\" textbox");
        mi.setActionCommand("Last");
        mi.addActionListener(this.chartActionListener);
        this.chartMenu.add(mi);
        FontAdjust.FontMenu ms = new FontAdjust.FontMenu("Zoom and center");
        ms.setToolTipText("Zoom display X-scale with current position as center");
        ms.setActionCommand("Zoom");
        ms.addActionListener(this.chartActionListener);
        this.chartMenu.add(ms);
        if ((double)samples / range > 10.0) {
            mi = new FontAdjust.FontMenuItem("5 seconds");
            mi.addActionListener(this.chartActionListener);
            mi.setActionCommand("Zoom:5");
            ms.add(mi);
        }
        if ((double)samples / range > 1.0) {
            mi = new FontAdjust.FontMenuItem("20 seconds");
            mi.addActionListener(this.chartActionListener);
            mi.setActionCommand("Zoom:20");
            ms.add(mi);
        }
        mi = new FontAdjust.FontMenuItem("1 minute");
        mi.addActionListener(this.chartActionListener);
        mi.setActionCommand("Zoom:60");
        ms.add(mi);
        mi = new FontAdjust.FontMenuItem("5 minutes");
        mi.addActionListener(this.chartActionListener);
        mi.setActionCommand("Zoom:300");
        ms.add(mi);
        mi = new FontAdjust.FontMenuItem("15 minutes");
        mi.addActionListener(this.chartActionListener);
        mi.setActionCommand("Zoom:900");
        ms.add(mi);
        if (range > 3600.0) {
            mi = new FontAdjust.FontMenuItem("1 hour");
            mi.addActionListener(this.chartActionListener);
            mi.setActionCommand("Zoom:3600");
            ms.add(mi);
        }
        if (range > 10800.0) {
            mi = new FontAdjust.FontMenuItem("3 hours");
            mi.addActionListener(this.chartActionListener);
            mi.setActionCommand("Zoom:10800");
            ms.add(mi);
        }
        if (range > 36000.0) {
            mi = new FontAdjust.FontMenuItem("10 hours");
            mi.addActionListener(this.chartActionListener);
            mi.setActionCommand("Zoom:36000");
            ms.add(mi);
        }
        mi = new FontAdjust.FontMenuItem("All");
        mi.addActionListener(this.chartActionListener);
        mi.setActionCommand("Zoom:All");
        ms.add(mi);
        FontAdjust.FontMenu m = new FontAdjust.FontMenu("Top peak");
        m.setToolTipText("Locate a positive peak");
        this.chartMenu.add(m);
        ms = new FontAdjust.FontMenu("Search left");
        ms.addActionListener(this.chartActionListener);
        ms.setActionCommand("LTP");
        m.add(ms);
        this.chartSubmenus.add(ms);
        ms = new FontAdjust.FontMenu("Search right");
        ms.addActionListener(this.chartActionListener);
        ms.setActionCommand("RTP");
        m.add(ms);
        this.chartSubmenus.add(ms);
        ms = new FontAdjust.FontMenu("Search view");
        ms.addActionListener(this.chartActionListener);
        ms.setActionCommand("TP");
        m.add(ms);
        this.chartSubmenus.add(ms);
        m = new FontAdjust.FontMenu("Bottom peak");
        m.setToolTipText("Locate a negative peak");
        this.chartMenu.add(m);
        ms = new FontAdjust.FontMenu("Search left");
        ms.addActionListener(this.chartActionListener);
        ms.setActionCommand("LBP");
        m.add(ms);
        this.chartSubmenus.add(ms);
        ms = new FontAdjust.FontMenu("Search right");
        ms.addActionListener(this.chartActionListener);
        ms.setActionCommand("RBP");
        m.add(ms);
        this.chartSubmenus.add(ms);
        ms = new FontAdjust.FontMenu("Search view");
        ms.addActionListener(this.chartActionListener);
        ms.setActionCommand("BP");
        m.add(ms);
        this.chartSubmenus.add(ms);
        m = new FontAdjust.FontMenu("Zero");
        m.setToolTipText("Locate a zero crossing");
        this.chartMenu.add(m);
        ms = new FontAdjust.FontMenu("Search left");
        ms.addActionListener(this.chartActionListener);
        ms.setActionCommand("LZ");
        m.add(ms);
        this.chartSubmenus.add(ms);
        ms = new FontAdjust.FontMenu("Search right");
        ms.addActionListener(this.chartActionListener);
        ms.setActionCommand("RZ");
        m.add(ms);
        this.chartSubmenus.add(ms);
        ms = new FontAdjust.FontMenu("Search view");
        ms.addActionListener(this.chartActionListener);
        ms.setActionCommand("Z");
        m.add(ms);
        this.chartSubmenus.add(ms);
        m = new FontAdjust.FontMenu("Value");
        m.setToolTipText("Locate a arbitrary value");
        this.chartMenu.add(m);
        ms = new FontAdjust.FontMenu("Search left");
        ms.addActionListener(this.chartActionListener);
        ms.setActionCommand("LV");
        m.add(ms);
        this.chartSubmenus.add(ms);
        ms = new FontAdjust.FontMenu("Search right");
        ms.addActionListener(this.chartActionListener);
        ms.setActionCommand("RV");
        m.add(ms);
        this.chartSubmenus.add(ms);
        ms = new FontAdjust.FontMenu("Search view");
        ms.addActionListener(this.chartActionListener);
        ms.setActionCommand("V");
        m.add(ms);
        this.chartSubmenus.add(ms);
        m = new FontAdjust.FontMenu("Max. rate");
        m.setToolTipText("Locate the steepest change in data");
        this.chartMenu.add(m);
        ms = new FontAdjust.FontMenu("Raise");
        ms.setActionCommand("RR");
        ms.addActionListener(this.chartActionListener);
        this.chartSubmenus.add(ms);
        m.add(ms);
        ms = new FontAdjust.FontMenu("Fall");
        ms.setActionCommand("FR");
        ms.addActionListener(this.chartActionListener);
        this.chartSubmenus.add(ms);
        m.add(ms);
        mi = new FontAdjust.FontMenuItem("Zero marker");
        mi.setToolTipText("Use this position as reference for the values readout");
        mi.setActionCommand("Marker");
        mi.addActionListener(this.chartActionListener);
        this.chartMenu.add(mi);
        mi = new FontAdjust.FontMenuItem("Layout");
        mi.setToolTipText("Add annotations and modify colors");
        mi.setActionCommand("Layout");
        mi.addActionListener(this.chartActionListener);
        this.chartMenu.add(mi);
        this.updateMenus();
    }

    private void modifyChartPanel() {
        this.chartPanel.setDomainZoomable(false);
        this.chartPanel.setRangeZoomable(false);
        this.chartPanel.setMouseZoomable(false);
        this.chartPanel.addChartMouseListener(new ChartMouseListener(){

            @Override
            public void chartMouseClicked(ChartMouseEvent me) {
                PaneChart.this.handleChartMouseEvent(true, me);
            }

            @Override
            public void chartMouseMoved(ChartMouseEvent me) {
                PaneChart.this.handleChartMouseEvent(false, me);
            }
        });
        this.setupPopupMenu();
    }

    private boolean moveCursor(String cmd) {
        double v;
        int i = cmd.indexOf(58);
        if (i < 0) {
            return false;
        }
        String f = cmd.substring(0, i);
        String name = cmd.substring(i + 1);
        int columnNo = Support.dataBase.header().getIndex(name);
        if (columnNo < 0) {
            return false;
        }
        boolean isDT = Support.dataBase.header().getColumnName(this.domainColumn).equals("dateTime");
        int rowNo = Support.dataBase.findSampleIndex(this.domainColumn, this.cursorPosition / (double)(isDT ? 1000 : 1));
        int leftRowNo = Support.dataBase.findSampleIndex(this.domainColumn, this.cursorLeftPosition / (double)(isDT ? 1000 : 1));
        int rightRowNo = Support.dataBase.findSampleIndex(this.domainColumn, this.cursorRightPosition / (double)(isDT ? 1000 : 1));
        if (rowNo < leftRowNo || rowNo > rightRowNo) {
            return false;
        }
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        double dv = 0.0;
        double target = 0.0;
        if ("LTP RTP LBP RBP".contains(f)) {
            int j = leftRowNo;
            while (j < rightRowNo) {
                v = Support.dataBase.getValue(j, columnNo);
                if (v > max) {
                    max = v;
                }
                if (v < min) {
                    min = v;
                }
                ++j;
            }
            dv = (max - min) * 0.05;
        }
        if ("LV RV V".contains(f)) {
            String vv = JOptionPane.showInputDialog(Main.main.frame, "Value?", this.lastSearchValue);
            if (vv == null || vv.length() == 0) {
                return false;
            }
            target = StringUtil.parseDoubleEE(vv);
            if (Double.isNaN(target)) {
                return false;
            }
            this.lastSearchValue = vv;
        }
        v = Support.dataBase.getValue(rowNo, columnNo);
        int nn = -1;
        if (f.equals("LTP")) {
            boolean up = false;
            int n = rowNo - 1;
            while (n > leftRowNo) {
                double v1 = Support.dataBase.getValue(n, columnNo);
                if (v1 > v) {
                    v = v1;
                    nn = n;
                    up = true;
                } else if (v1 + dv < v && up) break;
                --n;
            }
        } else if (f.equals("RTP")) {
            boolean up = false;
            int n = rowNo + 1;
            while (n < rightRowNo) {
                double v1 = Support.dataBase.getValue(n, columnNo);
                if (v1 > v) {
                    v = v1;
                    nn = n;
                    up = true;
                } else if (v1 + dv < v && up) break;
                ++n;
            }
        } else if (f.equals("LBP")) {
            boolean down = false;
            int n = rowNo - 1;
            while (n > leftRowNo) {
                double v1 = Support.dataBase.getValue(n, columnNo);
                if (v1 < v) {
                    v = v1;
                    nn = n;
                    down = true;
                } else if (v1 - dv > v && down) break;
                --n;
            }
        } else if (f.equals("RBP")) {
            boolean down = false;
            int n = rowNo + 1;
            while (n < rightRowNo) {
                double v1 = Support.dataBase.getValue(n, columnNo);
                if (v1 < v) {
                    v = v1;
                    nn = n;
                    down = true;
                } else if (v1 - dv > v && down) break;
                ++n;
            }
        } else if (f.equals("LZ") || f.equals("LV")) {
            int n = rowNo - 1;
            while (n > leftRowNo) {
                double v1 = Support.dataBase.getValue(n, columnNo);
                if (v1 <= target && v > target || v1 >= target && v < target) {
                    nn = n;
                    double v2 = Support.dataBase.getValue(n + 1, columnNo);
                    if (!(Math.abs(v2 - target) < Math.abs(v1 - target))) break;
                    nn = n + 1;
                    break;
                }
                --n;
            }
        } else if (f.equals("RZ") || f.equals("RV")) {
            int n = rowNo + 1;
            while (n < rightRowNo) {
                double v1 = Support.dataBase.getValue(n, columnNo);
                if (v1 <= target && v > target || v1 >= target && v < target) {
                    nn = n;
                    double v2 = Support.dataBase.getValue(n - 1, columnNo);
                    if (!(Math.abs(v2 - target) < Math.abs(v1 - target))) break;
                    nn = n - 1;
                    break;
                }
                ++n;
            }
        } else if (f.equals("TP")) {
            int n = leftRowNo;
            while (n < rightRowNo) {
                double v1 = Support.dataBase.getValue(n, columnNo);
                if (v1 > v) {
                    v = v1;
                    nn = n;
                }
                ++n;
            }
        } else if (f.equals("BP")) {
            int n = leftRowNo;
            while (n < rightRowNo) {
                double v1 = Support.dataBase.getValue(n, columnNo);
                if (v1 < v) {
                    v = v1;
                    nn = n;
                }
                ++n;
            }
        } else if (f.equals("Z") || f.equals("V")) {
            v = Support.dataBase.getValue(leftRowNo, columnNo);
            int n = leftRowNo + 1;
            while (n < rightRowNo) {
                double v1 = Support.dataBase.getValue(n, columnNo);
                if (v1 <= target && v > target || v1 >= target && v < target) {
                    v = v1;
                    nn = n;
                    break;
                }
                ++n;
            }
        } else if (f.equals("RR") || f.equals("FR")) {
            int step;
            int span = (rightRowNo - leftRowNo) / 2000;
            if (span < 2) {
                span = 2;
            }
            if ((step = span / 10) < 1) {
                step = 1;
            }
            boolean raise = f.equals("RR");
            double rrRef = 0.0;
            boolean log = Support.chartScales.getScale(name).isLog();
            int n = leftRowNo;
            while (n < rightRowNo) {
                double[] vv = Support.dataBase.getColumnRange(n - span, n + span, columnNo);
                if (log) {
                    int j = 0;
                    while (j < vv.length) {
                        vv[j] = vv[j] <= Support.systemSettings.chartLowLog ? Support.systemSettings.chartLowLog : Math.log10(vv[j]);
                        ++j;
                    }
                }
                double rr = MathUtil.slope(vv);
                if (raise && rr > rrRef) {
                    rrRef = rr;
                    nn = n;
                } else if (!raise && rr < rrRef) {
                    rrRef = rr;
                    nn = n;
                }
                n += step;
            }
        }
        if (nn >= leftRowNo && nn <= rightRowNo) {
            this.moveCursor(Support.dataBase.getValue(nn, this.domainColumn) * (double)(isDT ? 1000 : 1));
            this.cursorState = CursorState.on;
            return true;
        }
        return false;
    }

    private void updateMenus() {
        for (JMenu m : this.chartSubmenus) {
            m.removeAll();
            for (String s : this.checkedColumns) {
                int col = Support.dataBase.header().getIndex(s);
                if (Support.dataBase.format().get((int)col).format.digitalValues() != 0) continue;
                FontAdjust.FontMenuItem mi = new FontAdjust.FontMenuItem(s);
                mi.setActionCommand(String.valueOf(m.getActionCommand()) + ":" + s);
                mi.addActionListener(this.chartActionListener);
                m.add(mi);
            }
        }
    }

    private void handleChartMouseEvent(Boolean click, ChartMouseEvent me) {
        if (this.chartMenu != null && this.chartMenu.isVisible()) {
            return;
        }
        XYPlot plot = (XYPlot)this.chart.getPlot();
        if (click.booleanValue() && this.cursorState == CursorState.moving) {
            this.cursorState = CursorState.off;
            click = false;
            if (this.popupValues != null) {
                this.popupValues.setVisible(false);
                this.popupValues = null;
            }
        }
        if (this.cursorState == CursorState.off && this.cursorLine != null) {
            this.chart.getXYPlot().removeAnnotation(this.cursorLine);
            this.cursorLine = null;
            this.chart.setNotify(true);
        }
        if (this.markerLine != null && this.cursorState == CursorState.off) {
            this.chart.getXYPlot().removeAnnotation(this.markerLine);
            this.chart.getXYPlot().removeAnnotation(this.markerText);
            this.markerLine = null;
        }
        if (!this.cursorPossible) {
            return;
        }
        if (click.booleanValue() || this.cursorState == CursorState.moving) {
            if (this.popupValues == null) {
                this.popupValues = new PopupValues((Component)Main.main.frame, this.domainColumn);
                this.popupValues.setVisible(true);
            }
            this.cursorState = CursorState.moving;
            Point2D p = this.chartPanel.translateScreenToJava2D(new Point(0, 0));
            double x = p.getX() + me.getTrigger().getPoint().getX();
            double y = p.getY() + me.getTrigger().getPoint().getY();
            p = new Point((int)x, (int)y);
            Rectangle2D plotArea = this.chartPanel.getScreenDataArea();
            this.moveCursor(plot.getDomainAxis().java2DToValue(p.getX(), plotArea, plot.getDomainAxisEdge()));
        }
    }

    private void moveCursor(double pos) {
        if (this.cursorLine != null) {
            this.chart.getXYPlot().removeAnnotation(this.cursorLine);
            this.cursorLine = null;
        }
        XYPlot plot = (XYPlot)this.chart.getPlot();
        double lower = plot.getRangeAxis().getLowerBound();
        double upper = plot.getRangeAxis().getUpperBound();
        this.cursorPosition = pos;
        if (this.popupValues != null) {
            double div = Support.dataBase.header().getColumnName(this.domainColumn).equals("dateTime") ? 1000 : 1;
            if (!this.popupValues.updataValues(this.domainColumn, this.cursorPosition / div, this.markerLine != null ? Double.valueOf(this.markerPosition / div) : null)) {
                this.popupValues = null;
            }
            PopupChartLayout.updataValues(this.domainColumn, this.cursorPosition / div);
        }
        this.cursorLine = new XYLineAnnotation(this.cursorPosition, lower, this.cursorPosition, upper, new BasicStroke(2.0f), Color.CYAN);
        this.chart.getXYPlot().addAnnotation(this.cursorLine);
        this.chart.setNotify(true);
    }

    private double cursorPositionToSeconds() {
        int row = Support.dataBase.findSampleIndex(Support.dataBase.header().getColumnName(this.domainColumn), this.cursorPosition);
        if (row < 0 || row >= Support.dataBase.rows()) {
            return 0.0;
        }
        return Support.dataBase.getValue(row, this.timeColumn);
    }

    private void zoomChart(String cmd) {
        int i = cmd.indexOf(58);
        if (i < 0) {
            return;
        }
        if ((cmd = cmd.substring(i + 1)).equals("All")) {
            this.firstSampleTextField.setText("");
            this.lastSampleTextField.setText("");
        } else {
            int range = StringUtil.parseInt(cmd);
            double start = Math.max(0.0, this.cursorPositionToSeconds() - (double)(range / 2));
            this.firstSampleTextField.setText(Support.formatTime(start));
            double max = Support.dataBase.rows();
            if (this.timeColumn >= 0) {
                max = Support.dataBase.getValue(Support.dataBase.rows() - 1, this.timeColumn);
            }
            this.lastSampleTextField.setText(Support.formatTime(start + Math.min((double)range, max)));
        }
        this.parseInput();
    }

    public String getDomainColumn() {
        String s = Support.dataBase.header().getColumnName(this.domainColumn);
        if (s.equals("time") && this.timeStampCheckBox.isSelected()) {
            return "hhmmss";
        }
        return s;
    }

    private void selectDomainColumn(String name) {
        this.lastDomainColumn = name;
        this.domainColumn = Support.dataBase.header().getIndex(this.lastDomainColumn);
        this.cursorPossible = Support.dataBase.getSlope(this.domainColumn) != DataBase.Slope.unspecified;
        this.setupCurveIndexes();
        this.updateData(true);
    }

    private BufferedImage generateImage(int w, int h, String fname) {
        BufferedImage image = new BufferedImage(w, h, 1);
        int i = fname.lastIndexOf(46);
        if (i > 0) {
            fname = fname.substring(0, i);
        }
        if (fname.length() > 0) {
            this.chart.setTitle(fname);
        } else {
            this.chart.setTitle("Test controller");
        }
        if (Support.chartFontColor != null) {
            this.chart.getTitle().setPaint(Support.chartFontColor);
        }
        if (Support.chartHeaderColor != null) {
            this.chart.getTitle().setPaint(Support.chartHeaderColor);
        }
        if (this.cursorLine != null) {
            this.chart.getXYPlot().removeAnnotation(this.cursorLine);
        }
        this.chart.draw(image.createGraphics(), new Rectangle(w, h));
        this.chart.setTitle("");
        return image;
    }

    public void saveChart(String fname, int w, int h) {
        this.addCheckboxes();
        this.setupCurveIndexes();
        this.updateData(true);
        try {
            File f = Support.fileWithExtension(fname, Support.getDataPath(), ".png");
            ImageIO.write((RenderedImage)this.generateImage(w, h, Support.chartTitle != null ? Support.chartTitle : f.getName()), "png", f);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public void saveChart() {
        ChartSaveResolutionPanel savePanel = new ChartSaveResolutionPanel();
        FontAdjust.FontFileChooser fc = new FontAdjust.FontFileChooser();
        try {
            fc.setCurrentDirectory(new File(Support.getDataPath()));
        }
        catch (Exception exception) {
            System.out.println("Failed to set director: " + Support.getDataPath());
        }
        fc.setFileFilter(new FileNameExtensionFilter("PNG", "png"));
        fc.setAcceptAllFileFilterUsed(false);
        fc.setAccessory(savePanel.getPanel());
        while (true) {
            int option = 0;
            if (fc.showDialog(null, "Save chart") != 0) break;
            File f = Support.fileWithExtension(fc.getSelectedFile().getAbsolutePath(), null, ".png");
            if (!savePanel.isValid()) {
                option = 1;
            }
            if (option == 0 && f.exists() && (option = JOptionPane.showConfirmDialog(null, "File exists, overwrite?", "File exists", 1)) == 2) {
                return;
            }
            if (option != 0) continue;
            Support.setDataPath(fc.getCurrentDirectory().getPath());
            Dimension dim = savePanel.getSize();
            try {
                ImageIO.write((RenderedImage)this.generateImage(dim.width, dim.height, Support.chartTitle != null ? Support.chartTitle : f.getName()), "png", f);
                return;
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    public List<String> generateScript() {
        ArrayList<String> list = new ArrayList<String>();
        if (Support.dataBase.header().columns() == 0) {
            list.add(";; No table data present to select curves");
        } else {
            StringBuilder sb = new StringBuilder();
            for (String s : this.checkedColumns) {
                if (s.length() > 0) {
                    sb.append(" ");
                }
                sb.append(s);
            }
            sb.insert(0, "#ChartCurves ");
            list.add(sb.toString());
        }
        if (this.domainColumn >= 0 && !Support.dataBase.header().getColumnName(this.domainColumn).equals("time")) {
            list.add("#ChartX " + Support.dataBase.header().getColumnName(this.domainColumn));
        } else if (this.useTimeStamp) {
            list.add("#ChartX hhmmss");
        } else {
            list.add("#ChartX time");
        }
        list.add("#ChartSamples \"" + Support.conditionalQuote(this.firstSampleTextField.getText().trim()) + " " + Support.conditionalQuote(this.lastSampleTextField.getText().trim()));
        return list;
    }

    static enum CursorState {
        off,
        on,
        moving;

    }

    private class CurveIndex {
        private int chartIndex = -1;
        private int dbIndex;
        private String dbName;
        private String maskName;
        private int mask = 0;
        private String name;
        private DefaultXYDataset dataset = new DefaultXYDataset();
        private ValueAxis axis = null;

        private CurveIndex(String name) throws Exception {
            this.name = name;
            int i = name.lastIndexOf(32);
            if (i >= 0 && Support.dataBase.header().isDigital(name)) {
                this.dbName = name.substring(0, i);
                this.dbIndex = Support.dataBase.header().getIndex(this.dbName);
                this.maskName = name.substring(i + 1);
                PaneChart.this.maskNames.add(this.maskName);
                this.mask = Support.dataBase.format().get((int)this.dbIndex).format.getMask(this.maskName);
                if (this.mask == 0) {
                    throw new MaskNotFoundException();
                }
            } else {
                this.dbName = name;
                this.dbIndex = Support.dataBase.header().getIndex(this.dbName);
            }
            if (this.dbIndex < 0) {
                throw new IndexOutOfRangeException();
            }
        }

        public String getMaskName() {
            return this.maskName;
        }

        private int syncToScale(ChartScales.ChartScale cs) {
            String s = cs.getSyncToScale();
            cs.setIsSync(false);
            if (s == null || s.isEmpty() || this.chartIndex == 0) {
                return -1;
            }
            int i = 0;
            while (i < this.chartIndex) {
                if (s.equals(((CurveIndex)((PaneChart)PaneChart.this).curveIndexs.get((int)i)).dbName)) {
                    cs.setIsSync(true);
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private void updateDataset(double offset) {
            ChartScales.ChartScale ci;
            double[][] series = Support.dataBase.getSeries(PaneChart.this.dataBaseRange, 5000, PaneChart.this.domainColumn, this.dbIndex, this.mask, 0.1 + offset, 0.9 + offset);
            if (Support.dataBase.header().getColumnName(PaneChart.this.domainColumn).equals("dateTime")) {
                int i = 0;
                while (i < series[0].length) {
                    double[] dArray = series[0];
                    int n = i++;
                    dArray[n] = dArray[n] * 1000.0;
                }
            }
            if ((ci = Support.chartScales.getScale(this.name)) != null) {
                if (ci.isAxisNameChange()) {
                    int i = 0;
                    while (i < this.dataset.getSeriesCount()) {
                        this.dataset.removeSeries(this.dataset.getSeriesKey(i));
                        ++i;
                    }
                }
                PaneChart.this.filterSeries(PaneChart.this.domainLog, ci.isLog(), series);
                this.dataset.addSeries((Comparable)((Object)ci.getAxisName()), series);
                if (this.mask == 0) {
                    ci.setAxisScale(PaneChart.this.chart.getXYPlot().getRangeAxis(this.chartIndex), series);
                }
            } else {
                PaneChart.this.filterSeries(false, false, series);
                this.dataset = new DefaultXYDataset();
                this.dataset.addSeries((Comparable)((Object)this.name), series);
                if (this.mask == 0) {
                    PaneChart.this.chart.getXYPlot().getRangeAxis(this.chartIndex).setAutoRange(true);
                }
            }
        }

        private void setupAxis(boolean setupMaskIndex) {
            if (this.chartIndex < 0) {
                return;
            }
            Color color = PaneChart.this.getColor(this.chartIndex);
            PaneChart.this.chart.getXYPlot().setDataset(this.chartIndex, this.dataset);
            XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
            renderer.setDefaultShapesVisible(false);
            renderer.setSeriesPaint(0, color);
            renderer.setLegendLine(new Rectangle2D.Double(0.0, 0.0, 15.0, 1.0));
            if (Support.chartFontColor != null) {
                renderer.setDefaultLegendTextPaint(Support.chartFontColor);
                PaneChart.this.chart.getLegend().setBackgroundPaint(Support.chartBorderColor);
            }
            PaneChart.this.chart.getXYPlot().setRenderer(this.chartIndex, renderer);
            if (this.mask != 0) {
                if (setupMaskIndex) {
                    NumberAxis axis = new NumberAxis("Digital");
                    PaneChart.this.chart.getXYPlot().setRangeAxis(PaneChart.this.chartRangeAxisForMask, axis);
                    axis.setAxisLinePaint(Color.black);
                    axis.setTickLabelPaint(Color.black);
                    axis.setTickMarkPaint(Color.black);
                    axis.setLabelPaint(Color.black);
                    axis.setRange(0.0, PaneChart.this.chartMaskCount < 10 ? 10 : PaneChart.this.chartMaskCount);
                    PaneChart.this.chart.getXYPlot().setRangeAxisLocation(PaneChart.this.chartRangeAxisForMask, this.chartIndex == 0 ? AxisLocation.TOP_OR_LEFT : AxisLocation.BOTTOM_OR_RIGHT);
                    ((NumberAxis)PaneChart.this.chart.getXYPlot().getRangeAxis(PaneChart.this.chartRangeAxisForMask)).setNumberFormatOverride(new MaskFormat());
                    axis.setLabelFont(FontAdjust.fontSizes.chartTheme.getLargeFont());
                    axis.setTickLabelFont(FontAdjust.fontSizes.chartTheme.getRegularFont());
                }
                PaneChart.this.chart.getXYPlot().mapDatasetToRangeAxis(this.chartIndex, PaneChart.this.chartRangeAxisForMask);
            } else {
                ChartScales.ChartScale cs = Support.chartScales.getScale(this.name);
                int ii = this.syncToScale(cs);
                if (ii >= 0) {
                    PaneChart.this.chart.getXYPlot().mapDatasetToRangeAxis(this.chartIndex, ii);
                    if (((CurveIndex)((PaneChart)PaneChart.this).curveIndexs.get((int)ii)).axis != null) {
                        String s = ((CurveIndex)((PaneChart)PaneChart.this).curveIndexs.get((int)ii)).axis.getLabel();
                        s = String.valueOf(s) + "    " + cs.getAxisName();
                        ((CurveIndex)((PaneChart)PaneChart.this).curveIndexs.get((int)ii)).axis.setLabel(s);
                    }
                } else {
                    this.axis = cs.isLog() ? new MyLogarithmicAxis(cs.getAxisName()) : new NumberAxis(cs.getAxisName());
                    PaneChart.this.chart.getXYPlot().setRangeAxis(this.chartIndex, this.axis);
                    this.axis.setAxisLinePaint(color);
                    this.axis.setTickLabelPaint(color);
                    this.axis.setTickMarkPaint(color);
                    this.axis.setLabelPaint(color);
                    PaneChart.this.chart.getXYPlot().mapDatasetToRangeAxis(this.chartIndex, this.chartIndex);
                    PaneChart.this.chart.getXYPlot().setRangeAxisLocation(this.chartIndex, this.chartIndex == 0 ? AxisLocation.TOP_OR_LEFT : AxisLocation.BOTTOM_OR_RIGHT);
                    this.axis.setLabelFont(FontAdjust.fontSizes.chartTheme.getLargeFont());
                    this.axis.setTickLabelFont(FontAdjust.fontSizes.chartTheme.getRegularFont());
                    if (cs != null) {
                        this.axis.setAutoRange(false);
                        Support.MyDecimalFormat nf = new Support.MyDecimalFormat();
                        nf.setMaximumFractionDigits(cs.getDecimals());
                        nf.setSIFormat(cs.isSi());
                        ((NumberAxis)PaneChart.this.chart.getXYPlot().getRangeAxis(this.chartIndex)).setNumberFormatOverride(nf);
                    }
                }
            }
        }
    }

    class IndexOutOfRangeException
    extends Exception {
        IndexOutOfRangeException() {
        }
    }

    private class InputChanged
    implements ActionListener {
        private InputChanged() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("ToHist")) {
                Support.paneHistogram.setRange(PaneChart.this.firstSampleTextField.getText(), PaneChart.this.lastSampleTextField.getText());
                Main.selectPane(Support.paneHistogram.getTitle());
            } else if (e.getActionCommand().equals("ToRange")) {
                Support.paneRange.setRange(PaneChart.this.firstSampleTextField.getText(), PaneChart.this.lastSampleTextField.getText());
                Main.selectPane(Support.paneRange.getTitle());
            } else if (e.getActionCommand().equals("ToExport")) {
                Support.showExport(PaneChart.this.firstSampleTextField.getText(), PaneChart.this.lastSampleTextField.getText());
            } else {
                PaneChart.this.parseInput();
            }
        }
    }

    private class InputChangedFocus
    implements FocusListener {
        private InputChangedFocus() {
        }

        @Override
        public void focusGained(FocusEvent arg0) {
        }

        @Override
        public void focusLost(FocusEvent arg0) {
            PaneChart.this.parseInput();
        }
    }

    class MaskFormat
    extends NumberFormat {
        @Override
        public StringBuffer format(double arg0, StringBuffer arg1, FieldPosition arg2) {
            int i = (int)Math.floor(arg0);
            if (i < 0 || i >= PaneChart.this.maskNames.size()) {
                arg1.append("-");
            } else {
                arg1.append((String)PaneChart.this.maskNames.get(i));
            }
            return arg1;
        }

        @Override
        public StringBuffer format(long arg0, StringBuffer arg1, FieldPosition arg2) {
            return arg1;
        }

        @Override
        public Number parse(String arg0, ParsePosition arg1) {
            return null;
        }
    }

    class MaskNotFoundException
    extends Exception {
        MaskNotFoundException() {
        }
    }

    class TimeFormat
    extends NumberFormat {
        private DecimalFormat nf = (DecimalFormat)NumberFormat.getNumberInstance(Locale.ENGLISH);

        public TimeFormat() {
            this.nf.setGroupingUsed(false);
            this.nf.setMaximumFractionDigits(2);
        }

        @Override
        public StringBuffer format(double arg0, StringBuffer arg1, FieldPosition arg2) {
            if (PaneChart.this.useTimeStamp && PaneChart.this.currentTimeUnit != TimeUnit.index) {
                arg1.append(Support.toHMS1(arg0));
            } else if (PaneChart.this.currentTimeUnit == TimeUnit.seconds) {
                this.nf.setMaximumFractionDigits(PaneChart.this.cursorRightPosition - PaneChart.this.cursorLeftPosition <= 2.0 ? 2 : 1);
                this.nf.format(arg0, arg1, arg2);
                arg1.append('s');
            } else if (PaneChart.this.currentTimeUnit == TimeUnit.minutes) {
                this.nf.setMaximumFractionDigits(2);
                this.nf.format(arg0 / 60.0, arg1, arg2);
                arg1.append('m');
            } else if (PaneChart.this.currentTimeUnit == TimeUnit.hours) {
                this.nf.setMaximumFractionDigits(2);
                this.nf.format(arg0 / 3600.0, arg1, arg2);
                arg1.append('h');
            } else if (PaneChart.this.currentTimeUnit == TimeUnit.days) {
                this.nf.setMaximumFractionDigits(2);
                this.nf.format(arg0 / 3600.0 / 24.0, arg1, arg2);
                arg1.append('d');
            } else if (PaneChart.this.currentTimeUnit == TimeUnit.index) {
                this.nf.setMaximumFractionDigits(0);
                this.nf.format(arg0, arg1, arg2);
            }
            return arg1;
        }

        @Override
        public StringBuffer format(long arg0, StringBuffer arg1, FieldPosition arg2) {
            return arg1;
        }

        @Override
        public Number parse(String arg0, ParsePosition arg1) {
            return null;
        }
    }

    static enum TimeUnit {
        index,
        seconds,
        minutes,
        hours,
        days;

    }
}

