/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.database.DataRow;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.Main;
import dk.hkj.main.MathCalculators;
import dk.hkj.main.PopupFFTView;
import dk.hkj.main.Support;
import dk.hkj.main.ValueFormat;
import dk.hkj.script.Script;
import dk.hkj.util.FileUtil;
import dk.hkj.vars.Var;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class Mathematics {
    private List<MathEntry> mathList = new ArrayList<MathEntry>();
    boolean changed = false;
    boolean formatChanged = false;
    private Script script = new Script();
    private final String deliReplacement = "#OROPERATOR#";
    MathTableModel mathTableModel = new MathTableModel(this);

    public static List<String> getTypeList() {
        ArrayList<String> list = new ArrayList<String>();
        MathType[] mathTypeArray = MathType.values();
        int n = mathTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MathType mt = mathTypeArray[n2];
            list.add(mt.name());
            ++n2;
        }
        list.sort(null);
        return list;
    }

    public boolean isChanged() {
        boolean c = this.changed;
        this.changed = false;
        return c;
    }

    public void clearChanged() {
        this.changed = false;
    }

    public Mathematics() {
        this.loadDefault();
    }

    public void clearErrors() {
        for (MathEntry me : this.mathList) {
            me.clearError();
        }
    }

    public void addNewEntry() {
        this.mathList.add(new MathEntry());
        this.mathTableModel.changeNotification();
    }

    public void deleteEntry(String name) {
        int i = this.mathList.size() - 1;
        while (i >= 0) {
            MathEntry me = this.mathList.get(i);
            if (me.getName().equals(name)) {
                this.deleteEntry(i);
            }
            --i;
        }
    }

    public void deleteEntry(int index) {
        if (!this.mathList.get(index).isEnabled() || !InterfaceThreads.isLogging()) {
            this.mathList.remove(index);
            this.mathTableModel.sendNotifications(this.mathList.size());
        }
        this.mathTableModel.changeNotification();
    }

    public void addMathColumns() {
        for (MathEntry me : this.mathList) {
            if (!me.enabled) continue;
            Support.dataBase.header().addHeader(me.getFullName());
            Support.dataBase.format().addFormat(me.getValueFormat());
        }
        PopupFFTView.databaseModified();
    }

    public void disableAll() {
        for (MathEntry me : this.mathList) {
            me.setEnabled(false);
        }
        this.mathTableModel.changeNotification();
    }

    public void resetCalc(String domain) {
        this.script.getLocalVars().clear();
        for (MathEntry me : this.mathList) {
            me.reset(domain);
        }
    }

    public void removeDomain(String domain) {
        for (MathEntry me : this.mathList) {
            me.removeDomain(domain);
        }
    }

    public MathEntry getEntry(String name) {
        for (MathEntry me : this.mathList) {
            if (!me.getName().equals(name)) continue;
            return me;
        }
        return null;
    }

    public MathEntry createEntry(String name) {
        MathEntry me = new MathEntry();
        me.setName(name);
        return me;
    }

    public void addEntry(MathEntry me) {
        this.mathList.add(me);
        this.mathTableModel.changeNotification();
    }

    public List<MathEntry> getEnabledMathEntries() {
        ArrayList<MathEntry> list = new ArrayList<MathEntry>();
        for (MathEntry me : this.mathList) {
            if (!me.enabled) continue;
            list.add(me);
        }
        return list;
    }

    public ValueFormat getValueFormat(String name) {
        ValueFormat vf = null;
        for (MathEntry me : this.mathList) {
            if (!name.equals(me.getName()) && !name.equals(me.getFullName())) continue;
            vf = me.getValueFormat();
            if (!me.isEnabled()) continue;
            return vf;
        }
        return vf != null ? vf : new ValueFormat(name, "", ValueFormat.formatD2);
    }

    public void calcAllColumns(Script script, String domain) {
        double time = (double)System.currentTimeMillis() / 1000.0;
        for (MathEntry me : this.mathList) {
            if (!me.enabled) continue;
            double v = me.calcDirect(domain, time);
            script.getLocalVars().getCreate(me.getFullName()).set(Var.createValue(v));
        }
    }

    public double getChannelValue(String channel, String domain) {
        MathEntry me = null;
        double v = Double.NaN;
        if (channel.startsWith("Math.")) {
            me = Support.math.getEntry(channel.substring(5));
        }
        v = me != null && me.isEnabled() ? me.calcDirect(domain, (double)System.currentTimeMillis() / 1000.0) : Var.gl.get(channel).asDouble();
        return v;
    }

    public void calcMathAllRows(int domainColumn) {
        if (Support.dataBase.rows() == 0 || !this.anyMathEnabled()) {
            return;
        }
        for (MathEntry me : this.mathList) {
            int i;
            if (!me.enabled) continue;
            if (Support.dataBase.addExtraColumn(me.getFullName())) {
                this.formatChanged = true;
            }
            if ((i = Support.dataBase.header().getIndex(me.getFullName())) < 0) continue;
            Support.dataBase.format().get((int)i).format = me.getValueFormat().format;
        }
        this.resetCalc(null);
        int i = 0;
        while (i < Support.dataBase.rows()) {
            this.calcMathColumns(Support.dataBase.getRow(i), domainColumn, false);
            ++i;
        }
        if (this.formatChanged) {
            Main.changeDevicesOrTable(Support.UpdateType.ColumnsTable);
            this.formatChanged = false;
        }
    }

    public boolean anyMathEnabled() {
        for (MathEntry me : this.mathList) {
            if (!me.enabled || me.error) continue;
            return true;
        }
        return false;
    }

    public void calcMathColumns(DataRow dr, int domainColumn, boolean original) {
        if (!this.anyMathEnabled()) {
            return;
        }
        this.script.getLocalVars().clear();
        int j = 0;
        while (j < Support.dataBase.columns()) {
            String name = Support.dataBase.header().getColumnNameAsIdentifier(j);
            this.script.getLocalVars().getCreate(name).set(dr.getValue(j));
            ++j;
        }
        for (MathEntry me : this.mathList) {
            if (!me.isEnabled() || me.getType() == MathType.FormulaNU && !original) continue;
            int j2 = Support.dataBase.header().getIndex(me.getFullName());
            if (!me.enabled) continue;
            me.calcRowPartial(j2, this.script, dr, domainColumn);
        }
    }

    public void saveToFile(File file) {
        ArrayList<String> list = new ArrayList<String>();
        for (MathEntry me : this.mathList) {
            if (me.getName().length() <= 0) continue;
            list.add(me.toString());
        }
        try {
            FileUtil.writeFile(file, list);
        }
        catch (IOException iOException) {}
    }

    public void loadFromFile(File file) {
        try {
            List<String> list = FileUtil.readFileAsList(file);
            for (String line : list) {
                if ((line = line.trim()).length() <= 0 || line.startsWith(";") || !line.contains("|")) continue;
                this.mathList.add(new MathEntry(line));
            }
            this.mathTableModel.changeNotification();
        }
        catch (IOException iOException) {}
    }

    public void saveDefault() {
        this.saveToFile(new File(String.valueOf(Support.getConfigPath()) + "/settingsMath.txt"));
    }

    public void loadDefault() {
        this.loadFromFile(new File(String.valueOf(Support.getConfigPath()) + "/settingsMath.txt"));
        this.changed = true;
    }

    public TableModel getTableModel() {
        return this.mathTableModel;
    }

    public List<String> generateScriptMath() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("#Math");
        for (MathEntry m : this.mathList) {
            if (!m.isEnabled()) continue;
            list.add("#Math " + m.getName() + " \"" + m.getUnit() + "\" " + (Object)((Object)m.getType()) + " " + m.getSamples() + " " + Support.conditionalQuote(m.getFormula()));
        }
        return list;
    }

    public List<String> generateScriptValueFormats() {
        ArrayList<String> list = new ArrayList<String>();
        for (MathEntry m : this.mathList) {
            if (!m.isEnabled()) continue;
            list.add("#ValueFormat Math." + m.name + " " + m.getValueFormat().format.toString());
        }
        return list;
    }

    public class MathEntry {
        private String name = "";
        private boolean enabled = false;
        private MathType type = MathType.Formula;
        private int samples = 30;
        private String formula = "";
        private String unit = "";
        private boolean error = false;
        private String errorMessage = "";
        private MathCalculators.MathBaseCalc calc = null;
        private Map<String, MathCalculators.MathBaseCalc> extraCalc = new HashMap<String, MathCalculators.MathBaseCalc>();

        MathEntry() {
            this.name = "Undefined";
            this.setType(MathType.Formula);
        }

        public void clearError() {
            this.error = false;
        }

        public MathEntry(String line) {
            for (Support.ConfigLineElement element : new Support.ConfigLineSplitter(line)) {
                if (element.name.equalsIgnoreCase("name")) {
                    this.setName(element.value);
                    continue;
                }
                if (element.name.equalsIgnoreCase("enabled")) {
                    this.setEnabled(Integer.parseInt(element.value) != 0);
                    continue;
                }
                if (element.name.equalsIgnoreCase("type")) {
                    this.setType(element.value);
                    continue;
                }
                if (element.name.equalsIgnoreCase("samples")) {
                    this.setSamples(element.value);
                    continue;
                }
                if (element.name.equalsIgnoreCase("unit")) {
                    this.setUnit(element.value);
                    continue;
                }
                if (!element.name.equalsIgnoreCase("formula")) continue;
                this.setFormula(element.value.replace("#OROPERATOR#", "|"));
            }
            if (this.calc == null) {
                this.setType(MathType.Formula);
            }
            Mathematics.this.changed = true;
        }

        public void reset(String domain) {
            if (domain == null) {
                this.calc.reset();
            } else {
                MathCalculators.MathBaseCalc c = this.extraCalc.get(domain);
                if (c == null) {
                    c = MathCalculators.getCalculator(this.type, this);
                    this.extraCalc.put(domain, c);
                }
                c.reset();
            }
        }

        public void removeDomain(String domain) {
            this.extraCalc.remove(domain);
        }

        public ValueFormat getValueFormat() {
            ValueFormat vf = this.calc == null ? null : this.calc.getValueFormat();
            return vf == null ? new ValueFormat("", this.unit, ValueFormat.formatD4) : vf;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("name:");
            sb.append(this.name);
            sb.append("|");
            sb.append("enabled:");
            sb.append(this.enabled ? 1 : 0);
            sb.append("|");
            sb.append("type:");
            sb.append(this.type.name());
            sb.append("|");
            sb.append("samples:");
            sb.append(this.samples);
            sb.append("|");
            sb.append("unit:");
            sb.append(this.unit);
            sb.append("|");
            sb.append("formula:");
            sb.append(this.formula.replace("|", "#OROPERATOR#"));
            return sb.toString();
        }

        public void calcRowComplete(DataRow dataRow, int domainColumn) {
            if (!this.enabled) {
                return;
            }
            Mathematics.this.script.getLocalVars().clear();
            double[] data = dataRow.getRow();
            StringBuilder sb = new StringBuilder();
            try {
                int j = Support.dataBase.header().getIndex(this.getFullName());
                int i = 0;
                while (i < j) {
                    String name = Support.dataBase.header().getColumnNameAsIdentifier(j);
                    sb.append(String.valueOf(name) + ", ");
                    double value = data[i];
                    Mathematics.this.script.getLocalVars().getCreate(name).set(value);
                    ++i;
                }
                double v = 0.0;
                if (!this.error) {
                    v = Mathematics.this.script.expression(this.formula).asDouble();
                    v = this.calc.processValue(v, dataRow.getValue(domainColumn));
                }
                dataRow.setValue(j, v);
            }
            catch (Exception e) {
                this.error = true;
                this.errorMessage = e.getMessage();
                System.out.println("Error: " + this.errorMessage);
                System.out.println("Formula: " + this.formula);
                System.out.println("Vars: " + sb.toString());
            }
        }

        public void calcRowPartial(int myIndex, Script script, DataRow dataRow, int domainColumn) {
            if (!this.enabled) {
                return;
            }
            try {
                if (this.error) {
                    dataRow.setValue(myIndex, 0.0);
                    return;
                }
                double v = script.expression(this.formula).asDouble();
                v = this.calc.processValue(v, dataRow.getValue(domainColumn));
                dataRow.setValue(myIndex, v);
            }
            catch (Exception e) {
                this.error = true;
                this.errorMessage = e.getMessage();
                this.enabled = false;
                System.out.println("Error: " + this.errorMessage);
                e.printStackTrace();
                System.out.println("Formula: " + this.formula);
                Mathematics.this.mathTableModel.sendNotifications(dataRow.getRowIndex());
            }
        }

        public double calcDirect(String domain, double currentTime) {
            MathCalculators.MathBaseCalc c = this.calc;
            if (domain != null) {
                c = this.extraCalc.get(domain);
            }
            double v = 0.0;
            if (!this.enabled || this.error || c == null) {
                return v;
            }
            try {
                v = Mathematics.this.script.expression(this.formula).asDouble();
                v = c.processValue(v, currentTime);
            }
            catch (Exception e) {
                this.error = true;
                this.errorMessage = e.getMessage();
                System.out.println("Error: " + this.errorMessage);
                e.printStackTrace();
                System.out.println("Formula: " + this.formula);
                Mathematics.this.mathTableModel.sendNotifications();
            }
            return v;
        }

        public String getFullName() {
            return "Math." + this.name;
        }

        public String getName() {
            return this.name;
        }

        public String getUnit() {
            return this.unit == null ? "" : this.unit;
        }

        public boolean isError() {
            return this.error;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public void setName(String name) {
            if (InterfaceThreads.isLogging()) {
                return;
            }
            this.name = Support.filterToIdentifier(name);
            Mathematics.this.changed = true;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            if (InterfaceThreads.isLogging()) {
                return;
            }
            if (this.enabled != enabled) {
                Mathematics.this.formatChanged = true;
                Mathematics.this.changed = true;
            }
            this.enabled = enabled;
        }

        public MathType getType() {
            return this.type;
        }

        public void setUnit(String unit) {
            if (InterfaceThreads.isLogging()) {
                return;
            }
            this.unit = unit == null ? "" : unit.replace("|", "");
        }

        public void setType(MathType type) {
            if (InterfaceThreads.isLogging()) {
                return;
            }
            this.type = type;
            Mathematics.this.changed = true;
            this.calc = MathCalculators.getCalculator(type, this);
        }

        public boolean setType(String type) {
            MathType[] mathTypeArray = MathType.values();
            int n = mathTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                MathType mt = mathTypeArray[n2];
                if (mt.name().equals(type)) {
                    this.setType(mt);
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public int getSamples() {
            return this.samples;
        }

        public synchronized void setSamples(int samples) {
            if (InterfaceThreads.isLogging()) {
                return;
            }
            this.samples = samples;
            this.calc = MathCalculators.getCalculator(this.type, this);
            ArrayList<String> domains = new ArrayList<String>();
            domains.addAll(this.extraCalc.keySet());
            this.extraCalc.clear();
            for (String domain : domains) {
                this.extraCalc.put(domain, MathCalculators.getCalculator(this.type, this));
            }
            Mathematics.this.changed = true;
        }

        public boolean setSamples(String samples) {
            try {
                if (samples.equals("-") || samples.length() == 0) {
                    this.setSamples(1);
                } else {
                    this.setSamples(Integer.parseInt(samples));
                }
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }

        public String getFormula() {
            return this.formula;
        }

        public void setFormula(String formula) {
            if (InterfaceThreads.isLogging()) {
                return;
            }
            this.formula = formula.trim();
            Mathematics.this.changed = true;
        }

        public boolean needSamples() {
            return this.calc != null ? this.calc.needSamples() : false;
        }
    }

    public class MathTableModel
    implements TableModel {
        private Mathematics math = null;
        private List<TableModelListener> listeners = new ArrayList<TableModelListener>();

        MathTableModel(Mathematics math) {
            this.math = math;
        }

        @Override
        public void addTableModelListener(TableModelListener arg0) {
            this.listeners.add(arg0);
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Boolean.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return MathType.class;
                }
                case 4: {
                    return String.class;
                }
                case 5: {
                    return String.class;
                }
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Enabled";
                }
                case 2: {
                    return "Unit";
                }
                case 3: {
                    return "Type";
                }
                case 4: {
                    return "Samples";
                }
                case 5: {
                    return "Source formula";
                }
            }
            return "?";
        }

        @Override
        public int getRowCount() {
            return Mathematics.this.mathList.size();
        }

        public MathEntry getMathEntry(int row) {
            return (MathEntry)Mathematics.this.mathList.get(row);
        }

        @Override
        public Object getValueAt(int row, int column) {
            MathEntry me = (MathEntry)Mathematics.this.mathList.get(row);
            switch (column) {
                case 0: {
                    return me.getName();
                }
                case 1: {
                    return me.isEnabled();
                }
                case 2: {
                    return me.getUnit();
                }
                case 3: {
                    return me.getType().name();
                }
                case 4: {
                    return me.needSamples() ? Integer.valueOf(me.getSamples()) : "-";
                }
                case 5: {
                    return me.getFormula();
                }
            }
            return "?";
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            MathEntry me = (MathEntry)Mathematics.this.mathList.get(row);
            switch (column) {
                case 0: {
                    return !me.enabled || !InterfaceThreads.isLogging();
                }
                case 1: {
                    return !InterfaceThreads.isLogging();
                }
                case 2: {
                    return !me.enabled || !InterfaceThreads.isLogging();
                }
                case 3: {
                    return !me.enabled || !InterfaceThreads.isLogging();
                }
                case 4: {
                    return ((MathEntry)Mathematics.this.mathList.get(row)).needSamples() && (!me.enabled || !InterfaceThreads.isLogging());
                }
                case 5: {
                    return !me.enabled || !InterfaceThreads.isLogging();
                }
            }
            return false;
        }

        @Override
        public void removeTableModelListener(TableModelListener arg0) {
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (row >= Mathematics.this.mathList.size()) {
                return;
            }
            MathEntry me = (MathEntry)Mathematics.this.mathList.get(row);
            switch (column) {
                case 0: {
                    me.setName((String)value);
                    break;
                }
                case 1: {
                    me.setEnabled((Boolean)value);
                    me.error = false;
                    this.sendNotifications(row);
                    break;
                }
                case 2: {
                    me.setUnit((String)value);
                    break;
                }
                case 3: {
                    me.setType((String)value);
                    me.error = false;
                    this.sendNotifications(row);
                    break;
                }
                case 4: {
                    me.setSamples((String)value);
                    break;
                }
                case 5: {
                    me.setFormula((String)value);
                    me.error = false;
                    this.sendNotifications(row);
                    break;
                }
            }
        }

        private void sendNotifications() {
            if (Mathematics.this.formatChanged) {
                Mathematics.this.formatChanged = false;
                for (TableModelListener ml : this.listeners) {
                    ml.tableChanged(new TableModelEvent(Mathematics.this.mathTableModel, -1));
                }
            }
            for (TableModelListener ml : this.listeners) {
                ml.tableChanged(new TableModelEvent(Mathematics.this.mathTableModel));
            }
        }

        private void sendNotifications(int row) {
            if (Mathematics.this.mathTableModel.getRowCount() > 0) {
                for (TableModelListener ml : this.listeners) {
                    ml.tableChanged(new TableModelEvent(Mathematics.this.mathTableModel, row, row));
                }
            }
        }

        public void changeNotification() {
            if (SwingUtilities.isEventDispatchThread()) {
                this.sendNotifications();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MathTableModel.this.sendNotifications();
                    }
                });
            }
        }
    }

    public static enum MathType {
        Formula,
        FormulaNU,
        Average,
        Slope,
        Min,
        Max,
        RollingSum,
        TotalSum,
        SumTimeSec,
        SumTimeMin,
        SumTimeHour,
        Change,
        Delta,
        Range,
        RMS,
        FilterLP,
        FilterHP,
        Digital,
        DropOutFilter,
        StdDev,
        StdDevRunning;

    }
}

