/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.Mathematics;
import dk.hkj.main.ValueFormat;

public class MathCalculators {
    public static MathBaseCalc getCalculator(Mathematics.MathType mt, Mathematics.MathEntry me) {
        if (mt == Mathematics.MathType.Formula) {
            return new MathNoneCalc(me);
        }
        if (mt == Mathematics.MathType.FormulaNU) {
            return new MathFormulaNU(me);
        }
        if (mt == Mathematics.MathType.Average) {
            return new MathAverageCalc(me);
        }
        if (mt == Mathematics.MathType.Max) {
            return new MathMaximumCalc(me);
        }
        if (mt == Mathematics.MathType.Min) {
            return new MathMinimumCalc(me);
        }
        if (mt == Mathematics.MathType.Slope) {
            return new MathSlopeCalc(me);
        }
        if (mt == Mathematics.MathType.RollingSum) {
            return new MathRollingSumCalc(me);
        }
        if (mt == Mathematics.MathType.Change) {
            return new MathChangeCalc(me);
        }
        if (mt == Mathematics.MathType.Delta) {
            return new MathDeltaCalc(me);
        }
        if (mt == Mathematics.MathType.Range) {
            return new MathRangeCalc(me);
        }
        if (mt == Mathematics.MathType.RMS) {
            return new MathRmsCalc(me);
        }
        if (mt == Mathematics.MathType.TotalSum) {
            return new MathTotalSumCalc(me);
        }
        if (mt == Mathematics.MathType.SumTimeSec) {
            return new MathSumTimeCalc(me, 1);
        }
        if (mt == Mathematics.MathType.SumTimeMin) {
            return new MathSumTimeCalc(me, 60);
        }
        if (mt == Mathematics.MathType.SumTimeHour) {
            return new MathSumTimeCalc(me, 3600);
        }
        if (mt == Mathematics.MathType.FilterLP) {
            return new MathFilterLPCalc(me);
        }
        if (mt == Mathematics.MathType.Digital) {
            return new MathDigital(me);
        }
        if (mt == Mathematics.MathType.DropOutFilter) {
            return new MathDropOutFilterCalc(me);
        }
        if (mt == Mathematics.MathType.StdDev) {
            return new MathStdDevCalc(me);
        }
        if (mt == Mathematics.MathType.StdDevRunning) {
            return new MathStdDevRunningCalc(me);
        }
        if (mt == Mathematics.MathType.FilterHP) {
            return new MathFilterHPCalc(me);
        }
        return null;
    }

    static class MathAverageCalc
    extends MathRollingCalc {
        private MathAverageCalc(Mathematics.MathEntry me) {
            super(me);
        }

        @Override
        protected double calcValue() {
            double sum = 0.0;
            int i = 0;
            while (i < this.n) {
                sum += this.buffer[i];
                ++i;
            }
            return sum / (double)this.n;
        }
    }

    static abstract class MathBaseCalc {
        protected Mathematics.MathEntry me = null;
        protected ValueFormat vf = null;

        private MathBaseCalc(Mathematics.MathEntry me) {
            this.me = me;
        }

        public abstract double processValue(double var1, double var3);

        public void reset() {
        }

        public boolean needSamples() {
            return false;
        }

        public ValueFormat getValueFormat() {
            if (this.vf == null) {
                this.vf = new ValueFormat("", this.me.getUnit(), ValueFormat.formatD4);
            }
            return this.vf;
        }
    }

    static class MathChangeCalc
    extends MathRollingCalc {
        private MathChangeCalc(Mathematics.MathEntry me) {
            super(me);
        }

        @Override
        protected double calcValue() {
            return this.buffer[0] - this.buffer[this.n - 1];
        }
    }

    static class MathDeltaCalc
    extends MathRollingCalc {
        private MathDeltaCalc(Mathematics.MathEntry me) {
            super(me);
        }

        @Override
        protected double calcValue() {
            if (this.n < 2) {
                return 0.0;
            }
            double d = this.buffer[0] - this.buffer[1];
            int i = 1;
            while (i < this.n - 1) {
                double dd = this.buffer[i] - this.buffer[i + 1];
                if (Math.abs(dd) > Math.abs(d)) {
                    d = dd;
                }
                ++i;
            }
            return d;
        }
    }

    static class MathDigital
    extends MathBaseCalc {
        private int bits = 1;
        private int[] mask;

        private MathDigital(Mathematics.MathEntry me) {
            super(me);
            int[] nArray = new int[17];
            nArray[1] = 1;
            nArray[2] = 3;
            nArray[3] = 7;
            nArray[4] = 15;
            nArray[5] = 31;
            nArray[6] = 63;
            nArray[7] = 127;
            nArray[8] = 255;
            nArray[9] = 511;
            nArray[10] = 1023;
            nArray[11] = 2047;
            nArray[12] = 4095;
            nArray[13] = 8191;
            nArray[14] = 16383;
            nArray[15] = Short.MAX_VALUE;
            nArray[16] = 65535;
            this.mask = nArray;
            this.bits = me.getSamples();
            if (this.bits < 1) {
                this.bits = 1;
            } else if (this.bits > 16) {
                this.bits = 16;
            }
        }

        @Override
        public double processValue(double value, double time) {
            long v = (long)value;
            return v &= (long)this.mask[this.bits];
        }

        @Override
        public boolean needSamples() {
            return true;
        }

        @Override
        public ValueFormat getValueFormat() {
            if (this.vf == null) {
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (i < this.bits) {
                    sb.append("B");
                    sb.append(i);
                    sb.append(" ");
                    ++i;
                }
                this.vf = new ValueFormat("", this.me.getUnit(), new ValueFormat.ValueFormatterDigital(sb.toString()));
            }
            return this.vf;
        }
    }

    static class MathDropOutFilterCalc
    extends MathRollingTimeCalc {
        private MathDropOutFilterCalc(Mathematics.MathEntry me) {
            super(me);
        }

        @Override
        protected double calcValue() {
            double sum = 0.0;
            int i = 0;
            while (i < this.n) {
                sum += this.valueBuffer[i];
                ++i;
            }
            sum /= (double)this.n;
            double deltasum = 0.0;
            int i2 = 0;
            while (i2 < this.n) {
                deltasum += Math.abs(sum - this.valueBuffer[i2]);
                ++i2;
            }
            deltasum = deltasum / (double)this.n * 3.0;
            if (Math.abs(this.valueBuffer[0] - sum) <= deltasum) {
                return this.valueBuffer[0];
            }
            double cursum = 0.0;
            int i3 = 0;
            while (i3 < this.n / 3) {
                cursum += this.valueBuffer[i3];
                ++i3;
            }
            if (Math.abs((cursum /= (double)(this.n / 3)) - sum) > deltasum) {
                return this.valueBuffer[0];
            }
            cursum = 0.0;
            int j = 0;
            int i4 = 0;
            while (i4 < this.n / 3) {
                if (Math.abs(this.valueBuffer[i4] - sum) <= deltasum) {
                    cursum += this.valueBuffer[i4];
                    ++j;
                }
                ++i4;
            }
            return cursum /= (double)j;
        }
    }

    static class MathDummyCalc
    extends MathBaseCalc {
        public MathDummyCalc(Mathematics.MathEntry me) {
            super(me);
        }

        @Override
        public double processValue(double value, double time) {
            return 8888.88;
        }
    }

    static class MathFilterHPCalc
    extends MathBaseCalc {
        private double smoothedValue = 0.0;
        private int count = 0;

        MathFilterHPCalc(Mathematics.MathEntry me) {
            super(me);
            this.me = me;
            this.count = me.getSamples();
        }

        @Override
        public double processValue(double value, double time) {
            this.smoothedValue += (value - this.smoothedValue) / (double)this.count;
            return value - this.smoothedValue;
        }

        @Override
        public void reset() {
            this.smoothedValue = 0.0;
        }

        @Override
        public boolean needSamples() {
            return true;
        }
    }

    static class MathFilterLPCalc
    extends MathBaseCalc {
        private double smoothedValue = 0.0;
        private int count = 0;

        MathFilterLPCalc(Mathematics.MathEntry me) {
            super(me);
            this.me = me;
            this.count = me.getSamples();
        }

        @Override
        public double processValue(double value, double time) {
            this.smoothedValue += (value - this.smoothedValue) / (double)this.count;
            return this.smoothedValue;
        }

        @Override
        public void reset() {
            this.smoothedValue = 0.0;
        }

        @Override
        public boolean needSamples() {
            return true;
        }
    }

    static class MathFormulaNU
    extends MathNoneCalc {
        public MathFormulaNU(Mathematics.MathEntry me) {
            super(me);
        }
    }

    static class MathMaximumCalc
    extends MathRollingCalc {
        private MathMaximumCalc(Mathematics.MathEntry me) {
            super(me);
        }

        @Override
        protected double calcValue() {
            double v = -1.7976931348623157E308;
            int i = 0;
            while (i < this.n) {
                if (this.buffer[i] > v) {
                    v = this.buffer[i];
                }
                ++i;
            }
            return v;
        }
    }

    static class MathMinimumCalc
    extends MathRollingCalc {
        private MathMinimumCalc(Mathematics.MathEntry me) {
            super(me);
        }

        @Override
        protected double calcValue() {
            double v = Double.MAX_VALUE;
            int i = 0;
            while (i < this.n) {
                if (this.buffer[i] < v) {
                    v = this.buffer[i];
                }
                ++i;
            }
            return v;
        }
    }

    static class MathNoneCalc
    extends MathBaseCalc {
        public MathNoneCalc(Mathematics.MathEntry me) {
            super(me);
        }

        @Override
        public double processValue(double value, double time) {
            return value;
        }
    }

    static class MathRangeCalc
    extends MathRollingCalc {
        private MathRangeCalc(Mathematics.MathEntry me) {
            super(me);
        }

        @Override
        protected double calcValue() {
            double min = Double.MAX_VALUE;
            double max = -1.7976931348623157E308;
            int i = 0;
            while (i < this.n) {
                if (this.buffer[i] < min) {
                    min = this.buffer[i];
                }
                if (this.buffer[i] > max) {
                    max = this.buffer[i];
                }
                ++i;
            }
            return max - min;
        }
    }

    static class MathRmsCalc
    extends MathRollingCalc {
        private MathRmsCalc(Mathematics.MathEntry me) {
            super(me);
        }

        @Override
        protected double calcValue() {
            double v = 0.0;
            int i = 0;
            while (i < this.n) {
                v += this.buffer[i] * this.buffer[i];
                ++i;
            }
            return Math.sqrt(v / (double)this.n);
        }
    }

    static abstract class MathRollingCalc
    extends MathBaseCalc {
        protected double[] buffer = null;
        protected int n;

        private MathRollingCalc(Mathematics.MathEntry me) {
            super(me);
            this.buffer = new double[me.getSamples()];
            this.n = 0;
        }

        @Override
        public double processValue(double value, double time) {
            int i = Math.min(this.n, this.me.getSamples() - 1);
            while (i > 0) {
                this.buffer[i] = this.buffer[i - 1];
                --i;
            }
            this.buffer[0] = value;
            if (this.n < this.me.getSamples()) {
                ++this.n;
            }
            return this.calcValue();
        }

        @Override
        public void reset() {
            this.n = 0;
        }

        protected abstract double calcValue();

        @Override
        public boolean needSamples() {
            return true;
        }
    }

    static class MathRollingSumCalc
    extends MathRollingCalc {
        private MathRollingSumCalc(Mathematics.MathEntry me) {
            super(me);
        }

        @Override
        protected double calcValue() {
            double v = 0.0;
            int i = 0;
            while (i < this.n) {
                v += this.buffer[i];
                ++i;
            }
            return v;
        }
    }

    static abstract class MathRollingTimeCalc
    extends MathBaseCalc {
        protected double[] timeBuffer = null;
        protected double[] valueBuffer = null;
        protected int n;

        private MathRollingTimeCalc(Mathematics.MathEntry me) {
            super(me);
            this.valueBuffer = new double[me.getSamples()];
            this.timeBuffer = new double[me.getSamples()];
            this.n = 0;
        }

        @Override
        public double processValue(double value, double time) {
            int i = Math.min(this.n, this.me.getSamples() - 1);
            while (i > 0) {
                this.valueBuffer[i] = this.valueBuffer[i - 1];
                this.timeBuffer[i] = this.timeBuffer[i - 1];
                --i;
            }
            this.valueBuffer[0] = value;
            this.timeBuffer[0] = time;
            if (this.n < this.me.getSamples()) {
                ++this.n;
            }
            return this.calcValue();
        }

        @Override
        public void reset() {
            this.n = 0;
        }

        protected abstract double calcValue();

        @Override
        public boolean needSamples() {
            return true;
        }
    }

    static class MathSlopeCalc
    extends MathRollingTimeCalc {
        private MathSlopeCalc(Mathematics.MathEntry me) {
            super(me);
        }

        @Override
        protected double calcValue() {
            double sumx = 0.0;
            double sumy = 0.0;
            double sumxx = 0.0;
            double sumxy = 0.0;
            double t0 = this.timeBuffer[this.n - 1];
            int i = 0;
            while (i < this.n) {
                sumy += this.valueBuffer[i];
                sumx += this.timeBuffer[i] - t0;
                sumxx += (this.timeBuffer[i] - t0) * (this.timeBuffer[i] - t0);
                sumxy += (this.timeBuffer[i] - t0) * this.valueBuffer[i];
                ++i;
            }
            double b = ((double)this.n * sumxy - sumy * sumx) / ((double)this.n * sumxx - sumx * sumx);
            return b;
        }
    }

    static class MathStdDevCalc
    extends MathBaseCalc {
        private int n;
        private double m;
        private double s;

        private MathStdDevCalc(Mathematics.MathEntry me) {
            super(me);
            this.reset();
        }

        @Override
        public void reset() {
            this.n = 0;
            this.m = 0.0;
            this.s = 0.0;
        }

        @Override
        public double processValue(double value, double time) {
            ++this.n;
            double nextm = this.m + (value - this.m) / (double)this.n;
            this.s += (value - this.m) * (value - nextm);
            this.m = nextm;
            return this.n > 1 ? Math.sqrt(this.s / (double)(this.n - 1)) : 0.0;
        }
    }

    static class MathStdDevRunningCalc
    extends MathRollingCalc {
        private MathStdDevRunningCalc(Mathematics.MathEntry me) {
            super(me);
        }

        @Override
        protected double calcValue() {
            double avg = 0.0;
            int i = 0;
            while (i < this.n) {
                avg += this.buffer[i];
                ++i;
            }
            avg /= (double)this.n;
            double var = 0.0;
            int i2 = 0;
            while (i2 < this.n) {
                double v = this.buffer[i2] - avg;
                var += v * v;
                ++i2;
            }
            return this.n > 1 ? Math.sqrt(var / (double)(this.n - 1)) : 0.0;
        }
    }

    static abstract class MathSumCalc
    extends MathBaseCalc {
        protected double sum = 0.0;

        private MathSumCalc(Mathematics.MathEntry me) {
            super(me);
        }

        @Override
        public abstract double processValue(double var1, double var3);

        @Override
        public void reset() {
            this.sum = 0.0;
        }

        @Override
        public boolean needSamples() {
            return false;
        }
    }

    static class MathSumTimeCalc
    extends MathSumCalc {
        private double lastTime;
        private int period;

        private MathSumTimeCalc(Mathematics.MathEntry me, int period) {
            super(me);
            this.period = period;
        }

        @Override
        public double processValue(double value, double time) {
            double dt = time - this.lastTime;
            this.lastTime = time;
            if (Math.abs(value) >= 1.0E99 || dt < 0.0) {
                return this.sum;
            }
            this.sum += value * dt / (double)this.period;
            return this.sum;
        }

        @Override
        public void reset() {
            super.reset();
            this.lastTime = (double)System.currentTimeMillis() / 1000.0;
        }
    }

    static class MathTotalSumCalc
    extends MathSumCalc {
        private MathTotalSumCalc(Mathematics.MathEntry me) {
            super(me);
        }

        @Override
        public double processValue(double value, double time) {
            this.sum += value;
            return this.sum;
        }
    }
}

