/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.comm.CommInterface;
import dk.hkj.comm.VXI11Discovery;
import dk.hkj.database.ScriptFunctions;
import dk.hkj.devices.LoadDeviceConfig;
import dk.hkj.main.CommandProcessor;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.HelpLoader;
import dk.hkj.main.IconGenerator;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.PaneChart;
import dk.hkj.main.PaneCommand;
import dk.hkj.main.PaneConfig;
import dk.hkj.main.PaneCurrentValues;
import dk.hkj.main.PaneHistogram;
import dk.hkj.main.PaneLoadDevices;
import dk.hkj.main.PaneMath;
import dk.hkj.main.PaneRange;
import dk.hkj.main.PaneRemap;
import dk.hkj.main.PaneScales;
import dk.hkj.main.PaneTable;
import dk.hkj.main.PopupAdjustScale;
import dk.hkj.main.PopupAdvancedLog;
import dk.hkj.main.PopupAlarm;
import dk.hkj.main.PopupAutoAdjust;
import dk.hkj.main.PopupAutoHold;
import dk.hkj.main.PopupCalculator;
import dk.hkj.main.PopupChartLayout;
import dk.hkj.main.PopupExport;
import dk.hkj.main.PopupFFTView;
import dk.hkj.main.PopupGridPanel;
import dk.hkj.main.PopupImage;
import dk.hkj.main.PopupImport;
import dk.hkj.main.PopupLogEvent;
import dk.hkj.main.PopupLogEventCapture;
import dk.hkj.main.PopupLogTrigger;
import dk.hkj.main.PopupMPPT;
import dk.hkj.main.PopupModeSelection;
import dk.hkj.main.PopupNewDevice;
import dk.hkj.main.PopupNotes;
import dk.hkj.main.PopupParamAdjuster;
import dk.hkj.main.PopupParamSweeper;
import dk.hkj.main.PopupReadout;
import dk.hkj.main.PopupScriptList;
import dk.hkj.main.PopupSetupSelection;
import dk.hkj.main.PopupShowDevices;
import dk.hkj.main.PopupTestInterface;
import dk.hkj.main.PopupTimer;
import dk.hkj.main.PopupTimerCounter;
import dk.hkj.main.PopupValuesHistogram;
import dk.hkj.main.Support;
import dk.hkj.script.Script;
import dk.hkj.util.StringUtil;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Main {
    public static final String VERSION = "2.38";
    public static final int ManualThresholdWidth = 900;
    public static Main main = null;
    public static boolean busyReconnecting = false;
    public static boolean notifyBusy = false;
    public JFrame frame;
    private JTabbedPane tabbedPane = null;
    private PaneInterface[] panes;
    private boolean notifyChangeInQueue = false;
    public boolean askDemo = true;
    private Timer timer;

    private Main() {
        Support.paneCommand = new PaneCommand();
        Support.paneCurrentValues = new PaneCurrentValues();
        Support.paneTable = new PaneTable();
        Support.paneChart = new PaneChart();
        Support.paneHistogram = new PaneHistogram();
        Support.paneRange = new PaneRange();
        Support.paneScales = new PaneScales();
        Support.paneMath = new PaneMath();
        Support.paneRemap = new PaneRemap();
        Support.paneLoadDevices = new PaneLoadDevices();
        Support.paneConfig = new PaneConfig();
        Script.setLocalSyntax(false);
        this.panes = new PaneInterface[]{Support.paneCommand, Support.paneCurrentValues, Support.paneTable, Support.paneChart, Support.paneHistogram, Support.paneScales, Support.paneRange, Support.paneMath, Support.paneRemap, Support.paneLoadDevices, Support.paneConfig};
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Main.this.createAndShowGUI();
            }
        });
    }

    public void notifyChangeDevicesOrTable(final Support.UpdateType type) {
        if (this.notifyChangeInQueue && type != Support.UpdateType.Devices) {
            return;
        }
        notifyBusy = true;
        if (SwingUtilities.isEventDispatchThread()) {
            this.notifyChangeDevicesOrTableSync(type);
        } else {
            this.notifyChangeInQueue = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Main.this.notifyChangeDevicesOrTableSync(type);
                }
            });
        }
    }

    private void notifyChangeDevicesOrTableSync(Support.UpdateType type) {
        this.notifyChangeInQueue = false;
        try {
            PaneInterface[] paneInterfaceArray = this.panes;
            int n = this.panes.length;
            int n2 = 0;
            while (n2 < n) {
                PaneInterface p = paneInterfaceArray[n2];
                p.changeDevicesOrTable(type);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        if (type == Support.UpdateType.ColumnsTable) {
            ScriptFunctions.get().tableChanged();
        }
        notifyBusy = false;
    }

    private void createAndShowGUI() {
        this.frame = new JFrame("Test Controller");
        this.frame.setIconImage(IconGenerator.makeImage(IconGenerator.IconType.ProgramIcon));
        this.frame.setDefaultCloseOperation(3);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent arg0) {
            }

            @Override
            public void windowClosing(WindowEvent arg0) {
                try {
                    int i = 0;
                    while (i < Main.this.tabbedPane.getTabCount()) {
                        Main.this.panes[i].deselect();
                        ++i;
                    }
                    Support.systemSettings.saveDefault();
                    InterfaceThreads.closeAllDevices();
                    InterfaceThreads.closeAll(true);
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        this.timer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.update();
            }
        });
        this.timer.setRepeats(true);
        this.timer.start();
        Dimension d = new Dimension(1000, 530);
        this.frame.setMinimumSize(d);
        this.frame.setPreferredSize(d);
        this.tabbedPane = new FontAdjust.FontTabbedPane();
        PaneInterface[] paneInterfaceArray = this.panes;
        int n = this.panes.length;
        int n2 = 0;
        while (n2 < n) {
            PaneInterface pi = paneInterfaceArray[n2];
            this.tabbedPane.addTab(pi.getTitle(), pi.getPanel());
            this.tabbedPane.setMnemonicAt(this.tabbedPane.indexOfTab(pi.getTitle()), pi.getHotKey());
            ++n2;
        }
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                int pi = Main.this.tabbedPane.getSelectedIndex();
                int i = 0;
                while (i < Main.this.tabbedPane.getTabCount()) {
                    if (i != pi) {
                        Main.this.panes[i].deselect();
                    }
                    ++i;
                }
                Main.this.panes[pi].select();
            }
        });
        this.tabbedPane.setToolTipTextAt(this.tabbedPane.indexOfTab(Support.paneCommand.getTitle()), "Control of loaded devices, start/top of logging and script control");
        this.tabbedPane.setToolTipTextAt(this.tabbedPane.indexOfTab(Support.paneCurrentValues.getTitle()), "Up to date measurements from all connected devices");
        this.tabbedPane.setToolTipTextAt(this.tabbedPane.indexOfTab(Support.paneTable.getTitle()), "Load data or show logged data in tabular format");
        this.tabbedPane.setToolTipTextAt(this.tabbedPane.indexOfTab(Support.paneScales.getTitle()), "Adjust range, decimals, etc. for scales on chart and histogram pages");
        this.tabbedPane.setToolTipTextAt(this.tabbedPane.indexOfTab(Support.paneMath.getTitle()), "Add calculated data columns/curves");
        this.tabbedPane.setToolTipTextAt(this.tabbedPane.indexOfTab(Support.paneRemap.getTitle()), "Change handle name for devices, can be useful with many of the same device connected");
        this.tabbedPane.setToolTipTextAt(this.tabbedPane.indexOfTab(Support.paneLoadDevices.getTitle()), "Select devices that is active/connected in TestController");
        this.tabbedPane.setToolTipTextAt(this.tabbedPane.indexOfTab(Support.paneConfig.getTitle()), "Adjust handling of invalid values, font size and fixed window positions on the screen");
        this.frame.add(this.tabbedPane);
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        if (Support.systemSettings.screenSize.width >= 900) {
            this.frame.setSize(Support.systemSettings.screenSize);
            this.frame.setLocation(Support.systemSettings.screenUpperLeft);
        }
        this.frame.setVisible(true);
        ToolTipManager.sharedInstance().setDismissDelay(30000);
        Support.systemCommands = HelpLoader.getHelpFile("SystemCommands");
        Support.systemSettings.loadDefault();
        FontAdjust.setFontScale((double)Support.systemSettings.fontSize / 100.0);
        final KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                if (e.getID() == 401 && e.getKeyCode() == 112) {
                    Desktop dt = Desktop.getDesktop();
                    if (dt != null) {
                        try {
                            Window active = manager.getActiveWindow();
                            String url = "https://lygte-info.dk/project/TestControllerIntro%20UK.html";
                            if (active instanceof PopupNewDevice) {
                                url = "https://lygte-info.dk/project/TestControllerConfigDevice%20UK.html";
                            } else if (active instanceof PopupNotes) {
                                url = "https://lygte-info.dk/project/TestControllerIntro%20UK.html";
                            } else if (active instanceof PopupCalculator) {
                                url = "https://lygte-info.dk/project/TestControllerPopupCalculator%20UK.html";
                            } else if (active instanceof PopupSetupSelection) {
                                url = ((PopupSetupSelection)active).getHelpURL();
                            } else if (active instanceof PopupModeSelection) {
                                url = ((PopupModeSelection)active).getHelpURL();
                            } else if (active instanceof PopupTimer) {
                                url = "https://lygte-info.dk/project/TestControllerPopupTimer%20UK.html";
                            } else if (active instanceof PopupTestInterface) {
                                url = "https://lygte-info.dk/project/TestControllerPopupTestInterface%20UK.html";
                            } else if (active instanceof PopupReadout) {
                                url = "https://lygte-info.dk/project/TestControllerPopupReadout%20UK.html";
                            } else if (active instanceof PopupAdvancedLog) {
                                url = "https://lygte-info.dk/project/TestControllerPopupLog%20UK.html";
                            } else if (active instanceof PopupLogTrigger) {
                                url = "https://lygte-info.dk/project/TestControllerPopupLog%20UK.html#Log_trigger_popup";
                            } else if (active instanceof PopupExport) {
                                url = "https://lygte-info.dk/project/TestControllerPopupExport%20UK.html";
                            } else if (active instanceof PopupShowDevices) {
                                url = "https://lygte-info.dk/project/TestControllerPopupConnectedDevices%20UK.html";
                            } else if (active instanceof PopupAlarm) {
                                url = "https://lygte-info.dk/project/TestControllerPopupAlarm%20UK.html";
                            } else if (active instanceof PopupLogEvent || active instanceof PopupLogEventCapture) {
                                url = "https://lygte-info.dk/project/TestControllerPopupLogEvent%20UK.html";
                            } else if (active instanceof PopupAdjustScale) {
                                url = "https://lygte-info.dk/project/TestControllerPopupAdjustScale%20UK.html";
                            } else if (active instanceof PopupParamAdjuster) {
                                url = "https://lygte-info.dk/project/TestControllerPopupParamAdjuster%20UK.html";
                            } else if (active instanceof PopupParamSweeper) {
                                url = "http://lygte-info.dk/project/TestControllerPopupParamSweeper%20UK.html";
                            } else if (active instanceof PopupImage) {
                                url = "https://lygte-info.dk/project/TestControllerPopupImage%20UK.html";
                            } else if (active instanceof PopupImport) {
                                url = "https://lygte-info.dk/project/TestControllerPopupImport%20UK.html";
                            } else if (active instanceof PopupValuesHistogram) {
                                url = "https://lygte-info.dk/project/TestControllerHistogram%20UK.html#Cursor_and_value_popup";
                            } else if (active instanceof PopupAutoHold) {
                                url = "https://lygte-info.dk/project/TestControllerPopupAutoHold%20UK.html";
                            } else if (active instanceof PopupTimerCounter) {
                                url = "https://lygte-info.dk/project/TestControllerPopupTimerCounter%20UK.html";
                            } else if (active instanceof PopupScriptList) {
                                url = "https://lygte-info.dk/project/TestControllerPopupScriptList%20UK.html";
                            } else if (active instanceof PopupGridPanel) {
                                url = "http://lygte-info.dk/project/TestControllerPopupGridPanel%20UK.html";
                            } else if (active instanceof PopupFFTView) {
                                url = "http://lygte-info.dk/project/TestControllerPopupFFTView%20UK.html";
                            } else if (active instanceof PopupChartLayout) {
                                url = "http://lygte-info.dk/project/TestControllerPopupChartLayoutUK.html";
                            } else if (active instanceof PopupMPPT) {
                                url = "http://lygte-info.dk/project/TestControllerPopupMPPT%20UK.html";
                            } else if (active instanceof PopupAutoAdjust) {
                                url = "http://lygte-info.dk/project/TestControllerPopupAutoAdjust%20UK.html";
                            } else if (active == Main.main.frame) {
                                String p = Main.this.tabbedPane.getTitleAt(Main.this.tabbedPane.getSelectedIndex());
                                if (p.equals(Support.paneCommand.getTitle())) {
                                    url = "https://lygte-info.dk/project/TestControllerCommands%20UK.html";
                                } else if (p.equals(Support.paneCurrentValues.getTitle())) {
                                    url = "https://lygte-info.dk/project/TestControllerCurrentValues%20UK.html";
                                } else if (p.equals(Support.paneTable.getTitle())) {
                                    url = "https://lygte-info.dk/project/TestControllerTable%20UK.html";
                                } else if (p.equals(Support.paneChart.getTitle())) {
                                    url = "https://lygte-info.dk/project/TestControllerChart%20UK.html";
                                } else if (p.equals(Support.paneHistogram.getTitle())) {
                                    url = "https://lygte-info.dk/project/TestControllerHistogram%20UK.html";
                                } else if (p.equals(Support.paneScales.getTitle())) {
                                    url = "https://lygte-info.dk/project/TestControllerScales%20UK.html";
                                } else if (p.equals(Support.paneRange.getTitle())) {
                                    url = "https://lygte-info.dk/project/TestControllerRange%20UK.html";
                                } else if (p.equals(Support.paneMath.getTitle())) {
                                    url = "https://lygte-info.dk/project/TestControllerMath%20UK.html";
                                } else if (p.equals(Support.paneRemap.getTitle())) {
                                    url = "https://lygte-info.dk/project/TestControllerRemap%20UK.html";
                                } else if (p.equals(Support.paneLoadDevices.getTitle())) {
                                    url = "https://lygte-info.dk/project/TestControllerLoad%20UK.html";
                                } else if (p.equals(Support.paneConfig.getTitle())) {
                                    url = "https://lygte-info.dk/project/TestControllerConfig%20UK.html";
                                }
                            }
                            if (url != null) {
                                dt.browse(new URI(url));
                            }
                        }
                        catch (Exception exception) {}
                    }
                    return true;
                }
                return false;
            }
        });
    }

    public void updateUI() {
        int selected = this.tabbedPane.getSelectedIndex();
        this.panes[selected].deselect();
        int i = 0;
        while (i < this.tabbedPane.getTabCount()) {
            this.panes[i].select();
            this.panes[i].deselect();
            ++i;
        }
        this.panes[selected].select();
    }

    private void update() {
        int i1;
        if (this.askDemo) {
            this.setupDemo();
            this.askDemo = false;
        }
        if (Support.dataBase.rows() > 0) {
            i1 = this.tabbedPane.indexOfTab(Support.paneChart.getTitle());
            int i2 = this.tabbedPane.indexOfTab(Support.paneHistogram.getTitle());
            int i3 = this.tabbedPane.indexOfTab(Support.paneRange.getTitle());
            this.tabbedPane.setEnabledAt(i1, true);
            this.tabbedPane.setEnabledAt(i2, true);
            this.tabbedPane.setEnabledAt(i3, true);
            this.tabbedPane.setToolTipTextAt(i1, "Show a chart for logged data");
            this.tabbedPane.setToolTipTextAt(i2, "Show a histogram with distribution of values for logged data");
            this.tabbedPane.setToolTipTextAt(i3, "Show calculated values for logged data");
        } else {
            i1 = this.tabbedPane.indexOfTab(Support.paneChart.getTitle());
            int i2 = this.tabbedPane.indexOfTab(Support.paneHistogram.getTitle());
            int i3 = this.tabbedPane.indexOfTab(Support.paneRange.getTitle());
            String hint = "Table must contain data to enable this tab. Start logging or load a csv file.";
            this.tabbedPane.setEnabledAt(i1, false);
            this.tabbedPane.setEnabledAt(i2, false);
            this.tabbedPane.setEnabledAt(i3, false);
            this.tabbedPane.setToolTipTextAt(i1, hint);
            this.tabbedPane.setToolTipTextAt(i2, hint);
            this.tabbedPane.setToolTipTextAt(i3, hint);
        }
        String title = "Test Controller" + (InterfaceThreads.isLoggingToDisk() ? "    Logging to disk" : "") + (InterfaceThreads.loggingMode != InterfaceThreads.LoggingMode.Normal ? "     Trig: " + InterfaceThreads.loggingMode.name() : "");
        if (InterfaceThreads.loggingMode == InterfaceThreads.LoggingMode.NOnCommand || InterfaceThreads.loggingMode == InterfaceThreads.LoggingMode.NOnTrig || InterfaceThreads.loggingMode == InterfaceThreads.LoggingMode.WhileTrigOrN) {
            title = String.valueOf(title) + " (" + InterfaceThreads.trigLogCount + ")";
        }
        this.frame.setTitle(title);
    }

    public static void changeDevicesOrTable(Support.UpdateType type) {
        if (main == null) {
            return;
        }
        main.notifyChangeDevicesOrTable(type);
    }

    public static void selectPane(String name) {
        int index = Main.main.tabbedPane.indexOfTab(name);
        if (Main.main.tabbedPane.isEnabledAt(index)) {
            Main.main.tabbedPane.setSelectedIndex(index);
        }
    }

    private void setupDemo() {
        if (InterfaceThreads.loadDeviceConfig.getRowCount() > 0) {
            return;
        }
        Desktop dt = Desktop.getDesktop();
        if (dt != null) {
            try {
                dt.browse(new URI("http://lygte-info.dk/project/TestControllerInstalling%20UK.html#Starting_TestController"));
            }
            catch (Exception exception) {}
        }
        if (JOptionPane.showConfirmDialog(null, "Load virtual devices for test/demo?", "Test/demo", 0) == 1) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                while (InterfaceThreads.inInitialization()) {
                    CommInterface.sleep(10);
                }
                int i = 0;
                while (i < InterfaceThreads.loadDeviceConfig.getRowCount()) {
                    InterfaceThreads.loadDeviceConfig.getIndex(i).setEnabled(false);
                    ++i;
                }
                LoadDeviceConfig.LoadDevice ld = InterfaceThreads.loadDeviceConfig.addDeviceSecure("VirtualRampGenerator");
                ld.setEnabled(true);
                ld = InterfaceThreads.loadDeviceConfig.addDeviceSecure("VirtualSinusGenerator");
                ld.setEnabled(true);
                ld = InterfaceThreads.loadDeviceConfig.addDeviceSecure("VirtualSquareGenerator");
                ld.setEnabled(true);
                InterfaceThreads.startInterface();
                CommandProcessor.runBackground(StringUtil.stringToList("#logcmds 0\n#waitReady\n#log 0.1\n#clear\n#delay 0.1\n;;\n;; Test devices loaded and logging\n;;\n;; Press F1 for help\n", "\n"), false);
            }
        });
    }

    public static void printOptions() {
        System.out.println("Command line options, must be placed after TextController.jar on the command line");
        System.out.println("debug\tWill turn all debug options on and also log debug output to console");
        System.out.println("debugTime\tSimilar to debug, but will include a timestamp on each line");
        System.out.println("dataDir=path\tDefault save/load path for data and charts");
        System.out.println("configDir=path\tWhere to load and save configuration information from");
        System.out.println("deviceDir=path\tSupplemental path to load custom device definitions from");
        System.out.println("scriptDir=path\tPath to load library script definitions from");
        System.out.println("script=filename\tRun this script when startup is finished");
    }

    public static void main(String[] args) {
        System.out.println("Starting");
        String opt = "";
        String param = "";
        try {
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                String[] s = arg.split("[=]");
                if (s.length == 2) {
                    opt = s[0].trim();
                    param = s[1].trim();
                    if (opt.equalsIgnoreCase("dataDir")) {
                        Support.setDataPath(Paths.get(param, new String[0]).toString());
                    } else if (opt.equalsIgnoreCase("configDir")) {
                        Support.setConfigPath(Paths.get(param, new String[0]).toString());
                    } else if (opt.equalsIgnoreCase("scriptDir")) {
                        Support.setScriptPath(Paths.get(param, new String[0]).toString());
                    } else if (opt.equalsIgnoreCase("deviceDir")) {
                        Support.setDevicePath(Paths.get(param, new String[0]).toString());
                    } else if (opt.equalsIgnoreCase("debugTime")) {
                        InterfaceThreads.debugAll = true;
                        InterfaceThreads.debugTime = StringUtil.parseInt(param);
                    } else if (opt.equalsIgnoreCase("debugCon")) {
                        InterfaceThreads.debugAll = true;
                        InterfaceThreads.debugTime = StringUtil.parseInt(param);
                        InterfaceThreads.debugCon = true;
                    } else if (opt.equalsIgnoreCase("resetDelay")) {
                        Support.resetDelay = (int)(Double.parseDouble(param) * 1000.0);
                    } else if (opt.equalsIgnoreCase("script")) {
                        Support.startupScript = param;
                    }
                } else if (s.length == 1) {
                    opt = s[0].trim();
                    if (opt.equalsIgnoreCase("debug")) {
                        InterfaceThreads.debugAll = true;
                    } else if (opt.equalsIgnoreCase("debugTime")) {
                        InterfaceThreads.debugAll = true;
                        InterfaceThreads.debugTime = 1;
                    } else if (opt.equalsIgnoreCase("debugCon")) {
                        InterfaceThreads.debugAll = true;
                        InterfaceThreads.debugTime = 1;
                        InterfaceThreads.debugCon = true;
                    } else if (opt.equalsIgnoreCase("devices")) {
                        Support.listDevices = true;
                    } else if (opt.equalsIgnoreCase("useHid4Java")) {
                        Support.useHid4Java = true;
                    } else if (opt.equalsIgnoreCase("devlop")) {
                        Support.devlop = true;
                    } else {
                        if (opt.equalsIgnoreCase("discover")) {
                            VXI11Discovery dis = new VXI11Discovery();
                            dis.listDevices();
                            return;
                        }
                        if (opt.equalsIgnoreCase("?") || opt.equalsIgnoreCase("/?") || opt.equalsIgnoreCase("-?")) {
                            Main.printOptions();
                        }
                    }
                }
                ++n2;
            }
            opt = "";
            param = "";
            Support.makeDirs();
            Support.initSupport();
            InterfaceThreads.initInterfaceThreads();
            InterfaceThreads.startInterface();
            InterfaceThreads.loadDeviceConfig.init();
            main = new Main();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            opt.length();
        }
    }

    public String generateLocationParams() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.frame.getLocationOnScreen().x);
        sb.append(" ");
        sb.append(this.frame.getLocationOnScreen().y);
        sb.append(" ");
        sb.append(this.frame.getSize().width);
        sb.append(" ");
        sb.append(this.frame.getSize().height);
        return sb.toString();
    }

    public static List<String> generateScript() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("#ShowPopupSystem Main " + main.generateLocationParams());
        return list;
    }

    public void alignGrid(int pixels) {
        int x = this.frame.getLocationOnScreen().x / pixels * pixels + (pixels - 1) / 2;
        int y = this.frame.getLocationOnScreen().y / pixels * pixels + (pixels - 1) / 2;
        this.frame.setLocation(x, y);
    }

    static interface PaneInterface {
        public String getTitle();

        public JPanel getPanel();

        public int getHotKey();

        public void changeDevicesOrTable(Support.UpdateType var1);

        public void select();

        public void deselect();
    }
}

