/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.comm.CommInterface;
import dk.hkj.comm.DummyInterface;
import dk.hkj.comm.HidClass;
import dk.hkj.comm.LXIInterface;
import dk.hkj.comm.SerialInterface;
import dk.hkj.comm.SocketFilterInterface;
import dk.hkj.comm.SocketInterface;
import dk.hkj.comm.TelnetInterface;
import dk.hkj.comm.UDPInterface;
import dk.hkj.comm.UsbHidInterfaceFile;
import dk.hkj.comm.UsbHidInterfaceHidIO;
import dk.hkj.comm.VXI11Discovery;
import dk.hkj.database.DataRow;
import dk.hkj.devices.DeviceATorch;
import dk.hkj.devices.DeviceATorchPX100;
import dk.hkj.devices.DeviceAppa;
import dk.hkj.devices.DeviceAscii;
import dk.hkj.devices.DeviceAsciiBin;
import dk.hkj.devices.DeviceAsciiBlock;
import dk.hkj.devices.DeviceBK85xx;
import dk.hkj.devices.DeviceBlock;
import dk.hkj.devices.DeviceDMM2;
import dk.hkj.devices.DeviceDischarger;
import dk.hkj.devices.DeviceFlukeDMM;
import dk.hkj.devices.DeviceIT85xx;
import dk.hkj.devices.DeviceKeysightDMM;
import dk.hkj.devices.DeviceModbus;
import dk.hkj.devices.DeviceRelay;
import dk.hkj.devices.DeviceSCPI;
import dk.hkj.devices.DeviceSCPIx;
import dk.hkj.devices.DeviceSerial7Seg;
import dk.hkj.devices.DeviceSingleValue;
import dk.hkj.devices.DeviceSoundcardInput;
import dk.hkj.devices.DeviceSoundcardOutput;
import dk.hkj.devices.DeviceThermoAndMore;
import dk.hkj.devices.DeviceThermoSensor;
import dk.hkj.devices.DeviceUnitDMM;
import dk.hkj.devices.DeviceUsbHidDMM;
import dk.hkj.devices.DeviceUsbHidDevice;
import dk.hkj.devices.DeviceVC8145;
import dk.hkj.devices.LoadDeviceConfig;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.devices.Remapper;
import dk.hkj.devices.ScriptInterface;
import dk.hkj.devices.VirtualBatteryGenerator;
import dk.hkj.devices.VirtualLogGenerator;
import dk.hkj.devices.VirtualPatternGenerator;
import dk.hkj.devices.VirtualRampGenerator;
import dk.hkj.devices.VirtualSinusGenerator;
import dk.hkj.devices.VirtualSquareGenerator;
import dk.hkj.devices.VirtualUserGenerator;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.HelpLoader;
import dk.hkj.main.Main;
import dk.hkj.main.Mathematics;
import dk.hkj.main.PopupAdjustScale;
import dk.hkj.main.PopupAlarm;
import dk.hkj.main.PopupAutoAdjust;
import dk.hkj.main.PopupAutoHold;
import dk.hkj.main.PopupCalculator;
import dk.hkj.main.PopupChart;
import dk.hkj.main.PopupChartLayout;
import dk.hkj.main.PopupFFTView;
import dk.hkj.main.PopupGridPanel;
import dk.hkj.main.PopupImage;
import dk.hkj.main.PopupLogEvent;
import dk.hkj.main.PopupLogTrigger;
import dk.hkj.main.PopupMPPT;
import dk.hkj.main.PopupParamAdjuster;
import dk.hkj.main.PopupParamSweeper;
import dk.hkj.main.PopupReadout;
import dk.hkj.main.PopupScriptList;
import dk.hkj.main.PopupShowDevices;
import dk.hkj.main.PopupTestInterface;
import dk.hkj.main.PopupTimer;
import dk.hkj.main.PopupTimerCounter;
import dk.hkj.main.PopupValues;
import dk.hkj.main.PopupVarDisplay;
import dk.hkj.main.Support;
import dk.hkj.main.ValueFormat;
import dk.hkj.script.Functions;
import dk.hkj.script.Script;
import dk.hkj.shared.SharedInterface;
import dk.hkj.shared.SharedInterfaceList;
import dk.hkj.util.CharacterEscapes;
import dk.hkj.util.LogToWebserver;
import dk.hkj.vars.Var;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;

public class InterfaceThreads {
    private static List<DeviceThread> deviceThreads = null;
    public static Map<String, DeviceThread> deviceMap = new HashMap<String, DeviceThread>();
    private static ConcurrentLinkedQueue<String> logQueue = new ConcurrentLinkedQueue();
    private static LoggingSample loggingSample = null;
    private static LoggingWriter loggingWriter = null;
    protected static long loggingInterval = 0L;
    protected static boolean logData = false;
    protected static int databaseIndex = 0;
    static long loggingStartTime = 0L;
    private static boolean initialization = true;
    static ThreadCommander threadCommander = new ThreadCommander();
    static Remapper remapper = null;
    static LoadDeviceConfig loadDeviceConfig = null;
    static ScriptInterface scriptInterface = new ScriptInterface();
    static SharedInterfaceList sharedInterfaceList = new SharedInterfaceList();
    static long nextVarSetupTime = 0L;
    protected static boolean debugIdnSerial = false;
    protected static boolean debugIdnSocket = false;
    protected static boolean debugIdnUsb = false;
    public static boolean debugAll = false;
    public static int debugTime = 0;
    protected static boolean debugCon = false;
    private static SimpleDateFormat sdfDebug = new SimpleDateFormat("HH:mm:ss.SSS ");
    static long startingNanoTime = System.nanoTime();
    public static LoggingMode loggingMode = LoggingMode.Normal;
    public static String trigExpression = "";
    public static boolean lastTrig = false;
    public static boolean hasTriggered = false;
    public static int trigLogCount = 100;
    private static AtomicBoolean foundUnknownDevice = new AtomicBoolean();
    public static NumberFormat nf2 = NumberFormat.getNumberInstance(Locale.US);
    public static VXI11Discovery discovery;

    static {
        nf2.setMaximumFractionDigits(2);
        nf2.setMinimumFractionDigits(2);
        nf2.setGroupingUsed(false);
        discovery = new VXI11Discovery();
        Functions.addAll();
    }

    public static boolean isTrig(LoggingMode mode) {
        switch (mode) {
            case SingleOnTrig: 
            case SecondOnTrig: 
            case NOnTrig: 
            case WhileTrig: 
            case WhileTrigOrN: 
            case StartOnTrig: 
            case StopOnTrig: 
            case StopOnTrigOrN: {
                return true;
            }
        }
        return false;
    }

    public static List<DeviceThread> getAllDeviceThreads() {
        return deviceThreads;
    }

    public static boolean isManualTrig(LoggingMode mode) {
        return mode.equals((Object)LoggingMode.SingleOnCommand) || mode.equals((Object)LoggingMode.StartStopOnCommand) || mode.equals((Object)LoggingMode.NOnCommand);
    }

    public static boolean isManualTrig() {
        return InterfaceThreads.isManualTrig(loggingMode);
    }

    public static void initInterfaceThreads() {
        remapper = new Remapper();
        loadDeviceConfig = new LoadDeviceConfig();
        sharedInterfaceList.loadDefault();
    }

    public static void initAllColumns() {
        if (InterfaceThreads.isLogging()) {
            return;
        }
        threadCommander.sampleAllDevices(2);
    }

    public static DeviceInterface findDeviceInterfaceFromDeviceDefinition(ManageDeviceDefinitions.DeviceDefinition def) {
        if (def == null) {
            return null;
        }
        if (def.getDeviceName().equals(DeviceThermoSensor.deviceName())) {
            return new DeviceThermoSensor(def);
        }
        if (def.getDeviceName().equals(DeviceRelay.deviceName())) {
            return new DeviceRelay(def);
        }
        if (def.getDeviceName().equals(DeviceThermoAndMore.deviceName())) {
            return new DeviceThermoAndMore(def);
        }
        if (def.getDeviceName().equals(DeviceDischarger.deviceName())) {
            return new DeviceDischarger(def);
        }
        if (def.getDeviceName().equals(VirtualRampGenerator.deviceName())) {
            return new VirtualRampGenerator(def);
        }
        if (def.getDeviceName().equals(VirtualUserGenerator.deviceName())) {
            return new VirtualUserGenerator(def);
        }
        if (def.getDeviceName().equals(VirtualLogGenerator.deviceName())) {
            return new VirtualLogGenerator(def);
        }
        if (def.getDeviceName().equals(VirtualPatternGenerator.deviceName())) {
            return new VirtualPatternGenerator(def);
        }
        if (def.getDeviceName().equals(VirtualSinusGenerator.deviceName())) {
            return new VirtualSinusGenerator(def);
        }
        if (def.getDeviceName().equals(VirtualSquareGenerator.deviceName())) {
            return new VirtualSquareGenerator(def);
        }
        if (def.getDeviceName().equals(DeviceSoundcardOutput.deviceName())) {
            return new DeviceSoundcardOutput(def);
        }
        if (def.getDeviceName().equals(DeviceSoundcardInput.deviceName())) {
            return new DeviceSoundcardInput(def);
        }
        if (def.getDeviceName().equals(VirtualBatteryGenerator.deviceName())) {
            return new VirtualBatteryGenerator(def);
        }
        if ("IT85xx".equalsIgnoreCase(def.getDriver())) {
            return new DeviceIT85xx(def);
        }
        if ("BK85xx".equalsIgnoreCase(def.getDriver())) {
            return new DeviceBK85xx(def);
        }
        if ("FlukeDMM".equalsIgnoreCase(def.getDriver())) {
            return new DeviceFlukeDMM(def);
        }
        if ("KeysightDMM".equalsIgnoreCase(def.getDriver())) {
            return new DeviceKeysightDMM(def);
        }
        if ("UNITDMM".equalsIgnoreCase(def.getDriver())) {
            return new DeviceUnitDMM(def);
        }
        if ("SERIAL7SEG".equalsIgnoreCase(def.getDriver())) {
            return new DeviceSerial7Seg(def);
        }
        if ("BLOCK".equalsIgnoreCase(def.getDriver())) {
            return new DeviceBlock(def);
        }
        if ("ASCIIBLOCK".equalsIgnoreCase(def.getDriver())) {
            return new DeviceAsciiBlock(def);
        }
        if ("APPA".equalsIgnoreCase(def.getDriver())) {
            return new DeviceAppa(def);
        }
        if ("VC8145".equalsIgnoreCase(def.getDriver())) {
            return new DeviceVC8145(def);
        }
        if ("DMM2".equalsIgnoreCase(def.getDriver())) {
            return new DeviceDMM2(def);
        }
        if ("USBHIDDMM".equalsIgnoreCase(def.getDriver())) {
            return new DeviceUsbHidDMM(def);
        }
        if ("USBHIDDevice".equalsIgnoreCase(def.getDriver())) {
            return new DeviceUsbHidDevice(def);
        }
        if ("SingleValue".equalsIgnoreCase(def.getDriver())) {
            return new DeviceSingleValue(def);
        }
        if ("Modbus".equalsIgnoreCase(def.getDriver())) {
            return new DeviceModbus(def);
        }
        if ("Ascii".equalsIgnoreCase(def.getDriver())) {
            return new DeviceAscii(def);
        }
        if ("AsciiBin".equalsIgnoreCase(def.getDriver())) {
            return new DeviceAsciiBin(def);
        }
        if ("SCPIx".equalsIgnoreCase(def.getDriver())) {
            return new DeviceSCPIx(def);
        }
        if ("ATorch".equalsIgnoreCase(def.getDriver())) {
            return new DeviceATorch(def);
        }
        if ("ATorchPX100".equalsIgnoreCase(def.getDriver())) {
            return new DeviceATorchPX100(def);
        }
        return new DeviceSCPI(def);
    }

    private static String getComputerName() {
        Map<String, String> env = System.getenv();
        if (env.containsKey("COMPUTERNAME")) {
            return env.get("COMPUTERNAME");
        }
        if (env.containsKey("HOSTNAME")) {
            return env.get("HOSTNAME");
        }
        return "Unknown Computer";
    }

    public static void logToWebServer() {
        String name = InterfaceThreads.getComputerName();
        String usedFunctions = Support.getUsedFunctions();
        if (Support.devlop && name.equals("INTEL7")) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (DeviceThread dt : InterfaceThreads.getDevices()) {
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append(dt.getDeviceInterface().getDeviceName());
        }
        new LogToWebserver("TC", Support.systemSettings.uid, "2.38", sb.toString()).postAsync(10);
        if (usedFunctions.length() > 0) {
            if (usedFunctions.length() > 10300) {
                usedFunctions = String.valueOf(usedFunctions.substring(0, 10300)) + "...";
            }
            new LogToWebserver("TC", Support.systemSettings.uid, "2.38", "#" + usedFunctions).postAsync(10);
        }
    }

    public static DeviceInterface getLoadedDeviceInterfaceHandle(String handle) {
        DeviceThread dt;
        if (handle == null) {
            return null;
        }
        int i = handle.indexOf(46);
        if (i >= 0) {
            handle = handle.substring(0, i);
        }
        if ((i = handle.indexOf(58)) >= 0) {
            handle = handle.substring(0, i);
        }
        return (dt = deviceMap.get(handle.toUpperCase().trim())) == null ? null : dt.deviceInterface;
    }

    public static DeviceInterface findDeviceInterfaceAnyHandle(String handle) {
        if (handle == null) {
            return null;
        }
        DeviceThread dt = deviceMap.get(handle.toUpperCase().trim());
        if (dt != null) {
            return dt.deviceInterface;
        }
        for (String s : Support.manageDeviceDefinitions.getDeviceList()) {
            ManageDeviceDefinitions.DeviceDefinition def = Support.manageDeviceDefinitions.findDeviceDefintionFromName(s);
            try {
                def.parse();
            }
            catch (Exception e) {
                System.out.println("Fault in " + def.getDeviceName());
                e.printStackTrace(System.out);
            }
            DeviceInterface di = InterfaceThreads.findDeviceInterfaceFromDeviceDefinition(def);
            if (di == null) continue;
            if (handle.equalsIgnoreCase(di.getHandleName())) {
                return di;
            }
            if (!handle.equalsIgnoreCase(remapper.remapDevice(di))) continue;
            return di;
        }
        return null;
    }

    public static List<DeviceInterface> findDeviceInterfaceListAnyHandle(String handle) {
        ArrayList<DeviceInterface> list = new ArrayList<DeviceInterface>();
        if (handle == null) {
            return list;
        }
        DeviceThread dt = deviceMap.get(handle.toUpperCase().trim());
        if (dt != null) {
            list.add(dt.deviceInterface);
            return list;
        }
        for (String s : Support.manageDeviceDefinitions.getDeviceList()) {
            ManageDeviceDefinitions.DeviceDefinition def = Support.manageDeviceDefinitions.findDeviceDefintionFromName(s);
            try {
                def.parse();
            }
            catch (Exception e) {
                System.out.println("Fault in " + def.getDeviceName());
                e.printStackTrace(System.out);
            }
            DeviceInterface di = InterfaceThreads.findDeviceInterfaceFromDeviceDefinition(def);
            if (di == null) continue;
            if (handle.equalsIgnoreCase(di.getHandleName())) {
                list.add(di);
                continue;
            }
            if (!handle.equalsIgnoreCase(remapper.remapDevice(di))) continue;
            list.add(di);
        }
        return list;
    }

    public static boolean inInitialization() {
        return initialization;
    }

    public static boolean isLogging() {
        return logData && loggingSample != null && loggingSample.isAlive();
    }

    public static boolean isLoggingToDisk() {
        return InterfaceThreads.isLogging() && loggingWriter != null;
    }

    public static long loggingInterval() {
        return loggingInterval;
    }

    public static void startInterface() {
        Main.busyReconnecting = true;
        if (SwingUtilities.isEventDispatchThread()) {
            InterfaceThreads.startInterfaceInternal();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InterfaceThreads.startInterfaceInternal();
                }
            });
        }
    }

    public static void closeAll(final boolean all) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PopupAdjustScale.closeAll();
                PopupAlarm.closeAll();
                if (all) {
                    PopupCalculator.closeAll();
                }
                if (all) {
                    PopupVarDisplay.closeAll();
                }
                PopupLogTrigger.closeAll();
                PopupReadout.closeAll();
                PopupShowDevices.closeAll();
                PopupTestInterface.closeAll();
                PopupChart.closeAll();
                PopupChartLayout.closeAll();
                if (all) {
                    PopupTimer.closeAll();
                }
                if (all) {
                    PopupImage.closeAll();
                }
                PopupParamAdjuster.closeAll();
                PopupParamSweeper.closeAll();
                PopupValues.closeAll();
                PopupGridPanel.closeAll();
                PopupAutoHold.closeAll();
                PopupScriptList.closeAll();
                PopupLogEvent.closeAll();
                PopupFFTView.closeAll();
                PopupMPPT.closeAll();
                PopupTimerCounter.closeAll();
                PopupAutoAdjust.closeAll();
                if (deviceThreads != null) {
                    for (DeviceThread dt : deviceThreads) {
                        dt.getDeviceInterface().closePopups();
                    }
                }
            }
        });
    }

    public static void startInterfaceInternal() {
        Var.gl.getCreate("logInterval").set(0);
        initialization = true;
        InterfaceThreads.closeAll(false);
        Support.clearExporter();
        sharedInterfaceList.reset();
        ScanPorts sp = new ScanPorts();
        sp.start();
    }

    public static List<String> listChannels(boolean includeMath) {
        ArrayList<String> list = new ArrayList<String>();
        if (deviceThreads != null) {
            for (DeviceThread dt : deviceThreads) {
                for (String s : dt.getValueNames()) {
                    list.add(s);
                }
            }
            if (includeMath) {
                for (Mathematics.MathEntry me : Support.math.getEnabledMathEntries()) {
                    list.add(me.getFullName());
                }
            }
        }
        return list;
    }

    public static List<String> listChannels(boolean includeMath, String filter) {
        if (filter == null || filter.length() == 0) {
            return InterfaceThreads.listChannels(includeMath);
        }
        ArrayList<String> list = new ArrayList<String>();
        String regex = CharacterEscapes.forSimpleSearch(filter);
        for (String s : InterfaceThreads.listChannels(includeMath)) {
            if (!s.matches(regex)) continue;
            list.add(s);
        }
        return list;
    }

    public static ValueFormat findValueFormat(String channel) {
        if (channel == null) {
            return new ValueFormat("??", "", ValueFormat.formatD2);
        }
        ValueFormat fmt = null;
        int i = channel.indexOf(46);
        if (i >= 0) {
            String handle = channel.substring(0, i);
            if (handle.equalsIgnoreCase("Math")) {
                Mathematics.MathEntry me = Support.math.getEntry(channel.substring(i + 1));
                if (me != null) {
                    fmt = me.getValueFormat();
                }
            } else {
                channel = channel.substring(i + 1);
                DeviceInterface di = InterfaceThreads.getLoadedDeviceInterfaceHandle(handle);
                if (di != null) {
                    fmt = di.getValueFormat(channel);
                }
            }
        }
        if (fmt == null) {
            fmt = new ValueFormat("??", "", ValueFormat.formatD2);
        }
        return fmt;
    }

    public static List<String> listDevices() {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        if (deviceThreads != null) {
            for (DeviceThread dt : deviceThreads) {
                sb.append(dt.getHandleName());
                sb.append(": ");
                sb.append(String.valueOf(dt.deviceInterface.getDeviceName()) + " on " + dt.cPort.getDeviceName());
                list.add(sb.toString());
                sb.setLength(0);
            }
        }
        return list;
    }

    public static List<String> listDeviceHandles() {
        ArrayList<String> list = new ArrayList<String>();
        if (deviceThreads != null) {
            for (DeviceThread dt : deviceThreads) {
                list.add(dt.getHandleName());
            }
        }
        return list;
    }

    public static List<String> listDeviceNames() {
        ArrayList<String> list = new ArrayList<String>();
        if (deviceThreads != null) {
            for (DeviceThread dt : deviceThreads) {
                list.add(dt.getName());
            }
        }
        return list;
    }

    public static List<DeviceThread> getDevices() {
        return deviceThreads;
    }

    public static List<String> getDevicesHandlesWithInterface(String interfaceSearch, String functionList, boolean expandMultiDevices) {
        if (functionList.equals("*")) {
            functionList = "";
        }
        interfaceSearch = CharacterEscapes.forSimpleSearch(interfaceSearch);
        ArrayList<String> list = new ArrayList<String>();
        String[] ff = functionList.split("[,; ]+");
        for (DeviceThread dt : InterfaceThreads.getDevices()) {
            boolean match = false;
            try {
                String[] stringArray = dt.getDeviceInterface().getIFaceTypes();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (s.matches(interfaceSearch)) {
                        match = true;
                        break;
                    }
                    ++n2;
                }
                if (!match) continue;
                if (!functionList.trim().isEmpty()) {
                    stringArray = ff;
                    n = ff.length;
                    n2 = 0;
                    while (n2 < n) {
                        String f = stringArray[n2];
                        if (dt.getDeviceInterface().getIFace(f) == null) {
                            match = false;
                            break;
                        }
                        ++n2;
                    }
                }
                if (!match) continue;
                list.add(dt.getHandleName());
                int i = 1;
                while (expandMultiDevices && i < dt.getDeviceInterface().getIFaceChannels()) {
                    list.add(String.valueOf(dt.getHandleName()) + ":" + (i + 1));
                    ++i;
                }
            }
            catch (Exception exception) {}
        }
        return list;
    }

    public static void clearLogBuffer() {
        logQueue.clear();
    }

    public static String readLog() {
        if (logQueue.size() > 0) {
            return (String)logQueue.remove();
        }
        return null;
    }

    public static void log(String s) {
        if (debugAll) {
            System.out.println(s);
        }
        logQueue.add(s);
        int n = logQueue.size();
        if (n > 100) {
            CommInterface.sleep(50);
        } else if (n > 10) {
            CommInterface.sleep(5);
        }
    }

    public static void logException(Exception e) {
        e.printStackTrace(System.out);
    }

    public static void logDebug(String s) {
        long tt = System.currentTimeMillis();
        switch (debugTime) {
            case 0: {
                s = ";; " + s;
                break;
            }
            case 1: {
                s = ";; " + sdfDebug.format(new Date()) + s;
                break;
            }
            case 2: {
                long t = System.nanoTime() - startingNanoTime;
                s = ";; " + nf2.format((double)t / 1000000.0) + "ms " + s;
            }
        }
        if (debugAll) {
            System.out.println(s);
        }
        if (!debugCon) {
            logQueue.add(s);
            int n = logQueue.size();
            if (n > 100) {
                CommInterface.sleep(50);
            } else if (n > 10) {
                CommInterface.sleep(5);
            }
        }
        if ((tt = System.currentTimeMillis() - tt) > 150L) {
            System.out.println("************************* Logging slow *****************************");
        }
    }

    public static void closeAllDevices() {
        threadCommander.sampleAllDevices(5);
    }

    protected static synchronized void nextSetupVarTime() {
        long dt = Var.gl.get("commandTime").asLong() * 12L / 10000L;
        if (dt < 100L) {
            dt = 100L;
        }
        if (dt > 1500L) {
            dt = 1500L;
        }
        nextVarSetupTime = System.currentTimeMillis() + dt;
    }

    public static List<ThreadCommand> sampleAllDeviceValues() {
        return threadCommander.sampleAllDevices(1);
    }

    public static void setupVars() {
        if (nextVarSetupTime > System.currentTimeMillis()) {
            return;
        }
        threadCommander.sampleAllDevices(3);
        InterfaceThreads.nextSetupVarTime();
    }

    public static void startLogThread() {
        if (logData) {
            if (loggingInterval <= 0L) {
                loggingInterval = 1000L;
            } else if (loggingInterval > 3600000L) {
                loggingInterval = 3600000L;
            }
            if (loggingSample == null || !loggingSample.isAlive()) {
                loggingSample = new LoggingSample();
            }
        }
    }

    public static synchronized void startSavingThread(String fname) {
        if (fname == null || fname.length() == 0) {
            InterfaceThreads.stopLoggingWriter();
        } else if (loggingWriter == null) {
            Support.dataBase.startOptimizer();
            loggingWriter = new LoggingWriter(fname);
        }
    }

    public static synchronized void saveLine(String line) {
        if (loggingWriter != null) {
            loggingWriter.write(line);
        }
    }

    private static synchronized void stopLoggingWriter() {
        if (loggingWriter == null) {
            return;
        }
        InterfaceThreads.loggingWriter.done = true;
        loggingWriter.write("");
        loggingWriter = null;
    }

    public static enum CommStatus {
        none,
        opening,
        ready,
        failed;

    }

    public static class DeviceThread
    extends Thread {
        public CommInterface cPort = null;
        private CommStatus commStatus = CommStatus.none;
        private DeviceInterface deviceInterface;
        private long commandTimeSlowest = 0L;
        private long commandTimeSum = 0L;
        private long commandTimeCount = 0L;
        private ArrayBlockingQueue<ThreadCommand> cmdQueue = new ArrayBlockingQueue(10);
        private ArrayBlockingQueue<ThreadCommand> doneQueue = new ArrayBlockingQueue(10);
        private boolean deviceLogging = true;
        private boolean unknownDevice = false;

        DeviceThread(CommInterface cPort) {
            this.cPort = cPort;
            this.setDaemon(true);
            this.setPriority(10);
            this.start();
            this.setName(cPort.getName());
        }

        DeviceThread(CommInterface cPort, boolean unknownDevice) {
            this.cPort = cPort;
            this.setDaemon(true);
            this.setPriority(10);
            this.unknownDevice = unknownDevice;
            this.start();
            this.setName(cPort.getName());
        }

        DeviceThread(CommInterface cPort, DeviceInterface di) {
            this.deviceInterface = di;
            this.cPort = di.getCommInterface(cPort);
            if (this.cPort == null) {
                return;
            }
            this.setPriority(10);
            this.setDaemon(true);
            this.start();
            this.setName("Device " + this.cPort.getName());
        }

        public void setDeviceLogging(boolean status) {
            this.deviceLogging = status;
        }

        @Override
        public String toString() {
            return String.valueOf(this.deviceName()) + " " + (Object)((Object)this.commStatus);
        }

        public synchronized void start(ThreadCommand cmd) {
            this.cmdQueue.add(cmd);
        }

        public boolean threadFailed() {
            return !this.isAlive();
        }

        public boolean threadReady() {
            return this.isAlive() && this.deviceInterface != null && this.commStatus == CommStatus.ready;
        }

        public String getHandleName() {
            return this.deviceInterface.getHandleName();
        }

        public String deviceName() {
            if (this.deviceInterface == null) {
                return "none";
            }
            return String.valueOf(this.deviceInterface.getDeviceName()) + " on " + this.cPort.getName();
        }

        public List<String> supportedCommands() {
            return this.deviceInterface.supportedCommands();
        }

        public DeviceInterface getDeviceInterface() {
            return this.deviceInterface;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean initDevice() {
            this.commStatus = CommStatus.opening;
            try {
                try {
                    block26: {
                        block29: {
                            block28: {
                                if (!this.cPort.isOpen()) {
                                    this.cPort.open();
                                }
                                if (!this.cPort.isOpen()) {
                                    return false;
                                }
                                if (this.deviceInterface != null) {
                                    this.deviceInterface.setBaudrate(this.cPort);
                                } else {
                                    this.cPort.setParams("9600n81");
                                }
                                if (this.deviceInterface == null || this.deviceInterface.def.getResetDleay() <= 0) break block28;
                                DeviceThread.sleep(this.deviceInterface.def.getResetDleay());
                                break block26;
                            }
                            if (!(this.cPort instanceof SerialInterface)) break block29;
                            if (Support.resetDelay > 0) {
                                DeviceThread.sleep(Support.resetDelay);
                                break block26;
                            } else if (this.cPort.getName().contains("Arduino Leonardo")) {
                                DeviceThread.sleep(500L);
                                break block26;
                            } else {
                                DeviceThread.sleep(2000L);
                            }
                            break block26;
                        }
                        DeviceThread.sleep(200L);
                    }
                    this.cPort.flush();
                    String answer = this.cPort.writeRead("*IDN?");
                    if (answer == null || answer.length() < 3) {
                        DeviceThread.sleep(700L);
                        answer = this.cPort.writeRead("*IDN?");
                    }
                    if (answer == null) return false;
                    if (answer.length() < 3) {
                        return false;
                    }
                    answer = answer.trim();
                    if (this.deviceInterface == null) {
                        ManageDeviceDefinitions.DeviceDefinition def = Support.manageDeviceDefinitions.findDeviceDefintionFromId(answer);
                        this.deviceInterface = InterfaceThreads.findDeviceInterfaceFromDeviceDefinition(def);
                        if (this.deviceInterface == null) {
                            if (this.unknownDevice && !foundUnknownDevice.compareAndSet(false, true)) {
                                this.deviceInterface = InterfaceThreads.findDeviceInterfaceFromDeviceDefinition(ManageDeviceDefinitions.getDeviceDefinitionUnknown());
                                String[] s = answer.split(",");
                                this.deviceInterface.def.setDeviceName("Undefined: " + s[0] + (s.length >= 2 ? "," + s[1] : ""));
                            } else {
                                InterfaceThreads.log(";; " + this.cPort.getName() + " Did not find any match for: " + answer);
                                this.cPort.close();
                                return false;
                            }
                        }
                        this.cPort = this.deviceInterface.getCommInterface(this.cPort);
                    } else if (!answer.startsWith(this.deviceInterface.getDeviceId())) {
                        InterfaceThreads.log(";; " + this.cPort.getName() + " Device " + this.deviceInterface.getDeviceId() + " do not match: " + answer);
                        this.cPort.close();
                        return false;
                    }
                    this.deviceInterface.threadStarted(this);
                    this.deviceInterface.setSerialNumberFromIDN(answer);
                    this.deviceInterface.setSoftwareVersionFromIDN(answer);
                    this.setName("Device: " + this.deviceInterface.getHandleName());
                    this.commStatus = CommStatus.ready;
                }
                finally {
                    if (this.commStatus != CommStatus.ready) {
                        this.commStatus = CommStatus.failed;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            this.cPort.debugLog = false;
            if (this.commStatus != CommStatus.ready) return false;
            return true;
        }

        public String getValuesString(List<Double> list) {
            return this.deviceInterface.getValuesString(list);
        }

        public void setupVariables(List<Double> list) {
            this.deviceInterface.setupVariables(list);
        }

        public String getValueName(int index) {
            return String.valueOf(this.deviceInterface.getHandleName()) + "." + this.deviceInterface.getValueNameList().get(index);
        }

        public List<String> getValueNames() {
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (i < this.deviceInterface.getValueNameList().size()) {
                list.add(this.getValueName(i));
                ++i;
            }
            return list;
        }

        @Override
        public void run() {
            if (this.cPort == null) {
                this.deviceInterface = null;
                return;
            }
            if (debugAll) {
                InterfaceThreads.logDebug("Start thread for: " + this.cPort.getDeviceName() + (this.deviceInterface != null ? " - " + this.deviceInterface.getDeviceName() : ""));
            }
            if (!this.initDevice()) {
                if (debugAll) {
                    InterfaceThreads.logDebug("Stopping thread for: " + this.cPort.getDeviceName() + (this.deviceInterface != null ? " - " + this.deviceInterface.getDeviceName() : ""));
                }
                this.deviceInterface = null;
                if (this.cPort != null) {
                    this.cPort.close();
                    this.cPort = null;
                }
                return;
            }
            String sn = "";
            if (this.deviceInterface.getSerialNumber().length() > 0) {
                sn = " sn: " + this.deviceInterface.getSerialNumber();
            }
            InterfaceThreads.log(";; Found " + this.deviceInterface.getDeviceName() + " on " + this.cPort.getName() + sn);
            this.supportedCommands();
            while (true) {
                try {
                    while (true) {
                        ThreadCommand cmd = this.cmdQueue.take();
                        long time = System.nanoTime();
                        try {
                            switch (cmd.getCmd()) {
                                case 1: {
                                    if (this.deviceLogging || !logData) {
                                        List<Double> list = this.deviceInterface.getValuesFromDevices();
                                        this.setupVariables(list);
                                        cmd.setAnswerDoubles(list);
                                        break;
                                    }
                                    cmd.setAnswerDoubles(new ArrayList<Double>());
                                    break;
                                }
                                case 2: {
                                    this.deviceInterface.initColumns();
                                    break;
                                }
                                case 3: {
                                    this.deviceInterface.setupVariables(this.deviceInterface.getValuesFromDevices());
                                    break;
                                }
                                case 4: {
                                    cmd.setAnswerString(this.deviceInterface.getIdn());
                                    break;
                                }
                                case 7: {
                                    cmd.setAnswerString(this.deviceInterface.finalInit());
                                    break;
                                }
                                case 5: {
                                    this.deviceInterface.close();
                                    this.cPort.close();
                                    cmd.answerString = "Goodbye";
                                    this.doneQueue.add(cmd);
                                    return;
                                }
                                case 6: {
                                    this.deviceInterface.outputOff();
                                    break;
                                }
                                case 100: {
                                    this.commandTimeSlowest = 0L;
                                    this.commandTimeSum = 0L;
                                    this.commandTimeCount = 0L;
                                }
                            }
                        }
                        finally {
                            this.doneQueue.add(cmd);
                        }
                        time = (System.nanoTime() - time + 500L) / 1000L;
                        Var.gl.getCreate(String.valueOf(this.deviceInterface.getHandleName()) + ".commandTime").set(time);
                        if (time > this.commandTimeSlowest) {
                            this.commandTimeSlowest = time;
                            Var.gl.getCreate(String.valueOf(this.deviceInterface.getHandleName()) + ".commandTimeSlowest").set(this.commandTimeSlowest);
                        }
                        this.commandTimeSum += time;
                        ++this.commandTimeCount;
                        Var.gl.getCreate(String.valueOf(this.deviceInterface.getHandleName()) + ".commandTimeAverage").set(this.commandTimeSum / this.commandTimeCount);
                    }
                }
                catch (Exception e) {
                    System.out.println("Thread for " + this.deviceInterface.getHandleName());
                    e.printStackTrace(System.out);
                    continue;
                }
                break;
            }
        }
    }

    static class Interfaces {
        String name;
        DeviceInterface di;

        Interfaces() {
        }
    }

    static enum LoggingMode {
        Normal,
        StartStopOnCommand,
        SingleOnCommand,
        NOnCommand,
        SingleOnTrig,
        SecondOnTrig,
        NOnTrig,
        WhileTrig,
        WhileTrigOrN,
        StartOnTrig,
        StopOnTrig,
        StopOnTrigOrN;

    }

    private static class LoggingSample
    extends Thread {
        private Script script = new Script();
        private int trigLogCount = 0;
        private int[] timeoutCount;
        private boolean[] sampleValid;

        LoggingSample() {
            this.setDaemon(true);
            this.setPriority(8);
            this.start();
            this.setName("LoggerSample");
            Support.addUsedFunction("log");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (DeviceThread dt : deviceThreads) {
                dt.deviceInterface.resetTime();
            }
            Support.math.clearChanged();
            this.timeoutCount = new int[Support.dataBase.columns()];
            this.sampleValid = new boolean[Support.dataBase.columns()];
            int i = 0;
            while (i < Support.dataBase.columns()) {
                this.timeoutCount[i] = 0;
                ++i;
            }
            long time = System.currentTimeMillis();
            while (logData) {
                long sleepTime = 0L;
                do {
                    if ((sleepTime = time - System.currentTimeMillis()) <= 0L) continue;
                    try {
                        LoggingSample.sleep(sleepTime > 100L ? 100L : sleepTime);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (logData) continue;
                    return;
                } while (sleepTime > 0L);
                long delta = (time += loggingInterval) - System.currentTimeMillis();
                if (delta < -100L) {
                    time = System.currentTimeMillis() + (loggingInterval += (long)(loggingInterval < 100L ? 10 : 100));
                }
                double timeStamp = (double)(System.currentTimeMillis() - loggingStartTime) / 1000.0;
                Var.gl.getCreate("time").set((double)(System.currentTimeMillis() - loggingStartTime) / 1000.0);
                List<ThreadCommand> doneList = threadCommander.sampleAllDevices(1);
                InterfaceThreads.nextSetupVarTime();
                boolean doLogData = logData;
                try {
                    switch (loggingMode) {
                        case Normal: {
                            break;
                        }
                        case SingleOnCommand: {
                            doLogData = lastTrig;
                            lastTrig = false;
                            break;
                        }
                        case NOnCommand: {
                            if (lastTrig) {
                                this.trigLogCount = trigLogCount;
                                lastTrig = false;
                            }
                            boolean bl = doLogData = this.trigLogCount > 0;
                            if (this.trigLogCount > 0) {
                                --this.trigLogCount;
                            }
                            break;
                        }
                        case SingleOnTrig: {
                            boolean trig;
                            String string = trigExpression;
                            synchronized (string) {
                                trig = this.script.expression(trigExpression).asBoolean();
                            }
                            doLogData = false;
                            if (trig && !lastTrig) {
                                doLogData = true;
                                lastTrig = true;
                                break;
                            }
                            if (!trig) {
                                lastTrig = false;
                            }
                            break;
                        }
                        case SecondOnTrig: {
                            boolean trig;
                            String string = trigExpression;
                            synchronized (string) {
                                trig = this.script.expression(trigExpression).asBoolean();
                            }
                            if (trig && !lastTrig) {
                                this.trigLogCount = 2;
                                lastTrig = true;
                            } else if (!trig) {
                                lastTrig = false;
                            }
                            boolean bl = doLogData = this.trigLogCount == 1;
                            if (this.trigLogCount > 0) {
                                --this.trigLogCount;
                            }
                            break;
                        }
                        case NOnTrig: {
                            boolean trig;
                            String string = trigExpression;
                            synchronized (string) {
                                trig = this.script.expression(trigExpression).asBoolean();
                            }
                            doLogData = false;
                            if (trig && !lastTrig) {
                                this.trigLogCount = trigLogCount;
                                lastTrig = true;
                            } else if (!trig) {
                                lastTrig = false;
                            }
                            boolean bl = doLogData = this.trigLogCount > 0;
                            if (this.trigLogCount > 0) {
                                --this.trigLogCount;
                            }
                            break;
                        }
                        case StartOnTrig: {
                            if (!lastTrig) {
                                String trig = trigExpression;
                                synchronized (trig) {
                                    lastTrig = this.script.expression(trigExpression).asBoolean();
                                }
                            }
                            doLogData = lastTrig;
                            break;
                        }
                        case StopOnTrig: {
                            boolean trig;
                            String string = trigExpression;
                            synchronized (string) {
                                trig = this.script.expression(trigExpression).asBoolean();
                            }
                            if (trig) {
                                logData = false;
                                doLogData = false;
                            }
                            break;
                        }
                        case StopOnTrigOrN: {
                            boolean trig;
                            String string = trigExpression;
                            synchronized (string) {
                                trig = this.script.expression(trigExpression).asBoolean();
                            }
                            if (!trig) {
                                this.trigLogCount = trigLogCount + 1;
                            }
                            logData = doLogData = this.trigLogCount > 0;
                            if (this.trigLogCount > 0) {
                                --this.trigLogCount;
                            }
                            break;
                        }
                        case StartStopOnCommand: {
                            doLogData = lastTrig;
                            break;
                        }
                        case WhileTrig: {
                            String trig = trigExpression;
                            synchronized (trig) {
                                doLogData = this.script.expression(trigExpression).asBoolean();
                                break;
                            }
                        }
                        case WhileTrigOrN: {
                            String trig = trigExpression;
                            synchronized (trig) {
                                if (this.script.expression(trigExpression).asBoolean()) {
                                    this.trigLogCount = trigLogCount + 1;
                                }
                            }
                            boolean bl = doLogData = this.trigLogCount > 0;
                            if (this.trigLogCount > 0) {
                                --this.trigLogCount;
                            }
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    InterfaceThreads.log("Trigger expression failed: <" + trigExpression + ">");
                    InterfaceThreads.logException(e);
                }
                if (!(doLogData || loggingMode == LoggingMode.SecondOnTrig && this.trigLogCount == 1)) {
                    time = System.currentTimeMillis() + 50L;
                }
                nextVarSetupTime = System.currentTimeMillis() + (long)(loggingInterval > 1500L ? 500 : 2000);
                if (doLogData) {
                    List<String> names;
                    hasTriggered = true;
                    DataRow dr = Support.dataBase.getNewRow(Support.systemSettings.timeoutValue);
                    dr.setValue("index", (double)databaseIndex++);
                    dr.setValue("time", timeStamp);
                    dr.setValue("minutes", timeStamp / 60.0);
                    dr.setValue("dateTime", (double)System.currentTimeMillis() / 1000.0);
                    int i2 = 4;
                    while (i2 < Support.dataBase.columns()) {
                        this.sampleValid[i2] = false;
                        ++i2;
                    }
                    for (ThreadCommand dl : doneList) {
                        if (dl.getAnswerDoubles() == null) continue;
                        try {
                            int i3 = 0;
                            while (i3 < Math.min(dl.getAnswerDoubles().size(), ((DeviceThread)dl.getHandler()).deviceInterface.valueNames.size())) {
                                int c = Support.dataBase.header().getIndex(dl.getValueName(i3));
                                double v = dl.getValue(i3);
                                this.timeoutCount[c] = 0;
                                this.sampleValid[c] = true;
                                dr.setValue(c, v);
                                ++i3;
                            }
                        }
                        catch (Exception exception) {}
                    }
                    if (PopupParamSweeper.addColumns() && (names = PopupParamSweeper.columnNames()).size() > 0) {
                        int i4 = 0;
                        for (Double value : PopupParamSweeper.columnValues()) {
                            int c = Support.dataBase.header().getIndex(names.get(i4));
                            if (c >= 0) {
                                this.timeoutCount[c] = 9999;
                                this.sampleValid[c] = true;
                                dr.setValue(c, (double)value);
                            }
                            ++i4;
                        }
                    }
                    int c = 4;
                    while (c < Support.dataBase.columns()) {
                        if (!this.sampleValid[c]) {
                            if (this.timeoutCount[c] < Support.systemSettings.delayTimeout && Support.dataBase.rows() > 0) {
                                dr.setValue(c, Support.dataBase.getValue(Support.dataBase.rows() - 1, c));
                            }
                            int n = c;
                            this.timeoutCount[n] = this.timeoutCount[n] + 1;
                        }
                        ++c;
                    }
                    if (logData) {
                        Support.math.calcMathColumns(dr, Support.dataBase.header().getDomainColumn(), true);
                        Support.dataBase.addRow(dr);
                        InterfaceThreads.saveLine(dr.getDataRowLine());
                    }
                }
                if (logData) continue;
                InterfaceThreads.startSavingThread(null);
            }
        }
    }

    private static class LoggingWriter
    extends Thread {
        private File file;
        private BlockingQueue<String> saveQueue = new LinkedBlockingQueue<String>();
        boolean done = false;

        LoggingWriter(String fname) {
            this.setDaemon(true);
            this.setName("Logging Writer");
            this.file = new File(fname);
            this.start();
        }

        public void write(String s) {
            try {
                this.saveQueue.put(s);
            }
            catch (InterruptedException interruptedException) {}
        }

        @Override
        public void run() {
            BufferedWriter bw = null;
            try {
                FileOutputStream os = new FileOutputStream(this.file);
                OutputStreamWriter osw = new OutputStreamWriter(os);
                bw = new BufferedWriter(osw, 32768);
                long time = System.currentTimeMillis();
                while (!this.done || this.saveQueue.size() > 0) {
                    long t;
                    String s = this.saveQueue.take();
                    if (s.length() > 0) {
                        bw.write(s);
                        bw.write("\r\n");
                    }
                    if ((t = System.currentTimeMillis()) - time <= 30000L) continue;
                    bw.close();
                    os = new FileOutputStream(this.file, true);
                    osw = new OutputStreamWriter(os);
                    bw = new BufferedWriter(osw, 32768);
                    time = t;
                }
                bw.close();
                bw = null;
            }
            catch (Exception exception) {
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (IOException iOException) {}
                }
                InterfaceThreads.stopLoggingWriter();
            }
        }
    }

    private static class ScanPorts
    extends Thread {
        private List<DeviceThread> dts = new ArrayList<DeviceThread>();
        private List<CommInterface> cPorts = null;

        private synchronized void addDeviceThread(DeviceThread dt) {
            this.dts.add(dt);
        }

        public ScanPorts() {
            this.setName("Scan ports");
            this.setDaemon(true);
        }

        private CommInterface findComm(List<CommInterface> ports, String name) {
            for (CommInterface ci : ports) {
                if (!ci.getDeviceName().toLowerCase().equals(name.toLowerCase())) continue;
                ports.remove(ci);
                return ci;
            }
            return new DummyInterface();
        }

        private void listConflict(DeviceThread dt) {
            InterfaceThreads.log(";; " + dt.deviceName() + " handle matches another device " + dt.getHandleName() + " use remapping");
        }

        private void generateHandles() {
            HashSet<String> conflicts = new HashSet<String>();
            for (DeviceThread dt : this.dts) {
                dt.deviceInterface.setHandleName(remapper.remapDevice(dt.deviceInterface));
                if (conflicts.contains(dt.getHandleName())) {
                    dt.deviceInterface.setHandleName(String.valueOf(dt.getHandleName()) + "_" + dt.deviceInterface.getId());
                    if (deviceMap.containsKey(dt.getHandleName().toUpperCase().trim())) {
                        this.listConflict(dt);
                        continue;
                    }
                    deviceMap.put(dt.getHandleName().toUpperCase().trim(), dt);
                    continue;
                }
                DeviceThread xdt = deviceMap.get(dt.getHandleName().toUpperCase().trim());
                if (xdt != null) {
                    if (xdt.deviceInterface.getId() == dt.deviceInterface.getId()) {
                        this.listConflict(dt);
                        continue;
                    }
                    conflicts.add(dt.getHandleName());
                    deviceMap.remove(xdt.getHandleName().toUpperCase().trim());
                    dt.deviceInterface.setHandleName(String.valueOf(dt.getHandleName()) + "_" + dt.deviceInterface.getId());
                    xdt.deviceInterface.setHandleName(String.valueOf(xdt.getHandleName()) + "_" + xdt.deviceInterface.getId());
                    deviceMap.put(dt.getHandleName().toUpperCase().trim(), dt);
                    deviceMap.put(xdt.getHandleName().toUpperCase().trim(), xdt);
                    continue;
                }
                deviceMap.put(dt.getHandleName().toUpperCase().trim(), dt);
            }
        }

        private void removeDisabledDevices() {
            ArrayList removeList = new ArrayList();
            for (DeviceThread dt : removeList) {
                this.dts.remove(dt);
            }
        }

        private void addDevicesShared(ManageDeviceDefinitions.PortType portType) {
            for (LoadDeviceConfig.LoadDevice ld : loadDeviceConfig.getDeviceType(portType)) {
                CommInterface ci;
                ManageDeviceDefinitions.DeviceDefinition def = Support.manageDeviceDefinitions.findDeviceDefintionFromName(ld.getDevice());
                DeviceInterface di = InterfaceThreads.findDeviceInterfaceFromDeviceDefinition(def);
                if (di == null) break;
                di.setDef(def);
                SharedInterface shi = sharedInterfaceList.find(ld.getAddress());
                if (shi == null || (ci = shi.getInterface()) == null) break;
                String s = shi.neededCommInterface();
                if (s != null) {
                    CommInterface ci1 = this.findComm(this.cPorts, s);
                    if (ci1 == null) break;
                    shi.setCommInterface(ci1);
                    if (shi.getPortType() == ManageDeviceDefinitions.PortType.Serial) {
                        ((SerialInterface)ci1).setParams(shi.getBaudrate());
                    }
                }
                this.addDeviceThread(new DeviceThread(ci, di));
            }
        }

        private void addDevicesSerial(ManageDeviceDefinitions.PortType portType) {
            for (LoadDeviceConfig.LoadDevice ld : loadDeviceConfig.getDeviceType(portType)) {
                ManageDeviceDefinitions.DeviceDefinition def = Support.manageDeviceDefinitions.findDeviceDefintionFromName(ld.getDevice());
                DeviceInterface di = InterfaceThreads.findDeviceInterfaceFromDeviceDefinition(def);
                if (di == null) break;
                di.setDef(def);
                di.setBaudrate(ld.getBaudrate());
                CommInterface ci = this.findComm(this.cPorts, ld.getAddress());
                if (ci == null) break;
                this.addDeviceThread(new DeviceThread(ci, di));
            }
        }

        private void addDevicesSocket() {
            CommInterface ci;
            DeviceInterface di;
            ManageDeviceDefinitions.DeviceDefinition def;
            for (LoadDeviceConfig.LoadDevice ld : loadDeviceConfig.getDeviceType(ManageDeviceDefinitions.PortType.Socket)) {
                def = Support.manageDeviceDefinitions.findDeviceDefintionFromName(ld.getDevice());
                di = InterfaceThreads.findDeviceInterfaceFromDeviceDefinition(def);
                if (di == null) break;
                ci = new SocketInterface(ld.getAddressWithSearch(), def.getPort());
                ci.debugLog = debugIdnSocket | debugAll;
                this.addDeviceThread(new DeviceThread(ci, di));
            }
            for (LoadDeviceConfig.LoadDevice ld : loadDeviceConfig.getDeviceType(ManageDeviceDefinitions.PortType.SocketFilter)) {
                def = Support.manageDeviceDefinitions.findDeviceDefintionFromName(ld.getDevice());
                di = InterfaceThreads.findDeviceInterfaceFromDeviceDefinition(def);
                if (di == null) break;
                ci = new SocketFilterInterface(ld.getAddress(), def.getPort());
                this.addDeviceThread(new DeviceThread(ci, di));
            }
            for (LoadDeviceConfig.LoadDevice ld : loadDeviceConfig.getDeviceType(ManageDeviceDefinitions.PortType.Telnet)) {
                def = Support.manageDeviceDefinitions.findDeviceDefintionFromName(ld.getDevice());
                di = InterfaceThreads.findDeviceInterfaceFromDeviceDefinition(def);
                if (di == null) break;
                ci = new TelnetInterface(ld.getAddress(), def.getPort());
                this.addDeviceThread(new DeviceThread(ci, di));
            }
            for (LoadDeviceConfig.LoadDevice ld : loadDeviceConfig.getDeviceType(ManageDeviceDefinitions.PortType.UDP)) {
                def = Support.manageDeviceDefinitions.findDeviceDefintionFromName(ld.getDevice());
                di = InterfaceThreads.findDeviceInterfaceFromDeviceDefinition(def);
                if (di == null) break;
                ci = new UDPInterface(ld.getAddress(), def.getPort());
                ci.debugLog = debugIdnSocket | debugAll;
                this.addDeviceThread(new DeviceThread(ci, di));
            }
        }

        private void addDevicesSocketAuto() {
            for (String port : Support.manageDeviceDefinitions.getDeviceSocketPorts()) {
                for (LoadDeviceConfig.LoadDevice ld : loadDeviceConfig.getDeviceType(ManageDeviceDefinitions.PortType.SocketAuto)) {
                    try {
                        SocketInterface ci = new SocketInterface(ld.getAddress(), Integer.parseInt(port));
                        this.addDeviceThread(new DeviceThread((CommInterface)ci, true));
                    }
                    catch (Exception exception) {}
                }
            }
        }

        private void addDevicesSocketLXI() {
            for (LoadDeviceConfig.LoadDevice ld : loadDeviceConfig.getDeviceType(ManageDeviceDefinitions.PortType.LXI)) {
                ManageDeviceDefinitions.DeviceDefinition def = Support.manageDeviceDefinitions.findDeviceDefintionFromName(ld.getDevice());
                DeviceInterface di = InterfaceThreads.findDeviceInterfaceFromDeviceDefinition(def);
                if (di == null) break;
                LXIInterface ci = new LXIInterface(ld.getAddressWithSearch());
                this.addDeviceThread(new DeviceThread((CommInterface)ci, di));
            }
        }

        private void addDevicesNone() {
            for (LoadDeviceConfig.LoadDevice ld : loadDeviceConfig.getDeviceType(ManageDeviceDefinitions.PortType.None)) {
                ManageDeviceDefinitions.DeviceDefinition def = Support.manageDeviceDefinitions.findDeviceDefintionFromName(ld.getDevice());
                DeviceInterface di = InterfaceThreads.findDeviceInterfaceFromDeviceDefinition(def);
                if (di == null) break;
                this.addDeviceThread(new DeviceThread((CommInterface)new DummyInterface(), di));
            }
        }

        private void addDevicesUsbHid() {
            for (LoadDeviceConfig.LoadDevice ld : loadDeviceConfig.getDeviceType(ManageDeviceDefinitions.PortType.USBHID)) {
                ManageDeviceDefinitions.DeviceDefinition def = Support.manageDeviceDefinitions.findDeviceDefintionFromName(ld.getDevice());
                DeviceInterface di = InterfaceThreads.findDeviceInterfaceFromDeviceDefinition(def);
                if (di == null) break;
                HidClass ci = null;
                ci = Support.isWindows() && !Support.useHid4Java ? new UsbHidInterfaceFile(def.getItemInt("#usbVendor"), def.getItemInt("#usbProduct"), ld) : new UsbHidInterfaceHidIO(def.getItemInt("#usbVendor"), def.getItemInt("#usbProduct"), ld);
                ci.debugLog = debugIdnUsb | debugAll;
                this.addDeviceThread(new DeviceThread((CommInterface)ci, di));
            }
        }

        private int removeDeadThreads() {
            int n = 0;
            int i = this.dts.size() - 1;
            while (i >= 0) {
                DeviceThread dt = this.dts.get(i);
                if (dt.threadFailed()) {
                    this.dts.remove(i);
                } else if (!dt.threadReady()) {
                    ++n;
                }
                --i;
            }
            return n;
        }

        @Override
        public void run() {
            try {
                boolean busy;
                Main.changeDevicesOrTable(Support.UpdateType.StartInit);
                InterfaceThreads.closeAllDevices();
                do {
                    this.removeDeadThreads();
                } while (this.dts.size() > 0);
                deviceMap.clear();
                if (deviceThreads != null) {
                    deviceThreads.clear();
                }
                Support.manageDeviceDefinitions.loadDefinitions();
                VirtualSinusGenerator.resetForReload();
                VirtualSquareGenerator.resetForReload();
                VirtualRampGenerator.resetForReload();
                VirtualUserGenerator.resetForReload();
                VirtualLogGenerator.resetForReload();
                VirtualPatternGenerator.resetForReload();
                VirtualBatteryGenerator.resetForReload();
                DeviceSoundcardOutput.resetForReload();
                DeviceSoundcardInput.resetForReload();
                discovery.resetDiscovery();
                Functions.addAll();
                scriptInterface.addBasicFunctions();
                foundUnknownDevice.set(false);
                this.cPorts = SerialInterface.getSerialPorts(".*", debugIdnSerial | debugAll);
                this.addDevicesShared(ManageDeviceDefinitions.PortType.GPIB);
                this.addDevicesSerial(ManageDeviceDefinitions.PortType.SerialFixedBaud);
                this.addDevicesSerial(ManageDeviceDefinitions.PortType.SerialNoBaud);
                this.addDevicesSerial(ManageDeviceDefinitions.PortType.Serial);
                if (loadDeviceConfig.isSearchSerialPorts()) {
                    for (CommInterface cPort : this.cPorts) {
                        if (loadDeviceConfig.isExcluded(cPort.getDeviceName())) continue;
                        this.addDeviceThread(new DeviceThread(cPort));
                    }
                }
                this.addDevicesUsbHid();
                this.addDevicesSocket();
                this.addDevicesSocketAuto();
                this.addDevicesSocketLXI();
                this.addDevicesNone();
                do {
                    SerialInterface.sleep(50);
                    boolean bl = busy = this.removeDeadThreads() > 0;
                } while (busy && this.dts.size() > 0);
                this.removeDisabledDevices();
                deviceMap.clear();
                this.generateHandles();
                this.dts.sort(new Comparator<DeviceThread>(){

                    @Override
                    public int compare(DeviceThread dt1, DeviceThread dt2) {
                        return dt1.getHandleName().compareTo(dt2.getHandleName());
                    }
                });
                deviceThreads = this.dts;
                scriptInterface.init();
                threadCommander.sampleAllDevices(7);
            }
            finally {
                initialization = false;
            }
            Main.changeDevicesOrTable(Support.UpdateType.Devices);
            InterfaceThreads.logToWebServer();
            List<String> list = HelpLoader.getHelpFile("Versions");
            if (list != null && list.size() > 1) {
                Support.paneCommand.setVersionLabel(list);
            }
        }
    }

    static class ThreadCommand {
        private int cmd;
        private int id;
        private List<Double> answerDoubles;
        private String answerString;
        private DeviceThread handler = null;

        private ThreadCommand(int cmd, int id, DeviceThread handler) {
            this.cmd = cmd;
            this.id = id;
            this.handler = handler;
            this.answerDoubles = null;
            this.answerString = null;
        }

        public int getCmd() {
            return this.cmd;
        }

        public int getId() {
            return this.id;
        }

        public void setAnswerDoubles(List<Double> values) {
            this.answerDoubles = values;
        }

        public List<Double> getAnswerDoubles() {
            return this.answerDoubles;
        }

        public void setAnswerString(String value) {
            this.answerString = value;
        }

        public String getAnswerString() {
            return this.answerString;
        }

        public DeviceThread getHandler() {
            return this.handler;
        }

        public String getValueName(int index) {
            return String.valueOf(this.handler.getHandleName()) + "." + this.handler.deviceInterface.getValueName(index);
        }

        public Double getValue(int index) {
            if (this.answerDoubles == null || index >= this.answerDoubles.size()) {
                return 0.0;
            }
            return this.answerDoubles.get(index);
        }
    }

    public static class ThreadCommander {
        public static final int CmdSample = 1;
        public static final int CmdInitColumns = 2;
        public static final int CmdSetupVars = 3;
        public static final int CmdId = 4;
        public static final int CmdClose = 5;
        public static final int CmdOutputOff = 6;
        public static final int CmdInit = 7;
        public static final int CmdClearTimer = 100;
        private int id = 0;
        private int jobs = 0;
        private boolean inShutDown = true;

        ThreadCommander() {
        }

        public synchronized int getId() {
            ++this.id;
            return this.id;
        }

        public synchronized void start(int cmd, int id) {
            ++this.jobs;
            if (deviceThreads != null) {
                for (DeviceThread dt : deviceThreads) {
                    dt.cmdQueue.add(new ThreadCommand(cmd, id, dt));
                }
            }
        }

        public synchronized List<ThreadCommand> waitFinished(int id) {
            ArrayList<ThreadCommand> list = new ArrayList<ThreadCommand>();
            if (deviceThreads != null) {
                for (DeviceThread dt : deviceThreads) {
                    ThreadCommand tc = null;
                    do {
                        try {
                            tc = (ThreadCommand)dt.doneQueue.take();
                        }
                        catch (InterruptedException interruptedException) {
                            tc = null;
                        }
                    } while (tc == null || tc.getId() != id);
                    list.add(tc);
                }
            }
            --this.jobs;
            return list;
        }

        public boolean isBusy() {
            return this.jobs > 0;
        }

        public synchronized List<ThreadCommand> sampleAllDevices(int threadCommand) {
            switch (threadCommand) {
                case 7: {
                    this.inShutDown = false;
                    break;
                }
                case 5: {
                    this.inShutDown = true;
                    break;
                }
                default: {
                    if (!this.inShutDown) break;
                    return null;
                }
            }
            long time = System.nanoTime();
            int id = threadCommander.getId();
            threadCommander.start(threadCommand, id);
            List<ThreadCommand> doneList = threadCommander.waitFinished(id);
            time = (System.nanoTime() - time + 500L) / 1000L;
            Var.gl.getCreate("commandTime").set(time);
            return doneList;
        }
    }
}

