/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.color.ColorUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class Indicator
extends JPanel {
    private BufferedImage image;
    private Color color;
    private boolean on = true;
    private int graphicHeight = 15;
    private int graphicWidth = 15;
    private boolean useRound = false;
    private double minColor = 0.05;
    private Color bgColor = null;

    public Indicator() {
        this.setColor(Color.red);
        this.setIndicatorSize(30, 30);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.bgColor = color;
    }

    public Indicator(boolean round) {
        this.useRound = round;
        this.setColor(Color.red);
        this.setIndicatorSize(30, 30);
    }

    public void setIndicatorSize(int w, int h) {
        this.graphicHeight = h;
        this.graphicWidth = w;
        Dimension d = new Dimension(w, h);
        this.setMinimumSize(d);
        this.setMaximumSize(d);
        this.setPreferredSize(d);
        this.setSize(d);
        this.drawImage();
    }

    public void setOn(boolean on) {
        if (this.on != on) {
            this.on = on;
            this.drawImage();
        }
    }

    public boolean isOn() {
        return this.on;
    }

    public void setColor(Color color) {
        if (this.color == null || !this.color.equals(color)) {
            this.color = color;
            this.drawImage();
        }
    }

    public Color getColor() {
        return this.color;
    }

    private void draw(Graphics g, int margin, Color color) {
        g.setColor(color);
        if (this.useRound) {
            g.fillOval(margin, margin, this.graphicWidth - margin * 2, this.graphicHeight - margin * 2);
        } else {
            g.fillRoundRect(margin, margin, this.graphicWidth - margin * 2, this.graphicHeight - margin * 2, this.graphicWidth / 4, this.graphicHeight / 4);
        }
    }

    private void drawImage() {
        this.image = new BufferedImage(this.graphicWidth, this.graphicHeight, 5);
        Graphics g = this.image.getGraphics();
        if (this.bgColor == null) {
            this.bgColor = SystemColor.control;
        }
        g.setColor(this.bgColor);
        g.fillRect(0, 0, this.graphicWidth, this.graphicHeight);
        this.draw(g, 0, ColorUtil.blend(this.bgColor, this.color, this.minColor));
        if (this.on) {
            this.draw(g, 2, ColorUtil.blend(this.bgColor, this.color, 0.05));
            this.draw(g, 3, ColorUtil.blend(this.bgColor, this.color, 0.08));
            this.draw(g, 4, ColorUtil.blend(this.bgColor, this.color, 0.2));
            this.draw(g, 5, ColorUtil.blend(this.bgColor, this.color, 0.4));
            this.draw(g, 6, this.color);
        }
        this.invalidate();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.image, 0, 0, null);
    }
}

