/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.Base64;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class IconGenerator {
    private static String getData(IconType iconType) {
        switch (iconType) {
            case FoldUp: {
                return "iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAElSURBVDhPrZStbgJBFEa3DaICUYlE8ACVlYhKRCUCgais6ANUNOkDVFQiEBVIRCUCieQBEMjKiooKRHu+zX6b2c3CzpI9yQnMz53cOzszSQ3X+I1/mV/YxbN5Qy9mX/As+viL5QWVcQ8bM0cvssVd0FbmjbjBA3qBEU6CtsYGGM0nOnitjgxl6v4PdcQwRAfJWzR3GI6pklo26IClOkooY4+v1HGKe/TkY/ukrDxHqqJKOhh+yRkeY4Gep32t5AE9Sefv1FlT5uEpGGOBK9S18oRXrOMdPV+VqcKcZ/SgboLucB2q4Acd94gp5QfgCWPRvXZc/nCED8AeVX4sSibcqvThCB+AqToaooocr0rzhj5/YWMjKRy3i+xPa1xmv63R8oJJ8g+hLm8vlY7QbAAAAABJRU5ErkJggg==";
            }
            case FoldDown: {
                return "iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAEmSURBVDhPrZSvUkJBFIdXx2AgGIkGH4BoNBgJRILBQDTwAARmeACD0WAwEA1GApHoAxCIRoLBYJDfx/BjDhe4f5j7zXzD3LPnLHt2792zlNK/rI3zzW9t1D4h0DLO5QWBilDzJT1PWoaHPoGKPErX/xIYhsC3vJJluZQL6fpnmRqSiRzkD8pCR66j0+1inqQHfmRTFkFx3K6B3MLGcigefJFFjKTz6ZD2d+hKJ/zJG3kMOuAAnN+TB4nHPyZwhFfpvNzX7U46EVsyCyunA+d0ZC4T6eQpgQwf0uMzAkWwKhfgvTS3Mo7RUSnepYvYV8OKHf8kUJbsPj3Idnhm7ND+5sJn5Ak4yfgGvMnK8K7FL8Hy/l3Lk4gXh11fAKeSvTh2LoB9UloBxD5vL2/fINAAAAAASUVORK5CYII=";
            }
            case FieldChange: {
                return "iVBORw0KGgoAAAANSUhEUgAAABgAAAAQCAYAAAAMJL+VAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjEuNWRHWFIAAAFCSURBVDhPrdSvTgNBEMfxEUgEAtFHQPYBeA4SEhKQJGgsCssLYJAkWBJsE2wTFIIEAVV1hJY/Bczx++6WY293Dkqp+DSXmenN3v6zqqrama3JrfScXE+G0i1yCTcYmO3Jqwyk7+T7ci8T2S/yU25Q4UP5COlo6NQwenJ4k6OihkwRNDsRRhXT0YPsZIilNS9yKkvp++qHkDC7kKcQbhoJU5UilteNhbVZbjYwW5UreQyh/6HxtXRiA7NN4XPpnhfPi+liJrZowE7xihZhQoN8QRfpnQbb8ix8llc0Lwa+q6ewyB25EW9n/BXvYE03vncR2Fpml+I1ITbLNiXGCV/5em/4SZpwFs4kn65ZDhrTfC4tBy3FsW8u/m9XBbXHRQ0ZLxhwgcU/cqG1XXZ3wjY/KPJTbrDGVRxH+tN1vV7kapV9AoA1VEeY6xVeAAAAAElFTkSuQmCC";
            }
            case ViewButton: {
                return "iVBORw0KGgoAAAANSUhEUgAAACgAAAAMCAYAAAAQw/9NAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAABh0RVh0U29mdHdhcmUAcGFpbnQubmV0IDQuMS41ZEdYUgAAAulJREFUSEutlW1ojWEYxy922GjzumzG2DQzzGzetmajbd6Gbeb9ZXS8DDtRmhJCocgHTfaZIgor80H5sFleSnEiJSkmRRH7QDuxpuXyv871PPfzPOecSDn169zXy3Pf//u+7ud6iJmjaJhKxR011MgBagId4APoBvzFT/x0DXHvLuIHK4ifr8Uj8P8j30AnaAOyhh+Mtdf3/IywAPmsxOCeXOL8kWYyQ99u4uoM4rpstbOHqh2Z9yd+NcT2WwSBaPAZsZa4HPAKhBPv1ZBsgx/WmgfDdO9Q/61Ktd/VEYfqvTn/CdGSowIDlAG6rIAhawhx/WSv73IFcXKCY58vUZ87p62K+Phs4hNziO9WO/7TRcR3lju2XA/x2bZwbi7x2WJjiybUJ0AtlsPDoRnECXFe37LxxLifxi5IJt5slVvYP11P+AwWXpyu45tLNFY5jrjGdR32TtO4VMv2pSdGiW4RgSGXw/AML4JMcG2h2t9RSrHdp+IWKH6Jv97oxOenEZek6ri5VON2LDNJ7YMFar9Yp/bL9U4OCInAHpfDgwgoHa3jqwt00si4LVAE+Prp6ckpCGVjiIcN1PjbTSrgQhnxZ3QCGR9GlWQOiTehvHnRL2aPCGyNcBpOFTq7ljt5wNqtjVvg0ZnEcRBYhTLWZhJvyCL2TyJuRNnd+eUQfX2RnuyTVTr/1+3EFfAfwRx2rkWrCMwCMcv8xtq1vAzyH1ztjbsFXsTJyAm645GIAJmnKIX42Cz1pQ0mvoLqiP8xBLvyRRO2qW0mF5g242YeSpzoi3n8HoFdW4nj+3sveSc2eKncsR+tVCHCfbzF4tuWQzwR/XQCKmTnAdGS6/RBFWkaNTDJ9uU+ibbh9gv5EGg3beH2UuIpwzU/ZRDxiHjiwlHeZ1LhTxpA/GOn2jdQbsnflxe2oxu1/TNCVaz0RklsBu2f/OFPXS8Ifwn+8jXgEBr6+y2x8/rgQ0f4ifFH0A5kDVkrw6MhDNNvZoPbKHu9cBYAAAAASUVORK5CYII=";
            }
            case TestButton: {
                return "iVBORw0KGgoAAAANSUhEUgAAACgAAAAMCAYAAAAQw/9NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjEuNWRHWFIAAAJjSURBVEhLnZU/aBRREMa/4IGKokYFRQ9yyhnPeAEDItEg8U8KiwTUCEYTwqpEZdXezsLCwiJFqghioV3AKy3SqSBoKRIwQQUF0aBXnHB243w7+9i927eiKX7czp/39rs3b2YhIllCFJVg4QIevBvDy/cX8WlpHD8/TkAcy5c0NVwxy8qiMq9MK4FS9GlJjBCFOPGNEm1U3gDN8FPdbDkr4ckQ5OFxb4zvpoZCq8AQFWVBaVlwuw8S7IWc250Io03u9bfm/g9d622v7/lVoJaKCQxRUnjkvsQIltQJTPsbU5CZo5Dr+03w2/Ot8aenIDeqkNO7ILOD5rt7CLJ2le3FAxjc0bomBTWVKHAu5fTiE1i/AqlsghQ6IAe22C+ZH7E4hTC/pxNyZLs9/7gM6Yj3cezZmOzpYY4CG23ODD6BTsD9w2a/OGM2xdLu1TtKm2tpf56038VxyJr4BF+dhWgDRv4cGhTYbHNm8AkcKpp9U0t456BBmy9n/Fav2RTK8vP03NrO1RZL+3JoUmCtzZnBJ5Dlpd2/DXJM75FjrGzx39cgU/us7MzbuQ7yJT5FPv+jwBoFlpW/ltkncLjLbHfn8viljdS31XKnB8zHe0f7Q1z+HKiJfzcaM1UlM2YcPoGPTpjNk3x8ElLTjmWZnQieHO/ns2HIaDymOP8YG4ibZkR7tNvfJNRSTeagicwMasfXIOnStJ9jwpWQOFGMTXQnfjKps9Otc3+OFLXczq/kDOp2bDYycUbh54ifpbqS3iyiedVOmPA5HeMdez1qZU77lbre0SXt4OffAsyqzXeVsloEfwAbBtif+Gi/JgAAAABJRU5ErkJggg==";
            }
            case SetButton: {
                return "iVBORw0KGgoAAAANSUhEUgAAACgAAAAMCAYAAAAQw/9NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjEuNWRHWFIAAAJ0SURBVEhLnZVNbA1hFIYPbaNEoy1tkyq5qLrVP9FQIrSV0AjdINIU0ajqzwKJWNqJsCLpgkgkbCw0Uish9iKsaeiGjQ1STUkJ7vG+c+535+fOvbcxyZPM+fnOeef7Zs6IqmYzJnVgANwAz8E0+Az094joqyOiLw6LzgwiHb7/gLVYk7XZg73qXP/QFRBVnE58DeKK6q09olWlwgoZru+Iz43jbrfo4wPxsTTsTQ3FGbFpcUkwBeIWeXw46Ys6tkH0/l7RgU2i1xYocPq4rW2pjI9HoJakCRyTBPCOLx9PDlqDnTXxcZIaFb25S7R/o+j5VtGnh8z/pk90eLOtr11mu34PDxhdH4GaEhQ4EXDm5CXeO7eDl7aIfsSOBuM/hkSbKizevdrPfbDPhDrbca4lvD4HExQ4F3HmZLAx3OQsdgX+FLnYZr47XZ7991mvpGh3VHv2H5yAZ69dLvoWO/odD8SaBZijwPmIMy+PekS3rvJF8jjp76w1++h60dEm0RFAu3KJxXnMtBuxy8F6BZinwMmIc0GM7/ZF/hoWTZbbfVmJaM1S0USZiemCcOY7gduqs2vlYZIC60HBY37XL/oTQpz96ZQ1LFlsds8as692+DlB3mM9460r4+MxUFM97rwx0wzyjpnL7aLrsCt8D/kVcifYsI8lEL/daXYbBPDDeLhf9Mp20dIii3/DUGecXMAX3rAiXD8CtTT7c9BE5h3UHDPtVX6TokWiJxpEv5z2cyioAu+cyyH4SDJxzk3nH8KDOn+A7EHtroxQE8vZyMRx4H51M0C/QhCPm/e54HFGXwnH7BlvRM3i3v3q2IO9EiENHir/AE+v4p5eWlqwAAAAAElFTkSuQmCC";
            }
            case GetButton: {
                return "iVBORw0KGgoAAAANSUhEUgAAACgAAAAMCAYAAAAQw/9NAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAABh0RVh0U29mdHdhcmUAcGFpbnQubmV0IDQuMS41ZEdYUgAAAqNJREFUSEuVlUloU1EUhk8l1AmH1rZIjRBtlWCCltaqVKkzDog4UFoi1dapbVYirkQcwI0giIruRER3WRRxoeKu4IwbFUUL4qILpWDAIAGHdzx/zrt50zXSBx9595x7//vnDucRM0fJUlzoEy4Jj4RRYVxg8KWPeGQX8ZM9xOP9Gpsg0IImtDEH5oqb+QOPz1TM7fhSsInywx3ELXMICgHa6ol/HLGPCfNiL/GN9cSvu615zA0PsbJZ11xSeC/YBpW4t90ztDNBfLad+PwK4q4mjT2XiW3jwpxerv0vdtjzLvCSVINZSgjl7fsX7Q0qfE6MhXNve4LtZ2L2VBtxT7P+5g9p/PIa4tY61VnXSHxhFfG3g8GxPuBJliJLOV/Qyug+FW2Yas/7ub1R+1ZPIl7p/ql504l/DRJnFmnbz6suu45LDgYLoWCE3BYVWz231HaKA+TgLPr52k8OcgtmEMeqiMcO0B9p/x5MkYOx1zrJwYXqllVF+0QL8bvQylsowGAxFIxwa4OKYkVMLFVDnBAzVRJHDof/c6++100R2TTxUIp4rWwlYseW6jgxXGpf7/S0KlCEweFQMMJTKScQrZ1M/HMgmJtV7RnE2cM7TNdI38ZpxE0zidO1xCdbtf/xZRMyOAyDzULFbXaGiJOzVfiM3EJ/rl5WyxhEfcR7pbOKS4M+uCC2vA94kgOhZSYtVCwz96UGQhhg27B9vYu9GAyi39b52sYW391GfFOOx9ElxA9kPPJX5CYjv1BWFjpmXAh4SXt1UE3+t1Cj1nXIRTHnzrA5TlxwC/WHjHcRDNjqO5s0j7JidgM83h2YI1qozVM2qmZRG9HxqmA+dXmhLAYjb+Rr8P2wF/ODs4rVGdtvzeflln/6mKERecccmCsR8FCC6S+6ktGfArKG6wAAAABJRU5ErkJggg==";
            }
            case ReadButton: {
                return "iVBORw0KGgoAAAANSUhEUgAAACgAAAAMCAYAAAAQw/9NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjEuNWRHWFIAAAL4SURBVEhLrVVJSJVRFD6vnlRmZoNmVk45ZZZmWmSZqQ0YDZaY5pCvcHyrpKIgotq0CxdGVEIktQgMrLaNtIk2EURFaQYNKyMhIRt8ns73zrv/YNLKHz7++33nvnO/d8699ydmdkGeqBO5lP9oN7W/2Eddo610n/3UJxgU8CQBuZDznqAjIoy+ej00IGvvD3mwH8ucn7wCX2w4/YJsMNVDXBBL/KTctcCkYkeCrnWhkAaE+wReq2AhcxmCN5gcO0Mn+9KJz+YTJ0QoXzHXnXQysUEKgDWul1oavGSoQT8lCqz2GYNva5Q/q1AO/G6xEnDXJuLmTOIWweUiWwce7iI+lkNclULcvpL4bpk7/ukA8cnVxPVpxJ2FxGmzNf+Nza558JQIgz0OkReGuw0+kMXAI8PsOdvjVVu3gDjcq+OjYgix55XKgex59viK/CHE/7QSJ0faOiD7L/geZxDogcFhp2gMVi4lrki2k5xbq/HuUhoDb10e5GMAOPYqxh/qKdCxPqgHBKO3yyiAeHlSUONLUm3wojji4SbNCw5MYHAYBkecojHoROMyO45KQUP12sQkjC6eqdq7UNWB7hJiMRrcAoitiVHdn6UcMTN3pzQS2gQGR2Cw1ykagwN1xO9riWNCe/LWNo1j34BHSGujpxPHyyFKjyLOkXZ+aVCTKY4WZs7Rd160/t505eYWe83/GOyFwRSB1WanQfBTspnBa1LdfOsSK4kLpsJ18kfAX1crz52vvEm6AX58lf2b4kWqjTMIT3LM9JrJEgSvmbhxBj/WKwf6paJP9+p4lhyaa9LGO3JCzxcQT5ui88/I1YR4g1xTqNKeJOWoMOI40SbfkWzdi4Y7DMJLln0PqsngRe0JTTYGgVqpHrTDcmWAXy12txEokSog9u2Qe1EYxdsYBGDMxFHZ03k6vrhxgovaPA7B86qaUkMTOwX4HPX9bKGhQJu9CPBZ7rOXVcTfG906gP07ePBfPYShH83UL3v2sYyxhk8+q2nGgw2mvwswgAYfcmBgAAAAAElFTkSuQmCC";
            }
            case ProgramIcon: {
                return "iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAIAAAD8GO2jAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjEuNWRHWFIAAALBSURBVEhLtZZRaFJRGMfve8976FEY+NjDHrcYDOZDg0AYDQQRJCoQpI2FNBIWwgVLEG4tDEEaMwSZsbAk6QTqmltu6eZaGy3mWq7VgmAVEfTSX8939arbvXegP87D9/d6z/+c833nUyGlj3QySdEp0WVQsloPTKaVQGAxEqGPdKNhsOb1ls3m5WBwPh7fdLkKfv/eyMjbqSnEMMtGoynG6KsnoGGQSSSWwmESVWpmMPg6OJiXpFWfT8VGzQAT/e3qInESjH0bGFiIxZrWUUNjB/CgSJWCz3dkNJJoRM0AJ/69r4+EFkVRRBWQUKBmgI2/npsjoQUykQuFSCgQrNd33Xc2PP714MwyRjwxzx9k4vGfRiOSzKUmWMqO3U5CQWUH4ehS6HFOlIre+2u2sdK1mx9Hx/JPzlqkQIOlBoyhtChWcMwRofhit2eeBWaxMymYv3h53yVu2m/swB6LwGpgmXyZpm8r4BeFhEyjAWPvJyaOva58K+OeLez1/KVDk+2AHijAFWl9t8EAWd21Wkmogt1gkJDB61+GhkjINBjgsc6mFni0gkFCgdoRYeoNt5uEDsxXy63533Y41j0eElXqBkjRu8lJEjpAwlsNkIOmyy+UZMqMYZDQwXO2bxk9IiGzl8v96e0lUaW+A/Qs/fcWJF5kUFokFDQVUt0AzUSzuTdhcX5C4ZKQKdlsyhtHBpgdD3isn9jTBfYqhUxgRGYXsSHfg1XJn0XjwUBHcNzaJgNk5s30NI/1g9nPnPt3xVWZCLcdk/ofFu7dTWcNF/jFxKgY4NR+dXfzd04LMkGRAlR8rUtWDNBmdf6w6OTz8PDW+DiPBSz/sL+fizZSK0jhg9PJozaCpvTbYOCx0N7DqYFpYYOgfg/aC4qed7ZOGaCQ8POAoFMGKNMfPT0IOmUA8FcMo4MGqE90oA4a4JSKovgf2BjJQUV4H64AAAAASUVORK5CYII=";
            }
            case AdjustPadLow: {
                return "iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAIpSURBVFhHvZerTgNBGIU3QEgTwONAoAkCgUBUIJAIBAkIEhSOB8DxABUIBKICiegDICqQCB6ABMItEAgh3O+Xc9rzw+TPNoV2Z0/6ZXZu/9mZzs7sJu3oq/ZrTx1K/y04zyudqhXkLRjvcQbAroryE0ctc6OoqnwEw10ZXyitqiq+YDYp0yelr0rH1CSuYFSVoaeiJvEEk6LMbNTGm9IRNY0jGFRk5LlXWlbT7IXgIzKx0Xo+AOuG1CVbIfCmjI6Ueqx8TV2yEQIWwCL4lEHaDdyAF11zfQyoe2tCgC4wAcrgDoRm5y5PzlyeN7EBuGEVFLa50JirfB1cgjCgjd7g/81RG8yH9SGMxZgcUJesfoXCPrAEjkHYkSN/1DVN0kbu4c54CE6UXoOwnjezCsZlj9IkWVYl4VQeBPlG2GPXKO9hvR8AB1zicbxSv5Wa7pVmrR7QXb/8EddGwf6CtMV26/Kt4GPQI31xskAVbJC28sM18g7SFuEp8FPNQ4s76DT42xOBhr1gTh39vk9oGuZtDzB4QzuAMXoVtjUhwLAChgYPLu+352fQrxDtC8G4RhjYXkAacaW0pK7ZCAGbHUQGZ4ptBtU1OyGoHcV++g1b8XGOZAQelYG9inlsduIcxxSCN3ods50w7msZDOyVzM+C5eO+klEw4fMdmhtbahJXMLKPEluMNvr8Pk5gZh8mtu1uqyofwXAW7Muc5PuBCsNOMCPzBRW3oCT5BlTxuy7XQPiCAAAAAElFTkSuQmCC";
            }
            case AdjustPadMedium: {
                return "iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAJPSURBVFhHxZdNSxxBEIZrVp1ZRxACHiSnEMght4RcVhERf0BQyEU8Sk6eE/CSJddAAvkRIkggId4l4MfuJeBBVBByFFHB28x278ekqruyZpLZ3a5G9IHtqepeqKp3unpmAvAk+15dwMtX/C0GL99/M5MeeCWAwSch1UcwGj6ARJ1BHL3AJM55WUSJr1IqJjgRRw+N74lYAVN9on5yYEuiTtGf9VHBR4FKLjgRR09w9FJBpABXX8OAj3jqhqRxDHF5XqqCVAGq/v/gRFx+iqNYBecEuPoP7BaTqKr5nwCJAlQ93evexNEzHEUqOCXA1VfZ7U+q30hUcFWAqqfqBjMaTuPorELPLuAqKqBbM5BlryEaGbcrDjT0DpTDT2jVB3VFLoFu0HZnClTzFVb92K54Qsf08NAGhMO76BUmYxLoBqZdPmij+ZKoX6jiFxgq1dDrJhNkm2ufoRSsQDgyRhN3QtI4wXNjjcwAq8/M5D0hPQlvnRK02lts3x20OXXrI1qLdAtu2q3VXsJNmH/S3RaJOseOWP+3I4rbUDXnoJMt46EyYVc8SfUVbvB13P0/0OvdhkX81ZrvUJXndlaAam5j4GXRQVQEJvLn5VOK08uqSxfUUYUDtt1I9R6Odev0Z6AChIcKzq/qrucAqXDIdn9SvY+jU/WEkwKEQAXRh4rkJCQVTtkuxu4V5+oJZwUIBxXEn2nSZwGpcMZ2HquOqHpClIA5VOJold08cfTWrAuRKkCQCpdsW6wq4uoJcQKmynZnHoNemImGvsbqPb+OAX4DCA7hDYGewGoAAAAASUVORK5CYII=";
            }
            case AdjustPadHigh: {
                return "iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAJVSURBVFhHxZY/aFNRFMa/94yapKl/OmhHFxGdHIJUEBQczSQODi4u7g4OgnRyEDq4ODuJOOhWcVFREESJk4O4FUWwCFpt08S0tX7feyfF6Etyz0XaH4R7zr3h3fN99953H2JprOMMf+tqrSuK1FoXnHR/dQG3FY99wy3l2UAEUQWQ+vIe7FPQ2osDyhXH4C5AaqXa0gzmM7EuxDhQN9UbMD/MJsoFVwFSWfuKm5b2QReux7jgdaC+NIGDFvdBF46ycbsQXICt/YylhXB82uuCxwGtvdZ6IBw/xsblQlABpn7a0qFUfuCKx4VQB6Re6kbS3oWTbIJdSKz9B1NR397BidIKLrXHMZGPjKa8iCed8ey0NGcTzOe9xfQV0Js0XcXxyiLOUfWhfCQOLttct4J7K2W8YFpYTFZAb2Lt8lEbLRY++z1dvP+rhJdMN4pJLr9C/eMRPO7UsFsdmwGLeUuhVxUnZ1todauoZiNbQLqVk4u01MUDizcNbU6erhsMG8mfx21HG+e5Nn033f9ibAEfumXc/ftEFB7DnUs4tW0VF/jRMZmPxMGvps9rJdz5WcMzpoOPYRG9YviQayxkKu8NhyIeceKLrhdRESxEH52zeeaiwckfWjyQkLugyU3z2uIgeCE9ZdPMs+GMdEBEuBCkXoTehnLhjcVDofrnbILUiyAHhMOFYPXC80UkF95ZXIjtlWD1ItgBEeCCS73wOCDkwpzFfZg7LvXC5YAY4oJbvfA6IJp6xVqcYa641Qt3AVQ5n67hNIv4pLzyHV94gU2pP/uDC+A3/3nARLYvFyQAAAAASUVORK5CYII=";
            }
            case SmallGreenCircle: {
                return "iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAABySURBVChTY/z//z9jMAOXzi+G7wsYGBiMgBgEzgFx3GaG/1cZE/7LGr1heHwKKMAMlkKAv0Csz+jzH6zaECyECZ4wAQlckiAgA1KAF4AUgKzABcBWxAExyEHoACTmwQTyCpChD8RPQKJQAGLrb2b4fxUAcwgegiFAZ+EAAAAASUVORK5CYII=";
            }
            case SmallClearCircle: {
                return "iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAACDSURBVChTdU6xDYRADPMdeomelj0oWOEpqZkBMc43vwMjAR0sgIRMHB2IBku+5JzECUiGlUu0iC8RFH/sPYoq5gMqbph3AMFIIwqU+GPy7o9N3g6Xy+0gYbRUUw2CHBzS9PeGpD2RGQ8lMU2rKUpI8GKN1i6yesdSTvG5X5rfoOcdwAn6H1RibXk4TwAAAABJRU5ErkJggg==";
            }
            case X: {
                return "iVBORw0KGgoAAAANSUhEUgAAAB4AAAAQCAYAAAABOs/SAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAGOSURBVEhLnZUrTgRBEIYrZMUKxMg5AAfgAIiVCMRKBAKJRCCQJAgkAoFAcAAER1iJQCARCAQCAQkhKyCBZPj/fszU9IPpnU6+zFbXXzWPrqqVRmQKTsAHaBRf4AxUDayVYIzNuQTYaWHOU1BR9Oo2yQLMwa3a4wMdg2nyJhr7EodgKOcbxd64AhOVZAYY5P1Mtg86jcb6ngAswz2YBZpz76fx4A3wCOaBeAdoDZN3mtifyrENehrv2ANDTxtq7oD+Is+g/0VEtoDWvACjsQIrmoDU+WwGmgOgNfzNuK4GGBPXyRFoNVaoEVkHYZUzyYbSsIhYcNR1VU+NyDX4AYxrq7jVOHpGD5EasBgYjB2TjAVY/6P1N8xrHWuSX9/gE/wai+eCN3XXcHGvclcuxrwD5kiv6GnyvZg665KzTc6AngGzpBd3gdakqnlwBnjhqF5M2MUzgM7Rvej8o2YAN73BNlipF5W2dAZcOp/Z0P16A3g+Rb0YkZ8BYc4lxfwL0/3qGezFLPEM8DDnRSNS/wECE7EJ/1iClQAAAABJRU5ErkJggg==";
            }
        }
        return null;
    }

    public static BufferedImage makeImage(IconType iconType) {
        BufferedImage image = null;
        try {
            byte[] imageByte = Base64.getDecoder().decode(IconGenerator.getData(iconType));
            ByteArrayInputStream bis = new ByteArrayInputStream(imageByte);
            image = ImageIO.read(bis);
            bis.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return image;
    }

    public static ImageIcon makeIcon(IconType iconType) {
        return new ImageIcon(IconGenerator.makeImage(iconType));
    }

    public static enum IconType {
        FoldUp,
        FoldDown,
        FieldChange,
        ViewButton,
        TestButton,
        SetButton,
        GetButton,
        ReadButton,
        ProgramIcon,
        AdjustPadHigh,
        AdjustPadMedium,
        AdjustPadLow,
        SmallGreenCircle,
        SmallClearCircle,
        X;

    }
}

