/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.CommandProcessor;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.Support;
import dk.hkj.util.FileUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JTextArea;

public class HotKeyLoader {
    private String[] popupKeys = new String[]{"F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "F10", "F11"};
    private int[] popupCodes = new int[]{113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    private Map<Integer, String> hotKeys = new HashMap<Integer, String>();
    private JTextArea area;
    private Container container;
    KeyAdapter keyAdapter = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            int i;
            if (e.getModifiers() != 0) {
                return;
            }
            String cmds = (String)HotKeyLoader.this.hotKeys.get(e.getKeyCode());
            if (cmds != null && (i = cmds.indexOf(58)) > 0) {
                String[] stringArray = cmds.substring(i + 1).trim().split("[\r\n]+");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    CommandProcessor.processCommands(Support.cmdEnvironment, line);
                    ++n2;
                }
            }
        }
    };
    private ActionListener popupActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String keyName = e.getActionCommand();
            String cmds = HotKeyLoader.this.area.getSelectedText();
            int index = HotKeyLoader.this.findKeyIndex(keyName);
            HotKeyLoader.this.hotKeys.put(HotKeyLoader.this.popupCodes[index], String.valueOf(HotKeyLoader.this.popupKeys[index]) + ":" + cmds);
            HotKeyLoader.this.saveHotKeys();
        }
    };

    public HotKeyLoader(Container container, JTextArea area) {
        this.area = area;
        this.container = container;
        this.loadHotKeys();
    }

    public JMenu makeHotKeyMenu() {
        FontAdjust.FontMenu menu = new FontAdjust.FontMenu("Assign marked area to ...");
        String[] stringArray = this.popupKeys;
        int n = this.popupKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            FontAdjust.FontMenuItem item = new FontAdjust.FontMenuItem(s);
            item.setActionCommand(s);
            item.addActionListener(this.popupActionListener);
            menu.add(item);
            ++n2;
        }
        return menu;
    }

    public void assign() {
        this.assignKeyListener(this.container, this.keyAdapter);
    }

    private void assignKeyListener(Container comp, KeyListener listener) {
        comp.addKeyListener(listener);
        Component[] componentArray = comp.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (comp instanceof Container) {
                this.assignKeyListener((Container)c, listener);
            }
            ++n2;
        }
    }

    private int findKeyIndex(String keyName) {
        int i = 0;
        while (i < this.popupKeys.length) {
            if (this.popupKeys[i].equalsIgnoreCase(keyName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void saveHotKeys() {
        String fname = String.valueOf(Support.getConfigPath()) + "/settingsHotkeys.txt";
        ArrayList<String> list = new ArrayList<String>();
        list.add("##HOTKEYS");
        for (String s : this.hotKeys.values()) {
            list.add("##KEY " + s);
        }
        list.add("##KEY none");
        try {
            FileUtil.writeFile(new File(fname), list);
        }
        catch (IOException iOException) {}
    }

    private void loadHotKeys() {
        try {
            String fname = String.valueOf(Support.getConfigPath()) + "/settingsHotkeys.txt";
            List<String> list = null;
            try {
                list = FileUtil.readFileAsList(new File(fname));
            }
            catch (IOException iOException) {
                return;
            }
            if (!list.get(0).equalsIgnoreCase("##HOTKEYS")) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            boolean insideDef = false;
            for (String line : list) {
                if (line.startsWith("##KEY ")) {
                    String keyName;
                    int index;
                    int i = sb.indexOf(":");
                    if (i >= 0 && (index = this.findKeyIndex(keyName = sb.substring(0, i))) >= 0) {
                        this.hotKeys.put(this.popupCodes[index], sb.toString());
                    }
                    sb.setLength(0);
                    sb.append(line.substring(6));
                    continue;
                }
                if (!insideDef) continue;
                sb.append(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }
}

