/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.Support;
import dk.hkj.util.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HelpLoader {
    private static Map<String, List<String>> helpTextCollection = new ConcurrentHashMap<String, List<String>>();

    private static List<String> readURLAsList(URL url) throws IOException {
        HttpURLConnection huc = (HttpURLConnection)url.openConnection();
        huc.setConnectTimeout(3000);
        huc.setReadTimeout(3000);
        huc.connect();
        InputStream is = huc.getInputStream();
        ArrayList<String> list = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is), 32768);){
            String line = null;
            while ((line = br.readLine()) != null) {
                list.add(line);
            }
        }
        return list;
    }

    static List<String> getFile(String inetPath, String filePath) {
        File file = new File(filePath);
        List<String> list = null;
        try {
            URI uri = new URI("http", "lygte-info.dk", inetPath, null);
            list = HelpLoader.readURLAsList(uri.toURL());
            FileUtil.writeFile(file, list);
            return list;
        }
        catch (Exception exception) {
            if (file.exists()) {
                try {
                    list = FileUtil.readFileAsList(file);
                    return list;
                }
                catch (IOException iOException) {}
            }
            return new ArrayList<String>();
        }
    }

    static List<String> getHelpFile(String fname) {
        List<String> list = helpTextCollection.get(fname);
        if (list != null) {
            return list;
        }
        list = HelpLoader.getFile("/pic/Projects/TestController/DeviceHelp/" + fname + ".dat", String.valueOf(Support.getConfigPath()) + "/" + fname + ".txt");
        helpTextCollection.put(fname, list);
        return list;
    }

    static List<String> filterCommandList(List<String> list, String filter) {
        ArrayList<String> nList = new ArrayList<String>();
        filter = filter.toLowerCase();
        int i = list.size() - 1;
        while (i >= 0) {
            String line = list.get(i);
            if (line.trim().length() != 0 && !Character.isWhitespace(line.charAt(0)) && line.toLowerCase().startsWith(filter)) {
                nList.add(line);
            }
            --i;
        }
        return nList;
    }

    static List<String> filterList(List<String> list, String filter) {
        ArrayList<String> nList = new ArrayList<String>();
        filter = filter.toLowerCase();
        boolean match = false;
        boolean fullWord = filter.trim().length() != filter.length();
        filter = filter.trim();
        ArrayList<String> remarks = new ArrayList<String>();
        for (String line : list) {
            if (line.startsWith("##")) continue;
            if (match && (line.trim().length() == 0 || Character.isWhitespace(line.charAt(0))) && nList.size() == 1) {
                remarks.add(line);
                continue;
            }
            if (line.trim().length() != 0 && !Character.isWhitespace(line.charAt(0)) && line.toLowerCase().startsWith(filter) && (!fullWord || line.length() > filter.length() && Character.isWhitespace(line.charAt(filter.length())))) {
                nList.add(line);
                match = true;
                continue;
            }
            match = false;
        }
        if (nList.size() == 1) {
            nList.addAll(remarks);
        }
        return nList;
    }
}

