/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.ChartSaveResolutionPanel;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.MyLogarithmicAxis;
import dk.hkj.main.Support;
import dk.hkj.util.Complex;
import dk.hkj.util.FFT;
import dk.hkj.util.StringUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYLineAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.xy.DefaultXYDataset;

public class FFTChart
implements ChartMouseListener {
    private static int maxPoints = 524288;
    private static final int maxFFTime = 1200;
    private Thread fftAnalyzer = null;
    private BlockingQueue<FFTQueueEntry> fftQueue = new ArrayBlockingQueue<FFTQueueEntry>(3);
    private FFTPanel fftPanel = null;
    private JFreeChart freeChart = null;
    private DefaultXYDataset dataset = null;
    private AmpFormat ampFormat = AmpFormat.rms;
    private FreqFormat freqFormat = FreqFormat.logHz;
    private WindowFunction windowFunction = WindowFunction.Blackman;
    private boolean noTime = false;
    private boolean markers = true;
    private double minFreq = 0.0;
    private double maxFreq = 1.0E101;
    private double lastMinFreq = 0.0;
    private double lastMaxFreq = 1.0E101;
    private double lastMinValue = 0.0;
    private double lastMaxValue = 0.0;
    private boolean cursorOn = false;
    private double cursorPosition = 0.0;
    private XYLineAnnotation cursorLine = null;
    private XYTextAnnotation cursorText = null;
    private String channel = "";
    private boolean snap = false;

    public FFTChart() {
        this.freeChart = ChartFactory.createXYLineChart("", "Frequency", "Ampliture", null, PlotOrientation.VERTICAL, true, true, false);
        this.fftPanel = new FFTPanel(this.freeChart);
        FontAdjust.fontSizes.chartTheme.apply(this.freeChart);
        this.freeChart.getLegend().setVisible(false);
        this.dataset = new DefaultXYDataset();
        this.freeChart.getXYPlot().setDataset(this.dataset);
        this.fftAnalyzer = new FFTAnalyzer();
        this.fftAnalyzer.start();
        this.refresh(1.0, null);
        this.setupFormat();
        this.fftPanel.addChartMouseListener(this);
    }

    public void destroy() {
        if (this.fftAnalyzer != null) {
            try {
                this.fftQueue.put(new FFTQueueEntry());
            }
            catch (InterruptedException interruptedException) {}
            this.fftAnalyzer.interrupt();
            this.fftAnalyzer = null;
        }
    }

    public static List<String> getAmpFormats() {
        ArrayList<String> list = new ArrayList<String>();
        AmpFormat[] ampFormatArray = AmpFormat.values();
        int n = ampFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            AmpFormat af = ampFormatArray[n2];
            list.add(af.name());
            ++n2;
        }
        return list;
    }

    public static List<String> getFreqFormats() {
        ArrayList<String> list = new ArrayList<String>();
        FreqFormat[] freqFormatArray = FreqFormat.values();
        int n = freqFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            FreqFormat ff = freqFormatArray[n2];
            list.add(ff.name());
            ++n2;
        }
        return list;
    }

    public static List<String> getWindowFunctions() {
        ArrayList<String> list = new ArrayList<String>();
        WindowFunction[] windowFunctionArray = WindowFunction.values();
        int n = windowFunctionArray.length;
        int n2 = 0;
        while (n2 < n) {
            WindowFunction wf = windowFunctionArray[n2];
            list.add(wf.name());
            ++n2;
        }
        return list;
    }

    public void setMarkers(boolean markers) {
        this.markers = markers;
    }

    public boolean getMarkers() {
        return this.markers;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public WindowFunction getWindowFunction() {
        return this.windowFunction;
    }

    public void setWindowFunction(WindowFunction windowFunction) {
        this.windowFunction = windowFunction;
    }

    public void setWindowFunction(String windowFunction) {
        WindowFunction[] windowFunctionArray = WindowFunction.values();
        int n = windowFunctionArray.length;
        int n2 = 0;
        while (n2 < n) {
            WindowFunction wf = windowFunctionArray[n2];
            if (windowFunction.equalsIgnoreCase(wf.name())) {
                this.setWindowFunction(wf);
            }
            ++n2;
        }
    }

    public void setSnap(boolean snap) {
        this.snap = snap;
        this.updateCursor();
    }

    public void setOption(String option) {
        this.setWindowFunction(option);
        this.setFreqFormat(option);
        this.setAmpFormat(option);
    }

    public FreqFormat getFreqFormat() {
        return this.freqFormat;
    }

    public void setFreqFormat(FreqFormat freqFormat) {
        this.minFreq /= this.getFreqScale();
        this.maxFreq /= this.getFreqScale();
        this.freqFormat = freqFormat;
        this.minFreq *= this.getFreqScale();
        this.maxFreq *= this.getFreqScale();
        this.lastMinFreq = this.minFreq;
        this.lastMaxFreq = this.maxFreq;
    }

    public void setFreqFormat(String freqFormat) {
        FreqFormat[] freqFormatArray = FreqFormat.values();
        int n = freqFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            FreqFormat ff = freqFormatArray[n2];
            if (freqFormat.equalsIgnoreCase(ff.name())) {
                this.setFreqFormat(ff);
            }
            ++n2;
        }
    }

    public boolean isLogFreq() {
        switch (this.freqFormat) {
            case linHour: {
                return false;
            }
            case linHz: {
                return false;
            }
            case logHour: {
                return true;
            }
            case logHz: {
                return true;
            }
            case linMin: {
                return false;
            }
            case logMin: {
                return true;
            }
            case linDay: {
                return false;
            }
            case logDay: {
                return true;
            }
        }
        return false;
    }

    public double getFreqScale() {
        switch (this.freqFormat) {
            case linHour: {
                return 3600.0;
            }
            case linHz: {
                return 1.0;
            }
            case logHour: {
                return 3600.0;
            }
            case logHz: {
                return 1.0;
            }
            case linMin: {
                return 60.0;
            }
            case logMin: {
                return 60.0;
            }
            case linDay: {
                return 86400.0;
            }
            case logDay: {
                return 86400.0;
            }
        }
        return 1.0;
    }

    public AmpFormat getAmpFormat() {
        return this.ampFormat;
    }

    public void setAmpFormat(AmpFormat ampFormat) {
        this.ampFormat = ampFormat;
    }

    public void setAmpFormat(String ampFormat) {
        AmpFormat[] ampFormatArray = AmpFormat.values();
        int n = ampFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            AmpFormat af = ampFormatArray[n2];
            if (ampFormat.equalsIgnoreCase(af.name())) {
                this.setAmpFormat(af);
            }
            ++n2;
        }
    }

    public double getMinFreq() {
        return this.minFreq;
    }

    public void setMinFreq(double minFreq) {
        this.minFreq = minFreq;
    }

    public double getMaxFreq() {
        return this.maxFreq;
    }

    public void setMaxFreq(double maxFreq) {
        this.maxFreq = maxFreq;
    }

    private void setXScale() {
        NumberAxis axis = (NumberAxis)this.freeChart.getXYPlot().getDomainAxis();
        if (this.minFreq == 0.0 && this.maxFreq >= 1.0E100) {
            axis.setAutoRange(true);
        } else {
            axis.setAutoRange(false);
            axis.setRange(Math.max(this.minFreq, this.lastMinFreq), Math.min(this.maxFreq, this.lastMaxFreq));
        }
    }

    public void setupFormat() {
        NumberAxis axis = null;
        switch (this.freqFormat) {
            case linHour: {
                axis = new NumberAxis("Frequency /hour");
                break;
            }
            case linHz: {
                axis = new NumberAxis("Frequency Hz");
                break;
            }
            case logHour: {
                axis = new MyLogarithmicAxis("Frequency /hour");
                break;
            }
            case logHz: {
                axis = new MyLogarithmicAxis("Frequency Hz");
                break;
            }
            case linMin: {
                axis = new NumberAxis("Frequency /minute");
                break;
            }
            case logMin: {
                axis = new MyLogarithmicAxis("Frequency /minute");
                break;
            }
            case linDay: {
                axis = new MyLogarithmicAxis("Frequency /day");
                break;
            }
            case logDay: {
                axis = new MyLogarithmicAxis("Frequency /day");
                break;
            }
        }
        if (this.noTime) {
            axis.setLabel(String.valueOf(axis.getLabel()) + " assuming 1 sample/sec");
        }
        Support.MyDecimalFormat nf = new Support.MyDecimalFormat();
        nf.setMaximumFractionDigits(1);
        nf.setSIFormat(true);
        axis.setNumberFormatOverride(nf);
        this.freeChart.getXYPlot().setDomainAxis(axis);
        axis.setTickLabelFont(FontAdjust.fontSizes.chartTheme.getRegularFont());
        axis.setLabelFont(FontAdjust.fontSizes.chartTheme.getLargeFont());
        this.setXScale();
        switch (this.ampFormat) {
            case dBu: {
                axis = new NumberAxis("Amplitude dBu");
                nf = new Support.MyDecimalFormat();
                nf.setMaximumFractionDigits(1);
                axis.setNumberFormatOverride(nf);
                break;
            }
            case dBV: {
                axis = new NumberAxis("Amplitude dBV");
                nf = new Support.MyDecimalFormat();
                nf.setMaximumFractionDigits(1);
                axis.setNumberFormatOverride(nf);
                break;
            }
            case rms: {
                axis = new NumberAxis("Amplitude rms");
                nf = new Support.MyDecimalFormat();
                nf.setMaximumFractionDigits(1);
                nf.setSIFormat(true);
                axis.setNumberFormatOverride(nf);
                break;
            }
            case rmslog: {
                axis = new MyLogarithmicAxis("Amplitude rms log");
                nf = new Support.MyDecimalFormat();
                nf.setMaximumFractionDigits(1);
                nf.setSIFormat(true);
                axis.setNumberFormatOverride(nf);
                break;
            }
            case peak: {
                axis = new NumberAxis("Amplitude peak");
                nf = new Support.MyDecimalFormat();
                nf.setMaximumFractionDigits(1);
                nf.setSIFormat(true);
                axis.setNumberFormatOverride(nf);
                break;
            }
            case peakLog: {
                axis = new MyLogarithmicAxis("Amplitude peak log");
                nf = new Support.MyDecimalFormat();
                nf.setMaximumFractionDigits(1);
                nf.setSIFormat(true);
                axis.setNumberFormatOverride(nf);
            }
        }
        this.freeChart.getXYPlot().setRangeAxis(axis);
        axis.setTickLabelFont(FontAdjust.fontSizes.chartTheme.getRegularFont());
        axis.setLabelFont(FontAdjust.fontSizes.chartTheme.getLargeFont());
    }

    public List<Peak> findPeaks() {
        ArrayList<Peak> peaks = new ArrayList<Peak>();
        int i = 1;
        while (i < this.dataset.getItemCount(0) - 1) {
            double v = this.dataset.getYValue(0, i);
            if (v > this.dataset.getYValue(0, i - 1) && v > this.dataset.getYValue(0, i + 1)) {
                peaks.add(new Peak(this.dataset.getXValue(0, i), this.dataset.getYValue(0, i)));
                peaks.sort(null);
                if (peaks.size() > 100) {
                    peaks.remove(0);
                }
            }
            ++i;
        }
        if (this.dataset.getXValue(0, 0) == 0.0) {
            peaks.add(new Peak(this.dataset.getXValue(0, 0), this.dataset.getYValue(0, 0)));
        }
        return peaks;
    }

    public List<String> listPeaks() {
        ArrayList<String> list = new ArrayList<String>();
        String s1 = this.freeChart.getXYPlot().getDomainAxis().getLabel();
        String s2 = this.freeChart.getXYPlot().getRangeAxis().getLabel();
        list.add(String.valueOf(s1) + "\t" + s2 + "\tHarmonic");
        List<Peak> peaks = this.findPeaks();
        if (peaks.size() == 0) {
            return list;
        }
        double f0 = peaks.get((int)(peaks.size() - 1)).freq;
        if (f0 == 0.0 && peaks.size() > 1) {
            f0 = peaks.get((int)(peaks.size() - 2)).freq;
        }
        for (Peak p : peaks) {
            double h = p.freq / f0;
            String s = "";
            if (Math.abs((double)Math.round(h) - h) < 0.2 && h < 15.0) {
                s = "\t" + StringUtil.formatDoubleEE(h, false, 3);
            }
            list.add(1, String.valueOf(StringUtil.formatDoubleEE(p.freq, false, 3)) + "\t" + StringUtil.formatDoubleEE(p.value, false, 3) + s);
        }
        list.add("List is sorted by amplitude");
        return list;
    }

    public double zoomInMin() {
        if (this.isLogFreq()) {
            double v = Math.log(this.cursorPosition) - Math.log(this.lastMinFreq);
            double f = Math.exp(Math.log(this.cursorPosition) - v / 2.2);
            if (f < 0.0) {
                f = 0.0;
            }
            return f;
        }
        double f = (this.lastMaxFreq - this.lastMinFreq) / 5.0;
        if ((f = this.cursorPosition - f) < 0.0) {
            f = 0.0;
        }
        return f;
    }

    public double zoomInMax() {
        if (this.isLogFreq()) {
            double v = Math.log(this.lastMaxFreq) - Math.log(this.cursorPosition);
            return Math.exp(Math.log(this.cursorPosition) + v / 2.2);
        }
        double f = (this.lastMaxFreq - this.lastMinFreq) / 5.0;
        return this.cursorPosition + f;
    }

    public double zoomOutMin() {
        if (this.isLogFreq()) {
            double v = Math.log(this.cursorPosition) - Math.log(this.lastMinFreq);
            v = Math.exp(Math.log(this.lastMinFreq) - v / 2.0);
            if (v < 0.0) {
                v = 0.0;
            }
            return v;
        }
        double f = (this.lastMaxFreq - this.lastMinFreq) / 5.0;
        if ((f = this.lastMinFreq - f) < 0.0) {
            f = 0.0;
        }
        return f;
    }

    public double zoomOutMax() {
        if (this.isLogFreq()) {
            double v = Math.log(this.lastMaxFreq) - Math.log(this.cursorPosition);
            return Math.exp(Math.log(this.lastMaxFreq) + v / 2.0);
        }
        double f = (this.lastMaxFreq - this.lastMinFreq) / 5.0;
        return this.lastMaxFreq + f;
    }

    public void cursorOff() {
        this.cursorOn = false;
        this.updateCursor();
    }

    private void updateCursor() {
        XYPlot xyplot = this.freeChart.getXYPlot();
        if (this.cursorLine != null) {
            xyplot.removeAnnotation(this.cursorLine);
            xyplot.removeAnnotation(this.cursorText);
            this.cursorLine = null;
        }
        if (this.cursorOn) {
            double lower = xyplot.getRangeAxis().getLowerBound();
            double upper = xyplot.getRangeAxis().getUpperBound();
            int min = 0;
            int max = this.dataset.getItemCount(0);
            int idx = (min + max) / 2;
            do {
                double v;
                if ((v = this.dataset.getXValue(0, idx)) < this.cursorPosition) {
                    min = idx;
                } else {
                    max = idx;
                }
                idx = (min + max) / 2;
            } while (max - min > 1);
            if (idx < this.dataset.getItemCount(0) - 1 && Math.abs(this.dataset.getXValue(0, idx) - this.cursorPosition) > Math.abs(this.dataset.getXValue(0, idx + 1) - this.cursorPosition)) {
                ++idx;
            }
            this.cursorPosition = this.dataset.getXValue(0, idx);
            if (this.snap) {
                int idx1 = idx;
                while (idx1 > 0 && idx1 < this.dataset.getItemCount(0) - 2) {
                    double v = this.dataset.getYValue(0, idx1);
                    if (v > this.dataset.getYValue(0, idx1 - 1) && v > this.dataset.getYValue(0, idx1 + 1) && v > this.dataset.getYValue(0, idx1 + 2)) {
                        idx = idx1;
                        break;
                    }
                    ++idx1;
                }
            }
            double freq = this.dataset.getXValue(0, idx);
            double value = this.dataset.getYValue(0, idx);
            this.cursorLine = new XYLineAnnotation(freq, lower, freq, upper, new BasicStroke(2.0f), Color.CYAN);
            xyplot.addAnnotation(this.cursorLine);
            this.cursorText = new XYTextAnnotation(" " + StringUtil.formatDoubleEE(freq, false, 3) + "  " + StringUtil.formatDoubleEE(value, false, 3) + " ", freq, upper);
            this.cursorText.setTextAnchor(TextAnchor.TOP_LEFT);
            this.cursorText.setFont(FontAdjust.fontSizes.getChartFont(2));
            this.cursorText.setOutlineVisible(true);
            this.cursorText.setOutlinePaint(Color.CYAN);
            this.cursorText.setBackgroundPaint(Color.CYAN);
            xyplot.addAnnotation(this.cursorText);
        }
    }

    public void refresh(double periodeTime, double[] data) {
        if (data == null) {
            return;
        }
        this.fftQueue.clear();
        this.noTime = false;
        if (periodeTime == 0.0) {
            periodeTime = data.length;
            this.noTime = true;
        }
        try {
            this.fftQueue.put(new FFTQueueEntry(periodeTime, data));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public FFTPanel getPanel() {
        return this.fftPanel;
    }

    @Override
    public void chartMouseClicked(ChartMouseEvent me) {
        if (me.getTrigger().getButton() == 1) {
            this.cursorOn = !this.cursorOn;
            this.updateCursor();
        }
    }

    @Override
    public void chartMouseMoved(ChartMouseEvent me) {
        Point2D p = this.fftPanel.translateScreenToJava2D(new Point(0, 0));
        double x = p.getX() + me.getTrigger().getPoint().getX();
        double y = p.getY() + me.getTrigger().getPoint().getY();
        p = new Point((int)x, (int)y);
        Rectangle2D plotArea = this.fftPanel.getScreenDataArea();
        XYPlot plot = (XYPlot)this.freeChart.getPlot();
        this.cursorPosition = plot.getDomainAxis().java2DToValue(p.getX(), plotArea, plot.getDomainAxisEdge());
        this.updateCursor();
    }

    private BufferedImage generateImage(int w, int h) {
        BufferedImage image = new BufferedImage(w, h, 1);
        this.freeChart.setTitle(this.channel);
        if (Support.chartFontColor != null) {
            this.freeChart.getTitle().setPaint(Support.chartFontColor);
        }
        if (Support.chartHeaderColor != null) {
            this.freeChart.getTitle().setPaint(Support.chartHeaderColor);
        }
        if (this.cursorLine != null) {
            this.freeChart.getXYPlot().removeAnnotation(this.cursorLine);
            this.freeChart.getXYPlot().removeAnnotation(this.cursorText);
        }
        this.freeChart.draw(image.createGraphics(), new Rectangle(w, h));
        this.freeChart.setTitle("");
        return image;
    }

    public void copyChart(int w, int h) {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new Support.TransferableImage(this.generateImage(w, h)), null);
        }
        catch (Exception exception) {}
    }

    public void saveChart(String fname, int w, int h) {
        try {
            File f = Support.fileWithExtension(fname, Support.getDataPath(), ".png");
            ImageIO.write((RenderedImage)this.generateImage(w, h), "png", f);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public void saveChart() {
        ChartSaveResolutionPanel savePanel = new ChartSaveResolutionPanel();
        FontAdjust.FontFileChooser fc = new FontAdjust.FontFileChooser();
        try {
            fc.setCurrentDirectory(new File(Support.getDataPath()));
        }
        catch (Exception exception) {
            System.out.println("Failed to set director: " + Support.getDataPath());
        }
        fc.setFileFilter(new FileNameExtensionFilter("PNG", "png"));
        fc.setAcceptAllFileFilterUsed(false);
        fc.setAccessory(savePanel.getPanel());
        while (true) {
            int option = 0;
            if (fc.showDialog(null, "Save chart") != 0) break;
            File f = Support.fileWithExtension(fc.getSelectedFile().getAbsolutePath(), null, ".png");
            if (!savePanel.isValid()) {
                option = 1;
            }
            if (option == 0 && f.exists() && (option = JOptionPane.showConfirmDialog(null, "File exists, overwrite?", "File exists", 1)) == 2) {
                return;
            }
            if (option != 0) continue;
            Support.setDataPath(fc.getCurrentDirectory().getPath());
            Dimension dim = savePanel.getSize();
            try {
                ImageIO.write((RenderedImage)this.generateImage(dim.width, dim.height), "png", f);
                return;
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    private class AddSeriesRunnable
    implements Runnable {
        double[][] fftData;
        List<Peak> peaks;

        public AddSeriesRunnable(List<Peak> peaks, double[][] fftData) {
            this.fftData = fftData;
            this.peaks = peaks;
        }

        @Override
        public void run() {
            FFTChart.this.setXScale();
            FFTChart.this.dataset.addSeries((Comparable)((Object)"Amplitude"), this.fftData);
            XYPlot xyplot = FFTChart.this.freeChart.getXYPlot();
            xyplot.clearAnnotations();
            FFTChart.this.updateCursor();
            double lowerLimit = FFTChart.this.lastMinValue + (FFTChart.this.lastMaxValue - FFTChart.this.lastMinValue) * 0.1;
            for (Peak p : this.peaks) {
                if (!(p.value > lowerLimit)) continue;
                XYTextAnnotation a = new XYTextAnnotation(String.valueOf(StringUtil.formatDoubleEE(p.freq, false, 3)) + " " + StringUtil.formatDoubleEE(p.value, false, 3), p.freq, p.value);
                a.setTextAnchor(TextAnchor.BOTTOM_CENTER);
                xyplot.addAnnotation(a);
            }
        }
    }

    public static enum AmpFormat {
        rms,
        rmslog,
        peak,
        peakLog,
        dBV,
        dBu;

    }

    private class FFTAnalyzer
    extends Thread {
        public FFTAnalyzer() {
            this.setDaemon(true);
            this.setName("FFT Analyzer");
        }

        @Override
        public void run() {
            FFTQueueEntry pack = new FFTQueueEntry();
            while (true) {
                try {
                    pack = (FFTQueueEntry)FFTChart.this.fftQueue.take();
                }
                catch (InterruptedException interruptedException) {}
                if (pack.done) {
                    return;
                }
                long startTime = System.currentTimeMillis();
                int n = FFT.pointsPower2(pack.data.length);
                if (n > maxPoints) {
                    n = maxPoints;
                }
                double[] data = FFT.interpolate(n, pack.data);
                switch (FFTChart.this.windowFunction) {
                    case Hamming: {
                        int i = 0;
                        while (i < n) {
                            int n2 = i;
                            data[n2] = data[n2] * ((0.53836 - 0.46164 * Math.cos(Math.PI * 2 * (double)i / (double)(n - 1))) * 1.8533457479816);
                            ++i;
                        }
                        break;
                    }
                    case Hanning: {
                        int i = 0;
                        while (i < n) {
                            int n3 = i;
                            data[n3] = data[n3] * ((0.5 - 0.5 * Math.cos(Math.PI * 2 * (double)i / (double)(n - 1))) * 2.0);
                            ++i;
                        }
                        break;
                    }
                    case Blackman: {
                        int i = 0;
                        while (i < n) {
                            int n4 = i;
                            data[n4] = data[n4] * ((0.42 - 0.5 * Math.cos(Math.PI * 2 * (double)i / (double)(n - 1)) + 0.08 * Math.cos(Math.PI * 4 * (double)i / (double)(n - 1))) * 2.380976190714277);
                            ++i;
                        }
                        break;
                    }
                    case FlatTop: {
                        int i = 0;
                        while (i < n) {
                            int n5 = i;
                            data[n5] = data[n5] * ((0.21557895 - 0.41663158 * Math.cos(Math.PI * 2 * (double)i / (double)(n - 1)) + 0.277263158 * Math.cos(Math.PI * 4 * (double)i / (double)(n - 1)) - 0.083578947 * Math.cos(Math.PI * 4 * (double)i / (double)(n - 1)) + 0.006947368 * Math.cos(Math.PI * 4 * (double)i / (double)(n - 1))) * 4.638718296158128);
                            ++i;
                        }
                        break;
                    }
                }
                double[][] fftData = null;
                Complex[] fft = FFT.fft(data);
                double[] d = FFT.magnitude(fft);
                fftData = new double[2][d.length];
                int cnt = 0;
                double mf = FFTChart.this.minFreq;
                if (FFTChart.this.isLogFreq() && mf == 0.0) {
                    mf = 1.0E-6;
                }
                int i = 0;
                while (i < d.length) {
                    double f = (double)i / pack.periode * FFTChart.this.getFreqScale();
                    if (f >= mf && f < FFTChart.this.maxFreq) {
                        fftData[0][cnt] = f;
                        switch (FFTChart.this.ampFormat) {
                            case dBu: {
                                fftData[1][cnt] = 20.0 * Math.log10(d[i] / 0.774597);
                                break;
                            }
                            case dBV: {
                                fftData[1][cnt] = 20.0 * Math.log10(d[i]);
                                break;
                            }
                            case rms: {
                                fftData[1][cnt] = d[i];
                                break;
                            }
                            case rmslog: {
                                fftData[1][cnt] = d[i];
                                break;
                            }
                            case peak: {
                                fftData[1][cnt] = d[i] * Math.sqrt(2.0);
                                break;
                            }
                            case peakLog: {
                                fftData[1][cnt] = d[i] * Math.sqrt(2.0);
                            }
                        }
                        ++cnt;
                    }
                    ++i;
                }
                double[][] fftData1 = new double[2][cnt];
                FFTChart.this.lastMinValue = Double.MAX_VALUE;
                FFTChart.this.lastMaxValue = -1.7976931348623157E308;
                int i2 = 0;
                while (i2 < cnt) {
                    fftData1[0][i2] = fftData[0][i2];
                    fftData1[1][i2] = fftData[1][i2];
                    if (fftData1[1][i2] < FFTChart.this.lastMinValue) {
                        FFTChart.this.lastMinValue = fftData1[1][i2];
                    }
                    if (fftData1[1][i2] > FFTChart.this.lastMaxValue) {
                        FFTChart.this.lastMaxValue = fftData1[1][i2];
                    }
                    ++n;
                    ++i2;
                }
                ArrayList<Peak> peaks = new ArrayList<Peak>();
                if (FFTChart.this.markers) {
                    int i3 = 1;
                    while (i3 < cnt - 1) {
                        double v = fftData1[1][i3];
                        if (v > fftData1[1][i3 - 1] && v > fftData1[1][i3 + 1]) {
                            peaks.add(new Peak(fftData1[0][i3], fftData1[1][i3]));
                            peaks.sort(null);
                            if (peaks.size() > 3) {
                                peaks.remove(0);
                            }
                        }
                        ++i3;
                    }
                }
                if (cnt > 0) {
                    FFTChart.this.lastMinFreq = fftData1[0][0];
                    FFTChart.this.lastMaxFreq = fftData1[0][cnt - 1];
                }
                long dt = System.currentTimeMillis() - startTime;
                while (dt > 1200L && maxPoints > 1024) {
                    maxPoints = maxPoints / 2;
                    dt /= 2L;
                }
                SwingUtilities.invokeLater(new AddSeriesRunnable(peaks, fftData1));
            }
        }
    }

    public class FFTPanel
    extends ChartPanel {
        public FFTPanel(JFreeChart chart) {
            super(chart);
            this.setPopupMenu(null);
            this.setInheritsPopupMenu(true);
            this.setDomainZoomable(false);
            this.setRangeZoomable(false);
            this.setMouseZoomable(false);
            this.setDisplayToolTips(true);
        }
    }

    private class FFTQueueEntry {
        double[] data;
        double periode;
        boolean done = false;

        FFTQueueEntry(double periode, double[] data) {
            this.periode = periode;
            this.data = data;
            this.done = false;
        }

        FFTQueueEntry() {
            this.periode = 0.0;
            this.data = null;
            this.done = true;
        }
    }

    public static enum FreqFormat {
        linHz,
        logHz,
        linMin,
        logMin,
        linHour,
        logHour,
        linDay,
        logDay;

    }

    private class Peak
    implements Comparable<Peak> {
        double freq = 0.0;
        double value = 0.0;

        public Peak(double freq, double value) {
            this.freq = freq;
            this.value = value;
        }

        @Override
        public int compareTo(Peak arg0) {
            if (arg0.value > this.value) {
                return -1;
            }
            if (arg0.value < this.value) {
                return 1;
            }
            return 0;
        }
    }

    public static enum WindowFunction {
        None,
        Hanning,
        Hamming,
        Blackman,
        FlatTop;

    }
}

