/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.comm.CommInterface;
import dk.hkj.comm.GpibInterface;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.devices.MenuModeSelection;
import dk.hkj.devices.SetupFormats;
import dk.hkj.main.CommandProcessor;
import dk.hkj.main.HelpLoader;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.Main;
import dk.hkj.main.PopupBase;
import dk.hkj.main.PopupModeSelection;
import dk.hkj.main.PopupNotes;
import dk.hkj.main.PopupSetupSelection;
import dk.hkj.main.SCPICommand;
import dk.hkj.main.Support;
import dk.hkj.main.ValueFormat;
import dk.hkj.script.Script;
import dk.hkj.util.StringUtil;
import dk.hkj.vars.Var;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class DeviceInterface {
    protected ManageDeviceDefinitions.DeviceDefinition def;
    protected String currentModes = "";
    protected Set<String> currentLocalModes = new HashSet<String>();
    public InterfaceThreads.DeviceThread dt;
    protected List<String> commandList = null;
    protected List<ValueFormat> valueFormats = new ArrayList<ValueFormat>();
    public List<String> valueNames = null;
    protected SCPICommand askModeCommand = null;
    protected SCPICommand askValueCommand = null;
    protected SCPICommand outputOffCommand = null;
    protected String modeFromValue = null;
    protected String lastModeAnswer = null;
    protected long noTimeoutBefore = 0L;
    private Script script = null;
    Map<String, String> commCache = new HashMap<String, String>();
    String handle = null;
    private String serialNumber = "";
    private String softwareVersion = "";
    private Timer initValueListTimer = null;
    private String baudrate = null;
    private PopupSetupSelection popupSetupSelection = null;
    private PopupModeSelection popupModeSelection = null;
    protected boolean debugOtherComm = false;
    protected boolean debugCommHex = false;
    private List<String> otherMenu = null;

    public void cacheClear() {
        this.commCache.clear();
    }

    public String doCommand(String cmd) {
        this.cacheClear();
        SCPICommand scpiCmd = new SCPICommand(this, cmd);
        scpiCmd.setDebug(this.debugOtherComm);
        return scpiCmd.writeRead();
    }

    public void doCommand(String cmd, boolean saveInCommandList) {
        this.cacheClear();
        SCPICommand scpiCmd = new SCPICommand(this, cmd);
        scpiCmd.setDebug(this.debugOtherComm);
        scpiCmd.setSaveInCommandList(saveInCommandList);
        scpiCmd.writeRead();
    }

    public SCPICommand getCommand(String cmd) {
        SCPICommand scpiCmd = new SCPICommand(this, cmd);
        scpiCmd.setDebug(this.debugOtherComm);
        return scpiCmd;
    }

    public SCPICommand getCommand(String cmd, String readMath, String readFormat) {
        SCPICommand scpiCmd = new SCPICommand(this, cmd, readMath, readFormat);
        scpiCmd.setDebug(this.debugOtherComm);
        return scpiCmd;
    }

    protected DeviceInterface(ManageDeviceDefinitions.DeviceDefinition def) {
        this.def = def;
        if (InterfaceThreads.debugAll) {
            this.debugOtherComm = true;
        }
    }

    protected DeviceInterface() {
        if (InterfaceThreads.debugAll) {
            this.debugOtherComm = true;
        }
    }

    protected String overflowValueString(boolean positive) {
        if (Support.systemSettings.overflowHandling == Support.OverflowHandling.zero) {
            return "0";
        }
        if (Support.systemSettings.overflowHandling == Support.OverflowHandling.highValue) {
            return positive ? Double.toString(Support.systemSettings.overFlowValue) : Double.toString(-Support.systemSettings.overFlowValue);
        }
        if (Support.systemSettings.overflowHandling == Support.OverflowHandling.infinite) {
            return positive ? "\u221e" : "-\u221e";
        }
        return "0";
    }

    public static double overflowValueDouble(boolean positive) {
        if (Support.systemSettings.overflowHandling == Support.OverflowHandling.zero) {
            return 0.0;
        }
        if (Support.systemSettings.overflowHandling == Support.OverflowHandling.highValue) {
            return positive ? Support.systemSettings.overFlowValue : -Support.systemSettings.overFlowValue;
        }
        if (Support.systemSettings.overflowHandling == Support.OverflowHandling.infinite) {
            return positive ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        }
        return 0.0;
    }

    public void setDebug(String item) {
        boolean on = true;
        if (item.contains("-")) {
            on = false;
        }
        if ((item = item.replace("-", "").replace("+", "")).equalsIgnoreCase("modeComm")) {
            this.askModeCommand.setDebug(on);
        } else if (item.equalsIgnoreCase("valueComm")) {
            this.askValueCommand.setDebug(on);
        } else if (item.equalsIgnoreCase("otherComm")) {
            this.debugOtherComm = on;
            this.outputOffCommand.setDebug(on);
        } else if (item.equalsIgnoreCase("commHex")) {
            this.debugCommHex = on;
        }
    }

    public Script getScript() {
        if (this.script == null) {
            this.script = new Script();
            this.script.addLocalVar("handle", Var.createValue(this.getHandleName()));
            if (this.dt != null && this.dt.cPort != null) {
                this.script.addLocalVar("portType", Var.createValue(this.dt.cPort.getPortType().name()));
                this.script.addLocalVar("portAddress", Var.createValue(this.dt.cPort.getAddress()));
            }
        }
        return this.script;
    }

    public String getDebug() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(this.askModeCommand.isDebug() ? (char)'+' : '-') + "modeComm ");
        sb.append(String.valueOf(this.askValueCommand.isDebug() ? (char)'+' : '-') + "valueComm ");
        sb.append(String.valueOf(this.debugOtherComm ? (char)'+' : '-') + "otherComm ");
        sb.append(String.valueOf(this.debugCommHex ? (char)'+' : '-') + "commHex ");
        return sb.toString();
    }

    public void debugLog(String tag) {
        StringBuilder sb = new StringBuilder();
        if (this.handle != null) {
            sb.append(this.handle);
        } else if (this.dt != null && this.dt.cPort != null) {
            sb.append(this.dt.cPort.getDeviceName());
        }
        sb.append(": ");
        sb.append(tag);
        InterfaceThreads.logDebug(sb.toString());
    }

    public void outputOff() {
        if (this.outputOffCommand == null) {
            return;
        }
        this.outputOffCommand.write();
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.popupSetupSelection != null) {
                this.popupSetupSelection.syncAllOff();
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (DeviceInterface.this.popupSetupSelection != null) {
                        DeviceInterface.this.popupSetupSelection.syncAllOff();
                    }
                }
            });
        }
    }

    public String getSerialNumber() {
        return this.serialNumber.trim();
    }

    public String getSoftwareVersion() {
        return this.softwareVersion.trim();
    }

    public void setSoftwareVersion(String version) {
        this.softwareVersion = version;
    }

    public void setSoftwareVersionFromIDN(String answer) {
        String[] s = answer.split(",");
        if (s.length >= 4 && s[3].length() >= 2) {
            this.setSoftwareVersion(s[3]);
        }
    }

    protected void setSerialNumberFromIDN(String answer) {
        String[] s = answer.split(",");
        if (s.length >= 4 && s[2].length() >= 3) {
            this.setSerialNumber(s[2]);
        }
    }

    protected void setSerialNumber(String serialNumber) {
        while (serialNumber.length() > 0 && serialNumber.charAt(0) == '0') {
            serialNumber = serialNumber.substring(1);
        }
        this.serialNumber = serialNumber;
    }

    public void threadStarted(InterfaceThreads.DeviceThread deviceThread) {
        this.dt = deviceThread;
        if (this.def == null) {
            this.def = Support.manageDeviceDefinitions.findDeviceDefintionFromId(this.getDeviceId());
        }
        this.doCommand(this.def.getItem("#initCmd"));
        this.initDef();
    }

    public void setDef(ManageDeviceDefinitions.DeviceDefinition def) {
        this.def = def;
        def.parse();
    }

    protected String filterCommandMode(String mode, String str) {
        int j;
        if (str == null) {
            return "";
        }
        if (mode == null) {
            return str;
        }
        HashSet<String> modeSet = new HashSet<String>();
        String[] stringArray = mode.split("[ ,;]+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s != null && (s = s.trim()).length() > 0) {
                modeSet.add(s);
            }
            ++n2;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        boolean include = true;
        String strLower = str.toLowerCase();
        block1: while ((j = strLower.indexOf("[mode:", i)) >= 0) {
            if (include) {
                sb.append(str.substring(i, j));
            }
            i = strLower.indexOf(93, j);
            String modes = str.substring(j + 6, i).trim();
            ++i;
            include = modes.isEmpty();
            if (include) continue;
            String[] stringArray2 = modes.split("[ ,;]+");
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String s = stringArray2[n4];
                if (modeSet.contains(s)) {
                    include = true;
                    continue block1;
                }
                ++n4;
            }
        }
        if (include) {
            sb.append(str.substring(i));
        }
        return sb.toString();
    }

    protected void setupAskValues(String mode) {
        String s = this.filterCommandMode(mode, this.def.getItem("#askValues"));
        if (s.startsWith(";")) {
            s = s.substring(1);
        }
        if (this.askValueCommand == null) {
            this.askValueCommand = new SCPICommand(this, s);
            this.askValueCommand.setProcessor(this.def.getItem("#askValuesProcessor"));
        } else {
            this.askValueCommand.setCmd(s);
        }
        this.askValueCommand.setReadFormat(this.filterCommandMode(mode, this.def.getItem("#askValuesReadFormat")));
        this.askValueCommand.setMathFormat(this.filterCommandMode(mode, this.def.getItem("#askValuesMathFormat")));
        this.modeFromValue = this.def.getItem("#modeFromValue");
    }

    protected void initDef() {
        if (this.def != null) {
            this.def.parse();
            this.setupAskValues("");
            this.askModeCommand = new SCPICommand(this, this.def.getItem("#askMode"));
            this.askModeCommand.setReadFormat(this.def.getItem("#askModeReadFormat"));
            this.askModeCommand.setMathFormat(this.def.getItem("#askModeMathFormat"));
            this.askModeCommand.setProcessor(this.def.getItem("#askModeProcessor"));
            this.outputOffCommand = new SCPICommand(this, this.def.getItem("#outputOff"));
        } else if (this.def == null) {
            System.out.println("Missing DEF for " + this.getDeviceName());
        }
    }

    public String getDeviceId() {
        return this.def != null ? this.def.getIdName() : "";
    }

    private int calcIdFromSerial() {
        long n = 0L;
        int digits = 0;
        int i = 0;
        while (i < this.serialNumber.length()) {
            char c = this.serialNumber.charAt(i);
            if (c >= '0' && c <= '9') {
                n = n * 10L + (long)(c - 48);
                ++digits;
            }
            ++i;
        }
        return digits <= 2 ? -1 : (int)n % 100;
    }

    public int getId() {
        int i = this.calcIdFromSerial();
        if (i < 0 && this.dt != null && this.dt.cPort != null) {
            i = this.dt.cPort.getSerialId();
        }
        return i % 100;
    }

    public String getIdn() {
        return this.doCommand("*IDN?");
    }

    public final String getHandleName() {
        if (this.handle == null && this.def != null) {
            return this.def.getHandleName();
        }
        return this.handle;
    }

    public void setHandleName(String handle) {
        if (handle != null && handle.length() > 0) {
            this.handle = Support.cleanString(handle);
        } else {
            System.out.println("Request for invalid handle " + this.getClass().getName());
        }
    }

    public void close() {
        if (this.def == null) {
            return;
        }
        this.doCommand(this.def.getItem("#finalCmd"));
    }

    public List<String> supportedCommands() {
        if (this.commandList == null) {
            String name = this.def.getItem("#help");
            this.commandList = HelpLoader.getHelpFile(name != null ? name : this.getDeviceName());
        }
        return this.commandList;
    }

    protected boolean mayModifyColumns(String cmd) {
        return this.def.mayModifyColumns(cmd);
    }

    public void checkModifyColumns(String cmd) {
        if (this.mayModifyColumns(cmd)) {
            this.valueNames = null;
        }
    }

    protected void getValuesEdit(List<Double> list) {
    }

    public synchronized List<Double> getValuesFromDevices() {
        this.commCache.clear();
        if (this.askValueCommand.getCmd().isEmpty()) {
            if (this.getDeviceId().equals("Unknown device")) {
                return new ArrayList<Double>();
            }
            InterfaceThreads.log(";; Cannot read from device " + this.getHandleName() + ", #askValues is not defined");
        }
        List<Double> list = this.askValueCommand.readNumbers();
        if (this.modeFromValue != null && !this.modeFromValue.isEmpty()) {
            this.getScript().addLocalVar(Var.createValue("value", this.askValueCommand.getLastAnswer()));
            String s = this.getScript().expression(this.modeFromValue).asString().trim();
            if (!this.lastModeAnswer.equals(s)) {
                this.processModeString(s);
                this.requestInitColumns();
            }
        }
        return list;
    }

    public void resetTime() {
    }

    public synchronized void setupVariables(List<Double> list) {
        if (list == null || this.valueNames == null) {
            return;
        }
        int i = 0;
        while (i < Math.min(list.size(), this.valueNames.size())) {
            String name = String.valueOf(this.getHandleName()) + "." + this.valueNames.get(i);
            Var.gl.getCreate(name).set(list.get(i));
            ++i;
        }
    }

    public String getValuesString(List<Double> list) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < Math.min(list.size(), this.valueNames.size())) {
            ValueFormat vf = this.getValueFormat(this.valueNames.get(i));
            sb.append(String.valueOf(this.getHandleName()) + "." + vf.name + "=" + vf.format.formatDisplay(list.get(i)) + " " + vf.unit);
            sb.append("  ");
            ++i;
        }
        return sb.toString();
    }

    private void requestInitColumnsSync() {
        if (this.initValueListTimer == null) {
            this.initValueListTimer = new Timer(100, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    DeviceInterface.this.valueNames = null;
                    DeviceInterface.this.initColumns();
                    Main.changeDevicesOrTable(Support.UpdateType.ColumnsSource);
                    DeviceInterface.this.initValueListTimer.stop();
                    DeviceInterface.this.initValueListTimer = null;
                }
            });
            this.initValueListTimer.setRepeats(false);
            this.initValueListTimer.start();
        }
    }

    public void requestInitColumns() {
        if (InterfaceThreads.isLogging() || InterfaceThreads.inInitialization()) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.requestInitColumnsSync();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DeviceInterface.this.requestInitColumnsSync();
                }
            });
        }
    }

    public void syncPopup() {
        PopupSetupSelection m = this.getSetupPopupInstance();
        if (m != null && m.isVisible()) {
            m.initialSync();
        }
    }

    public void initColumns() {
        this.commCache.clear();
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.popupSetupSelection != null) {
                this.popupSetupSelection.syncModeChange();
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (DeviceInterface.this.popupSetupSelection != null) {
                        DeviceInterface.this.popupSetupSelection.syncModeChange();
                    }
                }
            });
        }
    }

    public String getValueUnit(String name) {
        ValueFormat vf = this.getValueFormat(name);
        return vf == null ? "" : vf.unit;
    }

    public ValueFormat getExistingValueFormat(String name) {
        int i = name.indexOf(46);
        if (i > 0) {
            name = name.substring(i + 1);
        }
        for (ValueFormat vf : this.valueFormats) {
            if (!vf.name.equalsIgnoreCase(name)) continue;
            return vf;
        }
        for (ValueFormat vf : this.def.getValueFormats()) {
            if (!vf.name.equalsIgnoreCase(name)) continue;
            return vf;
        }
        return null;
    }

    public ValueFormat getValueFormat(String name) {
        int i = name.indexOf(46);
        if (i > 0) {
            name = name.substring(i + 1);
        }
        for (ValueFormat vf : this.valueFormats) {
            if (!vf.name.equalsIgnoreCase(name)) continue;
            return vf;
        }
        for (ValueFormat vf : this.def.getValueFormats()) {
            if (!vf.name.equalsIgnoreCase(name)) continue;
            return vf;
        }
        return new ValueFormat(name, "", ValueFormat.formatD2);
    }

    public String getDeviceName() {
        return "";
    }

    public List<String> getValueNameList() {
        if (this.valueNames == null) {
            this.initColumns();
        }
        return this.valueNames;
    }

    public String getValueName(int i) {
        if (this.valueNames == null) {
            this.initColumns();
        }
        if (i >= this.valueNames.size()) {
            return "";
        }
        return this.valueNames.get(i);
    }

    public List<String> getValueNames(String mode) {
        return this.def.getValueNames(mode);
    }

    public void setBaudrate(String baudrate) {
        this.baudrate = baudrate;
    }

    public void setBaudrate(int baudrate) {
        this.baudrate = Integer.toString(baudrate);
    }

    public void setBaudrate() {
        if (this.dt != null) {
            this.setBaudrate(this.dt.cPort);
        }
    }

    public void setBaudrate(CommInterface ci) {
        if (ci == null || this.def == null) {
            return;
        }
        if (this.def.getPortType() == ManageDeviceDefinitions.PortType.SerialFixedBaud) {
            String baud = this.def.getItem("#baudrate");
            ci.setParams(baud);
        } else if (this.def.getPortType() == ManageDeviceDefinitions.PortType.Serial) {
            if (this.baudrate == null || this.baudrate.length() == 0) {
                this.baudrate = this.def.getItem("#baudrate");
            }
            ci.setParams(this.baudrate);
        }
    }

    public String finalInit() {
        if (this.script != null) {
            this.script.addLocalVar("handle", Var.createValue(this.getHandleName()));
            this.script.addLocalVar("portType", Var.createValue(this.dt.cPort.getPortType().name()));
            this.script.addLocalVar("portAddress", Var.createValue(this.dt.cPort.getAddress()));
        }
        return "";
    }

    public Map<String, String> getIFaces() {
        if (this.def != null) {
            return this.def.getIFaces();
        }
        return new HashMap<String, String>();
    }

    public String getIFace(String name) {
        if (this.def != null) {
            return this.def.getIFace(name);
        }
        return null;
    }

    public Var executeIFace(String name, int channel, double param) {
        String s = Double.toString(param);
        if (s.endsWith(".0")) {
            s = s.substring(0, s.length() - 2);
        }
        return this.executeIFace(name, channel, s);
    }

    public synchronized Var executeIFace(String name, int channel, String param) {
        try {
            Script script = new Script();
            StringBuilder sb = new StringBuilder();
            sb.append(name);
            sb.append("(\"");
            sb.append(this.dt.getHandleName());
            if (channel > 1) {
                sb.append(":");
                sb.append(channel);
            }
            sb.append("\"");
            if (param != null && !param.isEmpty()) {
                sb.append(",");
                if (param.matches("[0-9.]+")) {
                    sb.append(param);
                } else {
                    sb.append("\"");
                    sb.append(param);
                    sb.append("\"");
                }
            }
            sb.append(")");
            Var v = script.expression(sb.toString());
            return v;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    public String[] getIFaceTypes() {
        if (this.def == null) {
            return null;
        }
        String deviceTypes = this.def.getItem("#interfaceType");
        if (deviceTypes == null) {
            return null;
        }
        return deviceTypes.split("[,; ]+");
    }

    public boolean hasIFaceType(String type) {
        if (this.def == null) {
            return false;
        }
        if (type.equalsIgnoreCase("*")) {
            return true;
        }
        String[] ifs = this.getIFaceTypes();
        if (ifs == null) {
            return false;
        }
        String[] stringArray = ifs;
        int n = ifs.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equalsIgnoreCase(type)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int getIFaceChannels() {
        String[] deviceTypes = this.getIFaceTypes();
        if (deviceTypes == null) {
            return 1;
        }
        int max = 1;
        String[] stringArray = deviceTypes;
        int n = deviceTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            try {
                int i = t.indexOf(58);
                if (i > 0) {
                    max = Math.max(max, Integer.parseInt(t.substring(i + 1)));
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
        return max;
    }

    public CommInterface getCommInterface(CommInterface ci) {
        if (this.def != null) {
            String charset;
            String eol = this.def.getItem("#eol");
            if (eol != null) {
                ci.setEOL(StringUtil.decodeEscape(eol.trim()));
            }
            if ((charset = this.def.getItem("#charset")) != null && !charset.isEmpty()) {
                ci.setCharset(charset);
            }
            if (ci instanceof GpibInterface) {
                GpibInterface gi = (GpibInterface)ci;
                String reol = this.def.getItem("#gpibReadEol");
                if (reol != null) {
                    gi.setReadEol(reol);
                }
                gi.setTimeout(this.def.getReadingDelay());
                gi.setWriteDelay(this.def.getItemInt("#gpibWriteDelay"));
                gi.setWriteReadDelay(this.def.getItemInt("#gpibWriteReadDelay"));
                gi.setReadCount(this.def.getItemInt("#gpibReadCount"));
            }
        }
        return ci;
    }

    public void closePopups() {
        if (this.popupSetupSelection != null) {
            this.popupSetupSelection.setVisible(false);
            this.popupSetupSelection.dispose();
            this.popupSetupSelection = null;
        }
        if (this.popupModeSelection != null) {
            this.popupModeSelection.setVisible(false);
            this.popupModeSelection.dispose();
            this.popupModeSelection = null;
        }
    }

    public void setPopupsOnTop(boolean onTop) {
        if (this.popupSetupSelection != null) {
            this.popupSetupSelection.setOnTop(onTop);
        }
        if (this.popupModeSelection != null) {
            this.popupModeSelection.setOnTop(onTop);
        }
    }

    public List<String> generateScriptPopup() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.popupModeSelection != null) {
            list.addAll(this.popupModeSelection.generateScript());
        }
        if (this.popupSetupSelection != null) {
            list.addAll(this.popupSetupSelection.generateScript());
        }
        return list;
    }

    public void alignGridAll(int pixels) {
        if (this.popupModeSelection != null) {
            this.popupModeSelection.alignGrid(pixels);
        }
        if (this.popupSetupSelection != null) {
            this.popupSetupSelection.alignGrid(pixels);
        }
    }

    public PopupModeSelection getModePopupInstance() {
        return this.popupModeSelection;
    }

    public PopupSetupSelection getSetupPopupInstance() {
        return this.popupSetupSelection;
    }

    public void focusPopup() {
        if (this.popupSetupSelection != null) {
            this.popupSetupSelection.toFront();
        }
        if (this.popupModeSelection != null) {
            this.popupModeSelection.toFront();
        }
    }

    public boolean canScreenDump() {
        return false;
    }

    public BufferedImage readScreenDump() {
        return null;
    }

    public void setupSetup(String setup) {
    }

    public List<SetupFormats> getSetupPopupList() {
        return this.def == null ? null : this.def.getSetupPopupList(this);
    }

    public boolean haveSetupPopup() {
        return this.def == null ? false : this.def.haveSetupPopup();
    }

    public void setSetupFieldValue(Class controlType, String pageName, String name, String value) {
        if (this.popupSetupSelection != null && this.popupSetupSelection.isVisible()) {
            this.popupSetupSelection.setSetupFieldValue(controlType, pageName, name, value);
        }
    }

    public PopupBase showSetupPopup(JComponent location) {
        if (this.haveSetupPopup()) {
            this.popupSetupSelection = new PopupSetupSelection(this, location);
            return this.popupSetupSelection;
        }
        return null;
    }

    public void setupMode(String mode, boolean on) {
        if (!InterfaceThreads.isLogging()) {
            this.noTimeoutBefore = (long)this.def.getModeChangeDelay() + System.currentTimeMillis();
            ManageDeviceDefinitions.FunctionMode fm = this.def.getFunctionMode(mode);
            if (fm instanceof ManageDeviceDefinitions.FunctionModeCheck) {
                ManageDeviceDefinitions.FunctionModeCheck fmc = (ManageDeviceDefinitions.FunctionModeCheck)fm;
                if (fmc.localMode) {
                    if (on) {
                        this.currentLocalModes.add(mode);
                    } else {
                        this.currentLocalModes.remove(mode);
                    }
                }
                String s = on ? fmc.cmdsToSetup : fmc.cmdsToDisable;
                if (!(s = s.replaceAll("(?i)\\[localMode]", "")).isEmpty()) {
                    this.doCommand(s, true);
                }
            } else if (fm.cmdsToSetup != null && !fm.cmdsToSetup.isEmpty()) {
                this.doCommand(fm.cmdsToSetup, true);
            }
            Support.commandList.add("#InitColumns");
            this.valueNames = null;
            this.initColumns();
            Main.changeDevicesOrTable(Support.UpdateType.ColumnsSource);
        }
    }

    public String processModeString(String deviceModes) {
        if (deviceModes != null && deviceModes.length() > 0) {
            this.lastModeAnswer = deviceModes;
            StringBuilder modes = new StringBuilder();
            String[] stringArray = deviceModes.split("[ ,;]+");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                s = this.def.getFunctionModeFromDeviceMode((String)Support.unQuote((String)s.trim()).trim()).name;
                if (modes.length() > 0) {
                    modes.append(',');
                }
                modes.append(s);
                ++n2;
            }
            for (String s : this.currentLocalModes) {
                if (modes.length() > 0) {
                    modes.append(',');
                }
                modes.append(s);
            }
            this.currentModes = modes.toString();
            this.setupAskValues(this.currentModes);
            return this.currentModes;
        }
        return "";
    }

    public String getMode() {
        return "";
    }

    public String getCurrentModes() {
        return this.currentModes;
    }

    public List<String> getModesPopupList() {
        return this.def == null ? null : this.def.getFunctionModes();
    }

    public boolean modeActive(String mode) {
        String[] stringArray = this.currentModes.split("[;,]");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equals(mode)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean haveModesPopup() {
        return this.def == null ? false : this.def.haveModes();
    }

    public PopupBase showModesPopup(JComponent location) {
        if (this.haveModesPopup()) {
            this.popupModeSelection = new PopupModeSelection(this, location, this.def);
            return this.popupModeSelection;
        }
        return null;
    }

    public void showModesMenu(JComponent location) {
        if (this.haveModesPopup()) {
            MenuModeSelection m = new MenuModeSelection(this, this.def);
            m.showMenu(location);
        }
    }

    private void otherListItems() {
        if (this.otherMenu != null) {
            return;
        }
        String pgm = this.def.getItem("#otherList");
        if (pgm == null || pgm.trim().length() == 0) {
            return;
        }
        Script script = new Script(this.getScript());
        Var v = Var.createArray();
        script.getLocalVars().addVar("menuItem", v);
        script.execute(pgm);
        this.otherMenu = new ArrayList<String>();
        int i = 0;
        while (i < v.getSize()) {
            this.otherMenu.add(v.get(i).asString());
            ++i;
        }
    }

    public boolean otherVisible() {
        if (InterfaceThreads.isLogging()) {
            return false;
        }
        this.otherListItems();
        return this.canScreenDump() || this.otherMenu != null && this.otherMenu.size() > 0;
    }

    public void otherPreparePopup(JPopupMenu pm) {
        if (InterfaceThreads.isLogging()) {
            return;
        }
        JMenuItem mi = null;
        if (this.canScreenDump()) {
            mi = new JMenuItem("Screendump");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DeviceInterface.this.otherActions("ScreenDump");
                }
            });
            pm.add(mi);
        }
        if (this.otherMenu != null) {
            for (final String item : this.otherMenu) {
                int i;
                String ext = item.substring(i = item.lastIndexOf(46));
                if (ext.matches("\\.(jpg|png|bmp)")) {
                    mi = new JMenuItem("Image: " + item.substring(0, i));
                    mi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DeviceInterface.this.otherActions("getImage:" + item);
                        }
                    });
                    pm.add(mi);
                    continue;
                }
                if (ext.matches("(\\.csv)")) {
                    mi = new JMenuItem("Data: " + item.substring(0, i));
                    mi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DeviceInterface.this.otherActions("getData:" + item);
                        }
                    });
                    pm.add(mi);
                    continue;
                }
                if (ext.matches("(\\.xxx)")) {
                    mi = new JMenuItem(item.substring(0, i));
                    mi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DeviceInterface.this.otherActions("doCommand:" + item);
                        }
                    });
                    pm.add(mi);
                    continue;
                }
                mi = new JMenuItem("Text: " + item.substring(0, i));
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DeviceInterface.this.otherActions("getText:" + item);
                    }
                });
                pm.add(mi);
            }
        }
    }

    private void otherActions(final String action) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                DeviceInterface.this.otherActionsBackground(action);
            }
        };
        thread.start();
    }

    private void otherActionsBackground(String action) {
        try {
            if (action.equalsIgnoreCase("ScreenDump")) {
                CommandProcessor.runScript(String.valueOf(this.handle) + ":\n#ScreenDump");
            } else if (action.startsWith("getImage:")) {
                String pgm = this.def.getItem("#otherImage");
                Script script = new Script(this.getScript());
                script.getLocalVars().getCreate("name").set(action.substring(9));
                script.execute(pgm);
                script.getLocalVars().remove("name");
            } else if (action.startsWith("getData:")) {
                String pgm = this.def.getItem("#otherData");
                Script script = new Script(this.getScript());
                script.getLocalVars().getCreate("name").set(action.substring(8));
                script.execute(pgm);
                script.getLocalVars().remove("name");
            } else if (action.startsWith("doCommand")) {
                String pgm = this.def.getItem("#otherFunc");
                Script script = new Script(this.getScript());
                script.getLocalVars().getCreate("name").set(action.substring(10));
                script.execute(pgm);
                script.getLocalVars().remove("name");
            } else if (action.startsWith("getText:")) {
                String pgm = this.def.getItem("#otherText");
                Script script = new Script(this.getScript());
                script.getLocalVars().getCreate("name").set(action.substring(8));
                Var v = script.execute(pgm);
                script.getLocalVars().remove("name");
                if (v != null) {
                    PopupNotes popupNotes = new PopupNotes(this.handle, v.asString());
                    popupNotes.setLocationRelativeTo(Main.main.frame);
                    popupNotes.setVisible(true);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public List<String> generateScriptValueName() {
        ArrayList<String> list = new ArrayList<String>();
        for (ValueFormat vf : this.valueFormats) {
            list.add("#ValueFormat " + this.handle + "." + vf.name + " " + vf.format.toString());
        }
        return list;
    }
}

