/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.color.ColorUtil;
import dk.hkj.comm.VXI11Discovery;
import dk.hkj.database.DataBase;
import dk.hkj.database.Exporter;
import dk.hkj.database.Importer;
import dk.hkj.devices.LoadDeviceConfig;
import dk.hkj.main.AsyncHandler;
import dk.hkj.main.ChartAnnotations;
import dk.hkj.main.ChartScales;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.Main;
import dk.hkj.main.Mathematics;
import dk.hkj.main.PopupAdjustScale;
import dk.hkj.main.PopupAlarm;
import dk.hkj.main.PopupAutoAdjust;
import dk.hkj.main.PopupAutoHold;
import dk.hkj.main.PopupBase;
import dk.hkj.main.PopupBaseFrame;
import dk.hkj.main.PopupCalculator;
import dk.hkj.main.PopupChart;
import dk.hkj.main.PopupChartLayout;
import dk.hkj.main.PopupFFTView;
import dk.hkj.main.PopupGridPanel;
import dk.hkj.main.PopupImage;
import dk.hkj.main.PopupLogEvent;
import dk.hkj.main.PopupLogTrigger;
import dk.hkj.main.PopupMPPT;
import dk.hkj.main.PopupParamAdjuster;
import dk.hkj.main.PopupParamSweeper;
import dk.hkj.main.PopupReadout;
import dk.hkj.main.PopupScriptList;
import dk.hkj.main.PopupShowDevices;
import dk.hkj.main.PopupTestInterface;
import dk.hkj.main.PopupTimer;
import dk.hkj.main.PopupTimerCounter;
import dk.hkj.main.PopupVarDisplay;
import dk.hkj.main.ScriptMenu;
import dk.hkj.main.Support;
import dk.hkj.main.ValueFormat;
import dk.hkj.panels.BasicPanel;
import dk.hkj.script.Functions;
import dk.hkj.script.Script;
import dk.hkj.util.CharacterEscapes;
import dk.hkj.util.FileUtil;
import dk.hkj.util.InputPopup;
import dk.hkj.util.StringUtil;
import dk.hkj.vars.Var;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;

public class CommandProcessor {
    private static BackgroundCommands backgroundCommands = null;
    private static CmdEnvironment backgroundCmdEnvironment = new CmdEnvironment();
    private static AsyncHandler asyncHandler = null;
    private static Set<CmdEnvironment> cmdEnvironments = Collections.synchronizedSet(new HashSet());

    public static void addFunctions() {
        Functions.gf().add(new Functions.Func("runScript"){

            @Override
            public Var execute(Script scriptx, List<Var> params) {
                String script;
                if (params.size() == 0) {
                    1.invalidNumberOfParams(scriptx, "name{, params...}");
                }
                if ((script = CommandProcessor.loadScript(params.get(0).asString())) == null || script.trim().length() == 0) {
                    return Var.createValue(false);
                }
                if (SwingUtilities.isEventDispatchThread()) {
                    if (CommandProcessor.isBackground()) {
                        InterfaceThreads.log(";; A background job is already running, this request is ignored");
                        return Var.createValue(false);
                    }
                    backgroundCmdEnvironment = new CmdEnvironment();
                    if (params.size() > 1) {
                        Var p = Var.createArray();
                        backgroundCmdEnvironment.script.addLocalVar("params", p);
                        int i = 1;
                        while (i < params.size()) {
                            p.addVar(params.get(i).cloneSimple());
                            ++i;
                        }
                    }
                    backgroundCmdEnvironment.logCmds = false;
                    CommandProcessor.backgroundCommands = new BackgroundCommands(backgroundCmdEnvironment, StringUtil.stringToList(script, "\n"));
                } else {
                    CmdEnvironment pgm = new CmdEnvironment();
                    pgm.script = new Script(scriptx);
                    if (params.size() > 1) {
                        Var p = Var.createArray();
                        backgroundCmdEnvironment.script.addLocalVar("params", p);
                        int i = 1;
                        while (i < params.size()) {
                            p.addVar(params.get(i).cloneSimple());
                            ++i;
                        }
                    }
                    pgm.initProgram(StringUtil.stringToList(script, "\n"));
                    pgm.logCmds = false;
                    pgm.run();
                }
                return Var.createValue(true);
            }
        });
        Functions.gf().add(new Functions.Func("runScriptAsync"){

            @Override
            public Var execute(Script scriptx, List<Var> params) {
                String script;
                if (params.size() == 0) {
                    2.invalidNumberOfParams(scriptx, "name{, params...}");
                }
                if ((script = CommandProcessor.loadScript(params.get(0).asString())) == null || script.trim().length() == 0) {
                    return Var.createValue(false);
                }
                CmdEnvironment envx = new CmdEnvironment();
                envx.script = new Script(scriptx);
                if (params.size() > 1) {
                    Var p = Var.createArray();
                    envx.script.addLocalVar("params", p);
                    int i = 1;
                    while (i < params.size()) {
                        p.addVar(params.get(i).cloneSimple());
                        ++i;
                    }
                }
                envx.logCmds = false;
                new BackgroundCommands(envx, StringUtil.stringToList(script, "\n"));
                return Var.createValue(true);
            }
        });
        Functions.gf().add(new Functions.Func("plot"){

            @Override
            public Var execute(Script scriptx, List<Var> params) {
                if (params.size() == 0) {
                    3.invalidNumberOfParams(scriptx, "{x[],}y[]{,y[],...}");
                }
                PopupChart.closeAll();
                PopupChart chart = PopupChart.getPopup("Plot", "X", "Y");
                if (params.size() == 1) {
                    Var v = params.get(0);
                    if (v.isArray()) {
                        double[] x = new double[v.getSize()];
                        double[] y = new double[v.getSize()];
                        int i = 0;
                        while (i < v.getSize()) {
                            x[i] = i;
                            y[i] = v.get(i).asDouble();
                            ++i;
                        }
                        chart.showData(x, 1, y);
                    }
                } else {
                    Var v = params.get(0);
                    double[] x = new double[v.getSize()];
                    int i = 0;
                    while (i < v.getSize()) {
                        x[i] = v.get(i).asDouble();
                        ++i;
                    }
                    int j = 1;
                    while (j < params.size()) {
                        v = params.get(j);
                        double[] y = new double[v.getSize()];
                        int i2 = 0;
                        while (i2 < v.getSize()) {
                            y[i2] = v.get(i2).asDouble();
                            ++i2;
                        }
                        chart.showData(x, j, y);
                        ++j;
                    }
                }
                return null;
            }
        });
    }

    private static String loadScript(String id) {
        if (id == null || id.length() == 0) {
            return null;
        }
        if (id.startsWith("#")) {
            return id;
        }
        ScriptMenu.ScriptEntry script = Support.paneCommand.scriptMenu.getScript(id, true);
        if (script == null || script.isEmptry()) {
            try {
                return FileUtil.readFileAsStringAutoCharset(Support.fileWithOptinalDefaults(id, Support.getDataPath(), ".txt"));
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return script.getFilteredScript();
    }

    public static boolean isScriptValid(String id) {
        if (id == null || id.length() == 0) {
            return false;
        }
        if (id.startsWith("#")) {
            return true;
        }
        ScriptMenu.ScriptEntry script = Support.paneCommand.scriptMenu.getScript(id, false);
        if (script == null || script.isEmptry()) {
            return Support.fileWithOptinalDefaults(id, Support.getDataPath(), ".txt").exists();
        }
        return script.includeScriptInMenu();
    }

    public static void runNamedScriptAsync(String scriptName) {
        String script = CommandProcessor.loadScript(scriptName);
        if (script == null || script.trim().length() == 0) {
            return;
        }
        CmdEnvironment envx = new CmdEnvironment();
        envx.logCmds = false;
        new BackgroundCommands(envx, StringUtil.stringToList(script, "\n"));
    }

    protected static IgnoredCommands ignoredCommand(String cmd) {
        cmd = cmd.substring(1);
        IgnoredCommands[] ignoredCommandsArray = IgnoredCommands.values();
        int n = ignoredCommandsArray.length;
        int n2 = 0;
        while (n2 < n) {
            IgnoredCommands sc = ignoredCommandsArray[n2];
            if (sc.name().equalsIgnoreCase(cmd)) {
                return sc;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isRestore() {
        return CommandProcessor.backgroundCmdEnvironment.restoreProgram && CommandProcessor.backgroundCmdEnvironment.restoreOption;
    }

    public static void clearRestore() {
        CommandProcessor.backgroundCmdEnvironment.restoreProgram = false;
    }

    public static void runBackground(List<String> program, boolean restoreOption) {
        if (CommandProcessor.isBackground()) {
            InterfaceThreads.log(";; A background job is already running, this request is ignored");
            return;
        }
        for (String s : program) {
            if (!s.startsWith("##")) continue;
            InterfaceThreads.log(";; This is not a program file");
            return;
        }
        CommandProcessor.backgroundCmdEnvironment.restoreOption = restoreOption;
        CommandProcessor.backgroundCmdEnvironment.logCmds = true;
        backgroundCommands = new BackgroundCommands(backgroundCmdEnvironment, program);
    }

    public static void stopBackground() {
        ArrayList<CmdEnvironment> list = new ArrayList<CmdEnvironment>();
        list.addAll(cmdEnvironments);
        for (CmdEnvironment ce : list) {
            ce.stop();
        }
    }

    public static boolean isBackground() {
        return backgroundCommands != null && backgroundCommands.isAlive();
    }

    public static boolean isAnyBackground() {
        return cmdEnvironments.size() > 0;
    }

    public static void runScript(String script) {
        CmdEnvironment envx = new CmdEnvironment();
        envx.logCmds = false;
        new BackgroundCommands(envx, StringUtil.stringToList(script, "\n"));
    }

    private static boolean skipToCmd(CmdEnvironment env, String cmds) {
        String[] cc = cmds.split("[,;| ]+");
        String line = null;
        block0: while ((line = env.getProgramLine(++env.backgroundProgramLine)) != null) {
            line = line.toLowerCase();
            String[] stringArray = cc;
            int n = cc.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block0;
                String c = stringArray[n2];
                if (line.startsWith(c)) {
                    return true;
                }
                ++n2;
            }
            break;
        }
        return false;
    }

    private static void cmdDebugIdn(String item) {
        if (item.length() == 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.valueOf(InterfaceThreads.debugIdnSocket ? (char)'+' : '-') + "socket ");
            sb.append(String.valueOf(InterfaceThreads.debugIdnSerial ? (char)'+' : '-') + "serial ");
            sb.append(String.valueOf(InterfaceThreads.debugIdnUsb ? (char)'+' : '-') + "USB ");
            sb.insert(0, ";; ");
            InterfaceThreads.log(sb.toString());
        } else {
            boolean on = true;
            if (item.contains("-")) {
                on = false;
            }
            if ((item = item.replace("-", "").replace("+", "")).equalsIgnoreCase("socket")) {
                InterfaceThreads.debugIdnSocket = on;
            }
            if (item.equalsIgnoreCase("serial")) {
                InterfaceThreads.debugIdnSerial = on;
            }
            if (item.equalsIgnoreCase("USB")) {
                InterfaceThreads.debugIdnUsb = on;
            }
        }
    }

    public static void sysCmdDebug(String device, String item) {
        if (device.equalsIgnoreCase("*idn")) {
            CommandProcessor.cmdDebugIdn(item);
        } else {
            DeviceInterface di = InterfaceThreads.getLoadedDeviceInterfaceHandle(device);
            if (di == null) {
                return;
            }
            if (item.length() == 0) {
                InterfaceThreads.log(";; " + di.getDebug());
            } else {
                di.setDebug(item);
            }
        }
    }

    public static void sysCmdLog(double interval, String fname, boolean uniqueFilename) {
        int newInterval = (int)(Math.round(interval * 200.0) * 5L);
        if (InterfaceThreads.isLogging() && newInterval > 0) {
            InterfaceThreads.loggingInterval = newInterval;
            if (InterfaceThreads.loggingInterval <= 0L) {
                InterfaceThreads.loggingInterval = 1000L;
            } else if (InterfaceThreads.loggingInterval > 3600000L) {
                InterfaceThreads.loggingInterval = 3600000L;
            }
            Var.gl.getCreate("logInterval").set(InterfaceThreads.loggingInterval);
            InterfaceThreads.log(";; Logging already running, interval adjusted");
            return;
        }
        if (newInterval <= 0) {
            InterfaceThreads.logData = false;
            InterfaceThreads.startSavingThread(null);
            Var.gl.getCreate("logInterval").set(0);
            PopupGridPanel.systemStateChanged();
            return;
        }
        Support.chartTitle = null;
        InterfaceThreads.loggingInterval = newInterval;
        Var.gl.getCreate("logInterval").set(InterfaceThreads.loggingInterval);
        InterfaceThreads.databaseIndex = 0;
        Support.dataBase.clear();
        InterfaceThreads.initAllColumns();
        Support.dataBase.header().addHeader("index");
        Support.dataBase.format().addFormat(new ValueFormat("Index", "", ValueFormat.formatInt));
        Support.dataBase.header().addHeader("time");
        Support.dataBase.format().addFormat(new ValueFormat("time", "s", ValueFormat.formatTime));
        Support.dataBase.header().addHeader("minutes");
        Support.dataBase.format().addFormat(new ValueFormat("minutes", "m", ValueFormat.formatD3));
        Support.dataBase.header().addHeader("dateTime");
        Support.dataBase.format().addFormat(new ValueFormat("dataTime", "", ValueFormat.formatDateTime));
        for (InterfaceThreads.DeviceThread dt : InterfaceThreads.getDevices()) {
            for (String s : dt.getDeviceInterface().valueNames) {
                String name = String.valueOf(dt.getHandleName()) + "." + s;
                Var.gl.getCreate(name);
                Support.dataBase.header().addHeader(name);
                Support.dataBase.format().addFormat(dt.getDeviceInterface().getValueFormat(s));
            }
        }
        Support.math.addMathColumns();
        Support.math.resetCalc(null);
        if (PopupParamSweeper.addColumns()) {
            List<String> names = PopupParamSweeper.columnNames();
            List<String> units = PopupParamSweeper.columnUnits();
            int i = 0;
            while (i < names.size()) {
                String name = names.get(i);
                Var.gl.getCreate(name);
                Support.dataBase.header().addHeader(name);
                Support.dataBase.format().addFormat(new ValueFormat(name, units.get(i), ValueFormat.formatD2));
                ++i;
            }
        }
        if (fname != null && fname.trim().length() > 0) {
            if (!new File(fname = StringUtil.unQuote(fname.trim())).isAbsolute()) {
                fname = Paths.get(Support.getDataPath(), fname).toString();
            }
            if (!new File(fname).getName().contains(".")) {
                fname = String.valueOf(fname) + ".csv";
            }
            if (uniqueFilename) {
                fname = Support.uniqueFilename(fname);
            }
            InterfaceThreads.startSavingThread(fname);
            InterfaceThreads.saveLine(Support.dataBase.header().getHeaderLine());
        }
        Var.gl.getCreate("time").set(0.0);
        InterfaceThreads.logData = true;
        InterfaceThreads.loggingStartTime = System.currentTimeMillis();
        Main.changeDevicesOrTable(Support.UpdateType.ColumnsTable);
        Support.paneChart.annotations.clear();
        Support.paneHistogram.annotations.clear();
        InterfaceThreads.startLogThread();
        PopupGridPanel.systemStateChanged();
        PopupChartLayout.closeAll();
    }

    private static void sysCmdMath(CmdEnvironment env, String[] params) {
        if (InterfaceThreads.isLogging()) {
            return;
        }
        if (params.length < 2) {
            Support.math.disableAll();
            return;
        }
        String name = StringUtil.unQuote(env.exp(params[1]));
        boolean newEntry = false;
        Mathematics.MathEntry me = Support.math.getEntry(name);
        if (me == null) {
            me = Support.math.createEntry(name);
            newEntry = true;
        }
        me.setEnabled(true);
        me.clearError();
        if (params.length > 5) {
            String s = StringUtil.unQuote(env.exp(params[2]));
            if (s.equals("_")) {
                s = "";
            }
            me.setUnit(s);
            if (!me.setType(StringUtil.unQuote(env.exp(params[3])))) {
                return;
            }
            me.setSamples(params[4].equals("-") ? 0 : env.expInt(params[4]));
            me.setFormula(StringUtil.unQuote(env.exp(env.remaning(params, 5))));
            if (newEntry) {
                Support.math.addEntry(me);
            }
        }
    }

    private static void sysCmdMathDelete(CmdEnvironment env, String[] params) {
        if (InterfaceThreads.isLogging()) {
            return;
        }
        int i = 1;
        while (i < params.length) {
            String s = StringUtil.unQuote(env.exp(params[i]));
            Support.math.deleteEntry(s);
            ++i;
        }
    }

    private static void sysCmdDevice(String cmd) {
        String name;
        if (InterfaceThreads.isLogging()) {
            return;
        }
        int i = cmd.indexOf(32);
        if (i < 0) {
            InterfaceThreads.loadDeviceConfig.disableAll();
            return;
        }
        if ((cmd = cmd.substring(i + 1)).length() < 1) {
            return;
        }
        boolean useHandle = false;
        char c = cmd.charAt(0);
        if (c == '\"' || c == '\'') {
            if ((i = cmd.indexOf(c, i)) < 0) {
                return;
            }
            name = cmd.substring(1, i);
            cmd = cmd.substring(i + 1);
        } else {
            i = cmd.indexOf(32);
            if (i < 0) {
                i = cmd.length();
            }
            name = cmd.substring(0, i);
            useHandle = true;
            cmd = cmd.substring(i);
        }
        String[] params = cmd.trim().split("[ ]+");
        String address = params.length > 0 ? params[0] : null;
        String baudrate = params.length > 1 ? params[1] : null;
        LoadDeviceConfig.LoadDevice ld = null;
        ld = useHandle ? InterfaceThreads.loadDeviceConfig.findDeviceHandle(name, address) : InterfaceThreads.loadDeviceConfig.findDeviceName(name, address);
        if (ld != null) {
            if (address != null && address.length() > 0) {
                ld.setAddress(address);
            }
            if (baudrate != null && baudrate.length() > 0) {
                ld.setBaudrate(baudrate);
            }
            ld.setEnabled(true);
        }
    }

    private static void sysCmdReconnect() {
        if (InterfaceThreads.isLogging()) {
            return;
        }
        InterfaceThreads.startInterface();
    }

    private static void sysCmdValues() {
        List<InterfaceThreads.ThreadCommand> doneList = InterfaceThreads.threadCommander.sampleAllDevices(1);
        StringBuilder sb = new StringBuilder();
        for (InterfaceThreads.ThreadCommand tc : doneList) {
            sb.append(";; ");
            sb.append(tc.getHandler().getValuesString(tc.getAnswerDoubles()));
            InterfaceThreads.log(sb.toString());
            sb.setLength(0);
        }
    }

    private static void sysCmdId() {
        List<InterfaceThreads.ThreadCommand> doneList = InterfaceThreads.threadCommander.sampleAllDevices(4);
        StringBuilder sb = new StringBuilder();
        for (InterfaceThreads.ThreadCommand dl : doneList) {
            sb.append(";; ");
            sb.append(dl.getAnswerString());
            if (dl.getHandler().getDeviceInterface().getId() > 0) {
                sb.append("   Id: ");
                sb.append(dl.getHandler().getDeviceInterface().getId());
            }
            InterfaceThreads.log(sb.toString());
            sb.setLength(0);
        }
    }

    static void sysCmdOutputOff() {
        Support.commandList.add("#off");
        PopupParamSweeper.abort();
        PopupAutoAdjust.stopAll();
        PopupMPPT.stopAll();
        InterfaceThreads.threadCommander.sampleAllDevices(6);
    }

    static void sysCmdInitColumns() {
        for (InterfaceThreads.DeviceThread dt : InterfaceThreads.getDevices()) {
            dt.getDeviceInterface().requestInitColumns();
        }
    }

    private static void sysCmdEcho(CmdEnvironment env, String[] params) {
        StringBuilder sb = new StringBuilder();
        sb.append(";; ");
        int i = 1;
        while (i < params.length) {
            sb.append(env.exp(params[i]));
            sb.append(" ");
            ++i;
        }
        InterfaceThreads.log(sb.toString());
    }

    /*
     * Unable to fully structure code
     */
    private static void sysCmdWaitReady() {
        if (!InterfaceThreads.isLogging()) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException v0) {}
lbl7:
            // 3 sources

            ** while (InterfaceThreads.inInitialization() || Main.busyReconnecting || InterfaceThreads.threadCommander.isBusy())
        }
lbl8:
        // 1 sources

        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
    }

    private static void sysCmdWaitUi() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Main.main.updateUI();
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {}
    }

    private static void sysCmdDelay(CmdEnvironment env, long time) {
        if (SwingUtilities.isEventDispatchThread()) {
            InterfaceThreads.log(";; #DELAY ignored from command line");
            return;
        }
        long stopTime = System.currentTimeMillis() + time;
        while (stopTime > System.currentTimeMillis() && !env.stopRequest) {
            try {
                Thread.sleep(Math.min(stopTime - System.currentTimeMillis(), 100L));
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static void sysCmdWait(CmdEnvironment env, String exp) {
        if (SwingUtilities.isEventDispatchThread()) {
            InterfaceThreads.log(";; #WAIT ignored from command line");
            return;
        }
        InterfaceThreads.setupVars();
        while (env.script.expression(exp).asBoolean() && !env.stopRequest) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            InterfaceThreads.setupVars();
        }
    }

    private static void sysCmdWhile(CmdEnvironment env, String exp) {
        if (SwingUtilities.isEventDispatchThread()) {
            InterfaceThreads.log(";; #WHILE ignored from command line");
            return;
        }
        InterfaceThreads.setupVars();
        if (!env.script.expression(exp).asBoolean()) {
            String line = null;
            int n = 1;
            do {
                if ((line = env.getProgramLine(++env.backgroundProgramLine)) == null) {
                    InterfaceThreads.log(";; #ENDWHILE not found");
                }
                if (!(line = line.toLowerCase()).startsWith("#while")) continue;
                ++n;
            } while (!line.startsWith("#endwhile") || --n != 0);
            ++env.backgroundProgramLine;
            return;
        }
        env.backgroundWhileStack.push(env.backgroundProgramLine - 1);
    }

    private static void sysCmdForEach(CmdEnvironment env, String[] params) {
        if (SwingUtilities.isEventDispatchThread()) {
            InterfaceThreads.log(";; #FOREACH ignored from command line");
            return;
        }
        if (params.length < 2) {
            return;
        }
        ForEach forEach = new ForEach();
        forEach.line = env.backgroundProgramLine;
        forEach.varName = params[1];
        int i = 2;
        while (i < params.length) {
            String s = params[i];
            if (s.startsWith("(") && s.endsWith(")")) {
                Var v = env.script.expression(s);
                if (v.isArray()) {
                    int j = 0;
                    while (j < v.getSize()) {
                        forEach.items.add(v.get(j));
                        ++j;
                    }
                } else {
                    forEach.items.add(v);
                }
            } else {
                forEach.items.add(Var.createValue(s));
            }
            ++i;
        }
        if (forEach.items.size() == 0) {
            int n = 1;
            while (n > 0) {
                String line;
                if ((line = env.getProgramLine(++env.backgroundProgramLine)).toLowerCase().startsWith("#foreach")) {
                    ++n;
                    continue;
                }
                if (!line.toLowerCase().startsWith("#endforeach")) continue;
                --n;
            }
        } else {
            env.backgroundForEachStack.push(forEach);
            CommandProcessor.sysCmdEndForEach(env);
        }
    }

    private static void sysCmdEndForEach(CmdEnvironment env) {
        if (env.backgroundForEachStack.size() == 0) {
            return;
        }
        ForEach forEach = env.backgroundForEachStack.peek();
        if (forEach.items.size() == 0) {
            env.backgroundForEachStack.pollFirst();
            return;
        }
        env.script.getLocalVars().getCreate(forEach.varName).set(forEach.items.remove(0));
        env.backgroundProgramLine = forEach.line;
    }

    private static void sysCmdIf(CmdEnvironment env, String exp) {
        if (SwingUtilities.isEventDispatchThread()) {
            InterfaceThreads.log(";; #IF ignored from command line");
            return;
        }
        InterfaceThreads.setupVars();
        if (env.script.expression(exp).asBoolean()) {
            env.backgroundIfPerformed = true;
        } else {
            CommandProcessor.skipToCmd(env, "#elseif #else #endif");
            env.backgroundIfPerformed = false;
        }
    }

    private static void sysCmdElseIf(CmdEnvironment env, String exp) {
        if (SwingUtilities.isEventDispatchThread()) {
            InterfaceThreads.log(";; #ELSEIF ignored from command line");
            return;
        }
        InterfaceThreads.setupVars();
        if (!env.backgroundIfPerformed && env.script.expression(exp).asBoolean()) {
            env.backgroundIfPerformed = true;
        } else {
            CommandProcessor.skipToCmd(env, "#elseif #else #endif");
        }
    }

    private static void sysCmdElse(CmdEnvironment env) {
        if (SwingUtilities.isEventDispatchThread()) {
            InterfaceThreads.log(";; #ELSE ignored from command line");
            return;
        }
        if (env.backgroundIfPerformed) {
            CommandProcessor.skipToCmd(env, "#endif");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sysCmdTrig(CmdEnvironment env, String cmdLine) {
        InterfaceThreads.hasTriggered = false;
        int i = cmdLine.indexOf(32);
        if (i < 0) {
            if (InterfaceThreads.isManualTrig()) {
                InterfaceThreads.lastTrig = true;
            }
            return;
        }
        if ((i = (cmdLine = cmdLine.substring(i + 1).trim()).indexOf(32)) > 0) {
            String string = InterfaceThreads.trigExpression;
            synchronized (string) {
                InterfaceThreads.trigExpression = cmdLine.substring(i).trim();
            }
            cmdLine = cmdLine.substring(0, i);
        }
        if (cmdLine.equalsIgnoreCase("0")) {
            if (InterfaceThreads.isManualTrig()) {
                InterfaceThreads.lastTrig = false;
            }
        } else if (cmdLine.equalsIgnoreCase("1")) {
            if (InterfaceThreads.isManualTrig()) {
                InterfaceThreads.lastTrig = true;
            }
        } else {
            InterfaceThreads.LoggingMode[] loggingModeArray = InterfaceThreads.LoggingMode.values();
            int n = loggingModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                InterfaceThreads.LoggingMode lm = loggingModeArray[n2];
                if (cmdLine.equalsIgnoreCase(lm.name())) {
                    InterfaceThreads.loggingMode = lm;
                    break;
                }
                ++n2;
            }
        }
    }

    private static void sysCmdHasLogged() {
        if (SwingUtilities.isEventDispatchThread()) {
            InterfaceThreads.log(";; #HASLOGGED ignored from command line");
            return;
        }
        if (InterfaceThreads.loggingMode == InterfaceThreads.LoggingMode.Normal) {
            InterfaceThreads.hasTriggered = false;
        }
        while (!InterfaceThreads.hasTriggered) {
            try {
                if (!InterfaceThreads.isLogging()) {
                    InterfaceThreads.log(";; #HASLOGGED only works when logging");
                    return;
                }
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        InterfaceThreads.hasTriggered = false;
    }

    private static void sysCmdLogCmds(CmdEnvironment env, boolean on) {
        env.logCmds = on;
    }

    private static void sysCmdSaveTable(CmdEnvironment env, String[] params) {
        if (InterfaceThreads.isLogging() || params.length < 2) {
            return;
        }
        int mode = 0;
        if (params.length >= 3) {
            String format = env.exp(params[2]);
            if (format.equals(",;")) {
                Support.dataBase.setFileFormat(DataBase.FileFormat.euro);
            } else if (format.equals(".,")) {
                Support.dataBase.setFileFormat(DataBase.FileFormat.us);
            } else if (format.equalsIgnoreCase("tab")) {
                Support.dataBase.setFileFormat(DataBase.FileFormat.tab);
            } else if (format.equalsIgnoreCase("ctab")) {
                Support.dataBase.setFileFormat(DataBase.FileFormat.ctab);
            } else if (format.equalsIgnoreCase("int")) {
                mode = 1;
            } else if (format.equalsIgnoreCase("long")) {
                mode = 2;
            } else if (format.equalsIgnoreCase("float")) {
                mode = 3;
            } else if (format.equalsIgnoreCase("double")) {
                mode = 4;
            }
        }
        try {
            switch (mode) {
                case 1: {
                    Support.dataBase.saveJavaInt(Support.fileWithOptinalDefaults(env.exp(params[1]), Support.getDataPath(), ".java"));
                    break;
                }
                case 2: {
                    Support.dataBase.saveJavaLong(Support.fileWithOptinalDefaults(env.exp(params[1]), Support.getDataPath(), ".java"));
                    break;
                }
                case 3: {
                    Support.dataBase.saveJavaFloat(Support.fileWithOptinalDefaults(env.exp(params[1]), Support.getDataPath(), ".java"));
                    break;
                }
                case 4: {
                    Support.dataBase.saveJavaDouble(Support.fileWithOptinalDefaults(env.exp(params[1]), Support.getDataPath(), ".java"));
                    break;
                }
                default: {
                    Support.dataBase.save(Support.fileWithOptinalDefaults(env.exp(params[1]), Support.getDataPath(), ".csv"));
                    break;
                }
            }
        }
        catch (IOException iOException) {
            InterfaceThreads.log(";; *** Error *** #SaveTable failed");
        }
    }

    private static void sysCmdLoadTable(CmdEnvironment env, String[] params) {
        if (InterfaceThreads.isLogging() || params.length != 2) {
            return;
        }
        try {
            Support.dataBase.load(Support.fileWithOptinalDefaults(env.exp(params[1]), Support.getDataPath(), ".csv"));
            Support.chartTitle = null;
        }
        catch (IOException iOException) {}
        Support.math.disableAll();
        Main.changeDevicesOrTable(Support.UpdateType.ColumnsTable);
        Support.clearExporter();
        Support.paneChart.annotations.clear();
        Support.paneHistogram.annotations.clear();
        PopupGridPanel.systemStateChanged();
        PopupChartLayout.closeAll();
    }

    private static void sysCmdImportTable(CmdEnvironment env, String[] params) {
        if (InterfaceThreads.isLogging() || params.length < 3) {
            return;
        }
        ArrayList<String> dataColumns = new ArrayList<String>();
        String refColumn = env.exp(params[2]);
        int i = 3;
        while (i < params.length) {
            dataColumns.add(env.exp(params[i]));
            ++i;
        }
        try {
            Importer importer = new Importer(Support.dataBase);
            String err = importer.importData(Support.fileWithOptinalDefaults(env.exp(params[1]), Support.getDataPath(), ".csv"), refColumn, dataColumns);
            if (err != null && err.length() > 0) {
                InterfaceThreads.log(";; *** Error *** " + err);
            }
        }
        catch (IOException iOException) {}
        Main.changeDevicesOrTable(Support.UpdateType.ColumnsTable);
        PopupGridPanel.systemStateChanged();
        Support.clearExporter();
    }

    public static void clearTable() {
        Support.dataBase.clear();
        Support.chartTitle = null;
        Support.math.disableAll();
        Main.changeDevicesOrTable(Support.UpdateType.ColumnsTable);
        Support.clearExporter();
        Support.paneChart.annotations.clear();
        Support.paneHistogram.annotations.clear();
        PopupChartLayout.closeAll();
    }

    private static void sysCmdClearTable(CmdEnvironment env, String[] params) {
        CommandProcessor.clearTable();
    }

    /*
     * Unable to fully structure code
     */
    private static void sysCmdCalc(CmdEnvironment env, String cmds) {
        sb = new StringBuilder();
        i = cmds.indexOf(32);
        if (i > 0) {
            sb.append(cmds.substring(i + 1));
        }
        sb.append("\n");
        if (!SwingUtilities.isEventDispatchThread()) ** GOTO lbl17
        env.commandLineCalcMode = true;
        CommandProcessor.processCommandLineStatement(env, sb.toString());
        return;
        while ((line = env.getProgramLine(env.backgroundProgramLine++)) != null && !line.startsWith("#")) {
            sb.append(line);
            sb.append("\n");
lbl17:
            // 2 sources

            if (env.backgroundProgramLine < env.program.size()) continue;
        }
        if ((s = CmdEnvironment.access$3(env).execute(sb.toString())) != null) {
            if (s.isStruct() || s.isArray()) {
                InterfaceThreads.log(";; " + s.toString());
            } else if (s.asString().length() > 0) {
                InterfaceThreads.log(";; " + s.asString());
            }
        }
    }

    private static void sysCmdDiscover(String filter) {
        if (SwingUtilities.isEventDispatchThread()) {
            CommandProcessor.runScript("#discover?" + (filter != null ? " " + filter : ""));
        } else {
            VXI11Discovery d = new VXI11Discovery();
            for (String s : d.getDeviceList(filter)) {
                InterfaceThreads.log(";; " + s);
            }
        }
    }

    private static void sysCmdConnected(CmdEnvironment env, String[] cmds) {
        File f = null;
        if (cmds.length > 1) {
            f = Support.fileWithOptinalDefaults(env.exp(cmds[1]), Support.getDataPath(), ".txt");
        }
        StringBuilder sb = new StringBuilder();
        if (f == null) {
            sb.append(";; ");
        }
        sb.append("Computer:\t");
        String hostName = "";
        try {
            hostName = InetAddress.getLocalHost().getHostName();
            sb.append(hostName);
            sb.append("\t");
        }
        catch (UnknownHostException unknownHostException) {}
        try {
            int n = 0;
            InetAddress[] inetAddressArray = InetAddress.getAllByName(hostName);
            int n2 = inetAddressArray.length;
            int n3 = 0;
            while (n3 < n2) {
                InetAddress ia = inetAddressArray[n3];
                if (n > 0) {
                    sb.append(", ");
                }
                sb.append(ia.getHostAddress());
                ++n;
                ++n3;
            }
        }
        catch (Exception exception) {}
        sb.append("\n");
        if (f == null) {
            sb.append(";; ");
        }
        sb.append("OS:\t");
        sb.append(System.getProperty("os.name"));
        sb.append("\t");
        sb.append(System.getProperty("os.arch"));
        sb.append(" ");
        sb.append(System.getProperty("os.version"));
        sb.append("\n");
        if (f == null) {
            sb.append(";; ");
        }
        sb.append("Java:\t");
        sb.append(System.getProperty("java.vendor"));
        sb.append("\t");
        sb.append(System.getProperty("java.version"));
        sb.append("\n");
        if (f == null) {
            sb.append(";; ");
        }
        sb.append("User:\t");
        sb.append(System.getProperty("user.name"));
        sb.append("\n");
        if (f == null) {
            sb.append(";; ");
        }
        sb.append("Handle\tDevice\tSerial number\tVersion\tAddress\n");
        for (InterfaceThreads.DeviceThread dt : InterfaceThreads.getDevices()) {
            if (f == null) {
                sb.append(";; ");
            }
            sb.append(dt.getHandleName());
            sb.append("\t");
            sb.append(dt.getDeviceInterface().getDeviceName());
            sb.append("\t");
            sb.append(dt.getDeviceInterface().getSerialNumber());
            sb.append("\t");
            sb.append(dt.getDeviceInterface().getSoftwareVersion());
            sb.append("\t");
            sb.append(dt.cPort.getDeviceName());
            sb.append("\n");
        }
        if (f == null) {
            InterfaceThreads.log(sb.toString());
        } else {
            try {
                FileUtil.writeFile(f, sb.toString());
            }
            catch (IOException iOException) {}
        }
    }

    private static void sysCmdPopupRCL(RCL mode, CmdEnvironment env, String[] cmds) {
        ArrayList<String> list = new ArrayList<String>();
        if (cmds.length <= 3) {
            return;
        }
        int lines = -1;
        boolean withTip = false;
        int i = 3;
        while (i < cmds.length) {
            String s = cmds[i];
            if (s.startsWith("(") && s.endsWith(")")) {
                Var v = env.script.expression(s);
                if (v.isArray()) {
                    int j = 0;
                    while (j < v.getSize()) {
                        list.add(v.get(j).asString());
                        withTip = false;
                        ++j;
                    }
                } else {
                    list.add(v.toString());
                    withTip = true;
                }
            } else {
                list.add(s);
                withTip = true;
            }
            ++i;
        }
        String tip = null;
        if (withTip) {
            tip = (String)list.get(list.size() - 1);
            list.remove(list.size() - 1);
            if (mode == RCL.list && StringUtil.isInt((String)list.get(list.size() - 1))) {
                lines = StringUtil.parseInt((String)list.get(list.size() - 1));
                list.remove(list.size() - 1);
            }
        }
        switch (mode) {
            case radio: {
                env.inputPopup.addRadioInput(cmds[1], cmds[2], list, tip);
                break;
            }
            case combo: {
                env.inputPopup.addComboboxInput(cmds[1], cmds[2], list, tip);
                break;
            }
            case list: {
                env.inputPopup.addListInput(cmds[1], cmds[2], list, lines, tip);
            }
        }
    }

    private static void sysCmdPopupColumn(boolean radio, CmdEnvironment env, String[] cmds) {
        if (cmds.length < 3) {
            return;
        }
        boolean systemColumns = cmds.length < 4 ? false : env.expBoolean(cmds[3]);
        Pattern filter = Pattern.compile("(?i)" + CharacterEscapes.forSimpleSearch(cmds.length < 5 ? "" : env.exp(cmds[4])));
        String tip = cmds.length < 6 ? null : env.exp(cmds[5]);
        ArrayList<String> list = new ArrayList<String>();
        if (systemColumns) {
            list.addAll(Support.dataBase.header().getSystemColumnsList());
        }
        for (String s : Support.dataBase.header().getDataColumnsList()) {
            if (!filter.matcher(s).find()) continue;
            list.add(s);
        }
        env.inputPopup.addComboboxInput(cmds[1], cmds[2], list, tip);
    }

    private static void sysCmdPopupDevice(boolean radio, CmdEnvironment env, String[] params) {
        String tip;
        String functionList;
        String deviceFilter;
        if (params.length < 3) {
            return;
        }
        int n = 3;
        boolean all = false;
        if ((deviceFilter = env.pString(params, n++, null)).equalsIgnoreCase("all")) {
            all = true;
            deviceFilter = env.pString(params, n++, null);
        }
        if ((functionList = env.pString(params, n++, null)).equalsIgnoreCase("all")) {
            all = true;
            functionList = env.pString(params, n++, null);
        }
        if ((tip = env.pString(params, n++, null)).equalsIgnoreCase("all")) {
            all = true;
            tip = env.pString(params, n++, null);
        }
        List<String> list = InterfaceThreads.getDevicesHandlesWithInterface(deviceFilter, functionList, all);
        env.inputPopup.addComboboxInput(params[1], params[2], list, tip);
    }

    private static void sysCmdPopupValue(boolean radio, CmdEnvironment env, String[] cmds) {
        if (cmds.length < 3) {
            return;
        }
        boolean includeMath = cmds.length < 4 ? false : env.expBoolean(cmds[3]);
        Pattern filter = Pattern.compile("(?i)" + CharacterEscapes.forSimpleSearch(cmds.length < 5 ? "" : env.exp(cmds[4])));
        String tip = cmds.length < 6 ? null : env.exp(cmds[5]);
        ArrayList<String> list = new ArrayList<String>();
        for (String s : InterfaceThreads.listChannels(includeMath)) {
            if (!filter.matcher(s).find()) continue;
            list.add(s);
        }
        env.inputPopup.addComboboxInput(cmds[1], cmds[2], list, tip);
    }

    private static void sysCmdPopupColor(boolean radio, CmdEnvironment env, String[] cmds) {
        if (cmds.length < 3) {
            return;
        }
        String tip = cmds.length >= 4 ? env.exp(cmds[3]) : "";
        env.inputPopup.addColorInput(cmds[1], cmds[2], tip);
    }

    private static void sysCmdPopupImage(CmdEnvironment env, String[] cmds) {
        if (cmds.length < 4) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        String tip = null;
        int i = 3;
        while (i < cmds.length) {
            list.add(env.exp(cmds[i]));
            ++i;
        }
        if (list.size() > 1) {
            tip = (String)list.remove(list.size() - 1);
        }
        env.inputPopup.addImage(env.exp(cmds[1]), env.exp(cmds[2]), list, tip, new InputPopup.ImageViewerCallback(){

            @Override
            public void show(List<String> images) {
                PopupImage pi = PopupImage.getPopup();
                for (String s : images) {
                    pi.addImage(s);
                }
                pi.setShowFirstLoaded();
                pi.showDefault(false);
            }
        });
    }

    private static synchronized void sysCmdAsync(CmdEnvironment env, String[] params) {
        if (params.length <= 1) {
            if (asyncHandler != null) {
                asyncHandler.waitDone();
            }
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        String s = params[1];
        if (s.startsWith("(") && s.endsWith(")")) {
            Var v = env.script.expression(s);
            if (v.isArray()) {
                int j = 0;
                while (j < v.getSize()) {
                    list.add(v.get(j).asString());
                    ++j;
                }
            } else {
                list.add(v.asString());
            }
        } else {
            list.add(s);
        }
        if (list.size() > 0) {
            String cmds = env.remaningExp(params, 2);
            if (asyncHandler == null) {
                asyncHandler = new AsyncHandler();
            }
            asyncHandler.add(list, cmds);
        }
    }

    private static synchronized void sysCmdAsyncCmd(CmdEnvironment env, String[] params) {
        if (params.length <= 1) {
            if (asyncHandler != null) {
                asyncHandler.waitDone();
            }
            return;
        }
        String cmds = env.exp(params[params.length - 1]);
        if (asyncHandler == null) {
            asyncHandler = new AsyncHandler();
        }
        int i = 1;
        while (i < params.length - 1) {
            asyncHandler.add(env.exp(params[i]), cmds);
            ++i;
        }
    }

    private static void sysCmdChartScaleName(CmdEnvironment env, String[] params) {
        if (params.length == 1) {
            Support.chartScales.resetOverrides();
            return;
        }
        String scaleName = env.exp(params[1]);
        String newName = null;
        if (params.length >= 3) {
            newName = env.exp(params[2]);
        }
        Support.chartScales.overrideName(scaleName, newName);
        PopupChartLayout.updateNames();
    }

    private static void sysCmdChartColors(CmdEnvironment env, String[] params) {
        if (params.length < 2) {
            return;
        }
        Color[] lineColor = new Color[params.length - 1];
        int i = 1;
        while (i < params.length) {
            lineColor[i - 1] = env.expColor(params[i]);
            ++i;
        }
        Support.chartLineColor = lineColor;
        PopupChartLayout.layoutFillColors();
    }

    private static void sysCmdChartBackground(CmdEnvironment env, String[] params) {
        if (params.length < 2) {
            return;
        }
        Support.chartColor = env.expColor(params[1]);
        Support.chartBorderColor = params.length >= 3 ? env.expColor(params[2]) : null;
        Support.chartGridColor = params.length >= 4 ? env.expColor(params[3]) : null;
        Support.chartFontColor = params.length >= 5 ? env.expColor(params[4]) : null;
        Support.chartHeaderColor = params.length >= 6 ? env.expColor(params[5]) : null;
        PopupChartLayout.layoutFillColors();
    }

    private static void sysCmdChartScaleSync(CmdEnvironment env, String[] params) {
        if (params.length == 1) {
            Support.chartScales.disableSync();
        }
        if (params.length < 3) {
            return;
        }
        String master = env.exp(params[1]);
        int i = 2;
        while (i < params.length) {
            Support.chartScales.syncToName(master, env.exp(params[i]));
            ++i;
        }
        PopupChartLayout.updateSync();
    }

    private static void sysCmdScriptPriority(CmdEnvironment env, String[] params) {
        if (params.length < 2) {
            int p = Thread.currentThread().getPriority();
            String s = "";
            s = p == 5 ? "Normal" : (p == 6 ? "Normal+" : (p == 1 ? "Low" : (p == 8 ? "High" : "" + p)));
            InterfaceThreads.log(";; Priority is " + s);
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            InterfaceThreads.log(";; Command interface cannot change priority");
            return;
        }
        if (params[1].equalsIgnoreCase("low")) {
            Thread.currentThread().setPriority(1);
        } else if (params[1].equalsIgnoreCase("high")) {
            Thread.currentThread().setPriority(8);
        } else if (params[1].equalsIgnoreCase("normal") || params[1].equalsIgnoreCase("medium")) {
            Thread.currentThread().setPriority(5);
        } else if (params[1].equalsIgnoreCase("normal+") || params[1].equalsIgnoreCase("medium+")) {
            Thread.currentThread().setPriority(6);
        } else if (StringUtil.isInt(params[1])) {
            Thread.currentThread().setPriority(StringUtil.parseInt(params[1]));
        }
    }

    private static void sysCmdRunScript(CmdEnvironment env, String[] params) {
        if (params.length < 2) {
            InterfaceThreads.log(";; Scripts running: " + cmdEnvironments.size());
            return;
        }
        String script = CommandProcessor.loadScript(env.exp(params[1]));
        if (script == null || script.trim().length() == 0) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            if (CommandProcessor.isBackground()) {
                InterfaceThreads.log(";; A background job is already running, this request is ignored");
                return;
            }
            backgroundCmdEnvironment = new CmdEnvironment();
            if (params.length > 2) {
                Var p = Var.createArray();
                backgroundCmdEnvironment.script.addLocalVar("params", p);
                int i = 2;
                while (i < params.length) {
                    p.addVar(env.expVar(params[i]));
                    ++i;
                }
            }
            CommandProcessor.backgroundCmdEnvironment.logCmds = false;
            backgroundCommands = new BackgroundCommands(backgroundCmdEnvironment, StringUtil.stringToList(script, "\n"));
        } else {
            CmdEnvironment pgm = new CmdEnvironment();
            pgm.script = new Script(env.script);
            if (params.length > 2) {
                Var p = Var.createArray();
                pgm.script.addLocalVar("params", p);
                int i = 2;
                while (i < params.length) {
                    p.addVar(env.expVar(params[i]));
                    ++i;
                }
            }
            pgm.initProgram(StringUtil.stringToList(script, "\n"));
            pgm.logCmds = env.logCmds;
            pgm.run();
        }
    }

    private static void sysCmdRunScriptAsync(CmdEnvironment env, String[] params) {
        if (params.length < 2) {
            return;
        }
        String script = CommandProcessor.loadScript(env.exp(params[1]));
        if (script == null || script.trim().length() == 0) {
            return;
        }
        CmdEnvironment envx = new CmdEnvironment();
        envx.script = new Script(env.script);
        if (params.length > 2) {
            Var p = Var.createArray();
            envx.script.addLocalVar("params", p);
            int i = 2;
            while (i < params.length) {
                p.addVar(env.expVar(params[i]));
                ++i;
            }
        }
        envx.logCmds = false;
        new BackgroundCommands(envx, StringUtil.stringToList(script, "\n"));
    }

    private static boolean containDeviceHandle(String str) {
        List<InterfaceThreads.DeviceThread> devices = InterfaceThreads.getDevices();
        if (devices == null) {
            return false;
        }
        str = str.toUpperCase();
        for (InterfaceThreads.DeviceThread dt : devices) {
            if (!str.contains(dt.getHandleName())) continue;
            return true;
        }
        return false;
    }

    private static void sysCmdScreenDump(CmdEnvironment env) {
        if (InterfaceThreads.isLogging()) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            CommandProcessor.runScript("#\n" + env.defaultDevice.toUpperCase() + ":\n#screenDump");
        } else {
            BufferedImage img;
            final InterfaceThreads.DeviceThread dt = InterfaceThreads.deviceMap.get(env.defaultDevice.toUpperCase());
            if (dt != null && (img = dt.getDeviceInterface().readScreenDump()) != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PopupImage pi = PopupImage.getPopup();
                        pi.setShowFirstLoaded();
                        pi.addImage(img, "", "Screen on " + dt.deviceName(), true);
                        pi.showDefault(false);
                    }
                });
            }
        }
    }

    private static void deviceLog(CmdEnvironment env, boolean status, String[] params) {
        int i = 1;
        while (i < params.length) {
            String handle = env.exp(params[i]);
            if (handle.equals("*")) {
                for (InterfaceThreads.DeviceThread dt : InterfaceThreads.getAllDeviceThreads()) {
                    dt.setDeviceLogging(status);
                }
            } else {
                DeviceInterface di = InterfaceThreads.getLoadedDeviceInterfaceHandle(handle);
                if (di != null) {
                    di.dt.setDeviceLogging(status);
                }
            }
            ++i;
        }
    }

    private static void processCommandLineStatement(CmdEnvironment env, String cmd) {
        try {
            Var s = env.script.execute(cmd);
            if (s != null) {
                if (s.isStruct() || s.isArray() || s.isBytes()) {
                    InterfaceThreads.log(";; " + s.toString());
                } else if (s.asString().length() > 0) {
                    InterfaceThreads.log(";; " + s.asString());
                }
            }
        }
        catch (Exception e) {
            InterfaceThreads.log(";; Error: " + e.getMessage());
            e.printStackTrace(System.out);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean processCommands(CmdEnvironment env, String cmds) {
        if (cmds.trim().length() == 0 || cmds.charAt(0) == ';') {
            if (!env.logCmds) return true;
            InterfaceThreads.log(cmds);
            return true;
        } else if (cmds.startsWith("#")) {
            env.commandLineCalcMode = false;
            String[] cmdLine = Support.splitWithQuotes(cmds);
            cmdLine[0] = cmdLine[0].toLowerCase();
            if (env.logCmds && !cmds.toLowerCase().startsWith("#logcmds 0")) {
                InterfaceThreads.log(cmds);
            }
            try {
                if (cmdLine[0].equals("#values?")) {
                    CommandProcessor.sysCmdValues();
                    return true;
                }
                if (cmdLine[0].equals("#id?")) {
                    CommandProcessor.sysCmdId();
                    return true;
                }
                if (cmdLine[0].equals("#math")) {
                    CommandProcessor.sysCmdMath(env, cmdLine);
                    return true;
                }
                if (cmdLine[0].equals("#mathdelete")) {
                    CommandProcessor.sysCmdMathDelete(env, cmdLine);
                    return true;
                }
                if (cmdLine[0].equals("#device")) {
                    CommandProcessor.sysCmdDevice(cmds);
                    return true;
                }
                if (cmdLine[0].equals("#waitready")) {
                    CommandProcessor.sysCmdWaitReady();
                    return true;
                }
                if (cmdLine[0].equals("#waitui")) {
                    CommandProcessor.sysCmdWaitUi();
                    return true;
                }
                if (cmdLine[0].equals("#echo")) {
                    CommandProcessor.sysCmdEcho(env, cmdLine);
                    return true;
                }
                if (cmdLine[0].equals("#reconnect")) {
                    CommandProcessor.sysCmdReconnect();
                    return true;
                }
                if (cmdLine[0].equals("#off")) {
                    CommandProcessor.sysCmdOutputOff();
                    return true;
                }
                if (cmdLine[0].equals("#initcolumns")) {
                    CommandProcessor.sysCmdInitColumns();
                    return true;
                }
                if (cmdLine[0].equals("#loadtable")) {
                    CommandProcessor.sysCmdLoadTable(env, cmdLine);
                    return true;
                }
                if (cmdLine[0].equals("#importtable")) {
                    CommandProcessor.sysCmdImportTable(env, cmdLine);
                    return true;
                }
                if (cmdLine[0].equals("#connected?")) {
                    CommandProcessor.sysCmdConnected(env, cmdLine);
                    return true;
                }
                if (cmdLine[0].equals("#savetable")) {
                    CommandProcessor.sysCmdSaveTable(env, cmdLine);
                    return true;
                }
                if (cmdLine[0].equals("#cleartable")) {
                    CommandProcessor.sysCmdClearTable(env, cmdLine);
                    return true;
                }
                if (cmdLine[0].equals("#calc")) {
                    env.restoreProgram = true;
                    CommandProcessor.sysCmdCalc(env, cmds);
                    return true;
                }
                if (cmdLine[0].equals("#discover?")) {
                    CommandProcessor.sysCmdDiscover(cmdLine.length >= 2 ? cmdLine[1] : null);
                    return true;
                }
                if (cmdLine[0].equals("#log")) {
                    CommandProcessor.sysCmdLog(env.expDouble(cmdLine[1]), cmdLine.length > 2 ? env.exp(cmdLine[2]) : "", true);
                    return true;
                }
                if (cmdLine[0].equals("#runscript")) {
                    CommandProcessor.sysCmdRunScript(env, cmdLine);
                    return true;
                }
                if (cmdLine[0].equals("#runscriptasync")) {
                    CommandProcessor.sysCmdRunScriptAsync(env, cmdLine);
                    return true;
                }
                if (cmdLine[0].equals("#scriptpriority")) {
                    CommandProcessor.sysCmdScriptPriority(env, cmdLine);
                    return true;
                }
                if (cmdLine[0].equals("#async")) {
                    CommandProcessor.sysCmdAsync(env, cmdLine);
                    return true;
                }
                if (cmdLine[0].equals("#asynccmd")) {
                    CommandProcessor.sysCmdAsyncCmd(env, cmdLine);
                    return true;
                }
                if (cmdLine[0].equals("#commandtime?")) {
                    DecimalFormat nf = new DecimalFormat("####0.00");
                    for (InterfaceThreads.DeviceThread dt : InterfaceThreads.getDevices()) {
                        String handle = dt.getHandleName();
                        long t = Var.gl.getAsLong(String.valueOf(handle) + ".commandTime", -1L);
                        long ts = Var.gl.getAsLong(String.valueOf(handle) + ".commandTimeSlowest", -1L);
                        long ta = Var.gl.getAsLong(String.valueOf(handle) + ".commandTimeAverage", -1L);
                        if (t <= 0L) continue;
                        InterfaceThreads.log(";; " + handle + "\t    last: " + StringUtil.formatRight(nf.format((double)t / 1000.0).replace(",", "."), 8, ' ') + " ms\t    average: " + StringUtil.formatRight(nf.format((double)ta / 1000.0).replace(",", "."), 8, ' ') + " ms\t    slowest: " + StringUtil.formatRight(nf.format((double)ts / 1000.0).replace(",", "."), 8, ' ') + " ms");
                    }
                    InterfaceThreads.threadCommander.sampleAllDevices(100);
                    return true;
                }
                if (cmdLine[0].equals("#debug")) {
                    int i = 2;
                    i = 2;
                    while (i < cmdLine.length) {
                        CommandProcessor.sysCmdDebug(cmdLine[1], cmdLine[i]);
                        ++i;
                    }
                    if (cmdLine.length != 2) return true;
                    CommandProcessor.sysCmdDebug(cmdLine[1], "");
                    return true;
                }
                if (cmdLine[0].equals("#trig")) {
                    env.restoreProgram = true;
                    CommandProcessor.sysCmdTrig(env, cmds);
                    return true;
                }
                if (cmdLine[0].equals("#trign")) {
                    InterfaceThreads.trigLogCount = env.expInt(cmdLine[1]);
                    return true;
                }
                if (cmdLine[0].equals("#haslogged")) {
                    CommandProcessor.sysCmdHasLogged();
                    return true;
                }
                if (cmdLine[0].equals("#delay")) {
                    env.restoreProgram = true;
                    CommandProcessor.sysCmdDelay(env, (long)(env.expDouble(cmdLine[1]) * 1000.0));
                    return true;
                }
                if (cmdLine[0].equals("#wait")) {
                    env.restoreProgram = true;
                    CommandProcessor.sysCmdWait(env, cmds.substring(5));
                    return true;
                }
                if (cmdLine[0].equals("#while")) {
                    env.restoreProgram = true;
                    CommandProcessor.sysCmdWhile(env, cmds.substring(7));
                    return true;
                }
                if (cmdLine[0].equals("#endwhile")) {
                    env.restoreProgram = true;
                    if (env.backgroundWhileStack.size() <= 0) return true;
                    env.backgroundProgramLine = env.backgroundWhileStack.pop();
                    return true;
                }
                if (cmdLine[0].equals("#foreach")) {
                    env.restoreProgram = true;
                    CommandProcessor.sysCmdForEach(env, cmdLine);
                    return true;
                }
                if (cmdLine[0].equals("#endforeach")) {
                    env.restoreProgram = true;
                    CommandProcessor.sysCmdEndForEach(env);
                    return true;
                }
                if (cmdLine[0].equals("#if")) {
                    env.restoreProgram = true;
                    CommandProcessor.sysCmdIf(env, cmds.substring(4));
                    return true;
                }
                if (cmdLine[0].equals("#elseif")) {
                    env.restoreProgram = true;
                    CommandProcessor.sysCmdElseIf(env, cmds.substring(8));
                    return true;
                }
                if (cmdLine[0].equals("#else")) {
                    env.restoreProgram = true;
                    CommandProcessor.sysCmdElse(env);
                    return true;
                }
                if (cmdLine[0].equals("#endif")) {
                    env.restoreProgram = true;
                    env.backgroundIfPerformed = false;
                    return true;
                }
                if (cmdLine[0].equals("#logcmds")) {
                    CommandProcessor.sysCmdLogCmds(env, env.expInt(cmdLine[1]) != 0);
                    env.restoreProgram = true;
                    return true;
                }
                if (cmdLine[0].equals("#charttitle")) {
                    String s = env.remaningExp(cmdLine, 1).trim();
                    Support.chartTitle = s.isEmpty() ? null : s;
                    return true;
                }
                if (cmdLine[0].equals("#chartscalename")) {
                    CommandProcessor.sysCmdChartScaleName(env, cmdLine);
                    return true;
                }
                if (cmdLine[0].equals("#chartcolors")) {
                    CommandProcessor.sysCmdChartColors(env, cmdLine);
                    return true;
                }
                if (cmdLine[0].equals("#chartbackground")) {
                    CommandProcessor.sysCmdChartBackground(env, cmdLine);
                    return true;
                }
                if (cmdLine[0].equals("#chartscalesync")) {
                    CommandProcessor.sysCmdChartScaleSync(env, cmdLine);
                    return true;
                }
                if (cmdLine[0].equals("#fontscale")) {
                    FontAdjust.setFontScale(env.expDouble(cmdLine[1]));
                    return true;
                }
                if (cmdLine[0].equals("#stopscript")) {
                    CommandProcessor.stopBackground();
                    return true;
                }
                if (cmdLine[0].equals("#return")) {
                    env.backgroundProgramLine = env.program.size();
                    return true;
                }
                if (cmdLine[0].equals("#x") && Support.devlop) {
                    PopupScriptList.getPopup();
                    return true;
                }
                if (cmdLine[0].equals("#screendump")) {
                    CommandProcessor.sysCmdScreenDump(env);
                    return true;
                }
                if (cmdLine[0].equals("#popupinit")) {
                    env.inputPopup = new InputPopup(env.script.getLocalVars(), env.exp(cmdLine[1]));
                    return true;
                }
                if (cmdLine[0].equals("#popuplabel")) {
                    env.inputPopup.addLabelInput(env.exp(cmdLine[1]), cmdLine.length >= 3 ? env.exp(cmdLine[2]) : null, cmdLine.length >= 4 ? env.exp(cmdLine[3]) : null);
                    return true;
                }
                if (cmdLine[0].equals("#popuptext")) {
                    env.inputPopup.addTextInput(env.exp(cmdLine[1]), env.exp(cmdLine[2]), cmdLine.length >= 4 ? env.expInt(cmdLine[3]) : 20, cmdLine.length >= 5 ? env.exp(cmdLine[5]) : null);
                    return true;
                }
                if (cmdLine[0].equals("#popupnumber")) {
                    env.inputPopup.addNumberInput(env.exp(cmdLine[1]), env.exp(cmdLine[2]), cmdLine.length >= 5 ? env.expDouble(cmdLine[3]) : -1.7976931348623157E308, cmdLine.length >= 5 ? env.expDouble(cmdLine[4]) : Double.MAX_VALUE, cmdLine.length >= 6 ? env.exp(cmdLine[5]) : null);
                    return true;
                }
                if (cmdLine[0].equals("#popupnumberlist")) {
                    env.inputPopup.addNumberListInput(env.exp(cmdLine[1]), env.exp(cmdLine[2]), cmdLine.length >= 5 ? env.expDouble(cmdLine[3]) : -1.7976931348623157E308, cmdLine.length >= 5 ? env.expDouble(cmdLine[4]) : Double.MAX_VALUE, cmdLine.length >= 6 ? env.exp(cmdLine[5]) : null);
                    return true;
                }
                if (cmdLine[0].equals("#popupnumberint")) {
                    env.inputPopup.addNumberIntInput(env.exp(cmdLine[1]), env.exp(cmdLine[2]), cmdLine.length >= 5 ? env.expLong(cmdLine[3]) : Long.MIN_VALUE, cmdLine.length >= 5 ? env.expLong(cmdLine[4]) : Long.MAX_VALUE, cmdLine.length >= 6 ? env.exp(cmdLine[5]) : null);
                    return true;
                }
                if (cmdLine[0].equals("#popupnumberintlist")) {
                    env.inputPopup.addNumberIntListInput(env.exp(cmdLine[1]), env.exp(cmdLine[2]), cmdLine.length >= 5 ? env.expLong(cmdLine[3]) : Long.MIN_VALUE, cmdLine.length >= 5 ? env.expLong(cmdLine[4]) : Long.MAX_VALUE, cmdLine.length >= 6 ? env.exp(cmdLine[5]) : null);
                    return true;
                }
                if (cmdLine[0].equals("#popupcombo")) {
                    CommandProcessor.sysCmdPopupRCL(RCL.combo, env, cmdLine);
                    return true;
                }
                if (cmdLine[0].equals("#popuplist")) {
                    CommandProcessor.sysCmdPopupRCL(RCL.list, env, cmdLine);
                    return true;
                }
                if (cmdLine[0].equals("#popupradio")) {
                    CommandProcessor.sysCmdPopupRCL(RCL.radio, env, cmdLine);
                    return true;
                }
                if (cmdLine[0].equals("#popupcolumn")) {
                    CommandProcessor.sysCmdPopupColumn(false, env, cmdLine);
                    return true;
                }
                if (cmdLine[0].equals("#popupdevice")) {
                    CommandProcessor.sysCmdPopupDevice(false, env, cmdLine);
                    return true;
                }
                if (cmdLine[0].equals("#popupvalue")) {
                    CommandProcessor.sysCmdPopupValue(false, env, cmdLine);
                    return true;
                }
                if (cmdLine[0].equals("#popupcheckbox")) {
                    env.inputPopup.addCheckboxInput(env.exp(cmdLine[1]), env.exp(cmdLine[2]), cmdLine.length >= 4 ? env.exp(cmdLine[3]) : null);
                    return true;
                }
                if (cmdLine[0].equals("#popupcolor")) {
                    CommandProcessor.sysCmdPopupColor(false, env, cmdLine);
                    return true;
                }
                if (cmdLine[0].equals("#popupfilename")) {
                    env.inputPopup.addFilenameInput(env.exp(cmdLine[1]), env.exp(cmdLine[2]), cmdLine.length >= 4 ? env.exp(cmdLine[3]) : null);
                    return true;
                }
                if (cmdLine[0].equals("#popupfile")) {
                    env.inputPopup.addFileInput(env.exp(cmdLine[1]), env.exp(cmdLine[2]), cmdLine.length >= 4 ? env.exp(cmdLine[3]) : null, cmdLine.length >= 5 ? env.exp(cmdLine[4]) : null, cmdLine.length >= 6 ? env.expBoolean(cmdLine[5]) : false, cmdLine.length >= 7 ? env.exp(cmdLine[6]) : null);
                    return true;
                }
                if (cmdLine[0].equals("#popupbutton")) {
                    env.inputPopup.addButton(env.exp(cmdLine[1]), env.exp(cmdLine[2]), cmdLine.length >= 4 ? env.exp(cmdLine[3]) : null);
                    return true;
                }
                if (cmdLine[0].equals("#popupimage")) {
                    CommandProcessor.sysCmdPopupImage(env, cmdLine);
                    return true;
                }
                if (cmdLine[0].equals("#popupbuttons")) {
                    env.inputPopup.addButton(env.exp(cmdLine[1]), env.exp(cmdLine[2]), cmdLine.length >= 4 ? env.exp(cmdLine[3]) : null, cmdLine.length >= 5 ? env.exp(cmdLine[4]) : null);
                    return true;
                }
                if (cmdLine[0].equals("#popupshow")) {
                    env.inputPopup.show(Main.main.frame, cmdLine.length >= 3 ? env.expInt(cmdLine[1]) : 30, cmdLine.length >= 3 ? env.expInt(cmdLine[2]) : 20);
                    return true;
                }
                if (cmdLine[0].equals("#popupshowinfo")) {
                    InputPopup.showInfo(Main.main.frame, env.exp(cmdLine[1]), cmdLine.length >= 3 ? env.expInt(cmdLine[2]) : 0);
                    return true;
                }
                if (cmdLine[0].equals("#popupshowinfoasync")) {
                    InputPopup.showInfoAsync(Main.main.frame, env.exp(cmdLine[1]), cmdLine.length >= 3 ? env.expInt(cmdLine[2]) : 0, cmdLine.length >= 4 ? (int)(env.expDouble(cmdLine[3]) * 1000.0) : 0);
                    return true;
                }
                if (cmdLine[0].equals("#popupshowquestion")) {
                    InputPopup.showQuestion(Main.main.frame, env.script.getLocalVars(), env.exp(cmdLine[1]), env.exp(cmdLine[2]), cmdLine.length >= 4 ? env.exp(cmdLine[3]) : null, cmdLine.length >= 5 ? env.exp(cmdLine[4]) : null, cmdLine.length >= 6 ? env.exp(cmdLine[5]) : null);
                    return true;
                }
                if (cmdLine[0].equals("#deviceloggingenable")) {
                    CommandProcessor.deviceLog(env, true, cmdLine);
                    return true;
                }
                if (cmdLine[0].equals("#deviceloggingdisable")) {
                    CommandProcessor.deviceLog(env, false, cmdLine);
                    return true;
                }
                if (cmdLine[0].equals("#") || cmdLine[0].matches("# *;.*") || env.syncCommand(cmdLine[0], cmdLine) || CommandProcessor.ignoredCommand(cmdLine[0]) != null) return true;
                InterfaceThreads.log(";; Invalid command <" + cmds + ">");
                return false;
            }
            catch (Exception e) {
                InterfaceThreads.log(";; " + cmds + " failed due to " + e.getMessage());
                if (!Support.devlop) return true;
                e.printStackTrace();
                return true;
            }
        } else if (cmds.startsWith("=") || env.commandLineCalcMode) {
            if (env.logCmds) {
                InterfaceThreads.log(cmds);
            } else {
                env.restoreProgram = true;
            }
            if (CommandProcessor.containDeviceHandle(cmds)) {
                InterfaceThreads.setupVars();
            }
            CommandProcessor.processCommandLineStatement(env, env.commandLineCalcMode ? cmds : cmds.substring(1));
            return true;
        } else {
            String devicePrefix = "";
            cmds = Support.processScriptInBrackets(env.script, cmds);
            String[] stringArray = cmds.split("[;]");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                InterfaceThreads.DeviceThread dt;
                String s;
                String line = stringArray[n2];
                int i = line.indexOf(58);
                if (i > 0 && InterfaceThreads.deviceMap.get((s = line.substring(0, i).trim()).toUpperCase()) != null) {
                    env.defaultDevice = InterfaceThreads.deviceMap.get(s.toUpperCase()).getHandleName();
                    devicePrefix = String.valueOf(env.defaultDevice) + ':';
                    line = line.substring(i + 1);
                }
                if ((dt = InterfaceThreads.deviceMap.get(env.defaultDevice.toUpperCase())) == null) {
                    InterfaceThreads.log(";; Invalid device <" + env.defaultDevice + ">");
                    return false;
                }
                if ((line.trim().length() > 0 || devicePrefix.length() > 0) && env.logCmds) {
                    InterfaceThreads.log(String.valueOf(devicePrefix) + line);
                }
                if (line.trim().length() == 0) {
                    return true;
                }
                DeviceInterface di = dt.getDeviceInterface();
                di.checkModifyColumns(line);
                String answer = di.doCommand(line);
                if (answer.length() > 0) {
                    InterfaceThreads.log(";; " + (answer == null ? "No answer" : answer));
                    Var.gl.getCreate(String.valueOf(dt.getHandleName()) + ".lastAnswer").set(answer);
                }
                ++n2;
            }
        }
        return true;
    }

    private static class BackgroundCommands
    extends Thread {
        private CmdEnvironment env;

        BackgroundCommands(CmdEnvironment env, List<String> program) {
            this.env = env;
            env.initProgram(program);
            this.setDaemon(true);
            this.setName("BackgroundCommands");
            this.start();
        }

        @Override
        public void run() {
            this.env.run();
        }
    }

    public static class CmdEnvironment {
        boolean logCmds = true;
        boolean stopRequest = false;
        List<String> program = null;
        int backgroundProgramLine = 0;
        Deque<Integer> backgroundWhileStack = new ArrayDeque<Integer>();
        Deque<ForEach> backgroundForEachStack = new ArrayDeque<ForEach>();
        InputPopup inputPopup = null;
        boolean backgroundIfPerformed = false;
        private Script script = new Script();
        boolean commandLineCalcMode = false;
        private String defaultDevice = "";
        boolean restoreProgram = false;
        boolean restoreOption = false;
        private Semaphore busy = new Semaphore(1);

        public void stop() {
            this.stopRequest = true;
            if (this.script != null) {
                this.script.stop();
            }
        }

        public String exp(String msg) {
            if (msg.length() >= 3 && msg.charAt(0) == '(' && msg.charAt(msg.length() - 1) == ')') {
                return this.script.expression(msg.substring(1, msg.length() - 1)).asString();
            }
            return msg;
        }

        public String expx(String msg) {
            if (msg.length() >= 3 && msg.charAt(0) == '(' && msg.charAt(msg.length() - 1) == ')') {
                return this.script.expression(msg.substring(1, msg.length() - 1)).asString();
            }
            return Support.unescapeFromCommandLine(msg);
        }

        public Var expVar(String msg) {
            if (msg.length() >= 3 && msg.charAt(0) == '(' && msg.charAt(msg.length() - 1) == ')') {
                return this.script.expression(msg.substring(1, msg.length() - 1)).cloneSimple();
            }
            return Var.createValueAuto(msg);
        }

        public List<String> expList(String msg) {
            ArrayList<String> list = new ArrayList<String>();
            Var v = this.expVar(msg);
            if (v.isArray()) {
                int j = 0;
                while (j < v.getSize()) {
                    list.add(StringUtil.unQuote(v.get(j).asString().trim()));
                    ++j;
                }
            } else {
                list.add(StringUtil.unQuote(v.asString().trim()));
            }
            return list;
        }

        public double expDouble(String msg) {
            if (msg.length() >= 3 && msg.charAt(0) == '(' && msg.charAt(msg.length() - 1) == ')') {
                return this.script.expression(msg.substring(1, msg.length() - 1)).asDouble();
            }
            return StringUtil.parseDoubleEE(msg);
        }

        public double expDoubleNaN(String msg) {
            if ((msg = this.exp(msg)).trim().length() == 0) {
                return Double.NaN;
            }
            return StringUtil.parseDoubleEE(msg);
        }

        public int expInt(String msg) {
            if (msg.length() >= 3 && msg.charAt(0) == '(' && msg.charAt(msg.length() - 1) == ')') {
                return this.script.expression(msg.substring(1, msg.length() - 1)).asInt();
            }
            return StringUtil.parseInt(msg);
        }

        public long expLong(String msg) {
            if (msg.length() >= 3 && msg.charAt(0) == '(' && msg.charAt(msg.length() - 1) == ')') {
                return this.script.expression(msg.substring(1, msg.length() - 1)).asLong();
            }
            return StringUtil.parseLong(msg);
        }

        public boolean expBoolean(String msg) {
            if (msg.length() >= 3 && msg.charAt(0) == '(' && msg.charAt(msg.length() - 1) == ')') {
                return this.script.expression(msg.substring(1, msg.length() - 1)).asBoolean();
            }
            return StringUtil.parseInt(msg) != 0;
        }

        public Color expColor(String msg) {
            if (msg.equals("-")) {
                return null;
            }
            if (!msg.matches("\\([0-9]+,[0-9]+,[0-9]+\\)") && msg.length() >= 3 && msg.charAt(0) == '(' && msg.charAt(msg.length() - 1) == ')') {
                Var v = this.script.expression(msg.substring(1, msg.length() - 1));
                if (v.isColor()) {
                    return v.asColor();
                }
                if (v.isInt()) {
                    return new Color(v.asInt());
                }
                ColorUtil.nameToColor(v.asString());
            }
            return ColorUtil.nameToColor(msg);
        }

        public String remaning(String[] param, int from) {
            StringBuilder sb = new StringBuilder();
            int i = from;
            while (i < param.length) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(param[i]);
                ++i;
            }
            return sb.toString().trim();
        }

        public String remaningExp(String[] param, int from) {
            StringBuilder sb = new StringBuilder();
            int i = from;
            while (i < param.length) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(this.exp(param[i]));
                ++i;
            }
            return sb.toString().trim();
        }

        public String getProgramLine(int line) {
            if (line < 0 || line >= this.program.size()) {
                return null;
            }
            return this.program.get(line);
        }

        public String getDeviceHandleLabel() {
            return this.commandLineCalcMode ? "#CALC" : String.valueOf(this.defaultDevice) + ":";
        }

        public String getDeviceHandle() {
            return this.defaultDevice;
        }

        public void setDeviceHandle(String handle) {
            this.defaultDevice = handle;
        }

        public void initProgram(List<String> program) {
            this.program = program;
            this.defaultDevice = "";
            this.restoreProgram = false;
            this.backgroundWhileStack.clear();
            this.stopRequest = false;
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            cmdEnvironments.add(this);
            try {
                block8: {
                    block7: {
                        this.backgroundProgramLine = 0;
                        if (!true) break block7;
                        if (this.backgroundProgramLine >= this.program.size()) return;
                        if (this.stopRequest) break block8;
                    }
                    do {
                        String line;
                        if ((line = this.getProgramLine(this.backgroundProgramLine++)) == null) {
                            return;
                        }
                        CommandProcessor.processCommands(this, line);
                        if (this.backgroundProgramLine >= this.program.size()) return;
                    } while (!this.stopRequest);
                }
                return;
            }
            finally {
                cmdEnvironments.remove(this);
            }
        }

        private void showParams(String[] params) {
            int i = 1;
            while (i < params.length) {
                InterfaceThreads.log(";; param " + i + " <" + params[i] + ">");
                ++i;
            }
        }

        private void showPopupSystem(String[] params) {
            if (params.length < 2) {
                return;
            }
            String name = this.exp(params[1]);
            PopupBase pb = null;
            Component pbf = null;
            if (name.equalsIgnoreCase("Calculator")) {
                if (PopupCalculator.reShow()) {
                    pb = PopupCalculator.getInstance();
                } else {
                    pb = new PopupCalculator();
                    pb.setLocation(Support.paneCommand.modeButton.getLocation());
                    pb.setVisible(true);
                }
            } else if (name.equalsIgnoreCase("Timer")) {
                if (PopupTimer.reShow()) {
                    pb = PopupTimer.getInstance();
                } else {
                    pb = new PopupTimer();
                    pb.setLocation(Support.paneCommand.modeButton.getLocation());
                    pb.setVisible(true);
                }
            } else if (name.equalsIgnoreCase("AdjustScale")) {
                pb = PopupAdjustScale.getPopup();
            } else if (name.equalsIgnoreCase("Alarm")) {
                pb = new PopupAlarm();
                pb.setLocation(Support.paneCommand.modeButton.getLocation());
                pb.setVisible(true);
            } else if (name.equalsIgnoreCase("ParamAdjuster")) {
                pb = PopupParamAdjuster.getPopup();
            } else if (name.equalsIgnoreCase("AutoHold")) {
                pb = PopupAutoHold.getPopup();
            } else if (name.equalsIgnoreCase("TimerCounter")) {
                pb = PopupTimerCounter.getPopup();
            } else if (name.equalsIgnoreCase("ParamSweeper")) {
                pbf = PopupParamSweeper.getPopup();
            } else if (name.equalsIgnoreCase("GridPanel")) {
                pbf = PopupGridPanel.getPopup();
            } else if (name.equalsIgnoreCase("VarDisplay")) {
                pb = new PopupVarDisplay(Support.paneCommand.modeButton.getLocation());
                pb.setVisible(true);
            } else if (name.equalsIgnoreCase("Image")) {
                pbf = PopupImage.getPopup();
                ((PopupImage)pbf).showDefault(false);
            } else if (name.equalsIgnoreCase("ScriptList")) {
                pbf = PopupScriptList.getPopup();
                ((PopupImage)pbf).showDefault(false);
            } else if (name.equalsIgnoreCase("LogTrigger")) {
                pb = new PopupLogTrigger();
                pb.setLocation(Support.paneCommand.modeButton.getLocation());
                pb.setVisible(true);
            } else if (name.equalsIgnoreCase("LogEvent")) {
                pb = PopupLogEvent.getPopup();
                pb.setLocation(Support.paneCommand.modeButton.getLocation());
                pb.setVisible(true);
            } else if (name.equalsIgnoreCase("FFTView")) {
                pbf = PopupFFTView.getPopup();
                ((Window)pbf).setLocation(Support.paneCommand.modeButton.getLocation());
                ((Window)pbf).setVisible(true);
            } else if (name.equalsIgnoreCase("MPPT")) {
                pbf = PopupMPPT.getPopup(-1);
                ((Window)pbf).setLocation(Support.paneCommand.modeButton.getLocation());
                ((Window)pbf).setVisible(true);
            } else if (name.equalsIgnoreCase("AutoAdjust")) {
                pb = PopupAutoAdjust.getPopup();
                pb.setLocation(Support.paneCommand.modeButton.getLocation());
                pb.setVisible(true);
            } else if (name.equalsIgnoreCase("Main") && params.length >= 3) {
                Main.main.frame.setLocation(this.expInt(params[2]), this.expInt(params[3]));
                if (params.length >= 5) {
                    Main.main.frame.setSize(this.expInt(params[4]), this.expInt(params[5]));
                }
            }
            if (pb != null) {
                if (params.length >= 5) {
                    pb.setOverrideLocation(this.expInt(params[2]), this.expInt(params[3]), StringUtil.parseInt(params[4]), StringUtil.parseInt(params[5]));
                } else if (params.length >= 3) {
                    pb.setOverrideLocation(this.expInt(params[2]), this.expInt(params[3]));
                }
                pb.repaint();
            } else if (pbf != null) {
                if (params.length >= 5) {
                    ((PopupBaseFrame)pbf).setOverrideLocation(this.expInt(params[2]), this.expInt(params[3]), StringUtil.parseInt(params[4]), StringUtil.parseInt(params[5]));
                } else if (params.length >= 3) {
                    ((PopupBaseFrame)pbf).setOverrideLocation(this.expInt(params[2]), this.expInt(params[3]));
                }
                pbf.repaint();
            }
        }

        private void closeAll() {
            InterfaceThreads.closeAll(true);
        }

        private void setAlarm(String[] params) {
            int n = 2;
            boolean on = true;
            if (params[n].equalsIgnoreCase("off")) {
                on = false;
                ++n;
            } else if (params[n].equalsIgnoreCase("on")) {
                ++n;
            }
            if (params.length == n + 2) {
                PopupAlarm.setAlarm(this.expInt(params[1]), on, this.expBoolean(params[n]), this.expBoolean(params[n + 1]));
            } else if (params.length == n + 3) {
                PopupAlarm.setAlarm(this.expInt(params[1]), on, this.expBoolean(params[n]), this.expBoolean(params[n + 1]), this.exp(params[n + 2]));
            } else if (params.length == n + 5) {
                PopupAlarm.setAlarm(this.expInt(params[1]), on, this.expBoolean(params[n]), this.expBoolean(params[n + 1]), this.exp(params[n + 2]), this.expDouble(params[n + 3]), this.expDouble(params[n + 4]));
            } else {
                InterfaceThreads.log(";; #SETALARM no outputOff retrig expression /{channel min max}");
            }
        }

        private void adjustAlarm(String[] params) {
            String s;
            StringBuilder sb = new StringBuilder();
            boolean quotesUsed = false;
            int i = 2;
            while (i < params.length) {
                s = params[i];
                if (s.indexOf(32) > 0 || PopupAlarm.isAdjustKeyword(s)) {
                    quotesUsed = true;
                }
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(s);
                ++i;
            }
            if (quotesUsed) {
                i = 2;
                while (i < params.length) {
                    s = params[i];
                    if (StringUtil.isInt(s)) {
                        PopupAlarm.adjustAlarm(this.expInt(params[1]), params[i]);
                    } else {
                        PopupAlarm.adjustAlarm(this.expInt(params[1]), s);
                    }
                    ++i;
                }
            } else if (sb.length() > 0) {
                PopupAlarm.adjustAlarm(this.expInt(params[1]), sb.toString());
            }
        }

        private void closeAlarm(String[] params) {
            String s = this.exp(params[1]);
            int n = 0;
            n = s.equalsIgnoreCase("all") ? -1 : StringUtil.parseInt(s);
            PopupAlarm.closeAlarm(n);
        }

        private void readout(String[] params) {
            PopupReadout pr = null;
            String name = "";
            if (params.length > 1) {
                name = this.exp(params[1]);
                pr = PopupReadout.getPopup(name);
            }
            if (pr == null) {
                pr = Support.paneCommand.showReadoutPopup();
                pr.getSettings().valueName = name;
            }
            if (params.length > 3) {
                pr.getSettings().x = this.expInt(params[2]);
                pr.getSettings().y = this.expInt(params[3]);
            }
            if (params.length > 4) {
                pr.getSettings().fontSize = this.expDouble(params[4]);
            }
            if (params.length > 5) {
                pr.getSettings().fc = ColorUtil.nameToColor(params[5]);
            }
            if (params.length > 6) {
                pr.getSettings().bc = ColorUtil.nameToColor(params[6]);
            }
            if (params.length > 7) {
                int alpha = this.expInt(params[7]);
                pr.getSettings().bc = new Color((float)pr.getSettings().bc.getRed() / 255.0f, (float)pr.getSettings().bc.getGreen() / 255.0f, (float)pr.getSettings().bc.getBlue() / 255.0f, (float)alpha / 255.0f);
            }
            if (params.length > 8) {
                String format = this.exp(params[8]);
                pr.setFormat(format);
            }
            pr.applySettings();
        }

        private void showPopupMode(String[] params) {
            if (InterfaceThreads.inInitialization() || params.length < 2) {
                return;
            }
            DeviceInterface di = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.exp(params[1]));
            if (di == null || !di.haveModesPopup()) {
                return;
            }
            PopupBase pb = di.showModesPopup(Support.paneCommand.modeButton);
            if (params.length == 3 && this.exp(params[2]).equalsIgnoreCase("onTop")) {
                pb.setOnTop(true);
            }
            if (params.length >= 4) {
                pb.setOverrideLocation(this.expInt(params[2]), this.expInt(params[3]));
                if (params.length == 5 && this.exp(params[4]).equalsIgnoreCase("onTop")) {
                    pb.setOnTop(true);
                }
            }
        }

        private void showPopupSetup(String[] params) {
            if (InterfaceThreads.inInitialization() || params.length < 2) {
                return;
            }
            DeviceInterface di = InterfaceThreads.getLoadedDeviceInterfaceHandle(this.exp(params[1]));
            if (di == null || !di.haveSetupPopup()) {
                return;
            }
            PopupBase pb = di.showSetupPopup(Support.paneCommand.modeButton);
            if (params.length == 3 && this.exp(params[2]).equalsIgnoreCase("onTop")) {
                pb.setOnTop(true);
            }
            if (params.length >= 4) {
                pb.setOverrideLocation(this.expInt(params[2]), this.expInt(params[3]));
                if (params.length == 5 && this.exp(params[4]).equalsIgnoreCase("onTop")) {
                    pb.setOnTop(true);
                }
            }
        }

        private void clear(String[] params) {
            if (params.length <= 1 || this.expInt(params[1]) == 0) {
                this.restoreProgram = true;
            }
            InterfaceThreads.clearLogBuffer();
            Support.paneCommand.clearLogWindow();
        }

        private void scale(String[] params) {
            if (params.length != 8 && params.length != 9 && params.length != 11) {
                return;
            }
            String name = this.exp(params[1]);
            ChartScales.ChartScale cs = Support.chartScales.getScale(name);
            cs.setDecimals(this.expInt(params[2]));
            cs.setSI(this.expInt(params[3]) != 0);
            cs.setLog(this.expInt(params[4]) != 0);
            cs.setAuto(this.expInt(params[5]) != 0);
            if (params.length == 8 && !cs.isAuto()) {
                cs.setMin(this.expDouble(params[6]));
                cs.setMax(this.expDouble(params[7]));
            } else if (params.length == 9 && cs.isAuto()) {
                cs.setAutoIncludeZero(this.expInt(params[6]) != 0);
                cs.setRange(this.expDouble(params[7]));
                cs.setBottomStep(this.expDouble(params[8]));
            } else if (params.length == 11) {
                cs.setAutoIncludeZero(this.expInt(params[6]) != 0);
                cs.setRange(this.expDouble(params[7]));
                cs.setBottomStep(this.expDouble(params[8]));
                cs.setMin(this.expDouble(params[9]));
                cs.setMax(this.expDouble(params[10]));
            }
        }

        private void scaleDelete(String[] params) {
            int i = 1;
            while (i < params.length) {
                String name = StringUtil.unQuote(this.exp(params[i]));
                if (name.endsWith(".")) {
                    Support.chartScales.removeMask(String.valueOf(name.substring(0, name.length() - 1)) + "\\..*");
                } else {
                    Support.chartScales.remove(name);
                }
                ++i;
            }
        }

        private void alignGrid(String[] params) {
            int pixels = 16;
            if (params.length >= 2) {
                pixels = this.expInt(params[1]);
            }
            if (pixels < 2) {
                pixels = 2;
            }
            if (pixels > 500) {
                pixels = 500;
            }
            if (InterfaceThreads.getDevices() != null) {
                for (InterfaceThreads.DeviceThread dt : InterfaceThreads.getDevices()) {
                    dt.getDeviceInterface().alignGridAll(pixels);
                }
            }
            Main.main.alignGrid(pixels);
            PopupAdjustScale.alignGridAll(pixels);
            PopupAlarm.alignGridAll(pixels);
            PopupCalculator.alignGridAll(pixels);
            PopupVarDisplay.alignGridAll(pixels);
            PopupLogTrigger.alignGridAll(pixels);
            PopupReadout.alignGridAll(pixels);
            PopupShowDevices.alignGridAll(pixels);
            PopupTestInterface.alignGridAll(pixels);
            PopupChart.alignGridAll(pixels);
            PopupTimer.alignGridAll(pixels);
            PopupImage.alignGridAll(pixels);
            PopupParamAdjuster.alignGridAll(pixels);
            PopupParamSweeper.alignGridAll(pixels);
            PopupGridPanel.alignGridAll(pixels);
            PopupAutoHold.alignGridAll(pixels);
            PopupScriptList.alignGridAll(pixels);
            PopupLogEvent.alignGridAll(pixels);
            PopupFFTView.alignGridAll(pixels);
            PopupMPPT.alignGridAll(pixels);
            PopupTimerCounter.alignGridAll(pixels);
            PopupAutoAdjust.alignGridAll(pixels);
        }

        private void chartCurves(String[] params) {
            ArrayList<String> list = new ArrayList<String>();
            int i = 1;
            while (i < params.length) {
                list.addAll(this.expList(params[i]));
                ++i;
            }
            if (list.size() > 0) {
                Support.paneChart.selectCurves(list);
            }
        }

        private void chartSamples(String[] params) {
            String s1 = params.length < 2 ? "" : this.exp(params[1]);
            String s2 = params.length < 3 ? "" : this.exp(params[2]);
            Support.paneChart.setSamples(StringUtil.unQuote(s1), StringUtil.unQuote(s2));
        }

        private void chartX(String[] params) {
            if (params.length < 2) {
                return;
            }
            Support.paneChart.setAxisX(this.exp(params[1]));
        }

        private void saveChart(String[] params) {
            if (params.length < 2) {
                return;
            }
            int w = Support.systemSettings.imageResolution[0].width;
            int h = Support.systemSettings.imageResolution[0].height;
            if (params.length >= 4) {
                w = this.expInt(params[2]);
                h = this.expInt(params[3]);
            }
            Support.paneChart.saveChart(StringUtil.unQuote(this.exp(params[1])), w, h);
        }

        private void saveLog(String[] params) {
            if (params.length < 2) {
                return;
            }
            String fname = StringUtil.unQuote(this.exp(params[1]));
            String type = "pgm";
            String menu = fname;
            if (params.length >= 3 && (type = StringUtil.unQuote(this.exp(params[2])).toLowerCase()).equals("menu")) {
                String s = "";
                int i = 3;
                while (i < params.length) {
                    s = String.valueOf(s) + params[i];
                    ++i;
                }
                if (s.length() > 0) {
                    menu = StringUtil.unQuote(this.exp(s)).toLowerCase();
                }
            }
            List<String> list = Support.paneCommand.getLogText();
            if (type.equals("raw") || type.equals("log")) {
                File f = Support.fileWithOptinalDefaults(fname, Support.getDataPath(), ".log");
                try {
                    FileUtil.writeFile(f, list);
                }
                catch (IOException iOException) {}
            } else if (type.equals("pgm") || type.equals("program")) {
                Support.paneCommand.removeDoubleComments(list);
                File f = Support.fileWithOptinalDefaults(fname, Support.getDataPath(), ".txt");
                try {
                    FileUtil.writeFile(f, list);
                }
                catch (IOException iOException) {}
            } else if (type.equals("menu")) {
                Support.paneCommand.removeDoubleComments(list);
                Support.paneCommand.scriptMenu.saveScript(fname, menu, list, false);
                Support.paneCommand.makeListPanelPopup();
            }
        }

        private void syncPopups() {
            for (InterfaceThreads.DeviceThread dt : InterfaceThreads.getDevices()) {
                dt.getDeviceInterface().syncPopup();
            }
        }

        private void currentValuesOptions(String[] params) {
            int i = 1;
            while (i < params.length) {
                String s = this.exp(params[i].toLowerCase());
                if (StringUtil.isInt(s)) {
                    Support.paneCurrentValues.setSamples(StringUtil.parseInt(s));
                } else if (s.equals("large")) {
                    Support.paneCurrentValues.setLarge(true);
                } else if (s.equals("small")) {
                    Support.paneCurrentValues.setLarge(false);
                } else if (s.equals("/s") || s.equals("s")) {
                    Support.paneCurrentValues.setSlope('s');
                } else if (s.equals("/m") || s.equals("m")) {
                    Support.paneCurrentValues.setSlope('m');
                } else if (s.equals("/h") || s.equals("h")) {
                    Support.paneCurrentValues.setSlope('h');
                }
                ++i;
            }
        }

        private void histogramCurves(String[] params) {
            ArrayList<String> list = new ArrayList<String>();
            int i = 1;
            while (i < params.length) {
                list.add(StringUtil.unQuote(this.exp(params[i])).trim());
                ++i;
            }
            if (list.size() > 0) {
                Support.paneHistogram.selectCurves(list);
            }
        }

        private void histogramSamples(String[] params) {
            String s1 = params.length < 2 ? "" : this.exp(params[1]);
            String s2 = params.length < 3 ? "" : this.exp(params[2]);
            Support.paneHistogram.setSamples(StringUtil.unQuote(s1), StringUtil.unQuote(s2));
        }

        private void histogramOptions(String[] params) {
            int i = 1;
            while (i < params.length) {
                String s = this.exp(params[i].toLowerCase());
                if (StringUtil.isInt(s)) {
                    Support.paneHistogram.setBins(StringUtil.parseInt(s));
                } else if (s.equals("%") || s.equals("percent")) {
                    Support.paneHistogram.setPercent(true);
                } else if (s.equals("count")) {
                    Support.paneHistogram.setPercent(false);
                }
                ++i;
            }
        }

        private void saveHistogram(String[] params) {
            if (params.length < 2) {
                return;
            }
            int w = Support.systemSettings.imageResolution[0].width;
            int h = Support.systemSettings.imageResolution[0].height;
            if (params.length >= 4) {
                w = this.expInt(params[2]);
                h = this.expInt(params[3]);
            }
            Support.paneHistogram.saveChart(StringUtil.unQuote(this.exp(params[1])), w, h);
        }

        private void rangeSamples(String[] params) {
            String s1 = params.length < 2 ? "" : this.exp(params[1]);
            String s2 = params.length < 3 ? "" : this.exp(params[2]);
            Support.paneRange.setRange(StringUtil.unQuote(s1), StringUtil.unQuote(s2));
        }

        private void rangeOptions(String[] params) {
            int i = 1;
            while (i < params.length) {
                String s = this.exp(params[i].toLowerCase());
                if (StringUtil.isInt(s)) {
                    Support.paneHistogram.setBins(StringUtil.parseInt(s));
                } else if (s.equals("/s") || s.equals("s")) {
                    Support.paneRange.setSlope('s');
                } else if (s.equals("/m") || s.equals("m")) {
                    Support.paneRange.setSlope('m');
                } else if (s.equals("/h") || s.equals("h")) {
                    Support.paneRange.setSlope('h');
                }
                ++i;
            }
        }

        private void exportColumns(String[] params) {
            ArrayList<String> columns = new ArrayList<String>();
            int i = 1;
            while (i < params.length) {
                Var v = this.expVar(params[i]);
                if (v.isArray()) {
                    int j = 0;
                    while (j < v.getSize()) {
                        columns.add(v.get(j).asString());
                        ++j;
                    }
                } else {
                    columns.add(v.asString());
                }
                ++i;
            }
            Exporter.getExporter().setColumns(columns);
            Support.updateExport();
        }

        private void exportColumnsExclude(String[] params) {
            ArrayList<String> columns = new ArrayList<String>();
            int i = 1;
            while (i < params.length) {
                Var v = this.expVar(params[i]);
                if (v.isArray()) {
                    int j = 0;
                    while (j < v.getSize()) {
                        columns.add(v.get(j).asString());
                        ++j;
                    }
                } else {
                    columns.add(v.asString());
                }
                ++i;
            }
            Exporter.getExporter().setColumnsExclude(columns);
            Support.updateExport();
        }

        private void exportColumn(String[] params) {
            if (params.length < 2) {
                return;
            }
            String column = this.exp(params[1]);
            String newName = params.length >= 3 ? this.exp(params[2]) : null;
            String format = params.length >= 4 ? this.exp(params[3]) : null;
            String customFormat = params.length >= 5 ? this.exp(params[4]) : null;
            Exporter.getExporter().setColumn(column, newName, format, customFormat);
            Support.updateExport();
        }

        private void exportSamples(String[] params) {
            String s1 = params.length < 2 ? "" : this.exp(params[1]);
            String s2 = params.length < 3 ? "" : this.exp(params[2]);
            Exporter.getExporter().setRange(StringUtil.unQuote(s1), StringUtil.unQuote(s2));
            Support.updateExport();
        }

        private void loadExportFormat(String[] params) {
            if (params.length < 2) {
                return;
            }
            String fname = this.exp(params[1]);
            Exporter.getExporter().loadFormatFromFile(Support.fileWithOptinalDefaults(fname, Support.getDataPath(), ".txt"));
            Support.updateExport();
        }

        private void exportReduce(String[] params) {
            if (params.length < 2) {
                return;
            }
            String format = this.exp(params[1]);
            if (format.equalsIgnoreCase("AllData")) {
                Exporter.getExporter().setReduceFormat(Exporter.ReduceFormat.AllData);
            } else if (format.equalsIgnoreCase("ReduceBySampling") && params.length >= 3) {
                Exporter.getExporter().setReduceFormat(Exporter.ReduceFormat.ReduceBySampling);
                Exporter.getExporter().setSamples(this.expInt(params[2]));
            } else if (format.equalsIgnoreCase("ReduceByAveraging") && params.length >= 3) {
                Exporter.getExporter().setReduceFormat(Exporter.ReduceFormat.ReduceByAveraging);
                Exporter.getExporter().setSamples(this.expInt(params[2]));
            } else if (format.equalsIgnoreCase("ReduceOnChange") && params.length >= 4) {
                String column = this.exp(params[2]);
                if (Support.dataBase.header().getIndex(column) < 0) {
                    return;
                }
                Exporter.getExporter().setReduceFormat(Exporter.ReduceFormat.ReduceOnChange);
                Exporter.getExporter().setChangeColumn(column);
                Exporter.getExporter().setChangeValue(this.expDouble(params[3]));
            } else if (format.equalsIgnoreCase("ReduceByFormula") && params.length >= 3) {
                Exporter.getExporter().setReduceFormat(Exporter.ReduceFormat.ReduceByFormula);
                Exporter.getExporter().setFormula(this.remaning(params, 2));
            }
            Support.updateExport();
        }

        private void exportTable(String[] params) {
            if (params.length < 2) {
                return;
            }
            String fname = this.exp(params[1]);
            if (params.length >= 3) {
                String format = this.exp(params[2]);
                if (format.equals(",;")) {
                    Support.dataBase.setFileFormat(DataBase.FileFormat.euro);
                } else if (format.equals(".,")) {
                    Support.dataBase.setFileFormat(DataBase.FileFormat.us);
                } else if (format.equalsIgnoreCase("tab")) {
                    Support.dataBase.setFileFormat(DataBase.FileFormat.tab);
                } else if (format.equalsIgnoreCase("ctab")) {
                    Support.dataBase.setFileFormat(DataBase.FileFormat.ctab);
                }
            }
            try {
                Exporter.getExporter().export(Support.fileWithOptinalDefaults(fname, Support.getDataPath(), ".csv"));
            }
            catch (IOException iOException) {
                InterfaceThreads.log(";; *** Error *** #ExportTable failed");
            }
        }

        private void exportInit(String[] params) {
            Support.clearExporter();
        }

        private void exportTableReload() {
            if (!InterfaceThreads.isLoggingToDisk()) {
                Exporter.getExporter().exportReload();
            }
        }

        private void valueFormat(String[] params) {
            if (params.length <= 2) {
                return;
            }
            String columnName = params[1];
            ValueFormat.ValueFormatter fmt = ValueFormat.getFormatter(params[2]);
            Support.paneTable.setDecimals(columnName, fmt);
            int i = columnName.indexOf(46);
            String handle = "";
            if (i > 0) {
                handle = columnName.substring(0, i);
                ValueFormat vf = null;
                if (handle.equalsIgnoreCase("Math")) {
                    vf = Support.math.getValueFormat(columnName.substring(i + 1));
                } else {
                    DeviceInterface di = InterfaceThreads.findDeviceInterfaceAnyHandle(handle);
                    if (di != null) {
                        vf = di.getValueFormat(columnName.substring(i + 1));
                    }
                }
                if (vf != null) {
                    vf.format = fmt;
                }
            }
        }

        private void setParamAdjuster(String[] params) {
            switch (params.length) {
                case 3: {
                    PopupParamAdjuster.setParams(this.expInt(params[1]), this.exp(params[2]), null, null, null);
                    break;
                }
                case 5: {
                    PopupParamAdjuster.setParams(this.expInt(params[1]), this.exp(params[2]), this.expDouble(params[3]), this.expDouble(params[4]), null);
                    break;
                }
                case 6: {
                    PopupParamAdjuster.setParams(this.expInt(params[1]), this.exp(params[2]), this.expDouble(params[3]), this.expDouble(params[4]), this.exp(params[5]));
                }
            }
        }

        private void closeParamAdjuster(String[] params) {
            if (params.length <= 1) {
                return;
            }
            PopupParamAdjuster.closePopup(this.expInt(params[1]));
        }

        private void closeParamSweeper(String[] params) {
            PopupParamSweeper.closePopup();
        }

        private void setParamSweeper(String[] params) {
            PopupParamSweeper.setParamSweeper(this, params);
        }

        private void showImage(String[] params) {
            PopupImage pi = PopupImage.getPopup();
            boolean showFirstImage = true;
            int i = 1;
            while (i < params.length) {
                String s = this.exp(params[i]);
                if (s.equals("-")) {
                    showFirstImage = false;
                } else {
                    pi.addImage(s);
                }
                ++i;
            }
            if (showFirstImage) {
                pi.setShowFirstLoaded();
            }
            pi.showDefault(params.length <= 1);
        }

        private double pDouble(String[] params, int index, double def) {
            if (params.length <= index || params[index].equals("-")) {
                return def;
            }
            return this.expDouble(params[index]);
        }

        private double pDouble(String[] params, int index) {
            if (params.length <= index) {
                throw new RuntimeException("Required parameter missing");
            }
            return this.expDouble(params[index]);
        }

        private int pInt(String[] params, int index, int def) {
            if (params.length <= index) {
                return def;
            }
            return this.expInt(params[index]);
        }

        private int pInt(String[] params, int index) {
            if (params.length <= index) {
                throw new RuntimeException("Required parameter missing");
            }
            return this.expInt(params[index]);
        }

        private Boolean pBoolean(String[] params, int index, Boolean def) {
            if (params.length <= index || params[index].equals("-")) {
                return def;
            }
            return this.expBoolean(params[index]);
        }

        private String pString(String[] params, int index, String def) {
            if (params.length <= index) {
                return def;
            }
            return this.exp(params[index]);
        }

        private String pxString(String[] params, int index) {
            if (params.length <= index) {
                throw new RuntimeException("Required parameter missing");
            }
            return this.expx(params[index]);
        }

        private String pString(String[] params, int index) {
            if (params.length <= index) {
                throw new RuntimeException("Required parameter missing");
            }
            return this.exp(params[index]);
        }

        private boolean pBoolean(String[] params, int index) {
            if (params.length <= index) {
                throw new RuntimeException("Required parameter missing");
            }
            return this.expInt(params[index]) != 0;
        }

        private double[] pArray(String[] params, int index, double x0, double y0) {
            if (params.length <= index) {
                throw new RuntimeException("Required parameter missing");
            }
            Var points = this.script.expression(params[index]);
            double[] pp = new double[points.getSize() / 2 * 2];
            int i = 0;
            while (i < points.getSize() / 2) {
                pp[i * 2] = points.getValue(i * 2).asDouble() + x0;
                pp[i * 2 + 1] = points.getValue(i * 2 + 1).asDouble() + y0;
                ++i;
            }
            return pp;
        }

        private Color pColor(String[] params, int index, Color def) {
            if (params.length <= index) {
                return def;
            }
            if (params[index].equals("-")) {
                return def;
            }
            return this.expColor(params[index]);
        }

        private void parseAnnotations(ChartAnnotations annotations, String[] params) {
            String type;
            if (params.length < 2) {
                annotations.clear();
                return;
            }
            int n = 1;
            String axis = null;
            if (params.length >= n + 1 && params[n].startsWith("+")) {
                params[n] = params[n].substring(1);
                axis = this.pString(params, n++);
            }
            if ((type = this.pString(params, n++).toLowerCase()).equalsIgnoreCase("line")) {
                double x1 = this.pDouble(params, n++);
                double y1 = this.pDouble(params, n++);
                double x2 = this.pDouble(params, n++);
                double y2 = this.pDouble(params, n++);
                Color c = this.pColor(params, n++, null);
                double w = this.pDouble(params, n++, 0.0);
                String style = this.pString(params, n++, null);
                annotations.add(new ChartAnnotations.AnnoLine(axis, x1, y1, x2, y2, w, c, style));
            } else if (type.equalsIgnoreCase("liney")) {
                double y = this.pDouble(params, n++);
                Color c = this.pColor(params, n++, null);
                double w = this.pDouble(params, n++, 0.0);
                String style = this.pString(params, n++, null);
                annotations.add(new ChartAnnotations.AnnoLineY(axis, y, w, c, style));
            } else if (type.equalsIgnoreCase("linex")) {
                double x = this.pDouble(params, n++);
                Color c = this.pColor(params, n++, null);
                double w = this.pDouble(params, n++, 0.0);
                String style = this.pString(params, n++, null);
                annotations.add(new ChartAnnotations.AnnoLineX(axis, x, w, c, style));
            } else if (type.equalsIgnoreCase("arrow")) {
                String msg = this.pString(params, n++);
                double x = this.pDouble(params, n++);
                double y = this.pDouble(params, n++);
                double a = this.pDouble(params, n++);
                Color c = this.pColor(params, n++, null);
                int sz = this.pInt(params, n++, 2);
                Color cb = this.pColor(params, n++, null);
                annotations.add(new ChartAnnotations.AnnoArrow(axis, msg, x, y, a, c, sz, cb));
            } else if (type.equalsIgnoreCase("value")) {
                double x = this.pDouble(params, n++);
                double a = this.pDouble(params, n++);
                Color c = this.pColor(params, n++, null);
                int sz = this.pInt(params, n++, 2);
                Color cb = this.pColor(params, n++, null);
                annotations.add(new ChartAnnotations.AnnoValue(axis, x, a, c, sz, cb));
            } else if (type.equalsIgnoreCase("text")) {
                String msg = this.pString(params, n++);
                String anchor = this.pString(params, n++);
                double x = this.pDouble(params, n++);
                double y = this.pDouble(params, n++);
                Color c = this.pColor(params, n++, null);
                int sz = this.pInt(params, n++, 2);
                Color cb = this.pColor(params, n++, null);
                annotations.add(new ChartAnnotations.AnnoText(axis, msg, anchor, x, y, c, sz, cb));
            } else if (type.equalsIgnoreCase("circle")) {
                double x = this.pDouble(params, n++);
                double y = this.pDouble(params, n++);
                double rx = this.pDouble(params, n++);
                double ry = this.pDouble(params, n++);
                Color c = this.pColor(params, n++, null);
                double w = this.pDouble(params, n++, 0.0);
                String style = this.pString(params, n++, null);
                Color cb = this.pColor(params, n++, null);
                annotations.add(new ChartAnnotations.AnnoCircle(axis, x, y, rx, ry, c, w, style, cb));
            } else if (type.equalsIgnoreCase("box")) {
                double x = this.pDouble(params, n++);
                double y = this.pDouble(params, n++);
                double rx = this.pDouble(params, n++);
                double ry = this.pDouble(params, n++);
                Color c = this.pColor(params, n++, null);
                double w = this.pDouble(params, n++, 0.0);
                String style = this.pString(params, n++, null);
                Color cb = this.pColor(params, n++, null);
                annotations.add(new ChartAnnotations.AnnoBox(axis, x, y, rx, ry, c, w, style, cb));
            } else if (type.equalsIgnoreCase("boxrounded")) {
                double x = this.pDouble(params, n++);
                double y = this.pDouble(params, n++);
                double rx = this.pDouble(params, n++);
                double ry = this.pDouble(params, n++);
                Color c = this.pColor(params, n++, null);
                double w = this.pDouble(params, n++, 0.0);
                String style = this.pString(params, n++, null);
                Color cb = this.pColor(params, n++, null);
                annotations.add(new ChartAnnotations.AnnoBoxRounded(axis, x, y, rx, ry, c, w, style, cb));
            } else if (type.equalsIgnoreCase("polygon")) {
                double x0 = this.pDouble(params, n++);
                double y0 = this.pDouble(params, n++);
                double[] p = this.pArray(params, n++, x0, y0);
                Color c = this.pColor(params, n++, null);
                double w = this.pDouble(params, n++, 0.0);
                String style = this.pString(params, n++, null);
                Color cb = this.pColor(params, n++, null);
                annotations.add(new ChartAnnotations.AnnoPolygon(axis, p, c, w, style, cb));
            } else if (type.equalsIgnoreCase("shape")) {
                double x0 = this.pDouble(params, n++);
                double y0 = this.pDouble(params, n++);
                double[] p = this.pArray(params, n++, x0, y0);
                Color c = this.pColor(params, n++, null);
                double w = this.pDouble(params, n++, 0.0);
                String style = this.pString(params, n++, null);
                Color cb = this.pColor(params, n++, null);
                annotations.add(new ChartAnnotations.AnnoShape(axis, p, c, w, style, cb));
            } else if (type.equalsIgnoreCase("polyline")) {
                double x0 = this.pDouble(params, n++);
                double y0 = this.pDouble(params, n++);
                double[] p = this.pArray(params, n++, x0, y0);
                Color c = this.pColor(params, n++, null);
                double w = this.pDouble(params, n++, 0.0);
                String style = this.pString(params, n++, null);
                annotations.add(new ChartAnnotations.AnnoPolyline(axis, p, c, w, style));
            } else if (type.equalsIgnoreCase("curve")) {
                double x0 = this.pDouble(params, n++);
                double y0 = this.pDouble(params, n++);
                double[] p = this.pArray(params, n++, x0, y0);
                Color c = this.pColor(params, n++, null);
                double w = this.pDouble(params, n++, 0.0);
                String style = this.pString(params, n++, null);
                annotations.add(new ChartAnnotations.AnnoCurve(axis, p, c, w, style));
            }
            PopupChartLayout.updateAnnotations();
        }

        private void chartAnnotate(String[] params) {
            this.parseAnnotations(Support.paneChart.annotations, params);
        }

        private void histogramAnnotate(String[] params) {
            this.parseAnnotations(Support.paneHistogram.annotations, params);
        }

        private void gridPanel(String[] params, boolean single) {
            BasicPanel bp;
            PopupGridPanel gridPanel;
            int x = 0;
            int y = 0;
            int w = 0;
            int h = 0;
            PopupGridPanel popupGridPanel = gridPanel = single ? null : PopupGridPanel.getPopup();
            if (params.length < 2) {
                if (!single) {
                    gridPanel.removeAllPanels();
                }
                return;
            }
            int n = 1;
            if (!single && params.length >= 3 && StringUtil.isInt(params[1]) && StringUtil.isInt(params[2])) {
                gridPanel.setPanelGrid(StringUtil.parseInt(params[1]), StringUtil.parseInt(params[2]));
                return;
            }
            if (params.length > 5 && StringUtil.isInt(params[1]) && StringUtil.isInt(params[2]) && StringUtil.isInt(params[3]) && StringUtil.isInt(params[4])) {
                x = this.pInt(params, n++);
                y = this.pInt(params, n++);
                w = this.pInt(params, n++);
                h = this.pInt(params, n++);
            }
            if ((bp = PopupGridPanel.createPanel(this.pString(params, n++))) == null) {
                return;
            }
            BasicPanel.ParamsSet paramsSet = bp.getParamsSet();
            int i = 0;
            while (i < paramsSet.getNChannels()) {
                paramsSet.addChannel(this.pxString(params, n++));
                ++i;
            }
            while (n < params.length && paramsSet.add(this.pString(params, n))) {
                ++n;
            }
            while (n < params.length) {
                paramsSet.addColor(this.pColor(params, n++, null));
            }
            bp.setParams(paramsSet);
            if (single) {
                PopupGridPanel.createSinglePanel(x, y, w, h, bp);
            } else {
                gridPanel.addPanel(bp);
            }
        }

        private void chartReset() {
            Support.chartTitle = null;
            Support.chartLineColor = Arrays.copyOf(Support.InitialChartLineColor, Support.InitialChartLineColor.length);
            Support.chartColor = new Color(192, 192, 192);
            Support.chartBorderColor = Color.white;
            Support.chartGridColor = new Color(255, 255, 255);
            Support.chartFontColor = Color.BLACK;
            Support.chartHeaderColor = Color.black;
            Support.chartScales.resetOverrides();
            Support.chartScales.disableSync();
        }

        private void setLogEvent(String[] params) {
            int n = 1;
            double iTime = this.pDouble(params, n++);
            double fTime = this.pDouble(params, n++);
            double interval = this.pDouble(params, n++);
            String mode = this.pString(params, n++).toLowerCase();
            double time = 0.0;
            String channel = "";
            double min = -1.7976931348623157E308;
            double max = Double.MAX_VALUE;
            String exp = "";
            if (mode.equals("minmax")) {
                channel = this.pString(params, n++);
                min = this.pDouble(params, n++);
                max = this.pDouble(params, n++);
            } else if (mode.equals("time")) {
                time = this.pDouble(params, n++);
            } else if (mode.equals("exp")) {
                exp = this.pString(params, n++);
            }
            PopupLogEvent.setParams(iTime, fTime, interval, mode, time, channel, min, max, exp);
        }

        private void setLogEventCmds(String[] params) {
            PopupLogEvent.setCmds(true, Support.unescapeFromCommandLine(params[1]));
            PopupLogEvent.setCmds(false, Support.unescapeFromCommandLine(params[2]));
        }

        private void FFTView(String[] params) {
            if (params.length < 2) {
                return;
            }
            PopupFFTView fftView = PopupFFTView.getPopup();
            int n = 1;
            fftView.setChannel(this.pString(params, n++));
            if (params.length > 2) {
                fftView.setFreq(this.pDouble(params, n++, 0.0), this.pDouble(params, n++, 1.0E101));
                if (params.length > 4) {
                    fftView.setOption(this.pString(params, n++));
                }
                if (params.length > 5) {
                    fftView.setOption(this.pString(params, n++));
                }
                if (params.length > 6) {
                    fftView.setOption(this.pString(params, n++));
                }
            }
            fftView.setControls();
        }

        private void setMPPT(String[] params) {
            int n = 1;
            if (params.length < 3) {
                return;
            }
            int no = this.pInt(params, n++, -1);
            PopupMPPT pop = PopupMPPT.getPopup(no);
            String channel = this.pString(params, n++, "");
            double stepCurrent = this.pDouble(params, n++, pop.getStepCurrent());
            double maxCurrent = this.pDouble(params, n++, pop.getMaxCurrent());
            double minVoltage = this.pDouble(params, n++, pop.getMinVoltage());
            double updateSpeed = this.pDouble(params, n++, pop.getUpdateSpeed());
            boolean active = this.pInt(params, n++, pop.isActive() ? 1 : 0) != 0;
            pop.setParams(channel, stepCurrent, maxCurrent, minVoltage, updateSpeed, active);
        }

        private void setAutoAdjust(String[] params) {
            int n = 1;
            if (params.length < 8) {
                return;
            }
            String controlChannel = this.pString(params, n++);
            double minRange = this.pDouble(params, n++);
            double maxRange = this.pDouble(params, n++);
            double minChange = this.pDouble(params, n++);
            double updateSpeed = this.pDouble(params, n++);
            String targetChannel = this.pString(params, n++);
            String target = this.pString(params, n++);
            PopupAutoAdjust pop = PopupAutoAdjust.getPopup();
            pop.setParams(StringUtil.unQuote(controlChannel), minRange, maxRange, minChange, updateSpeed, StringUtil.unQuote(targetChannel), target);
        }

        private void setTimerCounter(String[] params) {
            if (params.length < 2) {
                return;
            }
            int n = 1;
            String channel = this.pString(params, n++, null);
            double threshold = this.pDouble(params, n++, Double.NaN);
            double tol = this.pDouble(params, n++, Double.NaN);
            Boolean onIsLow = this.pBoolean(params, n++, null);
            Boolean useTable = this.pBoolean(params, n++, null);
            PopupTimerCounter.set(channel, threshold, tol, onIsLow, useTable);
        }

        private void autoHold(String[] params) {
            if (params.length < 2) {
                return;
            }
            int n = 1;
            String channel = this.pString(params, n++, null);
            double tol = this.pDouble(params, n++, Double.NaN) / 100.0;
            double time = this.pDouble(params, n++, Double.NaN);
            double min = this.pDouble(params, n++, Double.NaN);
            PopupAutoHold.set(channel, tol, time, min);
        }

        private SyncCommands findCommand(String cmd) {
            SyncCommands[] syncCommandsArray = SyncCommands.values();
            int n = syncCommandsArray.length;
            int n2 = 0;
            while (n2 < n) {
                SyncCommands sc = syncCommandsArray[n2];
                if (sc.name().equalsIgnoreCase(cmd)) {
                    return sc;
                }
                ++n2;
            }
            return null;
        }

        private void doCommand(SyncCommands sc, String[] params) {
            switch (sc) {
                case ShowParams: {
                    this.showParams(params);
                    break;
                }
                case ShowPopupSystem: {
                    this.showPopupSystem(params);
                    break;
                }
                case Readout: {
                    this.readout(params);
                    break;
                }
                case AdjustAlarm: {
                    this.adjustAlarm(params);
                    break;
                }
                case SetAlarm: {
                    this.setAlarm(params);
                    break;
                }
                case CloseAlarm: {
                    this.closeAlarm(params);
                }
                case CloseAll: {
                    this.closeAll();
                    break;
                }
                case ShowPopupSetup: {
                    this.showPopupSetup(params);
                    break;
                }
                case ShowPopupMode: {
                    this.showPopupMode(params);
                    break;
                }
                case Clear: {
                    this.clear(params);
                    break;
                }
                case Scale: {
                    this.scale(params);
                    break;
                }
                case ScaleDelete: {
                    this.scaleDelete(params);
                    break;
                }
                case AlignGrid: {
                    this.alignGrid(params);
                    break;
                }
                case ChartCurves: {
                    this.chartCurves(params);
                    break;
                }
                case ChartSamples: {
                    this.chartSamples(params);
                    break;
                }
                case ChartY: 
                case ChartX: {
                    this.chartX(params);
                    break;
                }
                case SaveChart: {
                    this.saveChart(params);
                    break;
                }
                case SaveLog: {
                    this.saveLog(params);
                    break;
                }
                case SyncPopups: {
                    this.syncPopups();
                    break;
                }
                case CurrentValuesOptions: {
                    this.currentValuesOptions(params);
                    break;
                }
                case HistogramCurves: {
                    this.histogramCurves(params);
                    break;
                }
                case HistogramSamples: {
                    this.histogramSamples(params);
                    break;
                }
                case HistogramOptions: {
                    this.histogramOptions(params);
                    break;
                }
                case SaveHistogram: {
                    this.saveHistogram(params);
                    break;
                }
                case RangeSamples: {
                    this.rangeSamples(params);
                    break;
                }
                case RangeOptions: {
                    this.rangeOptions(params);
                    break;
                }
                case ExportColumns: {
                    this.exportColumns(params);
                    break;
                }
                case ExportColumnsExclude: {
                    this.exportColumnsExclude(params);
                    break;
                }
                case ExportColumn: {
                    this.exportColumn(params);
                    break;
                }
                case ExportSamples: {
                    this.exportSamples(params);
                    break;
                }
                case LoadExportFormat: {
                    this.loadExportFormat(params);
                    break;
                }
                case ExportReduce: {
                    this.exportReduce(params);
                    break;
                }
                case ExportTable: {
                    this.exportTable(params);
                    break;
                }
                case ExportInit: {
                    this.exportInit(params);
                    break;
                }
                case ExportTableReload: {
                    this.exportTableReload();
                    break;
                }
                case ValueFormat: {
                    this.valueFormat(params);
                    break;
                }
                case SetParamAdjuster: {
                    this.setParamAdjuster(params);
                }
                case CloseParamAdjuster: {
                    this.closeParamAdjuster(params);
                    break;
                }
                case ShowImage: {
                    this.showImage(params);
                    break;
                }
                case CloseParamSweeper: {
                    this.closeParamSweeper(params);
                    break;
                }
                case SetParamSweeper: {
                    this.setParamSweeper(params);
                    break;
                }
                case ChartAnnotate: {
                    this.chartAnnotate(params);
                    break;
                }
                case HistogramAnnotate: {
                    this.histogramAnnotate(params);
                    break;
                }
                case GridPanel: {
                    this.gridPanel(params, false);
                    break;
                }
                case SinglePanel: {
                    this.gridPanel(params, true);
                    break;
                }
                case AutoHold: {
                    this.autoHold(params);
                    break;
                }
                case ChartReset: {
                    this.chartReset();
                    break;
                }
                case SetLogEvent: {
                    this.setLogEvent(params);
                    break;
                }
                case SetLogEventCmds: {
                    this.setLogEventCmds(params);
                    break;
                }
                case FFTView: {
                    this.FFTView(params);
                    break;
                }
                case SetMPPT: {
                    this.setMPPT(params);
                    break;
                }
                case SetAutoAdjust: {
                    this.setAutoAdjust(params);
                    break;
                }
                case TimerCounter: {
                    this.setTimerCounter(params);
                }
            }
        }

        private void setBusy() {
            try {
                this.busy.acquire();
            }
            catch (InterruptedException interruptedException) {}
        }

        private void releaseBusy() {
            this.busy.release();
        }

        private void waitNotBusy() {
            this.setBusy();
            this.releaseBusy();
        }

        public boolean syncCommand(String cmd, final String[] params) {
            final SyncCommands sc = this.findCommand(cmd.substring(1));
            if (sc == null) {
                return false;
            }
            if (SwingUtilities.isEventDispatchThread()) {
                this.doCommand(sc, params);
            } else {
                this.setBusy();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            this.doCommand(sc, params);
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.out);
                        }
                        this.releaseBusy();
                    }
                });
                this.waitNotBusy();
            }
            return true;
        }
    }

    static class ForEach {
        List<Var> items = new ArrayList<Var>();
        String varName;
        int line;

        ForEach() {
        }
    }

    static enum IgnoredCommands {
        Autorun,
        ScriptMenu,
        ScriptSystemVersion,
        ScriptInterface,
        ScriptDevice,
        ScriptTable,
        ScriptNoLog,
        ScriptHandle,
        ScriptShowImage,
        ScriptScript;

    }

    private static enum RCL {
        combo,
        radio,
        list;

    }

    static enum SyncCommands {
        ShowParams,
        ShowPopupSystem,
        Readout,
        AdjustAlarm,
        SetAlarm,
        CloseAlarm,
        CloseAll,
        ShowPopupSetup,
        ShowPopupMode,
        Clear,
        Scale,
        ScaleDelete,
        AlignGrid,
        ChartCurves,
        ChartSamples,
        ChartY,
        ChartX,
        SaveChart,
        SaveLog,
        SyncPopups,
        CurrentValuesOptions,
        HistogramCurves,
        HistogramSamples,
        HistogramOptions,
        SaveHistogram,
        RangeSamples,
        RangeOptions,
        ExportColumns,
        ExportColumnsExclude,
        ExportColumn,
        ExportSamples,
        LoadExportFormat,
        ExportReduce,
        ExportTable,
        ExportInit,
        ExportTableReload,
        ValueFormat,
        SetParamAdjuster,
        CloseParamAdjuster,
        ShowImage,
        CloseParamSweeper,
        SetParamSweeper,
        ChartAnnotate,
        HistogramAnnotate,
        GridPanel,
        SinglePanel,
        AutoHold,
        ChartReset,
        SetLogEvent,
        SetLogEventCmds,
        FFTView,
        SetMPPT,
        SetAutoAdjust,
        TimerCounter;

    }
}

