/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.Support;
import dk.hkj.main.ValueFormat;
import dk.hkj.util.FileUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;

public class ChartScales {
    protected ScalesTableModel scalesTableModel = new ScalesTableModel(this);
    private List<ChartScale> scales = new ArrayList<ChartScale>();
    private boolean formatChanged = true;
    private JTable table = null;
    private boolean changed = false;
    private NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
    private String scaleCountName = null;
    private String scalePercentName = null;
    private String scaleTimeName = null;
    private String scaleDateTimeName = null;
    private boolean centerSpan = false;

    public ChartScales() {
        this.nf.setGroupingUsed(false);
        this.nf.setMaximumFractionDigits(8);
        this.nf.setMinimumFractionDigits(0);
        this.loadDefault();
    }

    public String getCountName() {
        if (this.scaleCountName != null) {
            return this.scaleCountName;
        }
        return "Count";
    }

    public String getPercentName() {
        if (this.scalePercentName != null) {
            return this.scalePercentName;
        }
        return "Percent";
    }

    public String getTimeName() {
        if (this.scaleTimeName != null) {
            return this.scaleTimeName;
        }
        return "time";
    }

    public String getDateTimeName() {
        if (this.scaleDateTimeName != null) {
            return this.scaleDateTimeName;
        }
        return "dateTime";
    }

    public void resetOverrides() {
        for (ChartScale cs : this.scales) {
            cs.setAxisName(null);
        }
        this.scaleTimeName = null;
        this.scaleDateTimeName = null;
        this.scaleCountName = null;
        this.scalePercentName = null;
    }

    public void setCenterSpan(boolean centerSpan) {
        this.centerSpan = centerSpan;
        this.scalesTableModel.changeNotification(true);
    }

    public boolean getCenterSpan() {
        return this.centerSpan;
    }

    private boolean isDigital(String name) {
        int n = Support.dataBase.header().getIndex(name);
        return Support.dataBase.format().get((int)n).format instanceof ValueFormat.ValueFormatterDigital;
    }

    public void overrideName(String scaleName, String newName) {
        if (scaleName.equals("Count")) {
            this.scaleCountName = newName;
            return;
        }
        if (scaleName.equals("Percent")) {
            this.scalePercentName = newName;
            return;
        }
        if (scaleName.equals("time")) {
            this.scaleTimeName = newName;
            return;
        }
        if (scaleName.equals("dateTime")) {
            this.scaleDateTimeName = newName;
            return;
        }
        ChartScale cs = this.getScale(scaleName);
        if (cs == null) {
            return;
        }
        if (newName.trim().isEmpty()) {
            newName = cs.name;
        }
        cs.setAxisName(newName);
        if (this.isDigital(scaleName)) {
            for (ChartScale csx : this.scales) {
                if (!csx.name.startsWith(String.valueOf(scaleName) + " ")) continue;
                csx.setAxisName(String.valueOf(newName) + csx.name.substring(scaleName.length()));
            }
        }
    }

    public void syncToName(String masterScale, String slaveScale) {
        ChartScale cs = this.getScale(slaveScale);
        cs.setSyncToScale(masterScale);
    }

    public void disableSync() {
        for (ChartScale cs : this.scales) {
            cs.setSyncToScale(null);
        }
    }

    public void setTable(JTable table) {
        this.table = table;
    }

    public void clearAllScales() {
        this.scales.clear();
        this.scalesTableModel.changeNotification(true);
    }

    public void addScale(ChartScale scale) {
        if (this.getScale(scale.name) == null) {
            this.scales.add(scale);
            this.scalesTableModel.changeNotification(true);
        }
    }

    public boolean containScale(String name) {
        for (ChartScale sc : this.scales) {
            if (!sc.name.equals(name)) continue;
            return true;
        }
        return false;
    }

    public ChartScale addScale(String name, int decimals, boolean auto, boolean autoIncludeZero, double range, double bottomStep, double min, double max) {
        for (ChartScale cs : this.scales) {
            if (!cs.name.equals(name)) continue;
            return cs;
        }
        ChartScale sc = new ChartScale(name, decimals, auto, autoIncludeZero, range, bottomStep, min, max);
        this.scales.add(sc);
        this.scalesTableModel.changeNotification(true);
        return sc;
    }

    public ChartScale getExistingScale(String name) {
        for (ChartScale cs : this.scales) {
            if (!cs.name.equals(name)) continue;
            return cs;
        }
        return null;
    }

    public ChartScale getScale(String name) {
        for (ChartScale cs : this.scales) {
            if (!cs.name.equals(name)) continue;
            return cs;
        }
        if (name.equals("dateTime") || name.equals("index") || name.equals("minutes")) {
            return this.addScale(name, 2, true, false, 0.0, 0.0, 0.0, 100.0);
        }
        return this.addScale(name, 2, true, true, 1.0, 1.0, 0.0, 100.0);
    }

    public ChartScale getScale(int no) {
        return this.scales.get(no);
    }

    public ChartScale getNewScale() {
        return new ChartScale();
    }

    public void saveToFile(File file) {
        ArrayList<String> list = new ArrayList<String>();
        for (ChartScale sc : this.scales) {
            list.add(sc.toString());
        }
        try {
            FileUtil.writeFile(file, list);
        }
        catch (IOException iOException) {}
    }

    public void loadFromFile(File file) {
        try {
            List<String> list = FileUtil.readFileAsList(file);
            for (String line : list) {
                if ((line = line.trim()).length() <= 0 || line.startsWith(";") || !line.contains("|")) continue;
                this.scales.add(new ChartScale(line));
            }
            this.sort();
            this.scalesTableModel.changeNotification(true);
        }
        catch (IOException iOException) {}
    }

    public void remove(ChartScale cs) {
        this.scales.remove(cs);
        this.changed = true;
    }

    public void removeMask(String name) {
        int i = this.scales.size() - 1;
        while (i >= 0) {
            ChartScale sc = this.scales.get(i);
            if (sc.name.matches(name)) {
                this.remove(i);
            }
            --i;
        }
    }

    public void remove(String name) {
        for (ChartScale sc : this.scales) {
            if (!sc.name.equals(name)) continue;
            this.remove(sc);
            return;
        }
    }

    public void remove(int index) {
        this.scales.remove(index);
        this.changed = true;
    }

    public void saveDefault() {
        if (!this.changed) {
            return;
        }
        this.saveToFile(new File(String.valueOf(Support.getConfigPath()) + "/settingsScales.txt"));
        this.changed = false;
    }

    public void loadDefault() {
        this.loadFromFile(new File(String.valueOf(Support.getConfigPath()) + "/settingsScales.txt"));
        this.changed = false;
    }

    public ScalesTableModel getTableDataModel() {
        return this.scalesTableModel;
    }

    public void sort() {
        this.scales.sort(new ChartScaleComparator());
        this.scalesTableModel.sendNotifications();
    }

    public List<String> matchingChannels(String mask) {
        ArrayList<String> list = new ArrayList<String>();
        for (ChartScale cs : this.scales) {
            if (!cs.name.matches(mask)) continue;
            list.add(cs.name);
        }
        return list;
    }

    public List<String> generateScript(String mask) {
        ArrayList<String> list = new ArrayList<String>();
        for (ChartScale cs : this.scales) {
            if (!cs.name.matches(mask)) continue;
            list.add(cs.generateScript());
        }
        return list;
    }

    public class ChartScale
    implements Comparable<ChartScale> {
        private String name = "";
        private double range = 1.0;
        private double bottomStep = 5.0;
        private double min = 0.0;
        private double max = 0.0;
        private int decimals = 2;
        private boolean auto = false;
        private boolean autoIncludeZero = false;
        private boolean log = false;
        private boolean si = false;
        private double chartPosition = 0.5;
        private String axisName = null;
        private String axisOverrideName = null;
        private boolean axisNameChange = false;
        private String syncToScale = null;
        private boolean sync = false;

        public ChartScale(String name, int decimals, boolean auto, boolean autoIncludeZero, double range, double bottomStep, double min, double max) {
            this.name = name;
            this.decimals = decimals;
            this.auto = auto;
            this.autoIncludeZero = autoIncludeZero;
            this.range = range;
            this.setBottomStep(bottomStep);
            this.min = min;
            this.max = max;
            ChartScales.this.changed = true;
        }

        public ChartScale() {
            ChartScales.this.changed = true;
        }

        public void setAxisName(String name) {
            if (name != null && (name = name.trim()).isEmpty()) {
                name = null;
            }
            this.axisName = name;
            this.axisOverrideName = name;
            this.axisNameChange = true;
        }

        public boolean isAxisNameChange() {
            boolean v = this.axisNameChange;
            this.axisNameChange = false;
            return v;
        }

        public void setSyncToScale(String name) {
            if (name != null && ((name = name.trim()).isEmpty() || name.equals(this.name))) {
                name = null;
            }
            this.syncToScale = name;
        }

        public String getSyncToScale() {
            return this.syncToScale;
        }

        public void setIsSync(boolean sync) {
            this.sync = sync;
        }

        public boolean isSync() {
            return this.sync;
        }

        public String getAxisOverrideName() {
            return this.axisOverrideName;
        }

        public String getAxisName() {
            if (this.axisName == null) {
                int column = Support.dataBase.header().getIndex(this.name);
                String u = "";
                if (column >= 0) {
                    u = Support.dataBase.format().get((int)column).unit.replace("_", "").replace("-", "");
                }
                this.axisName = u.length() > 0 ? String.valueOf(this.name) + " (" + u + ")" : this.name;
            }
            return this.axisName;
        }

        public ChartScale(String line) {
            for (Support.ConfigLineElement element : new Support.ConfigLineSplitter(line)) {
                if (element.name.equalsIgnoreCase("name")) {
                    this.name = element.value;
                    continue;
                }
                if (element.name.equalsIgnoreCase("decimals")) {
                    this.decimals = Integer.parseInt(element.value);
                    continue;
                }
                if (element.name.equalsIgnoreCase("auto")) {
                    this.auto = Integer.parseInt(element.value) != 0;
                    continue;
                }
                if (element.name.equalsIgnoreCase("log")) {
                    this.log = Integer.parseInt(element.value) != 0;
                    continue;
                }
                if (element.name.equalsIgnoreCase("si")) {
                    this.si = Integer.parseInt(element.value) != 0;
                    continue;
                }
                if (element.name.equalsIgnoreCase("autoIncludeZero")) {
                    this.autoIncludeZero = Integer.parseInt(element.value) != 0;
                    continue;
                }
                if (element.name.equalsIgnoreCase("range")) {
                    this.range = Double.parseDouble(element.value);
                    continue;
                }
                if (element.name.equalsIgnoreCase("bottomStep")) {
                    this.bottomStep = Double.parseDouble(element.value);
                    continue;
                }
                if (element.name.equalsIgnoreCase("min")) {
                    this.min = Double.parseDouble(element.value);
                    continue;
                }
                if (!element.name.equalsIgnoreCase("max")) continue;
                this.max = Double.parseDouble(element.value);
            }
            ChartScales.this.changed = true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("name:");
            sb.append(this.name);
            sb.append("|");
            sb.append("decimals:");
            sb.append(this.decimals);
            sb.append("|");
            sb.append("auto:");
            sb.append(this.auto ? 1 : 0);
            sb.append("|");
            sb.append("log:");
            sb.append(this.log ? 1 : 0);
            sb.append("|");
            sb.append("si:");
            sb.append(this.si ? 1 : 0);
            sb.append("|");
            sb.append("autoIncludeZero:");
            sb.append(this.autoIncludeZero ? 1 : 0);
            sb.append("|");
            sb.append("range:");
            sb.append(this.range);
            sb.append("|");
            sb.append("bottomStep:");
            sb.append(this.bottomStep);
            sb.append("|");
            sb.append("min:");
            sb.append(this.min);
            sb.append("|");
            sb.append("max:");
            sb.append(this.max);
            return sb.toString();
        }

        public void setAxisScale(ValueAxis axis, double[][] series) {
            NumberFormat df;
            Double dd;
            double mx;
            double mi;
            if (axis == null) {
                return;
            }
            if (this.auto && series.length > 0 && series[0].length > 0) {
                double d;
                double n;
                double dataMin = Double.MAX_VALUE;
                double dataMax = -1.7976931348623157E308;
                int i = 0;
                while (i < series[0].length) {
                    double v = series[1][i];
                    if (v > dataMax) {
                        dataMax = v;
                    }
                    if (v < dataMin) {
                        dataMin = v;
                    }
                    ++i;
                }
                mi = dataMin;
                mx = dataMax;
                if (this.autoIncludeZero && !this.log) {
                    if (mi > 0.0) {
                        mi = 0.0;
                    }
                    if (mx < 0.0) {
                        mx = 0.0;
                    }
                }
                if (this.log && mi < Support.systemSettings.chartLowLog) {
                    mi = Support.systemSettings.chartLowLog;
                }
                if ((n = (this.range - (d = Math.max(mx - mi, 1.0E-10))) / d * this.chartPosition) > 0.0) {
                    mi -= d * n;
                }
                if (this.bottomStep > 1.0E-10) {
                    mi = Math.floor(mi / this.bottomStep) * this.bottomStep;
                }
                if (this.log && mi < Support.systemSettings.chartLowLog) {
                    mi = Support.systemSettings.chartLowLog;
                }
                if ((mx += (mx - mi) * 0.01) - mi < this.range) {
                    mx = mi + this.range;
                }
            } else {
                mi = this.min;
                mx = this.max;
            }
            if (mx <= mi + (dd = Double.valueOf((Math.abs(mi) + Math.abs(mx)) * 1.0E-10 + 1.0E-100))) {
                mx = mi + dd;
            }
            axis.setRange(mi, mx);
            if (this.log && (mi < 1.0E-7 || mx > 1.0E7 || mx / mi > 1.0E7) && axis instanceof NumberAxis && (df = ((NumberAxis)axis).getNumberFormatOverride()) != null && df instanceof Support.MyDecimalFormat) {
                ((Support.MyDecimalFormat)df).seteFormat(true);
            }
        }

        public void setAxisScale(NumberAxis axis, double[] data) {
            NumberFormat df;
            Double dd;
            double mx;
            double mi;
            if (this.auto && data.length > 0) {
                double d;
                double n;
                double dataMin = Double.MAX_VALUE;
                double dataMax = -1.7976931348623157E308;
                int i = 0;
                while (i < data.length) {
                    double v = data[i];
                    if (v > dataMax) {
                        dataMax = v;
                    }
                    if (v < dataMin) {
                        dataMin = v;
                    }
                    ++i;
                }
                mi = dataMin;
                mx = dataMax;
                if (this.autoIncludeZero && !this.log) {
                    if (mi > 0.0) {
                        mi = 0.0;
                    }
                    if (mx < 0.0) {
                        mx = 0.0;
                    }
                }
                if (this.log && mi < Support.systemSettings.chartLowLog) {
                    mi = Support.systemSettings.chartLowLog;
                }
                if ((n = (this.range - (d = Math.max(mx - mi, 1.0E-10))) / d * this.chartPosition) > 0.0) {
                    mi -= d * n;
                }
                if (this.bottomStep > 1.0E-10) {
                    mi = Math.floor(mi / this.bottomStep) * this.bottomStep;
                }
                if (this.log && mi < Support.systemSettings.chartLowLog) {
                    mi = Support.systemSettings.chartLowLog;
                }
                if ((mx += (mx - mi) * 0.01) - mi < this.range) {
                    mx = mi + this.range;
                }
            } else {
                mi = this.min;
                mx = this.max;
            }
            if (mx <= mi + (dd = Double.valueOf((Math.abs(mi) + Math.abs(mx)) * 1.0E-10 + 1.0E-100))) {
                mx = mi + dd;
            }
            axis.setRange(mi, mx);
            if (this.log && (mi < 1.0E-7 || mx > 1.0E7 || mx / mi > 1.0E7) && axis instanceof NumberAxis && (df = axis.getNumberFormatOverride()) != null && df instanceof Support.MyDecimalFormat) {
                ((Support.MyDecimalFormat)df).seteFormat(true);
            }
        }

        public boolean isLog() {
            return this.log;
        }

        public boolean isSi() {
            return this.si;
        }

        public double getMin() {
            return this.min;
        }

        public void setMin(double min) {
            this.min = min;
            ChartScales.this.changed = true;
        }

        public double getMax() {
            return this.max;
        }

        public void setMax(double max) {
            this.max = max;
            ChartScales.this.changed = true;
        }

        public int getDecimals() {
            return this.decimals;
        }

        public void setDecimals(int decimals) {
            this.decimals = decimals;
            ChartScales.this.changed = true;
        }

        public boolean isAuto() {
            return this.auto;
        }

        public boolean isSI() {
            return this.si;
        }

        public void setSI(boolean si) {
            this.si = si;
            ChartScales.this.changed = true;
        }

        public void setLog(boolean log) {
            this.log = log;
            ChartScales.this.changed = true;
        }

        public void setAuto(boolean auto) {
            this.auto = auto;
            ChartScales.this.changed = true;
        }

        public boolean isAutoIncludeZero() {
            return this.autoIncludeZero;
        }

        public void setAutoIncludeZero(boolean autoIncludeZero) {
            this.autoIncludeZero = autoIncludeZero;
            ChartScales.this.changed = true;
        }

        public String getName() {
            return this.name;
        }

        public double getRange() {
            return this.range;
        }

        public void setRange(double range) {
            this.range = range;
            ChartScales.this.changed = true;
        }

        public double getBottomStep() {
            return this.bottomStep;
        }

        public void setBottomStep(double bottomStep) {
            this.bottomStep = bottomStep;
            ChartScales.this.changed = true;
        }

        public double getChartPosition() {
            return this.chartPosition;
        }

        public void setChartPosition(double chartPosition) {
            this.chartPosition = chartPosition;
        }

        @Override
        public int compareTo(ChartScale o) {
            return this.name.compareTo(o.name);
        }

        public String generateScript() {
            StringBuilder sb = new StringBuilder();
            sb.append("#scale ");
            sb.append(this.name);
            sb.append(" ");
            sb.append(this.getDecimals());
            sb.append(" ");
            sb.append(this.isSI() ? 1 : 0);
            sb.append(" ");
            sb.append(this.isLog() ? 1 : 0);
            sb.append(" ");
            sb.append(this.isAuto() ? 1 : 0);
            sb.append(" ");
            if (this.isAuto()) {
                sb.append(this.isAutoIncludeZero() ? 1 : 0);
                sb.append(" ");
                sb.append(this.getRange());
                sb.append(" ");
                sb.append(this.getBottomStep());
            } else {
                sb.append(this.getMin());
                sb.append(" ");
                sb.append(this.getMax());
            }
            return sb.toString();
        }
    }

    private class ChartScaleComparator
    implements Comparator<ChartScale> {
        private ChartScaleComparator() {
        }

        @Override
        public int compare(ChartScale o1, ChartScale o2) {
            return o1.compareTo(o2);
        }
    }

    static class DecimalFormatRenderer
    extends DefaultTableCellRenderer {
        private static NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);

        DecimalFormatRenderer() {
            nf.setGroupingUsed(false);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Number) {
                value = nf.format((Number)value);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    public class ScalesTableModel
    implements TableModel {
        private ChartScales scales = null;
        private List<TableModelListener> listeners = new ArrayList<TableModelListener>();

        ScalesTableModel(ChartScales scales) {
            this.scales = scales;
        }

        @Override
        public void addTableModelListener(TableModelListener arg0) {
            this.listeners.add(arg0);
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Integer.class;
                }
                case 2: {
                    return Boolean.class;
                }
                case 3: {
                    return Boolean.class;
                }
                case 4: {
                    return Boolean.class;
                }
                case 5: {
                    return Boolean.class;
                }
                case 6: {
                    return String.class;
                }
                case 7: {
                    return String.class;
                }
                case 8: {
                    return String.class;
                }
                case 9: {
                    return String.class;
                }
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 10;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Column";
                }
                case 1: {
                    return "Decimals";
                }
                case 2: {
                    return "SI";
                }
                case 3: {
                    return "Log";
                }
                case 4: {
                    return "Auto";
                }
                case 5: {
                    return "Auto includes zero";
                }
                case 6: {
                    return "Auto min. range";
                }
                case 7: {
                    return "Auto bottom step";
                }
                case 8: {
                    return ChartScales.this.centerSpan ? "Center" : "Minimum";
                }
                case 9: {
                    return ChartScales.this.centerSpan ? "Span" : "Maximum";
                }
            }
            return "?";
        }

        @Override
        public int getRowCount() {
            return this.scales.scales.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            boolean auto = ((ChartScale)this.scales.scales.get(row)).auto;
            switch (col) {
                case 0: {
                    return ((ChartScale)this.scales.scales.get(row)).name;
                }
                case 1: {
                    return ((ChartScale)this.scales.scales.get(row)).decimals;
                }
                case 2: {
                    return ((ChartScale)this.scales.scales.get(row)).si;
                }
                case 3: {
                    return ((ChartScale)this.scales.scales.get(row)).log;
                }
                case 4: {
                    return auto;
                }
                case 5: {
                    return auto && !((ChartScale)this.scales.scales.get(row)).log ? Boolean.valueOf(((ChartScale)this.scales.scales.get(row)).autoIncludeZero) : "-";
                }
                case 6: {
                    return auto ? ChartScales.this.nf.format(((ChartScale)this.scales.scales.get(row)).range) : "-";
                }
                case 7: {
                    return auto ? ChartScales.this.nf.format(((ChartScale)this.scales.scales.get(row)).bottomStep) : "-";
                }
                case 8: {
                    if (auto) {
                        return "-";
                    }
                    if (ChartScales.this.centerSpan) {
                        return ChartScales.this.nf.format((((ChartScale)this.scales.scales.get(row)).min + ((ChartScale)this.scales.scales.get(row)).max) / 2.0);
                    }
                    return ChartScales.this.nf.format(((ChartScale)this.scales.scales.get(row)).min);
                }
                case 9: {
                    if (auto) {
                        return "-";
                    }
                    if (ChartScales.this.centerSpan) {
                        return ChartScales.this.nf.format(((ChartScale)this.scales.scales.get(row)).max - ((ChartScale)this.scales.scales.get(row)).min);
                    }
                    return ChartScales.this.nf.format(((ChartScale)this.scales.scales.get(row)).max);
                }
            }
            return Character.valueOf('?');
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            boolean auto = ((ChartScale)this.scales.scales.get(row)).auto;
            switch (col) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 3: {
                    return true;
                }
                case 4: {
                    return true;
                }
                case 5: {
                    return auto;
                }
                case 6: {
                    return auto;
                }
                case 7: {
                    return auto;
                }
                case 8: {
                    return !auto;
                }
                case 9: {
                    return !auto;
                }
            }
            return false;
        }

        @Override
        public void removeTableModelListener(TableModelListener arg0) {
            int i = this.listeners.size() - 1;
            while (i >= 0) {
                if (this.listeners.get(i) == arg0) {
                    this.listeners.remove(i);
                }
                --i;
            }
        }

        private double parseDouble(Object obj) throws ParseException {
            if (obj instanceof Double) {
                return (Double)obj;
            }
            String s = (String)obj;
            s = s.replace(',', '.');
            obj = ChartScales.this.nf.parse(s);
            if (obj instanceof Long) {
                return ((Long)obj).longValue();
            }
            return (Double)obj;
        }

        private int parseInt(Object obj) throws ParseException {
            if (obj instanceof Integer) {
                return (Integer)obj;
            }
            obj = ChartScales.this.nf.parse((String)obj);
            if (obj instanceof Long) {
                return (int)((Long)obj).longValue();
            }
            return (Integer)obj;
        }

        @Override
        public void setValueAt(Object val, int row, int col) {
            ChartScales.this.changed = true;
            switch (col) {
                case 0: {
                    ((ChartScale)this.scales.scales.get(row)).name = (String)val;
                    break;
                }
                case 1: {
                    try {
                        ((ChartScale)this.scales.scales.get(row)).decimals = this.parseInt(val);
                    }
                    catch (ParseException parseException) {}
                    break;
                }
                case 2: {
                    ((ChartScale)this.scales.scales.get(row)).si = (Boolean)val;
                    break;
                }
                case 3: {
                    ((ChartScale)this.scales.scales.get(row)).log = (Boolean)val;
                    break;
                }
                case 4: {
                    ((ChartScale)this.scales.scales.get(row)).auto = (Boolean)val;
                    break;
                }
                case 5: {
                    ((ChartScale)this.scales.scales.get(row)).autoIncludeZero = (Boolean)val;
                    break;
                }
                case 6: {
                    try {
                        ((ChartScale)this.scales.scales.get(row)).range = this.parseDouble(val);
                    }
                    catch (ParseException parseException) {}
                    break;
                }
                case 7: {
                    try {
                        ((ChartScale)this.scales.scales.get(row)).bottomStep = this.parseDouble(val);
                    }
                    catch (ParseException parseException) {}
                    break;
                }
                case 8: {
                    try {
                        double v = this.parseDouble(val);
                        if (ChartScales.this.centerSpan) {
                            double center = (((ChartScale)this.scales.scales.get(row)).min + ((ChartScale)this.scales.scales.get(row)).max) / 2.0;
                            double span = ((ChartScale)this.scales.scales.get(row)).max - ((ChartScale)this.scales.scales.get(row)).min;
                            center = v;
                            ((ChartScale)this.scales.scales.get(row)).min = center - span / 2.0;
                            ((ChartScale)this.scales.scales.get(row)).max = center + span / 2.0;
                        } else {
                            ((ChartScale)this.scales.scales.get(row)).min = v;
                        }
                    }
                    catch (ParseException parseException) {}
                    if (!(((ChartScale)this.scales.scales.get(row)).max < ((ChartScale)this.scales.scales.get(row)).min)) break;
                    ((ChartScale)this.scales.scales.get(row)).max = ((ChartScale)this.scales.scales.get(row)).min + 1.0;
                    break;
                }
                case 9: {
                    try {
                        double v = this.parseDouble(val);
                        if (ChartScales.this.centerSpan) {
                            double center = (((ChartScale)this.scales.scales.get(row)).min + ((ChartScale)this.scales.scales.get(row)).max) / 2.0;
                            double span = ((ChartScale)this.scales.scales.get(row)).max - ((ChartScale)this.scales.scales.get(row)).min;
                            span = v;
                            if (span < 0.0) {
                                span = 1.0;
                            }
                            ((ChartScale)this.scales.scales.get(row)).min = center - span / 2.0;
                            ((ChartScale)this.scales.scales.get(row)).max = center + span / 2.0;
                        } else {
                            ((ChartScale)this.scales.scales.get(row)).max = v;
                        }
                        if (!(((ChartScale)this.scales.scales.get(row)).min > ((ChartScale)this.scales.scales.get(row)).max)) break;
                        ((ChartScale)this.scales.scales.get(row)).min = ((ChartScale)this.scales.scales.get(row)).max - 1.0;
                        break;
                    }
                    catch (ParseException parseException) {}
                }
            }
            this.rowChanged(row);
        }

        private void sendNotifications() {
            if (ChartScales.this.formatChanged) {
                ChartScales.this.formatChanged = false;
                for (TableModelListener ml : this.listeners) {
                    ml.tableChanged(new TableModelEvent(ChartScales.this.scalesTableModel, -1));
                }
            }
            if (ChartScales.this.scalesTableModel.getRowCount() > 0) {
                for (TableModelListener ml : this.listeners) {
                    ml.tableChanged(new TableModelEvent(ChartScales.this.scalesTableModel, 0, ChartScales.this.scalesTableModel.getRowCount()));
                }
            }
            if (ChartScales.this.table != null && ChartScales.this.table.getColumnCount() >= 7) {
                ChartScales.this.table.getColumnModel().getColumn(4).setCellRenderer(new DecimalFormatRenderer());
                ChartScales.this.table.getColumnModel().getColumn(5).setCellRenderer(new DecimalFormatRenderer());
                ChartScales.this.table.getColumnModel().getColumn(6).setCellRenderer(new DecimalFormatRenderer());
                ChartScales.this.table.addNotify();
            }
        }

        private void rowChanged(int row) {
            for (TableModelListener ml : this.listeners) {
                ml.tableChanged(new TableModelEvent(ChartScales.this.scalesTableModel, row, row));
            }
        }

        public synchronized void changeNotification(boolean full) {
            ChartScales chartScales = ChartScales.this;
            chartScales.formatChanged = chartScales.formatChanged | full;
            if (SwingUtilities.isEventDispatchThread()) {
                this.sendNotifications();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ScalesTableModel.this.sendNotifications();
                    }
                });
            }
        }
    }
}

