/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.color.ColorUtil;
import dk.hkj.main.ChartScales;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.Support;
import dk.hkj.main.ValueFormat;
import dk.hkj.util.MySwingUtil;
import dk.hkj.util.StringUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYLineAnnotation;
import org.jfree.chart.annotations.XYPointerAnnotation;
import org.jfree.chart.annotations.XYShapeAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.statistics.HistogramType;

public class ChartAnnotations {
    private static final int ColorPatchWidth = 25;
    private static final int ColorPatchHeight = 15;
    private List<Anno> annotations = new ArrayList<Anno>();

    public List<Anno> getList() {
        return this.annotations;
    }

    public void moveUp(int i) {
        if (i <= 0 || i >= this.annotations.size()) {
            return;
        }
        Anno a = this.annotations.remove(i);
        this.annotations.add(i - 1, a);
    }

    public void moveDown(int i) {
        if (i < 0 || i >= this.annotations.size() - 1) {
            return;
        }
        Anno a = this.annotations.remove(i);
        this.annotations.add(i + 1, a);
    }

    private static void valueChanged() {
        Support.paneChart.updateAnnotations();
    }

    public static List<String> getAnnotationNamesText() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("arrow");
        list.add("value");
        list.add("text");
        list.sort(null);
        return list;
    }

    public static List<String> getAnnotationNamesSimple() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("line");
        list.add("linex");
        list.add("liney");
        list.add("circle");
        list.add("box");
        list.add("boxrounded");
        list.sort(null);
        return list;
    }

    public static List<String> getAnnotationNamesComplex() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("polyline");
        list.add("curve");
        list.add("polygon");
        list.add("shape");
        list.sort(null);
        return list;
    }

    private static ImageIcon generateColorIcon(Color color) {
        BufferedImage image = new BufferedImage(25, 15, 1);
        Graphics g = image.getGraphics();
        if (color == null) {
            g.setColor(Color.lightGray);
            g.fillRect(0, 0, 25, 15);
            g.setColor(Color.white);
            g.drawRect(1, 1, 23, 13);
            g.drawLine(1, 1, 23, 13);
            g.drawLine(1, 13, 23, 1);
        } else {
            g.setColor(color);
            g.fillRect(0, 0, 25, 15);
        }
        return new ImageIcon(image);
    }

    public void add(String annoName) {
        if (annoName.equalsIgnoreCase("line")) {
            this.annotations.add(new AnnoLine());
        } else if (annoName.equalsIgnoreCase("liney")) {
            this.annotations.add(new AnnoLineY());
        } else if (annoName.equalsIgnoreCase("linex")) {
            this.annotations.add(new AnnoLineX());
        } else if (annoName.equalsIgnoreCase("arrow")) {
            this.annotations.add(new AnnoArrow());
        } else if (annoName.equalsIgnoreCase("value")) {
            this.annotations.add(new AnnoValue());
        } else if (annoName.equalsIgnoreCase("text")) {
            this.annotations.add(new AnnoText());
        } else if (annoName.equalsIgnoreCase("circle")) {
            this.annotations.add(new AnnoCircle());
        } else if (annoName.equalsIgnoreCase("box")) {
            this.annotations.add(new AnnoBox());
        } else if (annoName.equalsIgnoreCase("boxrounded")) {
            this.annotations.add(new AnnoBoxRounded());
        } else if (annoName.equalsIgnoreCase("polygon")) {
            this.annotations.add(new AnnoPolygon());
        } else if (annoName.equalsIgnoreCase("shape")) {
            this.annotations.add(new AnnoShape());
        } else if (annoName.equalsIgnoreCase("polyline")) {
            this.annotations.add(new AnnoPolyline());
        } else if (annoName.equalsIgnoreCase("curve")) {
            this.annotations.add(new AnnoCurve());
        }
    }

    public void add(Anno anno) {
        this.annotations.add(anno);
    }

    private static Stroke getStroke(String style, double thickness) {
        if (thickness < 1.0) {
            thickness = 1.0;
        }
        if (style == null || style.trim().length() == 0) {
            return new BasicStroke((float)thickness);
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        int cnt = 0;
        int l = 0;
        boolean draw = true;
        char[] cArray = style.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '.': {
                    l = 1;
                    break;
                }
                case '-': {
                    l = 5;
                    break;
                }
                case ' ': {
                    l = -1;
                    break;
                }
                case 'W': 
                case 'w': {
                    l = -5;
                }
            }
            if ((l < 0 && draw || l > 0 && !draw) && cnt > 0) {
                list.add(cnt);
                cnt = 0;
            }
            cnt += Math.abs(l);
            draw = l > 0;
            ++n2;
        }
        list.add(cnt);
        float[] f = new float[list.size()];
        int i = 0;
        while (i < list.size()) {
            f[i] = ((Integer)list.get(i)).intValue();
            ++i;
        }
        if (f.length <= 1) {
            return new BasicStroke((float)thickness);
        }
        return new BasicStroke((float)thickness, 0, 1, 10.0f, f, 0.0f);
    }

    private static TextAnchor getAnchor(String anchor) {
        if ((anchor = anchor.toUpperCase()).equals("LT") || anchor.equals("TL")) {
            return TextAnchor.TOP_LEFT;
        }
        if (anchor.equals("RT") || anchor.equals("TR")) {
            return TextAnchor.TOP_RIGHT;
        }
        if (anchor.equals("LB") || anchor.equals("BL")) {
            return TextAnchor.BOTTOM_LEFT;
        }
        if (anchor.equals("RB") || anchor.equals("BR")) {
            return TextAnchor.BOTTOM_RIGHT;
        }
        if (anchor.equals("C") || anchor.equals("CC")) {
            return TextAnchor.CENTER;
        }
        if (anchor.equals("LC") || anchor.equals("CL")) {
            return TextAnchor.CENTER_LEFT;
        }
        if (anchor.equals("RC") || anchor.equals("CR")) {
            return TextAnchor.CENTER_RIGHT;
        }
        if (anchor.equals("CT") || anchor.equals("TC")) {
            return TextAnchor.TOP_CENTER;
        }
        if (anchor.equals("CB") || anchor.equals("BC")) {
            return TextAnchor.BOTTOM_CENTER;
        }
        return TextAnchor.CENTER;
    }

    public static String anchorText(TextAnchor anchor) {
        if (anchor == TextAnchor.TOP_LEFT) {
            return "TL";
        }
        if (anchor == TextAnchor.TOP_CENTER) {
            return "TC";
        }
        if (anchor == TextAnchor.TOP_RIGHT) {
            return "TR";
        }
        if (anchor == TextAnchor.CENTER_LEFT) {
            return "CL";
        }
        if (anchor == TextAnchor.CENTER) {
            return "CC";
        }
        if (anchor == TextAnchor.CENTER_RIGHT) {
            return "CR";
        }
        if (anchor == TextAnchor.BOTTOM_LEFT) {
            return "BL";
        }
        if (anchor == TextAnchor.BOTTOM_CENTER) {
            return "BC";
        }
        if (anchor == TextAnchor.BOTTOM_RIGHT) {
            return "BR";
        }
        return "CC";
    }

    public void clear() {
        this.annotations.clear();
    }

    public void addToChart(Map<String, Integer> curveMap, String xaxis, XYPlot plot) {
        plot.clearAnnotations();
        for (Anno a : this.annotations) {
            a.addToChart(curveMap, xaxis, plot);
        }
    }

    static abstract class Anno {
        protected String axis = null;
        private Color color = null;
        private Color mappedColor = null;
        protected double y00 = 0.0;
        protected double ys = 1.0;

        public Anno() {
        }

        public Anno(String axis, Color color) {
            this.axis = axis;
            this.color = color;
        }

        protected abstract XYAnnotation get();

        public abstract String name();

        public abstract String generateScript();

        public void updateValues(int column, double position) {
        }

        public JPanel getEditPanel() {
            final JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            final FontAdjust.FontComboBox axisComboBox = new FontAdjust.FontComboBox();
            axisComboBox.addItem("");
            int[] nArray = Support.dataBase.header().getDataColumns();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                if (!(Support.dataBase.format().get((int)i).format instanceof ValueFormat.ValueFormatterDigital)) {
                    axisComboBox.addItem(Support.dataBase.header().getColumnName(i));
                }
                ++n2;
            }
            axisComboBox.setSelectedItem(this.axis);
            axisComboBox.setToolTipText("Select curve to associate this annotation with, this will also define the Y-coordinate");
            axisComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String s = (String)axisComboBox.getSelectedItem();
                    axis = s.isEmpty() ? null : s;
                    ChartAnnotations.valueChanged();
                }
            });
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.insets = new Insets(2, 2, 2, 2);
            c.anchor = 17;
            panel.add(axisComboBox);
            final JButton colorButton = new JButton();
            colorButton.setToolTipText("Select color for this annotation, when none is selected curve color is used");
            colorButton.setIcon(ChartAnnotations.generateColorIcon(this.color));
            colorButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    color = MySwingUtil.colorChooser(panel, "Color", color);
                    colorButton.setIcon(ChartAnnotations.generateColorIcon(color));
                    ChartAnnotations.valueChanged();
                }
            });
            c.gridx = 1;
            c.gridy = 0;
            c.insets = new Insets(2, 2, 2, 2);
            c.anchor = 17;
            panel.add((Component)colorButton, c);
            JButton defaultColorButton = new JButton("As curve");
            defaultColorButton.setToolTipText("Show annotation in same color as curve");
            defaultColorButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    color = null;
                    colorButton.setIcon(ChartAnnotations.generateColorIcon(color));
                    ChartAnnotations.valueChanged();
                }
            });
            c.gridx = 2;
            c.gridy = 0;
            c.insets = new Insets(2, 2, 2, 2);
            c.anchor = 17;
            panel.add((Component)defaultColorButton, c);
            return panel;
        }

        public String scriptPrefix() {
            StringBuilder sb = new StringBuilder();
            sb.append("#ChartAnnotate");
            if (this.axis != null && !this.axis.isEmpty()) {
                sb.append(" +");
                sb.append(this.axis);
            }
            sb.append(' ');
            sb.append(this.name());
            return sb.toString();
        }

        public String scriptColor() {
            if (this.color == null) {
                return " -";
            }
            return " " + ColorUtil.colorToName(this.color);
        }

        protected int getAxisIndex(Map<String, Integer> curveMap) {
            if (this.axis == null || !curveMap.containsKey(this.axis)) {
                return 0;
            }
            return curveMap.get(this.axis);
        }

        public void addToChart(Map<String, Integer> curveMap, String xaxis, XYPlot plot) {
            this.y00 = 0.0;
            this.ys = 1.0;
            Color color = this.mappedColor = this.color == null ? Support.chartLineColor[0] : this.color;
            if (this.axis == null) {
                plot.addAnnotation(this.get());
                return;
            }
            if (!curveMap.containsKey(this.axis)) {
                return;
            }
            int n = this.getAxisIndex(curveMap);
            if (n == 0) {
                plot.addAnnotation(this.get());
                return;
            }
            this.mappedColor = this.color == null ? Support.chartLineColor[n] : this.color;
            double low0 = plot.getRangeAxis(0).getLowerBound();
            double high0 = plot.getRangeAxis(0).getUpperBound();
            ValueAxis a = plot.getRangeAxis(n);
            ChartScales.ChartScale cs = Support.chartScales.getScale(this.axis);
            if (cs.isSync()) {
                n = curveMap.get(cs.getSyncToScale());
                a = plot.getRangeAxis(n);
            }
            double low1 = a.getLowerBound();
            double high1 = a.getUpperBound();
            this.ys = (high0 - low0) / (high1 - low1);
            this.y00 = low0 - low1 * this.ys;
            plot.addAnnotation(this.get());
        }

        protected Color getColor() {
            return this.mappedColor;
        }
    }

    private static abstract class AnnoArray
    extends AnnoXYWidthStyleBackground
    implements TableModel {
        private List<TableModelListener> listeners = new ArrayList<TableModelListener>();
        protected double[] xx = new double[0];
        protected double[] yy = new double[0];

        private AnnoArray() {
        }

        protected AnnoArray(String axis, double[] pp, Color color, double w, String style, Color background) {
            super(axis, color, pp[0], pp[1], w, style, background);
            this.xx = new double[pp.length / 2];
            this.yy = new double[pp.length / 2];
            int i = 0;
            while (i < pp.length / 2) {
                this.xx[i] = pp[i * 2];
                this.yy[i] = pp[i * 2 + 1];
                ++i;
            }
        }

        public JPanel getEditPanel(boolean askBackground) {
            JPanel panel = super.getEditPanel(false, false, askBackground);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 2;
            c.insets = new Insets(2, 2, 2, 2);
            c.anchor = 17;
            panel.add((Component)new FontAdjust.FontLabel("Positions:"), c);
            FontAdjust.FontTable table = new FontAdjust.FontTable(){

                @Override
                public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                    Component comp = super.prepareRenderer(renderer, row, col);
                    if (!comp.getBackground().equals(Support.colorScheme.selectedCellbackground)) {
                        comp.setBackground(row % 4 == 0 ? Support.colorScheme.tableGridAlternateBackground : Support.colorScheme.textBackground);
                    }
                    if (comp instanceof JLabel) {
                        JLabel label = (JLabel)comp;
                        label.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
                        label.setHorizontalAlignment(2);
                    }
                    return comp;
                }
            };
            JScrollPane scrollPane = new JScrollPane(table);
            scrollPane.setPreferredSize(new Dimension(200, 150));
            table.setDefaultEditor(String.class, new Support.AutoSelectCellEditor());
            table.setColumnModel(new Support.WidthTableColumnModel(new int[]{95, 95}));
            table.setModel(this);
            table.getTableHeader().setReorderingAllowed(false);
            table.setAutoResizeMode(0);
            table.setFillsViewportHeight(true);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 2;
            c.gridwidth = 5;
            c.insets = new Insets(2, 2, 2, 2);
            c.anchor = 17;
            c.fill = 1;
            panel.add((Component)scrollPane, c);
            return panel;
        }

        @Override
        public void addTableModelListener(TableModelListener arg0) {
            this.listeners.add(arg0);
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "X";
                }
                case 1: {
                    return "Y";
                }
            }
            return "";
        }

        @Override
        public int getRowCount() {
            return this.xx.length + 1;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row >= this.xx.length) {
                return "";
            }
            switch (col) {
                case 0: {
                    return StringUtil.formatDoubleEE(this.xx[row], false);
                }
                case 1: {
                    return StringUtil.formatDoubleEE(this.yy[row], false);
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public void removeTableModelListener(TableModelListener arg0) {
            this.listeners.remove(arg0);
        }

        @Override
        public void setValueAt(Object arg0, int row, int col) {
            String s = (String)arg0;
            if (s.trim().isEmpty() && row == this.xx.length - 1 && this.xx.length > 0) {
                this.xx = Arrays.copyOf(this.xx, this.xx.length - 1);
                this.yy = Arrays.copyOf(this.yy, this.yy.length - 1);
                ChartAnnotations.valueChanged();
                this.changed();
                return;
            }
            double v = StringUtil.parseDoubleEE(s);
            if (row >= this.xx.length) {
                this.xx = Arrays.copyOf(this.xx, this.xx.length + 1);
                this.yy = Arrays.copyOf(this.yy, this.yy.length + 1);
            }
            switch (col) {
                case 0: {
                    this.xx[row] = v;
                    break;
                }
                case 1: {
                    this.yy[row] = v;
                }
            }
            ChartAnnotations.valueChanged();
        }

        private void changed() {
            for (TableModelListener ml : this.listeners) {
                ml.tableChanged(new TableModelEvent(this));
            }
        }

        public String scriptArray() {
            if (this.xx.length == 0) {
                return " 0 0 (array())";
            }
            double x0 = this.xx[0];
            double y0 = this.yy[0];
            StringBuilder sb = new StringBuilder();
            sb.append(" ");
            sb.append(StringUtil.formatDoubleEE(x0, false));
            sb.append(" ");
            sb.append(StringUtil.formatDoubleEE(y0, false));
            sb.append(" (array(");
            int i = 0;
            while (i < this.xx.length) {
                sb.append(StringUtil.formatDoubleEE(this.xx[i] - x0, false));
                sb.append(",");
                sb.append(StringUtil.formatDoubleEE(this.yy[i] - y0, false));
                sb.append(",");
                ++i;
            }
            sb.setLength(sb.length() - 1);
            sb.append("))");
            return sb.toString();
        }
    }

    public static class AnnoArrow
    extends AnnoSizeBackground {
        private double angle = 0.0;

        public AnnoArrow() {
        }

        public AnnoArrow(String axis, String msg, double x, double y, double angle, Color color, int sz, Color background) {
            super(axis, color, x, y, msg, sz, background);
            this.angle = angle;
        }

        @Override
        public JPanel getEditPanel() {
            JPanel panel = this.getEditPanel(true, true);
            final FontAdjust.FontTextField aTextField = new FontAdjust.FontTextField(6);
            aTextField.setToolTipText("Select rotation of arrow: 0=Right, +=Down, -=Up");
            aTextField.setText(StringUtil.formatDoubleEE(this.angle, false));
            aTextField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    angle = Support.parseTextFieldDouble(aTextField, 0.0, false);
                    ChartAnnotations.valueChanged();
                }
            });
            aTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent arg0) {
                    angle = Support.parseTextFieldDouble(aTextField, 0.0, false);
                    ChartAnnotations.valueChanged();
                }
            });
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 4;
            c.insets = new Insets(2, 2, 2, 2);
            c.anchor = 17;
            panel.add((Component)new FontAdjust.FontLabel("Angle:"), c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 4;
            c.insets = new Insets(2, 2, 2, 2);
            c.anchor = 17;
            panel.add((Component)aTextField, c);
            return panel;
        }

        @Override
        public String name() {
            return "Arrow";
        }

        @Override
        protected XYAnnotation get() {
            XYPointerAnnotation a = new XYPointerAnnotation(this.getMessage(), this.x, this.y * this.ys + this.y00, (double)((float)this.angle) / 180.0 * Math.PI);
            a.setArrowPaint(this.getColor());
            a.setPaint(this.getColor());
            BasicStroke stroke = new BasicStroke((float)((double)this.sz / 2.0 + 1.0));
            a.setArrowStroke(stroke);
            a.setOutlineStroke(stroke);
            a.setBaseRadius(this.sz * 5 + 15);
            a.setArrowWidth(this.sz * 2 + 4);
            if (Math.abs(this.angle % 360.0) < 45.0) {
                a.setTextAnchor(TextAnchor.CENTER_LEFT);
            } else if (Math.abs((this.angle - 180.0) % 360.0) < 45.0) {
                a.setTextAnchor(TextAnchor.CENTER_RIGHT);
            } else if (this.angle >= 45.0 && this.angle <= 135.0) {
                a.setTextAnchor(TextAnchor.TOP_CENTER);
            } else {
                a.setTextAnchor(TextAnchor.BOTTOM_CENTER);
            }
            a.setFont(FontAdjust.fontSizes.getChartFont(this.sz));
            if (this.background != null) {
                a.setBackgroundPaint(this.background);
            }
            return a;
        }

        @Override
        public String generateScript() {
            return String.valueOf(this.scriptPrefix()) + this.scriptMessage() + this.scriptXY() + " " + StringUtil.formatDoubleEE(this.angle, false) + this.scriptColor() + this.scriptSizeBackground();
        }
    }

    public static class AnnoBox
    extends AnnoXYXYWidthStyleBackground {
        private AnnoBox() {
        }

        public AnnoBox(String axis, double x, double y, double rx, double ry, Color color, double w, String style, Color background) {
            super(axis, color, x, y, rx, ry, w, style, background);
        }

        @Override
        public JPanel getEditPanel() {
            JPanel panel = this.getEditPanel("Size:", true, true, true);
            return panel;
        }

        @Override
        public String name() {
            return "Box";
        }

        @Override
        protected XYAnnotation get() {
            Rectangle2D.Double shape = new Rectangle2D.Double(this.x1, this.y1 * this.ys + this.y00, this.x2, this.y2 * this.ys + this.y00);
            XYShapeAnnotation a = new XYShapeAnnotation(shape, this.stroke, this.getColor(), this.background);
            return a;
        }

        @Override
        public String generateScript() {
            return String.valueOf(this.scriptPrefix()) + this.scriptXY() + this.scriptXY2() + this.scriptColor() + this.scriptWidthStyle() + this.scriptBackground();
        }
    }

    public static class AnnoBoxRounded
    extends AnnoXYXYWidthStyleBackground {
        private AnnoBoxRounded() {
        }

        public AnnoBoxRounded(String axis, double x, double y, double rx, double ry, Color color, double w, String style, Color background) {
            super(axis, color, x, y, rx, ry, w, style, background);
        }

        @Override
        public JPanel getEditPanel() {
            JPanel panel = this.getEditPanel("Size:", true, true, true);
            return panel;
        }

        @Override
        public String name() {
            return "BoxRounded";
        }

        @Override
        protected XYAnnotation get() {
            RoundRectangle2D.Double shape = new RoundRectangle2D.Double(this.x1, this.y1 * this.ys + this.y00, this.x2, this.y2 * this.ys + this.y00, Math.abs(this.x2) / 3.0, Math.abs(this.y2 * this.ys + this.y00) / 3.0);
            XYShapeAnnotation a = new XYShapeAnnotation(shape, this.stroke, this.getColor(), this.background);
            return a;
        }

        @Override
        public String generateScript() {
            return String.valueOf(this.scriptPrefix()) + this.scriptXY() + this.scriptXY2() + this.scriptColor() + this.scriptWidthStyle() + this.scriptBackground();
        }
    }

    public static class AnnoCircle
    extends AnnoXYXYWidthStyleBackground {
        private AnnoCircle() {
        }

        public AnnoCircle(String axis, double x, double y, double rx, double ry, Color color, double w, String style, Color background) {
            super(axis, color, x, y, rx, ry, w, style, background);
        }

        @Override
        public JPanel getEditPanel() {
            JPanel panel = this.getEditPanel("Size:", true, true, true);
            return panel;
        }

        @Override
        public String name() {
            return "Circle";
        }

        @Override
        protected XYAnnotation get() {
            Ellipse2D.Double shape = new Ellipse2D.Double(this.x1, this.y1 * this.ys + this.y00, this.x2, this.y2 * this.ys + this.y00);
            XYShapeAnnotation a = new XYShapeAnnotation(shape, this.stroke, this.getColor(), this.background);
            return a;
        }

        @Override
        public String generateScript() {
            return String.valueOf(this.scriptPrefix()) + this.scriptXY() + this.scriptXY2() + this.scriptColor() + this.scriptWidthStyle() + this.scriptBackground();
        }
    }

    public static class AnnoCurve
    extends AnnoArray {
        private AnnoCurve() {
        }

        public AnnoCurve(String axis, double[] pp, Color color, double w, String style) {
            super(axis, pp, color, w, style, null);
        }

        @Override
        public JPanel getEditPanel() {
            JPanel panel = this.getEditPanel(false);
            return panel;
        }

        @Override
        public String name() {
            return "Curve";
        }

        @Override
        protected XYAnnotation get() {
            double[] yya = new double[this.xx.length];
            int i = 0;
            while (i < this.xx.length) {
                yya[i] = this.yy[i] * this.ys + this.y00;
                ++i;
            }
            SmoothCurve shape = new SmoothCurve(this.xx, yya, false);
            XYShapeAnnotation a = new XYShapeAnnotation(shape, this.stroke, this.getColor());
            return a;
        }

        @Override
        public String generateScript() {
            return String.valueOf(this.scriptPrefix()) + this.scriptArray() + this.scriptColor() + this.scriptWidthStyle();
        }
    }

    public static class AnnoLine
    extends AnnoXYXYWidthStyleBackground {
        public AnnoLine() {
        }

        public AnnoLine(String axis, double x1, double y1, double x2, double y2, double thickness, Color color, String style) {
            super(axis, color, x1, y1, x2, y2, thickness, style, null);
        }

        @Override
        public JPanel getEditPanel() {
            JPanel panel = this.getEditPanel("Position 2:", true, true, false);
            return panel;
        }

        @Override
        public String name() {
            return "Line";
        }

        @Override
        protected XYAnnotation get() {
            return new XYLineAnnotation(this.x1, this.y1 * this.ys + this.y00, this.x2, this.y2 * this.ys + this.y00, this.stroke, this.getColor());
        }

        @Override
        public String generateScript() {
            return String.valueOf(this.scriptPrefix()) + this.scriptXY() + this.scriptXY2() + this.scriptColor() + this.scriptWidthStyle();
        }
    }

    public static class AnnoLineX
    extends AnnoLine {
        private AnnoLineX() {
            this.y1 = -1.0E30;
            this.y2 = 1.0E30;
        }

        public AnnoLineX(String axis, double x, double thickness, Color color, String style) {
            super(axis, x, -1.0E30, x, 1.0E30, thickness, color, style);
        }

        @Override
        public JPanel getEditPanel() {
            JPanel panel = this.getEditPanel(true, false, false);
            return panel;
        }

        @Override
        public String name() {
            return "LineX";
        }

        @Override
        protected XYAnnotation get() {
            return new XYLineAnnotation(this.x1, this.y1 * this.ys + this.y00, this.x1, this.y2 * this.ys + this.y00, this.stroke, this.getColor());
        }

        @Override
        public String generateScript() {
            return String.valueOf(this.scriptPrefix()) + " " + StringUtil.formatDoubleEE(this.x1, false) + this.scriptColor() + this.scriptWidthStyle();
        }
    }

    public static class AnnoLineY
    extends AnnoLine {
        private AnnoLineY() {
            this.x1 = -1.0E30;
            this.x2 = 1.0E30;
        }

        public AnnoLineY(String axis, double y, double thickness, Color color, String style) {
            super(axis, -1.0E30, y, 1.0E30, y, thickness, color, style);
        }

        @Override
        public JPanel getEditPanel() {
            JPanel panel = this.getEditPanel(false, true, false);
            return panel;
        }

        @Override
        public String name() {
            return "LineY";
        }

        @Override
        protected XYAnnotation get() {
            return new XYLineAnnotation(this.x1, this.y1 * this.ys + this.y00, this.x2, this.y1 * this.ys + this.y00, this.stroke, this.getColor());
        }

        @Override
        public String generateScript() {
            return String.valueOf(this.scriptPrefix()) + " " + StringUtil.formatDoubleEE(this.y1, false) + this.scriptColor() + this.scriptWidthStyle();
        }
    }

    public static class AnnoPolygon
    extends AnnoArray {
        private AnnoPolygon() {
        }

        public AnnoPolygon(String axis, double[] pp, Color color, double w, String style, Color background) {
            super(axis, pp, color, w, style, background);
        }

        @Override
        public JPanel getEditPanel() {
            JPanel panel = this.getEditPanel(true);
            return panel;
        }

        @Override
        public String name() {
            return "Polygon";
        }

        @Override
        protected XYAnnotation get() {
            Path2D.Double shape = new Path2D.Double();
            int i = 0;
            while (i < this.xx.length) {
                if (i == 0) {
                    shape.moveTo(this.xx[i], this.yy[i] * this.ys + this.y00);
                } else {
                    shape.lineTo(this.xx[i], this.yy[i] * this.ys + this.y00);
                }
                ++i;
            }
            if (this.xx.length > 0) {
                shape.lineTo(this.xx[0], this.yy[0] * this.ys + this.y00);
            }
            XYShapeAnnotation a = new XYShapeAnnotation(shape, this.stroke, this.getColor(), this.background);
            return a;
        }

        @Override
        public String generateScript() {
            return String.valueOf(this.scriptPrefix()) + this.scriptArray() + this.scriptColor() + this.scriptWidthStyle() + this.scriptBackground();
        }
    }

    public static class AnnoPolyline
    extends AnnoArray {
        private AnnoPolyline() {
        }

        public AnnoPolyline(String axis, double[] pp, Color color, double w, String style) {
            super(axis, pp, color, w, style, null);
        }

        @Override
        public JPanel getEditPanel() {
            JPanel panel = this.getEditPanel(false);
            return panel;
        }

        @Override
        public String name() {
            return "PolyLine";
        }

        @Override
        protected XYAnnotation get() {
            Path2D.Double shape = new Path2D.Double();
            int i = 0;
            while (i < this.xx.length) {
                if (i == 0) {
                    shape.moveTo(this.xx[i], this.yy[i] * this.ys + this.y00);
                } else {
                    shape.lineTo(this.xx[i], this.yy[i] * this.ys + this.y00);
                }
                ++i;
            }
            XYShapeAnnotation a = new XYShapeAnnotation(shape, this.stroke, this.getColor());
            return a;
        }

        @Override
        public String generateScript() {
            return String.valueOf(this.scriptPrefix()) + this.scriptArray() + this.scriptColor() + this.scriptWidthStyle();
        }
    }

    public static class AnnoShape
    extends AnnoArray {
        private AnnoShape() {
        }

        public AnnoShape(String axis, double[] pp, Color color, double w, String style, Color background) {
            super(axis, pp, color, w, style, background);
        }

        @Override
        public JPanel getEditPanel() {
            JPanel panel = this.getEditPanel(true);
            return panel;
        }

        @Override
        public String name() {
            return "Shape";
        }

        @Override
        protected XYAnnotation get() {
            double[] yya = new double[this.xx.length];
            int i = 0;
            while (i < this.xx.length) {
                yya[i] = this.yy[i] * this.ys + this.y00;
                ++i;
            }
            SmoothCurve shape = new SmoothCurve(this.xx, yya, true);
            XYShapeAnnotation a = new XYShapeAnnotation(shape, this.stroke, this.getColor(), this.background);
            return a;
        }

        @Override
        public String generateScript() {
            return String.valueOf(this.scriptPrefix()) + this.scriptArray() + this.scriptColor() + this.scriptWidthStyle() + this.scriptBackground();
        }
    }

    static abstract class AnnoSizeBackground
    extends Anno {
        protected int sz = 1;
        protected Color background = null;
        protected double x = 0.0;
        protected double y = 0.0;
        protected String message = "";

        private AnnoSizeBackground() {
        }

        public AnnoSizeBackground(String axis, Color color, double x, double y, String message, int size, Color background) {
            super(axis, color);
            if (size < 1) {
                size = 1;
            }
            if (size > 4) {
                size = 4;
            }
            this.sz = size;
            this.background = background;
            this.x = x;
            this.y = y;
            this.message = message;
        }

        protected String getMessage() {
            if (this.background != null) {
                return " " + this.message + " ";
            }
            if (this.message.isEmpty()) {
                return " ";
            }
            return this.message;
        }

        public JPanel getEditPanel(boolean askMessage, boolean askY) {
            JPanel panel = super.getEditPanel();
            final FontAdjust.FontComboBox sizeComboBox = new FontAdjust.FontComboBox();
            sizeComboBox.setToolTipText("Select text size");
            sizeComboBox.addItem("Very small");
            sizeComboBox.addItem("Small");
            sizeComboBox.addItem("Medium");
            sizeComboBox.addItem("Large");
            sizeComboBox.setSelectedIndex(this.sz - 1);
            sizeComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    sz = sizeComboBox.getSelectedIndex() + 1;
                    ChartAnnotations.valueChanged();
                }
            });
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 1;
            c.insets = new Insets(2, 2, 2, 2);
            c.anchor = 17;
            panel.add(sizeComboBox, c);
            final JButton colorButton = new JButton();
            colorButton.setToolTipText("Select background color for text, default is none");
            colorButton.setIcon(ChartAnnotations.generateColorIcon(this.background));
            colorButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    background = MySwingUtil.colorChooser(colorButton, "Color", background);
                    colorButton.setIcon(ChartAnnotations.generateColorIcon(background));
                    ChartAnnotations.valueChanged();
                }
            });
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 1;
            c.insets = new Insets(2, 2, 2, 2);
            c.anchor = 17;
            panel.add((Component)colorButton, c);
            JButton noColorButton = new JButton("None");
            noColorButton.setToolTipText("Remove background color from text");
            noColorButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    background = null;
                    colorButton.setIcon(ChartAnnotations.generateColorIcon(background));
                    ChartAnnotations.valueChanged();
                }
            });
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 1;
            c.insets = new Insets(2, 2, 2, 2);
            c.anchor = 17;
            panel.add((Component)noColorButton, c);
            c.gridx = 0;
            c.gridy = 2;
            c.insets = new Insets(2, 2, 2, 2);
            c.anchor = 17;
            panel.add((Component)new FontAdjust.FontLabel("Position:"), c);
            final FontAdjust.FontTextField xTextField = new FontAdjust.FontTextField(6);
            xTextField.setText(StringUtil.formatDoubleEE(this.x, false));
            xTextField.setToolTipText("X coordinate, with default X-scale it is in seconds");
            xTextField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    x = Support.parseTextFieldDouble(xTextField, 0.0, false);
                    ChartAnnotations.valueChanged();
                }
            });
            xTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent arg0) {
                    x = Support.parseTextFieldDouble(xTextField, 0.0, false);
                    ChartAnnotations.valueChanged();
                }
            });
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 2;
            c.insets = new Insets(2, 2, 2, 2);
            c.anchor = 17;
            panel.add((Component)xTextField, c);
            if (askY) {
                final FontAdjust.FontTextField yTextField = new FontAdjust.FontTextField(6);
                yTextField.setToolTipText("Y coordinate, this will match the selected curve");
                yTextField.setText(StringUtil.formatDoubleEE(this.y, false));
                yTextField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        y = Support.parseTextFieldDouble(yTextField, 0.0, false);
                        ChartAnnotations.valueChanged();
                    }
                });
                yTextField.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent arg0) {
                        y = Support.parseTextFieldDouble(yTextField, 0.0, false);
                        ChartAnnotations.valueChanged();
                    }
                });
                c = new GridBagConstraints();
                c.gridx = 2;
                c.gridy = 2;
                c.insets = new Insets(2, 2, 2, 2);
                c.anchor = 17;
                panel.add((Component)yTextField, c);
            }
            if (askMessage) {
                c.gridx = 0;
                c.gridy = 3;
                c.insets = new Insets(2, 2, 2, 2);
                c.anchor = 17;
                panel.add((Component)new FontAdjust.FontLabel("Text:"), c);
                final FontAdjust.FontTextField textField = new FontAdjust.FontTextField(15);
                textField.setToolTipText("Text to show in annotation");
                textField.setText(this.message);
                textField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        message = textField.getText();
                        ChartAnnotations.valueChanged();
                    }
                });
                textField.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent arg0) {
                        message = textField.getText();
                        ChartAnnotations.valueChanged();
                    }
                });
                c = new GridBagConstraints();
                c.gridx = 1;
                c.gridy = 3;
                c.gridwidth = 2;
                c.insets = new Insets(2, 2, 2, 2);
                c.anchor = 17;
                panel.add((Component)textField, c);
            }
            return panel;
        }

        public String scriptMessage() {
            return " " + Support.conditionalQuote(this.message);
        }

        public String scriptSizeBackground() {
            return " " + Integer.toString(this.sz) + " " + (this.background == null ? "-" : ColorUtil.colorToName(this.background));
        }

        public String scriptXY() {
            return " " + StringUtil.formatDoubleEE(this.x, false) + " " + StringUtil.formatDoubleEE(this.y, false);
        }
    }

    public static class AnnoText
    extends AnnoSizeBackground {
        private TextAnchor anchor = TextAnchor.TOP_CENTER;

        public AnnoText() {
        }

        public AnnoText(String axis, String msg, String anchor, double x, double y, Color color, int sz, Color background) {
            super(axis, color, x, y, msg, sz, background);
            this.anchor = ChartAnnotations.getAnchor(anchor);
        }

        @Override
        public JPanel getEditPanel() {
            JPanel panel = this.getEditPanel(true, true);
            final FontAdjust.FontComboBox attachComboBox = new FontAdjust.FontComboBox();
            attachComboBox.setToolTipText("Select reference position for the text");
            attachComboBox.setMaximumRowCount(20);
            attachComboBox.addItem("TL: Top left");
            attachComboBox.addItem("CL: Center left");
            attachComboBox.addItem("BL: Bottom left");
            attachComboBox.addItem("TC: Top center");
            attachComboBox.addItem("CC: Center center");
            attachComboBox.addItem("BC: Bottom center");
            attachComboBox.addItem("TR: Top right");
            attachComboBox.addItem("CR: Center right");
            attachComboBox.addItem("BR: Bottom right");
            int i = 0;
            while (i < attachComboBox.getItemCount()) {
                String s = (String)attachComboBox.getItemAt(i);
                if (ChartAnnotations.getAnchor(s.substring(0, 2)) == this.anchor) {
                    attachComboBox.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
            attachComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    String s = (String)attachComboBox.getSelectedItem();
                    if (s.length() > 2) {
                        anchor = ChartAnnotations.getAnchor(s.substring(0, 2));
                    }
                    ChartAnnotations.valueChanged();
                }
            });
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 4;
            c.insets = new Insets(2, 2, 2, 2);
            c.anchor = 17;
            panel.add((Component)new FontAdjust.FontLabel("Anchor:"), c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 4;
            c.gridwidth = 2;
            c.insets = new Insets(2, 2, 2, 2);
            c.anchor = 17;
            panel.add(attachComboBox, c);
            return panel;
        }

        @Override
        public String name() {
            return "Text";
        }

        @Override
        protected XYAnnotation get() {
            XYTextAnnotation a = new XYTextAnnotation(this.getMessage(), this.x, this.y * this.ys + this.y00);
            a.setPaint(this.getColor());
            if (this.background != null) {
                a.setOutlinePaint(this.background);
                a.setBackgroundPaint(this.background);
                a.setOutlineVisible(true);
            }
            a.setTextAnchor(this.anchor);
            a.setFont(FontAdjust.fontSizes.getChartFont(this.sz));
            return a;
        }

        @Override
        public String generateScript() {
            return String.valueOf(this.scriptPrefix()) + this.scriptMessage() + " " + ChartAnnotations.anchorText(this.anchor) + this.scriptXY() + this.scriptColor() + this.scriptSizeBackground();
        }
    }

    public static class AnnoValue
    extends AnnoSizeBackground {
        private String xaxis = null;
        private double angle = 0.0;
        private Map<String, Integer> curveMap;
        private XYPlot plot;

        public AnnoValue() {
        }

        public AnnoValue(String axis, double x, double angle, Color color, int sz, Color background) {
            super(axis, color, x, 0.0, null, sz, background);
            this.angle = angle;
        }

        @Override
        public JPanel getEditPanel() {
            JPanel panel = this.getEditPanel(false, false);
            final FontAdjust.FontTextField aTextField = new FontAdjust.FontTextField(6);
            aTextField.setText(StringUtil.formatDoubleEE(this.angle, false));
            aTextField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    angle = Support.parseTextFieldDouble(aTextField, 0.0, false);
                    ChartAnnotations.valueChanged();
                }
            });
            aTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent arg0) {
                    angle = Support.parseTextFieldDouble(aTextField, 0.0, false);
                    ChartAnnotations.valueChanged();
                }
            });
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 4;
            c.insets = new Insets(2, 2, 2, 2);
            c.anchor = 17;
            panel.add((Component)new FontAdjust.FontLabel("Angle:"), c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 4;
            c.insets = new Insets(2, 2, 2, 2);
            c.anchor = 17;
            panel.add((Component)aTextField, c);
            return panel;
        }

        @Override
        public String name() {
            return "Value";
        }

        @Override
        public void addToChart(Map<String, Integer> curveMap, String xaxis, XYPlot plot) {
            this.xaxis = xaxis;
            this.curveMap = curveMap;
            this.plot = plot;
            super.addToChart(curveMap, xaxis, plot);
        }

        @Override
        protected XYAnnotation get() {
            String yaxis = this.axis;
            if (yaxis == null) {
                for (Map.Entry<String, Integer> entry : this.curveMap.entrySet()) {
                    if (entry.getValue() != 0) continue;
                    yaxis = entry.getKey();
                }
            }
            if (yaxis == null) {
                return null;
            }
            String msg = "";
            double y = 0.0;
            if (this.plot.getRenderer() instanceof XYBarRenderer) {
                HistogramDataset dataset = (HistogramDataset)this.plot.getDataset();
                int i = 0;
                while (i < dataset.getItemCount(0)) {
                    if (this.x >= dataset.getStartXValue(0, i) && this.x <= dataset.getEndXValue(0, i)) {
                        y = dataset.getYValue(0, i);
                        break;
                    }
                    ++i;
                }
                if (dataset.getType() == HistogramType.FREQUENCY) {
                    msg = Long.toString((long)y);
                } else {
                    DecimalFormat nf = (DecimalFormat)NumberFormat.getNumberInstance(Locale.ENGLISH);
                    ((NumberFormat)nf).setGroupingUsed(false);
                    ((NumberFormat)nf).setMaximumFractionDigits(4);
                    msg = String.valueOf(nf.format(y * 100.0)) + " %";
                }
            } else {
                int row = Support.dataBase.findSampleIndex(this.xaxis, this.x);
                int column = Support.dataBase.header().getIndex(yaxis);
                y = Support.dataBase.getValue(row, column);
                msg = String.valueOf(Support.dataBase.format().formatDisplay(column, y)) + " " + Support.dataBase.format().get((int)column).unit;
            }
            msg = this.background != null ? " " + msg + " " : msg;
            XYPointerAnnotation a = new XYPointerAnnotation(msg, this.x, y * this.ys + this.y00, (double)((float)this.angle) / 180.0 * Math.PI);
            a.setArrowPaint(this.getColor());
            a.setPaint(this.getColor());
            BasicStroke stroke = new BasicStroke((float)((double)this.sz / 2.0 + 1.0));
            a.setArrowStroke(stroke);
            a.setOutlineStroke(stroke);
            a.setBaseRadius(this.sz * 5 + 15);
            a.setArrowWidth(this.sz * 2 + 4);
            if (Math.abs(this.angle % 360.0) < 45.0) {
                a.setTextAnchor(TextAnchor.CENTER_LEFT);
            } else if (Math.abs((this.angle - 180.0) % 360.0) < 45.0) {
                a.setTextAnchor(TextAnchor.CENTER_RIGHT);
            } else if (this.angle >= 45.0 && this.angle <= 135.0) {
                a.setTextAnchor(TextAnchor.TOP_CENTER);
            } else {
                a.setTextAnchor(TextAnchor.BOTTOM_CENTER);
            }
            a.setFont(FontAdjust.fontSizes.getChartFont(this.sz));
            if (this.background != null) {
                a.setBackgroundPaint(this.background);
            }
            return a;
        }

        @Override
        public String generateScript() {
            return String.valueOf(this.scriptPrefix()) + " " + StringUtil.formatDoubleEE(this.x, false) + " " + StringUtil.formatDoubleEE(this.angle, false) + this.scriptColor() + this.scriptSizeBackground();
        }
    }

    static abstract class AnnoXYWidthStyleBackground
    extends Anno {
        protected double x1 = 0.0;
        protected double y1 = 0.0;
        private double thickness = 1.0;
        private String style = "-";
        protected Stroke stroke = ChartAnnotations.access$2("-", 1.0);
        protected Color background = null;

        private AnnoXYWidthStyleBackground() {
        }

        public AnnoXYWidthStyleBackground(String axis, Color color, double x1, double y1, double thickness, String style, Color background) {
            super(axis, color);
            this.background = background;
            this.x1 = x1;
            this.y1 = y1;
            if (thickness < 1.0) {
                thickness = 1.0;
            } else if (thickness > 50.0) {
                thickness = 50.0;
            }
            this.thickness = thickness;
            this.style = style;
            this.stroke = ChartAnnotations.getStroke(style, thickness);
        }

        public JPanel getEditPanel(boolean askX, boolean askY, boolean askBackground) {
            JPanel panel = super.getEditPanel();
            final FontAdjust.FontComboBox styleComboBox = new FontAdjust.FontComboBox();
            styleComboBox.setToolTipText("Define line style .=dot -=line, =short space, w=long space");
            styleComboBox.addItem("-");
            styleComboBox.addItem(".w");
            styleComboBox.addItem("-w");
            styleComboBox.addItem("-w.w");
            styleComboBox.addItem(".ww");
            styleComboBox.addItem("-ww");
            styleComboBox.addItem("-ww.ww");
            styleComboBox.addItem("-www");
            styleComboBox.setEditable(true);
            styleComboBox.setSelectedItem(this.style);
            styleComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    style = (String)styleComboBox.getSelectedItem();
                    stroke = ChartAnnotations.getStroke(style, thickness < 1.0 ? 1.0 : thickness);
                    ChartAnnotations.valueChanged();
                }
            });
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 1;
            c.insets = new Insets(2, 2, 2, 2);
            c.anchor = 17;
            panel.add(styleComboBox, c);
            final FontAdjust.FontTextField wTextField = new FontAdjust.FontTextField(3);
            wTextField.setToolTipText("Line width, can be from 1 to 50");
            wTextField.setText(StringUtil.formatDoubleEE(this.thickness, false));
            wTextField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    thickness = Support.parseTextFieldDouble(wTextField, 0.0, false, 1.0, 50.0);
                    stroke = ChartAnnotations.getStroke(style, thickness < 1.0 ? 1.0 : thickness);
                    ChartAnnotations.valueChanged();
                }
            });
            wTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent arg0) {
                    thickness = Support.parseTextFieldDouble(wTextField, 0.0, false, 1.0, 50.0);
                    stroke = ChartAnnotations.getStroke(style, thickness < 1.0 ? 1.0 : thickness);
                    ChartAnnotations.valueChanged();
                }
            });
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 1;
            c.insets = new Insets(2, 2, 2, 2);
            c.anchor = 17;
            panel.add((Component)wTextField, c);
            if (askBackground) {
                final JButton colorButton = new JButton();
                colorButton.setToolTipText("Select background color for text, default is none");
                colorButton.setIcon(ChartAnnotations.generateColorIcon(this.background));
                colorButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        background = MySwingUtil.colorChooser(colorButton, "Color", background);
                        colorButton.setIcon(ChartAnnotations.generateColorIcon(background));
                        ChartAnnotations.valueChanged();
                    }
                });
                c = new GridBagConstraints();
                c.gridx = 2;
                c.gridy = 1;
                c.insets = new Insets(2, 2, 2, 2);
                c.anchor = 17;
                panel.add((Component)colorButton, c);
                JButton noColorButton = new JButton("None");
                noColorButton.setToolTipText("Remove background color from text");
                noColorButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        background = null;
                        colorButton.setIcon(ChartAnnotations.generateColorIcon(background));
                        ChartAnnotations.valueChanged();
                    }
                });
                c = new GridBagConstraints();
                c.gridx = 3;
                c.gridy = 1;
                c.insets = new Insets(2, 2, 2, 2);
                c.anchor = 17;
                panel.add((Component)noColorButton, c);
            }
            if (askX || askY) {
                c.gridx = 0;
                c.gridy = 2;
                c.insets = new Insets(2, 2, 2, 2);
                c.anchor = 17;
                panel.add((Component)new FontAdjust.FontLabel("Position:"), c);
            }
            if (askX) {
                final FontAdjust.FontTextField xTextField = new FontAdjust.FontTextField(6);
                xTextField.setToolTipText("X coordinate, with default X-scale it is in seconds");
                xTextField.setText(StringUtil.formatDoubleEE(this.x1, false));
                xTextField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        x1 = Support.parseTextFieldDouble(xTextField, 0.0, false);
                        ChartAnnotations.valueChanged();
                    }
                });
                xTextField.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent arg0) {
                        x1 = Support.parseTextFieldDouble(xTextField, 0.0, false);
                        ChartAnnotations.valueChanged();
                    }
                });
                c = new GridBagConstraints();
                c.gridx = 1;
                c.gridy = 2;
                c.insets = new Insets(2, 2, 2, 2);
                c.anchor = 17;
                panel.add((Component)xTextField, c);
            }
            if (askY) {
                final FontAdjust.FontTextField yTextField = new FontAdjust.FontTextField(6);
                yTextField.setToolTipText("Y coordinate, this will match the selected curve");
                yTextField.setText(StringUtil.formatDoubleEE(this.y1, false));
                yTextField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        y1 = Support.parseTextFieldDouble(yTextField, 0.0, false);
                        ChartAnnotations.valueChanged();
                    }
                });
                yTextField.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent arg0) {
                        y1 = Support.parseTextFieldDouble(yTextField, 0.0, false);
                        ChartAnnotations.valueChanged();
                    }
                });
                c = new GridBagConstraints();
                c.gridx = 2;
                c.gridy = 2;
                c.insets = new Insets(2, 2, 2, 2);
                c.anchor = 17;
                panel.add((Component)yTextField, c);
            }
            return panel;
        }

        public String scriptWidthStyle() {
            return " " + StringUtil.formatDoubleEE(this.thickness, false) + " " + Support.conditionalQuote(this.style);
        }

        public String scriptBackground() {
            return " " + (this.background == null ? "-" : ColorUtil.colorToName(this.background));
        }

        public String scriptXY() {
            return " " + StringUtil.formatDoubleEE(this.x1, false) + " " + StringUtil.formatDoubleEE(this.y1, false);
        }
    }

    static abstract class AnnoXYXYWidthStyleBackground
    extends AnnoXYWidthStyleBackground {
        protected double x2 = 0.0;
        protected double y2 = 0.0;

        private AnnoXYXYWidthStyleBackground() {
        }

        public AnnoXYXYWidthStyleBackground(String axis, Color color, double x1, double y1, double x2, double y2, double thickness, String style, Color background) {
            super(axis, color, x1, y1, thickness, style, background);
            this.x2 = x2;
            this.y2 = y2;
        }

        public JPanel getEditPanel(String prompt, boolean askX, boolean askY, boolean askBackground) {
            JPanel panel = super.getEditPanel(askX, askY, askBackground);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 3;
            c.insets = new Insets(2, 2, 2, 2);
            c.anchor = 17;
            panel.add((Component)new FontAdjust.FontLabel(prompt), c);
            final FontAdjust.FontTextField xTextField = new FontAdjust.FontTextField(6);
            xTextField.setText(StringUtil.formatDoubleEE(this.x2, false));
            xTextField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    x2 = Support.parseTextFieldDouble(xTextField, 0.0, false);
                    ChartAnnotations.valueChanged();
                }
            });
            xTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent arg0) {
                    x2 = Support.parseTextFieldDouble(xTextField, 0.0, false);
                    ChartAnnotations.valueChanged();
                }
            });
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 3;
            c.insets = new Insets(2, 2, 2, 2);
            c.anchor = 17;
            panel.add((Component)xTextField, c);
            final FontAdjust.FontTextField yTextField = new FontAdjust.FontTextField(6);
            yTextField.setText(StringUtil.formatDoubleEE(this.y2, false));
            yTextField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    y2 = Support.parseTextFieldDouble(yTextField, 0.0, false);
                    ChartAnnotations.valueChanged();
                }
            });
            yTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent arg0) {
                    y2 = Support.parseTextFieldDouble(yTextField, 0.0, false);
                    ChartAnnotations.valueChanged();
                }
            });
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 3;
            c.insets = new Insets(2, 2, 2, 2);
            c.anchor = 17;
            panel.add((Component)yTextField, c);
            return panel;
        }

        public String scriptXY2() {
            return " " + StringUtil.formatDoubleEE(this.x2, false) + " " + StringUtil.formatDoubleEE(this.y2, false);
        }
    }

    public static class SmoothCurve
    extends Path2D.Double {
        double lastX;
        double lastY;
        int pointCounter = 0;
        boolean closed;
        double[] xx;
        double[] yy;

        public SmoothCurve(double[] xx, double[] yy, boolean closed) {
            if (xx.length == 0) {
                return;
            }
            this.closed = closed;
            this.xx = xx;
            this.yy = yy;
            if (closed) {
                double midx = (xx[0] + xx[xx.length - 1]) / 2.0;
                double midy = (yy[0] + yy[xx.length - 1]) / 2.0;
                this.moveTo(midx, midy);
                this.lastX = xx[0];
                this.lastY = yy[0];
                int i = 1;
                while (i < xx.length) {
                    this.addPointClosed(xx[i], yy[i]);
                    ++i;
                }
                midx = (xx[0] + this.lastX) / 2.0;
                midy = (yy[0] + this.lastY) / 2.0;
                this.quadTo(this.lastX, this.lastY, midx, midy);
            } else {
                int i = 0;
                while (i < xx.length) {
                    this.addPoint(xx[i], yy[i]);
                    ++i;
                }
                this.lineTo(xx[xx.length - 1], yy[xx.length - 1]);
            }
            xx = null;
            yy = null;
        }

        public void addPointClosed(double x, double y) {
            double midx = (x + this.lastX) / 2.0;
            double midy = (y + this.lastY) / 2.0;
            this.quadTo(this.lastX, this.lastY, midx, midy);
            this.lastX = x;
            this.lastY = y;
        }

        public void addPoint(double x, double y) {
            ++this.pointCounter;
            if (this.pointCounter == 1) {
                this.moveTo(x, y);
                this.lastX = x;
                this.lastY = y;
                return;
            }
            double midx = (x + this.lastX) / 2.0;
            double midy = (y + this.lastY) / 2.0;
            if (this.pointCounter < 3) {
                this.lineTo(midx, midy);
            } else {
                this.quadTo(this.lastX, this.lastY, midx, midy);
            }
            this.lastX = x;
            this.lastY = y;
        }
    }
}

