/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class CameraDigits {
    private Point tl = null;
    private Point tr = null;
    private Point bl = null;
    private Point br = null;
    private int digits = 3;
    private boolean half = false;
    private boolean sign = false;
    private Shape outline = null;
    private final int digitW = 50;
    private final int digitH = 80;
    private final int barW = 10;
    private int digitSpacing = 13;
    private double originalWidth = 0.0;
    private double originalHeight = 0.0;
    private List<Segment> segments = null;
    private List<Segment> segmentBackground = null;
    private boolean moved = false;

    CameraDigits() {
    }

    public void setDigitSpacing(int digitSpacing) {
        if (digitSpacing < 3) {
            digitSpacing = 3;
        }
        if (digitSpacing > 50) {
            digitSpacing = 50;
        }
        this.digitSpacing = digitSpacing;
        this.makeDigits();
    }

    public String location() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(this.tl.x) + "," + this.tl.y + ",");
        sb.append(String.valueOf(this.tr.x) + "," + this.tr.y + ",");
        sb.append(String.valueOf(this.bl.x) + "," + this.bl.y + ",");
        sb.append(String.valueOf(this.br.x) + "," + this.br.y + ",");
        return sb.toString();
    }

    public void setLocation(String location) {
        String[] loc = location.split(",");
        if (loc.length != 8) {
            return;
        }
        this.tl.x = Integer.parseInt(loc[0]);
        this.tl.y = Integer.parseInt(loc[1]);
        this.tr.x = Integer.parseInt(loc[2]);
        this.tr.y = Integer.parseInt(loc[3]);
        this.bl.x = Integer.parseInt(loc[4]);
        this.bl.y = Integer.parseInt(loc[5]);
        this.br.x = Integer.parseInt(loc[6]);
        this.br.y = Integer.parseInt(loc[7]);
    }

    public void setFormat(String format) {
        format = format.trim();
        this.digits = format.length();
        this.sign = format.startsWith("-");
        if (this.sign) {
            format = format.substring(1);
        }
        this.half = format.startsWith("1");
        this.makeDigits();
    }

    public void setFormat(int digits, boolean half, boolean sign) {
        this.digits = digits;
        this.half = half;
        this.sign = sign;
        this.makeDigits();
    }

    public void move(DigitArea item, int dx, int dy) {
        switch (item) {
            case all: {
                this.tl.x += dx;
                this.tl.y += dy;
                this.tr.x += dx;
                this.tr.y += dy;
                this.bl.x += dx;
                this.bl.y += dy;
                this.br.x += dx;
                this.br.y += dy;
                this.moved = true;
                break;
            }
            case bl: {
                this.bl.x += dx;
                this.bl.y += dy;
                this.moved = true;
                break;
            }
            case br: {
                this.br.x += dx;
                this.br.y += dy;
                this.moved = true;
                break;
            }
            case none: {
                break;
            }
            case tl: {
                this.tl.x += dx;
                this.tl.y += dy;
                this.moved = true;
                break;
            }
            case tr: {
                this.tr.x += dx;
                this.tr.y += dy;
                this.moved = true;
                break;
            }
        }
        this.defineSenseArea(true);
    }

    public boolean isMoved() {
        try {
            boolean bl = this.moved;
            return bl;
        }
        finally {
            this.moved = false;
        }
    }

    public String parseText(BufferedImage image) {
        double tripPoint = this.segmentBackground.get((int)0).calcArea((BufferedImage)image, (double)-1.0, (int)1).avg;
        CalcArea ca = this.segmentBackground.get(0).calcArea(image, tripPoint, 1);
        System.out.println("Avg:" + (int)ca.avg + "  below:" + ca.below + "  above:" + ca.above + "  n:" + ca.n);
        StringBuilder sb = new StringBuilder();
        for (Segment seg : this.segments) {
            if (!seg.isOn(image, tripPoint)) continue;
            sb.append(seg.getName());
        }
        return sb.toString();
    }

    public long getOnMask(BufferedImage image) {
        double tripPoint = this.segmentBackground.get((int)0).calcArea((BufferedImage)image, (double)-1.0, (int)1).avg;
        CalcArea ca = this.segmentBackground.get(0).calcArea(image, tripPoint, 1);
        long mask = 0L;
        System.out.print("Avg:" + (int)ca.avg + "  below:" + ca.below + "  above:" + ca.above + "  n:" + ca.n + " ");
        for (Segment seg : this.segments) {
            mask |= seg.getOnMask(image, ca.avg);
        }
        System.out.println();
        return mask;
    }

    public Double parse(BufferedImage image) {
        return Double.NaN;
    }

    public DigitArea getDigitArea(Point p) {
        int h;
        int w = Math.min(this.tr.x - this.tl.x, this.br.x - this.bl.x) / 8;
        int d = Math.min(w, h = Math.min(this.br.y - this.tr.y, this.bl.y - this.tl.y) / 3);
        if (d < 6) {
            d = 6;
        }
        if (p.distance(this.tl) < (double)d) {
            return DigitArea.tl;
        }
        if (p.distance(this.tr) < (double)d) {
            return DigitArea.tr;
        }
        if (p.distance(this.bl) < (double)d) {
            return DigitArea.bl;
        }
        if (p.distance(this.br) < (double)d) {
            return DigitArea.br;
        }
        if (this.outline.contains(p)) {
            return DigitArea.all;
        }
        return DigitArea.none;
    }

    protected void makeDigits() {
        this.segments = new ArrayList<Segment>();
        this.segmentBackground = new ArrayList<Segment>();
        double lw = 30.0;
        double lh = 25.0;
        double x0 = 0.0;
        double y0 = 0.0;
        double x = x0;
        double y = y0;
        int n = this.digits - 1;
        int dig = this.digits;
        if (this.sign) {
            this.segments.add(new SegmentMinus("-", n, x, y + 40.0, 25.0));
            x += 25.0;
            --dig;
            --n;
        }
        if (this.half) {
            this.segments.add(new SegmentLine("B", n, x + 5.0, y + 10.0, lh, false));
            this.segments.add(new SegmentLine("C", n, x + 5.0, y + 40.0 + 5.0, lw, false));
            this.segments.add(new SegmentDot(".", n, x + 10.0 + (double)(this.digitSpacing / 2), y + 80.0 - (double)(this.digitSpacing / 2), this.digitSpacing));
            x += (double)(10 + this.digitSpacing);
            --n;
            --dig;
        }
        int i = 0;
        while (i < dig) {
            this.segments.add(new SegmentLine("A", n, x + 10.0, y + 5.0, lw, true));
            this.segments.add(new SegmentLine("B", n, x + 50.0 - 5.0, y + 10.0, lh, false));
            this.segments.add(new SegmentLine("C", n, x + 50.0 - 5.0, y + 40.0 + 5.0, lw, false));
            this.segments.add(new SegmentLine("D", n, x + 10.0, y + 80.0 - 5.0, lw, true));
            this.segments.add(new SegmentLine("E", n, x + 5.0, y + 40.0 + 5.0, lh, false));
            this.segments.add(new SegmentLine("F", n, x + 5.0, y + 10.0, lh, false));
            this.segments.add(new SegmentLine("G", n, x + 10.0, y + 40.0, lw, true));
            this.segments.add(new SegmentDot(".", n, x + 50.0 + (double)(this.digitSpacing / 2), y + 80.0 - (double)(this.digitSpacing / 2), this.digitSpacing - 4));
            double sz = 8.0;
            this.segmentBackground.add(new SegmentDot("background", n, x + 25.0, y + 10.0 + sz, sz));
            x += (double)(50 + this.digitSpacing);
            --n;
            ++i;
        }
        if (this.tl == null) {
            this.tl = new Point((int)x0, (int)y0);
            this.tr = new Point((int)x, (int)y0);
            this.bl = new Point((int)x0, 80);
            this.br = new Point((int)x, 80);
        }
        this.originalWidth = x;
        this.originalHeight = 80.0;
        this.defineSenseArea(false);
    }

    public List<Shape> getShapes() {
        ArrayList<Shape> list = new ArrayList<Shape>();
        for (Segment seg : this.segments) {
            list.add(seg.getSegment());
        }
        Path2D.Double path = new Path2D.Double();
        path.moveTo(this.tl.x, this.tl.y);
        path.lineTo(this.tr.x, this.tr.y);
        path.lineTo(this.br.x, this.br.y);
        path.lineTo(this.bl.x, this.bl.y);
        path.lineTo(this.tl.x, this.tl.y);
        this.outline = path;
        int sz = 4;
        list.add(new Ellipse2D.Double(this.tl.x - sz, this.tl.y - sz, sz * 2, sz * 2));
        list.add(new Ellipse2D.Double(this.tr.x - sz, this.tr.y - sz, sz * 2, sz * 2));
        list.add(new Ellipse2D.Double(this.bl.x - sz, this.bl.y - sz, sz * 2, sz * 2));
        list.add(new Ellipse2D.Double(this.br.x - sz, this.br.y - sz, sz * 2, sz * 2));
        return list;
    }

    private void defineSenseArea(boolean onlyMap) {
        if (this.segments == null) {
            return;
        }
        for (Segment seg : this.segments) {
            if (!onlyMap) {
                seg.defineSenseArea();
            }
            seg.mapSenseArea();
        }
        for (Segment seg : this.segmentBackground) {
            if (!onlyMap) {
                seg.defineSenseArea();
            }
            seg.mapSenseArea();
        }
    }

    private static class CalcArea {
        double avg = 0.0;
        int above = 0;
        int below = 0;
        int n = 0;

        private CalcArea() {
        }
    }

    public static enum DigitArea {
        none,
        all,
        tl,
        tr,
        bl,
        br;

    }

    public abstract class Segment {
        protected double x0;
        protected double y0;
        protected String name;
        protected int digit;
        protected Point2D.Double[] senseArea = new Point2D.Double[4];
        protected Point2D.Double[] mappedSenseArea = new Point2D.Double[4];

        public String getName() {
            return String.valueOf(this.name) + this.digit;
        }

        protected Segment(String name, int digit, double x0, double y0) {
            this.name = name;
            this.digit = digit;
            this.x0 = x0;
            this.y0 = y0;
        }

        private void mapSenseArea() {
            int i = 0;
            while (i < 4) {
                double x = this.senseArea[i].x;
                double y = this.senseArea[i].y;
                double yl = ((CameraDigits)CameraDigits.this).bl.y - ((CameraDigits)CameraDigits.this).tl.y;
                double yr = ((CameraDigits)CameraDigits.this).br.y - ((CameraDigits)CameraDigits.this).tr.y;
                double xt = ((CameraDigits)CameraDigits.this).tr.x - ((CameraDigits)CameraDigits.this).tl.x;
                double xb = ((CameraDigits)CameraDigits.this).br.x - ((CameraDigits)CameraDigits.this).bl.x;
                double xpct = x / CameraDigits.this.originalWidth;
                double ypct = y / CameraDigits.this.originalHeight;
                double x1 = (xpct * xt + (double)((CameraDigits)CameraDigits.this).tl.x) * (1.0 - ypct) + (xpct * xb + (double)((CameraDigits)CameraDigits.this).bl.x) * ypct;
                double y1 = (ypct * yl + (double)((CameraDigits)CameraDigits.this).tl.y) * (1.0 - xpct) + (ypct * yr + (double)((CameraDigits)CameraDigits.this).tr.y) * xpct;
                this.mappedSenseArea[i] = new Point2D.Double(x1, y1);
                ++i;
            }
        }

        protected void moveTo(Path2D.Double path, double x, double y) {
            double yl = ((CameraDigits)CameraDigits.this).bl.y - ((CameraDigits)CameraDigits.this).tl.y;
            double yr = ((CameraDigits)CameraDigits.this).br.y - ((CameraDigits)CameraDigits.this).tr.y;
            double xt = ((CameraDigits)CameraDigits.this).tr.x - ((CameraDigits)CameraDigits.this).tl.x;
            double xb = ((CameraDigits)CameraDigits.this).br.x - ((CameraDigits)CameraDigits.this).bl.x;
            double xpct = x / CameraDigits.this.originalWidth;
            double ypct = y / CameraDigits.this.originalHeight;
            double x1 = (xpct * xt + (double)((CameraDigits)CameraDigits.this).tl.x) * (1.0 - ypct) + (xpct * xb + (double)((CameraDigits)CameraDigits.this).bl.x) * ypct;
            double y1 = (ypct * yl + (double)((CameraDigits)CameraDigits.this).tl.y) * (1.0 - xpct) + (ypct * yr + (double)((CameraDigits)CameraDigits.this).tr.y) * xpct;
            path.moveTo(x1, y1);
        }

        protected void lineTo(Path2D.Double path, double x, double y) {
            double yl = ((CameraDigits)CameraDigits.this).bl.y - ((CameraDigits)CameraDigits.this).tl.y;
            double yr = ((CameraDigits)CameraDigits.this).br.y - ((CameraDigits)CameraDigits.this).tr.y;
            double xt = ((CameraDigits)CameraDigits.this).tr.x - ((CameraDigits)CameraDigits.this).tl.x;
            double xb = ((CameraDigits)CameraDigits.this).br.x - ((CameraDigits)CameraDigits.this).bl.x;
            double xpct = x / CameraDigits.this.originalWidth;
            double ypct = y / CameraDigits.this.originalHeight;
            double x1 = (xpct * xt + (double)((CameraDigits)CameraDigits.this).tl.x) * (1.0 - ypct) + (xpct * xb + (double)((CameraDigits)CameraDigits.this).bl.x) * ypct;
            double y1 = (ypct * yl + (double)((CameraDigits)CameraDigits.this).tl.y) * (1.0 - xpct) + (ypct * yr + (double)((CameraDigits)CameraDigits.this).tr.y) * xpct;
            path.lineTo(x1, y1);
        }

        public abstract Shape getSegment();

        public Shape senseArea() {
            Path2D.Double path = new Path2D.Double();
            path.moveTo(this.mappedSenseArea[0].x, this.mappedSenseArea[0].y);
            path.lineTo(this.mappedSenseArea[1].x, this.mappedSenseArea[1].y);
            path.lineTo(this.mappedSenseArea[2].x, this.mappedSenseArea[2].y);
            path.lineTo(this.mappedSenseArea[3].x, this.mappedSenseArea[3].y);
            path.lineTo(this.mappedSenseArea[0].x, this.mappedSenseArea[0].y);
            return path;
        }

        public abstract void defineSenseArea();

        public CalcArea calcArea(BufferedImage img, double tripPoint, int step) {
            CalcArea ca = new CalcArea();
            double yl = ((CameraDigits)CameraDigits.this).bl.y - ((CameraDigits)CameraDigits.this).tl.y;
            double yr = ((CameraDigits)CameraDigits.this).br.y - ((CameraDigits)CameraDigits.this).tr.y;
            double xt = ((CameraDigits)CameraDigits.this).tr.x - ((CameraDigits)CameraDigits.this).tl.x;
            double xb = ((CameraDigits)CameraDigits.this).br.x - ((CameraDigits)CameraDigits.this).bl.x;
            double y = this.senseArea[0].y;
            while (y < this.senseArea[1].y) {
                double x = this.senseArea[0].x;
                while (x < this.senseArea[2].x) {
                    double xpct = x / CameraDigits.this.originalWidth;
                    double ypct = y / CameraDigits.this.originalHeight;
                    int x1 = (int)((xpct * xt + (double)((CameraDigits)CameraDigits.this).tl.x) * (1.0 - ypct) + (xpct * xb + (double)((CameraDigits)CameraDigits.this).bl.x) * ypct);
                    int y1 = (int)((ypct * yl + (double)((CameraDigits)CameraDigits.this).tl.y) * (1.0 - xpct) + (ypct * yr + (double)((CameraDigits)CameraDigits.this).tr.y) * xpct);
                    if (x1 >= 0 && x1 < img.getWidth() && y1 >= 0 && y1 < img.getHeight()) {
                        int c = img.getRGB(x1, y1);
                        int blue = c & 0xFF;
                        int green = (c & 0xFF00) >> 8;
                        int red = (c & 0xFF0000) >> 16;
                        int gray = (int)(0.2126 * (double)red + 0.7152 * (double)green + 0.0722 * (double)blue);
                        ca.avg += (double)gray;
                        if ((double)gray > tripPoint + 8.0) {
                            ++ca.above;
                        }
                        if ((double)gray < tripPoint - 8.0) {
                            ++ca.below;
                        }
                        ++ca.n;
                    }
                    x += (double)step;
                }
                y += (double)step;
            }
            ca.avg /= (double)ca.n;
            return ca;
        }

        public boolean isOn(BufferedImage img, double tripPoint) {
            CalcArea ca = this.calcArea(img, tripPoint, 2);
            System.out.print(String.valueOf((int)ca.avg) + " ");
            return ca.below > ca.n / 10 || ca.above > ca.n / 10;
        }

        public long getOnMask(BufferedImage img, double tripPoint) {
            long mask = 0L;
            if (this.isOn(img, tripPoint)) {
                char c = this.name.toUpperCase().charAt(0);
                if (c == 'A') {
                    mask |= 1L;
                }
                if (c == 'B') {
                    mask |= 2L;
                }
                if (c == 'C') {
                    mask |= 4L;
                }
                if (c == 'D') {
                    mask |= 8L;
                }
                if (c == 'E') {
                    mask |= 0x10L;
                }
                if (c == 'F') {
                    mask |= 0x20L;
                }
                if (c == 'G') {
                    mask |= 0x40L;
                }
                if (c == '.' || c == '-') {
                    mask |= 0x80L;
                }
                mask <<= 8 * this.digit;
            }
            return mask;
        }
    }

    public class SegmentDot
    extends Segment {
        private double sz;

        public SegmentDot(String name, int digit, double x0, double y0, double sz) {
            super(name, digit, x0, y0);
            this.sz = sz;
            this.defineSenseArea();
        }

        @Override
        public void defineSenseArea() {
            this.senseArea[0] = new Point2D.Double(this.x0 - this.sz / 2.0, this.y0 - this.sz / 2.0);
            this.senseArea[1] = new Point2D.Double(this.x0 - this.sz / 2.0, this.y0 + this.sz / 2.0);
            this.senseArea[2] = new Point2D.Double(this.x0 + this.sz / 2.0, this.y0 + this.sz / 2.0);
            this.senseArea[3] = new Point2D.Double(this.x0 + this.sz / 2.0, this.y0 - this.sz / 2.0);
        }

        @Override
        public Shape getSegment() {
            Path2D.Double path = new Path2D.Double();
            this.moveTo(path, this.x0 - this.sz / 2.0, this.y0 - this.sz / 2.0);
            this.lineTo(path, this.x0 - this.sz / 2.0, this.y0 + this.sz / 2.0);
            this.lineTo(path, this.x0 + this.sz / 2.0, this.y0 + this.sz / 2.0);
            this.lineTo(path, this.x0 + this.sz / 2.0, this.y0 - this.sz / 2.0);
            this.lineTo(path, this.x0 - this.sz / 2.0, this.y0 - this.sz / 2.0);
            return path;
        }
    }

    public class SegmentLine
    extends Segment {
        private double length;
        private boolean horizontal;

        public SegmentLine(String name, int digit, double x0, double y0, double length, boolean horizontal) {
            super(name, digit, x0, y0);
            this.length = length;
            this.horizontal = horizontal;
            this.defineSenseArea();
        }

        @Override
        public void defineSenseArea() {
            if (this.horizontal) {
                this.senseArea[0] = new Point2D.Double(this.x0 + this.length / 2.0 - 5.0, this.y0 - 10.0);
                this.senseArea[1] = new Point2D.Double(this.x0 + this.length / 2.0 - 5.0, this.y0 + 10.0);
                this.senseArea[2] = new Point2D.Double(this.x0 + this.length / 2.0 + 5.0, this.y0 + 10.0);
                this.senseArea[3] = new Point2D.Double(this.x0 + this.length / 2.0 + 5.0, this.y0 - 10.0);
            } else {
                this.senseArea[0] = new Point2D.Double(this.x0 - 10.0, this.y0 + this.length / 2.0 - 5.0);
                this.senseArea[1] = new Point2D.Double(this.x0 - 10.0, this.y0 + this.length / 2.0 + 5.0);
                this.senseArea[2] = new Point2D.Double(this.x0 + 10.0, this.y0 + this.length / 2.0 + 5.0);
                this.senseArea[3] = new Point2D.Double(this.x0 + 10.0, this.y0 + this.length / 2.0 - 5.0);
            }
        }

        @Override
        public Shape getSegment() {
            Path2D.Double path = new Path2D.Double();
            if (this.horizontal) {
                this.moveTo(path, this.x0, this.y0 - 5.0);
                this.lineTo(path, this.x0 + this.length, this.y0 - 5.0);
                this.lineTo(path, this.x0 + this.length, this.y0 + 5.0);
                this.lineTo(path, this.x0, this.y0 + 5.0);
                this.lineTo(path, this.x0, this.y0 - 5.0);
            } else {
                this.moveTo(path, this.x0 - 5.0, this.y0);
                this.lineTo(path, this.x0 - 5.0, this.y0 + this.length);
                this.lineTo(path, this.x0 + 5.0, this.y0 + this.length);
                this.lineTo(path, this.x0 + 5.0, this.y0);
                this.lineTo(path, this.x0 - 5.0, this.y0);
            }
            return path;
        }
    }

    public class SegmentMinus
    extends Segment {
        private double sz;

        public SegmentMinus(String name, int digit, double x0, double y0, double sz) {
            super(name, digit, x0, y0);
            this.sz = sz;
            this.defineSenseArea();
        }

        @Override
        public void defineSenseArea() {
            this.senseArea[0] = new Point2D.Double(this.x0, this.y0 - 5.0);
            this.senseArea[1] = new Point2D.Double(this.x0, this.y0 + 5.0);
            this.senseArea[2] = new Point2D.Double(this.x0 + this.sz, this.y0 + 5.0);
            this.senseArea[3] = new Point2D.Double(this.x0 + this.sz, this.y0 - 5.0);
        }

        @Override
        public Shape getSegment() {
            Path2D.Double path = new Path2D.Double();
            this.moveTo(path, this.x0, this.y0 - 5.0);
            this.lineTo(path, this.x0, this.y0 + 5.0);
            this.lineTo(path, this.x0 + this.sz, this.y0 + 5.0);
            this.lineTo(path, this.x0 + this.sz, this.y0 - 5.0);
            this.lineTo(path, this.x0, this.y0 - 5.0);
            return path;
        }
    }
}

