/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.ValueFormat;
import dk.hkj.util.AudibleAlarm;
import dk.hkj.util.StringUtil;
import java.awt.Robot;
import java.awt.event.KeyEvent;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class AutoHold {
    private double tolerance = 0.03;
    private double lockTime = 1.0;
    private double minValue = 0.0;
    private List<Double> sampleList = new ArrayList<Double>();
    private List<Measurement> measurementList = new ArrayList<Measurement>();
    private boolean armed = false;
    protected TypeOption typeOption = TypeOption.None;
    private Robot robot = null;
    private Object base = null;
    protected double currentValue = Double.NaN;

    public AutoHold(Object base) {
        this.base = base;
    }

    public void setTypeOption(TypeOption typeOption) {
        this.typeOption = typeOption;
        if (typeOption != TypeOption.None) {
            try {
                this.robot = new Robot();
            }
            catch (Exception exception) {
                this.robot = null;
            }
        }
    }

    public TypeOption getTypeOption() {
        return this.typeOption;
    }

    private void typeMessage(String message) {
        if (this.robot == null || this.typeOption == TypeOption.None) {
            return;
        }
        if (this.base != null) {
            if (this.base instanceof JFrame && ((JFrame)this.base).isActive()) {
                return;
            }
            if (this.base instanceof JDialog && ((JDialog)this.base).isActive()) {
                return;
            }
        }
        char[] cArray = message.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            int keyCode = KeyEvent.getExtendedKeyCodeForChar(c);
            if (keyCode != 0) {
                this.robot.keyPress(keyCode);
                this.robot.delay(10);
                this.robot.keyRelease(keyCode);
            }
            ++n2;
        }
        switch (this.typeOption) {
            case None: {
                return;
            }
            case WithEnter: {
                this.robot.keyPress(10);
                this.robot.delay(10);
                this.robot.keyRelease(10);
                break;
            }
            case WithDown: {
                this.robot.keyPress(40);
                this.robot.delay(10);
                this.robot.keyRelease(40);
                break;
            }
            case WithRight: {
                this.robot.keyPress(39);
                this.robot.delay(10);
                this.robot.keyRelease(39);
                break;
            }
            case WithTab: {
                this.robot.keyPress(9);
                this.robot.delay(10);
                this.robot.keyRelease(9);
                break;
            }
        }
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public double getLockTime() {
        return this.lockTime;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setTolerance(double v) {
        if (v > 0.0 && v < 1.0) {
            this.tolerance = v;
        }
    }

    public void setLockTime(double v) {
        if (v >= 0.7 && v < 10.0) {
            this.lockTime = v;
        }
    }

    public void setMinValue(double v) {
        if (v >= 0.0 && v < 1.0E12) {
            this.minValue = v;
        }
    }

    public void addSampleDirect() {
        this.sampleList.add(this.currentValue);
        AudibleAlarm.play(100, 200, 0, 1, new AudibleAlarm.AlarmSound('s', 700, 700, 100, 100));
        this.armed = false;
    }

    public boolean newValue(double v) {
        this.currentValue = v;
        this.measurementList.add(new Measurement(this.currentValue));
        while (this.measurementList.get((int)(this.measurementList.size() - 1)).time - this.measurementList.get((int)0).time > this.lockTime) {
            this.measurementList.remove(0);
        }
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        double avg = 0.0;
        for (Measurement m : this.measurementList) {
            if (m.value > max) {
                max = m.value;
            }
            if (m.value < min) {
                min = m.value;
            }
            avg += m.value;
        }
        double tt = Math.abs(avg / (double)this.measurementList.size() * this.tolerance);
        if (Math.abs(this.currentValue) >= this.minValue && this.measurementList.size() >= 2 && max - min < tt && this.armed) {
            this.sampleList.add(this.currentValue);
            AudibleAlarm.play(100, 200, 0, 1, new AudibleAlarm.AlarmSound('s', 700, 700, 100, 100));
            this.typeMessage(Double.toString(this.currentValue).replace('.', DecimalFormatSymbols.getInstance().getDecimalSeparator()));
            this.armed = false;
            return true;
        }
        if (this.sampleList.size() == 0 || Math.abs(this.currentValue - this.sampleList.get(this.sampleList.size() - 1)) > tt * 2.0) {
            this.armed = true;
        }
        return false;
    }

    public String getSampleAsString(int i, ValueFormat.ValueFormatter vf) {
        return this.sampleList.size() - i < 1 ? "" : vf.formatDisplay(this.sampleList.get(this.sampleList.size() - 1 - i));
    }

    public double getCurrentValue() {
        return this.currentValue;
    }

    public void reset() {
        this.sampleList.clear();
    }

    public List<Double> getSampleList() {
        return this.sampleList;
    }

    public String generateParams() {
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtil.formatDoubleEE(this.getTolerance() * 100.0, false));
        sb.append(" ");
        sb.append(StringUtil.formatDoubleEE(this.getLockTime(), false));
        sb.append(" ");
        sb.append(StringUtil.formatDoubleEE(this.getMinValue(), false));
        return sb.toString();
    }

    private class Measurement {
        double value;
        double time;

        Measurement(double value) {
            this.value = value;
            this.time = (double)System.currentTimeMillis() / 1000.0;
        }
    }

    public static enum TypeOption {
        None,
        WithEnter,
        WithRight,
        WithDown,
        WithTab;

    }
}

