/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.comm.CommInterface;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.SCPICommand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class AsyncHandler {
    private Map<String, AsyncThread> active = Collections.synchronizedMap(new HashMap());
    private final String END_OF_TASK = "\b\n\r[{*END*}]\r\n\b";

    AsyncHandler() {
    }

    public synchronized void add(String handle, String cmds) {
        InterfaceThreads.DeviceThread dt = InterfaceThreads.deviceMap.get(handle = handle.toUpperCase());
        if (dt == null) {
            return;
        }
        AsyncThread at = this.active.get(handle);
        if (at == null) {
            at = new AsyncThread(handle, dt);
        }
        at.add(cmds);
    }

    public synchronized void add(List<String> handles, String cmds) {
        for (String handle : handles) {
            this.add(handle, cmds);
        }
    }

    public synchronized void waitDone() {
        ArrayList<AsyncThread> list = new ArrayList<AsyncThread>(this.active.size());
        list.addAll(this.active.values());
        for (AsyncThread at : list) {
            at.setQuitWhenDone();
        }
        while (!this.active.isEmpty()) {
            CommInterface.sleep(1);
        }
    }

    private class AsyncThread
    extends Thread {
        private String handle = null;
        private InterfaceThreads.DeviceThread dt = null;
        private BlockingQueue<String> queue = new ArrayBlockingQueue<String>(100);

        AsyncThread(String handle, InterfaceThreads.DeviceThread dt) {
            this.handle = handle;
            this.dt = dt;
            this.setDaemon(true);
            AsyncHandler.this.active.put(handle, this);
            try {
                this.start();
            }
            catch (Exception exception) {
                AsyncHandler.this.active.remove(this);
            }
        }

        public void setQuitWhenDone() {
            this.add("\b\n\r[{*END*}]\r\n\b");
        }

        public void add(String cmds) {
            try {
                this.queue.put(cmds);
            }
            catch (InterruptedException interruptedException) {}
        }

        @Override
        public void run() {
            SCPICommand scpiCmd = new SCPICommand(this.dt.getDeviceInterface(), "");
            while (true) {
                try {
                    while (true) {
                        String cmd;
                        if ((cmd = this.queue.take()) == null) {
                            continue;
                        }
                        if (cmd.equals("\b\n\r[{*END*}]\r\n\b")) {
                            AsyncHandler.this.active.remove(this.handle);
                            return;
                        }
                        if (cmd.length() <= 0) continue;
                        scpiCmd.writeDirect(cmd);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

