/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.font;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;

public class FontAdjust {
    public static FontSizes fontSizes = new FontSizes();
    private static List<FontChangeListener> fontChangeListeners = new ArrayList<FontChangeListener>();

    public static void setFontScale(double scale) {
        FontAdjust.fontSizes.scale = scale;
        FontAdjust.fontSizes.textFont = new Font("Dialog", 0, (int)(12.0 * scale + 0.5));
        FontAdjust.fontSizes.tableRowHeight = (int)(16.0 * scale + 0.5);
        FontAdjust.fontSizes.tableLargeFont = new Font("Dialog", 0, (int)(20.0 * scale + 0.5));
        FontAdjust.fontSizes.tableLargeRowHeight = (int)(28.0 * scale + 0.5);
        FontAdjust.fontSizes.uiFont = new Font("Dialog", 1, (int)(12.0 * scale + 0.5));
        UIManager.put("ToolTip.font", FontAdjust.fontSizes.uiFont);
        UIManager.put("OptionPane.messageFont", FontAdjust.fontSizes.textFont);
        UIManager.put("OptionPane.buttonFont", FontAdjust.fontSizes.uiFont);
        for (FontChangeListener fcl : fontChangeListeners) {
            fcl.fontChange();
        }
    }

    public static class FontButton
    extends JButton
    implements FontChangeListener {
        public FontButton() {
            fontChangeListeners.add(this);
            this.fontChange();
        }

        public FontButton(String string) {
            super(string);
            fontChangeListeners.add(this);
            this.fontChange();
        }

        @Override
        public void fontChange() {
            if (FontAdjust.fontSizes.scale == 0.0) {
                return;
            }
            this.setFont(FontAdjust.fontSizes.uiFont);
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            fontChangeListeners.remove(this);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (!fontChangeListeners.contains(this)) {
                fontChangeListeners.add(this);
            }
        }
    }

    private static interface FontChangeListener {
        public void fontChange();
    }

    public static class FontCheckBox
    extends JCheckBox
    implements FontChangeListener {
        public FontCheckBox() {
            fontChangeListeners.add(this);
            this.fontChange();
        }

        public FontCheckBox(String string) {
            super(string);
            fontChangeListeners.add(this);
            this.fontChange();
        }

        @Override
        public void fontChange() {
            if (FontAdjust.fontSizes.scale == 0.0) {
                return;
            }
            this.setFont(FontAdjust.fontSizes.uiFont);
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            fontChangeListeners.remove(this);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (!fontChangeListeners.contains(this)) {
                fontChangeListeners.add(this);
            }
        }
    }

    public static class FontCheckBoxMenuItem
    extends JCheckBoxMenuItem
    implements FontChangeListener {
        public FontCheckBoxMenuItem() {
            fontChangeListeners.add(this);
            this.fontChange();
        }

        public FontCheckBoxMenuItem(String string) {
            super(string);
            fontChangeListeners.add(this);
            this.fontChange();
        }

        @Override
        public void fontChange() {
            if (FontAdjust.fontSizes.scale == 0.0) {
                return;
            }
            this.setFont(FontAdjust.fontSizes.uiFont);
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            fontChangeListeners.remove(this);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (!fontChangeListeners.contains(this)) {
                fontChangeListeners.add(this);
            }
        }
    }

    public static class FontComboBox<T>
    extends JComboBox<T>
    implements FontChangeListener {
        public FontComboBox() {
            fontChangeListeners.add(this);
        }

        @Override
        public void fontChange() {
            if (FontAdjust.fontSizes.scale == 0.0) {
                return;
            }
            this.setFont(FontAdjust.fontSizes.uiFont);
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            fontChangeListeners.remove(this);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (!fontChangeListeners.contains(this)) {
                fontChangeListeners.add(this);
            }
            this.fontChange();
        }
    }

    public static class FontFileChooser
    extends JFileChooser
    implements FontChangeListener {
        public FontFileChooser() {
            fontChangeListeners.add(this);
        }

        public FontFileChooser(String string) {
            super(string);
            fontChangeListeners.add(this);
        }

        private void setFileChooserFont(Component[] comp) {
            int x = 0;
            while (x < comp.length) {
                if (comp[x] instanceof Container) {
                    this.setFileChooserFont(((Container)comp[x]).getComponents());
                }
                try {
                    if (comp[x] instanceof JTextField) {
                        comp[x].setFont(FontAdjust.fontSizes.textFont);
                    } else {
                        comp[x].setFont(FontAdjust.fontSizes.uiFont);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++x;
            }
        }

        @Override
        public void fontChange() {
            if (FontAdjust.fontSizes.scale == 0.0) {
                return;
            }
            this.setFont(FontAdjust.fontSizes.uiFont);
            this.setFileChooserFont(this.getComponents());
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            fontChangeListeners.remove(this);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (!fontChangeListeners.contains(this)) {
                fontChangeListeners.add(this);
            }
            this.fontChange();
        }
    }

    public static class FontLabel
    extends JLabel
    implements FontChangeListener {
        private boolean largeText = false;

        public FontLabel() {
            fontChangeListeners.add(this);
            this.fontChange();
        }

        public FontLabel(String string) {
            super(string);
            fontChangeListeners.add(this);
            this.fontChange();
        }

        @Override
        public void fontChange() {
            if (FontAdjust.fontSizes.scale == 0.0) {
                return;
            }
            this.setFont(this.largeText ? FontAdjust.fontSizes.uiFont.deriveFont((float)FontAdjust.fontSizes.uiFont.getSize() * 2.0f) : FontAdjust.fontSizes.uiFont);
        }

        public void setLargeFont(boolean large) {
            this.largeText = true;
            this.fontChange();
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            fontChangeListeners.remove(this);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (!fontChangeListeners.contains(this)) {
                fontChangeListeners.add(this);
            }
        }
    }

    public static class FontList<T>
    extends JList<T>
    implements FontChangeListener {
        public FontList() {
            fontChangeListeners.add(this);
        }

        @Override
        public void fontChange() {
            if (FontAdjust.fontSizes.scale == 0.0) {
                return;
            }
            this.setFont(FontAdjust.fontSizes.uiFont);
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            fontChangeListeners.remove(this);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (!fontChangeListeners.contains(this)) {
                fontChangeListeners.add(this);
            }
            this.fontChange();
        }
    }

    public static class FontMenu
    extends JMenu
    implements FontChangeListener {
        public FontMenu() {
            fontChangeListeners.add(this);
            this.fontChange();
        }

        public FontMenu(String string) {
            super(string);
            fontChangeListeners.add(this);
            this.fontChange();
        }

        @Override
        public void fontChange() {
            if (FontAdjust.fontSizes.scale == 0.0) {
                return;
            }
            this.setFont(FontAdjust.fontSizes.uiFont);
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            fontChangeListeners.remove(this);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (!fontChangeListeners.contains(this)) {
                fontChangeListeners.add(this);
            }
        }
    }

    public static class FontMenuItem
    extends JMenuItem
    implements FontChangeListener {
        public FontMenuItem() {
            fontChangeListeners.add(this);
            this.fontChange();
        }

        public FontMenuItem(String string) {
            super(string);
            fontChangeListeners.add(this);
            this.fontChange();
        }

        @Override
        public void fontChange() {
            if (FontAdjust.fontSizes.scale == 0.0) {
                return;
            }
            this.setFont(FontAdjust.fontSizes.uiFont);
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            fontChangeListeners.remove(this);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (!fontChangeListeners.contains(this)) {
                fontChangeListeners.add(this);
            }
        }
    }

    public static class FontPanel
    extends JPanel
    implements FontChangeListener {
        private int scaleWidth = 0;
        private int scaleHeight = 0;

        public FontPanel() {
            fontChangeListeners.add(this);
        }

        public void setScaleWidth(int w) {
            this.scaleWidth = w;
        }

        public void setScaleHeight(int h) {
            this.scaleHeight = h;
        }

        @Override
        public void fontChange() {
            if (FontAdjust.fontSizes.scale == 0.0) {
                return;
            }
            this.setFont(FontAdjust.fontSizes.uiFont);
            if (this.getBorder() instanceof TitledBorder) {
                ((TitledBorder)this.getBorder()).setTitleFont(FontAdjust.fontSizes.uiFont);
            }
            Dimension d = new Dimension(this.getSize());
            if (this.scaleWidth > 0) {
                d.width = (int)((double)this.scaleWidth * FontAdjust.fontSizes.scale + 0.5);
            }
            if (this.scaleHeight > 0) {
                d.height = (int)((double)this.scaleHeight * FontAdjust.fontSizes.scale + 0.5);
            }
            this.setPreferredSize(d);
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            fontChangeListeners.remove(this);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (!fontChangeListeners.contains(this)) {
                fontChangeListeners.add(this);
            }
            this.fontChange();
        }
    }

    public static class FontRadioButton
    extends JRadioButton
    implements FontChangeListener {
        public FontRadioButton() {
            fontChangeListeners.add(this);
            this.fontChange();
        }

        public FontRadioButton(String string) {
            super(string);
            fontChangeListeners.add(this);
            this.fontChange();
        }

        @Override
        public void fontChange() {
            if (FontAdjust.fontSizes.scale == 0.0) {
                return;
            }
            this.setFont(FontAdjust.fontSizes.uiFont);
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            fontChangeListeners.remove(this);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (!fontChangeListeners.contains(this)) {
                fontChangeListeners.add(this);
            }
        }
    }

    public static class FontRadioButtonMenuItem
    extends JRadioButtonMenuItem
    implements FontChangeListener {
        public FontRadioButtonMenuItem() {
            fontChangeListeners.add(this);
            this.fontChange();
        }

        public FontRadioButtonMenuItem(String string) {
            super(string);
            fontChangeListeners.add(this);
            this.fontChange();
        }

        @Override
        public void fontChange() {
            if (FontAdjust.fontSizes.scale == 0.0) {
                return;
            }
            this.setFont(FontAdjust.fontSizes.uiFont);
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            fontChangeListeners.remove(this);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (!fontChangeListeners.contains(this)) {
                fontChangeListeners.add(this);
            }
        }
    }

    public static class FontSizes {
        public double scale = 1.0;
        public Font textFont;
        public int tableRowHeight;
        public Font tableLargeFont;
        public int tableLargeRowHeight;
        public Font uiFont;
    }

    public static class FontSlider
    extends JSlider
    implements FontChangeListener {
        public FontSlider() {
            fontChangeListeners.add(this);
            this.fontChange();
        }

        public FontSlider(int orientation) {
            super(orientation);
            fontChangeListeners.add(this);
            this.fontChange();
        }

        public FontSlider(int min, int max) {
            super(min, max);
            fontChangeListeners.add(this);
            this.fontChange();
        }

        @Override
        public void fontChange() {
            if (FontAdjust.fontSizes.scale == 0.0) {
                return;
            }
            this.setFont(FontAdjust.fontSizes.uiFont);
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            fontChangeListeners.remove(this);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (!fontChangeListeners.contains(this)) {
                fontChangeListeners.add(this);
            }
        }
    }

    public static class FontTabbedPane
    extends JTabbedPane
    implements FontChangeListener {
        public FontTabbedPane() {
            fontChangeListeners.add(this);
        }

        @Override
        public void fontChange() {
            if (FontAdjust.fontSizes.scale == 0.0) {
                return;
            }
            this.setFont(FontAdjust.fontSizes.uiFont);
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            fontChangeListeners.remove(this);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (!fontChangeListeners.contains(this)) {
                fontChangeListeners.add(this);
            }
            this.fontChange();
        }
    }

    public static class FontTable
    extends JTable
    implements FontChangeListener {
        public FontTable(TableModel statValues) {
            super(statValues);
            fontChangeListeners.add(this);
            this.fontChange();
        }

        public FontTable() {
            fontChangeListeners.add(this);
            this.fontChange();
        }

        @Override
        public void fontChange() {
            if (FontAdjust.fontSizes.scale == 0.0) {
                return;
            }
            this.setFont(FontAdjust.fontSizes.textFont);
            this.setRowHeight(FontAdjust.fontSizes.tableRowHeight);
            this.getTableHeader().setFont(FontAdjust.fontSizes.textFont);
        }
    }

    public static class FontTextArea
    extends JTextArea
    implements FontChangeListener {
        public FontTextArea() {
            fontChangeListeners.add(this);
            this.fontChange();
        }

        public FontTextArea(String string) {
            super(string);
            fontChangeListeners.add(this);
            this.fontChange();
        }

        public FontTextArea(int rows, int columns) {
            super(rows, columns);
            fontChangeListeners.add(this);
            this.fontChange();
        }

        @Override
        public void fontChange() {
            if (FontAdjust.fontSizes.scale == 0.0) {
                return;
            }
            this.setFont(FontAdjust.fontSizes.textFont);
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            fontChangeListeners.remove(this);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (!fontChangeListeners.contains(this)) {
                fontChangeListeners.add(this);
            }
        }
    }

    public static class FontTextField
    extends JTextField
    implements FontChangeListener {
        public FontTextField() {
            fontChangeListeners.add(this);
            this.fontChange();
        }

        public FontTextField(String string) {
            super(string);
            fontChangeListeners.add(this);
            this.fontChange();
        }

        public FontTextField(int i) {
            super(i);
            fontChangeListeners.add(this);
            this.fontChange();
        }

        @Override
        public void fontChange() {
            if (FontAdjust.fontSizes.scale == 0.0) {
                return;
            }
            this.setFont(FontAdjust.fontSizes.textFont);
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            fontChangeListeners.remove(this);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (!fontChangeListeners.contains(this)) {
                fontChangeListeners.add(this);
            }
        }
    }
}

