/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.dmm;

import dk.hkj.dmm.DMMSupport;
import dk.hkj.dmm.DecoderDMM;
import dk.hkj.dmm.DecoderES51922;
import java.util.Arrays;
import java.util.List;

public class DecoderMastechMS8040
extends DecoderES51922 {
    @Override
    public DecoderDMM.DecodePack decode(byte[] data) {
        byte v5;
        if (data.length != 12) {
            return null;
        }
        byte v1 = data[1];
        byte v2 = data[2];
        byte v3 = data[3];
        byte v4 = data[4];
        data[1] = v5 = data[5];
        data[2] = v4;
        data[3] = v3;
        data[4] = v2;
        data[5] = v1;
        DecoderDMM.DecodePack dp = super.decode(data);
        dp.hold = this.dm.hold;
        if (this.dm.min) {
            dp.values = DecoderDMM.Values.min;
        }
        if (this.dm.max) {
            dp.values = DecoderDMM.Values.max;
        }
        if (this.dm.rel) {
            dp.values = DecoderDMM.Values.relative;
        }
        if (this.dm.judge && dp.function == DMMSupport.MeasurementFunction.TEMPERATURE) {
            dp.value1 = (dp.value1 - 32.0) / 1.8;
        }
        return dp;
    }

    @Override
    public List<String> getCommSettings() {
        return Arrays.asList("baudrate=19200", "parity=odd", "databits=7", "stopbits=1", "eol=10", "portdtr=1", "portrts=0");
    }

    @Override
    public List<String> getSupportedDMM() {
        return Arrays.asList("Mastech MS8040");
    }
}

