/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.dmm;

import dk.hkj.dmm.DMMSupport;
import dk.hkj.dmm.DecoderDMM;
import java.util.Arrays;
import java.util.List;

public class DecoderES51922
extends DecoderDMM {
    protected DecodedMessage dm = null;

    @Override
    public DecoderDMM.DecodePack decode(byte[] data) {
        if (data.length != 12) {
            return null;
        }
        DecoderDMM.DecodePack dp = new DecoderDMM.DecodePack();
        dp.orginalData = data;
        this.dm = new DecodedMessage(data);
        int v = (int)this.getValue(data, 1, 5);
        boolean useFreq = false;
        dp.overload = this.dm.ol;
        double scale = 1.0;
        if (this.dm.function == 59) {
            dp.function = this.dm.ac ? DMMSupport.MeasurementFunction.V_AC : DMMSupport.MeasurementFunction.V_DC;
            useFreq = this.dm.vahz;
            switch (this.dm.range) {
                case 0: {
                    scale = 1.0;
                    dp.maxValue = 2.2;
                    break;
                }
                case 1: {
                    scale = 10.0;
                    dp.maxValue = 22.0;
                    break;
                }
                case 2: {
                    scale = 100.0;
                    dp.maxValue = 220.0;
                    break;
                }
                case 3: {
                    scale = 1000.0;
                    dp.maxValue = 1000.0;
                    break;
                }
                case 4: {
                    scale = 0.1;
                    dp.maxValue = 0.22;
                }
            }
        } else if (this.dm.function == 51) {
            dp.function = DMMSupport.MeasurementFunction.OHM;
            switch (this.dm.range) {
                case 0: {
                    scale = 100.0;
                    dp.maxValue = 220.0;
                    break;
                }
                case 1: {
                    scale = 1000.0;
                    dp.maxValue = 2200.0;
                    break;
                }
                case 2: {
                    scale = 10000.0;
                    dp.maxValue = 22000.0;
                    break;
                }
                case 3: {
                    scale = 100000.0;
                    dp.maxValue = 220000.0;
                    break;
                }
                case 4: {
                    scale = 1000000.0;
                    dp.maxValue = 2200000.0;
                    break;
                }
                case 5: {
                    scale = 1.0E7;
                    dp.maxValue = 2.2E7;
                    break;
                }
                case 6: {
                    scale = 1.0E8;
                    dp.maxValue = 2.2E8;
                }
            }
        } else if (this.dm.function == 53) {
            dp.function = DMMSupport.MeasurementFunction.CONTINUITY;
            scale = 100.0;
            dp.maxValue = 220.0;
        } else if (this.dm.function == 49) {
            dp.function = DMMSupport.MeasurementFunction.DIODE;
            dp.maxValue = 2.2;
        } else if (this.dm.function == 54) {
            dp.function = DMMSupport.MeasurementFunction.CAPACITY;
            switch (this.dm.range) {
                case 0: {
                    scale = 1.0E-8;
                    dp.maxValue = 2.2E-8;
                    break;
                }
                case 1: {
                    scale = 1.0E-7;
                    dp.maxValue = 2.2E-7;
                    break;
                }
                case 2: {
                    scale = 1.0E-6;
                    dp.maxValue = 2.2E-6;
                    break;
                }
                case 3: {
                    scale = 1.0E-5;
                    dp.maxValue = 2.2E-5;
                    break;
                }
                case 4: {
                    scale = 1.0E-4;
                    dp.maxValue = 2.2E-4;
                    break;
                }
                case 5: {
                    scale = 0.001;
                    dp.maxValue = 0.0022;
                    break;
                }
                case 6: {
                    scale = 0.01;
                    dp.maxValue = 0.022;
                    break;
                }
                case 7: {
                    scale = 0.1;
                    dp.maxValue = 0.22;
                }
            }
        } else if (this.dm.function == 52) {
            dp.function = DMMSupport.MeasurementFunction.TEMPERATURE;
            scale = this.dm.vbar ? 1000 : 10000;
            dp.maxValue = this.dm.vbar ? 220 : 2200;
        } else if (this.dm.function == 50) {
            dp.function = DMMSupport.MeasurementFunction.FREQUENCY;
            useFreq = true;
        } else if (this.dm.function == 61) {
            dp.function = this.dm.ac ? DMMSupport.MeasurementFunction.A_AC : DMMSupport.MeasurementFunction.A_DC;
            dp.function = dp.function;
            useFreq = this.dm.vahz;
            switch (this.dm.range) {
                case 0: {
                    scale = this.dm.vbar ? 100.0 : 1.0E-4;
                    dp.maxValue = this.dm.vbar ? 220.0 : 2.2E-4;
                    break;
                }
                case 1: {
                    scale = this.dm.vbar ? 1000.0 : 0.001;
                    dp.maxValue = this.dm.vbar ? 2200.0 : 0.0022;
                }
            }
        } else if (this.dm.function == 63) {
            dp.function = this.dm.ac ? DMMSupport.MeasurementFunction.A_AC : DMMSupport.MeasurementFunction.A_DC;
            dp.function = dp.function;
            useFreq = this.dm.vahz;
            switch (this.dm.range) {
                case 0: {
                    scale = this.dm.vbar ? 10.0 : 0.01;
                    dp.maxValue = this.dm.vbar ? 22.0 : 0.022;
                    break;
                }
                case 1: {
                    scale = this.dm.vbar ? 100.0 : 0.1;
                    dp.maxValue = this.dm.vbar ? 220.0 : 0.22;
                }
            }
        } else if (this.dm.function == 57) {
            dp.function = this.dm.ac ? DMMSupport.MeasurementFunction.A_AC : DMMSupport.MeasurementFunction.A_DC;
            dp.function = dp.function;
            useFreq = this.dm.vahz;
            switch (this.dm.range) {
                case 0: {
                    scale = 1.0;
                    dp.maxValue = 2.2;
                    break;
                }
                case 1: {
                    scale = 10.0;
                    dp.maxValue = 22.0;
                    break;
                }
                case 2: {
                    scale = 100.0;
                    dp.maxValue = 220.0;
                    break;
                }
                case 3: {
                    scale = 1000.0;
                    dp.maxValue = 2200.0;
                    break;
                }
                case 4: {
                    scale = 10000.0;
                    dp.maxValue = 22000.0;
                }
            }
        } else if (this.dm.function == 48) {
            dp.function = this.dm.ac ? DMMSupport.MeasurementFunction.A_AC : DMMSupport.MeasurementFunction.A_DC;
            dp.function = dp.function;
            scale = 10.0;
            dp.maxValue = 22.0;
            useFreq = this.dm.vahz;
        } else if (this.dm.function == 60) {
            dp.function = this.dm.ac ? DMMSupport.MeasurementFunction.A_AC : DMMSupport.MeasurementFunction.A_DC;
            dp.function = dp.function;
            useFreq = this.dm.vahz;
            switch (this.dm.range) {
                case 0: {
                    scale = 1.0;
                    dp.maxValue = 2.2;
                    break;
                }
                case 1: {
                    scale = 10.0;
                    dp.maxValue = 22.0;
                    break;
                }
                case 2: {
                    scale = 100.0;
                    dp.maxValue = 220.0;
                    break;
                }
                case 3: {
                    scale = 1000.0;
                    dp.maxValue = 2200.0;
                    break;
                }
                case 4: {
                    scale = 10000.0;
                    dp.maxValue = 22000.0;
                }
            }
        }
        if (useFreq) {
            if (this.dm.judge) {
                dp.function = DMMSupport.MeasurementFunction.DUTY_CYCLE;
                scale = 1000.0;
                dp.maxValue = 100.0;
            } else {
                dp.function = DMMSupport.MeasurementFunction.FREQUENCY;
                switch (this.dm.range) {
                    case 0: {
                        scale = 100.0;
                        dp.maxValue = 22.0;
                        break;
                    }
                    case 1: {
                        scale = 1000.0;
                        dp.maxValue = 220.0;
                        break;
                    }
                    case 3: {
                        scale = 10000.0;
                        dp.maxValue = 22000.0;
                        break;
                    }
                    case 4: {
                        scale = 100000.0;
                        dp.maxValue = 220000.0;
                        break;
                    }
                    case 5: {
                        scale = 1000000.0;
                        dp.maxValue = 2200000.0;
                        break;
                    }
                    case 6: {
                        scale = 1.0E7;
                        dp.maxValue = 2.2E7;
                        break;
                    }
                    case 7: {
                        scale = 1.0E8;
                        dp.maxValue = 2.2E8;
                    }
                }
            }
        }
        dp.value1 = (double)v * 1.0E-4 * scale;
        if (this.dm.sign) {
            dp.value1 = -dp.value1;
        }
        if (this.dm.pmin) {
            dp.values = DecoderDMM.Values.peakmin;
        } else if (this.dm.pmax) {
            dp.values = DecoderDMM.Values.peakmax;
        }
        dp.manualRange = !this.dm.auto;
        dp.lpf = this.dm.lpf;
        dp.lowBattery = this.dm.batt;
        return dp;
    }

    @Override
    public List<String> getCommSettings() {
        return Arrays.asList("baudrate=19200", "parity=odd", "databits=7", "stopbits=1", "eol=10", "portdtr=1", "portrts=0");
    }

    @Override
    public List<String> getSupportedDMM() {
        return Arrays.asList("Mastech MS8340B", "UNI_T UT61E", "CyrusTech ES51922");
    }

    protected class DecodedMessage {
        int range = 0;
        int function = 0;
        boolean judge = false;
        boolean sign = false;
        boolean batt = false;
        boolean ol = false;
        boolean max = false;
        boolean min = false;
        boolean rel = false;
        boolean rmr = false;
        boolean ul = false;
        boolean pmax = false;
        boolean pmin = false;
        boolean dc = false;
        boolean ac = false;
        boolean auto = false;
        boolean vahz = false;
        boolean vbar = false;
        boolean hold = false;
        boolean lpf = false;

        DecodedMessage(byte[] data) {
            this.range = data[0] & 7;
            this.function = data[6];
            this.judge = (data[7] & 8) != 0;
            this.sign = (data[7] & 4) != 0;
            this.batt = (data[7] & 2) != 0;
            this.ol = (data[7] & 1) != 0;
            this.max = (data[8] & 8) != 0;
            this.min = (data[8] & 4) != 0;
            this.rel = (data[8] & 2) != 0;
            this.rmr = (data[8] & 1) != 0;
            this.ul = (data[9] & 8) != 0;
            this.pmax = (data[9] & 4) != 0;
            this.pmin = (data[9] & 2) != 0;
            this.dc = (data[10] & 8) != 0;
            this.ac = (data[10] & 4) != 0;
            this.auto = (data[10] & 2) != 0;
            this.vahz = (data[10] & 1) != 0;
            this.vbar = (data[11] & 4) != 0;
            this.hold = (data[11] & 2) != 0;
            this.lpf = (data[11] & 1) != 0;
        }
    }
}

