/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.dmm;

import dk.hkj.dmm.DMMSupport;
import dk.hkj.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class DecoderDMM {
    protected long getValue(byte[] data, int first, int digits) {
        long v = 0L;
        int i = 0;
        while (i < digits) {
            int b = data[first + i] & 0xF;
            v = v * 10L + (long)b;
            ++i;
        }
        return v;
    }

    public byte[] getPrefix() {
        return new byte[0];
    }

    public byte[] getPostfix() {
        return new byte[]{13, 10};
    }

    public List<String> getCommSettings() {
        return Arrays.asList("baudrate=19200", "parity=odd", "databits=7", "stopbits=1", "eol=10", "portdtr=1", "portrts=0");
    }

    public List<String> getSupportedDMM() {
        return new ArrayList<String>();
    }

    public byte[] requestData() {
        return new byte[0];
    }

    public int requestInterval() {
        return 1000;
    }

    public abstract DecodePack decode(byte[] var1);

    public class DecodePack {
        byte[] orginalData;
        Values values = Values.value;
        double value1 = 0.0;
        double value2 = 0.0;
        double value3 = 0.0;
        double maxValue = 0.0;
        boolean overload = false;
        boolean rel = false;
        boolean hold = false;
        boolean lpf = false;
        boolean lowBattery = false;
        boolean manualRange = false;
        DMMSupport.MeasurementFunction function = DMMSupport.MeasurementFunction.UNDEF;

        private String format(int idx) {
            double v = 0.0;
            switch (idx) {
                case 1: {
                    v = this.value1;
                    break;
                }
                case 2: {
                    v = this.value2;
                    break;
                }
                case 3: {
                    v = this.value3;
                }
            }
            return String.valueOf(this.overload ? "OL " : DMMSupport.formatValue(this.value1, true)) + DMMSupport.getUnit(this.function) + " " + DMMSupport.getACDC(this.function);
        }

        public String toString() {
            String s = "";
            switch (this.values) {
                case value: {
                    s = this.format(1);
                    break;
                }
                case relative: {
                    s = "Rel: " + this.format(1);
                    break;
                }
                case relativeref: {
                    s = "Rel: " + this.format(1) + "  Ref: " + this.format(2);
                    break;
                }
                case min: {
                    s = "Min: " + this.format(1);
                    break;
                }
                case max: {
                    s = "Max: " + this.format(1);
                    break;
                }
                case minmax: {
                    s = "Min: " + this.format(1) + "  Max: " + this.format(2);
                    break;
                }
                case valueminmax: {
                    s = String.valueOf(this.format(1)) + "  Min: " + this.format(2) + "  Max: " + this.format(3);
                    break;
                }
                case peakmin: {
                    s = "Peak min: " + this.format(1);
                    break;
                }
                case peakmax: {
                    s = "Peak max: " + this.format(2);
                    break;
                }
                case peakminmax: {
                    s = "Peak min: " + this.format(1) + "  Peak max: " + this.format(2);
                }
            }
            String ss = "";
            if (this.lowBattery) {
                ss = String.valueOf(ss) + "  Low battery";
            }
            if (this.rel) {
                ss = String.valueOf(ss) + "  REL";
            }
            if (this.hold) {
                ss = String.valueOf(ss) + "  HOLD";
            }
            if (this.lpf) {
                ss = String.valueOf(ss) + "  LPF";
            }
            if (this.manualRange) {
                ss = String.valueOf(ss) + "  MANUAL";
            }
            return String.valueOf(StringUtil.hexN(this.orginalData)) + " -- " + s + " (Range:" + DMMSupport.formatValue(this.maxValue, false) + ")  " + ss + "\r\n";
        }
    }

    public static enum Values {
        value,
        relative,
        relativeref,
        min,
        max,
        minmax,
        valueminmax,
        peakmin,
        peakmax,
        peakminmax;

    }
}

