/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.dmm;

import dk.hkj.dmm.DMMSupport;
import dk.hkj.dmm.DecoderDMM;
import dk.hkj.util.StringUtil;
import java.util.Arrays;
import java.util.List;

public class DecodeUNITUT71E
extends DecoderDMM {
    protected DecodedMessage dm = null;

    @Override
    public DecoderDMM.DecodePack decode(byte[] data) {
        System.out.println(StringUtil.hexN(data));
        if (data.length != 9) {
            return null;
        }
        DecoderDMM.DecodePack dp = new DecoderDMM.DecodePack(this);
        dp.orginalData = data;
        this.dm = new DecodedMessage(data);
        double v = (double)this.getValue(data, 0, 5) * 1.0E-4;
        double[] factors = new double[]{0.1, 1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8};
        boolean useFreq = false;
        dp.overload = this.dm.ol;
        double scale = factors[this.dm.range];
        if (this.dm.function == 49) {
            dp.function = DMMSupport.MeasurementFunction.V_DC;
            dp.maxValue = 4.0 * scale;
            if (dp.maxValue > 1000.0) {
                dp.maxValue = 1000.0;
            }
        } else if (this.dm.function == 50) {
            dp.function = this.dm.acdc ? DMMSupport.MeasurementFunction.V_ACDC : DMMSupport.MeasurementFunction.V_AC;
            dp.maxValue = 4.0 * scale;
            if (dp.maxValue > 1000.0) {
                dp.maxValue = 1000.0;
            }
        } else if (this.dm.function == 51) {
            dp.function = DMMSupport.MeasurementFunction.V_DC;
            dp.maxValue = 4.0 * scale;
            if (dp.maxValue > 1000.0) {
                dp.maxValue = 1000.0;
            }
        } else if (this.dm.function == 52) {
            dp.function = DMMSupport.MeasurementFunction.OHM;
            dp.maxValue = 4.0 * (scale *= 100.0);
        } else if (this.dm.function == 53) {
            dp.function = DMMSupport.MeasurementFunction.CAPACITY;
            dp.maxValue = 4.0 * (scale /= 1.0E8);
        } else if (this.dm.function == 54) {
            dp.function = DMMSupport.MeasurementFunction.TEMPERATURE;
            scale *= 10000.0;
            dp.maxValue = 1000.0;
        } else if (this.dm.function == 55) {
            dp.function = this.dm.acdc ? DMMSupport.MeasurementFunction.A_ACDC : (this.dm.ac ? DMMSupport.MeasurementFunction.A_AC : DMMSupport.MeasurementFunction.A_DC);
            dp.maxValue = 4.0 * (scale /= 1000.0);
        } else if (this.dm.function == 56) {
            dp.function = this.dm.acdc ? DMMSupport.MeasurementFunction.A_ACDC : (this.dm.ac ? DMMSupport.MeasurementFunction.A_AC : DMMSupport.MeasurementFunction.A_DC);
            dp.maxValue = 4.0 * (scale /= 10.0);
        } else if (this.dm.function == 57) {
            dp.function = this.dm.acdc ? DMMSupport.MeasurementFunction.A_ACDC : (this.dm.ac ? DMMSupport.MeasurementFunction.A_AC : DMMSupport.MeasurementFunction.A_DC);
            scale *= 10.0;
            dp.maxValue = 10.0;
        } else if (this.dm.function == 58) {
            dp.function = DMMSupport.MeasurementFunction.CONTINUITY;
            dp.maxValue = 4.0 * (scale *= 1000.0);
        } else if (this.dm.function == 59) {
            dp.function = DMMSupport.MeasurementFunction.DIODE;
            scale *= 10.0;
            dp.maxValue = 2.0;
        } else if (this.dm.function == 60) {
            if (this.dm.dutycycle) {
                dp.function = DMMSupport.MeasurementFunction.DUTY_CYCLE;
                scale /= 10.0;
                dp.maxValue = 100.0;
            } else {
                dp.function = DMMSupport.MeasurementFunction.FREQUENCY;
                dp.maxValue = 4.0 * (scale *= 100.0);
            }
        } else if (this.dm.function == 61) {
            dp.function = DMMSupport.MeasurementFunction.TEMPERATURE;
            v = (v - 0.032) / 1.8;
            scale *= 10000.0;
            dp.maxValue = 1000.0;
        } else if (this.dm.function == 62) {
            dp.function = DMMSupport.MeasurementFunction.POWER;
            scale *= 10.0;
            dp.maxValue = 2500.0;
        } else if (this.dm.function == 63) {
            dp.function = DMMSupport.MeasurementFunction.A4_20m;
            scale *= 1000.0;
            dp.maxValue = 100.0;
        }
        dp.value1 = v * scale;
        if (this.dm.sign) {
            dp.value1 = -dp.value1;
        }
        dp.manualRange = this.dm.man;
        return dp;
    }

    @Override
    public List<String> getCommSettings() {
        return Arrays.asList("baudrate=2400", "parity=odd", "databits=7", "stopbits=1", "eol=10", "portdtr=1", "portrts=0");
    }

    @Override
    public List<String> getSupportedDMM() {
        return Arrays.asList("UNI-T UT71E");
    }

    protected class DecodedMessage {
        int range = 0;
        int function = 0;
        boolean sign = false;
        boolean ol = false;
        boolean ac = false;
        boolean acdc = false;
        boolean man = false;
        boolean dutycycle = false;

        DecodedMessage(byte[] data) {
            this.range = data[5] & 7;
            this.function = data[6];
            this.ol = (data[0] & 0xF) == 10;
            this.acdc = (data[7] & 2) != 0;
            this.ac = (data[7] & 1) != 0;
            this.man = (data[8] & 2) != 0;
            boolean bl = this.sign = (data[8] & 4) != 0;
            if (this.sign && this.function == 60) {
                this.dutycycle = true;
                this.sign = false;
            }
        }
    }
}

