/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.dmm;

import java.text.NumberFormat;
import java.util.Locale;

public class DMMSupport {
    static NumberFormat nf = null;

    public static String formatValue(double value, boolean withSpace) {
        if (nf == null) {
            nf = NumberFormat.getNumberInstance(Locale.US);
            nf.setGroupingUsed(false);
            nf.setMaximumFractionDigits(6);
            nf.setMaximumIntegerDigits(4);
        }
        String prefix = "";
        double v = Math.abs(value);
        if (v < 1.0E-12) {
            value = 0.0;
            prefix = "";
        } else if (v < 1.0E-9) {
            value *= 1.0E12;
            prefix = "p";
        } else if (v < 1.0E-6) {
            value *= 1.0E9;
            prefix = "n";
        } else if (v < 0.001) {
            value *= 1000000.0;
            prefix = "u";
        } else if (v < 1.0) {
            value *= 1000.0;
            prefix = "m";
        } else if (v > 1.0E9) {
            value /= 1.0E9;
            prefix = "G";
        } else if (v > 1000000.0) {
            value /= 1000000.0;
            prefix = "M";
        } else if (v > 1000.0) {
            value /= 1000.0;
            prefix = "k";
        }
        return String.valueOf(nf.format(value)) + (withSpace ? " " : "") + prefix;
    }

    public static String getUnit(MeasurementFunction func) {
        switch (func) {
            case V_DC: {
                return "V";
            }
            case V_AC: {
                return "V";
            }
            case V_ACDC: {
                return "V";
            }
            case A_DC: {
                return "A";
            }
            case A_AC: {
                return "A";
            }
            case A_ACDC: {
                return "A";
            }
            case A4_20m: {
                return "%";
            }
            case OHM: {
                return "Ohm";
            }
            case OHM4: {
                return "Ohm";
            }
            case CONTINUITY: {
                return "Ohm";
            }
            case FREQUENCY: {
                return "Hz";
            }
            case DUTY_CYCLE: {
                return "%";
            }
            case PERIOD: {
                return "s";
            }
            case CAPACITY: {
                return "F";
            }
            case TEMPERATURE: {
                return "\ufffdC";
            }
            case POWER: {
                return "W";
            }
            case ENERGY: {
                return "Wh";
            }
            case DIODE: {
                return "V";
            }
            case LUX: {
                return "Lux";
            }
        }
        return "Unknown";
    }

    public static String getACDC(MeasurementFunction func) {
        switch (func) {
            case V_DC: {
                return "DC";
            }
            case V_AC: {
                return "AC";
            }
            case V_ACDC: {
                return "ACDC";
            }
            case A_DC: {
                return "DC";
            }
            case A_AC: {
                return "AC";
            }
            case A_ACDC: {
                return "ACDC";
            }
            case A4_20m: {
                return "";
            }
            case OHM: {
                return "";
            }
            case OHM4: {
                return "";
            }
            case CONTINUITY: {
                return "";
            }
            case FREQUENCY: {
                return "";
            }
            case DUTY_CYCLE: {
                return "";
            }
            case PERIOD: {
                return "";
            }
            case CAPACITY: {
                return "";
            }
            case TEMPERATURE: {
                return "";
            }
            case POWER: {
                return "";
            }
            case ENERGY: {
                return "";
            }
            case DIODE: {
                return "";
            }
            case LUX: {
                return "";
            }
        }
        return "Unknown";
    }

    public static String getSCPIname(MeasurementFunction func) {
        switch (func) {
            case V_DC: {
                return "VOLT:DC";
            }
            case V_AC: {
                return "VOLT:AC";
            }
            case A_DC: {
                return "CURR:DC";
            }
            case A_AC: {
                return "CURR:AC";
            }
            case OHM: {
                return "RES";
            }
            case OHM4: {
                return "FRES";
            }
            case DIODE: {
                return "DIOD";
            }
            case FREQUENCY: {
                return "FREQ";
            }
            case PERIOD: {
                return "PER";
            }
            case CAPACITY: {
                return "CAP";
            }
            case TEMPERATURE: {
                return "TEMP";
            }
            case POWER: {
                return "POW";
            }
            case ENERGY: {
                return "ENE";
            }
            case LUX: {
                return "";
            }
        }
        return "Unknown";
    }

    static MeasurementFunction stringToFunction(String function) {
        if ((function = function.toLowerCase()).length() >= 3 && (function.contains("volt") || function.startsWith("v") || function.endsWith("v"))) {
            if (function.contains("ac") && function.contains("dc")) {
                return MeasurementFunction.V_ACDC;
            }
            if (function.contains("ac")) {
                return MeasurementFunction.V_AC;
            }
            return MeasurementFunction.V_DC;
        }
        if (function.length() >= 3 && (function.contains("cur") || function.contains("amp") || function.startsWith("a") || function.endsWith("a"))) {
            if (function.contains("ac") && function.contains("dc")) {
                return MeasurementFunction.A_ACDC;
            }
            if (function.contains("ac")) {
                return MeasurementFunction.A_AC;
            }
            return MeasurementFunction.A_DC;
        }
        if (function.startsWith("freq")) {
            return MeasurementFunction.FREQUENCY;
        }
        if (function.startsWith("per")) {
            return MeasurementFunction.PERIOD;
        }
        if (function.startsWith("temp")) {
            return MeasurementFunction.TEMPERATURE;
        }
        if (function.contains("res") || function.contains("ohm")) {
            if (function.contains("4") || function.contains("four") || function.contains("kelvin")) {
                return MeasurementFunction.OHM4;
            }
            return MeasurementFunction.OHM;
        }
        if (function.startsWith("cont")) {
            return MeasurementFunction.CONTINUITY;
        }
        if (function.equals("diode")) {
            return MeasurementFunction.DIODE;
        }
        return MeasurementFunction.UNDEF;
    }

    static enum MeasurementFunction {
        UNDEF,
        V_DC,
        V_AC,
        V_ACDC,
        A_DC,
        A_AC,
        A_ACDC,
        A4_20m,
        OHM,
        OHM4,
        FREQUENCY,
        DUTY_CYCLE,
        PERIOD,
        CAPACITY,
        TEMPERATURE,
        POWER,
        ENERGY,
        CONTINUITY,
        DIODE,
        LUX;

    }
}

