/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommInterface;
import dk.hkj.comm.VirtualInterface;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.devices.NoiseInterface;
import dk.hkj.devices.NoiseWhite;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.SCPICommand;
import dk.hkj.main.ValueFormat;
import dk.hkj.script.Script;
import dk.hkj.util.StringUtil;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;

public class VirtualUserGenerator
extends DeviceInterface {
    private static final String idName = "HKJ,VirtualUserGenerator,";
    private static final String longName = "VirtualUserGenerator";
    private static final String handleName = "VUG";
    private NumberFormat nf;
    private NoiseInterface noiseGenerator = new NoiseWhite();

    public VirtualUserGenerator(ManageDeviceDefinitions.DeviceDefinition def) {
        super(def);
        this.valueFormats.add(new ValueFormat("Value", "", ValueFormat.formatD3));
        this.nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        this.nf.setGroupingUsed(false);
        this.nf.setMaximumFractionDigits(5);
        this.setHandleName(handleName);
    }

    public static String name() {
        return idName;
    }

    public static String deviceName() {
        return longName;
    }

    public static String handleName() {
        return handleName;
    }

    @Override
    public String getDeviceName() {
        return longName;
    }

    @Override
    public String getDeviceId() {
        return idName;
    }

    @Override
    public synchronized void initColumns() {
        if (this.valueNames != null) {
            return;
        }
        this.valueNames = new ArrayList();
        this.valueNames.add("Value");
        this.askValueCommand = new SCPICommand((DeviceInterface)this, "VALUE?");
    }

    @Override
    public void resetTime() {
        ((VirtualComm)this.dt.cPort).resetTime();
    }

    @Override
    public CommInterface getCommInterface(CommInterface ci) {
        return new VirtualComm();
    }

    public static void resetForReload() {
        VirtualInterface.idNoSeq = 0;
    }

    private class VirtualComm
    extends VirtualInterface {
        private long startTimeStamp = 0L;
        private long startTime = 0L;
        private long upTime = 30000L;
        private long downTime = 10000L;
        private double offset = 0.0;
        private double levelJumpOffset = 0.0;
        private int cycle = 0;
        private int lastCycle = 0;
        private String upExpression = "sin(x*pi)/cycle";
        private String downExpression = "";
        private boolean on = true;
        private boolean noLevelJump = false;
        private boolean lastState = false;
        private String errorMessage = "";
        private Script script = new Script();

        private VirtualComm() {
        }

        @Override
        public String getName() {
            return "Virtual";
        }

        @Override
        public void open() {
            super.open();
            this.resetTime();
        }

        private synchronized void resetTime() {
            this.startTimeStamp = System.currentTimeMillis();
            this.lastState = false;
            this.errorMessage = "";
            this.cycle = 0;
            this.levelJumpOffset = 0.0;
        }

        private double calcUp(double x, int cycle) {
            this.script.getLocalVars().getCreate("cycle").set(cycle);
            this.script.getLocalVars().getCreate("x").set(x);
            return this.script.expression(this.upExpression).asDouble();
        }

        private double calcDown(double x, int cycle) {
            this.script.getLocalVars().getCreate("cycle").set(cycle);
            this.script.getLocalVars().getCreate("x").set(x);
            if (this.downExpression.length() == 0) {
                return -this.script.expression(this.upExpression).asDouble();
            }
            return this.script.expression(this.downExpression).asDouble();
        }

        private double calculateRampDown0(long periodTime) {
            double v = this.calcUp((double)periodTime / (double)this.upTime, this.cycle);
            if (this.noLevelJump) {
                if (this.cycle != this.lastCycle && this.cycle > 1) {
                    double v1 = this.calcUp(1.0, this.cycle - 1) + this.levelJumpOffset;
                    double v2 = this.calcUp(0.0, this.cycle);
                    this.levelJumpOffset = v1 - v2;
                }
                v += this.levelJumpOffset;
            }
            return v;
        }

        private double calculateRampUp0(long periodTime) {
            double v = this.calcDown((double)periodTime / (double)this.downTime, this.cycle);
            if (this.noLevelJump) {
                if (this.cycle != this.lastCycle && this.cycle > 1) {
                    double v1 = this.calcDown(1.0, this.cycle - 1) + this.levelJumpOffset;
                    double v2 = this.calcDown(0.0, this.cycle);
                    this.levelJumpOffset = v1 - v2;
                }
                v += this.levelJumpOffset;
            }
            return v;
        }

        private double calculateRamp(long periodTime) {
            double v = 0.0;
            if (periodTime < this.upTime) {
                v = this.calcUp((double)periodTime / (double)this.upTime, this.cycle);
                if (this.noLevelJump) {
                    if (!this.lastState && this.cycle > 1) {
                        double v1 = this.calcDown(1.0, this.cycle - 1) + this.levelJumpOffset;
                        double v2 = this.calcUp(0.0, this.cycle);
                        this.levelJumpOffset = v1 - v2;
                    }
                    v += this.levelJumpOffset;
                }
                this.lastState = true;
            } else {
                v = this.calcDown((double)(periodTime - this.upTime) / (double)this.downTime, this.cycle);
                if (this.noLevelJump) {
                    if (this.lastState) {
                        double v1 = this.calcUp(1.0, this.cycle) + this.levelJumpOffset;
                        double v2 = this.calcDown(0.0, this.cycle);
                        this.levelJumpOffset = v1 - v2;
                    }
                    v += this.levelJumpOffset;
                }
                this.lastState = false;
            }
            return v;
        }

        private double calculateOutput() {
            if (!this.on) {
                return 0.0;
            }
            double v = 0.0;
            try {
                long t = System.currentTimeMillis() + this.startTime - this.startTimeStamp;
                this.cycle = (int)(t / (this.upTime + this.downTime)) + 1;
                v = this.downTime == 0L ? this.calculateRampDown0(t) : (this.upTime == 0L ? this.calculateRampUp0(t) : this.calculateRamp(t %= this.upTime + this.downTime));
            }
            catch (Exception e) {
                this.errorMessage = e.getMessage();
                e.printStackTrace(System.out);
            }
            this.lastCycle = this.cycle;
            return v + this.offset;
        }

        private void setFrom(double period, double dutyCycle) {
            if (dutyCycle < 0.0) {
                dutyCycle = 0.0;
            } else if (dutyCycle > 100.0) {
                dutyCycle = 100.0;
            }
            if (period < 0.001) {
                period = 0.001;
            }
            this.upTime = (long)(period * dutyCycle * 1000.0);
            this.downTime = (long)(period * (1.0 - dutyCycle) * 1000.0);
        }

        @Override
        public synchronized boolean write(String msg) {
            String[] items = msg.split("[ ;]");
            if (items.length == 0) {
                return true;
            }
            try {
                int i = 0;
                while (i < items.length) {
                    items[i] = items[i].trim();
                    ++i;
                }
                String cmd = items[0].toUpperCase();
                if (cmd.equals("VALUE?")) {
                    this.message.add(VirtualUserGenerator.this.nf.format(this.calculateOutput()));
                } else if (cmd.equals("TIME") && items.length >= 3) {
                    this.upTime = (long)(StringUtil.parseDoubleEE(items[1]) * 1000.0);
                    this.downTime = (long)(StringUtil.parseDoubleEE(items[2]) * 1000.0);
                    if (this.upTime == 0L && this.downTime == 0L) {
                        this.upTime = 1L;
                        this.downTime = 1L;
                    }
                } else if (cmd.equals("UPTIME") && items.length >= 2) {
                    this.upTime = (long)(StringUtil.parseDoubleEE(items[1]) * 1000.0);
                    if (this.upTime == 0L && this.downTime == 0L) {
                        this.upTime = 1L;
                        this.downTime = 1L;
                    }
                } else if (cmd.equals("DOWNTIME") && items.length >= 2) {
                    this.downTime = (long)(StringUtil.parseDoubleEE(items[1]) * 1000.0);
                    if (this.upTime == 0L && this.downTime == 0L) {
                        this.upTime = 1L;
                        this.downTime = 1L;
                    }
                } else if (cmd.equals("CYCLE") && items.length >= 3) {
                    this.setFrom(StringUtil.parseDoubleEE(items[1]), StringUtil.parseDoubleEE(items[2]));
                } else if (cmd.equals("FREQ") && items.length >= 2) {
                    this.setFrom(1.0 / StringUtil.parseDoubleEE(items[1]), (double)this.upTime / (double)(this.upTime + this.downTime));
                } else if (cmd.equals("PERIOD") && items.length >= 2) {
                    this.setFrom(StringUtil.parseDoubleEE(items[1]), (double)this.upTime / (double)(this.upTime + this.downTime));
                } else if (cmd.equals("DUTYCYCLE") && items.length >= 2) {
                    this.setFrom((double)(this.upTime + this.downTime) / 1000.0, StringUtil.parseDoubleEE(items[1]));
                } else if (cmd.equals("OFFSET?")) {
                    this.message.add(VirtualUserGenerator.this.nf.format(this.offset));
                } else if (cmd.equals("OFFSET") && items.length >= 2) {
                    this.offset = StringUtil.parseDoubleEE(items[1]);
                } else if (cmd.equals("ON") && items.length >= 2) {
                    this.on = StringUtil.parseDoubleEE(items[1]) > 0.5;
                    this.resetTime();
                } else if (cmd.equals("STARTTIME") && items.length >= 2) {
                    this.startTime = (long)(StringUtil.parseDoubleEE(items[1]) * 1000.0) % (this.upTime + this.downTime);
                } else if (cmd.equals("STARTPHASE") && items.length >= 2) {
                    this.startTime = (long)(StringUtil.parseDoubleEE(items[1]) / 360.0 * (double)(this.upTime + this.downTime));
                } else if (cmd.equals("TIME?")) {
                    this.message.add(String.valueOf(VirtualUserGenerator.this.nf.format((double)this.upTime / 1000.0)) + " " + VirtualUserGenerator.this.nf.format((double)this.downTime / 1000.0));
                } else if (cmd.equals("UPTIME?")) {
                    this.message.add(VirtualUserGenerator.this.nf.format((double)this.upTime / 1000.0));
                } else if (cmd.equals("DOWNTIME?")) {
                    this.message.add(VirtualUserGenerator.this.nf.format((double)this.downTime / 1000.0));
                } else if (cmd.equals("CYCLE?")) {
                    double period = (double)(this.upTime + this.downTime) / 1000.0;
                    double dutyCycle = (double)this.upTime / period * 0.1;
                    this.message.add(String.valueOf(VirtualUserGenerator.this.nf.format(period)) + " " + VirtualUserGenerator.this.nf.format(dutyCycle));
                } else if (cmd.equals("FREQ?")) {
                    this.message.add(VirtualUserGenerator.this.nf.format(1000.0 / (double)(this.upTime + this.downTime)));
                } else if (cmd.equals("PERIOD?")) {
                    this.message.add(VirtualUserGenerator.this.nf.format((double)(this.upTime + this.downTime) / 1000.0));
                } else if (cmd.equals("DUTYCYCLE?")) {
                    this.message.add(VirtualUserGenerator.this.nf.format((double)this.upTime / (double)(this.upTime + this.downTime) * 100.0));
                } else if (cmd.equals("ON?")) {
                    this.message.add(this.on ? "1" : "0");
                } else if (cmd.equals("NOLEVELJUMP?")) {
                    this.message.add(this.noLevelJump ? "1" : "0");
                } else if (cmd.equals("NOLEVELJUMP")) {
                    this.levelJumpOffset = 0.0;
                    this.noLevelJump = StringUtil.parseDoubleEE(items[1]) > 0.5;
                } else if (cmd.equals("UPEXP?")) {
                    this.message.add("\"" + this.upExpression + "\"");
                } else if (cmd.equals("DOWNEXP?")) {
                    this.message.add("\"" + this.downExpression + "\"");
                } else if (cmd.equals("UPEXP")) {
                    StringBuilder sb = new StringBuilder();
                    int i2 = 1;
                    while (i2 < items.length) {
                        if (sb.length() > 0) {
                            sb.append(" ");
                        }
                        sb.append(items[i2]);
                        ++i2;
                    }
                    this.upExpression = StringUtil.unQuote(sb.toString()).trim();
                } else if (cmd.equals("DOWNEXP")) {
                    StringBuilder sb = new StringBuilder();
                    int i3 = 1;
                    while (i3 < items.length) {
                        if (sb.length() > 0) {
                            sb.append(" ");
                        }
                        sb.append(items[i3]);
                        ++i3;
                    }
                    this.downExpression = StringUtil.unQuote(sb.toString()).trim();
                } else if (cmd.equals("ERROR?")) {
                    this.message.add("\"" + this.errorMessage + "\"");
                } else if (cmd.equals("STARTTIME?")) {
                    this.message.add(VirtualUserGenerator.this.nf.format((double)this.startTime / 1000.0));
                } else if (cmd.equals("STARTPHASE?")) {
                    this.message.add(VirtualUserGenerator.this.nf.format(360.0 * (double)this.startTime / (double)(this.upTime + this.downTime)));
                } else if (cmd.equals("STARTLEVEL?")) {
                    this.message.add(VirtualUserGenerator.this.nf.format(this.calculateRamp(this.startTime)));
                } else if (cmd.equals("*IDN?")) {
                    this.message.add(VirtualUserGenerator.idName);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            return true;
        }
    }
}

