/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommInterface;
import dk.hkj.comm.VirtualInterface;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.devices.NoiseInterface;
import dk.hkj.devices.NoiseWhite;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.SCPICommand;
import dk.hkj.main.ValueFormat;
import dk.hkj.util.StringUtil;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;

public class VirtualSquareGenerator
extends DeviceInterface {
    private static final String idName = "HKJ,VirtualSquareGenerator,";
    private static final String longName = "VirtualSquareGenerator";
    private static final String handleName = "VQG";
    private NumberFormat nf;

    public VirtualSquareGenerator(ManageDeviceDefinitions.DeviceDefinition def) {
        super(def);
        this.valueFormats.add(new ValueFormat("Square", "", ValueFormat.formatD3));
        this.nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        this.nf.setGroupingUsed(false);
        this.nf.setMaximumFractionDigits(5);
        this.setHandleName(handleName);
    }

    public static String name() {
        return idName;
    }

    public static String deviceName() {
        return longName;
    }

    public static String handleName() {
        return handleName;
    }

    @Override
    public String getDeviceName() {
        return longName;
    }

    @Override
    public String getDeviceId() {
        return idName;
    }

    @Override
    public synchronized void initColumns() {
        if (this.valueNames != null) {
            return;
        }
        this.valueNames = new ArrayList();
        this.valueNames.add("Square");
        this.askValueCommand = new SCPICommand((DeviceInterface)this, "VALUE?");
    }

    @Override
    public void resetTime() {
        ((VirtualComm)this.dt.cPort).resetTime();
    }

    @Override
    public CommInterface getCommInterface(CommInterface ci) {
        return new VirtualComm();
    }

    public static void resetForReload() {
        VirtualInterface.idNoSeq = 0;
    }

    private class VirtualComm
    extends VirtualInterface {
        private long startTimeStamp = 0L;
        private NoiseInterface noiseGenerator = new NoiseWhite();
        private long startTime = 0L;
        private long upTime = 1000L;
        private long downTime = 10000L;
        private double maxLevel = 10.0;
        private double minLevel = 0.0;
        private double noise = 0.0;
        private boolean on = true;

        private VirtualComm() {
        }

        @Override
        public void open() {
            super.open();
            this.resetTime();
        }

        private synchronized void resetTime() {
            this.startTimeStamp = System.currentTimeMillis();
        }

        private double calculateSquare(long time) {
            return (time %= this.upTime + this.downTime) < this.upTime ? this.maxLevel : this.minLevel;
        }

        private double calculateOutput() {
            if (!this.on) {
                return 0.0;
            }
            double v = this.calculateSquare(System.currentTimeMillis() + this.startTime - this.startTimeStamp);
            if (this.noise > 0.0) {
                v += this.noiseGenerator.getValue() * this.noise;
            }
            return v;
        }

        private void setFrom(double period, double dutyCycle) {
            if (dutyCycle < 0.0) {
                dutyCycle = 0.0;
            } else if (dutyCycle > 100.0) {
                dutyCycle = 100.0;
            }
            if (period < 0.001) {
                period = 0.001;
            }
            this.upTime = (long)(period * dutyCycle * 1000.0);
            this.downTime = (long)(period * (1.0 - dutyCycle) * 1000.0);
        }

        @Override
        public synchronized boolean write(String msg) {
            String[] items = (msg = msg.trim().toUpperCase().replaceAll(",", ".")).split("[ ;]");
            if (items.length == 0) {
                return true;
            }
            try {
                int i = 0;
                while (i < items.length) {
                    items[i] = items[i].trim();
                    ++i;
                }
                String cmd = items[0];
                if (cmd.equals("VALUE?")) {
                    this.message.add(VirtualSquareGenerator.this.nf.format(this.calculateOutput()));
                } else if (cmd.equals("TIME") && items.length >= 3) {
                    this.upTime = (long)(StringUtil.parseDoubleEE(items[1]) * 1000.0);
                    this.downTime = (long)(StringUtil.parseDoubleEE(items[2]) * 1000.0);
                    if (this.upTime == 0L && this.downTime == 0L) {
                        this.upTime = 1L;
                        this.downTime = 1L;
                    }
                } else if (cmd.equals("UPTIME") && items.length >= 2) {
                    this.upTime = (long)(StringUtil.parseDoubleEE(items[1]) * 1000.0);
                    if (this.upTime == 0L && this.downTime == 0L) {
                        this.upTime = 1L;
                        this.downTime = 1L;
                    }
                } else if (cmd.equals("DOWNTIME") && items.length >= 2) {
                    this.downTime = (long)(StringUtil.parseDoubleEE(items[1]) * 1000.0);
                    if (this.upTime == 0L && this.downTime == 0L) {
                        this.upTime = 1L;
                        this.downTime = 1L;
                    }
                } else if (cmd.equals("CYCLE") && items.length >= 3) {
                    this.setFrom(StringUtil.parseDoubleEE(items[1]), StringUtil.parseDoubleEE(items[2]));
                } else if (cmd.equals("FREQ") && items.length >= 2) {
                    this.setFrom(1.0 / StringUtil.parseDoubleEE(items[1]), (double)this.upTime / (double)(this.upTime + this.downTime));
                } else if (cmd.equals("PERIOD") && items.length >= 2) {
                    this.setFrom(StringUtil.parseDoubleEE(items[1]), (double)this.upTime / (double)(this.upTime + this.downTime));
                } else if (cmd.equals("DUTYCYCLE") && items.length >= 2) {
                    this.setFrom((double)(this.upTime + this.downTime) / 1000.0, StringUtil.parseDoubleEE(items[1]));
                } else if (cmd.equals("NOISE") && items.length >= 2) {
                    this.noise = StringUtil.parseDoubleEE(items[1]);
                    if (items.length >= 3) {
                        this.noiseGenerator = NoiseInterface.getGenerator(items[2]);
                        if (this.noiseGenerator == null) {
                            this.noiseGenerator = new NoiseWhite();
                        }
                    }
                } else if (cmd.equals("ON") && items.length >= 2) {
                    this.on = StringUtil.parseDoubleEE(items[1]) > 0.5;
                    this.resetTime();
                } else if (cmd.equals("LEVEL") && items.length >= 3) {
                    this.minLevel = StringUtil.parseDoubleEE(items[1]);
                    this.maxLevel = StringUtil.parseDoubleEE(items[2]);
                } else if (cmd.equals("UPLEVEL") && items.length >= 2) {
                    this.maxLevel = StringUtil.parseDoubleEE(items[1]);
                } else if (cmd.equals("DOWNLEVEL") && items.length >= 2) {
                    this.minLevel = StringUtil.parseDoubleEE(items[1]);
                } else if (cmd.equals("OFFSET") && items.length >= 2) {
                    double offset = StringUtil.parseDoubleEE(items[1]);
                    double range = this.maxLevel - this.minLevel;
                    this.minLevel = offset - range / 2.0;
                    this.maxLevel = offset + range / 2.0;
                } else if (cmd.equals("RANGE") && items.length >= 2) {
                    double range = StringUtil.parseDoubleEE(items[1]);
                    double offset = (this.maxLevel - this.minLevel) / 2.0;
                    this.minLevel = offset - range / 2.0;
                    this.maxLevel = offset + range / 2.0;
                } else if (cmd.equals("STARTTIME") && items.length >= 2) {
                    this.startTime = (long)(StringUtil.parseDoubleEE(items[1]) * 1000.0) % (this.upTime + this.downTime);
                } else if (cmd.equals("STARTPHASE") && items.length >= 2) {
                    this.startTime = (long)(StringUtil.parseDoubleEE(items[1]) / 360.0 * (double)(this.upTime + this.downTime));
                } else if (cmd.equals("TIME?")) {
                    this.message.add(String.valueOf(VirtualSquareGenerator.this.nf.format((double)this.upTime / 1000.0)) + " " + VirtualSquareGenerator.this.nf.format((double)this.downTime / 1000.0));
                } else if (cmd.equals("UPTIME?")) {
                    this.message.add(VirtualSquareGenerator.this.nf.format((double)this.upTime / 1000.0));
                } else if (cmd.equals("DOWNTIME?")) {
                    this.message.add(VirtualSquareGenerator.this.nf.format((double)this.downTime / 1000.0));
                } else if (cmd.equals("CYCLE?")) {
                    double period = (double)(this.upTime + this.downTime) / 1000.0;
                    double dutyCycle = (double)this.upTime / period * 0.1;
                    this.message.add(String.valueOf(VirtualSquareGenerator.this.nf.format(period)) + " " + VirtualSquareGenerator.this.nf.format(dutyCycle));
                } else if (cmd.equals("FREQ?")) {
                    this.message.add(VirtualSquareGenerator.this.nf.format(1000.0 / (double)(this.upTime + this.downTime)));
                } else if (cmd.equals("PERIOD?")) {
                    this.message.add(VirtualSquareGenerator.this.nf.format((double)(this.upTime + this.downTime) / 1000.0));
                } else if (cmd.equals("DUTYCYCLE?")) {
                    this.message.add(VirtualSquareGenerator.this.nf.format((double)this.upTime / (double)(this.upTime + this.downTime) * 100.0));
                } else if (cmd.equals("RANGE?")) {
                    this.message.add(VirtualSquareGenerator.this.nf.format(this.maxLevel - this.minLevel));
                } else if (cmd.equals("OFFSET?")) {
                    this.message.add(VirtualSquareGenerator.this.nf.format((this.maxLevel + this.minLevel) / 2.0));
                } else if (cmd.equals("LEVEL?")) {
                    this.message.add(String.valueOf(VirtualSquareGenerator.this.nf.format(this.minLevel)) + " " + VirtualSquareGenerator.this.nf.format(this.maxLevel));
                } else if (cmd.equals("UPLEVEL?")) {
                    this.message.add(VirtualSquareGenerator.this.nf.format(this.maxLevel));
                } else if (cmd.equals("DOWNLEVEL?")) {
                    this.message.add(VirtualSquareGenerator.this.nf.format(this.minLevel));
                } else if (cmd.equals("ON?")) {
                    this.message.add(this.on ? "1" : "0");
                } else if (cmd.equals("NOISE?")) {
                    this.message.add(String.valueOf(VirtualSquareGenerator.this.nf.format(this.noise)) + " " + this.noiseGenerator.getName());
                } else if (cmd.equals("STARTTIME?")) {
                    this.message.add(VirtualSquareGenerator.this.nf.format((double)this.startTime / 1000.0));
                } else if (cmd.equals("STARTPHASE?")) {
                    this.message.add(VirtualSquareGenerator.this.nf.format(360.0 * (double)this.startTime / (double)(this.upTime + this.downTime)));
                } else if (cmd.equals("*IDN?")) {
                    this.message.add(VirtualSquareGenerator.idName);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            return true;
        }
    }
}

