/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommInterface;
import dk.hkj.comm.VirtualInterface;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.devices.NoiseInterface;
import dk.hkj.devices.NoiseWhite;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.SCPICommand;
import dk.hkj.main.ValueFormat;
import dk.hkj.util.StringUtil;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;

public class VirtualSinusGenerator
extends DeviceInterface {
    private static final String idName = "HKJ,VirtualSinusGenerator,";
    private static final String longName = "VirtualSinusGenerator";
    private static final String handleName = "VSG";
    private NumberFormat nf;
    private NoiseInterface noiseGenerator = new NoiseWhite();

    public VirtualSinusGenerator(ManageDeviceDefinitions.DeviceDefinition def) {
        super(def);
        this.valueFormats.add(new ValueFormat("Sine", "", ValueFormat.formatD3));
        this.nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        this.nf.setGroupingUsed(false);
        this.nf.setMaximumFractionDigits(5);
        this.setHandleName(handleName);
    }

    public static String name() {
        return idName;
    }

    public static String deviceName() {
        return longName;
    }

    public static String handleName() {
        return handleName;
    }

    @Override
    public String getDeviceName() {
        return longName;
    }

    @Override
    public String getDeviceId() {
        return idName;
    }

    @Override
    public synchronized void initColumns() {
        if (this.valueNames != null) {
            return;
        }
        this.valueNames = new ArrayList();
        this.valueNames.add("Sine");
        this.askValueCommand = new SCPICommand((DeviceInterface)this, "VALUE?");
    }

    @Override
    public void resetTime() {
        ((VirtualComm)this.dt.cPort).resetTime();
    }

    @Override
    public CommInterface getCommInterface(CommInterface ci) {
        return new VirtualComm();
    }

    public static void resetForReload() {
        VirtualInterface.idNoSeq = 0;
    }

    private class VirtualComm
    extends VirtualInterface {
        private long startTimeStamp = 0L;
        private long startTime = 0L;
        private long cycleTime = 10000L;
        private double range = 20.0;
        private double offset = 0.0;
        private double noise = 0.0;
        private boolean on = true;

        private VirtualComm() {
        }

        @Override
        public void open() {
            super.open();
            this.resetTime();
        }

        private synchronized void resetTime() {
            this.startTimeStamp = System.currentTimeMillis();
        }

        private double calculateSine(long time) {
            double s = Math.sin((double)(time %= this.cycleTime) / (double)this.cycleTime * 2.0 * Math.PI);
            double v = s * this.range / 2.0 + this.offset;
            return v;
        }

        private void setStartTimefromLevel(double level, boolean up) {
            long time;
            double p = Math.asin((level -= this.offset) * 2.0 / this.range);
            if (p < 0.0) {
                p += Math.PI * 2;
            }
            if (up) {
                if (p > 1.5707963267948966 && p < 4.71238898038469) {
                    p += Math.PI;
                }
            } else if (p < 1.5707963267948966 || p > 4.71238898038469) {
                p = Math.PI * 3 - p;
            }
            if (p > Math.PI * 2) {
                p -= Math.PI * 2;
            }
            this.startTime = time = (long)(p * (double)this.cycleTime / 2.0 / Math.PI);
        }

        private double calculateOutput() {
            if (!this.on) {
                return 0.0;
            }
            double v = this.calculateSine(System.currentTimeMillis() + this.startTime - this.startTimeStamp);
            if (this.noise > 0.0) {
                v += VirtualSinusGenerator.this.noiseGenerator.getValue() * this.noise;
            }
            return v;
        }

        @Override
        public synchronized boolean write(String msg) {
            String[] items = (msg = msg.trim().toUpperCase().replaceAll(",", ".")).split("[ ;]");
            if (items.length == 0) {
                return true;
            }
            try {
                int i = 0;
                while (i < items.length) {
                    items[i] = items[i].trim();
                    ++i;
                }
                String cmd = items[0];
                if (cmd.equals("VALUE?")) {
                    this.message.add(VirtualSinusGenerator.this.nf.format(this.calculateOutput()));
                } else if (cmd.equals("TIME") && items.length >= 2) {
                    this.cycleTime = (long)(StringUtil.parseDoubleEE(items[1]) * 1000.0);
                } else if (cmd.equals("FREQ") && items.length >= 2) {
                    this.cycleTime = (long)(1000.0 / StringUtil.parseDoubleEE(items[1]));
                } else if (cmd.equals("PERIOD") && items.length >= 2) {
                    this.cycleTime = (long)(StringUtil.parseDoubleEE(items[1]) * 1000.0);
                } else if (cmd.equals("NOISE") && items.length >= 2) {
                    this.noise = StringUtil.parseDoubleEE(items[1]);
                    if (items.length >= 3) {
                        VirtualSinusGenerator.this.noiseGenerator = NoiseInterface.getGenerator(items[2]);
                        if (VirtualSinusGenerator.this.noiseGenerator == null) {
                            VirtualSinusGenerator.this.noiseGenerator = new NoiseWhite();
                        }
                    }
                } else if (cmd.equals("ON") && items.length >= 2) {
                    this.on = StringUtil.parseDoubleEE(items[1]) > 0.5;
                    this.resetTime();
                } else if (cmd.equals("LEVEL") && items.length >= 3) {
                    double minLevel = StringUtil.parseDoubleEE(items[1]);
                    double maxLevel = StringUtil.parseDoubleEE(items[2]);
                    this.range = maxLevel - minLevel;
                    this.offset = (maxLevel + minLevel) / 2.0;
                } else if (cmd.equals("OFFSET") && items.length >= 2) {
                    this.offset = StringUtil.parseDoubleEE(items[1]);
                } else if (cmd.equals("RANGE") && items.length >= 2) {
                    this.range = StringUtil.parseDoubleEE(items[1]);
                } else if (cmd.equals("STARTTIME") && items.length >= 2) {
                    this.startTime = (long)(StringUtil.parseDoubleEE(items[1]) * 1000.0) % this.cycleTime;
                } else if (cmd.equals("STARTPHASE") && items.length >= 2) {
                    this.startTime = (long)(StringUtil.parseDoubleEE(items[1]) / 360.0 * (double)this.cycleTime);
                } else if (cmd.equals("STARTLEVEL") && items.length >= 2) {
                    double level = StringUtil.parseDoubleEE(items[1]);
                    boolean up = items.length == 2 || StringUtil.parseDoubleEE(items[2]) > 0.0;
                    this.setStartTimefromLevel(level, up);
                } else if (cmd.equals("TIME?")) {
                    this.message.add(VirtualSinusGenerator.this.nf.format((double)this.cycleTime / 1000.0));
                } else if (cmd.equals("CYCLE?")) {
                    this.message.add(VirtualSinusGenerator.this.nf.format((double)this.cycleTime / 1000.0));
                } else if (cmd.equals("FREQ?")) {
                    this.message.add(VirtualSinusGenerator.this.nf.format(1000.0 / (double)this.cycleTime));
                } else if (cmd.equals("PERIOD?")) {
                    this.message.add(VirtualSinusGenerator.this.nf.format((double)this.cycleTime / 1000.0));
                } else if (cmd.equals("RANGE?")) {
                    this.message.add(VirtualSinusGenerator.this.nf.format(this.range));
                } else if (cmd.equals("OFFSET?")) {
                    this.message.add(VirtualSinusGenerator.this.nf.format(this.offset));
                } else if (cmd.equals("LEVEL?")) {
                    double minLevel = this.offset - this.range / 2.0;
                    double maxLevel = this.offset + this.range / 2.0;
                    this.message.add(String.valueOf(VirtualSinusGenerator.this.nf.format(minLevel)) + " " + VirtualSinusGenerator.this.nf.format(maxLevel));
                } else if (cmd.equals("UPLEVEL?")) {
                    double maxLevel = this.offset + this.range / 2.0;
                    this.message.add(VirtualSinusGenerator.this.nf.format(maxLevel));
                } else if (cmd.equals("DOWNLEVEL?")) {
                    double minLevel = this.offset - this.range / 2.0;
                    this.message.add(VirtualSinusGenerator.this.nf.format(minLevel));
                } else if (cmd.equals("ON?")) {
                    this.message.add(this.on ? "1" : "0");
                } else if (cmd.equals("NOISE?")) {
                    this.message.add(String.valueOf(VirtualSinusGenerator.this.nf.format(this.noise)) + " " + VirtualSinusGenerator.this.noiseGenerator.getName());
                } else if (cmd.equals("STARTTIME?")) {
                    this.message.add(VirtualSinusGenerator.this.nf.format((double)this.startTime / 1000.0));
                } else if (cmd.equals("STARTPHASE?")) {
                    this.message.add(VirtualSinusGenerator.this.nf.format(360.0 * (double)this.startTime / (double)this.cycleTime));
                } else if (cmd.equals("STARTLEVEL?")) {
                    this.message.add(VirtualSinusGenerator.this.nf.format(this.calculateSine(this.startTime)));
                } else if (cmd.equals("*IDN?")) {
                    this.message.add(VirtualSinusGenerator.idName);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            return true;
        }
    }
}

