/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommInterface;
import dk.hkj.comm.VirtualInterface;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.SCPICommand;
import dk.hkj.main.ValueFormat;
import dk.hkj.util.StringUtil;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class VirtualPatternGenerator
extends DeviceInterface {
    private static final int MAX_STATE_ENTRIES = 1000;
    private static final String idName = "HKJ,VirtualPatternGenerator,";
    private static final String longName = "VirtualPatternGenerator";
    private static final String handleName = "VPG";
    private NumberFormat nf;

    public VirtualPatternGenerator(ManageDeviceDefinitions.DeviceDefinition def) {
        super(def);
        this.valueFormats.add(new ValueFormat("Value", "", ValueFormat.formatD3));
        this.nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        this.nf.setGroupingUsed(false);
        this.nf.setMaximumFractionDigits(5);
        this.setHandleName(handleName);
    }

    public static String name() {
        return idName;
    }

    public static String deviceName() {
        return longName;
    }

    public static String handleName() {
        return handleName;
    }

    @Override
    public String getDeviceName() {
        return longName;
    }

    @Override
    public String getDeviceId() {
        return idName;
    }

    @Override
    public synchronized void initColumns() {
        if (this.valueNames != null) {
            return;
        }
        this.valueNames = new ArrayList();
        this.valueNames.add("Value");
        this.askValueCommand = new SCPICommand((DeviceInterface)this, "VALUE?");
    }

    @Override
    public void resetTime() {
        ((VirtualComm)this.dt.cPort).resetTime();
    }

    @Override
    public CommInterface getCommInterface(CommInterface ci) {
        return new VirtualComm();
    }

    public static void resetForReload() {
        VirtualInterface.idNoSeq = 0;
    }

    private static class StateEntry {
        long time = 0L;
        double value = 0.0;
        boolean ramp = false;

        public StateEntry(double time, double value, boolean ramp) {
            this.time = (long)(time * 1000.0);
            this.value = value;
            this.ramp = ramp;
        }

        public StateEntry(String time, String value, String ramp) {
            this.time = (long)(StringUtil.parseDoubleEE(time) * 1000.0);
            this.value = StringUtil.parseDoubleEE(value);
            this.ramp = StringUtil.parseInt(ramp) != 0;
        }

        public String getEntry() {
            StringBuilder sb = new StringBuilder();
            sb.append(Double.toString((double)this.time / 1000.0));
            sb.append(" ");
            sb.append(Double.toString(this.value));
            sb.append(" ");
            sb.append(this.ramp ? 1 : 0);
            return sb.toString();
        }
    }

    private class VirtualComm
    extends VirtualInterface {
        private long startTimeStamp = 0L;
        private long startTime = 0L;
        private boolean on = true;
        private List<StateEntry> stateEntryList = new ArrayList<StateEntry>();
        private boolean repeat = true;
        private boolean stayAtFinalValue = true;
        private int currentEntry = 0;
        private long timeToCurrentEntry = 0L;
        private double lastValue = 0.0;

        VirtualComm() {
            this.stateEntryList.add(new StateEntry(8.0, 10.0, false));
            this.stateEntryList.add(new StateEntry(10.0, 3.0, true));
            this.stateEntryList.add(new StateEntry(10.0, 10.0, true));
            this.stateEntryList.add(new StateEntry(5.0, 10.0, false));
            this.stateEntryList.add(new StateEntry(5.0, 0.0, false));
        }

        @Override
        public String getName() {
            return "Virtual";
        }

        @Override
        public void open() {
            super.open();
            this.resetTime();
        }

        private synchronized void resetTime() {
            this.startTimeStamp = System.currentTimeMillis();
            this.startTime = 0L;
            this.currentEntry = 0;
            this.timeToCurrentEntry = 0L;
            this.lastValue = 0.0;
        }

        private synchronized void restart() {
            this.startTimeStamp = System.currentTimeMillis();
            this.startTime = 0L;
            this.currentEntry = 0;
            this.timeToCurrentEntry = 0L;
        }

        private String getEntries() {
            StringBuilder sb = new StringBuilder();
            int lasti = -1;
            int i = 0;
            while (i < this.stateEntryList.size()) {
                StateEntry se = this.stateEntryList.get(i);
                if (se.time > 0L) {
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    if (i != lasti + 1) {
                        sb.append("#");
                        sb.append(i);
                        sb.append(" ");
                    }
                    sb.append(se.getEntry());
                    lasti = i;
                }
                ++i;
            }
            return sb.toString();
        }

        /*
         * Unable to fully structure code
         */
        private void addEntry(int index, StateEntry se) {
            if (index >= 0 && index <= 1000) ** GOTO lbl5
            return;
lbl-1000:
            // 1 sources

            {
                this.stateEntryList.add(new StateEntry(0.0, 0.0, false));
lbl5:
                // 2 sources

                ** while (index >= this.stateEntryList.size())
            }
lbl6:
            // 1 sources

            this.stateEntryList.set(index, se);
        }

        private void setEntries(String[] entries) {
            int i = 1;
            int index = 0;
            while (i < entries.length) {
                if (entries[i].startsWith("#")) {
                    index = StringUtil.parseInt(entries[i++].substring(1));
                }
                double time = StringUtil.parseDoubleEE(entries[i++]);
                double value = StringUtil.parseDoubleEE(entries[i++]);
                boolean ramp = StringUtil.parseDoubleEE(entries[i++]) != 0.0;
                this.addEntry(index, new StateEntry(time, value, ramp));
                ++index;
            }
        }

        private double calculate(long time) {
            if (this.currentEntry >= this.stateEntryList.size()) {
                return this.stayAtFinalValue ? this.lastValue : 0.0;
            }
            StateEntry se = this.stateEntryList.get(this.currentEntry);
            while (time > se.time + this.timeToCurrentEntry && this.currentEntry < this.stateEntryList.size()) {
                if (se.time > 0L) {
                    this.lastValue = se.value;
                }
                ++this.currentEntry;
                this.timeToCurrentEntry += se.time;
                if (this.repeat && this.currentEntry >= this.stateEntryList.size()) {
                    this.currentEntry = 0;
                }
                if (this.currentEntry >= this.stateEntryList.size()) {
                    return this.stayAtFinalValue ? this.lastValue : 0.0;
                }
                se = this.stateEntryList.get(this.currentEntry);
            }
            if (se.ramp) {
                long dt = time - this.timeToCurrentEntry;
                return (se.value - this.lastValue) * (double)dt / (double)se.time + this.lastValue;
            }
            this.lastValue = se.value;
            return se.value;
        }

        private double calculateOutput() {
            if (!this.on) {
                this.lastValue = 0.0;
                return 0.0;
            }
            double v = this.calculate(System.currentTimeMillis() + this.startTime - this.startTimeStamp);
            return v;
        }

        @Override
        public synchronized boolean write(String msg) {
            String[] items = (msg = msg.trim().toUpperCase().replaceAll(",", ".")).split("[ ;]");
            if (items.length == 0) {
                return true;
            }
            try {
                int i = 0;
                while (i < items.length) {
                    items[i] = items[i].trim();
                    ++i;
                }
                String cmd = items[0];
                if (cmd.equals("VALUE?")) {
                    this.message.add(VirtualPatternGenerator.this.nf.format(this.calculateOutput()));
                } else if (cmd.equals("ON") && items.length >= 2) {
                    this.on = StringUtil.parseDoubleEE(items[1]) > 0.5;
                    this.resetTime();
                } else if (cmd.equals("ON?")) {
                    this.message.add(this.on ? "1" : "0");
                } else if (cmd.equals("BUSY?")) {
                    this.message.add(this.on && this.currentEntry < this.stateEntryList.size() ? "1" : "0");
                } else if (cmd.equals("RESTART")) {
                    this.restart();
                } else if (cmd.equals("REPEAT") && items.length >= 2) {
                    this.repeat = StringUtil.parseDoubleEE(items[1]) > 0.5;
                } else if (cmd.equals("REPEAT?")) {
                    this.message.add(this.repeat ? "1" : "0");
                } else if (cmd.equals("STAYATFINALVALUE") && items.length >= 2) {
                    this.stayAtFinalValue = StringUtil.parseDoubleEE(items[1]) > 0.5;
                } else if (cmd.equals("STAYATFINALVALUE?")) {
                    this.message.add(this.stayAtFinalValue ? "1" : "0");
                } else if (cmd.equals("ENTRIES?")) {
                    this.message.add(this.getEntries());
                } else if (cmd.equals("ENTRIES") && items.length >= 2) {
                    this.stateEntryList.clear();
                    this.restart();
                    this.setEntries(items);
                } else if (cmd.equals("ADDENTRIES") && items.length >= 2) {
                    this.restart();
                    this.setEntries(items);
                } else if (cmd.equals("ENTRY?") && items.length >= 2) {
                    int no = StringUtil.parseInt(items[1]);
                    if (no >= this.stateEntryList.size()) {
                        this.message.add(String.valueOf(Integer.toString(no)) + " 0 0 0");
                    } else if (no >= 0) {
                        this.message.add(String.valueOf(Integer.toString(no)) + " " + this.stateEntryList.get(no).getEntry());
                    }
                } else if (cmd.equals("ENTRY") && items.length >= 5) {
                    int no = StringUtil.parseInt(items[1]);
                    this.addEntry(no, new StateEntry(items[2], items[3], items[4]));
                } else if (cmd.equals("*IDN?")) {
                    this.message.add(VirtualPatternGenerator.idName);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            return true;
        }
    }
}

