/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommInterface;
import dk.hkj.comm.VirtualInterface;
import dk.hkj.devices.BatteryDataDuracellPlusAA;
import dk.hkj.devices.BatteryDataDuracellPlusAAA;
import dk.hkj.devices.BatteryDataEneloopAA;
import dk.hkj.devices.BatteryDataEneloopAAA;
import dk.hkj.devices.BatteryDataEnergizerLithiumAA;
import dk.hkj.devices.BatteryDataEnergizerLithiumAAA;
import dk.hkj.devices.BatteryDataFujitsu9VGold;
import dk.hkj.devices.BatteryDataKodakHeavyDutyAA;
import dk.hkj.devices.BatteryDataKodakHeavyDutyAAA;
import dk.hkj.devices.BatteryDataLG18650_H26;
import dk.hkj.devices.BatteryDataLG21700_M50;
import dk.hkj.devices.BatteryDataMaxellCR2032;
import dk.hkj.devices.BatteryDataMolicelINR21700_P42A;
import dk.hkj.devices.BatteryDataPanasonicCR123;
import dk.hkj.devices.BatteryDataRenataLR44;
import dk.hkj.devices.BatteryDataSamsungINR18650_36G;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.SCPICommand;
import dk.hkj.main.ValueFormat;
import dk.hkj.util.MathUtil;
import dk.hkj.util.StringUtil;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class VirtualBatteryGenerator
extends DeviceInterface {
    private static final String idName = "HKJ,VirtualBatteryGenerator,";
    private static final String longName = "VirtualBatteryGenerator";
    private static final String handleName = "VBG";
    private static NumberFormat nf;
    private static NumberFormat nf3;
    private static final int V_COLUMN = 0;
    private static final int Ah_COLUMN = 1;
    private OutputFormat outputFormat = OutputFormat.Capacity;

    public VirtualBatteryGenerator(ManageDeviceDefinitions.DeviceDefinition def) {
        super(def);
        this.valueFormats.add(new ValueFormat("Voltage", "V", ValueFormat.formatD3));
        this.valueFormats.add(new ValueFormat("Capacity", "Ah", ValueFormat.formatD3));
        this.valueFormats.add(new ValueFormat("UsedCap", "Ah", ValueFormat.formatD3));
        this.valueFormats.add(new ValueFormat("Current", "A", ValueFormat.formatD3));
        nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nf.setGroupingUsed(false);
        nf.setMaximumFractionDigits(5);
        nf3 = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nf3.setGroupingUsed(false);
        nf3.setMaximumFractionDigits(3);
        this.setHandleName(handleName);
    }

    public static String name() {
        return idName;
    }

    public static String deviceName() {
        return longName;
    }

    public static String handleName() {
        return handleName;
    }

    @Override
    public String getDeviceName() {
        return longName;
    }

    @Override
    public String getDeviceId() {
        return idName;
    }

    @Override
    public synchronized void initColumns() {
        if (this.valueNames != null) {
            return;
        }
        this.valueNames = new ArrayList();
        this.valueNames.add("Voltage");
        switch (this.outputFormat) {
            case Capacity: {
                this.valueNames.add("Capacity");
                break;
            }
            case UsedCap: {
                this.valueNames.add("UsedCap");
            }
        }
        this.valueNames.add("Current");
        this.askValueCommand = new SCPICommand((DeviceInterface)this, "VALUES?");
    }

    @Override
    public void resetTime() {
        ((VirtualComm)this.dt.cPort).resetTime();
    }

    @Override
    public CommInterface getCommInterface(CommInterface ci) {
        return new VirtualComm();
    }

    public static void resetForReload() {
        VirtualInterface.idNoSeq = 0;
    }

    public static class BatteryModel {
        String name = "";
        double openVoltage = 4.2;
        double ri = 0.0;
        boolean rechargeable = false;
        List<BatteryModelDataset> datasets = new ArrayList<BatteryModelDataset>();

        public BatteryModel(String name, double openVoltage, double ri, boolean rechargeable) {
            this.name = name;
            this.openVoltage = openVoltage;
            this.ri = ri;
            this.rechargeable = rechargeable;
        }

        public String getName() {
            return this.name;
        }

        private BatteryModelDataset[] getDatasets(double current) {
            current = Math.abs(current);
            BatteryModelDataset low = null;
            BatteryModelDataset high = null;
            for (BatteryModelDataset bmd : this.datasets) {
                double c = bmd.getCurrent();
                if ((low == null || c >= low.getCurrent()) && c <= current) {
                    low = bmd;
                }
                if (high != null && !(c <= high.getCurrent()) || !(c >= current)) continue;
                high = bmd;
            }
            if (low == high || high == null) {
                return new BatteryModelDataset[]{low};
            }
            if (low == null) {
                return new BatteryModelDataset[]{high};
            }
            return new BatteryModelDataset[]{low, high};
        }

        private double interpolate(double v1, double v2, double current, double r1, double r2) {
            double dr = r1 - r2;
            double dv = v1 - v2;
            return v1 + (Math.abs(current) - r1) / dr * dv;
        }

        public boolean nameEquals(String name) {
            if (name == null || name.length() == 0) {
                return false;
            }
            return this.name.toLowerCase().startsWith(name.toLowerCase());
        }

        public void addDataset(BatteryModelDataset dataset) {
            this.datasets.add(dataset);
            if (this.ri > 0.0) {
                dataset.setLocalOffsetVoltage(this.openVoltage);
            }
        }

        public double getCapacity(double current) {
            BatteryModelDataset[] bmd = this.getDatasets(current);
            if (bmd.length == 1) {
                return bmd[0].getCapacity();
            }
            double c1 = bmd[0].getCapacity();
            double c2 = bmd[1].getCapacity();
            return this.interpolate(c1, c2, current, bmd[0].getCurrent(), bmd[1].getCurrent());
        }

        public BatteryModelDataset getLowestCurrent() {
            BatteryModelDataset bmdLow = null;
            for (BatteryModelDataset bmd : this.datasets) {
                if (bmdLow != null && (!(bmd.current < bmdLow.current) || !(bmd.current > 0.0))) continue;
                bmdLow = bmd;
            }
            return bmdLow;
        }

        public double getVoltage(double dischargeCapacity, double current) {
            if (current == 0.0 && dischargeCapacity == 0.0) {
                return this.openVoltage;
            }
            BatteryModelDataset[] bmd = this.getDatasets(current);
            double v = 0.0;
            if (bmd.length == 1) {
                v = bmd[0].getVoltage(dischargeCapacity);
            } else {
                double c1 = bmd[0].getVoltage(dischargeCapacity);
                double c2 = bmd[1].getVoltage(dischargeCapacity);
                v = this.interpolate(c1, c2, current, bmd[0].getCurrent(), bmd[1].getCurrent());
            }
            if (current > 0.0) {
                if (!this.rechargeable) {
                    return this.openVoltage;
                }
                double vv = this.getLowestCurrent().getVoltage(dischargeCapacity);
                double dv = vv - v;
                v += dv;
            }
            return v;
        }

        public double getCapacityAtVoltage(double voltage, double current) {
            BatteryModelDataset[] bmd = this.getDatasets(current);
            double c = 0.0;
            if (bmd.length == 1) {
                c = bmd[0].getCapacityAtVoltage(voltage);
            } else {
                double c1 = bmd[0].getCapacityAtVoltage(voltage);
                double c2 = bmd[1].getCapacityAtVoltage(voltage);
                c = this.interpolate(c1, c2, current, bmd[0].getCurrent(), bmd[1].getCurrent());
            }
            return c;
        }

        public double getEndVoltage(double current) {
            BatteryModelDataset[] bmd = this.getDatasets(current);
            if (bmd.length == 1) {
                return bmd[0].getEndVoltage();
            }
            double c1 = bmd[0].getEndVoltage();
            double c2 = bmd[1].getEndVoltage();
            return this.interpolate(c1, c2, current, bmd[0].getCurrent(), bmd[1].getCurrent());
        }

        public double getRi() {
            return this.ri;
        }

        public String getTestCurrents() {
            StringBuilder sb = new StringBuilder();
            for (BatteryModelDataset bmd : this.datasets) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(StringUtil.formatDoubleEE(bmd.getCurrent(), false));
            }
            return sb.toString();
        }

        public String getInitialVoltages() {
            StringBuilder sb = new StringBuilder();
            sb.append("Open:");
            sb.append(nf3.format(this.openVoltage));
            for (BatteryModelDataset bmd : this.datasets) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(StringUtil.formatDoubleEE(bmd.getCurrent(), false));
                sb.append(":");
                sb.append(nf3.format(bmd.getVoltage(0.0)));
            }
            return sb.toString();
        }

        public String getEndVoltages() {
            StringBuilder sb = new StringBuilder();
            for (BatteryModelDataset bmd : this.datasets) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(StringUtil.formatDoubleEE(bmd.getCurrent(), false));
                sb.append(":");
                sb.append(nf3.format(bmd.getEndVoltage()));
            }
            return sb.toString();
        }

        public String getModelCapacities() {
            StringBuilder sb = new StringBuilder();
            for (BatteryModelDataset bmd : this.datasets) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(StringUtil.formatDoubleEE(bmd.getCurrent(), false));
                sb.append(":");
                sb.append(nf.format(bmd.getCapacity()));
            }
            return sb.toString();
        }

        public double getMaxCurrent() {
            double current = 0.0;
            for (BatteryModelDataset bmd : this.datasets) {
                if (!(Math.abs(bmd.current) > current)) continue;
                current = Math.abs(bmd.current);
            }
            return current;
        }

        public double graceCapacity() {
            return this.getLowestCurrent().getCapacity() * 0.01;
        }
    }

    public static class BatteryModelDataset {
        private double current = 0.0;
        private double offsetVoltage = 0.0;
        private final float[][] data;

        BatteryModelDataset(double current, float[][] data) {
            this.data = data;
            this.current = current;
            this.offsetVoltage = 0.0;
        }

        public double getCurrent() {
            return this.current;
        }

        protected void setLocalOffsetVoltage(double voltage) {
            this.offsetVoltage = 0.0;
            this.offsetVoltage = voltage - this.getVoltage(0.0);
        }

        public double getEndVoltage() {
            return this.data[this.data.length - 1][0];
        }

        public double getCapacity() {
            return this.data[this.data.length - 1][1];
        }

        public double getVoltage(double dischargedCapacity) {
            return MathUtil.interpolateLinear(dischargedCapacity, 1, 0, this.data) + this.offsetVoltage;
        }

        public double getCapacityAtVoltage(double voltage) {
            return MathUtil.interpolateLinear(voltage - this.offsetVoltage, 0, 1, this.data);
        }
    }

    private static enum OutputFormat {
        Capacity,
        UsedCap;

    }

    private class VirtualComm
    extends VirtualInterface {
        private double ri = 0.03;
        private double usedCapacity = 0.0;
        private double batteryCapacity = 0.0;
        private double voltage = 0.0;
        private double current = 0.0;
        private long timeMark;
        private int series = 1;
        private BatteryModel model;

        protected VirtualComm() {
            this.setModel(null);
        }

        protected synchronized void resetTime() {
            this.timeMark = System.currentTimeMillis();
        }

        @Override
        public String getName() {
            return "Virtual";
        }

        @Override
        public void open() {
            super.open();
            this.setModel(null);
        }

        private boolean setModel(int no) {
            boolean valid = true;
            switch (no) {
                case 0: {
                    this.model = BatteryDataLG18650_H26.getModel();
                    break;
                }
                case 1: {
                    this.model = BatteryDataLG21700_M50.getModel();
                    break;
                }
                case 2: {
                    this.model = BatteryDataSamsungINR18650_36G.getModel();
                    break;
                }
                case 3: {
                    this.model = BatteryDataMolicelINR21700_P42A.getModel();
                    break;
                }
                case 4: {
                    this.model = BatteryDataEnergizerLithiumAA.getModel();
                    break;
                }
                case 5: {
                    this.model = BatteryDataDuracellPlusAA.getModel();
                    break;
                }
                case 6: {
                    this.model = BatteryDataDuracellPlusAAA.getModel();
                    break;
                }
                case 7: {
                    this.model = BatteryDataEneloopAA.getModel();
                    break;
                }
                case 8: {
                    this.model = BatteryDataFujitsu9VGold.getModel();
                    break;
                }
                case 9: {
                    this.model = BatteryDataMaxellCR2032.getModel();
                    break;
                }
                case 10: {
                    this.model = BatteryDataRenataLR44.getModel();
                    break;
                }
                case 11: {
                    this.model = BatteryDataEnergizerLithiumAAA.getModel();
                    break;
                }
                case 12: {
                    this.model = BatteryDataKodakHeavyDutyAA.getModel();
                    break;
                }
                case 13: {
                    this.model = BatteryDataKodakHeavyDutyAAA.getModel();
                    break;
                }
                case 14: {
                    this.model = BatteryDataEneloopAAA.getModel();
                    break;
                }
                case 15: {
                    this.model = BatteryDataPanasonicCR123.getModel();
                    break;
                }
                default: {
                    this.model = BatteryDataDuracellPlusAA.getModel();
                    valid = false;
                }
            }
            this.batteryCapacity = this.model.getCapacity(0.0);
            this.usedCapacity = 0.0;
            this.ri = this.model.getRi();
            return valid;
        }

        private void setModel(String name) {
            if (name != null) {
                name = name.trim();
            }
            if (StringUtil.isInt(name)) {
                this.setModel(StringUtil.parseInt(name));
            } else {
                int no = 0;
                no = BatteryDataLG18650_H26.getModel().nameEquals(name) ? 0 : (BatteryDataLG21700_M50.getModel().nameEquals(name) ? 1 : (BatteryDataSamsungINR18650_36G.getModel().nameEquals(name) ? 2 : (BatteryDataMolicelINR21700_P42A.getModel().nameEquals(name) ? 3 : (BatteryDataEnergizerLithiumAA.getModel().nameEquals(name) ? 4 : (BatteryDataDuracellPlusAA.getModel().nameEquals(name) ? 5 : (BatteryDataDuracellPlusAAA.getModel().nameEquals(name) ? 6 : (BatteryDataEneloopAA.getModel().nameEquals(name) ? 7 : (BatteryDataFujitsu9VGold.getModel().nameEquals(name) ? 8 : (BatteryDataMaxellCR2032.getModel().nameEquals(name) ? 9 : (BatteryDataRenataLR44.getModel().nameEquals(name) ? 10 : (BatteryDataEnergizerLithiumAAA.getModel().nameEquals(name) ? 11 : (BatteryDataKodakHeavyDutyAA.getModel().nameEquals(name) ? 12 : (BatteryDataKodakHeavyDutyAAA.getModel().nameEquals(name) ? 13 : (BatteryDataEneloopAAA.getModel().nameEquals(name) ? 14 : (BatteryDataPanasonicCR123.getModel().nameEquals(name) ? 15 : 999)))))))))))))));
                this.setModel(no);
            }
        }

        private double capBattToModel(double capacity) {
            return capacity * this.model.getCapacity(0.0) / this.batteryCapacity;
        }

        private double capModelToBatt(double capacity) {
            return capacity / this.model.getCapacity(0.0) * this.batteryCapacity;
        }

        private double getSOC(double current) {
            return this.getCapacity(current) / this.getBatteryCapacity(current);
        }

        public double getCapacity(double current) {
            return this.getBatteryCapacity(current) - this.usedCapacity;
        }

        public double getBatteryCapacity(double current) {
            return this.capModelToBatt(this.model.getCapacity(current));
        }

        public double getVoltage(double capacity, double current) {
            return this.model.getVoltage(capacity, current) + this.ri * current;
        }

        public double getEndVoltage(double current) {
            return this.model.getEndVoltage(current);
        }

        public double getCapacityAtVoltage(double voltage, double current) {
            return this.capModelToBatt(this.model.getCapacityAtVoltage(voltage, current));
        }

        private void update() {
            long time = System.currentTimeMillis();
            long dt = time - this.timeMark;
            this.timeMark = time;
            double ddc = -this.current / 3600.0 * (double)dt / 1000.0;
            this.usedCapacity += ddc;
            double c = this.capBattToModel(this.usedCapacity);
            if (c > this.model.getCapacity(0.0) + this.model.graceCapacity()) {
                this.voltage = 0.0;
                this.usedCapacity = this.model.getCapacity(this.current);
                this.current = 0.0;
            } else if (c < -this.model.graceCapacity()) {
                this.voltage = this.model.getVoltage(c, 0.0) * (double)this.series;
                this.usedCapacity = 0.0;
                this.current = 0.0;
            } else {
                this.voltage = this.getVoltage(c, this.current) * (double)this.series;
                if (Math.abs(this.current) > this.model.getMaxCurrent() * 1.3) {
                    this.voltage = 0.0;
                }
            }
        }

        private String calculateOutput() {
            StringBuilder sb = new StringBuilder();
            this.update();
            sb.append(nf.format(this.voltage));
            sb.append(" ");
            switch (VirtualBatteryGenerator.this.outputFormat) {
                case Capacity: {
                    sb.append(nf.format(this.getBatteryCapacity(this.current) - this.usedCapacity));
                    break;
                }
                case UsedCap: {
                    sb.append(nf.format(this.usedCapacity));
                    break;
                }
            }
            sb.append(" ");
            sb.append(nf.format(this.current));
            return sb.toString();
        }

        private void setBatteryCapacity(double batteryCapacity) {
            this.batteryCapacity = batteryCapacity;
            this.usedCapacity = 0.0;
        }

        private void setUsedCapacity(double usedCapacity) {
            double c = this.getBatteryCapacity(this.current);
            if (usedCapacity < 0.0) {
                usedCapacity = 0.0;
            }
            if (usedCapacity > c) {
                usedCapacity = c;
            }
            this.usedCapacity = usedCapacity;
        }

        private void setCurrentCapacity(double capacity) {
            double c = this.getBatteryCapacity(this.current);
            this.usedCapacity = c - capacity;
            if (this.usedCapacity < 0.0) {
                this.usedCapacity = 0.0;
            }
            if (this.usedCapacity > c) {
                this.usedCapacity = c;
            }
        }

        private void listAllInfo() {
            int i = 0;
            while (this.setModel(i)) {
                System.out.println("Name: " + this.model.getName());
                System.out.println("Initial voltage: " + this.model.getInitialVoltages());
                System.out.println("End voltage: " + this.model.getEndVoltages());
                System.out.println("Capacity: " + this.model.getModelCapacities());
                System.out.println();
                ++i;
            }
        }

        @Override
        public synchronized boolean write(String msg) {
            block70: {
                String[] items = (msg = msg.trim().replaceAll(",", ".")).split("[ ;]+");
                if (items.length == 0) {
                    return true;
                }
                try {
                    int i = 0;
                    while (i < items.length) {
                        items[i] = items[i].trim();
                        ++i;
                    }
                    String cmd = items[0].toUpperCase();
                    if (cmd.equals("VALUES?")) {
                        this.message.add(this.calculateOutput());
                        break block70;
                    }
                    if (cmd.equals("OUTPUTFORMAT")) {
                        OutputFormat[] outputFormatArray = OutputFormat.values();
                        int n = outputFormatArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            OutputFormat of = outputFormatArray[n2];
                            if (of.name().equalsIgnoreCase(items[1])) {
                                VirtualBatteryGenerator.this.outputFormat = of;
                                break block70;
                            }
                            ++n2;
                        }
                        break block70;
                    }
                    if (cmd.equals("OUTPUTFORMAT")) {
                        this.message.add(VirtualBatteryGenerator.this.outputFormat.name());
                    } else if (cmd.equals("MODELCAPACITY?")) {
                        double curr = items.length < 2 ? 0.0 : StringUtil.parseDoubleEE(items[1]);
                        this.message.add(nf.format(this.model.getCapacity(curr)));
                    } else if (cmd.equals("BATTERYCAPACITY?")) {
                        double curr = items.length < 2 ? 0.0 : StringUtil.parseDoubleEE(items[1]);
                        this.message.add(nf.format(this.getBatteryCapacity(curr)));
                    } else if (cmd.equals("BATTERYCAPACITY") && items.length > 2) {
                        this.setBatteryCapacity(StringUtil.parseDoubleEE(items[1]));
                    } else if (cmd.equals("CAPACITY?")) {
                        double curr = items.length < 2 ? this.current : StringUtil.parseDoubleEE(items[1]);
                        this.message.add(nf.format(this.getCapacity(curr)));
                    } else if (cmd.equals("CAPACITY") && items.length > 2) {
                        this.setCurrentCapacity(StringUtil.parseDoubleEE(items[1]));
                    } else if (cmd.equals("USEDCAPACITY?")) {
                        this.message.add(nf.format(this.usedCapacity));
                    } else if (cmd.equals("USEDCAPACITY") && items.length > 2) {
                        this.setUsedCapacity(StringUtil.parseDoubleEE(items[1]));
                    } else if (cmd.equals("ADD") && items.length > 2) {
                        this.setCurrentCapacity(this.batteryCapacity - this.usedCapacity + StringUtil.parseDoubleEE(items[1]));
                    } else if (cmd.equals("ADDPCT") && items.length > 2) {
                        double c = this.getBatteryCapacity(this.current);
                        this.setCurrentCapacity(c - this.usedCapacity + c * StringUtil.parseDoubleEE(items[1]));
                    } else if (cmd.equals("SOC?")) {
                        this.message.add(nf.format(this.getSOC(this.current)));
                    } else if (cmd.equals("SOC") && items.length > 2) {
                        this.setCurrentCapacity(this.getBatteryCapacity(this.current) * StringUtil.parseDoubleEE(items[1]));
                    } else if (cmd.equals("CURRENT?")) {
                        this.message.add(nf.format(this.current));
                    } else if (cmd.equals("CURRENT") && items.length > 2) {
                        this.update();
                        this.current = StringUtil.parseDoubleEE(items[1]);
                    } else if (cmd.equals("RI?")) {
                        this.message.add(nf.format(this.ri));
                    } else if (cmd.equals("RI") && items.length > 2) {
                        this.ri = StringUtil.parseDoubleEE(items[1]);
                    } else if (cmd.equals("SERIES?")) {
                        this.message.add(Integer.toString(this.series));
                    } else if (cmd.equals("SERIES") && items.length > 2) {
                        this.series = (int)Math.round(StringUtil.parseDoubleEE(items[1]));
                        if (this.series < 1) {
                            this.series = 1;
                        }
                    } else if (cmd.equals("CAPTOVOLT?") && items.length > 2) {
                        double cap = StringUtil.parseDoubleEE(items[1]);
                        double curr = items.length < 3 ? 0.0 : StringUtil.parseDoubleEE(items[2]);
                        this.message.add(nf3.format(this.getVoltage(this.getBatteryCapacity(0.0) - cap, curr)));
                    } else if (cmd.equals("VOLTTOCAP?") && items.length > 2) {
                        double volt = StringUtil.parseDoubleEE(items[1]);
                        double curr = items.length < 3 ? 0.0 : StringUtil.parseDoubleEE(items[2]);
                        this.message.add(nf3.format(this.getCapacityAtVoltage(volt, curr)));
                    } else if (cmd.equals("USEDCAPTOVOLT?") && items.length > 2) {
                        double cap = StringUtil.parseDoubleEE(items[1]);
                        double curr = items.length < 3 ? 0.0 : StringUtil.parseDoubleEE(items[2]);
                        this.message.add(nf3.format(this.getVoltage(cap, curr)));
                    } else if (cmd.equals("TESTCURRENTS?")) {
                        this.message.add(this.model.getTestCurrents());
                    } else if (cmd.equals("MODEL?")) {
                        this.message.add("\"" + this.model.getName() + "\"");
                    } else if (cmd.equals("MODEL") && items.length > 2) {
                        StringBuilder sb = new StringBuilder();
                        int i2 = 1;
                        while (i2 < items.length) {
                            if (sb.length() > 0) {
                                sb.append(" ");
                            }
                            sb.append(items[i2]);
                            ++i2;
                        }
                        this.setModel(StringUtil.unQuote(sb.toString()));
                    } else if (cmd.equals("OPENVOLTAGE?")) {
                        this.message.add(nf3.format(this.getVoltage(0.0, 0.0)));
                    } else if (cmd.equals("ENDVOLTAGE?")) {
                        this.message.add(nf3.format(this.getEndVoltage(items.length < 2 ? 0.0 : StringUtil.parseDoubleEE(items[1]))));
                    } else if (cmd.equals("INITIALVOLTAGES?")) {
                        this.message.add("\"" + this.model.getInitialVoltages() + "\"");
                    } else if (cmd.equals("ENDVOLTAGES?")) {
                        this.message.add("\"" + this.model.getEndVoltages() + "\"");
                    } else if (cmd.equals("MODELCAPACITIES?")) {
                        this.message.add("\"" + this.model.getModelCapacities() + "\"");
                    } else if (cmd.equals("*IDN?")) {
                        this.message.add(VirtualBatteryGenerator.idName);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                }
            }
            return true;
        }
    }
}

