/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.devices.SetupFormats;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.SCPICommand;
import dk.hkj.main.Support;
import dk.hkj.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class SetupFormatsAdjuster {
    public static List<AdjustParam> listAdjustableParams(boolean includeCustom) {
        ArrayList<AdjustParam> list = new ArrayList<AdjustParam>();
        for (InterfaceThreads.DeviceThread dt : InterfaceThreads.getDevices()) {
            List<SetupFormats> modes = dt.getDeviceInterface().getSetupPopupList();
            for (SetupFormats sf : modes) {
                if (!sf.getClass().equals(SetupFormats.NumberField.class) || sf.name.replace("_", "").replace("-", "").length() <= 0) continue;
                list.add(new AdjustParam(dt, (SetupFormats.NumberField)sf));
            }
        }
        if (includeCustom) {
            for (InterfaceThreads.DeviceThread dt : InterfaceThreads.getDevices()) {
                list.add(new AdjustParam(dt, "SCPI command for " + dt.getHandleName()));
            }
        }
        return list;
    }

    public static AdjustParam getAdjustParam(String adjustParamName) {
        for (InterfaceThreads.DeviceThread dt : InterfaceThreads.getDevices()) {
            List<SetupFormats> modes = dt.getDeviceInterface().getSetupPopupList();
            for (SetupFormats sf : modes) {
                String name;
                if (!sf.getClass().equals(SetupFormats.NumberField.class) || sf.name.replace("_", "").replace("-", "").length() <= 0 || !adjustParamName.equals(name = String.valueOf(dt.getDeviceInterface().getHandleName()) + " " + (sf.page != null && sf.page.length() > 0 ? String.valueOf(sf.page) + " " : "") + sf.name)) continue;
                return new AdjustParam(dt, (SetupFormats.NumberField)sf);
            }
        }
        for (InterfaceThreads.DeviceThread dt : InterfaceThreads.getDevices()) {
            if (!adjustParamName.equals("SCPI command for " + dt.getHandleName())) continue;
            return new AdjustParam(dt, "SCPI command for " + dt.getHandleName());
        }
        return null;
    }

    public static List<String> listAdjustableParamsNames(boolean includeCustom) {
        ArrayList<String> list = new ArrayList<String>();
        for (InterfaceThreads.DeviceThread dt : InterfaceThreads.getDevices()) {
            List<SetupFormats> modes = dt.getDeviceInterface().getSetupPopupList();
            for (SetupFormats sf : modes) {
                if (!sf.getClass().equals(SetupFormats.NumberField.class) || sf.name.replace("_", "").replace("-", "").length() <= 0) continue;
                list.add(String.valueOf(dt.getDeviceInterface().getHandleName()) + " " + (sf.page != null && sf.page.length() > 0 ? String.valueOf(sf.page) + " " : "") + sf.name);
            }
        }
        list.sort(null);
        if (includeCustom) {
            for (InterfaceThreads.DeviceThread dt : InterfaceThreads.getDevices()) {
                list.add("SCPI command for " + dt.getHandleName());
            }
        }
        return list;
    }

    public static List<String> listAdjustableParamsNames(String device) {
        ArrayList<String> list = new ArrayList<String>();
        for (InterfaceThreads.DeviceThread dt : InterfaceThreads.getDevices()) {
            if (!dt.getHandleName().equalsIgnoreCase(device)) continue;
            List<SetupFormats> modes = dt.getDeviceInterface().getSetupPopupList();
            for (SetupFormats sf : modes) {
                if (!sf.getClass().equals(SetupFormats.NumberField.class) || sf.name.replace("_", "").replace("-", "").length() <= 0) continue;
                list.add(String.valueOf(dt.getDeviceInterface().getHandleName()) + " " + (sf.page != null && sf.page.length() > 0 ? String.valueOf(sf.page) + " " : "") + sf.name);
            }
        }
        return list;
    }

    public static class AdjustParam
    implements Comparable<AdjustParam> {
        private String name = "";
        private String pageName = null;
        private String controlName = null;
        private double min = 0.0;
        private double max = 0.0;
        private String unit = "";
        private boolean isInt = false;
        private boolean useCustomCmd = false;
        private SCPICommand write = null;
        private SCPICommand read = null;
        private String cmd = null;
        private InterfaceThreads.DeviceThread dt = null;

        AdjustParam(InterfaceThreads.DeviceThread dt, String name) {
            this.name = name;
            this.dt = dt;
            this.min = -1.7976931348623157E308;
            this.max = Double.MAX_VALUE;
            this.unit = "";
            this.isInt = false;
            this.useCustomCmd = true;
            this.write = dt.getDeviceInterface().getCommand("");
        }

        AdjustParam(InterfaceThreads.DeviceThread dt, SetupFormats.NumberField sf) {
            this.name = String.valueOf(dt.getDeviceInterface().getHandleName()) + " " + (sf.page != null && sf.page.length() > 0 ? String.valueOf(sf.page) + " " : "") + sf.name;
            this.pageName = sf.page;
            this.controlName = sf.name;
            this.useCustomCmd = false;
            this.dt = dt;
            SetupFormats.LabelDualValue ld = (SetupFormats.LabelDualValue)sf.labelValues.get(0);
            this.unit = Support.toUnit(ld.label);
            this.min = StringUtil.parseDoubleEE(ld.value1);
            this.max = StringUtil.parseDoubleEE(ld.value2);
            this.write = dt.getDeviceInterface().getCommand(sf.getTag(":write:"));
            this.read = dt.getDeviceInterface().getCommand(sf.getTag(":read:"), sf.getTag(":readmath:"), sf.getTag(":readformat:"));
        }

        public void setDeviceOn(boolean on) {
            DeviceInterface di = this.dt.getDeviceInterface();
            if (di.getIFaceChannels() > 1) {
                return;
            }
            if (di.getIFaces().containsKey("setOn")) {
                di.executeIFace("setOn", 1, on ? 1 : 0);
            }
        }

        public String getName() {
            return this.name;
        }

        public DeviceInterface getDeviceInterface() {
            return this.dt.getDeviceInterface();
        }

        public String getPageName() {
            return this.pageName;
        }

        public String getControlName() {
            return this.controlName;
        }

        public String getHandle() {
            return this.dt.getDeviceInterface().getHandleName();
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public boolean isInt() {
            return this.isInt;
        }

        public String getUnit() {
            return this.unit;
        }

        public void setCmd(String cmd) {
            this.cmd = cmd;
        }

        public String getCmd() {
            return this.cmd == null ? "" : this.cmd;
        }

        public boolean useCustomCommand() {
            return this.useCustomCmd;
        }

        public String toString() {
            return this.name;
        }

        private void setParamWrite(double v, boolean update) {
            if (this.isInt) {
                v = Math.rint(v);
            }
            if (update) {
                String s = StringUtil.fixNumber(Double.toString(v));
                while (s.contains(".") && s.endsWith("0")) {
                    s = s.substring(0, s.length() - 1);
                }
                this.setSetupField(s);
            }
            this.write.write(Double.toString(v));
        }

        public void setParam(double v) {
            if (this.useCustomCommand()) {
                this.write.setCmd(this.cmd);
            }
            this.setParamWrite(v, false);
        }

        public void setParam(double v, boolean update) {
            if (this.useCustomCommand()) {
                this.write.setCmd(this.cmd);
            }
            this.setParamWrite(v, update);
        }

        public Double getParam() {
            try {
                double v;
                if (this.read != null && !Double.isNaN(v = this.read.readNumber()) && !Double.isInfinite(v)) {
                    return v;
                }
            }
            catch (Exception exception) {}
            return null;
        }

        public void setSetupField(final String value) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    dt.getDeviceInterface().setSetupFieldValue(SetupFormats.RadioField.class, pageName, controlName, value);
                    dt.getDeviceInterface().setSetupFieldValue(SetupFormats.NumberField.class, pageName, controlName, value);
                }
            });
        }

        public boolean equals(Object o) {
            if (!(o instanceof AdjustParam)) {
                return false;
            }
            return this.name.equals(((AdjustParam)o).name);
        }

        @Override
        public int compareTo(AdjustParam o) {
            return this.name.compareTo(o.name);
        }
    }
}

