/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.color.ColorUtil;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.IconGenerator;
import dk.hkj.main.Indicator;
import dk.hkj.main.PopupParamAdjuster;
import dk.hkj.main.PopupSetupSelection;
import dk.hkj.main.SCPICommand;
import dk.hkj.main.Support;
import dk.hkj.main.ValueFormat;
import dk.hkj.script.Script;
import dk.hkj.util.StringUtil;
import dk.hkj.vars.Var;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class SetupFormats {
    public static final String itemRead = ":read:";
    public static final String itemWrite = ":write:";
    public static final String itemReadFormat = ":readformat:";
    public static final String itemReadMath = ":readmath:";
    public static final String itemDecodeMath = ":decodemath:";
    private static final String itemTip = ":tip:";
    private static final String itemUpdate = ":update:";
    public static final String itemStringResult = ":string:";
    private static final String itemUpdateDelayed = ":updatedelayed:";
    private static final String itemColor = ":color:";
    private static final String itemBGColor = ":bgcolor:";
    private static final String itemEnable = ":enable:";
    private static final String itemVisible = ":visible:";
    private static final String itemButtonText = ":buttontext:";
    private static final String itemUpdateAllOff = ":updatealloff:";
    private static final String itemUpdateModeChange = ":updatemodechange:";
    public static final String itemSetVar = ":setvar:";
    private static final String itemEmptyValue = ":emptyvalue:";
    private static final String itemEmptyWrite = ":emptywrite:";
    private static final String itemLayout = ":layout:";
    private static final String itemTxDelimiter = ":txdelimiter:";
    private static final String itemFormat = ":format:";
    private static final String itemTextWidth = ":textwidth:";
    private static final String itemLabelFormat = ":labelformat:";
    private static final String[] validTags = new String[]{":read:", ":write:", ":readformat:", ":readmath:", ":tip:", ":update:", ":updatedelayed:", ":color:", ":enable:", ":visible:", ":buttontext:", ":updatealloff:", ":string:", ":bgcolor:", ":updatemodechange:", ":setvar:", ":emptyvalue:", ":emptywrite:", ":layout:", ":txdelimiter:", ":format:", ":textwidth:", ":labelformat:"};
    protected DeviceInterface deviceInterface;
    protected String name = "";
    protected String page = "";
    protected SCPICommand read = null;
    protected SCPICommand write = null;
    protected Timer updateTimer = null;
    protected PopupSetupSelection form = null;
    protected Script script = null;
    protected Object currentValue = null;
    protected Object currentValue2 = null;
    protected Object currentValue3 = null;
    private Map<String, String> tags = new HashMap<String, String>();
    private static final String controlInfoName = "info";
    private static final String controlNumberName = "number";
    private static final String controlNumberIntName = "numberint";
    private static final String controlCheckboxName = "checkbox";
    private static final String controlComboboxName = "combobox";

    public abstract SetupFormats getClone(DeviceInterface var1);

    private static String validTag(String tag) {
        String[] stringArray = validTags;
        int n = validTags.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equalsIgnoreCase(tag)) {
                return s;
            }
            ++n2;
        }
        return null;
    }

    protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
        this.deviceInterface = newDeviceInterface;
        this.name = model.name;
        this.page = model.page;
        this.read = newDeviceInterface.getCommand(model.getTag(itemRead), model.getTag(itemReadMath), model.getTag(itemReadFormat));
        this.write = newDeviceInterface.getCommand(model.getTag(itemWrite));
        this.write.setSaveInCommandList(true);
        this.tags = model.tags;
    }

    public void setSetupFieldValue(String value) {
    }

    public boolean isTagParam(String name) {
        String s = this.tags.get(name);
        return s != null && s.length() > 0;
    }

    public boolean isTagPresent(String name) {
        return this.tags.get(name) != null;
    }

    public String getTag(String name) {
        String s = this.tags.get(name);
        return s == null ? "" : s;
    }

    public String getTag(String name, String def) {
        String s = this.tags.get(name);
        return s == null ? def : s;
    }

    public int getTagInt(String name, int def) {
        String s = this.tags.get(name);
        return s == null ? def : Integer.parseInt(s);
    }

    public int getTagInt(String name, int def, int index) {
        String s = this.tags.get(name);
        if (s == null) {
            return def;
        }
        String[] ss = s.split("[,; ]+");
        return Integer.parseInt(index < ss.length ? ss[index] : ss[0]);
    }

    public Double getTagFloat(String name, Double def) {
        String s = this.tags.get(name);
        return s == null ? def : Double.valueOf(StringUtil.parseDoubleEE(s));
    }

    public Color getTagColor(String name, Color def) {
        String s = this.tags.get(name);
        return s == null ? def : ColorUtil.nameToColor(s.trim());
    }

    public void setBGColor(Component comp) {
        Color color = this.getTagColor(itemBGColor, null);
        if (color == null) {
            for (SetupFormats mode : this.form.modes) {
                if (!(mode instanceof ColorField) || !mode.getPage().equals(this.page)) continue;
                color = ((ColorField)mode).getBGColor();
                break;
            }
        }
        if (color != null) {
            comp.setBackground(color);
        }
    }

    protected void adjustLabelFormat(JLabel label) {
        String ss = this.tags.get(itemLabelFormat);
        if (ss == null) {
            return;
        }
        Integer style = null;
        Color c = null;
        int size = 0;
        String[] stringArray = ss.split("[ ]+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equalsIgnoreCase("bold")) {
                style = style == null ? Integer.valueOf(1) : Integer.valueOf(style | 1);
            } else if (s.equalsIgnoreCase("italic")) {
                style = style == null ? Integer.valueOf(2) : Integer.valueOf(style | 2);
            } else if (s.equalsIgnoreCase("plain")) {
                style = style == null ? Integer.valueOf(0) : Integer.valueOf(style | 0);
            } else if (s.equalsIgnoreCase("+")) {
                ++size;
            } else if (s.equalsIgnoreCase("++")) {
                size += 2;
            } else if (s.equalsIgnoreCase("+++")) {
                size += 3;
            } else if (s.equalsIgnoreCase("++++")) {
                size += 4;
            } else if (s.equalsIgnoreCase("+++++")) {
                size += 5;
            } else if (s.equalsIgnoreCase("++++++")) {
                size += 6;
            } else {
                try {
                    c = ColorUtil.nameToColor(s);
                }
                catch (Exception exception) {}
            }
            if (c != null) {
                label.setForeground(c);
            }
            Font font = label.getFont();
            Float fsize = Float.valueOf(font.getSize2D() + (float)(size * 2));
            if (style != null) {
                label.setFont(font.deriveFont((int)style, fsize.floatValue()));
            } else if (size > 0) {
                label.setFont(font.deriveFont(fsize.floatValue()));
            }
            ++n2;
        }
    }

    public abstract int addGridBag(PopupSetupSelection var1, JPanel var2, int var3, int var4);

    public void syncValue() {
    }

    protected void setStateVar(Script script) {
    }

    protected String pname() {
        if (this.page.length() > 0) {
            return String.valueOf(this.page) + "." + this.name;
        }
        return this.name;
    }

    protected void setScriptValue(Script script, String name, Object value) {
        if (this.page.length() > 0) {
            name = String.valueOf(this.page) + "." + name;
        }
        if (script == null) {
            return;
        }
        script.getLocalVars().getCreate(name).set(value == null ? Integer.valueOf(0) : value);
    }

    public static void syncAll(List<SetupFormats> list) {
        if (list.size() > 0 && (list.get((int)0).deviceInterface == null || list.get((int)0).deviceInterface.dt == null)) {
            return;
        }
        for (SetupFormats sf : list) {
            sf.syncValue();
        }
    }

    public static void enableItems(List<SetupFormats> list) {
        if (list.size() > 0 && (list.get((int)0).deviceInterface == null || list.get((int)0).deviceInterface.dt == null)) {
            return;
        }
        boolean enablePresent = false;
        boolean visiblePresent = false;
        for (SetupFormats f : list) {
            enablePresent |= f.hasTag(itemEnable);
            visiblePresent |= f.hasTag(itemVisible);
        }
        Script script = null;
        if (enablePresent || visiblePresent) {
            script = new Script();
            script.addLocalVar("handle", Var.createValue(list.get((int)0).deviceInterface.getHandleName()));
            for (SetupFormats f : list) {
                f.setStateVar(script);
            }
        }
        if (enablePresent) {
            for (SetupFormats f : list) {
                f.calcEnable(script);
            }
        }
        if (visiblePresent) {
            for (SetupFormats f : list) {
                f.calcVisible(script);
            }
        }
    }

    protected void calcEnable(Script script) {
        if (this.isTagParam(itemEnable)) {
            try {
                this.setEnable(script.expression(this.getTag(itemEnable)).asBoolean());
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                this.setEnable(true);
            }
        }
    }

    protected void calcVisible(Script script) {
        if (this.isTagParam(itemVisible)) {
            try {
                this.setVisible(script.expression(this.getTag(itemVisible)).asBoolean());
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                this.setVisible(true);
            }
        }
    }

    protected void setEnable(boolean yes) {
    }

    protected void setVisible(boolean yes) {
    }

    protected boolean hasTag(String tag) {
        return this.tags.containsKey(tag);
    }

    public void syncValue(String name) {
        if (name.equals(this.name)) {
            this.syncValue();
        }
    }

    public String formatDouble(double v) {
        String tag = this.tags.get(itemFormat);
        if (tag == null) {
            return StringUtil.formatDoubleEE(v, false).trim();
        }
        int i = tag.indexOf(32);
        if (i > 0) {
            tag = tag.substring(0, i);
        }
        return ValueFormat.getFormatter(tag).formatDisplay(v).trim();
    }

    public String formatDouble(int n, double v) {
        String tag = this.tags.get(itemFormat);
        if (tag == null) {
            return StringUtil.formatDoubleEE(v, false).trim();
        }
        String[] tt = tag.split("[ ]+");
        if (n >= tt.length) {
            n = 0;
        }
        return ValueFormat.getFormatter(tt[n]).formatDisplay(v).trim();
    }

    public final void syncAllOff() {
        for (SetupFormats mode : this.form.modes) {
            if (!mode.hasTag(itemUpdateAllOff)) continue;
            mode.syncValue();
        }
    }

    public final void syncModeChange() {
        for (SetupFormats mode : this.form.modes) {
            if (!mode.hasTag(itemUpdateModeChange)) continue;
            mode.syncValue();
        }
    }

    private void syncher(boolean clearCache) {
        if (clearCache) {
            this.deviceInterface.cacheClear();
        }
        for (SetupFormats mode : this.form.modes) {
            mode.syncValue(this.name);
        }
        String[] stringArray = this.getTag(itemUpdate).split("[;, ]+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            int i = (s = s.trim()).indexOf(46);
            if (i >= 0) {
                s = s.substring(i + 1);
            }
            if (s.length() > 0 && !s.equals(this.name)) {
                for (SetupFormats mode : this.form.modes) {
                    mode.syncValue(s);
                }
            }
            ++n2;
        }
        SetupFormats.enableItems(this.form.modes);
    }

    public void requestSync() {
        this.requestSync(true);
    }

    public void requestSync(boolean clearCache) {
        int dly = (int)(this.getTagFloat(itemUpdateDelayed, 0.0) * 1000.0);
        if (dly > 0) {
            Support.commandList.delayTime(dly);
            this.updateTimer = new Timer(dly, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SetupFormats.this.syncher(true);
                    SetupFormats.this.updateTimer = null;
                }
            });
            this.updateTimer.setRepeats(false);
            this.updateTimer.start();
        } else {
            this.syncher(clearCache);
        }
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.valueOf(this.name) + " r:" + this.read + " w:" + this.write;
    }

    public abstract int getColumns();

    public String getPage() {
        return this.page;
    }

    public String collectWrite() {
        return "";
    }

    public boolean collectEnable() {
        return false;
    }

    protected boolean isEnabled() {
        return true;
    }

    protected boolean isValid() {
        return true;
    }

    protected boolean isVisible() {
        return true;
    }

    protected List<SetupFormats> getControls(String name) {
        ArrayList<SetupFormats> valid = new ArrayList<SetupFormats>();
        for (SetupFormats mode : this.form.modes) {
            if (!mode.isEnabled() || !mode.isVisible()) continue;
            if (mode instanceof SelectorField) {
                valid.addAll(mode.getControls(name));
                continue;
            }
            if (!mode.pname().equals(name)) continue;
            valid.add(mode);
        }
        return valid;
    }

    public static SetupFormats setup(String type, String name, String page, String params) {
        SetupFormats format = null;
        if (params == null) {
            return null;
        }
        if ((type = type.trim().toLowerCase()).equals(controlNumberName)) {
            format = new NumberField();
        } else if (type.equals("text")) {
            format = new TextField();
        } else if (type.equals("textQ")) {
            format = new TextQField();
        } else if (type.equals("numberdual")) {
            format = new NumberDualField();
        } else if (type.equals("numbertriple")) {
            format = new NumberTripleField();
        } else if (type.equals("numberquad")) {
            format = new NumberQuadField();
        } else if (type.equals(controlNumberIntName)) {
            format = new NumberIntField();
        } else if (type.equals("button")) {
            format = new ButtonField();
        } else if (type.equals("buttons")) {
            format = new ButtonsField();
        } else if (type.equals("buttonson")) {
            format = new ButtonsOnField();
        } else if (type.equals("radio")) {
            format = new RadioField();
        } else if (type.equals(controlCheckboxName)) {
            format = new CheckboxField();
        } else if (type.equals(controlComboboxName)) {
            format = new ComboboxField();
        } else if (type.equals("comboboxhot")) {
            format = new ComboboxHotField();
        } else if (type.equals("comboboxfill")) {
            format = new ComboboxFillField();
        } else if (type.equals("comboboxfillhot")) {
            format = new ComboboxFillHotField();
        } else if (type.equals("comboboxfillhot")) {
            format = new ComboboxFillHotField();
        } else if (type.equals(controlInfoName)) {
            format = new InfoField();
        } else if (type.equals("infoask")) {
            format = new InfoAskField();
        } else if (type.equals("slider")) {
            format = new SliderField();
        } else if (type.equals("indicator")) {
            format = new IndicatorField();
        } else if (type.equals("indicatornum")) {
            format = new IndicatorNumericField();
        } else if (type.equals("updater")) {
            format = new UpdaterField();
        } else if (type.equals("color")) {
            format = new ColorField();
        } else if (type.equals("selector")) {
            format = new SelectorField();
        } else if (type.equals("multi")) {
            format = new MultiField();
        } else if (type.equals("separator")) {
            format = new SeparatorField();
        } else if (type.equals("set")) {
            format = new SetField();
        } else {
            System.out.println("Could not find " + type);
            return null;
        }
        format.name = name;
        String string = format.page = page == null ? "" : page;
        if (format.read != null) {
            System.out.println("Already initialized");
        }
        ArrayList<String> paramsList = new ArrayList<String>();
        String[] stringArray = params.split("[\n]");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String ss = s = s.trim();
            boolean tagFound = false;
            if (ss.length() > 0 && ss.charAt(0) == ':' && ss.matches(":[a-zA-Z0-9]+:.*")) {
                int i = ss.indexOf(58, 1);
                int j = ss.indexOf(32);
                if (i > 0 && (j > i || j < 0)) {
                    tagFound = true;
                    String tag = ss.substring(0, i + 1);
                    String par = ss.substring(i + 1).trim();
                    if ((tag = SetupFormats.validTag(tag)) != null) {
                        format.tags.put(tag, par);
                    } else {
                        System.out.println("Device: " + name);
                        System.out.println("WARNING unknown tag on line: " + ss);
                    }
                }
            }
            if (!tagFound) {
                paramsList.add(s);
            }
            ++n2;
        }
        format.parseParamsList(paramsList);
        return format;
    }

    private static List<CheckboxField> allCheckboxWithName(List<SetupFormats> list, String name, String page) {
        ArrayList<CheckboxField> sameName = new ArrayList<CheckboxField>();
        for (SetupFormats f : list) {
            if (!(f instanceof CheckboxField) || !f.getName().equals(name) || !f.getPage().equals(page)) continue;
            sameName.add((CheckboxField)f);
        }
        return sameName;
    }

    private static List<InfoField> allInfoWithName(List<SetupFormats> list, String name, String page) {
        ArrayList<InfoField> sameName = new ArrayList<InfoField>();
        for (SetupFormats f : list) {
            if (!(f instanceof InfoField) || !f.getName().equals(name) || !f.getPage().equals(page)) continue;
            sameName.add((InfoField)f);
        }
        return sameName;
    }

    private static List<IndicatorField> allIndicatorWithName(List<SetupFormats> list, String name, String page) {
        ArrayList<IndicatorField> sameName = new ArrayList<IndicatorField>();
        for (SetupFormats f : list) {
            if (!(f instanceof IndicatorField) || !f.getName().equals(name) || !f.getPage().equals(page)) continue;
            sameName.add((IndicatorField)f);
        }
        return sameName;
    }

    /*
     * WARNING - void declaration
     */
    public static void optimizeFormList(List<SetupFormats> list) {
        boolean bl;
        void var4_11;
        int i = 0;
        while (i < list.size()) {
            List<CheckboxField> sameNameC;
            if (list.get(i) instanceof CheckboxField && (sameNameC = SetupFormats.allCheckboxWithName(list, list.get(i).getName(), list.get(i).getPage())).size() > 1) {
                CheckboxsField ff = new CheckboxsField(sameNameC);
                list.add(i, ff);
                for (SetupFormats setupFormats : sameNameC) {
                    if (ff.deviceInterface == null) {
                        ff.deviceInterface = setupFormats.deviceInterface;
                    }
                    list.remove(setupFormats);
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < list.size()) {
            List<InfoField> sameNameI;
            if (list.get(i2) instanceof InfoField && (sameNameI = SetupFormats.allInfoWithName(list, list.get(i2).getName(), list.get(i2).getPage())).size() > 1) {
                InfosField infosField = new InfosField(sameNameI);
                list.add(i2, infosField);
                for (SetupFormats setupFormats : sameNameI) {
                    if (infosField.deviceInterface == null) {
                        infosField.deviceInterface = setupFormats.deviceInterface;
                    }
                    list.remove(setupFormats);
                }
            }
            ++i2;
        }
        boolean bl2 = false;
        while (var4_11 < list.size()) {
            List<IndicatorField> sameNameIn;
            if (list.get((int)var4_11) instanceof IndicatorField && (sameNameIn = SetupFormats.allIndicatorWithName(list, list.get((int)var4_11).getName(), list.get((int)var4_11).getPage())).size() > 1) {
                IndicatorsField indicatorsField = new IndicatorsField(sameNameIn);
                list.add((int)var4_11, indicatorsField);
                for (SetupFormats setupFormats : sameNameIn) {
                    if (indicatorsField.deviceInterface == null) {
                        indicatorsField.deviceInterface = setupFormats.deviceInterface;
                    }
                    list.remove(setupFormats);
                }
            }
            ++var4_11;
        }
        HashSet<SetupFormats> hashSet = new HashSet<SetupFormats>();
        block6: do {
            bl = false;
            for (SetupFormats setupFormats : list) {
                if (!(setupFormats instanceof SelectorField) || ((SelectorField)setupFormats).controls != null) continue;
                SelectorField sl = (SelectorField)setupFormats;
                sl.controls = new HashMap<String, List<SetupFormats>>();
                for (String sel : sl.controlNames.keySet()) {
                    HashSet<String> names = new HashSet<String>();
                    names.addAll(Arrays.asList(((String)sl.controlNames.get(sel)).split("[;, ]+")));
                    ArrayList<SetupFormats> controls = new ArrayList<SetupFormats>();
                    int i4 = list.size() - 1;
                    while (i4 >= 0) {
                        if ((names.contains(list.get(i4).pname()) || names.contains(String.valueOf(list.get((int)i4).page) + ".")) && !list.get(i4).equals(sl)) {
                            controls.add(0, list.get(i4));
                            hashSet.add(list.get(i4));
                            if (sl.deviceInterface == null) {
                                sl.deviceInterface = list.get((int)i4).deviceInterface;
                            }
                        }
                        --i4;
                    }
                    if (controls.size() <= 0) continue;
                    sl.controls.put(sel, controls);
                }
                bl = true;
                continue block6;
            }
        } while (bl);
        for (SetupFormats setupFormats : hashSet) {
            list.remove(setupFormats);
        }
    }

    protected abstract void parseParamsList(List<String> var1);

    public static class ButtonField
    extends SetupFormats
    implements ActionListener {
        static final String typeName = "button";
        private String cmdValue = "";
        private JButton button = null;

        @Override
        public SetupFormats getClone(DeviceInterface di) {
            ButtonField nf = new ButtonField();
            nf.copyValues(this, di);
            return nf;
        }

        @Override
        protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
            super.copyValues(model, newDeviceInterface);
            this.cmdValue = ((ButtonField)model).cmdValue;
        }

        @Override
        public int getColumns() {
            return 2;
        }

        @Override
        protected void setEnable(boolean yes) {
            if (this.button != null) {
                this.button.setEnabled(yes);
            }
        }

        @Override
        public int addGridBag(PopupSetupSelection form, JPanel panel, int inRow, int maxColumns) {
            this.form = form;
            this.button = new FontAdjust.FontButton(this.name.replace('_', ' '));
            this.button.setActionCommand(this.cmdValue);
            this.button.addActionListener(this);
            this.button.setToolTipText(this.getTag(SetupFormats.itemTip));
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = inRow;
            c.gridwidth = maxColumns;
            c.fill = 2;
            c.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)this.button, c);
            return 1;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.write.write(e.getActionCommand());
            this.requestSync();
        }

        @Override
        protected void parseParamsList(List<String> paramsList) {
            if (paramsList.size() > 0) {
                this.cmdValue = paramsList.get(0);
            }
        }
    }

    public static class ButtonsField
    extends FieldWithLabelValue
    implements ActionListener {
        static final String typeName = "buttons";
        protected boolean wide = false;
        private List<JButton> list = null;

        @Override
        public SetupFormats getClone(DeviceInterface di) {
            ButtonsField nf = new ButtonsField();
            nf.copyValues(this, di);
            return nf;
        }

        @Override
        protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
            super.copyValues(model, newDeviceInterface);
        }

        @Override
        public int getColumns() {
            return this.labelValues.size() + 1;
        }

        @Override
        protected void setEnable(boolean yes) {
            if (this.list != null) {
                for (JButton b : this.list) {
                    b.setEnabled(yes);
                }
            }
        }

        @Override
        public int addGridBag(PopupSetupSelection form, JPanel panel, int inRow, int maxColumns) {
            this.form = form;
            this.wide = this.labelValues.size() <= (maxColumns - 1) / 2;
            FontAdjust.FontLabel label = new FontAdjust.FontLabel(String.valueOf(this.name.replace('_', ' ')) + ":");
            label.setToolTipText(this.getTag(SetupFormats.itemTip));
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = inRow;
            c.anchor = 21;
            c.insets = new Insets(2, 2, 2, 2);
            c.weighty = 1.0;
            panel.add((Component)label, c);
            this.list = new ArrayList<JButton>(this.labelValues.size());
            int i = 0;
            while (i < this.labelValues.size()) {
                LabelValue lv = (LabelValue)this.labelValues.get(i);
                FontAdjust.FontButton button = new FontAdjust.FontButton(lv.label.replace('_', ' '));
                this.list.add(button);
                button.setActionCommand(lv.value);
                button.addActionListener(this);
                button.setToolTipText(this.getTag(SetupFormats.itemTip));
                c = new GridBagConstraints();
                c.gridx = 1 + i;
                c.gridy = inRow;
                if (this.labelValues.size() == 1) {
                    c.gridwidth = maxColumns - 1;
                } else if (this.wide) {
                    c.gridwidth = 2;
                    c.gridx = 1 + i * 2;
                } else {
                    c.gridwidth = 1;
                }
                c.fill = 2;
                c.insets = new Insets(2, 2, 2, 2);
                panel.add((Component)button, c);
                ++i;
            }
            return 1;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.write.write(e.getActionCommand());
            this.requestSync();
        }
    }

    public static class ButtonsOnField
    extends ButtonsField {
        static final String typeName = "buttonson";
        protected Indicator indicator = null;

        @Override
        public SetupFormats getClone(DeviceInterface di) {
            ButtonsOnField nf = new ButtonsOnField();
            nf.copyValues(this, di);
            return nf;
        }

        @Override
        protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
            super.copyValues(model, newDeviceInterface);
        }

        @Override
        public int addGridBag(PopupSetupSelection form, JPanel panel, int inRow, int maxColumns) {
            super.addGridBag(form, panel, inRow, maxColumns - 1);
            if (this.read.isValid() && this.labelValues.size() + 1 < maxColumns) {
                this.indicator = new Indicator();
                this.indicator.setColor(this.getTagColor(SetupFormats.itemColor, Color.red));
                this.setBGColor(this.indicator);
                GridBagConstraints c = new GridBagConstraints();
                c.gridx = maxColumns - 1;
                c.gridy = inRow;
                panel.add((Component)this.indicator, c);
            }
            return 1;
        }

        @Override
        public int getColumns() {
            return this.labelValues.size() + 2;
        }

        @Override
        protected void setStateVar(Script script) {
            this.setScriptValue(script, this.name, this.currentValue);
        }

        private void syncValueNumber() {
            double v;
            if (this.indicator != null && this.read.isValid() && !Double.isNaN(v = this.read.readNumber())) {
                LabelValue lv = (LabelValue)this.labelValues.get(1);
                double vv = StringUtil.parseDoubleEE(lv.value);
                boolean state = Math.abs(v - vv) < vv * 0.01;
                this.currentValue = state;
                this.indicator.setOn(state);
            }
        }

        private void syncValueString() {
            if (this.indicator != null && this.read.isValid()) {
                String v = this.read.writeRead();
                LabelValue lv = (LabelValue)this.labelValues.get(1);
                StringUtil.parseDoubleEE(lv.value);
                boolean state = lv.value.equals(v);
                this.currentValue = state;
                this.indicator.setOn(state);
            }
        }

        @Override
        public void syncValue() {
            if (this.isTagPresent(SetupFormats.itemStringResult)) {
                this.syncValueString();
            } else {
                this.syncValueNumber();
            }
        }
    }

    public static class CheckboxField
    extends FieldWithLabelDualValue
    implements ActionListener {
        static final String typeName = "checkbox";
        private JCheckBox checkBox = null;
        private JLabel label = null;

        @Override
        public SetupFormats getClone(DeviceInterface di) {
            CheckboxField nf = new CheckboxField();
            nf.copyValues(this, di);
            return nf;
        }

        @Override
        protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
            super.copyValues(model, newDeviceInterface);
        }

        @Override
        public int getColumns() {
            return 2;
        }

        protected JCheckBox getCheckBox() {
            this.checkBox = new FontAdjust.FontCheckBox(((LabelDualValue)this.labelValues.get((int)0)).label.replace('_', ' '));
            this.checkBox.addActionListener(this);
            this.checkBox.setToolTipText(this.getTag(SetupFormats.itemTip));
            this.currentValue = ((LabelDualValue)this.labelValues.get((int)0)).value1;
            return this.checkBox;
        }

        @Override
        public int addGridBag(PopupSetupSelection form, JPanel panel, int inRow, int maxColumns) {
            this.form = form;
            this.label = new FontAdjust.FontLabel(String.valueOf(this.name.replace('_', ' ')) + ":");
            this.label.setToolTipText(this.getTag(SetupFormats.itemTip));
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = inRow;
            c.anchor = 21;
            c.insets = new Insets(2, 2, 2, 2);
            c.weighty = 1.0;
            panel.add((Component)this.label, c);
            this.checkBox = this.getCheckBox();
            this.setBGColor(this.checkBox);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = inRow;
            c.gridwidth = 1;
            c.fill = 2;
            c.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)this.checkBox, c);
            return 1;
        }

        @Override
        protected void setStateVar(Script script) {
            this.setScriptValue(script, String.valueOf(this.name) + "." + ((LabelDualValue)this.labelValues.get((int)0)).label, this.currentValue);
        }

        @Override
        protected void setEnable(boolean yes) {
            this.checkBox.setEnabled(yes);
        }

        @Override
        protected void setVisible(boolean yes) {
            this.checkBox.setVisible(yes);
            if (this.label != null) {
                this.label.setVisible(yes);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd;
            String string = cmd = this.checkBox.isSelected() ? ((LabelDualValue)this.labelValues.get((int)0)).value2 : ((LabelDualValue)this.labelValues.get((int)0)).value1;
            if (cmd.length() > 0) {
                this.currentValue = cmd;
                this.write.write(cmd);
                this.requestSync();
            }
        }

        private void syncValueNumber() {
            if (this.read.isValid()) {
                double v = this.read.readNumber();
                double on = StringUtil.parseDoubleEE(((LabelDualValue)this.labelValues.get((int)0)).value2);
                boolean state = !Double.isNaN(v) && Math.abs(v - on) < on * 0.01;
                this.currentValue = state;
                if (this.checkBox.isSelected() != state) {
                    this.checkBox.setSelected(state);
                }
            }
        }

        private void syncValueString() {
            if (this.read.isValid()) {
                String v = this.read.writeRead();
                boolean state = v.equals(((LabelDualValue)this.labelValues.get((int)0)).value2);
                this.currentValue = state;
                if (this.checkBox.isSelected() != state) {
                    this.checkBox.setSelected(state);
                }
            }
        }

        @Override
        public void syncValue() {
            if (this.isTagPresent(SetupFormats.itemStringResult)) {
                this.syncValueString();
            } else {
                this.syncValueNumber();
            }
        }

        @Override
        public void syncValue(String name) {
            if (name.equals(this.name) || name.equals(((LabelDualValue)this.labelValues.get((int)0)).label)) {
                this.syncValue();
            }
        }
    }

    public static class CheckboxsField
    extends SetupFormats {
        private List<CheckboxField> checkBoxList = new ArrayList<CheckboxField>();
        private JLabel label = null;

        @Override
        public SetupFormats getClone(DeviceInterface di) {
            CheckboxsField nf = new CheckboxsField(this.checkBoxList);
            nf.copyValues(this, di);
            return nf;
        }

        @Override
        protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
            super.copyValues(model, newDeviceInterface);
        }

        CheckboxsField(List<CheckboxField> cbList) {
            this.name = cbList.get(0).getName();
            this.page = cbList.get(0).getPage();
            this.checkBoxList = cbList;
        }

        @Override
        public int getColumns() {
            return 1 + this.checkBoxList.size();
        }

        @Override
        public int addGridBag(PopupSetupSelection form, JPanel panel, int inRow, int maxColumns) {
            this.form = form;
            boolean wide = maxColumns > this.checkBoxList.size() * 2 + 1;
            this.label = new FontAdjust.FontLabel(String.valueOf(this.name.replace('_', ' ')) + ":");
            this.label.setToolTipText(this.getTag(SetupFormats.itemTip));
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = inRow;
            c.anchor = 21;
            c.insets = new Insets(2, 2, 2, 2);
            c.weighty = 1.0;
            panel.add((Component)this.label, c);
            int i = 0;
            while (i < this.checkBoxList.size()) {
                CheckboxField f = this.checkBoxList.get(i);
                f.form = form;
                JCheckBox cb = f.getCheckBox();
                this.setBGColor(cb);
                c.gridx = 1 + (wide ? 2 : 1) * i;
                c.gridy = inRow;
                c.insets = new Insets(2, 2, 2, 2);
                panel.add((Component)cb, c);
                ++i;
            }
            return 1;
        }

        @Override
        protected void calcEnable(Script script) {
            int i = 0;
            while (i < this.checkBoxList.size()) {
                this.checkBoxList.get(i).calcEnable(script);
                ++i;
            }
        }

        @Override
        protected void calcVisible(Script script) {
            int i = 0;
            while (i < this.checkBoxList.size()) {
                this.checkBoxList.get(i).calcVisible(script);
                ++i;
            }
        }

        @Override
        protected void setStateVar(Script script) {
            int i = 0;
            while (i < this.checkBoxList.size()) {
                this.checkBoxList.get(i).setStateVar(script);
                ++i;
            }
        }

        @Override
        protected void setEnable(boolean yes) {
            int i = 0;
            while (i < this.checkBoxList.size()) {
                this.checkBoxList.get(i).setEnable(yes);
                ++i;
            }
        }

        @Override
        protected void setVisible(boolean yes) {
            int i = 0;
            while (i < this.checkBoxList.size()) {
                this.checkBoxList.get(i).setVisible(yes);
                ++i;
            }
            if (this.label != null) {
                this.label.setVisible(yes);
            }
        }

        @Override
        protected void parseParamsList(List<String> paramsList) {
        }

        @Override
        public void syncValue() {
            for (CheckboxField cb : this.checkBoxList) {
                cb.syncValue();
            }
        }

        @Override
        public void syncValue(String name) {
            for (CheckboxField cb : this.checkBoxList) {
                cb.syncValue(name);
            }
        }

        @Override
        protected boolean hasTag(String tag) {
            for (CheckboxField cb : this.checkBoxList) {
                if (!cb.hasTag(tag)) continue;
                return true;
            }
            return false;
        }
    }

    public static class ColorField
    extends SetupFormats {
        static final String typeName = "color";
        public Color color = null;

        @Override
        public SetupFormats getClone(DeviceInterface di) {
            ColorField nf = new ColorField();
            nf.color = this.color;
            nf.copyValues(this, di);
            return nf;
        }

        @Override
        protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
            super.copyValues(model, newDeviceInterface);
        }

        @Override
        public int getColumns() {
            return 0;
        }

        @Override
        public int addGridBag(PopupSetupSelection form, JPanel panel, int inRow, int maxColumns) {
            this.form = form;
            return 0;
        }

        @Override
        protected void parseParamsList(List<String> paramsList) {
            this.color = ColorUtil.nameToColor(paramsList.get(0).trim());
        }

        public Color getColor() {
            return this.color;
        }

        public Color getBGColor() {
            return this.getTagColor(SetupFormats.itemBGColor, null);
        }
    }

    private static class ComboBoxDisplayer {
        LabelValue v;

        ComboBoxDisplayer(LabelValue v) {
            this.v = v;
        }

        public String toString() {
            return this.v.label.replace('_', ' ');
        }
    }

    public static class ComboboxField
    extends FieldWithLabelValue
    implements ActionListener {
        static final String typeName = "combobox";
        private JComboBox<ComboBoxDisplayer> combobox = null;
        private JButton setButton = null;
        private JLabel label = null;

        @Override
        public SetupFormats getClone(DeviceInterface di) {
            ComboboxField nf = new ComboboxField();
            nf.copyValues(this, di);
            return nf;
        }

        @Override
        protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
            super.copyValues(model, newDeviceInterface);
        }

        @Override
        public int getColumns() {
            return 3;
        }

        protected JComboBox<ComboBoxDisplayer> getComboBox() {
            this.combobox = new FontAdjust.FontComboBox<ComboBoxDisplayer>();
            this.combobox.setMaximumRowCount(20);
            for (LabelValue v : this.labelValues) {
                this.combobox.addItem(new ComboBoxDisplayer(v));
            }
            this.combobox.setToolTipText(this.getTag(SetupFormats.itemTip));
            return this.combobox;
        }

        @Override
        public int addGridBag(PopupSetupSelection form, JPanel panel, int inRow, int maxColumns) {
            this.form = form;
            this.label = new FontAdjust.FontLabel(String.valueOf(this.name.replace('_', ' ')) + ":");
            this.label.setToolTipText(this.getTag(SetupFormats.itemTip));
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = inRow;
            c.anchor = 21;
            c.insets = new Insets(2, 2, 2, 2);
            c.weighty = 1.0;
            panel.add((Component)this.label, c);
            this.combobox = this.getComboBox();
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = inRow;
            c.gridwidth = maxColumns > 3 ? 2 : 1;
            c.fill = 2;
            c.insets = new Insets(2, 2, 2, 2);
            panel.add(this.combobox, c);
            this.setButton = new FontAdjust.FontButton(this.getTag(SetupFormats.itemButtonText, "Set"));
            this.setButton.setToolTipText(this.getTag(SetupFormats.itemTip));
            this.setButton.addActionListener(this);
            this.setButton.setBackground(this.getTagColor(SetupFormats.itemColor, this.setButton.getBackground()));
            c = new GridBagConstraints();
            c.gridx = maxColumns - 1;
            c.gridy = inRow;
            c.fill = 2;
            c.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)this.setButton, c);
            return 1;
        }

        @Override
        protected boolean isEnabled() {
            return this.combobox == null ? false : this.combobox.isEnabled();
        }

        @Override
        protected boolean isVisible() {
            return this.combobox == null ? false : this.combobox.isVisible();
        }

        @Override
        public boolean collectEnable() {
            if (this.setButton != null) {
                this.write.enableCollect(true);
                this.setButton.setText("");
                this.setButton.setEnabled(false);
                this.setButton.setIcon(IconGenerator.makeIcon(IconGenerator.IconType.X));
                return true;
            }
            return false;
        }

        @Override
        public String collectWrite() {
            this.write.clearCollect();
            this.localWrite();
            return this.write.getCollected();
        }

        @Override
        protected void setEnable(boolean yes) {
            this.combobox.setEnabled(yes);
            this.setButton.setEnabled(yes);
        }

        @Override
        protected void setVisible(boolean yes) {
            this.combobox.setVisible(yes);
            this.setButton.setVisible(yes);
            this.label.setVisible(yes);
        }

        private void localWrite() {
            String cmd = ((ComboBoxDisplayer)this.combobox.getSelectedItem()).v.value;
            if (cmd.length() > 0) {
                this.currentValue = cmd;
                this.write.write(cmd);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.localWrite();
            this.requestSync();
        }

        @Override
        protected void setStateVar(Script script) {
            this.setScriptValue(script, this.name, this.currentValue);
        }

        @Override
        public void syncValue() {
            if (this.read.isValid()) {
                String v = this.read.writeRead();
                boolean found = false;
                int i = 0;
                while (i < this.combobox.getItemCount()) {
                    ComboBoxDisplayer vv = this.combobox.getItemAt(i);
                    if (vv.v.value.replace('_', ' ').equalsIgnoreCase(v.replace('_', ' '))) {
                        this.currentValue = vv.v.value;
                        this.combobox.setSelectedItem(vv);
                        found = true;
                    }
                    ++i;
                }
                if (!found) {
                    this.currentValue = ((LabelValue)this.labelValues.get((int)0)).value;
                    this.combobox.setSelectedIndex(0);
                }
            }
        }

        @Override
        public void syncValue(String name) {
            if (name.equals(this.name) || name.equals(((LabelValue)this.labelValues.get((int)0)).label)) {
                this.syncValue();
            }
        }
    }

    public static class ComboboxFillField
    extends SetupFormats
    implements ActionListener {
        static final String typeName = "comboboxfill";
        private JComboBox<String> combobox = null;
        private JButton setButton = null;
        private JLabel label = null;
        private String askCommand = "";
        private boolean updating = true;

        @Override
        public SetupFormats getClone(DeviceInterface di) {
            ComboboxFillField nf = new ComboboxFillField();
            nf.copyValues(this, di);
            return nf;
        }

        @Override
        protected void parseParamsList(List<String> paramsList) {
            StringBuilder sb = new StringBuilder();
            for (String s : paramsList) {
                if (sb.length() > 0) {
                    sb.append(";");
                }
                sb.append(s);
            }
            this.askCommand = sb.toString();
        }

        @Override
        protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
            super.copyValues(model, newDeviceInterface);
            this.askCommand = ((ComboboxFillField)model).askCommand;
        }

        @Override
        public int getColumns() {
            return 3;
        }

        protected void updateContents() {
            this.combobox.removeAllItems();
            String line = this.write.writeReadDirect(this.askCommand);
            ArrayList<String> items = new ArrayList<String>();
            if (line.contains("\"")) {
                int i = 0;
                int j = 0;
                while ((i = line.indexOf("\"", i)) >= 0 && (j = line.indexOf("\"", i + 1)) > 0) {
                    items.add(line.substring(i + 1, j));
                    i = j + 1;
                }
            } else {
                String[] stringArray = line.split("[,; ]+");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    items.add(s);
                    ++n2;
                }
            }
            for (String s : items) {
                this.combobox.addItem(s);
            }
        }

        protected JComboBox<String> getComboBox() {
            this.combobox = new FontAdjust.FontComboBox<String>();
            this.combobox.setMaximumRowCount(20);
            this.updateContents();
            this.combobox.setToolTipText(this.getTag(SetupFormats.itemTip));
            return this.combobox;
        }

        @Override
        public int addGridBag(PopupSetupSelection form, JPanel panel, int inRow, int maxColumns) {
            this.updating = true;
            this.form = form;
            this.label = new FontAdjust.FontLabel(String.valueOf(this.name.replace('_', ' ')) + ":");
            this.label.setToolTipText(this.getTag(SetupFormats.itemTip));
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = inRow;
            c.anchor = 21;
            c.insets = new Insets(2, 2, 2, 2);
            c.weighty = 1.0;
            panel.add((Component)this.label, c);
            this.combobox = this.getComboBox();
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = inRow;
            c.gridwidth = maxColumns > 3 ? maxColumns - 2 : 1;
            c.fill = 2;
            c.insets = new Insets(2, 2, 2, 2);
            panel.add(this.combobox, c);
            this.setButton = new FontAdjust.FontButton(this.getTag(SetupFormats.itemButtonText, "Set"));
            this.setButton.setToolTipText(this.getTag(SetupFormats.itemTip));
            this.setButton.addActionListener(this);
            this.setButton.setBackground(this.getTagColor(SetupFormats.itemColor, this.setButton.getBackground()));
            c = new GridBagConstraints();
            c.gridx = maxColumns - 1;
            c.gridy = inRow;
            c.fill = 2;
            c.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)this.setButton, c);
            this.updating = false;
            return 1;
        }

        @Override
        protected void setEnable(boolean yes) {
            this.combobox.setEnabled(yes);
            this.setButton.setEnabled(yes);
        }

        @Override
        protected void setVisible(boolean yes) {
            this.combobox.setVisible(yes);
            this.setButton.setVisible(yes);
            this.label.setVisible(yes);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = (String)this.combobox.getSelectedItem();
            if (cmd.length() > 0) {
                this.currentValue = cmd;
                this.write.write(cmd);
                this.requestSync();
            }
        }

        @Override
        protected void setStateVar(Script script) {
            this.setScriptValue(script, this.name, this.currentValue);
        }

        @Override
        public void syncValue() {
            if (this.read.isValid()) {
                this.updating = true;
                String v = this.read.writeRead();
                boolean found = false;
                int i = 0;
                while (i < this.combobox.getItemCount()) {
                    if (v.equals(this.combobox.getItemAt(i))) {
                        this.currentValue = v;
                        this.combobox.setSelectedItem(v);
                        found = true;
                    }
                    ++i;
                }
                if (!found) {
                    this.combobox.setSelectedIndex(0);
                    this.currentValue = this.combobox.getSelectedItem();
                }
                this.updating = false;
            }
        }

        @Override
        public void syncValue(String name) {
            if (name.equals(this.name)) {
                this.syncValue();
            }
        }
    }

    public static class ComboboxFillHotField
    extends FieldWithLabelValue
    implements ActionListener {
        static final String typeName = "comboboxfillhot";
        private JComboBox<String> combobox = null;
        private JLabel label = null;
        private String askCommand = "";
        private boolean updating = true;

        @Override
        public SetupFormats getClone(DeviceInterface di) {
            ComboboxFillHotField nf = new ComboboxFillHotField();
            nf.copyValues(this, di);
            return nf;
        }

        @Override
        protected void parseParamsList(List<String> paramsList) {
            StringBuilder sb = new StringBuilder();
            for (String s : paramsList) {
                if (sb.length() > 0) {
                    sb.append(";");
                }
                sb.append(s);
            }
            this.askCommand = sb.toString();
        }

        @Override
        protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
            super.copyValues(model, newDeviceInterface);
            this.askCommand = ((ComboboxFillHotField)model).askCommand;
        }

        @Override
        public int getColumns() {
            return 2;
        }

        protected void updateContents() {
            this.combobox.removeAllItems();
            String line = this.write.writeReadDirect(this.askCommand);
            ArrayList<String> items = new ArrayList<String>();
            if (line.contains("\"")) {
                int i = 0;
                int j = 0;
                while ((i = line.indexOf("\"", i)) >= 0 && (j = line.indexOf("\"", i + 1)) > 0) {
                    items.add(line.substring(i + 1, j));
                    i = j + 1;
                }
            } else {
                String[] stringArray = line.split("[,; ]+");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    items.add(s);
                    ++n2;
                }
            }
            for (String s : items) {
                this.combobox.addItem(s);
            }
        }

        protected JComboBox<String> getComboBox() {
            this.combobox = new FontAdjust.FontComboBox<String>();
            this.combobox.setMaximumRowCount(20);
            this.updateContents();
            this.combobox.setToolTipText(this.getTag(SetupFormats.itemTip));
            this.combobox.addActionListener(this);
            return this.combobox;
        }

        @Override
        public int addGridBag(PopupSetupSelection form, JPanel panel, int inRow, int maxColumns) {
            this.updating = true;
            try {
                this.form = form;
                this.label = new FontAdjust.FontLabel(String.valueOf(this.name.replace('_', ' ')) + ":");
                this.label.setToolTipText(this.getTag(SetupFormats.itemTip));
                GridBagConstraints c = new GridBagConstraints();
                c.gridx = 0;
                c.gridy = inRow;
                c.anchor = 21;
                c.insets = new Insets(2, 2, 2, 2);
                c.weighty = 1.0;
                panel.add((Component)this.label, c);
                this.combobox = this.getComboBox();
                c = new GridBagConstraints();
                c.gridx = 1;
                c.gridy = inRow;
                c.gridwidth = maxColumns > 2 ? maxColumns - 1 : 1;
                c.fill = 2;
                c.insets = new Insets(2, 2, 2, 2);
                panel.add(this.combobox, c);
            }
            finally {
                this.updating = false;
            }
            return 1;
        }

        @Override
        protected void setEnable(boolean yes) {
            this.combobox.setEnabled(yes);
        }

        @Override
        protected void setVisible(boolean yes) {
            this.combobox.setVisible(yes);
            this.label.setVisible(yes);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.updating) {
                return;
            }
            String cmd = (String)this.combobox.getSelectedItem();
            if (cmd.length() > 0 && !this.updating) {
                this.currentValue = cmd;
                this.write.write(cmd);
                this.requestSync();
            }
        }

        @Override
        protected void setStateVar(Script script) {
            this.setScriptValue(script, this.name, this.currentValue);
        }

        @Override
        public void syncValue() {
            if (this.read.isValid()) {
                this.updating = true;
                this.updateContents();
                try {
                    String v = this.read.writeRead();
                    boolean found = false;
                    int i = 0;
                    while (i < this.combobox.getItemCount()) {
                        if (v.equals(this.combobox.getItemAt(i))) {
                            this.currentValue = v;
                            this.combobox.setSelectedItem(v);
                            found = true;
                        }
                        ++i;
                    }
                    if (!found) {
                        this.combobox.setSelectedIndex(0);
                        this.currentValue = this.combobox.getSelectedItem();
                    }
                }
                finally {
                    this.updating = false;
                }
            }
        }

        @Override
        public void syncValue(String name) {
            if (name.equals(this.name)) {
                this.syncValue();
            }
        }
    }

    public static class ComboboxHotField
    extends FieldWithLabelValue
    implements ActionListener {
        static final String typeName = "comboboxhot";
        private JComboBox<ComboBoxDisplayer> combobox = null;
        private JLabel label = null;

        @Override
        public SetupFormats getClone(DeviceInterface di) {
            ComboboxHotField nf = new ComboboxHotField();
            nf.copyValues(this, di);
            return nf;
        }

        @Override
        protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
            super.copyValues(model, newDeviceInterface);
        }

        @Override
        public int getColumns() {
            return 2;
        }

        protected JComboBox<ComboBoxDisplayer> getComboBox() {
            this.combobox = new FontAdjust.FontComboBox<ComboBoxDisplayer>();
            this.combobox.setMaximumRowCount(20);
            for (LabelValue v : this.labelValues) {
                this.combobox.addItem(new ComboBoxDisplayer(v));
            }
            this.combobox.addActionListener(this);
            this.combobox.setToolTipText(this.getTag(SetupFormats.itemTip));
            return this.combobox;
        }

        @Override
        public int addGridBag(PopupSetupSelection form, JPanel panel, int inRow, int maxColumns) {
            this.form = form;
            this.label = new FontAdjust.FontLabel(String.valueOf(this.name.replace('_', ' ')) + ":");
            this.label.setToolTipText(this.getTag(SetupFormats.itemTip));
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = inRow;
            c.anchor = 21;
            c.insets = new Insets(2, 2, 2, 2);
            c.weighty = 1.0;
            panel.add((Component)this.label, c);
            this.combobox = this.getComboBox();
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = inRow;
            c.gridwidth = maxColumns - 1;
            c.fill = 2;
            c.insets = new Insets(2, 2, 2, 2);
            panel.add(this.combobox, c);
            return 1;
        }

        @Override
        protected void setEnable(boolean yes) {
            this.combobox.setEnabled(yes);
        }

        @Override
        protected void setVisible(boolean yes) {
            this.combobox.setVisible(yes);
            this.label.setVisible(yes);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = ((ComboBoxDisplayer)this.combobox.getSelectedItem()).v.value;
            if (cmd.length() > 0) {
                this.write.write(cmd);
                this.requestSync();
            }
        }

        @Override
        protected void setStateVar(Script script) {
            this.setScriptValue(script, this.name, this.currentValue);
        }

        @Override
        public void syncValue() {
            if (this.read.isValid()) {
                String v = this.read.writeRead();
                boolean found = false;
                int i = 0;
                while (i < this.combobox.getItemCount()) {
                    ComboBoxDisplayer vv = this.combobox.getItemAt(i);
                    if (vv.v.value.replace('_', ' ').equalsIgnoreCase(v.replace('_', ' '))) {
                        this.currentValue = vv.v.value;
                        this.combobox.removeActionListener(this);
                        this.combobox.setSelectedItem(vv);
                        this.combobox.addActionListener(this);
                        found = true;
                    }
                    ++i;
                }
                if (!found) {
                    this.currentValue = ((LabelValue)this.labelValues.get((int)0)).value;
                    this.combobox.removeActionListener(this);
                    this.combobox.setSelectedIndex(0);
                    this.combobox.addActionListener(this);
                }
            }
        }

        @Override
        public void syncValue(String name) {
            if (name.equals(this.name) || name.equals(((LabelValue)this.labelValues.get((int)0)).label)) {
                this.syncValue();
            }
        }
    }

    static abstract class ControlInfo
    implements ActionListener {
        protected String lastValue;
        protected SetupFormats sf;
        protected int index = 0;

        ControlInfo() {
        }

        public static ControlInfo getControl(SetupFormats sf, int n, String info) {
            int i = info.indexOf(32);
            if (i < 0) {
                i = info.length();
            }
            String name = info.substring(0, i);
            info = info.substring(i).trim();
            if (name.equalsIgnoreCase(SetupFormats.controlInfoName)) {
                return new ControlInfoInfo(sf, n, info);
            }
            if (name.equalsIgnoreCase(SetupFormats.controlNumberName)) {
                return new ControlInfoNumber(sf, n, info);
            }
            if (name.equalsIgnoreCase(SetupFormats.controlNumberIntName)) {
                return new ControlInfoNumberInt(sf, n, info);
            }
            if (name.equalsIgnoreCase(SetupFormats.controlCheckboxName)) {
                return new ControlInfoCheckBox(sf, n, info);
            }
            if (name.equalsIgnoreCase(SetupFormats.controlComboboxName)) {
                return new ControlInfoComboBox(sf, n, info);
            }
            return null;
        }

        public abstract Component getComponent(String var1);

        public abstract String getValue();

        public abstract void setValue(double var1);

        public abstract void setValue(String var1);

        public abstract boolean validate();

        public abstract void setEnable(boolean var1);

        public abstract void setVisible(boolean var1);

        @Override
        public void actionPerformed(ActionEvent e) {
            this.validate();
        }
    }

    static class ControlInfoCheckBox
    extends ControlInfo {
        private String name;
        private String offValue = "0";
        private String onValue = "1";
        private boolean lastValue = false;
        private JCheckBox control;

        ControlInfoCheckBox(SetupFormats sf, int n, String params) {
            this.sf = sf;
            this.index = n;
            String[] s = params.split(" ");
            if (s.length >= 1) {
                this.name = s[0].replace("_", " ").trim();
            }
            if (s.length >= 2) {
                this.offValue = s[1];
            }
            if (s.length >= 3) {
                this.onValue = s[2];
            }
        }

        @Override
        public Component getComponent(String tip) {
            this.control = new FontAdjust.FontCheckBox(this.name);
            this.control.setToolTipText(tip);
            this.control.addActionListener(this);
            return this.control;
        }

        @Override
        public String getValue() {
            String s = this.offValue;
            if (this.control.isSelected()) {
                s = this.onValue;
            }
            if (s.endsWith(".0")) {
                s = s.substring(0, s.length() - 2);
            }
            this.lastValue = this.control.isSelected();
            return s;
        }

        @Override
        public void setValue(double value) {
            this.control.setSelected(value != StringUtil.parseDoubleEE(this.offValue));
            this.lastValue = this.control.isSelected();
            this.validate();
        }

        @Override
        public void setValue(String value) {
            this.control.setSelected(!value.equals(this.offValue));
            this.lastValue = this.control.isSelected();
            this.validate();
        }

        @Override
        public boolean validate() {
            this.control.setBackground(this.lastValue == this.control.isSelected() ? SystemColor.control : Support.colorScheme.changedBackground);
            return true;
        }

        @Override
        public void setEnable(boolean yes) {
            this.control.setEnabled(yes);
        }

        @Override
        public void setVisible(boolean yes) {
            this.control.setVisible(yes);
        }
    }

    static class ControlInfoComboBox
    extends ControlInfo {
        private List<String> values;
        private JComboBox<String> control;

        ControlInfoComboBox(SetupFormats sf, int n, String params) {
            this.sf = sf;
            this.index = n;
            String[] s = params.split(" ");
            this.values = new ArrayList<String>();
            int i = 0;
            while (i < s.length / 2) {
                this.values.add(String.valueOf(s[i * 2 + 0]) + "\n" + s[i * 2 + 1]);
                ++i;
            }
        }

        @Override
        public Component getComponent(String tip) {
            this.control = new FontAdjust.FontComboBox<String>();
            for (String val : this.values) {
                String[] s = val.split("\n");
                this.control.addItem(s[0]);
            }
            this.control.setToolTipText(tip);
            this.control.addActionListener(this);
            return this.control;
        }

        @Override
        public String getValue() {
            String val = this.values.get(this.control.getSelectedIndex());
            String[] s = val.split("\n");
            return s.length == 1 ? "0" : s[1];
        }

        @Override
        public void setValue(double value) {
            for (String val : this.values) {
                double v;
                String[] s = val.split("\n");
                double d = v = s.length == 1 ? 0.0 : StringUtil.parseDoubleEE(s[1]);
                if (!(Math.abs(value - v) < 1.0E-12)) continue;
                this.control.setSelectedItem(s[0]);
            }
            this.validate();
        }

        @Override
        public void setValue(String value) {
            for (String val : this.values) {
                String v;
                String[] s = val.split("\n");
                String string = v = s.length == 1 ? "0" : s[1];
                if (!v.equals(value)) continue;
                this.control.setSelectedItem(s[0]);
            }
            this.validate();
        }

        @Override
        public boolean validate() {
            return true;
        }

        @Override
        public void setEnable(boolean yes) {
            this.control.setEnabled(yes);
        }

        @Override
        public void setVisible(boolean yes) {
            this.control.setVisible(yes);
        }
    }

    static class ControlInfoInfo
    extends ControlInfo {
        private JLabel control;
        private String prefix = "";
        private String postfix = "";
        private String value = "";

        ControlInfoInfo(SetupFormats sf, int n, String params) {
            this.sf = sf;
            this.index = n;
            String[] s = params.split(" ");
            if (s.length >= 1) {
                this.prefix = s[0].replace("_", " ").trim();
            }
            if (s.length >= 2) {
                this.postfix = s[1].replace("_", " ").trim();
            }
        }

        @Override
        public Component getComponent(String tip) {
            this.control = new FontAdjust.FontLabel("");
            this.sf.adjustLabelFormat(this.control);
            this.control.setToolTipText(tip);
            return this.control;
        }

        @Override
        public String getValue() {
            String s = this.value;
            if (s.endsWith(".0")) {
                s = s.substring(0, s.length() - 2);
            }
            return s;
        }

        @Override
        public void setValue(double value) {
            this.value = this.sf.formatDouble(this.index, value);
            this.control.setText(String.valueOf(this.prefix.length() > 0 ? String.valueOf(this.prefix) + " " : "") + value + (this.postfix.length() > 0 ? " " + this.postfix : ""));
        }

        @Override
        public void setValue(String value) {
            this.value = value;
            this.control.setText(String.valueOf(this.prefix.length() > 0 ? String.valueOf(this.prefix) + " " : "") + value + (this.postfix.length() > 0 ? " " + this.postfix : ""));
        }

        @Override
        public boolean validate() {
            return true;
        }

        protected boolean isEnabled() {
            return this.control == null ? false : this.control.isEnabled();
        }

        protected boolean isVisible() {
            return this.control == null ? false : this.control.isVisible();
        }

        @Override
        public void setEnable(boolean yes) {
            this.control.setEnabled(yes);
        }

        @Override
        public void setVisible(boolean yes) {
            this.control.setVisible(yes);
        }
    }

    static class ControlInfoNumber
    extends ControlInfo
    implements FocusListener {
        protected String name = "?";
        protected String unit = "";
        protected double min = 0.0;
        protected double max = 0.0;
        protected double value;
        protected String lastValue;
        protected JPanel control;
        protected JLabel label;
        protected JTextField textField;

        ControlInfoNumber(SetupFormats sf, int n, String params) {
            this.sf = sf;
            this.index = n;
            String[] s = params.split(" ");
            if (s.length >= 1) {
                this.name = s[0].replace("_", " ").trim();
            }
            if (s.length >= 2) {
                this.unit = s[1].replace("_", " ").trim();
            }
            if (s.length >= 3) {
                this.min = StringUtil.parseDoubleEE(s[2]);
            }
            if (s.length >= 4) {
                this.max = StringUtil.parseDoubleEE(s[3]);
            }
        }

        @Override
        public Component getComponent(String tip) {
            this.control = new JPanel();
            this.control.setLayout(new FlowLayout(0, 0, 0));
            this.control.setToolTipText(tip);
            this.label = new FontAdjust.FontLabel(String.valueOf(this.name) + ":");
            this.label.setToolTipText(tip);
            this.control.add(this.label);
            this.control.add(Box.createHorizontalStrut(2));
            this.textField = new FontAdjust.FontTextField(this.sf.getTagInt(SetupFormats.itemTextWidth, 6, this.index - 1));
            this.textField.setToolTipText(String.valueOf(this.unit.length() > 0 ? String.valueOf(this.unit) + " " : "") + this.sf.formatDouble(this.index, this.min) + " - " + this.sf.formatDouble(this.index, this.max));
            this.textField.setMinimumSize(new Dimension(20, 20));
            this.textField.addActionListener(this);
            this.textField.addFocusListener(this);
            this.control.add(this.textField);
            return this.control;
        }

        @Override
        public String getValue() {
            this.validate();
            String s = Double.toString(this.value);
            if (s.endsWith(".0")) {
                s = s.substring(0, s.length() - 2);
            }
            this.lastValue = s;
            return s;
        }

        @Override
        public void setValue(double value) {
            this.value = value;
            this.textField.setText(this.sf.formatDouble(this.index, value));
            this.lastValue = this.textField.getText();
            this.validate();
        }

        @Override
        public void setValue(String value) {
            this.value = StringUtil.parseDoubleEE(value);
            this.textField.setText(this.sf.formatDouble(this.index, this.value));
            this.lastValue = this.textField.getText();
            this.validate();
        }

        @Override
        public boolean validate() {
            block3: {
                String s = this.textField.getText().trim().replace(",", ".");
                double v = 0.0;
                v = StringUtil.parseDoubleEE(s);
                if (!(v >= this.min) || !(v <= this.max)) break block3;
                this.textField.setBackground(s.equals(this.lastValue) ? Support.colorScheme.textBackground : Support.colorScheme.changedBackground);
                this.value = v;
                return true;
            }
            try {
                this.textField.setBackground(Support.colorScheme.errorBackground);
            }
            catch (Exception exception) {
                this.textField.setBackground(Support.colorScheme.errorBackground);
            }
            return false;
        }

        @Override
        public void focusGained(FocusEvent arg0) {
            this.textField.selectAll();
        }

        @Override
        public void focusLost(FocusEvent arg0) {
            this.validate();
        }

        @Override
        public void setEnable(boolean yes) {
            this.control.setEnabled(yes);
            this.textField.setEnabled(yes);
            this.label.setEnabled(yes);
        }

        @Override
        public void setVisible(boolean yes) {
            this.control.setVisible(yes);
            this.textField.setVisible(yes);
            this.label.setVisible(yes);
        }
    }

    static class ControlInfoNumberInt
    extends ControlInfoNumber {
        ControlInfoNumberInt(SetupFormats sf, int n, String params) {
            super(sf, n, params);
        }

        @Override
        public void setValue(double value) {
            this.value = value;
            this.textField.setText(Long.toString((long)value));
            this.lastValue = this.textField.getText();
            this.validate();
        }

        @Override
        public void setValue(String value) {
            this.value = StringUtil.parseDoubleEE(value);
            this.textField.setText(Long.toString((long)this.value));
            this.lastValue = this.textField.getText();
            this.validate();
        }

        @Override
        public boolean validate() {
            block3: {
                String s = this.textField.getText().trim().replace(",", ".");
                double v = 0.0;
                v = StringUtil.parseLong(s);
                if (!(v >= this.min) || !(v <= this.max) || s.contains(".")) break block3;
                this.textField.setBackground(s.equals(this.lastValue) ? Support.colorScheme.textBackground : Support.colorScheme.changedBackground);
                this.value = v;
                return true;
            }
            try {
                this.textField.setBackground(Support.colorScheme.errorBackground);
            }
            catch (Exception exception) {
                this.textField.setBackground(Support.colorScheme.errorBackground);
            }
            return false;
        }
    }

    public static abstract class FieldWithLabel
    extends SetupFormats {
        protected List<String> labels = new ArrayList<String>();

        @Override
        protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
            super.copyValues(model, newDeviceInterface);
            this.labels = ((FieldWithLabel)model).labels;
        }

        @Override
        protected void parseParamsList(List<String> paramsList) {
            for (String s : paramsList) {
                this.labels.add(s.trim());
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append(" ");
            for (String s : this.labels) {
                sb.append(" |");
                sb.append(s);
            }
            return sb.toString();
        }
    }

    public static abstract class FieldWithLabelDualValue
    extends SetupFormats {
        protected List<LabelDualValue> labelValues = new ArrayList<LabelDualValue>();

        @Override
        protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
            super.copyValues(model, newDeviceInterface);
            this.labelValues = ((FieldWithLabelDualValue)model).labelValues;
        }

        @Override
        protected void parseParamsList(List<String> paramsList) {
            for (String s : paramsList) {
                String[] ss = s.split("[ ]+");
                if (ss.length == 3) {
                    this.labelValues.add(new LabelDualValue(ss[0], ss[1], ss[2]));
                    continue;
                }
                if (s.length() <= 0) continue;
                System.out.println(String.valueOf(this.getClass().getName()) + " - " + this.name + " - Line do not contain 3 parameters: " + s);
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append(" ");
            for (LabelDualValue lv : this.labelValues) {
                sb.append(" |");
                sb.append(lv.label);
                sb.append(" ");
                sb.append(lv.value1);
                sb.append(" ");
                sb.append(lv.value2);
            }
            return sb.toString();
        }
    }

    public static abstract class FieldWithLabelTriplelValue
    extends SetupFormats {
        protected List<LabelTripleValue> labelValues = new ArrayList<LabelTripleValue>();

        @Override
        protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
            super.copyValues(model, newDeviceInterface);
            this.labelValues = ((FieldWithLabelTriplelValue)model).labelValues;
        }

        @Override
        protected void parseParamsList(List<String> paramsList) {
            for (String s : paramsList) {
                String[] ss = s.split("[ ]+");
                if (ss.length != 4) continue;
                this.labelValues.add(new LabelTripleValue(ss[0], ss[1], ss[2], ss[3]));
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append(" ");
            for (LabelTripleValue lv : this.labelValues) {
                sb.append(" |");
                sb.append(lv.label);
                sb.append(" ");
                sb.append(lv.value1);
                sb.append(" ");
                sb.append(lv.value2);
                sb.append(" ");
                sb.append(lv.value3);
            }
            return sb.toString();
        }
    }

    public static abstract class FieldWithLabelValue
    extends SetupFormats {
        protected List<LabelValue> labelValues = new ArrayList<LabelValue>();

        @Override
        protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
            super.copyValues(model, newDeviceInterface);
            this.labelValues = ((FieldWithLabelValue)model).labelValues;
        }

        @Override
        protected void parseParamsList(List<String> paramsList) {
            for (String s : paramsList) {
                String[] ss = s.split("[ ]+");
                if (ss.length == 2) {
                    this.labelValues.add(new LabelValue(ss[0], ss[1]));
                    continue;
                }
                if (s.length() <= 0) continue;
                System.out.println(String.valueOf(this.getClass().getName()) + " - " + this.name + " - Line do not contain 2 parameters: " + s);
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append(" ");
            for (LabelValue lv : this.labelValues) {
                sb.append(" |");
                sb.append(lv.label);
                sb.append(" ");
                sb.append(lv.value);
            }
            return sb.toString();
        }
    }

    public static class IndicatorField
    extends FieldWithLabelDualValue {
        static final String typeName = "indicator";
        protected Indicator indicator = null;
        protected boolean wide = false;
        protected JLabel label = null;
        protected String currentName = null;
        protected LabelDualValue current = null;

        @Override
        public SetupFormats getClone(DeviceInterface di) {
            IndicatorField nf = new IndicatorField();
            nf.copyValues(this, di);
            return nf;
        }

        @Override
        protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
            super.copyValues(model, newDeviceInterface);
        }

        IndicatorField() {
        }

        protected JLabel getLabel() {
            this.label = new FontAdjust.FontLabel(String.valueOf(((LabelDualValue)this.labelValues.get((int)0)).label.replace('_', ' ')) + ":");
            this.adjustLabelFormat(this.label);
            this.label.setToolTipText(this.getTag(SetupFormats.itemTip));
            return this.label;
        }

        protected Indicator getIndicator() {
            this.indicator = new Indicator();
            this.indicator.setIndicatorSize(this.wide ? 100 : 40, 20);
            this.indicator.setToolTipText(this.getTag(SetupFormats.itemTip));
            return this.indicator;
        }

        @Override
        public int getColumns() {
            return 3;
        }

        @Override
        public int addGridBag(PopupSetupSelection form, JPanel panel, int inRow, int maxColumns) {
            this.form = form;
            this.wide = maxColumns > 4;
            FontAdjust.FontLabel label1 = new FontAdjust.FontLabel(String.valueOf(this.name.replace('_', ' ')) + ":");
            label1.setToolTipText(this.getTag(SetupFormats.itemTip));
            int column = 0;
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = column++;
            c.gridy = inRow;
            c.anchor = 21;
            c.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)label1, c);
            this.label = this.getLabel();
            c = new GridBagConstraints();
            c.gridx = column++;
            c.gridy = inRow;
            c.insets = new Insets(2, 2, 2, 2);
            c.anchor = 13;
            panel.add((Component)this.label, c);
            Indicator indicator = this.getIndicator();
            this.setBGColor(indicator);
            c = new GridBagConstraints();
            c.gridx = column++;
            c.gridy = inRow;
            c.gridwidth = this.wide ? 2 : 1;
            c.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)indicator, c);
            return 1;
        }

        protected void setStatus(boolean on, LabelDualValue vv) {
            this.indicator.setOn(on);
            this.indicator.setColor(ColorUtil.nameToColor(vv.value2));
            this.label.setText(String.valueOf(vv.label.replace('_', ' ')) + ":");
            this.currentValue = vv.value1;
            this.currentName = vv.label;
        }

        @Override
        protected void setStateVar(Script script) {
            this.setScriptValue(script, String.valueOf(this.name) + ".on", this.indicator.isOn());
            this.setScriptValue(script, String.valueOf(this.name) + ".color", this.indicator.getColor());
            this.setScriptValue(script, String.valueOf(this.name) + ".name", this.currentName);
            this.setScriptValue(script, String.valueOf(this.name) + ".value", this.currentValue);
        }

        protected void setStateVarN(Script script, int n) {
            this.setScriptValue(script, String.valueOf(this.name) + n, this.currentValue);
        }

        @Override
        public void syncValue() {
            if (this.read.isValid()) {
                String v = this.read.writeRead();
                if (this.script == null) {
                    this.script = new Script();
                    this.script.addLocalVar("handle", Var.createValue(this.deviceInterface.getHandleName()));
                }
                this.script.addLocalVar(Var.createValue("value", v == null ? "" : v));
                boolean match = false;
                for (LabelDualValue vv : this.labelValues) {
                    if (!this.script.expression(vv.value1).asBoolean()) continue;
                    this.setStatus(true, vv);
                    match = true;
                    if (this.current == vv) continue;
                    this.current = vv;
                    if (!this.isTagPresent(SetupFormats.itemUpdate)) continue;
                    this.requestSync();
                }
                if (!match) {
                    this.setStatus(false, (LabelDualValue)this.labelValues.get(0));
                    if (this.current != null) {
                        this.current = null;
                        if (this.isTagPresent(SetupFormats.itemUpdate)) {
                            this.requestSync();
                        }
                    }
                }
            }
        }
    }

    public static class IndicatorNumericField
    extends IndicatorField {
        static final String typeName = "indicatornum";

        @Override
        public SetupFormats getClone(DeviceInterface di) {
            IndicatorNumericField nf = new IndicatorNumericField();
            nf.copyValues(this, di);
            return nf;
        }

        @Override
        protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
            super.copyValues(model, newDeviceInterface);
        }

        @Override
        public void syncValue() {
            if (this.read.isValid()) {
                double v = this.read.readNumber();
                boolean match = false;
                for (LabelDualValue lv : this.labelValues) {
                    double vv = StringUtil.parseDoubleEE(lv.value1);
                    if (!(Math.abs(vv - v) <= vv * 0.01)) continue;
                    match = true;
                    this.setStatus(true, lv);
                    if (this.current == lv) continue;
                    this.current = lv;
                    if (!this.isTagPresent(SetupFormats.itemUpdate)) continue;
                    this.requestSync();
                }
                if (!match) {
                    this.setStatus(false, (LabelDualValue)this.labelValues.get(0));
                    if (this.current != null) {
                        this.current = null;
                        if (this.isTagPresent(SetupFormats.itemUpdate)) {
                            this.requestSync();
                        }
                    }
                }
            }
        }
    }

    public static class IndicatorsField
    extends FieldWithLabelDualValue {
        private List<IndicatorField> indicatorList = new ArrayList<IndicatorField>();

        @Override
        public SetupFormats getClone(DeviceInterface di) {
            IndicatorsField nf = new IndicatorsField(this.indicatorList);
            nf.copyValues(this, di);
            return nf;
        }

        @Override
        protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
            super.copyValues(model, newDeviceInterface);
        }

        IndicatorsField(List<IndicatorField> indicatorList) {
            this.name = indicatorList.get(0).getName();
            this.page = indicatorList.get(0).getPage();
            this.indicatorList = indicatorList;
        }

        @Override
        public int getColumns() {
            return 1 + this.indicatorList.size() * 2;
        }

        @Override
        public int addGridBag(PopupSetupSelection form, JPanel panel, int inRow, int maxColumns) {
            this.form = form;
            JLabel label = new FontAdjust.FontLabel(String.valueOf(this.name.replace('_', ' ')) + ":");
            label.setToolTipText(this.getTag(SetupFormats.itemTip));
            GridBagConstraints c = new GridBagConstraints();
            int column = 0;
            c.gridx = column++;
            c.gridy = inRow;
            c.anchor = 21;
            c.insets = new Insets(2, 2, 2, 2);
            c.weighty = 1.0;
            panel.add((Component)label, c);
            int i = 0;
            while (i < this.indicatorList.size()) {
                IndicatorField indicatorField = this.indicatorList.get(i);
                indicatorField.form = form;
                label = indicatorField.getLabel();
                c.gridx = column++;
                c.gridy = inRow;
                c.insets = new Insets(2, 2, 2, 2);
                c.anchor = 13;
                panel.add((Component)label, c);
                Indicator indicator = indicatorField.getIndicator();
                this.setBGColor(indicator);
                c.gridx = column++;
                c.gridy = inRow;
                c.anchor = 17;
                c.insets = new Insets(2, 2, 2, 2);
                panel.add((Component)indicator, c);
                ++i;
            }
            return 1;
        }

        @Override
        protected void parseParamsList(List<String> paramsList) {
        }

        @Override
        public void syncValue() {
            for (IndicatorField indicatorField : this.indicatorList) {
                indicatorField.syncValue();
            }
        }

        @Override
        public void syncValue(String name) {
            for (IndicatorField indicatorField : this.indicatorList) {
                indicatorField.syncValue(name);
            }
        }

        @Override
        protected boolean hasTag(String tag) {
            for (IndicatorField indicatorField : this.indicatorList) {
                if (!indicatorField.hasTag(tag)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void setStateVar(Script script) {
            int n = 1;
            for (IndicatorField indicatorField : this.indicatorList) {
                indicatorField.setStateVarN(script, n++);
            }
        }
    }

    public static class InfoAskField
    extends FieldWithLabel
    implements ActionListener {
        static final String typeName = "infoask";
        private JLabel nameLabel = null;
        protected JLabel dataLabel = null;
        protected String unit = "";
        protected JButton getButton = null;

        @Override
        public SetupFormats getClone(DeviceInterface di) {
            InfoAskField nf = new InfoAskField();
            nf.copyValues(this, di);
            return nf;
        }

        @Override
        protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
            super.copyValues(model, newDeviceInterface);
            this.unit = ((InfoAskField)model).unit.replace('_', ' ');
        }

        @Override
        public int getColumns() {
            this.unit = this.labels.size() == 0 ? "" : (String)this.labels.get(0);
            return 3;
        }

        protected JLabel getLabelValue() {
            this.dataLabel = new FontAdjust.FontLabel("");
            this.adjustLabelFormat(this.dataLabel);
            this.dataLabel.setToolTipText(this.getTag(SetupFormats.itemTip));
            return this.dataLabel;
        }

        @Override
        public int addGridBag(PopupSetupSelection form, JPanel panel, int inRow, int maxColumns) {
            this.form = form;
            this.nameLabel = new FontAdjust.FontLabel(String.valueOf(this.name.replace('_', ' ')) + ":");
            this.nameLabel.setToolTipText(this.getTag(SetupFormats.itemTip));
            int column = 0;
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = column++;
            c.gridy = inRow;
            c.anchor = 21;
            c.insets = new Insets(2, 2, 2, 2);
            c.weighty = 1.0;
            panel.add((Component)this.nameLabel, c);
            this.getLabelValue();
            c = new GridBagConstraints();
            c.gridx = column++;
            c.gridy = inRow;
            c.gridwidth = maxColumns - column;
            c.fill = 2;
            c.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)this.dataLabel, c);
            FontAdjust.FontButton getButton = new FontAdjust.FontButton(this.getTag(SetupFormats.itemButtonText, "Get"));
            getButton.setToolTipText(this.getTag(SetupFormats.itemTip));
            getButton.addActionListener(this);
            getButton.setBackground(this.getTagColor(SetupFormats.itemColor, getButton.getBackground()));
            c = new GridBagConstraints();
            c.gridx = maxColumns - 1;
            c.gridy = inRow;
            c.gridwidth = 1;
            c.fill = 2;
            c.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)getButton, c);
            return 1;
        }

        @Override
        protected void setVisible(boolean yes) {
            if (this.nameLabel != null) {
                this.nameLabel.setVisible(yes);
            }
            if (this.getButton != null) {
                this.getButton.setVisible(yes);
            }
            this.dataLabel.setVisible(yes);
        }

        @Override
        protected void setEnable(boolean yes) {
            if (this.nameLabel != null) {
                this.nameLabel.setEnabled(yes);
            }
            if (this.getButton != null) {
                this.getButton.setEnabled(yes);
            }
            this.dataLabel.setEnabled(yes);
        }

        public void localSyncValue() {
            this.deviceInterface.cacheClear();
            String v = StringUtil.unQuote(this.read.writeRead());
            this.currentValue = v;
            if (!this.getTag(SetupFormats.itemFormat).isEmpty()) {
                this.dataLabel.setText(String.valueOf(this.formatDouble(StringUtil.parseDoubleEE(v))) + " " + this.unit.replace('_', ' '));
            } else {
                this.dataLabel.setText(String.valueOf(v) + " " + this.unit.replace('_', ' '));
            }
            if (this.form != null && this.hasTag(SetupFormats.itemLayout)) {
                this.form.pack();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.localSyncValue();
        }
    }

    public static class InfoField
    extends FieldWithLabel {
        static final String typeName = "info";
        private JLabel nameLabel = null;
        private JLabel prefixLabel = null;
        protected JLabel dataLabel = null;
        protected String unit = "";

        @Override
        public SetupFormats getClone(DeviceInterface di) {
            InfoField nf = new InfoField();
            nf.copyValues(this, di);
            return nf;
        }

        @Override
        protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
            super.copyValues(model, newDeviceInterface);
            this.unit = ((InfoField)model).unit.replace('_', ' ');
        }

        @Override
        public int getColumns() {
            this.unit = this.labels.size() == 0 ? "" : (String)this.labels.get(0);
            return this.labels.size() > 1 ? 3 : 2;
        }

        protected JLabel getLabelPrefix() {
            if (this.labels.size() <= 1) {
                return null;
            }
            this.prefixLabel = new FontAdjust.FontLabel(((String)this.labels.get(1)).replace('_', ' '));
            this.adjustLabelFormat(this.prefixLabel);
            this.prefixLabel.setToolTipText(this.getTag(SetupFormats.itemTip));
            return this.prefixLabel;
        }

        protected JLabel getLabelValue() {
            this.dataLabel = new FontAdjust.FontLabel("");
            this.adjustLabelFormat(this.dataLabel);
            this.dataLabel.setToolTipText(this.getTag(SetupFormats.itemTip));
            return this.dataLabel;
        }

        @Override
        public int addGridBag(PopupSetupSelection form, JPanel panel, int inRow, int maxColumns) {
            this.form = form;
            this.nameLabel = new FontAdjust.FontLabel(String.valueOf(this.name.replace('_', ' ')) + ":");
            this.nameLabel.setToolTipText(this.getTag(SetupFormats.itemTip));
            int column = 0;
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = column++;
            c.gridy = inRow;
            c.anchor = 21;
            c.insets = new Insets(2, 2, 2, 2);
            c.weighty = 1.0;
            panel.add((Component)this.nameLabel, c);
            this.prefixLabel = this.getLabelPrefix();
            if (this.prefixLabel != null) {
                c = new GridBagConstraints();
                c.gridx = column++;
                c.gridy = inRow;
                c.insets = new Insets(2, 2, 2, 2);
                c.weighty = 1.0;
                panel.add((Component)this.prefixLabel, c);
            }
            this.getLabelValue();
            c = new GridBagConstraints();
            c.gridx = column++;
            c.gridy = inRow;
            c.gridwidth = maxColumns - column + 1;
            c.fill = 2;
            c.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)this.dataLabel, c);
            return 1;
        }

        @Override
        protected void setStateVar(Script script) {
            this.setScriptValue(script, String.valueOf(this.name) + (this.prefixLabel != null ? this.prefixLabel.getText() : ""), this.currentValue);
        }

        @Override
        protected void setVisible(boolean yes) {
            if (this.nameLabel != null) {
                this.nameLabel.setVisible(yes);
            }
            if (this.prefixLabel != null) {
                this.prefixLabel.setVisible(yes);
            }
            this.dataLabel.setVisible(yes);
        }

        @Override
        protected void setEnable(boolean yes) {
            if (this.nameLabel != null) {
                this.nameLabel.setEnabled(yes);
            }
            if (this.prefixLabel != null) {
                this.prefixLabel.setEnabled(yes);
            }
            this.dataLabel.setEnabled(yes);
        }

        @Override
        public void syncValue() {
            String v = StringUtil.unQuote(this.read.writeRead());
            this.currentValue = v;
            if (!this.getTag(SetupFormats.itemFormat).isEmpty()) {
                this.dataLabel.setText(String.valueOf(this.formatDouble(StringUtil.parseDoubleEE(v))) + " " + this.unit.replace('_', ' '));
            } else {
                this.dataLabel.setText(String.valueOf(v) + " " + this.unit.replace('_', ' '));
            }
            if (this.form != null && this.hasTag(SetupFormats.itemLayout)) {
                this.form.pack();
            }
        }

        @Override
        public void syncValue(String name) {
            if (name.equals(this.name) || this.labels.size() > 1 && name.equals(this.labels.get(1))) {
                this.syncValue();
            }
        }
    }

    public static class InfoIntField
    extends InfoField {
        static final String typeName = "infoint";

        @Override
        public void syncValue() {
            if (this.read.isValid()) {
                double v = this.read.readNumber();
                this.currentValue = v;
                this.dataLabel.setText(String.valueOf(this.formatDouble(v)) + this.unit.replace('_', ' '));
            }
        }
    }

    public static class InfosField
    extends SetupFormats {
        private List<InfoField> infoList = new ArrayList<InfoField>();
        private JLabel nameLabel;

        @Override
        public SetupFormats getClone(DeviceInterface di) {
            InfosField nf = new InfosField(this.infoList);
            nf.copyValues(this, di);
            return nf;
        }

        @Override
        protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
            super.copyValues(model, newDeviceInterface);
        }

        InfosField(List<InfoField> infoList) {
            this.name = infoList.get(0).getName();
            this.page = infoList.get(0).getPage();
            this.infoList = infoList;
        }

        @Override
        public int getColumns() {
            int n = 1;
            for (InfoField infoField : this.infoList) {
                n += infoField.getColumns() - 1;
            }
            return n;
        }

        @Override
        public int addGridBag(PopupSetupSelection form, JPanel panel, int inRow, int maxColumns) {
            this.form = form;
            this.nameLabel = new FontAdjust.FontLabel(String.valueOf(this.name.replace('_', ' ')) + ":");
            this.nameLabel.setToolTipText(this.getTag(SetupFormats.itemTip));
            GridBagConstraints c = new GridBagConstraints();
            int column = 0;
            c.gridx = column++;
            c.gridy = inRow;
            c.anchor = 21;
            c.insets = new Insets(2, 2, 2, 2);
            c.weighty = 1.0;
            panel.add((Component)this.nameLabel, c);
            int i = 0;
            while (i < this.infoList.size()) {
                InfoField infoField = this.infoList.get(i);
                infoField.form = form;
                JLabel label = infoField.getLabelPrefix();
                if (label != null) {
                    c.gridx = column++;
                    c.gridy = inRow;
                    c.insets = new Insets(2, 2, 2, 2);
                    panel.add((Component)label, c);
                }
                label = infoField.getLabelValue();
                c.gridx = column++;
                c.gridy = inRow;
                c.insets = new Insets(2, 2, 2, 2);
                panel.add((Component)label, c);
                ++i;
            }
            return 1;
        }

        @Override
        protected void setVisible(boolean yes) {
            this.nameLabel.setVisible(yes);
            for (InfoField infoField : this.infoList) {
                infoField.setVisible(yes);
            }
        }

        @Override
        protected void setStateVar(Script script) {
            for (InfoField infoField : this.infoList) {
                infoField.setStateVar(script);
            }
        }

        @Override
        protected void parseParamsList(List<String> paramsList) {
        }

        @Override
        public void syncValue() {
            for (InfoField infoField : this.infoList) {
                infoField.syncValue();
            }
        }

        @Override
        public void syncValue(String name) {
            for (InfoField infoField : this.infoList) {
                infoField.syncValue(name);
            }
        }

        @Override
        protected boolean hasTag(String tag) {
            for (InfoField infoField : this.infoList) {
                if (!infoField.hasTag(tag)) continue;
                return true;
            }
            return false;
        }
    }

    public static class LabelDualValue {
        String label;
        String value1;
        String value2;

        protected LabelDualValue(String label, String value1, String value2) {
            this.label = label;
            this.value1 = value1;
            this.value2 = value2;
        }

        public String toString() {
            return String.valueOf(this.label) + " " + this.value1 + " " + this.value2;
        }
    }

    private static class LabelTripleValue {
        String label;
        String value1;
        String value2;
        String value3;

        protected LabelTripleValue(String label, String value1, String value2, String value3) {
            this.label = label;
            this.value1 = value1;
            this.value2 = value2;
            this.value3 = value3;
        }

        public String toString() {
            return String.valueOf(this.label) + " " + this.value1 + " " + this.value2;
        }
    }

    private static class LabelValue {
        String label;
        String value;

        protected LabelValue(String label, String value) {
            this.label = label;
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.label) + " " + this.value;
        }
    }

    public static class MultiField
    extends SetupFormats
    implements ActionListener {
        static final String typeName = "multi";
        protected List<String> controlList = new ArrayList<String>();
        protected List<ControlInfo> controls = new ArrayList<ControlInfo>();
        protected JButton setButton = null;

        @Override
        protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
            super.copyValues(model, newDeviceInterface);
            this.controlList = ((MultiField)model).controlList;
        }

        @Override
        protected void parseParamsList(List<String> paramsList) {
            for (String s : paramsList) {
                String sl = (s = s.trim()).toLowerCase();
                if (sl.startsWith(SetupFormats.controlInfoName) || sl.startsWith(SetupFormats.controlNumberName) || sl.startsWith(SetupFormats.controlNumberIntName) || sl.startsWith(SetupFormats.controlCheckboxName) || sl.startsWith(SetupFormats.controlComboboxName)) {
                    this.controlList.add(s);
                    continue;
                }
                if (s.length() <= 0) continue;
                System.out.println(String.valueOf(this.getClass().getName()) + " - " + this.name + " - Do not contain a valid control name: " + s);
            }
        }

        @Override
        public SetupFormats getClone(DeviceInterface di) {
            MultiField mf = new MultiField();
            mf.copyValues(this, di);
            return mf;
        }

        @Override
        protected void setEnable(boolean yes) {
            for (ControlInfo ci : this.controls) {
                ci.setEnable(yes);
            }
            this.setButton.setEnabled(yes);
        }

        @Override
        protected void setVisible(boolean yes) {
            this.setButton.setVisible(yes);
            for (ControlInfo ci : this.controls) {
                ci.setVisible(yes);
            }
        }

        @Override
        public int addGridBag(PopupSetupSelection form, JPanel panel, int inRow, int maxColumns) {
            this.form = form;
            int n = 0;
            FontAdjust.FontLabel label = new FontAdjust.FontLabel(String.valueOf(this.name.replace('_', ' ')) + ":");
            label.setToolTipText(this.getTag(SetupFormats.itemTip));
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = n++;
            c.gridy = inRow;
            c.anchor = 21;
            c.insets = new Insets(2, 2, 2, 2);
            c.weighty = 1.0;
            panel.add((Component)label, c);
            int extraColumns = maxColumns - this.controlList.size() - 2;
            int extra = 0;
            this.controls.clear();
            for (String params : this.controlList) {
                ControlInfo ci = ControlInfo.getControl(this, n - 1, params);
                this.controls.add(ci);
                c = new GridBagConstraints();
                c.gridx = extra + n++;
                c.gridy = inRow;
                if (extraColumns > 0 && (ci instanceof ControlInfoNumber || ci instanceof ControlInfoNumberInt) && this.getTagInt(SetupFormats.itemTextWidth, 6, n - 1) > 6) {
                    c.gridwidth = 2;
                    ++extra;
                    --extraColumns;
                }
                c.insets = new Insets(2, 2, 2, 2);
                c.weighty = 1.0;
                panel.add(ci.getComponent(this.getTag(SetupFormats.itemTip)), c);
            }
            this.setButton = new FontAdjust.FontButton(this.getTag(SetupFormats.itemButtonText, "Set"));
            this.setButton.setToolTipText(this.getTag(SetupFormats.itemTip));
            this.setButton.addActionListener(this);
            this.setButton.setBackground(this.getTagColor(SetupFormats.itemColor, this.setButton.getBackground()));
            c = new GridBagConstraints();
            c.gridx = maxColumns - 1;
            c.gridy = inRow;
            c.fill = 2;
            c.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)this.setButton, c);
            return 1;
        }

        @Override
        public int getColumns() {
            return this.controlList.size() + 2;
        }

        @Override
        public void syncValue() {
            block5: {
                if (!this.read.isValid()) break block5;
                if (this.isTagPresent(SetupFormats.itemStringResult)) {
                    String ss = this.read.writeRead();
                    int i = 0;
                    String[] stringArray = ss.split("[,;\t ]+");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        if (i < this.controls.size()) {
                            this.controls.get(i).setValue(s);
                        }
                        ++i;
                        ++n2;
                    }
                } else {
                    List<Double> vv = this.read.readNumbers();
                    int i = 0;
                    while (i < Math.min(vv.size(), this.controls.size())) {
                        this.controls.get(i).setValue(vv.get(i));
                        ++i;
                    }
                }
            }
        }

        @Override
        public boolean collectEnable() {
            if (this.setButton != null) {
                this.write.enableCollect(true);
                this.setButton.setText("");
                this.setButton.setEnabled(false);
                this.setButton.setIcon(IconGenerator.makeIcon(IconGenerator.IconType.X));
                return true;
            }
            return false;
        }

        @Override
        public String collectWrite() {
            this.write.clearCollect();
            this.localWrite();
            return this.write.getCollected();
        }

        @Override
        protected void setStateVar(Script script) {
        }

        private void localWrite() {
            ArrayList<String> list = new ArrayList<String>();
            for (ControlInfo ci : this.controls) {
                list.add(ci.getValue());
                ci.validate();
            }
            this.write.write(list, this.getTag(SetupFormats.itemTxDelimiter, " "));
        }

        @Override
        public boolean isValid() {
            for (ControlInfo ci : this.controls) {
                if (ci.validate()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isValid()) {
                this.localWrite();
                this.requestSync();
            }
        }
    }

    public static class NumberDualField
    extends FieldWithLabelTriplelValue
    implements ActionListener {
        static final String typeName = "numberdual";
        NumberSetting setting1 = new NumberSetting();
        NumberSetting setting2 = new NumberSetting();
        JButton setButton = null;
        private double last1 = 0.0;
        private double last2 = 0.0;

        @Override
        public SetupFormats getClone(DeviceInterface di) {
            NumberDualField nf = new NumberDualField();
            nf.copyValues(this, di);
            return nf;
        }

        @Override
        protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
            super.copyValues(model, newDeviceInterface);
            this.setting1 = ((NumberDualField)model).setting1;
            this.setting2 = ((NumberDualField)model).setting2;
        }

        @Override
        protected void parseParamsList(List<String> paramsList) {
            super.parseParamsList(paramsList);
            this.setting1.parse((LabelTripleValue)this.labelValues.get(0));
            this.setting2.parse((LabelTripleValue)this.labelValues.get(1));
        }

        @Override
        public int getColumns() {
            return 8;
        }

        @Override
        public int addGridBag(PopupSetupSelection form, JPanel panel, int inRow, int maxColumns) {
            this.form = form;
            int n = 0;
            FontAdjust.FontLabel label = new FontAdjust.FontLabel(String.valueOf(this.name.replace('_', ' ')) + ":");
            label.setToolTipText(this.getTag(SetupFormats.itemTip));
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = n++;
            c.gridy = inRow;
            c.anchor = 21;
            c.insets = new Insets(2, 2, 2, 2);
            c.weighty = 1.0;
            panel.add((Component)label, c);
            label = new FontAdjust.FontLabel(String.valueOf(this.setting1.label.replace('_', ' ')) + ":");
            label.setToolTipText(this.getTag(SetupFormats.itemTip));
            c = new GridBagConstraints();
            c.gridx = n++;
            c.gridy = inRow;
            c.insets = new Insets(2, 2, 2, 2);
            c.weighty = 1.0;
            panel.add((Component)label, c);
            this.setting1.textField = new Support.MyTextField(this.getTagInt(SetupFormats.itemTextWidth, 6, 0));
            this.setting1.textField.setToolTipText(this.getTag(SetupFormats.itemTip));
            this.setting1.textField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent arg0) {
                    setting1.textField.selectAll();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    double v = StringUtil.parseDoubleEE(setting1.textField.getText());
                    if (Double.isNaN(v) || v < setting1.min || v > setting1.max) {
                        setting1.textField.setBackground(Support.colorScheme.errorBackground);
                    } else if (v != last1) {
                        setting1.textField.setBackground(Support.colorScheme.changedBackground);
                    } else {
                        setting1.textField.setBackground(Support.colorScheme.textBackground);
                    }
                }
            });
            c = new GridBagConstraints();
            c.gridx = n++;
            c.gridy = inRow;
            c.fill = 2;
            c.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)this.setting1.textField, c);
            label = new FontAdjust.FontLabel(this.setting1.unit.replace('_', ' '));
            this.adjustLabelFormat(label);
            label.setToolTipText(this.getTag(SetupFormats.itemTip));
            c = new GridBagConstraints();
            c.gridx = n++;
            c.gridy = inRow;
            panel.add((Component)label, c);
            label = new FontAdjust.FontLabel(String.valueOf(this.setting2.label.replace('_', ' ')) + ":");
            this.adjustLabelFormat(label);
            label.setToolTipText(this.getTag(SetupFormats.itemTip));
            c = new GridBagConstraints();
            c.gridx = n++;
            c.gridy = inRow;
            c.insets = new Insets(2, 2, 2, 2);
            c.weighty = 1.0;
            panel.add((Component)label, c);
            this.setting2.textField = new Support.MyTextField(this.getTagInt(SetupFormats.itemTextWidth, 6, 1));
            this.setting2.textField.setToolTipText(this.getTag(SetupFormats.itemTip));
            this.setting2.textField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent arg0) {
                    setting2.textField.selectAll();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    double v = StringUtil.parseDoubleEE(setting2.textField.getText());
                    if (Double.isNaN(v) || v < setting2.min || v > setting2.max) {
                        setting2.textField.setBackground(Support.colorScheme.errorBackground);
                    } else if (v != last2) {
                        setting2.textField.setBackground(Support.colorScheme.changedBackground);
                    } else {
                        setting2.textField.setBackground(Support.colorScheme.textBackground);
                    }
                }
            });
            c = new GridBagConstraints();
            c.gridx = n++;
            c.gridy = inRow;
            c.fill = 2;
            c.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)this.setting2.textField, c);
            label = new FontAdjust.FontLabel(this.setting2.unit.replace('_', ' '));
            this.adjustLabelFormat(label);
            label.setToolTipText(this.getTag(SetupFormats.itemTip));
            c = new GridBagConstraints();
            c.gridx = n++;
            c.gridy = inRow;
            panel.add((Component)label, c);
            this.setButton = new FontAdjust.FontButton(this.getTag(SetupFormats.itemButtonText, "Set"));
            this.setButton.setToolTipText(this.getTag(SetupFormats.itemTip));
            this.setButton.addActionListener(this);
            this.setButton.setBackground(this.getTagColor(SetupFormats.itemColor, this.setButton.getBackground()));
            c = new GridBagConstraints();
            c.gridx = maxColumns - 1;
            c.gridy = inRow;
            c.fill = 2;
            c.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)this.setButton, c);
            return 1;
        }

        @Override
        protected void setStateVar(Script script) {
            this.setScriptValue(script, String.valueOf(this.name) + "1", this.currentValue);
            this.setScriptValue(script, String.valueOf(this.name) + "2", this.currentValue2);
        }

        @Override
        public void syncValue() {
            List<Double> v;
            if (this.read.isValid() && (v = this.read.readNumbers()).size() == 2 && !Double.isNaN(v.get(0)) && !Double.isNaN(v.get(1))) {
                this.currentValue = v.get(0);
                this.currentValue2 = v.get(1);
                this.last1 = v.get(0);
                this.last2 = v.get(1);
                this.setting1.textField.setText(this.formatDouble(0, v.get(0)));
                this.setting2.textField.setText(this.formatDouble(1, v.get(1)));
            }
        }

        @Override
        public boolean collectEnable() {
            if (this.setButton != null) {
                this.write.enableCollect(true);
                this.setButton.setText("");
                this.setButton.setEnabled(false);
                this.setButton.setIcon(IconGenerator.makeIcon(IconGenerator.IconType.X));
                return true;
            }
            return false;
        }

        @Override
        public String collectWrite() {
            this.write.clearCollect();
            this.localWrite();
            return this.write.getCollected();
        }

        @Override
        public boolean isValid() {
            boolean valid = true;
            double v1 = StringUtil.parseDoubleEE(this.setting1.textField.getText());
            if (Double.isNaN(v1) || v1 < this.setting1.min || v1 > this.setting1.max) {
                this.setting1.textField.setBackground(Support.colorScheme.errorBackground);
                valid = false;
            } else {
                this.setting1.textField.setBackground(Support.colorScheme.textBackground);
            }
            double v2 = StringUtil.parseDoubleEE(this.setting2.textField.getText());
            if (Double.isNaN(v2) || v2 < this.setting2.min || v2 > this.setting2.max) {
                valid = false;
                this.setting2.textField.setBackground(Support.colorScheme.errorBackground);
            } else {
                this.setting2.textField.setBackground(Support.colorScheme.textBackground);
            }
            return valid;
        }

        private void localWrite() {
            this.last1 = StringUtil.parseDoubleEE(this.setting1.textField.getText());
            this.last2 = StringUtil.parseDoubleEE(this.setting2.textField.getText());
            ArrayList<String> list = new ArrayList<String>();
            list.add(Double.toString(this.last1));
            list.add(Double.toString(this.last2));
            this.write.write(list, this.getTag(SetupFormats.itemTxDelimiter, " "));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isValid()) {
                this.localWrite();
                this.requestSync();
            }
        }
    }

    public static class NumberField
    extends FieldWithLabelDualValue
    implements ActionListener {
        static final String typeName = "number";
        protected NumberSetting setting = new NumberSetting();
        protected JButton setButton;
        protected JLabel nameLabel;
        protected JLabel unitLabel;
        protected JLabel rangeLabel;
        protected String lastValue = "";
        protected Double emptyValue = null;

        @Override
        public SetupFormats getClone(DeviceInterface di) {
            NumberField nf = new NumberField();
            nf.copyValues(this, di);
            return nf;
        }

        @Override
        protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
            super.copyValues(model, newDeviceInterface);
            this.setting = ((NumberField)model).setting;
            this.emptyValue = ((NumberField)model).emptyValue;
        }

        @Override
        protected void parseParamsList(List<String> paramsList) {
            super.parseParamsList(paramsList);
            this.setting.parse((LabelDualValue)this.labelValues.get(0));
            this.emptyValue = this.getTagFloat(SetupFormats.itemEmptyValue, null);
        }

        @Override
        public int getColumns() {
            return 5;
        }

        protected boolean validateTextField(JTextField f) {
            String s = f.getText().trim();
            if (this.emptyValue != null && (s.length() == 0 || s.equals("-"))) {
                f.setBackground(s.equals(this.lastValue) ? Support.colorScheme.textBackground : Support.colorScheme.changedBackground);
                return true;
            }
            double v = StringUtil.parseDoubleEE(s);
            if (Double.isNaN(v) || v < this.setting.min || v > this.setting.max) {
                f.setBackground(Support.colorScheme.errorBackground);
                return false;
            }
            if (!s.equals(this.lastValue)) {
                f.setBackground(Support.colorScheme.changedBackground);
                return true;
            }
            f.setBackground(Support.colorScheme.textBackground);
            return true;
        }

        @Override
        protected boolean isEnabled() {
            return this.setting.textField == null ? false : this.setting.textField.isEnabled();
        }

        @Override
        protected boolean isVisible() {
            return this.setting.textField == null ? false : this.setting.textField.isVisible();
        }

        @Override
        protected void setEnable(boolean yes) {
            this.setting.textField.setEnabled(yes);
            this.setButton.setEnabled(yes);
        }

        @Override
        protected void setVisible(boolean yes) {
            this.setting.textField.setVisible(yes);
            this.setButton.setVisible(yes);
            this.nameLabel.setVisible(yes);
            this.rangeLabel.setVisible(yes);
            this.unitLabel.setVisible(yes);
        }

        @Override
        public int addGridBag(PopupSetupSelection form, JPanel panel, int inRow, int maxColumns) {
            this.form = form;
            LabelDualValue cfr_ignored_0 = (LabelDualValue)this.labelValues.get(0);
            this.nameLabel = new FontAdjust.FontLabel(String.valueOf(this.name.replace('_', ' ')) + ":");
            this.nameLabel.setToolTipText(this.getTag(SetupFormats.itemTip));
            this.setBGColor(this.nameLabel);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = inRow;
            c.anchor = 21;
            c.insets = new Insets(2, 2, 2, 2);
            c.weighty = 1.0;
            panel.add((Component)this.nameLabel, c);
            this.setting.textField = new Support.MyTextField(this.getTagInt(SetupFormats.itemTextWidth, 6));
            this.setting.textField.setToolTipText(this.getTag(SetupFormats.itemTip));
            this.setBGColor(this.setting.textField);
            this.setting.textField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent arg0) {
                    setting.textField.selectAll();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    this.validateTextField(setting.textField);
                }
            });
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = inRow;
            c.gridwidth = maxColumns > 5 ? (maxColumns > 6 ? maxColumns - 5 : maxColumns - 4) : 1;
            c.fill = 2;
            c.anchor = 21;
            c.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)this.setting.textField, c);
            this.unitLabel = new FontAdjust.FontLabel(this.setting.unit.replace('_', ' '));
            this.adjustLabelFormat(this.unitLabel);
            this.unitLabel.setToolTipText(this.getTag(SetupFormats.itemTip));
            c = new GridBagConstraints();
            c.gridx = maxColumns > 6 ? maxColumns - 4 : maxColumns - 3;
            c.gridy = inRow;
            c.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)this.unitLabel, c);
            String s = String.valueOf(this.formatDouble(this.setting.min)) + " - " + this.formatDouble(this.setting.max);
            if (this.emptyValue != null) {
                s = "-, " + s;
            }
            this.rangeLabel = new FontAdjust.FontLabel(s);
            this.adjustLabelFormat(this.rangeLabel);
            this.rangeLabel.setToolTipText(this.getTag(SetupFormats.itemTip));
            c = new GridBagConstraints();
            c.gridwidth = maxColumns > 6 ? 2 : 1;
            c.gridx = maxColumns - 1 - c.gridwidth;
            c.gridy = inRow;
            c.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)this.rangeLabel, c);
            this.setButton = new FontAdjust.FontButton(this.getTag(SetupFormats.itemButtonText, "Set"));
            this.setButton.setToolTipText(this.getTag(SetupFormats.itemTip));
            this.setButton.addActionListener(this);
            this.setButton.setBackground(this.getTagColor(SetupFormats.itemColor, this.setButton.getBackground()));
            c = new GridBagConstraints();
            c.gridx = maxColumns - 1;
            c.gridy = inRow;
            c.fill = 2;
            c.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)this.setButton, c);
            return 1;
        }

        @Override
        public void setSetupFieldValue(String value) {
            this.setting.textField.setText(value);
            this.lastValue = value;
            this.validateTextField(this.setting.textField);
        }

        @Override
        public void syncValue() {
            double v;
            if (this.read.isValid() && !Double.isNaN(v = this.read.readNumber())) {
                this.currentValue = v;
                if (this.emptyValue != null && v == this.emptyValue) {
                    this.setting.textField.setText("");
                } else {
                    this.setting.textField.setText(this.formatDouble(v));
                }
                this.lastValue = this.setting.textField.getText();
                this.validateTextField(this.setting.textField);
            }
        }

        @Override
        protected void setStateVar(Script script) {
            this.setScriptValue(script, this.name, this.currentValue);
        }

        @Override
        public boolean collectEnable() {
            if (this.setButton != null) {
                this.write.enableCollect(true);
                this.setButton.setText("");
                this.setButton.setEnabled(false);
                this.setButton.setIcon(IconGenerator.makeIcon(IconGenerator.IconType.X));
                return true;
            }
            return false;
        }

        private void localWrite() {
            this.lastValue = this.setting.textField.getText().trim();
            this.currentValue = this.lastValue;
            if (this.lastValue.length() == 0 || this.lastValue.equals("-")) {
                String s = this.getTag(SetupFormats.itemEmptyWrite, null);
                if (s == null) {
                    this.write.write(Double.toString(this.emptyValue));
                } else {
                    this.write.writeReadDirect(s);
                }
            } else {
                double v = StringUtil.parseDoubleEE(this.lastValue);
                this.write.write(Double.toString(v));
                PopupParamAdjuster.valueChanged(this.page, this.name, v);
            }
        }

        @Override
        public String collectWrite() {
            this.write.clearCollect();
            this.localWrite();
            return this.write.getCollected();
        }

        @Override
        protected boolean isValid() {
            return this.validateTextField(this.setting.textField);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isValid()) {
                this.localWrite();
                this.requestSync();
                this.validateTextField(this.setting.textField);
            }
        }
    }

    public static class NumberIntField
    extends NumberField
    implements ActionListener {
        static final String typeName = "numberint";

        @Override
        public SetupFormats getClone(DeviceInterface di) {
            NumberIntField nf = new NumberIntField();
            nf.copyValues(this, di);
            return nf;
        }

        @Override
        protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
            super.copyValues(model, newDeviceInterface);
        }

        @Override
        protected boolean validateTextField(JTextField f) {
            String s = f.getText().trim();
            if (this.emptyValue != null && (s.length() == 0 || s.equals("-"))) {
                f.setBackground(s.equals(this.lastValue) ? Support.colorScheme.textBackground : Support.colorScheme.changedBackground);
                return true;
            }
            double v = StringUtil.parseDoubleEE(s);
            if (Double.isNaN(v) || s.indexOf(46) >= 0 || s.indexOf(44) >= 0 || (double)((long)v) < this.setting.min || (double)((long)v) > this.setting.max) {
                this.setting.textField.setBackground(Support.colorScheme.errorBackground);
                return false;
            }
            if (!s.equals(this.lastValue)) {
                this.setting.textField.setBackground(Support.colorScheme.changedBackground);
                return true;
            }
            this.setting.textField.setBackground(Support.colorScheme.textBackground);
            return true;
        }

        @Override
        public int addGridBag(PopupSetupSelection form, JPanel panel, int inRow, int maxColumns) {
            this.setting.min = Math.round(this.setting.min);
            this.setting.max = Math.round(this.setting.max);
            return super.addGridBag(form, panel, inRow, maxColumns);
        }

        @Override
        public void syncValue() {
            double v;
            if (this.read.isValid() && !Double.isNaN(v = this.read.readNumber())) {
                this.currentValue = (long)v;
                if (this.emptyValue != null && v == this.emptyValue) {
                    this.setting.textField.setText("");
                } else {
                    this.setting.textField.setText(Long.toString((long)v));
                }
                this.lastValue = this.setting.textField.getText();
                this.validateTextField(this.setting.textField);
            }
        }

        @Override
        protected void setStateVar(Script script) {
            this.setScriptValue(script, this.name, this.currentValue);
        }

        @Override
        public String collectWrite() {
            this.write.clearCollect();
            this.localWrite();
            return this.write.getCollected();
        }

        @Override
        public boolean isValid() {
            return this.validateTextField(this.setting.textField);
        }

        private void localWrite() {
            String s = this.setting.textField.getText();
            if (s.length() == 0 || s.equals("-")) {
                String ss = this.getTag(SetupFormats.itemEmptyWrite, null);
                if (ss == null) {
                    this.write.write(Long.toString(this.emptyValue.longValue()));
                } else {
                    this.write.writeReadDirect(s);
                }
            } else {
                long v = (long)StringUtil.parseDoubleEE(s);
                this.write.write(Long.toString(v));
            }
            this.lastValue = s;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isValid()) {
                this.localWrite();
                this.requestSync();
                this.validateTextField(this.setting.textField);
            }
        }
    }

    public static class NumberQuadField
    extends FieldWithLabelTriplelValue
    implements ActionListener {
        static final String typeName = "numberquad";
        NumberSetting setting1 = new NumberSetting();
        NumberSetting setting2 = new NumberSetting();
        NumberSetting setting3 = new NumberSetting();
        NumberSetting setting4 = new NumberSetting();

        @Override
        public SetupFormats getClone(DeviceInterface di) {
            NumberQuadField nf = new NumberQuadField();
            nf.copyValues(this, di);
            return nf;
        }

        @Override
        protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
            super.copyValues(model, newDeviceInterface);
            this.setting1 = ((NumberQuadField)model).setting1;
            this.setting2 = ((NumberQuadField)model).setting2;
            this.setting3 = ((NumberQuadField)model).setting3;
            this.setting4 = ((NumberQuadField)model).setting4;
        }

        @Override
        protected void parseParamsList(List<String> paramsList) {
        }

        @Override
        public int getColumns() {
            return 5;
        }

        @Override
        public int addGridBag(PopupSetupSelection form, JPanel panel, int inRow, int maxColumns) {
            this.form = form;
            return 1;
        }

        @Override
        public void syncValue() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    static class NumberSetting {
        String label;
        String unit;
        double min;
        double max;
        JTextField textField;

        NumberSetting() {
        }

        protected void parse(LabelDualValue ld) {
            this.unit = ld.label;
            this.min = StringUtil.parseDoubleEE(ld.value1);
            this.max = StringUtil.parseDoubleEE(ld.value2);
        }

        protected void parse(LabelTripleValue ld) {
            this.unit = ld.label;
            this.min = StringUtil.parseDoubleEE(ld.value1);
            this.max = StringUtil.parseDoubleEE(ld.value2);
            this.label = ld.value3;
        }
    }

    public static class NumberTripleField
    extends FieldWithLabelTriplelValue
    implements ActionListener {
        static final String typeName = "numbertriple";
        NumberSetting setting1 = new NumberSetting();
        NumberSetting setting2 = new NumberSetting();
        NumberSetting setting3 = new NumberSetting();

        @Override
        public SetupFormats getClone(DeviceInterface di) {
            NumberTripleField nf = new NumberTripleField();
            nf.copyValues(this, di);
            return nf;
        }

        @Override
        protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
            super.copyValues(model, newDeviceInterface);
            this.setting1 = ((NumberTripleField)model).setting1;
            this.setting2 = ((NumberTripleField)model).setting2;
            this.setting3 = ((NumberTripleField)model).setting3;
        }

        @Override
        protected void parseParamsList(List<String> paramsList) {
            super.parseParamsList(paramsList);
            this.setting1.parse((LabelTripleValue)this.labelValues.get(0));
            this.setting2.parse((LabelTripleValue)this.labelValues.get(1));
            this.setting3.parse((LabelTripleValue)this.labelValues.get(2));
        }

        @Override
        public int getColumns() {
            return 8;
        }

        @Override
        public int addGridBag(PopupSetupSelection form, JPanel panel, int inRow, int maxColumns) {
            this.form = form;
            int n = 0;
            FontAdjust.FontLabel label = new FontAdjust.FontLabel(String.valueOf(this.name.replace('_', ' ')) + ":");
            label.setToolTipText(this.getTag(SetupFormats.itemTip));
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = n++;
            c.gridy = inRow;
            c.anchor = 21;
            c.insets = new Insets(2, 2, 2, 2);
            c.weighty = 1.0;
            panel.add((Component)label, c);
            label = new FontAdjust.FontLabel(String.valueOf(this.setting1.label.replace('_', ' ')) + ":");
            this.adjustLabelFormat(label);
            label.setToolTipText(this.getTag(SetupFormats.itemTip));
            c = new GridBagConstraints();
            c.gridx = n++;
            c.gridy = inRow;
            c.insets = new Insets(2, 2, 2, 2);
            c.weighty = 1.0;
            panel.add((Component)label, c);
            this.setting1.textField = new Support.MyTextField(this.getTagInt(SetupFormats.itemTextWidth, 6, 0));
            this.setting1.textField.setToolTipText(this.getTag(SetupFormats.itemTip));
            this.setting1.textField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent arg0) {
                    setting1.textField.selectAll();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    double v = StringUtil.parseDoubleEE(setting1.textField.getText());
                    if (Double.isNaN(v) || v < setting1.min || v > setting1.max) {
                        setting1.textField.setBackground(Support.colorScheme.errorBackground);
                    } else {
                        setting1.textField.setBackground(Support.colorScheme.textBackground);
                    }
                }
            });
            c = new GridBagConstraints();
            c.gridx = n++;
            c.gridy = inRow;
            c.fill = 2;
            c.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)this.setting1.textField, c);
            label = new FontAdjust.FontLabel(String.valueOf(this.setting2.label.replace('_', ' ')) + ":");
            this.adjustLabelFormat(label);
            label.setToolTipText(this.getTag(SetupFormats.itemTip));
            c = new GridBagConstraints();
            c.gridx = n++;
            c.gridy = inRow;
            c.insets = new Insets(2, 2, 2, 2);
            c.weighty = 1.0;
            panel.add((Component)label, c);
            this.setting2.textField = new Support.MyTextField(this.getTagInt(SetupFormats.itemTextWidth, 6, 1));
            this.setting2.textField.setToolTipText(this.getTag(SetupFormats.itemTip));
            this.setting2.textField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent arg0) {
                    setting2.textField.selectAll();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    double v = StringUtil.parseDoubleEE(setting2.textField.getText());
                    if (Double.isNaN(v) || v < setting2.min || v > setting2.max) {
                        setting2.textField.setBackground(Support.colorScheme.errorBackground);
                    } else {
                        setting2.textField.setBackground(Support.colorScheme.textBackground);
                    }
                }
            });
            c = new GridBagConstraints();
            c.gridx = n++;
            c.gridy = inRow;
            c.fill = 2;
            c.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)this.setting2.textField, c);
            label = new FontAdjust.FontLabel(String.valueOf(this.setting3.label.replace('_', ' ')) + ":");
            this.adjustLabelFormat(label);
            label.setToolTipText(this.getTag(SetupFormats.itemTip));
            c = new GridBagConstraints();
            c.gridx = n++;
            c.gridy = inRow;
            c.insets = new Insets(2, 2, 2, 2);
            c.weighty = 1.0;
            panel.add((Component)label, c);
            this.setting3.textField = new Support.MyTextField(this.getTagInt(SetupFormats.itemTextWidth, 6, 2));
            this.setting3.textField.setToolTipText(this.getTag(SetupFormats.itemTip));
            this.setting3.textField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent arg0) {
                    setting3.textField.selectAll();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    double v = StringUtil.parseDoubleEE(setting3.textField.getText());
                    if (Double.isNaN(v) || v < setting3.min || v > setting3.max) {
                        setting3.textField.setBackground(Support.colorScheme.errorBackground);
                    } else {
                        setting3.textField.setBackground(Support.colorScheme.textBackground);
                    }
                }
            });
            c = new GridBagConstraints();
            c.gridx = n++;
            c.gridy = inRow;
            c.fill = 2;
            c.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)this.setting3.textField, c);
            FontAdjust.FontButton setButton = new FontAdjust.FontButton(this.getTag(SetupFormats.itemButtonText, "Set"));
            setButton.setToolTipText(this.getTag(SetupFormats.itemTip));
            setButton.addActionListener(this);
            setButton.setBackground(this.getTagColor(SetupFormats.itemColor, setButton.getBackground()));
            c = new GridBagConstraints();
            c.gridx = maxColumns - 1;
            c.gridy = inRow;
            c.fill = 2;
            c.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)setButton, c);
            return 1;
        }

        @Override
        protected void setStateVar(Script script) {
            this.setScriptValue(script, String.valueOf(this.name) + "1", this.currentValue);
            this.setScriptValue(script, String.valueOf(this.name) + "2", this.currentValue2);
            this.setScriptValue(script, String.valueOf(this.name) + "3", this.currentValue3);
        }

        @Override
        public void syncValue() {
            List<Double> v;
            if (this.read.isValid() && (v = this.read.readNumbers()).size() == 3 && !Double.isNaN(v.get(0)) && !Double.isNaN(v.get(1)) && !Double.isNaN(v.get(2))) {
                this.currentValue = v.get(0);
                this.currentValue2 = v.get(1);
                this.currentValue3 = v.get(2);
                this.setting1.textField.setText(StringUtil.formatDoubleEE(v.get(0)));
                this.setting2.textField.setText(StringUtil.formatDoubleEE(v.get(1)));
                this.setting3.textField.setText(StringUtil.formatDoubleEE(v.get(2)));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            double v3;
            double v2;
            boolean update = true;
            double v1 = StringUtil.parseDoubleEE(this.setting1.textField.getText());
            if (Double.isNaN(v1) || v1 < this.setting1.min || v1 > this.setting1.max) {
                this.setting1.textField.setBackground(Support.colorScheme.errorBackground);
                update = false;
            }
            if (Double.isNaN(v2 = StringUtil.parseDoubleEE(this.setting2.textField.getText())) || v2 < this.setting2.min || v2 > this.setting2.max) {
                update = false;
                this.setting2.textField.setBackground(Support.colorScheme.errorBackground);
            }
            if (Double.isNaN(v3 = StringUtil.parseDoubleEE(this.setting2.textField.getText())) || v3 < this.setting2.min || v3 > this.setting2.max) {
                update = false;
                this.setting3.textField.setBackground(Support.colorScheme.errorBackground);
            }
            if (update) {
                this.setting1.textField.setBackground(Support.colorScheme.textBackground);
                this.setting2.textField.setBackground(Support.colorScheme.textBackground);
                this.setting2.textField.setBackground(Support.colorScheme.textBackground);
                ArrayList<String> list = new ArrayList<String>();
                list.add(Double.toString(v1));
                list.add(Double.toString(v2));
                list.add(Double.toString(v3));
                this.write.write(list, this.getTag(SetupFormats.itemTxDelimiter, " "));
                this.requestSync();
            }
        }
    }

    public static class RadioField
    extends FieldWithLabelValue
    implements ActionListener {
        static final String typeName = "radio";
        private List<JRadioButton> buttonList = new ArrayList<JRadioButton>();
        private ButtonGroup grp;
        private JLabel nameLabel;

        @Override
        public SetupFormats getClone(DeviceInterface di) {
            RadioField nf = new RadioField();
            nf.copyValues(this, di);
            return nf;
        }

        @Override
        protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
            super.copyValues(model, newDeviceInterface);
        }

        @Override
        public int getColumns() {
            return this.labelValues.size() + 1;
        }

        @Override
        protected void setEnable(boolean yes) {
            for (JRadioButton rb : this.buttonList) {
                rb.setEnabled(yes);
            }
        }

        @Override
        public int addGridBag(PopupSetupSelection form, JPanel panel, int inRow, int maxColumns) {
            this.form = form;
            this.buttonList.clear();
            this.nameLabel = new FontAdjust.FontLabel(String.valueOf(this.name.replace('_', ' ')) + ":");
            this.nameLabel.setToolTipText(this.getTag(SetupFormats.itemTip));
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = inRow;
            c.anchor = 21;
            c.insets = new Insets(2, 2, 2, 2);
            c.weighty = 1.0;
            panel.add((Component)this.nameLabel, c);
            this.grp = new ButtonGroup();
            int i = 0;
            while (i < this.labelValues.size()) {
                LabelValue lv = (LabelValue)this.labelValues.get(i);
                FontAdjust.FontRadioButton button = new FontAdjust.FontRadioButton(lv.label.replace('_', ' '));
                button.setActionCommand(lv.value);
                button.addActionListener(this);
                button.setToolTipText(this.getTag(SetupFormats.itemTip));
                this.setBGColor(button);
                this.grp.add(button);
                c = new GridBagConstraints();
                c.gridx = 1 + i;
                c.gridy = inRow;
                c.gridwidth = 1;
                c.fill = 2;
                c.insets = new Insets(2, 2, 2, 2);
                this.buttonList.add(button);
                panel.add((Component)button, c);
                ++i;
            }
            return 1;
        }

        @Override
        protected void setVisible(boolean yes) {
            for (JRadioButton rb : this.buttonList) {
                rb.setVisible(yes);
            }
            this.nameLabel.setVisible(yes);
        }

        @Override
        public void setSetupFieldValue(String value) {
            try {
                double v = StringUtil.parseDoubleEE(value);
                if (!Double.isNaN(v) && !Double.isInfinite(v)) {
                    this.setValue(v);
                }
            }
            catch (Exception exception) {}
        }

        private void setValue(double v) {
            if (!Double.isNaN(v)) {
                int i = 0;
                while (i < this.labelValues.size()) {
                    LabelValue lv = (LabelValue)this.labelValues.get(i);
                    double vv = StringUtil.parseDoubleEE(lv.value);
                    double d = Math.abs(vv - v);
                    double d2 = vv == 0.0 ? 1.0E-12 : Math.abs(vv) * 0.01;
                    if (d < d2) {
                        this.currentValue = i;
                        this.grp.setSelected(this.buttonList.get(i).getModel(), true);
                        return;
                    }
                    ++i;
                }
            }
            this.currentValue = 0;
            this.grp.clearSelection();
        }

        private void syncValueNumber() {
            double v = Double.NaN;
            if (this.read.isValid()) {
                v = this.read.readNumber();
            }
            this.setValue(v);
        }

        private void syncValueString() {
            boolean match = false;
            if (this.read.isValid()) {
                String v = this.read.writeRead();
                int i = 0;
                while (i < this.labelValues.size()) {
                    LabelValue lv = (LabelValue)this.labelValues.get(i);
                    if (lv.value.equals(v)) {
                        this.currentValue = lv.value;
                        this.grp.setSelected(this.buttonList.get(i).getModel(), true);
                        match = true;
                    }
                    ++i;
                }
            }
            if (!match) {
                this.currentValue = "";
                this.grp.clearSelection();
            }
        }

        @Override
        public void syncValue() {
            if (this.isTagPresent(SetupFormats.itemStringResult)) {
                this.syncValueString();
            } else {
                this.syncValueNumber();
            }
        }

        @Override
        protected void setStateVar(Script script) {
            this.setScriptValue(script, this.name, this.currentValue);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String s = e.getActionCommand();
            this.write.write(s);
            try {
                double v = StringUtil.parseDoubleEE(s);
                if (!Double.isNaN(v) && !Double.isInfinite(v)) {
                    PopupParamAdjuster.valueChanged(this.page, this.name, v);
                }
            }
            catch (Exception exception) {}
            this.requestSync();
        }
    }

    public static class SelectorField
    extends FieldWithLabelValue {
        static final String typeName = "selector";
        private Map<String, String> controlNames = new HashMap<String, String>();
        private String emptySelection = null;
        private String expression = null;
        private String selected = "???????????????????????????????";
        protected Map<String, List<SetupFormats>> controls = null;
        private JLabel emptyLabel;
        private int firstRow = 0;
        private JPanel panel = null;
        private int maxColumns = 0;
        private int maxRows = 0;
        private boolean busy = false;

        @Override
        public SetupFormats getClone(DeviceInterface di) {
            SelectorField sel = new SelectorField();
            sel.copyValues(this, di);
            return sel;
        }

        @Override
        protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
            super.copyValues(model, newDeviceInterface);
            this.controlNames = ((SelectorField)model).controlNames;
            this.emptySelection = ((SelectorField)model).emptySelection;
            this.expression = ((SelectorField)model).expression;
        }

        @Override
        protected void parseParamsList(List<String> paramsList) {
            boolean read = this.isTagPresent(SetupFormats.itemRead);
            for (String s : paramsList) {
                if ((s = s.trim()).length() <= 0) continue;
                if (!read && this.expression == null) {
                    this.expression = s;
                    continue;
                }
                int i = s.indexOf(32);
                if (i < 0) {
                    this.controlNames.put(s, "");
                    if (this.emptySelection != null) continue;
                    this.emptySelection = s;
                    continue;
                }
                this.controlNames.put(s.substring(0, i), s.substring(i + 1).trim());
                if (this.emptySelection != null) continue;
                this.emptySelection = s.substring(0, i);
            }
        }

        @Override
        public int getColumns() {
            int n = 1;
            for (String sel : this.controls.keySet()) {
                for (SetupFormats sf : this.controls.get(sel)) {
                    n = Math.max(n, sf.getColumns());
                }
            }
            return n;
        }

        private void addEmptyLable() {
            this.emptyLabel = new JLabel(this.name.replace("_", " "));
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = this.firstRow;
            c.gridwidth = 1;
            c.fill = 2;
            c.insets = new Insets(2, 2, 2, 2);
            this.panel.add((Component)this.emptyLabel, c);
        }

        @Override
        public int addGridBag(PopupSetupSelection form, JPanel panel, int inRow, int maxColumns) {
            this.form = form;
            this.firstRow = inRow;
            this.panel = panel;
            this.maxColumns = maxColumns;
            this.maxRows = 1;
            for (String sel : this.controls.keySet()) {
                List<SetupFormats> list = this.controls.get(sel);
                int n = list.size();
                for (SetupFormats sf : list) {
                    if (!(sf instanceof SelectorField)) continue;
                    n += sf.addGridBag(form, panel, inRow, maxColumns) - 1;
                }
                this.maxRows = Math.max(this.maxRows, n);
            }
            this.doSelect(this.emptySelection);
            this.selected = "???????????????????????????????";
            return this.maxRows;
        }

        private void calcSelectedSync() {
            if (this.expression != null) {
                return;
            }
            String s = "";
            if (this.read.isValid()) {
                s = this.read.writeRead().trim();
            }
            if (s.length() == 0) {
                s = this.emptySelection;
            }
            this.doSelect(s);
        }

        private void calcSelectEnable(Script script) {
            if (this.expression == null || this.busy) {
                return;
            }
            try {
                this.busy = true;
                String s = "";
                try {
                    s = script.expression(this.expression).asString();
                }
                catch (Exception exception) {}
                if (s.length() == 0) {
                    s = this.emptySelection;
                }
                this.doSelect(s);
                this.syncValue(script);
            }
            finally {
                this.busy = false;
            }
        }

        private void doSelect(String sel) {
            if (sel.equals(this.selected)) {
                return;
            }
            this.selected = sel;
            Support.PosCtlGridBagLayout gb = (Support.PosCtlGridBagLayout)this.panel.getLayout();
            int row = 0;
            while (row < this.maxRows) {
                int column = 0;
                while (column < this.maxColumns) {
                    Component comp = gb.getComponent(column, row + this.firstRow);
                    if (comp != null) {
                        this.panel.remove(comp);
                    }
                    ++column;
                }
                ++row;
            }
            List<SetupFormats> list = this.controls.get(this.selected);
            if (list != null) {
                int row2 = this.firstRow;
                for (SetupFormats sf : list) {
                    sf.addGridBag(this.form, this.panel, row2, this.maxColumns);
                    ++row2;
                }
            } else {
                this.addEmptyLable();
            }
            this.form.pack();
            this.form.repaint();
        }

        @Override
        protected void calcEnable(Script script) {
            this.calcSelectEnable(script);
            if (this.isTagParam(SetupFormats.itemEnable)) {
                this.setEnable(script.expression(this.getTag(SetupFormats.itemEnable)).asBoolean());
                return;
            }
            List<SetupFormats> list = this.controls.get(this.selected);
            if (list == null) {
                return;
            }
            for (SetupFormats sf : list) {
                sf.calcEnable(script);
            }
        }

        @Override
        protected List<SetupFormats> getControls(String name) {
            ArrayList<SetupFormats> valid = new ArrayList<SetupFormats>();
            List<SetupFormats> list = this.controls.get(this.selected);
            if (list == null) {
                return valid;
            }
            for (SetupFormats mode : list) {
                if (!mode.isEnabled() || !mode.isVisible() || !mode.pname().equals(name)) continue;
                valid.add(mode);
            }
            return valid;
        }

        @Override
        protected boolean isEnabled() {
            return true;
        }

        @Override
        protected boolean isVisible() {
            return true;
        }

        @Override
        protected void setEnable(boolean yes) {
            List<SetupFormats> list = this.controls.get(this.selected);
            if (list == null) {
                return;
            }
            for (SetupFormats sf : list) {
                sf.setEnable(yes);
            }
        }

        @Override
        protected void setStateVar(Script script) {
            List<SetupFormats> list = this.controls.get(this.selected);
            if (list == null) {
                return;
            }
            for (SetupFormats sf : list) {
                sf.setStateVar(script);
            }
        }

        @Override
        protected boolean hasTag(String tag) {
            return tag.equals(SetupFormats.itemEnable) || super.hasTag(tag);
        }

        @Override
        protected void setVisible(boolean yes) {
            this.setVisible(this.selected, yes);
        }

        private void setVisible(String sel, boolean yes) {
            List<SetupFormats> list = this.controls.get(sel);
            if (list == null) {
                return;
            }
            for (SetupFormats sf : list) {
                sf.setVisible(yes);
            }
        }

        @Override
        public void syncValue() {
            this.calcSelectedSync();
            List<SetupFormats> list = this.controls.get(this.selected);
            if (list == null) {
                return;
            }
            for (SetupFormats sf : list) {
                sf.syncValue();
            }
            if (this.script == null) {
                this.script = new Script();
                this.script.addLocalVar("handle", Var.createValue(this.deviceInterface.getHandleName()));
                this.script.addLocalVar("portType", Var.createValue(this.deviceInterface.dt.cPort.getPortType().name()));
            }
            this.setStateVar(this.script);
            this.calcEnable(this.script);
        }

        public void syncValue(Script script) {
            this.calcSelectedSync();
            List<SetupFormats> list = this.controls.get(this.selected);
            if (list == null) {
                return;
            }
            for (SetupFormats sf : list) {
                sf.syncValue();
            }
            this.setStateVar(script);
            this.calcEnable(script);
        }

        @Override
        public void syncValue(String name) {
            List<SetupFormats> list;
            if (name.equals(this.name)) {
                this.syncValue();
            }
            if ((list = this.controls.get(this.selected)) == null) {
                return;
            }
            for (SetupFormats sf : list) {
                sf.syncValue(name);
            }
        }
    }

    public static class SeparatorField
    extends SetupFormats {
        static final String typeName = "separator";
        private SeparatorPanel spanel = null;
        private int percent = 100;
        private int weight = 2;
        private SeparatorLineStyle style = SeparatorLineStyle.Solid;

        @Override
        public SetupFormats getClone(DeviceInterface di) {
            SeparatorField sf = new SeparatorField();
            sf.copyValues(this, di);
            return sf;
        }

        @Override
        protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
            super.copyValues(model, newDeviceInterface);
            this.weight = ((SeparatorField)model).weight;
            this.percent = ((SeparatorField)model).percent;
            this.style = ((SeparatorField)model).style;
        }

        @Override
        public int addGridBag(PopupSetupSelection form, JPanel panel, int inRow, int maxColumns) {
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = inRow;
            c.gridwidth = 999;
            c.anchor = 10;
            c.fill = 2;
            c.insets = new Insets(2, 2, 2, 2);
            c.weighty = 1.0;
            this.spanel = new SeparatorPanel();
            this.spanel.setLayout(new FlowLayout(0, 0, 0));
            this.spanel.color = this.getTagColor(SetupFormats.itemColor, SystemColor.windowText);
            this.spanel.setPreferredSize(new Dimension(30, this.weight + 4));
            panel.add((Component)this.spanel, c);
            return 1;
        }

        @Override
        public int getColumns() {
            return 1;
        }

        private SeparatorLineStyle getStyle(String s) {
            SeparatorLineStyle[] separatorLineStyleArray = SeparatorLineStyle.values();
            int n = separatorLineStyleArray.length;
            int n2 = 0;
            while (n2 < n) {
                SeparatorLineStyle sls = separatorLineStyleArray[n2];
                if (sls.name().equalsIgnoreCase(s)) {
                    return sls;
                }
                ++n2;
            }
            return SeparatorLineStyle.Solid;
        }

        @Override
        protected void parseParamsList(List<String> paramsList) {
            if (paramsList.size() == 0) {
                return;
            }
            String[] ss = paramsList.get(0).trim().split("[ ]+");
            if (ss.length < 2) {
                return;
            }
            this.weight = (int)StringUtil.parseDoubleEE(ss[0]);
            if (this.weight < 1) {
                this.weight = 1;
            }
            if (this.weight > 10) {
                this.weight = 10;
            }
            this.percent = (int)StringUtil.parseDoubleEE(ss[1]);
            if (this.percent < 5) {
                this.percent = 5;
            }
            if (this.percent > 100) {
                this.percent = 100;
            }
            if (ss.length >= 3) {
                this.style = this.getStyle(ss[2]);
            }
            if (this.style == SeparatorLineStyle.Sunken || this.style == SeparatorLineStyle.Raised) {
                this.weight = 2;
            }
            if (this.style == SeparatorLineStyle.Dual) {
                this.weight *= 4;
            }
        }

        private class SeparatorPanel
        extends JPanel {
            Color color;

            SeparatorPanel() {
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                int w = this.getWidth();
                int h = this.getHeight();
                switch (SeparatorField.this.style) {
                    case Solid: {
                        int dw = w * (100 - SeparatorField.this.percent) / 100;
                        g.setColor(this.color);
                        g.fillRect(dw / 2, h / 2, w - dw, SeparatorField.this.weight);
                        break;
                    }
                    case Dual: {
                        int dw = w * (100 - SeparatorField.this.percent) / 100;
                        int ww = SeparatorField.this.weight / 4;
                        g.setColor(this.color);
                        g.fillRect(dw / 2, (h - ww - ww - ww) / 2, w - dw, ww);
                        g.fillRect(dw / 2, (h + ww) / 2, w - dw, ww);
                        break;
                    }
                    case DashedShort: {
                        int dw;
                        int x0 = dw = w * (100 - SeparatorField.this.percent) / 200;
                        int dx = (w - dw * 2) / 20;
                        if (dx < 5) {
                            dx = 5;
                        }
                        g.setColor(this.color);
                        while (x0 < w - dw - 1) {
                            g.fillRect(x0, h / 2, dx, SeparatorField.this.weight);
                            x0 += dx * 2;
                        }
                        break;
                    }
                    case DashedLong: {
                        int dw;
                        int x0 = dw = w * (100 - SeparatorField.this.percent) / 200;
                        int dx = (w - dw * 2) / 5;
                        if (dx < 5) {
                            dx = 5;
                        }
                        g.setColor(this.color);
                        while (x0 < w - dw - 1) {
                            g.fillRect(x0, 2, dx, SeparatorField.this.weight);
                            x0 += dx * 2;
                        }
                        break;
                    }
                    case Sunken: {
                        int dw = w * (100 - SeparatorField.this.percent) / 200;
                        g.setColor(this.getBackground().darker());
                        g.drawLine(dw, h / 2, w - dw, h / 2);
                        g.setColor(this.getBackground().brighter());
                        g.drawLine(dw, h / 2 + 1, w - dw, h / 2 + 1);
                        break;
                    }
                    case Raised: {
                        int dw = w * (100 - SeparatorField.this.percent) / 200;
                        g.setColor(this.getBackground().brighter());
                        g.drawLine(dw, h / 2, w - dw, h / 2);
                        g.setColor(this.getBackground().darker());
                        g.drawLine(dw, h / 2 + 1, w - dw, h / 2 + 1);
                        break;
                    }
                }
            }
        }
    }

    static enum SeparatorLineStyle {
        Solid,
        Dual,
        DashedShort,
        DashedLong,
        Sunken,
        Raised,
        Empty;

    }

    public static class SetField
    extends SetupFormats
    implements ActionListener {
        static final String typeName = "set";
        protected JButton setButton;
        protected JLabel nameLabel;
        protected List<String> controls = new ArrayList<String>();
        protected String delimeter = "";

        @Override
        public SetupFormats getClone(DeviceInterface di) {
            SetField sf = new SetField();
            sf.copyValues(this, di);
            return sf;
        }

        @Override
        protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
            super.copyValues(model, newDeviceInterface);
            this.controls.addAll(((SetField)model).controls);
            this.delimeter = ((SetField)model).delimeter;
        }

        @Override
        protected void parseParamsList(List<String> paramsList) {
            String s;
            if (paramsList.size() > 0) {
                String[] stringArray = paramsList.get(0).split("[,; ]+");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    s = stringArray[n2];
                    this.controls.add(s);
                    ++n2;
                }
            }
            if (paramsList.size() > 1) {
                s = paramsList.get(1).trim();
                this.delimeter = StringUtil.decodeEscape(s);
            }
        }

        @Override
        public int getColumns() {
            return 3;
        }

        protected boolean validateTextField(JTextField f) {
            return true;
        }

        @Override
        protected void setEnable(boolean yes) {
            this.setButton.setEnabled(yes);
        }

        @Override
        protected void setVisible(boolean yes) {
            this.setButton.setVisible(yes);
            this.nameLabel.setVisible(yes);
        }

        @Override
        public int addGridBag(PopupSetupSelection form, JPanel panel, int inRow, int maxColumns) {
            this.form = form;
            this.nameLabel = new FontAdjust.FontLabel(String.valueOf(this.name.replace('_', ' ')) + ":");
            this.nameLabel.setToolTipText(this.getTag(SetupFormats.itemTip));
            this.setBGColor(this.nameLabel);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = inRow;
            c.anchor = 21;
            c.insets = new Insets(2, 2, 2, 2);
            c.weighty = 1.0;
            panel.add((Component)this.nameLabel, c);
            this.setButton = new FontAdjust.FontButton(this.getTag(SetupFormats.itemButtonText, "Set"));
            this.setButton.setToolTipText(this.getTag(SetupFormats.itemTip));
            this.setButton.addActionListener(this);
            this.setButton.setBackground(this.getTagColor(SetupFormats.itemColor, this.setButton.getBackground()));
            c = new GridBagConstraints();
            c.gridx = maxColumns - 1;
            c.gridy = inRow;
            c.fill = 2;
            c.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)this.setButton, c);
            return 1;
        }

        public void initControls() {
            for (SetupFormats m : this.getSetupFormats()) {
                m.collectEnable();
            }
        }

        private List<SetupFormats> getSetupFormats() {
            ArrayList<SetupFormats> setupFormats = new ArrayList<SetupFormats>();
            for (String n : this.controls) {
                for (SetupFormats m : this.getControls(n)) {
                    if (!m.isVisible() || !m.isEnabled()) continue;
                    setupFormats.add(m);
                }
            }
            return setupFormats;
        }

        public void syncValuexxx() {
            if (this.read.isValid()) {
                String string = this.read.writeRead();
            }
        }

        public void localWrite() {
            List<SetupFormats> setupFormats = this.getSetupFormats();
            for (SetupFormats m : setupFormats) {
                if (m.isValid()) continue;
                return;
            }
            StringBuilder sb = new StringBuilder();
            for (SetupFormats m : setupFormats) {
                sb.append(m.collectWrite());
                sb.append(this.delimeter);
            }
            if (sb.length() > 0) {
                this.write.write(sb.toString());
            }
            boolean clearCache = true;
            for (SetupFormats m : setupFormats) {
                m.requestSync(clearCache);
                clearCache = false;
            }
        }

        @Override
        protected void setStateVar(Script script) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.localWrite();
        }
    }

    public static class SliderField
    extends FieldWithLabelDualValue
    implements ChangeListener {
        static final String typeName = "slider";
        NumberSetting setting = new NumberSetting();
        private JSlider slider = null;
        private JLabel label = null;

        @Override
        public SetupFormats getClone(DeviceInterface di) {
            SliderField nf = new SliderField();
            nf.copyValues(this, di);
            return nf;
        }

        @Override
        protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
            super.copyValues(model, newDeviceInterface);
            this.setting = ((SliderField)model).setting;
        }

        @Override
        protected void parseParamsList(List<String> paramsList) {
            super.parseParamsList(paramsList);
            this.setting.parse((LabelDualValue)this.labelValues.get(0));
        }

        @Override
        public int getColumns() {
            return 2;
        }

        @Override
        public int addGridBag(PopupSetupSelection form, JPanel panel, int inRow, int maxColumns) {
            this.form = form;
            LabelDualValue cfr_ignored_0 = (LabelDualValue)this.labelValues.get(0);
            this.label = new FontAdjust.FontLabel(String.valueOf(this.name.replace('_', ' ')) + ":");
            this.label.setToolTipText(this.getTag(SetupFormats.itemTip));
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = inRow;
            c.anchor = 21;
            c.insets = new Insets(2, 2, 2, 2);
            c.weighty = 1.0;
            panel.add((Component)this.label, c);
            this.setting.min = Math.round(this.setting.min);
            this.setting.max = Math.round(this.setting.max);
            this.slider = new JSlider((int)this.setting.min, (int)this.setting.max);
            this.slider.addChangeListener(this);
            this.slider.setToolTipText(this.getTag(SetupFormats.itemTip));
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = inRow;
            c.gridwidth = maxColumns - 1;
            c.fill = 2;
            c.anchor = 21;
            c.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)this.slider, c);
            this.label = new FontAdjust.FontLabel(this.setting.unit.replace('_', ' '));
            this.adjustLabelFormat(this.label);
            this.label.setToolTipText(this.getTag(SetupFormats.itemTip));
            c = new GridBagConstraints();
            c.gridx = 2 + (maxColumns > 5 ? 1 : 0);
            c.gridy = inRow;
            panel.add((Component)this.label, c);
            return 1;
        }

        @Override
        protected void setEnable(boolean yes) {
            this.slider.setEnabled(yes);
        }

        @Override
        protected void setVisible(boolean yes) {
            this.slider.setVisible(yes);
            this.label.setVisible(yes);
        }

        @Override
        public void syncValue() {
            if (this.read.isValid()) {
                int v = (int)this.read.readNumber();
                this.currentValue = v;
                this.slider.setValue(v);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.write.write(Integer.toString(this.slider.getValue()));
            this.requestSync();
        }
    }

    public static class TextField
    extends SetupFormats
    implements ActionListener {
        static final String typeName = "text";
        protected JButton setButton;
        protected JLabel nameLabel;
        protected JTextField inputTextField = null;
        protected String lastValue = "";
        protected int maxTextLength = 1000;

        @Override
        public SetupFormats getClone(DeviceInterface di) {
            TextField tf = new TextField();
            tf.copyValues(this, di);
            return tf;
        }

        @Override
        protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
            super.copyValues(model, newDeviceInterface);
            ((TextField)model).maxTextLength = this.maxTextLength;
        }

        @Override
        protected void parseParamsList(List<String> paramsList) {
            if (paramsList.size() > 0) {
                this.maxTextLength = StringUtil.parseInt(paramsList.get(0));
            }
        }

        @Override
        public int getColumns() {
            return 3;
        }

        protected boolean validateTextField(JTextField f) {
            String s = this.inputTextField.getText().trim();
            if (s != null && s.length() > this.maxTextLength) {
                this.inputTextField.setBackground(Support.colorScheme.errorBackground);
                return false;
            }
            this.inputTextField.setBackground(s.equals(this.lastValue) ? Support.colorScheme.textBackground : Support.colorScheme.changedBackground);
            return true;
        }

        @Override
        protected boolean isEnabled() {
            return this.inputTextField == null ? false : this.inputTextField.isEnabled();
        }

        @Override
        protected boolean isVisible() {
            return this.inputTextField == null ? false : this.inputTextField.isVisible();
        }

        @Override
        protected void setEnable(boolean yes) {
            this.inputTextField.setEnabled(yes);
            this.setButton.setEnabled(yes);
        }

        @Override
        protected void setVisible(boolean yes) {
            this.inputTextField.setVisible(yes);
            this.setButton.setVisible(yes);
            this.nameLabel.setVisible(yes);
        }

        @Override
        public int addGridBag(PopupSetupSelection form, JPanel panel, int inRow, int maxColumns) {
            this.form = form;
            this.nameLabel = new FontAdjust.FontLabel(String.valueOf(this.name.replace('_', ' ')) + ":");
            this.nameLabel.setToolTipText(this.getTag(SetupFormats.itemTip));
            this.setBGColor(this.nameLabel);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = inRow;
            c.anchor = 21;
            c.insets = new Insets(2, 2, 2, 2);
            c.weighty = 1.0;
            panel.add((Component)this.nameLabel, c);
            this.inputTextField = new Support.MyTextField(this.getTagInt(SetupFormats.itemTextWidth, 6));
            this.inputTextField.setToolTipText(this.getTag(SetupFormats.itemTip));
            this.setBGColor(this.inputTextField);
            this.inputTextField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent arg0) {
                    inputTextField.selectAll();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    this.validateTextField(inputTextField);
                }
            });
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = inRow;
            c.gridwidth = maxColumns - 2;
            c.fill = 2;
            c.anchor = 21;
            c.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)this.inputTextField, c);
            this.setButton = new FontAdjust.FontButton(this.getTag(SetupFormats.itemButtonText, "Set"));
            this.setButton.setToolTipText(this.getTag(SetupFormats.itemTip));
            this.setButton.addActionListener(this);
            this.setButton.setBackground(this.getTagColor(SetupFormats.itemColor, this.setButton.getBackground()));
            c = new GridBagConstraints();
            c.gridx = maxColumns - 1;
            c.gridy = inRow;
            c.fill = 2;
            c.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)this.setButton, c);
            return 1;
        }

        @Override
        public void syncValue() {
            String s;
            if (this.read.isValid() && (s = this.read.writeRead()) != null) {
                this.inputTextField.setText(StringUtil.unQuote(s));
                this.lastValue = this.inputTextField.getText();
                this.validateTextField(this.inputTextField);
            }
        }

        @Override
        public boolean collectEnable() {
            if (this.setButton != null) {
                this.write.enableCollect(true);
                this.setButton.setText("");
                this.setButton.setEnabled(false);
                this.setButton.setIcon(IconGenerator.makeIcon(IconGenerator.IconType.X));
                return true;
            }
            return false;
        }

        @Override
        public String collectWrite() {
            this.write.clearCollect();
            this.localWrite();
            return this.write.getCollected();
        }

        @Override
        protected void setStateVar(Script script) {
            this.setScriptValue(script, this.name, this.currentValue);
        }

        private void localWrite() {
            this.lastValue = this.inputTextField.getText().trim();
            this.currentValue = this.lastValue;
            this.write.write(this.lastValue);
        }

        @Override
        public boolean isValid() {
            return this.validateTextField(this.inputTextField);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isValid()) {
                this.localWrite();
                this.requestSync();
                this.validateTextField(this.inputTextField);
            }
        }
    }

    public static class TextQField
    extends TextField
    implements ActionListener {
        static final String typeName = "textQ";

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.validateTextField(this.inputTextField)) {
                this.lastValue = this.inputTextField.getText().trim();
                this.currentValue = this.lastValue;
                this.write.write("\"" + this.lastValue + "\"");
                this.requestSync();
                this.validateTextField(this.inputTextField);
            }
        }
    }

    public static class UpdaterField
    extends SetupFormats
    implements ActionListener {
        static final String typeName = "updater";
        private Timer timer = null;
        private int time = 0;

        @Override
        public SetupFormats getClone(DeviceInterface di) {
            UpdaterField nf = new UpdaterField();
            nf.copyValues(this, di);
            return nf;
        }

        @Override
        protected void copyValues(SetupFormats model, DeviceInterface newDeviceInterface) {
            super.copyValues(model, newDeviceInterface);
            this.time = ((UpdaterField)model).time;
        }

        @Override
        public int getColumns() {
            return 0;
        }

        @Override
        public int addGridBag(PopupSetupSelection form, JPanel panel, int inRow, int maxColumns) {
            this.form = form;
            this.timer = new Timer(this.time, this);
            this.timer.start();
            return 0;
        }

        @Override
        protected void parseParamsList(List<String> paramsList) {
            this.time = (int)(StringUtil.parseDoubleEE(paramsList.get(0)) * 1000.0);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (this.form != null && this.form.isVisible()) {
                this.requestSync();
            } else {
                this.timer.stop();
                this.timer = null;
            }
        }
    }
}

