/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.database.ScriptFunctions;
import dk.hkj.devices.DeviceSCPI;
import dk.hkj.main.CommandProcessor;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.Main;
import dk.hkj.main.PopupImage;
import dk.hkj.main.PopupVarDisplay;
import dk.hkj.main.SCPICommand;
import dk.hkj.main.Support;
import dk.hkj.script.Functions;
import dk.hkj.script.ProgramExceptions;
import dk.hkj.script.Script;
import dk.hkj.util.StringUtil;
import dk.hkj.vars.FormatVar;
import dk.hkj.vars.Var;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;

public class ScriptInterface {
    static final String ParamChannel = "(channel)";
    static final String ParamValue = "(value)";
    static final String setParamsHelp = "device,value";
    static final String getParamsHelp = "device";
    private ScriptFunctions scriptFunctions = null;
    static Var displayVarValue = null;

    public void tableChange() {
        if (this.scriptFunctions != null) {
            this.scriptFunctions.tableChanged();
        }
    }

    public void init() {
        Functions.removeAll();
        Functions.addAll();
        this.addFunctions();
        ScriptFunctions.get().addFunctions();
        CommandProcessor.addFunctions();
        this.addBasicFunctions();
        HashSet<String> functions = new HashSet<String>();
        for (InterfaceThreads.DeviceThread device : InterfaceThreads.getDevices()) {
            DeviceInterface di = device.getDeviceInterface();
            functions.addAll(di.getIFaces().keySet());
        }
        for (String s : functions) {
            if (s.startsWith("set")) {
                Functions.gf().add(new SetFunction(s));
                continue;
            }
            if (s.startsWith("get")) {
                Functions.gf().add(new GetFunction(s));
                continue;
            }
            if (!s.startsWith("read")) continue;
            Functions.gf().add(new ReadFunction(s));
            Functions.gf().add(new NameFunction("name" + s.substring(4)));
            Functions.gf().add(new UnitFunction("unit" + s.substring(4)));
        }
    }

    public void addBasicFunctions() {
        Functions.gf().add(new Functions.Func("displayVar"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    1.invalidNumberOfParams(script, "invalidValueType(-1,0,1)");
                }
                displayVarValue = params.get(0);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (!PopupVarDisplay.isPopupVisible()) {
                                Point p = Main.main.frame.getLocationOnScreen();
                                p.y -= 100;
                                if (p.y < 0) {
                                    p.y = 0;
                                }
                                new PopupVarDisplay(p);
                            }
                            PopupVarDisplay.showVar(FormatVar.getDefault().formatVarAsList(displayVarValue));
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.out);
                        }
                    }
                });
                return params.get(0);
            }
        });
        Functions.gf().add(new Functions.Func("addImage"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    2.invalidNumberOfParams(script, "image,name");
                }
                byte[] b = params.get(0).asBytes();
                final String name = params.get(1).asString();
                ByteArrayInputStream bis = new ByteArrayInputStream(b);
                try {
                    final BufferedImage img = ImageIO.read(bis);
                    if (img != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                PopupImage pi = PopupImage.getPopup();
                                pi.setShowFirstLoaded();
                                pi.addImage(img, "", name, true);
                                pi.showDefault(false);
                            }
                        });
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("isDeviceMode"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    3.invalidNumberOfParams(script, "device,mode");
                }
                String deviceName = params.get(0).asString();
                DeviceInterface di = ScriptInterface.this.findDeviceInterface(script, deviceName);
                return Var.createValue(di.modeActive(params.get(1).asString().trim()));
            }
        });
        Functions.gf().add(new Functions.Func("deviceMode"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    4.invalidNumberOfParams(script, ScriptInterface.getParamsHelp);
                }
                String deviceName = params.get(0).asString();
                DeviceInterface di = ScriptInterface.this.findDeviceInterface(script, deviceName);
                return Var.createValue(di.getCurrentModes());
            }
        });
        Functions.gf().add(new Functions.Func("modeColumnNames"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2) {
                    5.invalidNumberOfParams(script, "device,mode");
                }
                String deviceName = params.get(0).asString();
                DeviceInterface di = ScriptInterface.this.findDeviceInterface(script, deviceName);
                List<String> columns = di.getValueNames(params.get(1).asString());
                StringBuilder sb = new StringBuilder();
                for (String s : columns) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(s);
                }
                return Var.createValue(sb.toString());
            }
        });
        Functions.gf().add(new Functions.Func("hiokiValue"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    6.invalidNumberOfParams(script, "answer");
                }
                String ss = params.get(0).asString();
                int i = ss.indexOf(32);
                int j = ss.indexOf(44);
                double v = Integer.parseInt(ss.substring(0, i));
                String mode = ss.substring(i + 1, j);
                String range = ss.substring(j + 1);
                if (v >= 1999999.0) {
                    return Var.createValue(Double.NaN);
                }
                if (v >= 999999.0) {
                    return Var.createValue(Double.POSITIVE_INFINITY);
                }
                if (mode.equals("CAP")) {
                    if (range.equals("1n")) {
                        v *= 1.0E-12;
                    } else if (range.equals("10n")) {
                        v *= 1.0E-11;
                    } else if (range.equals("100n")) {
                        v *= 1.0E-10;
                    } else if (range.equals("1u")) {
                        v *= 1.0E-9;
                    } else if (range.equals("10u")) {
                        v *= 1.0E-8;
                    } else if (range.equals("100u")) {
                        v *= 1.0E-7;
                    } else if (range.equals("1m")) {
                        v *= 1.0E-6;
                    } else if (range.equals("10m")) {
                        v *= 1.0E-5;
                    } else if (range.equals("100m")) {
                        v *= 1.0E-4;
                    }
                } else if (mode.equals("DIODE")) {
                    v *= 0.001;
                } else if (mode.equals("CONT")) {
                    v *= 0.1;
                } else if (mode.equals("dBV")) {
                    v *= 0.01;
                } else if (mode.equals("nS")) {
                    v *= 1.0E-11;
                } else if (mode.equals("TEMP")) {
                    v *= 0.1;
                } else if (mode.equals("FREQ")) {
                    if (range.equals("10")) {
                        v *= 1.0E-4;
                    } else if (range.equals("100")) {
                        v *= 0.001;
                    } else if (range.equals("1k")) {
                        v *= 0.01;
                    } else if (range.equals("10k")) {
                        v *= 0.1;
                    } else if (range.equals("100k")) {
                        v *= 1.0;
                    } else if (range.equals("1000k")) {
                        v *= 10.0;
                    }
                } else if (range.equals("600u")) {
                    v *= 1.0E-8;
                } else if (range.equals("6000u")) {
                    v *= 1.0E-7;
                } else if (range.equals("60m")) {
                    v *= 1.0E-6;
                } else if (range.equals("600m")) {
                    v *= 1.0E-5;
                } else if (range.equals("6")) {
                    v *= 1.0E-4;
                } else if (range.equals("60")) {
                    v *= 0.001;
                } else if (range.equals("600")) {
                    v *= 0.01;
                } else if (range.equals("1000")) {
                    v *= 0.1;
                } else if (range.equals("6k")) {
                    v *= 0.1;
                } else if (range.equals("60k")) {
                    v *= 1.0;
                } else if (range.equals("600k")) {
                    v *= 10.0;
                } else if (range.equals("6M")) {
                    v *= 100.0;
                } else if (range.equals("60M")) {
                    v *= 10000.0;
                } else if (range.equals("600M")) {
                    v *= 100000.0;
                }
                return Var.createValue(v);
            }
        });
        Functions.gf().add(new Functions.Func("keysightU125xALog"){

            @Override
            public Var execute(Script script, List<Var> params) {
                String line = null;
                boolean asColumnName = false;
                switch (params.size()) {
                    case 1: {
                        line = StringUtil.unQuote(params.get(0).asString());
                        break;
                    }
                    case 2: {
                        line = StringUtil.unQuote(params.get(0).asString());
                        asColumnName = params.get(1).asBoolean();
                        break;
                    }
                    default: {
                        7.invalidNumberOfParams(script, "answer,asColumnName");
                    }
                }
                if (line.length() != 13) {
                    throw new ProgramExceptions.UnknownValueException(script, "Argument do not match Keysight U125xA log entry");
                }
                int mode = Integer.parseInt(line.substring(0, 2));
                double scale = 1.0;
                String column = "";
                int modeBits0 = Integer.parseInt(line.substring(7, 8));
                int modeBits1 = Integer.parseInt(line.substring(8, 9));
                int modeBits2 = Integer.parseInt(line.substring(10, 11));
                switch (mode) {
                    case 0: {
                        scale = 1.0E-6;
                        column = "Voltage";
                        break;
                    }
                    case 1: {
                        scale = 1.0E-4;
                        column = "Voltage";
                        break;
                    }
                    case 2: {
                        scale = 1.0E-8;
                        column = "Current";
                        break;
                    }
                    case 3: {
                        scale = 1.0E-6;
                        column = "Current";
                        break;
                    }
                    case 5: {
                        scale = 0.01;
                        column = "Resistance";
                        if ((modeBits0 & 1) == 0) break;
                        scale = 1.0E-18;
                        column = "Conductance";
                        break;
                    }
                    case 6: {
                        scale = 1.0E-4;
                        column = "Voltage";
                        break;
                    }
                    case 7: {
                        scale = 0.1;
                        column = "Temperature";
                        break;
                    }
                    case 8: {
                        scale = 1.0E-12;
                        column = "Capacitance";
                        break;
                    }
                    case 9: {
                        scale = 0.001;
                        column = "Frequency";
                        break;
                    }
                    case 10: {
                        scale = 1.0E-4;
                        column = "DutyCycle";
                        break;
                    }
                    case 11: {
                        scale = 1.0E-5;
                        column = "PulseWidth";
                        break;
                    }
                    case 13: {
                        scale = 0.01;
                        column = (modeBits2 & 1) == 0 ? "Decibel_m" : "Decibel_V";
                        modeBits1 &= 0xFFFFFFFC;
                        break;
                    }
                    case 14: {
                        scale = 0.01;
                        column = (modeBits2 & 1) == 0 ? "4-20mA" : "0-20mA";
                        modeBits1 &= 0xFFFFFFFC;
                        break;
                    }
                    default: {
                        scale = 1.0;
                        column = "unknown";
                    }
                }
                int exp = Integer.parseInt(line.substring(9, 10));
                double v = (double)Integer.parseInt(line.substring(2, 7)) * scale * Math.pow(10.0, exp);
                if ((modeBits1 & 4) != 0) {
                    v = Double.POSITIVE_INFINITY;
                }
                if ((modeBits0 & 2) != 0) {
                    v = -v;
                }
                if (mode == 6 && (modeBits2 & 1) != 0) {
                    v = (v - 32.0) * 5.0 / 9.0;
                }
                if (asColumnName) {
                    if ((modeBits1 & 2) != 0) {
                        column = String.valueOf(column) + "AC";
                    }
                    if ((modeBits1 & 1) != 0) {
                        column = String.valueOf(column) + "DC";
                    }
                    return Var.createValue(column);
                }
                return Var.createValue(v);
            }
        });
        Functions.gf().add(new Functions.Func("keysightU128xALog"){

            @Override
            public Var execute(Script script, List<Var> params) {
                String line = null;
                boolean asColumnName = false;
                switch (params.size()) {
                    case 1: {
                        line = StringUtil.unQuote(params.get(0).asString());
                        break;
                    }
                    case 2: {
                        line = StringUtil.unQuote(params.get(0).asString());
                        asColumnName = params.get(1).asBoolean();
                        break;
                    }
                    default: {
                        8.invalidNumberOfParams(script, "answer,asColumnName");
                    }
                }
                if (line.length() != 14) {
                    throw new ProgramExceptions.UnknownValueException(script, "Argument do not match Keysight U128xA log entry");
                }
                int mode = Integer.parseInt(line.substring(0, 2));
                double scale = 1.0;
                String column = "";
                int modeBits0 = Integer.parseInt(line.substring(7, 8));
                int modeBits1 = Integer.parseInt(line.substring(8, 9));
                int modeBits2 = Integer.parseInt(line.substring(10, 11));
                switch (mode) {
                    case 0: {
                        scale = 1.0E-6;
                        column = "Voltage";
                        break;
                    }
                    case 1: {
                        scale = 1.0E-4;
                        column = "Voltage";
                        break;
                    }
                    case 2: {
                        scale = 1.0E-9;
                        column = "Current";
                        break;
                    }
                    case 3: {
                        scale = 1.0E-4;
                        column = "Current";
                        break;
                    }
                    case 4: {
                        scale = 0.001;
                        column = "Resistance";
                        break;
                    }
                    case 5: {
                        scale = 1.0E-4;
                        column = "Voltage";
                        break;
                    }
                    case 6: {
                        scale = 0.1;
                        column = "Temperature";
                        break;
                    }
                    case 7: {
                        scale = 1.0E-12;
                        column = "Capacitance";
                        break;
                    }
                    case 8: {
                        scale = 0.001;
                        column = "Frequency";
                        break;
                    }
                    case 9: {
                        scale = 0.001;
                        column = "DutyCycle";
                        break;
                    }
                    case 10: {
                        scale = 1.0E-6;
                        column = "PulseWidth";
                        break;
                    }
                    case 11: {
                        scale = 0.001;
                        column = (modeBits2 & 1) == 0 ? "Decibel_m" : "Decibel_V";
                        modeBits1 &= 0xFFFFFFFC;
                        break;
                    }
                    case 12: {
                        scale = 0.01;
                        column = (modeBits2 & 1) == 0 ? "4-20mA" : "0-20mA";
                        modeBits1 &= 0xFFFFFFFC;
                        break;
                    }
                    case 13: {
                        scale = 1.0E-11;
                        column = "Conductance";
                        break;
                    }
                    default: {
                        scale = 1.0;
                        column = "unknown";
                    }
                }
                int exp = Integer.parseInt(line.substring(9, 10));
                double v = (double)Integer.parseInt(line.substring(2, 7)) * scale * Math.pow(10.0, exp);
                if ((modeBits1 & 4) != 0) {
                    v = Double.POSITIVE_INFINITY;
                }
                if ((modeBits0 & 2) != 0) {
                    v = -v;
                }
                if (mode == 6 && (modeBits2 & 1) != 0) {
                    v = (v - 32.0) * 5.0 / 9.0;
                }
                if (asColumnName) {
                    if ((modeBits1 & 2) != 0) {
                        column = String.valueOf(column) + "AC";
                    }
                    if ((modeBits1 & 1) != 0) {
                        column = String.valueOf(column) + "DC";
                    }
                    return Var.createValue(column);
                }
                return Var.createValue(v);
            }
        });
    }

    private void addFunctions() {
        Functions.gf().add(new Functions.Func("deviceWrite"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() < 2) {
                    9.invalidNumberOfParams(script, "device,string,...");
                }
                StringBuilder sb = new StringBuilder();
                int i = 1;
                while (i < params.size()) {
                    sb.append(params.get(i).asString());
                    ++i;
                }
                String deviceName = params.get(0).asString();
                DeviceInterface di = ScriptInterface.this.findDeviceInterface(script, deviceName);
                di.doCommand(sb.toString());
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("deviceRead"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() < 2) {
                    10.invalidNumberOfParams(script, "device,string,...");
                }
                StringBuilder sb = new StringBuilder();
                int i = 1;
                while (i < params.size()) {
                    sb.append(params.get(i).asString());
                    ++i;
                }
                String deviceName = params.get(0).asString();
                DeviceInterface di = ScriptInterface.this.findDeviceInterface(script, deviceName);
                return Var.createValue(di.doCommand(sb.toString().trim()));
            }
        });
        Functions.gf().add(new Functions.Func("deviceReadBytes"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() < 2) {
                    11.invalidNumberOfParams(script, "device,string,...");
                }
                StringBuilder sb = new StringBuilder();
                int i = 1;
                while (i < params.size()) {
                    sb.append(params.get(i).asString());
                    ++i;
                }
                String deviceName = params.get(0).asString();
                DeviceInterface di = ScriptInterface.this.findDeviceInterface(script, deviceName);
                if (di instanceof DeviceSCPI) {
                    byte[] b = ((DeviceSCPI)di).dt.cPort.readSCPIBinary(sb.toString().trim());
                    return Var.createValue(b);
                }
                return Var.createValue(new byte[0]);
            }
        });
        Functions.gf().add(new Functions.Func("deviceWriteBytes,..."){

            @Override
            public Var execute(Script script, List<Var> params) {
                DeviceInterface di;
                String data;
                if (params.size() < 3 || params.size() > 4) {
                    12.invalidNumberOfParams(script, "device,cmd,data{,eol}");
                }
                String deviceName = params.get(0).asString();
                String cmd = params.get(1).asString();
                try {
                    data = new String(params.get(2).asBytes(), "ISO-8859-1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    data = params.get(2).asString();
                }
                StringBuilder sb = new StringBuilder();
                sb.append(cmd);
                if (cmd.length() > 0 && !cmd.endsWith(" ")) {
                    sb.append(" ");
                }
                sb.append("#");
                String sz = Integer.toString(data.length());
                sb.append(sz.length());
                sb.append(sz);
                sb.append(data);
                if (params.size() == 4) {
                    sb.append(StringUtil.decodeEscape(params.get(3).asString()));
                }
                if ((di = ScriptInterface.this.findDeviceInterface(script, deviceName)) instanceof DeviceSCPI) {
                    ((DeviceSCPI)di).dt.cPort.debugLog = InterfaceThreads.debugAll;
                    ((DeviceSCPI)di).dt.cPort.writeBin(sb.toString());
                    return null;
                }
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("getDevice"){

            @Override
            public Var execute(Script script, List<Var> params) {
                String deviceType;
                if (params.size() != 1) {
                    13.invalidNumberOfParams(script, "deviceType");
                }
                if ((deviceType = params.get(0).asString().trim()).contains("*")) {
                    deviceType = deviceType.replace("*", "").replace("+", "");
                    Var v = Var.createArray();
                    for (InterfaceThreads.DeviceThread dt : InterfaceThreads.getDevices()) {
                        String[] deviceTypes = dt.getDeviceInterface().getIFaceTypes();
                        if (deviceTypes == null || deviceTypes.length <= 0) continue;
                        String[] stringArray = deviceTypes;
                        int n = deviceTypes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String device;
                            String t = stringArray[n2];
                            if (ScriptInterface.removeChannelNo(t).equalsIgnoreCase(deviceType)) {
                                device = ScriptInterface.addChannelNo(dt.getDeviceInterface().getHandleName(), ScriptInterface.getChannelNo(t));
                                v.addVar(Var.createValue(device));
                            } else if (t.equalsIgnoreCase(deviceType) || t.indexOf(58) < 0 && (String.valueOf(t) + ":1").equalsIgnoreCase(deviceType)) {
                                device = ScriptInterface.addChannelNo(dt.getDeviceInterface().getHandleName(), ScriptInterface.getChannelNo(t));
                                v.addVar(Var.createValue(device));
                            }
                            ++n2;
                        }
                    }
                    return v;
                }
                int n = 0;
                while (deviceType.startsWith("+")) {
                    ++n;
                    deviceType = deviceType.substring(1);
                }
                if (deviceType.indexOf(58) > 0) {
                    String device = "";
                    for (InterfaceThreads.DeviceThread dt : InterfaceThreads.getDevices()) {
                        String[] deviceTypes = dt.getDeviceInterface().getIFaceTypes();
                        if (deviceTypes == null || deviceTypes.length <= 0) continue;
                        String[] stringArray = deviceTypes;
                        int n3 = deviceTypes.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String t = stringArray[n4];
                            if (t.equalsIgnoreCase(deviceType) || ScriptInterface.getChannelNo(t) == 1 && ScriptInterface.getChannelNo(deviceType) == 1 && t.equalsIgnoreCase(ScriptInterface.removeChannelNo(deviceType))) {
                                if (n == 0) {
                                    device = ScriptInterface.addChannelNo(dt.getDeviceInterface().getHandleName(), ScriptInterface.getChannelNo(t));
                                    return Var.createValue(device);
                                }
                                --n;
                            }
                            ++n4;
                        }
                    }
                } else {
                    String device = "";
                    for (InterfaceThreads.DeviceThread dt : InterfaceThreads.getDevices()) {
                        String[] deviceTypes = dt.getDeviceInterface().getIFaceTypes();
                        if (deviceTypes == null || deviceTypes.length <= 0) continue;
                        String[] stringArray = deviceTypes;
                        int n5 = deviceTypes.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            String t = stringArray[n6];
                            if (ScriptInterface.removeChannelNo(t).equalsIgnoreCase(deviceType)) {
                                if (n == 0) {
                                    device = ScriptInterface.addChannelNo(dt.getDeviceInterface().getHandleName(), ScriptInterface.getChannelNo(t));
                                    return Var.createValue(device);
                                }
                                --n;
                            }
                            ++n6;
                        }
                    }
                }
                return new Var();
            }
        });
    }

    protected static int getChannelNo(String device) {
        int i = device.indexOf(58);
        try {
            if (i > 0) {
                return StringUtil.parseInt(device.substring(i + 1));
            }
        }
        catch (Exception exception) {}
        return 1;
    }

    protected static String addChannelNo(String device, int no) {
        if (no <= 1) {
            return ScriptInterface.removeChannelNo(device);
        }
        return String.valueOf(ScriptInterface.removeChannelNo(device)) + ":" + no;
    }

    protected static String removeChannelNo(String device) {
        int i = device.indexOf(58);
        if (i > 0) {
            return device.substring(0, i);
        }
        return device;
    }

    private DeviceInterface findDeviceInterface(Script script, String name) {
        InterfaceThreads.DeviceThread dt = InterfaceThreads.deviceMap.get(name.toUpperCase());
        if (dt != null) {
            return dt.getDeviceInterface();
        }
        throw new ProgramExceptions.UnknownException(script, "Device not found " + name);
    }

    class GetFunction
    extends Functions.Func {
        public GetFunction(String name) {
            super(name);
        }

        @Override
        public Var execute(Script script, List<Var> params) {
            if (params.size() != 1) {
                GetFunction.invalidNumberOfParams(script, ScriptInterface.getParamsHelp);
            }
            ParseCommand pc = new ParseCommand(false, this.name, script, params);
            return pc.getCommand();
        }
    }

    class NameFunction
    extends Functions.Func {
        public NameFunction(String name) {
            super(name);
        }

        @Override
        public Var execute(Script script, List<Var> params) {
            if (params.size() != 1) {
                NameFunction.invalidNumberOfParams(script, ScriptInterface.getParamsHelp);
            }
            ParseCommand pc = new ParseCommand(false, this.name, script, params);
            return pc.nameCommand();
        }
    }

    private class ParseCommand {
        String deviceName = "";
        DeviceInterface di = null;
        String cmd = "";
        String value = "";
        String channel = "1";
        boolean stringResult = false;

        ParseCommand(boolean set, String funcName, Script script, List<Var> params) {
            this.deviceName = params.get(0).asString();
            int i = this.deviceName.indexOf(58);
            if (i > 0) {
                this.channel = this.deviceName.substring(i + 1).trim();
                this.deviceName = this.deviceName.substring(0, i);
            }
            this.di = ScriptInterface.this.findDeviceInterface(script, this.deviceName);
            if (funcName.startsWith("name")) {
                funcName = "read" + funcName.substring(4);
            }
            if (funcName.startsWith("unit")) {
                funcName = "read" + funcName.substring(4);
            }
            this.cmd = this.di.getIFace(funcName);
            if (this.cmd == null) {
                throw new ProgramExceptions.UnknownFunctionException(script, "Interface function (" + funcName + ") not defined for this device (" + this.deviceName + ")");
            }
            if (set) {
                this.value = params.get(1).asString();
            }
        }

        private boolean replace(String item, String value) {
            int i = this.cmd.indexOf(item);
            if (i >= 0) {
                this.cmd = String.valueOf(this.cmd.substring(0, i)) + value + this.cmd.substring(i + item.length());
                return true;
            }
            return false;
        }

        private void replaceScript() {
            Script script = new Script();
            script.addLocalVar("value", Var.createValue(this.value));
            script.addLocalVar("channel", Var.createValue(this.channel));
            this.cmd = Support.processScriptInBrackets(script, this.cmd);
        }

        void setCommand() {
            if (this.cmd.equals("[SETMODE]")) {
                this.di.setupMode(this.value, true);
                return;
            }
            this.replace(ScriptInterface.ParamChannel, this.channel);
            if (!this.replace(ScriptInterface.ParamValue, this.value)) {
                this.replaceScript();
            }
            this.di.doCommand(this.cmd);
        }

        Var getCommand() {
            if (this.cmd.equals("[GETMODE]")) {
                return Var.createValue(this.di.getMode());
            }
            String[] cmds = this.cmd.split("[\n]");
            String readFormat = "";
            String readMath = "";
            if (cmds.length > 1) {
                StringBuilder sb = new StringBuilder();
                String[] stringArray = cmds;
                int n = cmds.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if ((s = s.trim()).toLowerCase().startsWith(":readformat:".toLowerCase())) {
                        readFormat = s.substring(":readformat:".length()).trim();
                    } else if (s.toLowerCase().startsWith(":readmath:".toLowerCase())) {
                        readMath = s.substring(":readmath:".length()).trim();
                    } else if (s.toLowerCase().startsWith(":string:".toLowerCase())) {
                        this.stringResult = true;
                    } else {
                        sb.append(s);
                        sb.append("\n");
                    }
                    ++n2;
                }
                this.cmd = sb.toString().trim();
            }
            this.replace(ScriptInterface.ParamChannel, this.channel);
            SCPICommand scpiCmd = this.di.getCommand(this.cmd, readMath, readFormat);
            this.di.getScript().addLocalVar("channel", Var.createValue(this.channel));
            if (this.stringResult) {
                return Var.createValue(scpiCmd.writeRead());
            }
            return Var.createValue(scpiCmd.readNumber());
        }

        Var readCommand() {
            String[] cmds = this.cmd.split("\n");
            String decodeMath = "";
            if (cmds.length > 1) {
                StringBuilder sb = new StringBuilder();
                String[] stringArray = cmds;
                int n = cmds.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if ((s = s.trim()).toLowerCase().startsWith(":decodemath:".toLowerCase())) {
                        decodeMath = s.substring(":decodemath:".length()).trim();
                    } else {
                        sb.append(s);
                        sb.append("\n");
                    }
                    ++n2;
                }
                this.cmd = sb.toString().trim();
            }
            String[] idx = this.cmd.split("[ ]");
            int channelNo = StringUtil.parseInt(this.channel);
            int index = StringUtil.parseInt(idx[decodeMath.length() > 0 ? 0 : channelNo - 1]);
            InterfaceThreads.setupVars();
            String vv = String.valueOf(this.di.getHandleName()) + "." + this.di.valueNames.get(index);
            Var v = Var.gl.get(vv);
            if (decodeMath.length() > 0) {
                this.di.getScript().addLocalVar("value", v);
                this.di.getScript().addLocalVar("channel", Var.createValue(channelNo));
                v = this.di.getScript().expression(decodeMath);
            }
            return v;
        }

        Var nameCommand() {
            if (this.cmd.matches("[0-9 ]+")) {
                String[] idx = this.cmd.split("[ ]");
                int channelNo = StringUtil.parseInt(this.channel);
                int index = StringUtil.parseInt(idx[channelNo - 1]);
                List<String> v = this.di.valueNames;
                if (v != null && index < v.size()) {
                    return Var.createValue(String.valueOf(this.deviceName) + "." + v.get(index));
                }
            }
            return new Var();
        }

        Var unitCommand() {
            if (this.cmd.matches("[0-9 ]+")) {
                String[] idx = this.cmd.split("[ ]");
                int channelNo = StringUtil.parseInt(this.channel);
                int index = StringUtil.parseInt(idx[channelNo - 1]);
                List<String> v = this.di.valueNames;
                if (v != null && index < v.size()) {
                    return Var.createValue(this.di.getValueUnit(v.get(index)));
                }
            }
            return new Var("");
        }
    }

    class ReadFunction
    extends Functions.Func {
        public ReadFunction(String name) {
            super(name);
        }

        @Override
        public Var execute(Script script, List<Var> params) {
            if (params.size() != 1) {
                ReadFunction.invalidNumberOfParams(script, ScriptInterface.getParamsHelp);
            }
            ParseCommand pc = new ParseCommand(false, this.name, script, params);
            return pc.readCommand();
        }
    }

    class SetFunction
    extends Functions.Func {
        public SetFunction(String name) {
            super(name);
        }

        @Override
        public Var execute(Script script, List<Var> params) {
            if (params.size() != 2) {
                SetFunction.invalidNumberOfParams(script, ScriptInterface.setParamsHelp);
            }
            ParseCommand pc = new ParseCommand(true, this.name, script, params);
            pc.setCommand();
            return null;
        }
    }

    class UnitFunction
    extends Functions.Func {
        public UnitFunction(String name) {
            super(name);
        }

        @Override
        public Var execute(Script script, List<Var> params) {
            if (params.size() != 1) {
                UnitFunction.invalidNumberOfParams(script, ScriptInterface.getParamsHelp);
            }
            ParseCommand pc = new ParseCommand(false, this.name, script, params);
            return pc.unitCommand();
        }
    }
}

