/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.main.DeviceInterface;
import dk.hkj.main.Support;
import dk.hkj.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class Remapper
implements TableModel {
    private List<Remap> remapList = new ArrayList<Remap>();
    private List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private boolean changed = false;

    public Remapper() {
        this.loadDefault();
    }

    public String remapDevice(DeviceInterface di) {
        Remap r = this.findDevice(di);
        return r == null || !r.enabled ? di.getHandleName() : r.getRemapHandle();
    }

    public boolean isEnabled(DeviceInterface di) {
        Remap r = this.findDevice(di);
        return r == null || r.isEnabled();
    }

    public Remap findDevice(DeviceInterface di) {
        Remap match = null;
        int points = 0;
        for (Remap r : this.remapList) {
            int i = r.match(di);
            if (i <= points) continue;
            match = r;
            points = i;
        }
        return match;
    }

    public void addDevice(DeviceInterface di) {
        Remap r1 = new Remap(di);
        int points = r1.match(di);
        for (Remap r : this.remapList) {
            if (points != r.match(di)) continue;
            return;
        }
        this.remapList.add(r1);
        this.changeNotification(this.remapList.size() - 2, this.remapList.size());
        this.changed = true;
    }

    public void removeDevice(int index) {
        this.remapList.remove(index);
        this.changeNotification(index, this.remapList.size());
        this.changed = true;
    }

    @Override
    public void addTableModelListener(TableModelListener arg0) {
        this.listeners.add(arg0);
    }

    @Override
    public Class<?> getColumnClass(int arg0) {
        return arg0 == 3 ? Boolean.class : String.class;
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Device name";
            }
            case 1: {
                return "Serial number";
            }
            case 2: {
                return "Serial id";
            }
            case 3: {
                return "Enabled";
            }
            case 4: {
                return "Handle";
            }
        }
        return "";
    }

    @Override
    public int getRowCount() {
        return this.remapList.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        Remap r = this.remapList.get(row);
        switch (column) {
            case 0: {
                return r.getDeviceName();
            }
            case 1: {
                return r.getDeviceSerialNumber();
            }
            case 2: {
                return r.getDeviceId() < 0 ? "" : Integer.toString(r.getDeviceId());
            }
            case 3: {
                return r.enabled;
            }
            case 4: {
                return r.getRemapHandle();
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column != 0;
    }

    @Override
    public void removeTableModelListener(TableModelListener arg0) {
        this.listeners.remove(arg0);
    }

    @Override
    public void setValueAt(Object obj, int row, int column) {
        Remap r = this.remapList.get(row);
        switch (column) {
            case 1: {
                r.setDeviceSerialNumber((String)obj);
                this.changed = true;
                break;
            }
            case 2: {
                String s = ((String)obj).trim();
                if (s.length() == 0) {
                    r.setDeviceId(-1);
                } else {
                    r.setDeviceId(Integer.parseInt(s));
                }
                this.changed = true;
                break;
            }
            case 3: {
                boolean v = (Boolean)obj;
                r.setEnabled(v);
                this.changed = true;
                break;
            }
            case 4: {
                r.setRemapHandle((String)obj);
                this.changed = true;
            }
        }
        this.changeNotification(row, row);
    }

    public void changeNotification(int firstRow, int lastRow) {
        for (TableModelListener ml : this.listeners) {
            ml.tableChanged(new TableModelEvent(this, -1));
        }
    }

    public void sortName() {
        this.remapList.sort(null);
        this.changeNotification(0, this.remapList.size());
    }

    public void sortHandle() {
        this.remapList.sort(new HandleComparator());
        this.changeNotification(0, this.remapList.size());
    }

    public void saveToFile(File file) {
        ArrayList<String> list = new ArrayList<String>();
        for (Remap r : this.remapList) {
            list.add(r.toString());
        }
        try {
            FileUtil.writeFile(file, list);
        }
        catch (IOException iOException) {}
    }

    public void loadFromFile(File file) {
        try {
            List<String> list = FileUtil.readFileAsList(file);
            for (String line : list) {
                if ((line = line.trim()).length() <= 0 || line.startsWith(";") || !line.contains("|")) continue;
                this.remapList.add(new Remap(line));
            }
            this.remapList.sort(null);
            this.changeNotification(0, this.remapList.size());
        }
        catch (IOException iOException) {}
    }

    public void saveDefault() {
        if (!this.changed) {
            return;
        }
        this.remapList.sort(null);
        this.saveToFile(new File(String.valueOf(Support.getConfigPath()) + "/settingsRemap.txt"));
        this.changed = false;
    }

    public void loadDefault() {
        this.loadFromFile(new File(String.valueOf(Support.getConfigPath()) + "/settingsRemap.txt"));
        this.remapList.sort(null);
        this.changed = false;
    }

    private class HandleComparator
    implements Comparator<Remap> {
        private HandleComparator() {
        }

        @Override
        public int compare(Remap o1, Remap o2) {
            return o1.getRemapHandle().compareTo(o2.getRemapHandle());
        }
    }

    static class Remap
    implements Comparable<Remap> {
        private String deviceName = "";
        private String deviceSerialNumber = "";
        private int deviceId = -1;
        private String remapHandle = "";
        private boolean enabled = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public Remap(String line) {
            for (Support.ConfigLineElement element : new Support.ConfigLineSplitter(line)) {
                if (element.name.equals("Name")) {
                    this.deviceName = element.value;
                    continue;
                }
                if (element.name.equals("SN")) {
                    this.deviceSerialNumber = element.value;
                    continue;
                }
                if (element.name.equals("Id")) {
                    this.deviceId = Integer.parseInt(element.value);
                    continue;
                }
                if (element.name.equals("enabled")) {
                    this.enabled = Integer.parseInt(element.value) != 0;
                    continue;
                }
                if (!element.name.equals("Handle")) continue;
                this.remapHandle = Support.cleanString(element.value);
            }
        }

        public Remap(DeviceInterface di) {
            this.deviceName = di.getDeviceName().trim();
            this.deviceSerialNumber = di.getSerialNumber().trim();
            this.deviceId = di.getId();
            this.remapHandle = di.getHandleName().trim().replace("|", "");
            this.enabled = true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Name:");
            sb.append(this.deviceName);
            sb.append("|SN:");
            sb.append(this.deviceSerialNumber);
            sb.append("|Id:");
            sb.append(this.deviceId);
            sb.append("|enabled:");
            sb.append(this.enabled ? "1" : "0");
            sb.append("|Handle:");
            sb.append(this.remapHandle);
            return sb.toString();
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public void setDeviceName(String deviceName) {
            this.deviceName = deviceName.trim();
        }

        public String getDeviceSerialNumber() {
            return this.deviceSerialNumber;
        }

        public void setDeviceSerialNumber(String deviceSerialNumber) {
            this.deviceSerialNumber = deviceSerialNumber.trim();
        }

        public int getDeviceId() {
            return this.deviceId;
        }

        public void setDeviceId(int deviceId) {
            this.deviceId = deviceId;
        }

        public String getRemapHandle() {
            return this.remapHandle;
        }

        public void setRemapHandle(String remapHandle) {
            this.remapHandle = Support.cleanString(remapHandle);
        }

        public int match(DeviceInterface di) {
            if (!di.getDeviceName().equals(this.deviceName)) {
                return 0;
            }
            if (this.deviceSerialNumber != null && this.deviceSerialNumber.length() > 0 && di.getSerialNumber().equals(this.deviceSerialNumber)) {
                return 3;
            }
            if (di.getId() == this.deviceId) {
                return 2;
            }
            return 1;
        }

        @Override
        public int compareTo(Remap r) {
            int i = this.deviceName.compareTo(r.deviceName);
            if (i != 0) {
                return i;
            }
            i = this.deviceSerialNumber.compareTo(r.deviceSerialNumber);
            if (i != 0) {
                return i;
            }
            if (this.deviceId > r.deviceId) {
                return 1;
            }
            if (this.deviceId < r.deviceId) {
                return -1;
            }
            return 0;
        }
    }
}

