/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.util.StringUtil;
import java.util.List;

public class ParseValues {
    private static String validSI = "0123456789+-.pnu\u00b5mkMG";

    private static double parseDouble(String s) {
        double v = Double.parseDouble(s);
        return Double.isFinite(v) ? v : 0.0;
    }

    public static void parse(List<Double> output, String[] input, String formats) {
        String s;
        boolean clearValues = false;
        int i = 0;
        while (i < formats.length() && i < input.length) {
            if (formats.charAt(i) == '*') {
                try {
                    s = input[i].trim();
                    if (StringUtil.parseInt(s) == 0) {
                        clearValues = true;
                    }
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        i = 0;
        while (i < formats.length() && i < input.length) {
            switch (formats.charAt(i)) {
                case 'x': {
                    break;
                }
                case 'f': 
                case 'i': {
                    try {
                        output.add(ParseValues.parseDouble(input[i]));
                    }
                    catch (Exception exception) {
                        output.add(0.0);
                    }
                    break;
                }
                case 'F': 
                case 'I': {
                    try {
                        output.add(clearValues ? 0.0 : ParseValues.parseDouble(input[i]));
                    }
                    catch (Exception exception) {
                        output.add(0.0);
                    }
                    break;
                }
                case 'u': {
                    int j;
                    try {
                        s = input[i];
                        j = s.length() - 1;
                        while (j >= 0 && Character.isAlphabetic(s.charAt(j))) {
                            --j;
                        }
                        output.add(ParseValues.parseDouble(s.substring(0, j + 1)));
                    }
                    catch (Exception exception) {
                        output.add(0.0);
                    }
                    break;
                }
                case 'U': {
                    int j;
                    try {
                        s = input[i];
                        j = s.length() - 1;
                        while (j >= 0 && Character.isAlphabetic(s.charAt(j))) {
                            --j;
                        }
                        output.add(clearValues ? 0.0 : ParseValues.parseDouble(s.substring(0, j + 1)));
                    }
                    catch (Exception exception) {
                        output.add(0.0);
                    }
                    break;
                }
                case 's': {
                    int j;
                    try {
                        s = input[i];
                        j = 0;
                        while (j < s.length()) {
                            if (validSI.indexOf(s.charAt(j)) < 0) {
                                s = s.substring(0, j);
                            }
                            ++j;
                        }
                        output.add(StringUtil.parseDoubleEE(s));
                    }
                    catch (Exception exception) {
                        output.add(0.0);
                    }
                    break;
                }
                case 'S': {
                    int j;
                    try {
                        s = input[i];
                        j = 0;
                        while (j < s.length()) {
                            if (validSI.indexOf(s.charAt(j)) < 0) {
                                s = s.substring(0, j);
                            }
                            ++j;
                        }
                        output.add(clearValues ? 0.0 : StringUtil.parseDoubleEE(s));
                    }
                    catch (Exception exception) {
                        output.add(0.0);
                    }
                    break;
                }
                case 'h': {
                    String s2;
                    int n;
                    int n2;
                    String[] stringArray;
                    try {
                        double v = 0.0;
                        stringArray = input[i].split("[:]");
                        n2 = stringArray.length;
                        n = 0;
                        while (n < n2) {
                            s2 = stringArray[n];
                            v = v * 60.0 + ParseValues.parseDouble(s2);
                            ++n;
                        }
                        output.add(v);
                    }
                    catch (Exception exception) {
                        output.add(0.0);
                    }
                    break;
                }
                case 'H': {
                    String s2;
                    int n;
                    int n2;
                    String[] stringArray;
                    try {
                        double v = 0.0;
                        stringArray = input[i].split("[:]");
                        n2 = stringArray.length;
                        n = 0;
                        while (n < n2) {
                            s2 = stringArray[n];
                            v = v * 60.0 + ParseValues.parseDouble(s2);
                            ++n;
                        }
                        output.add(clearValues ? 0.0 : v);
                        break;
                    }
                    catch (Exception exception) {
                        output.add(0.0);
                    }
                }
            }
            ++i;
        }
    }
}

