/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.FontAdjust;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.Support;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

public class MenuModeSelection
implements ActionListener {
    private ManageDeviceDefinitions.DeviceDefinition def = null;
    private DeviceInterface di;

    public MenuModeSelection(DeviceInterface di, ManageDeviceDefinitions.DeviceDefinition def) {
        this.di = di;
        this.def = def;
    }

    public void showMenu(JComponent pos) {
        if (this.di == null || this.di.dt == null || this.di.dt.cPort == null) {
            return;
        }
        if (InterfaceThreads.isLogging()) {
            return;
        }
        JPopupMenu popupMenu = new JPopupMenu();
        int n = 0;
        for (String key : this.di.getModesPopupList()) {
            ManageDeviceDefinitions.FunctionMode fm = this.def.getFunctionMode(key);
            if (key.length() == 0) {
                popupMenu.addSeparator();
                continue;
            }
            if (fm instanceof ManageDeviceDefinitions.FunctionModeCheck) {
                ManageDeviceDefinitions.FunctionModeCheck fmc = (ManageDeviceDefinitions.FunctionModeCheck)fm;
                FontAdjust.FontCheckBoxMenuItem mi = new FontAdjust.FontCheckBoxMenuItem(key.replace("_", " "));
                mi.setActionCommand(key);
                mi.addActionListener(this);
                mi.setSelected(fmc.defaultOn);
                ++n;
                continue;
            }
            FontAdjust.FontMenuItem mi = new FontAdjust.FontMenuItem(key.replace("_", " "));
            mi.setActionCommand(key);
            mi.addActionListener(this);
            popupMenu.add(mi);
            ++n;
        }
        popupMenu.show(pos, 30, -n * 15);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (InterfaceThreads.isLogging()) {
            return;
        }
        String cmd = e.getActionCommand();
        if (cmd == null || cmd.isEmpty()) {
            return;
        }
        ManageDeviceDefinitions.FunctionMode fm = this.def.getFunctionMode(cmd);
        if (fm instanceof ManageDeviceDefinitions.FunctionModeCheck) {
            ManageDeviceDefinitions.FunctionModeCheck fmc = (ManageDeviceDefinitions.FunctionModeCheck)fm;
            if (fmc != null && !fmc.modesRequired.isEmpty()) {
                String[] stringArray = fmc.modesRequired.split("[ ,;]");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String m = stringArray[n2];
                    boolean state = false;
                    if (m.startsWith("!")) {
                        state = true;
                        m = m.substring(1);
                    }
                    if (this.di.modeActive(m.trim()) != state) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
        } else {
            this.di.setupMode(cmd, true);
            Support.addUsedFunction(String.valueOf(this.di.getHandleName()) + "*ModeM");
        }
    }
}

