/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.devices.SetupFormats;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.Support;
import dk.hkj.main.ValueFormat;
import dk.hkj.util.FileUtil;
import dk.hkj.util.StringUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class ManageDeviceDefinitions {
    private List<DeviceDefinition> deviceDefinitions = new ArrayList<DeviceDefinition>();
    private List<MetaEntry> metaDefDefinitions = new ArrayList<MetaEntry>();
    private List<MetaEntry> metaDefinitions = new ArrayList<MetaEntry>();
    public static String SearchPortsString = "searchPorts: ";

    public List<String> getDeviceList() {
        ArrayList<String> deviceList = new ArrayList<String>();
        for (DeviceDefinition def : this.deviceDefinitions) {
            deviceList.add(def.deviceName);
        }
        deviceList.sort(null);
        return deviceList;
    }

    public List<String> getFilteredDeviceList(String filter) {
        ArrayList<String> deviceList = new ArrayList<String>();
        filter = filter.toLowerCase();
        for (DeviceDefinition def : this.deviceDefinitions) {
            if (!def.deviceName.toLowerCase().contains(filter)) continue;
            deviceList.add(def.deviceName);
        }
        deviceList.sort(new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                return arg0.toLowerCase().compareTo(arg1.toLowerCase());
            }
        });
        return deviceList;
    }

    public Collection<String> getDeviceSocketPorts() {
        TreeSet<String> ports = new TreeSet<String>();
        for (DeviceDefinition def : this.deviceDefinitions) {
            String[] stringArray = def.devicePort.split("[ ]+");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.matches("[0-9]+")) {
                    ports.add(def.devicePort);
                }
                ++n2;
            }
        }
        return ports;
    }

    public static PortType stringToPortType(String type) {
        if ((type = type.trim()).equalsIgnoreCase("Internal") || type.equalsIgnoreCase("none")) {
            return PortType.None;
        }
        if (type.equalsIgnoreCase("Serial") || type.equalsIgnoreCase("com")) {
            return PortType.Serial;
        }
        if (type.equalsIgnoreCase("Serial fixed baudrate") || type.equalsIgnoreCase("comFixedBaud")) {
            return PortType.SerialFixedBaud;
        }
        if (type.equalsIgnoreCase("Serial no baudrate") || type.equalsIgnoreCase("comNoBaud")) {
            return PortType.SerialNoBaud;
        }
        if (type.equalsIgnoreCase("Socket?")) {
            return PortType.SocketAuto;
        }
        if (type.equalsIgnoreCase("SocketF") || type.matches("[0-9]+[fF]")) {
            return PortType.SocketFilter;
        }
        if (type.equalsIgnoreCase("Telnet") || type.matches("[0-9]+[tT]")) {
            return PortType.Telnet;
        }
        if (type.equalsIgnoreCase("UDP") || type.matches("[0-9]+[uU]")) {
            return PortType.UDP;
        }
        if (type.equalsIgnoreCase("Socket") || type.matches("[0-9]+")) {
            return PortType.Socket;
        }
        if (type.equalsIgnoreCase("LXI")) {
            return PortType.LXI;
        }
        if (type.equalsIgnoreCase("GPIB")) {
            return PortType.GPIB;
        }
        if (type.equalsIgnoreCase("USBHID") || type.matches("USB/HID")) {
            return PortType.USBHID;
        }
        return PortType.None;
    }

    public static String portTypeToString(PortType portType) {
        switch (portType) {
            case None: {
                return "Internal";
            }
            case Serial: {
                return "Serial";
            }
            case SerialFixedBaud: {
                return "Serial fixed baudrate";
            }
            case SerialNoBaud: {
                return "Serial no baudrate";
            }
            case SocketAuto: {
                return "Socket?";
            }
            case Socket: {
                return "Socket";
            }
            case SocketFilter: {
                return "SocketF";
            }
            case Telnet: {
                return "Telnet";
            }
            case LXI: {
                return "LXI";
            }
            case GPIB: {
                return "GPIB";
            }
            case USBHID: {
                return "USBHID";
            }
            case UDP: {
                return "UDP";
            }
        }
        return "??";
    }

    public void loadDefinitions(File f) {
        try {
            List<String> list = FileUtil.readFileAsListAutoCharset(f, ";", true, false);
            DeviceDefinition dd = new DeviceDefinition(list);
            switch (dd.getDefintionType()) {
                case Device: {
                    if (this.findDeviceDefintionFromName(dd.getDeviceName()) == null) {
                        this.deviceDefinitions.add(dd);
                    }
                    break;
                }
                case MetaDef: {
                    int i = 0;
                    while (i < list.size()) {
                        if (list.get(i).toLowerCase().equals("#meta")) {
                            ArrayList<String> metaList = new ArrayList<String>();
                            int j = i + 1;
                            while (j < list.size()) {
                                metaList.add(list.get(j));
                                ++j;
                            }
                            while (list.size() > i) {
                                list.remove(list.size() - 1);
                            }
                            this.metaDefinitions.add(new MetaEntry(f.getName(), metaList));
                            break;
                        }
                        ++i;
                    }
                    this.metaDefDefinitions.add(new MetaEntry(f.getName(), list));
                    break;
                }
                case Meta: {
                    this.metaDefinitions.add(new MetaEntry(f.getName(), list));
                    break;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
    }

    public void loadDefinitions(String path) {
        try {
            File defDir = new File(path);
            if (!defDir.isDirectory()) {
                return;
            }
            File[] fileArray = defDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File arg0, String fname) {
                    return fname.toLowerCase().endsWith(".txt");
                }
            });
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                this.loadDefinitions(f);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void loadDefinitions() {
        if (this.deviceDefinitions.size() > 0) {
            return;
        }
        this.loadDefinitions(Support.getDevicePath());
        this.loadDefinitions(String.valueOf(Support.getProgramPath()) + "/Devices");
        int n = this.metaDefDefinitions.size();
        while (this.metaDefDefinitions.size() > 0 && n > 0) {
            ProcessMetaDefintion pmd = new ProcessMetaDefintion();
            try {
                if (pmd.process(this.metaDefDefinitions.get(0))) {
                    this.metaDefDefinitions.remove(0);
                    n = this.metaDefDefinitions.size();
                    continue;
                }
                this.metaDefDefinitions.add(this.metaDefDefinitions.remove(0));
                --n;
            }
            catch (Exception exception) {
                this.metaDefDefinitions.remove(0);
                n = this.metaDefDefinitions.size();
            }
        }
        if (Support.listDevices) {
            System.out.println("Total " + this.deviceDefinitions.size() + " devices");
            System.out.println();
            StringBuilder sb = new StringBuilder();
            ArrayList<String> list = new ArrayList<String>();
            for (DeviceDefinition def : this.deviceDefinitions) {
                list.add(def.getDeviceName());
            }
            list.sort(null);
            for (String s : list) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(s);
            }
            System.out.println(sb.toString());
        }
    }

    public DeviceDefinition findDeviceDefintionFromName(String deviceName) {
        for (DeviceDefinition dd : this.deviceDefinitions) {
            if (!deviceName.equals(dd.getDeviceName())) continue;
            return dd;
        }
        return null;
    }

    public DeviceDefinition findDeviceDefintionFromId(String id) {
        for (DeviceDefinition dd : this.deviceDefinitions) {
            if (!id.startsWith(dd.getIdName())) continue;
            return dd;
        }
        return null;
    }

    public DeviceDefinition findDeviceDefintionFromManufacturerModel(String manufacturer, String model) {
        manufacturer = manufacturer.toLowerCase();
        model = model.toLowerCase();
        for (DeviceDefinition dd : this.deviceDefinitions) {
            String[] ss = dd.getIdName().split("[,]");
            if (!ss[0].toLowerCase().contains(manufacturer) || !ss[1].toLowerCase().contains(model)) continue;
            return dd;
        }
        return null;
    }

    public DeviceDefinition findDeviceDefintionFromHandle(String handle) {
        int i = handle.indexOf(95);
        if (i >= 0) {
            handle = handle.substring(0, i);
        }
        for (String s : this.getDeviceList()) {
            DeviceDefinition def = this.findDeviceDefintionFromName(s);
            if (def == null || !def.getHandleName().equalsIgnoreCase(handle)) continue;
            return def;
        }
        return null;
    }

    public static DeviceDefinition getDeviceDefinitionUnknown() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("#idString Unknown device");
        list.add("#name Unknown device");
        list.add("#handle xx");
        return new DeviceDefinition(list);
    }

    public static enum DefinitionType {
        Invalid,
        Device,
        MetaDef,
        Meta;

    }

    public static class DeviceDefinition {
        private List<String> definition = new ArrayList<String>();
        private String idString = null;
        private String handleName = null;
        private String deviceName = null;
        private String devicePort = null;
        private PortType portType = PortType.None;
        private String deviceDriver = null;
        private boolean metaDefFound = false;
        private boolean metaFound = false;
        private int resetDelay = 0;
        private List<ValueFormat> valueFormats = new ArrayList<ValueFormat>();
        private List<String> valueFormatModes = new ArrayList<String>();
        private List<FunctionMode> functionModes = new ArrayList<FunctionMode>();
        private List<String> mayModifyFunctionMode = new ArrayList<String>();
        private List<SetupFormats> setupFormats = new ArrayList<SetupFormats>();
        private Map<String, String> cmds = new HashMap<String, String>();
        private Map<String, String> ifaces = new HashMap<String, String>();
        private Map<String, String> scpiDefines = new HashMap<String, String>();
        private List<String> scpiDefinesList = new ArrayList<String>();
        private LineParser parser = null;
        private int modeChangeDelay = 1000;
        private int readingDelay = 1000;

        private DeviceDefinition(List<String> list) {
            this.definition = list;
            this.firstParse();
        }

        private DefinitionType getDefintionType() {
            if (this.metaDefFound) {
                return DefinitionType.MetaDef;
            }
            if (this.metaFound) {
                return DefinitionType.Meta;
            }
            if (this.idString != null && this.handleName != null && this.deviceName != null && this.devicePort != null) {
                return DefinitionType.Device;
            }
            System.out.println("Definition is not valid: " + this.deviceName);
            return DefinitionType.Invalid;
        }

        public int getModeChangeDelay() {
            return this.modeChangeDelay;
        }

        public int getReadingDelay() {
            return this.readingDelay;
        }

        public int getResetDleay() {
            return this.resetDelay;
        }

        public synchronized boolean haveModes() {
            return this.functionModes.size() > 0;
        }

        public synchronized List<String> getFunctionModes() {
            ArrayList<String> list = new ArrayList<String>();
            for (FunctionMode fm : this.functionModes) {
                list.add(fm.name);
            }
            return list.size() == 0 ? null : list;
        }

        public synchronized FunctionMode getFunctionMode(String name) {
            for (FunctionMode fm : this.functionModes) {
                if (!fm.name.equalsIgnoreCase(name)) continue;
                return fm;
            }
            return null;
        }

        public synchronized boolean mayModifyColumns(String cmd) {
            if (cmd.startsWith(":")) {
                cmd = cmd.substring(1).trim();
            }
            cmd = cmd.toLowerCase();
            for (String s : this.mayModifyFunctionMode) {
                if (!cmd.startsWith(s)) continue;
                return true;
            }
            return false;
        }

        public synchronized FunctionMode getFunctionModeFromDeviceMode(String deviceModeName) {
            for (FunctionMode fm : this.functionModes) {
                if (fm.name.length() <= 0 || !fm.deviceModeName.equalsIgnoreCase(deviceModeName)) continue;
                return fm;
            }
            for (String vfm : this.valueFormatModes) {
                if (vfm == null) continue;
                String[] stringArray = vfm.split("[,]");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String ss = stringArray[n2];
                    if (ss != null && deviceModeName.equalsIgnoreCase((ss = ss.trim()).trim())) {
                        return new FunctionMode(ss, ss, "");
                    }
                    ++n2;
                }
            }
            System.out.println("Unknown mode: " + deviceModeName);
            System.out.print("Known modes: ");
            for (FunctionMode fm : this.functionModes) {
                System.out.print(String.valueOf(fm.deviceModeName) + ", ");
            }
            System.out.println();
            return new FunctionMode("Unknown", "Unknown", "");
        }

        public synchronized List<String> getValueNames(String mode) {
            ArrayList<String> list = new ArrayList<String>();
            boolean hasModes = false;
            for (String s : this.valueFormatModes) {
                if (s.trim().length() <= 0) continue;
                hasModes = true;
                break;
            }
            if (!hasModes) {
                int i = 0;
                while (i < this.valueFormats.size()) {
                    list.add(this.valueFormats.get((int)i).name);
                    ++i;
                }
            } else {
                if (mode == null) {
                    mode = "";
                }
                HashSet<String> modeSet = new HashSet<String>();
                String[] stringArray = mode.split("[ ,;]+");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (s != null && (s = s.trim()).length() > 0) {
                        modeSet.add(s);
                    }
                    ++n2;
                }
                int i = 0;
                while (i < this.valueFormats.size()) {
                    String[] stringArray2 = this.valueFormatModes.get(i).split("[ ,;]+");
                    int n3 = stringArray2.length;
                    n = 0;
                    while (n < n3) {
                        String s = stringArray2[n];
                        if (modeSet.contains(s) || s.isEmpty()) {
                            list.add(this.valueFormats.get((int)i).name);
                            break;
                        }
                        ++n;
                    }
                    ++i;
                }
            }
            return list;
        }

        public Map<String, String> getIFaces() {
            return this.ifaces;
        }

        public String getIFace(String name) {
            return this.ifaces.get(name);
        }

        public synchronized List<SetupFormats> getSetupPopupList(DeviceInterface di) {
            ArrayList<SetupFormats> list = new ArrayList<SetupFormats>();
            for (SetupFormats sf : this.setupFormats) {
                list.add(sf.getClone(di));
            }
            return list;
        }

        public synchronized boolean haveSetupPopup() {
            return this.setupFormats.size() > 0;
        }

        public String getIdName() {
            return this.idString;
        }

        public void setDeviceName(String newDeviceName) {
            this.deviceName = newDeviceName;
        }

        public String getDeviceName() {
            return this.deviceName.trim();
        }

        public String getHandleName() {
            return this.handleName.trim();
        }

        public String getPorts() {
            return this.devicePort;
        }

        public List<PortType> getPortList() {
            ArrayList<PortType> list = new ArrayList<PortType>();
            String[] stringArray = this.getPorts().split("[ ]+");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                list.add(ManageDeviceDefinitions.stringToPortType(s));
                ++n2;
            }
            return list;
        }

        public int getPort() {
            String[] stringArray = this.devicePort.split("[ ]+");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.matches("[0-9]+")) {
                    return StringUtil.parseInt(s);
                }
                if (s.matches("[0-9]+[uU]")) {
                    return StringUtil.parseInt(s.substring(0, s.length() - 1));
                }
                ++n2;
            }
            return 23;
        }

        public PortType getPortType() {
            return this.portType;
        }

        public String getDriver() {
            return this.deviceDriver;
        }

        public synchronized List<ValueFormat> getValueFormats() {
            return this.valueFormats;
        }

        private void firstParse() {
            int n = 0;
            for (String s : this.definition) {
                String cmd;
                if (n++ > 100) {
                    return;
                }
                if (s.length() <= 0 || s.charAt(0) != '#') continue;
                int i = s.indexOf(32);
                if (i < 0) {
                    i = s.length();
                }
                if ((cmd = s.substring(0, i).toLowerCase()).equals("#idstring")) {
                    this.idString = s.substring(i + 1).trim();
                    continue;
                }
                if (cmd.equals("#port")) {
                    this.devicePort = s.substring(i + 1).trim();
                    int j = this.devicePort.indexOf(32);
                    if (j < 0) {
                        j = this.devicePort.length();
                    }
                    this.portType = ManageDeviceDefinitions.stringToPortType(this.devicePort.substring(0, j));
                    continue;
                }
                if (cmd.equals("#name")) {
                    this.deviceName = s.substring(i + 1).trim();
                    continue;
                }
                if (cmd.equals("#handle")) {
                    this.handleName = s.substring(i + 1).trim();
                    continue;
                }
                if (cmd.equals("#driver")) {
                    this.deviceDriver = s.substring(i + 1).trim();
                    continue;
                }
                if (cmd.equals("#metadef")) {
                    this.metaDefFound = true;
                    return;
                }
                if (cmd.equals("#meta")) {
                    this.metaFound = true;
                    return;
                }
                if (cmd.equals("#ignore")) {
                    return;
                }
                if (!cmd.equals("#cmdsetup") && !cmd.equals("#cmdmode") && !cmd.equals("#cmdmodecheck")) continue;
                return;
            }
        }

        public synchronized boolean isParsed() {
            return this.parser != null;
        }

        public synchronized void parse() {
            if (this.isParsed()) {
                return;
            }
            this.parser = new LineParser(this.definition);
            while (!this.parser.done()) {
                String cmd = this.parser.nextKeyword();
                if (cmd == null) continue;
                if (cmd.equalsIgnoreCase("#metasection")) {
                    System.out.println(String.valueOf(this.deviceName) + " #metasection is only valid in #meta definitions");
                    throw new RuntimeException(String.valueOf(this.deviceName) + " #metasection is only valid in #meta definitions");
                }
                if (cmd.equalsIgnoreCase("#value") && this.parser.checkParams(3)) {
                    this.valueFormats.add(new ValueFormat(this.parser.getParam(0), this.parser.getParam(1), ValueFormat.getFormatter(this.parser.getParam(2))));
                    this.valueFormatModes.add(this.parser.getRest());
                    continue;
                }
                if (cmd.equalsIgnoreCase("#modeChangeDelay") && this.parser.checkParams(1)) {
                    this.modeChangeDelay = (int)(Double.parseDouble(this.parser.getParam(0)) * 1000.0);
                    continue;
                }
                if (cmd.equalsIgnoreCase("#readingDelay") && this.parser.checkParams(1)) {
                    this.readingDelay = (int)(Double.parseDouble(this.parser.getParam(0)) * 1000.0);
                    continue;
                }
                if (cmd.equalsIgnoreCase("#resetDelay") && this.parser.checkParams(1)) {
                    this.resetDelay = (int)(Double.parseDouble(this.parser.getParam(0)) * 1000.0);
                    continue;
                }
                if (cmd.equalsIgnoreCase("#interface") && this.parser.checkParams(1) & this.parser.checkRest()) {
                    this.ifaces.put(this.parser.getParam(0), this.parser.getRest());
                    continue;
                }
                if (cmd.equalsIgnoreCase("#cmdMode") && this.parser.checkParams(2) && this.parser.checkRest()) {
                    this.functionModes.add(new FunctionMode(this.parser.getParam(0), this.parser.getParam(1), this.parser.getRest()));
                    continue;
                }
                if (cmd.equalsIgnoreCase("#cmdMode")) {
                    this.functionModes.add(new FunctionMode("", "", ""));
                    continue;
                }
                if (cmd.equalsIgnoreCase("#cmdModeCheck") && this.parser.checkParams(2) && this.parser.checkRest()) {
                    String[] lines = this.parser.getRest().split("[\n]");
                    this.functionModes.add(new FunctionModeCheck(this.parser.getParam(0), this.parser.getParam(1), lines[1].trim(), lines[2].trim(), StringUtil.parseInt(lines[0].trim()) != 0, lines.length > 3 ? lines[3].trim() : ""));
                    continue;
                }
                if (cmd.equalsIgnoreCase("#cmdModeGet") && this.parser.checkParams(1)) {
                    this.functionModes.add(new FunctionModeGet(this.parser.getParam(0)));
                    continue;
                }
                if (cmd.equalsIgnoreCase("#scpiCmd") && this.parser.checkParams(1) && this.parser.checkRest()) {
                    this.scpiDefines.put(this.parser.getParam(0).toLowerCase(), this.parser.getRest());
                    this.scpiDefinesList.add(this.parser.getParam(0));
                    continue;
                }
                if (cmd.equalsIgnoreCase("#cmdSetup") && this.parser.checkParams(2)) {
                    this.parser.checkParams(3);
                    this.parser.checkRest();
                    SetupFormats format = SetupFormats.setup(this.parser.getParam(0), this.parser.getParam(1), this.parser.getParam(2), this.parser.getRest());
                    if (format == null) continue;
                    this.setupFormats.add(format);
                    continue;
                }
                if (cmd.equalsIgnoreCase("#mayModifyMode") && this.parser.checkParams(1)) {
                    this.mayModifyFunctionMode.add(this.parser.getParam(0).toLowerCase());
                    continue;
                }
                if (!this.parser.checkRest()) continue;
                if (this.cmds.get(cmd) != null) {
                    int i = 0;
                    while (this.cmds.get(String.valueOf(cmd) + " " + i) != null) {
                        ++i;
                    }
                    this.cmds.put(String.valueOf(cmd) + " " + i, this.parser.getRest());
                    continue;
                }
                this.cmds.put(cmd, this.parser.getRest());
            }
            if (this.functionModes.size() >= 2) {
                if (this.ifaces.get("getMode") == null && this.getItem("#askMode") != null && this.getItem("#askMode").trim().length() > 0) {
                    this.ifaces.put("getMode", "[GETMODE]");
                }
                if (this.ifaces.get("setMode") == null) {
                    this.ifaces.put("setMode", "[SETMODE]");
                }
            }
            this.definition = null;
        }

        public synchronized String getItem(String item) {
            this.parse();
            return this.cmds.get(item);
        }

        public String getItem(String item, String def) {
            String s = this.getItem(item);
            return s != null ? s : def;
        }

        public String getScpiDefine(String name) {
            return this.scpiDefines.get(name);
        }

        public List<String> getScpiDefines() {
            ArrayList<String> list = new ArrayList<String>();
            list.addAll(this.scpiDefinesList);
            list.sort(null);
            return list;
        }

        public synchronized int getItemInt(String item) {
            String s = this.getItem(item);
            if (s == null) {
                return 0;
            }
            if ((s = s.toLowerCase().trim()).length() == 0) {
                return 0;
            }
            return StringUtil.parseInt(s);
        }

        public synchronized int getItemInt(String item, int def) {
            String s = this.getItem(item);
            if (s == null) {
                return def;
            }
            if ((s = s.toLowerCase().trim()).length() == 0) {
                return def;
            }
            return StringUtil.parseInt(s);
        }

        public synchronized byte[] getItemBytes(String item) {
            String line = this.getItem(item);
            if (line == null || line.trim().length() == 0) {
                return null;
            }
            String[] s = line.toLowerCase().trim().split("[, ]+");
            byte[] data = new byte[s.length];
            int i = 0;
            while (i < s.length) {
                data[i] = (byte)StringUtil.parseInt(s[i]);
                ++i;
            }
            return data;
        }
    }

    public static class FunctionMode {
        public String name;
        String deviceModeName;
        public String cmdsToSetup;

        FunctionMode(String name, String deviceModeName, String cmdsToSetup) {
            this.name = name;
            this.deviceModeName = deviceModeName;
            this.cmdsToSetup = cmdsToSetup;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return String.valueOf(this.name) + " " + this.deviceModeName + " " + this.cmdsToSetup;
        }
    }

    public static class FunctionModeCheck
    extends FunctionMode {
        public String cmdsToDisable = "";
        public String modesRequired = "";
        public boolean defaultOn = false;
        public boolean localMode = false;

        FunctionModeCheck(String name, String deviceModeName, String cmdsToSetup, String cmdsToDisable, boolean defaultOn, String modesRequired) {
            super(name, deviceModeName, cmdsToSetup);
            this.cmdsToDisable = cmdsToDisable;
            this.defaultOn = defaultOn;
            int i = 0;
            i = cmdsToSetup.toLowerCase().indexOf("[localmode]");
            if (i >= 0) {
                this.localMode = true;
                this.cmdsToSetup = String.valueOf(this.cmdsToSetup.substring(0, i)) + this.cmdsToSetup.substring(i + "[localmode]".length());
            }
            if ((i = cmdsToDisable.toLowerCase().indexOf("[localmode]")) >= 0) {
                this.localMode = true;
                cmdsToDisable = String.valueOf(cmdsToDisable.substring(0, i)) + cmdsToDisable.substring(i + "[localmode]".length());
            }
            this.modesRequired = modesRequired;
        }

        @Override
        public String toString() {
            return String.valueOf(this.name) + " " + this.deviceModeName + " " + this.cmdsToSetup + " - " + this.cmdsToDisable;
        }
    }

    public static class FunctionModeGet
    extends FunctionMode {
        FunctionModeGet(String name) {
            super(name, "", "");
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    private static class LineParser {
        private List<String> lines = null;
        private int lineIndex = 0;
        private int lineMatch = -1;
        private String line;
        private int linePos = 0;
        private List<String> params = new ArrayList<String>();
        private String rest = null;

        LineParser(List<String> lines) {
            this.lines = lines;
        }

        public boolean done() {
            return this.lineIndex >= this.lines.size();
        }

        public String nextKeyword() {
            this.params.clear();
            this.rest = null;
            if (this.lineIndex == this.lineMatch) {
                ++this.lineIndex;
                if (this.lineIndex >= this.lines.size()) {
                    return null;
                }
            }
            do {
                this.line = this.lines.get(this.lineIndex).trim();
                if (this.line.length() > 0 && this.line.charAt(0) == '#') {
                    this.linePos = this.line.indexOf(32);
                    if (this.linePos < 0) {
                        this.linePos = this.line.length();
                    }
                    this.lineMatch = this.lineIndex;
                    return this.line.substring(0, this.linePos);
                }
                ++this.lineIndex;
            } while (this.lineIndex < this.lines.size());
            return null;
        }

        private boolean parseParam() {
            int i;
            block4: {
                i = this.line.indexOf(32, this.linePos + 1);
                if (i < 0) {
                    i = this.line.length();
                }
                if (this.line.length() >= this.linePos && i > this.linePos) break block4;
                return false;
            }
            try {
                this.params.add(this.line.substring(this.linePos + 1, i));
                this.linePos = i;
            }
            catch (Exception e) {
                System.out.println("Failed parsing cmdSetup: " + this.line);
                e.printStackTrace(System.out);
            }
            return true;
        }

        private boolean parseRest() {
            this.rest = "";
            if (this.linePos < this.line.length()) {
                this.rest = this.line.substring(this.linePos + 1);
            }
            boolean done = false;
            do {
                ++this.lineIndex;
                if (this.lineIndex < this.lines.size()) {
                    this.line = this.lines.get(this.lineIndex).trim();
                    if (this.line.length() > 0 && this.line.charAt(0) == '#') {
                        done = true;
                        continue;
                    }
                    if ((this.line.length() <= 0 || this.line.charAt(0) == '#' || this.line.charAt(0) == ';') && this.line.length() != 0) continue;
                    this.rest = String.valueOf(this.rest) + "\n" + this.line;
                    continue;
                }
                done = true;
            } while (!done);
            this.rest = this.rest.trim();
            return this.rest.length() > 0;
        }

        public boolean checkParams(int n) {
            int i = 0;
            while (i < n) {
                if (!this.parseParam()) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public boolean checkRest() {
            return this.parseRest();
        }

        public String getParam(int i) {
            if (i >= this.params.size()) {
                return null;
            }
            return this.params.get(i);
        }

        public String getRest() {
            if (this.rest == null) {
                this.parseRest();
            }
            return this.rest;
        }
    }

    private class MetaEntry {
        String name;
        List<String> list;

        MetaEntry(String name, List<String> list) {
            int i = name.lastIndexOf(46);
            if (i > 0) {
                name = name.substring(0, i);
            }
            this.name = name;
            this.list = list;
        }
    }

    public static enum PortType {
        None,
        Serial,
        SerialFixedBaud,
        SerialNoBaud,
        SocketAuto,
        Socket,
        SocketFilter,
        Telnet,
        LXI,
        USBHID,
        GPIB,
        UDP;

    }

    private class ProcessMetaDefintion {
        final String[] directReplaceTags = new String[]{"#idstring", "#name", "#handle", "#port", "#driver", "#baudrate", "#subdriver", "#usbvendor", "#usbproduct", "#usbpoll", "#eol", "#verifydevice", "#helpurl", "#help", "#checksum"};
        private List<String> definition = null;
        private MetaEntry metaDef = null;
        private boolean metaDebug = false;
        private boolean save = false;
        boolean metaSectionsDone = false;

        private ProcessMetaDefintion() {
        }

        private void error(String reason, String line) {
            System.out.println("Error in meta defintion: " + this.metaDef.name);
            System.out.println("    " + reason);
            if (line != null) {
                System.out.println("    " + line);
            }
            throw new RuntimeException();
        }

        private boolean isDirectReplaceTag(String tag) {
            String[] stringArray = this.directReplaceTags;
            int n = this.directReplaceTags.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.equals(tag)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private void saveDefinition() {
            DeviceDefinition dd;
            if (this.definition == null) {
                this.error("Trying to same a empty definition", null);
            }
            if (!this.metaSectionsDone) {
                this.handleMetaSections("");
            }
            if (this.save) {
                File f = new File(String.valueOf(Support.getDataPath()) + "/metaOutputDebug.txt");
                try {
                    FileUtil.writeFile(f, this.definition);
                }
                catch (IOException iOException) {}
                System.out.println("Save debug defintion as: " + f.getPath());
            }
            if ((dd = new DeviceDefinition(this.definition)).getDefintionType() == DefinitionType.Device && ManageDeviceDefinitions.this.findDeviceDefintionFromName(dd.getDeviceName()) == null) {
                ManageDeviceDefinitions.this.deviceDefinitions.add(dd);
                this.definition = null;
            }
        }

        private boolean getDefinition(String name) {
            DeviceDefinition dd;
            if (this.definition != null) {
                this.saveDefinition();
            }
            if (name.length() == 0) {
                name = this.metaDef.name;
            }
            if ((dd = ManageDeviceDefinitions.this.findDeviceDefintionFromName(name)) != null) {
                this.definition = new ArrayList<String>();
                this.definition.addAll(dd.definition);
                return true;
            }
            for (MetaEntry me : ManageDeviceDefinitions.this.metaDefinitions) {
                if (!me.name.equalsIgnoreCase(name)) continue;
                this.definition = new ArrayList<String>();
                this.definition.addAll(me.list);
                return true;
            }
            return false;
        }

        private void directReplacement(String tag, String fullLine) {
            if (this.definition == null) {
                throw new RuntimeException("No source definition found", null);
            }
            tag = tag.toLowerCase();
            int i = 0;
            while (i < this.definition.size()) {
                String line = this.definition.get(i);
                String cmd = "";
                int j = line.indexOf(32);
                if (j < 0) {
                    j = line.length();
                }
                if ((cmd = line.substring(0, j).toLowerCase()).equals(tag)) {
                    this.definition.set(i, fullLine);
                    if (this.metaDebug) {
                        System.out.println(fullLine);
                    }
                }
                ++i;
            }
        }

        private void removeSection(String tag) {
            if (this.definition == null) {
                throw new RuntimeException("No source definition found", null);
            }
            tag = tag.toLowerCase();
            int i = 0;
            while (i < this.definition.size()) {
                String line = this.definition.get(i).toLowerCase();
                if (line.startsWith(tag)) {
                    if (this.metaDebug) {
                        System.out.println("#remove " + tag);
                    }
                    this.definition.remove(i);
                    while (i < this.definition.size() && !this.definition.get(i).startsWith("#")) {
                        this.definition.remove(i);
                    }
                    break;
                }
                ++i;
            }
        }

        private void replaceSection(String tag, int defIndex) {
            if (this.definition == null) {
                throw new RuntimeException("No source definition found", null);
            }
            tag = tag.toLowerCase();
            int i = 0;
            while (i < this.definition.size()) {
                String line = this.definition.get(i).toLowerCase();
                if (line.startsWith(tag)) {
                    ++i;
                    if (this.metaDebug) {
                        System.out.println("#replace " + tag);
                    }
                    while (!this.definition.get(i).startsWith("#")) {
                        this.definition.remove(i);
                    }
                    int j = defIndex + 1;
                    while (j < this.metaDef.list.size() && !this.metaDef.list.get(j).startsWith("#")) {
                        this.definition.add(i++, this.metaDef.list.get(j));
                        ++j;
                    }
                    break;
                }
                ++i;
            }
        }

        private void removeLine(String tag) {
            if (this.definition == null) {
                throw new RuntimeException("No source definition found", null);
            }
            int i = 0;
            do {
                tag = tag.toLowerCase();
                String line = this.definition.get(i).toLowerCase();
                if (line.startsWith(tag)) {
                    if (this.metaDebug) {
                        System.out.println("#removeLine " + line);
                    }
                    this.definition.remove(i);
                    continue;
                }
                ++i;
            } while (i < this.definition.size());
        }

        private void replaceText(String params) {
            int i;
            String word = "";
            if (params.charAt(0) == '\"') {
                i = params.indexOf(34, 1);
                if (i < 0) {
                    return;
                }
                word = params.substring(1, i);
            } else {
                i = params.indexOf(32);
                if (i < 0) {
                    i = params.length();
                }
                word = params.substring(0, i);
            }
            String replacement = params.substring(i + 1).trim();
            int j = 0;
            while (j < this.definition.size()) {
                String originalLine = this.definition.get(j);
                String line = originalLine.replace(word, replacement);
                if (!line.equals(originalLine)) {
                    this.definition.set(j, line);
                    if (this.metaDebug) {
                        System.out.println("#ReplaceText to " + line);
                    }
                }
                ++j;
            }
        }

        private void handleMetaSections(String sections) {
            if (this.metaSectionsDone) {
                System.out.println("Multiple #sections specificed in the same #metadef");
                throw new RuntimeException("Multiple #sections specificed in the same #metadef");
            }
            HashSet<String> sec = new HashSet<String>();
            String[] stringArray = sections.trim().toLowerCase().split("[;, ]+");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.length() > 0) {
                    sec.add(s);
                }
                ++n2;
            }
            ArrayList<String> newdef = new ArrayList<String>();
            boolean include = true;
            for (String line : this.definition) {
                if (line.toLowerCase().startsWith("#metasection")) {
                    HashSet<String> reqSec = new HashSet<String>();
                    String[] stringArray2 = line.substring("#metasection".length()).trim().toLowerCase().split("[,; ]+");
                    int n3 = stringArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String s = stringArray2[n4];
                        if (s.length() > 0) {
                            reqSec.add(s);
                        }
                        ++n4;
                    }
                    include = true;
                    for (String name : reqSec) {
                        if (sec.contains(name)) continue;
                        include = false;
                        break;
                    }
                    if (!this.metaDebug) continue;
                    System.out.println(String.valueOf(line) + (include ? "  --Include--" : "  --Exclude--"));
                    continue;
                }
                if (!include) continue;
                newdef.add(line);
            }
            this.definition = newdef;
            this.metaSectionsDone = true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean process(MetaEntry metaDef) {
            try {
                this.definition = null;
                this.metaSectionsDone = false;
                this.metaDef = metaDef;
                int defIndex = 0;
                while (true) {
                    if (defIndex >= metaDef.list.size()) {
                        if (!this.metaSectionsDone) {
                            this.handleMetaSections("");
                        }
                        this.saveDefinition();
                        return true;
                    }
                    String line = metaDef.list.get(defIndex);
                    String cmd = "";
                    String params = "";
                    int i = line.indexOf(32);
                    if (i < 0) {
                        i = line.length();
                    }
                    cmd = line.substring(0, i).toLowerCase();
                    params = line.substring(i).trim();
                    if (cmd.equals("#metadef")) {
                        if (!this.getDefinition(params)) {
                            return false;
                        }
                        this.metaDebug = false;
                        this.metaSectionsDone = false;
                        this.save = false;
                    } else if (cmd.equals("#replace")) {
                        this.replaceSection(params, defIndex);
                    } else if (cmd.equals("#sections")) {
                        this.handleMetaSections(params);
                    } else if (cmd.equals("#remove")) {
                        this.removeSection(params);
                    } else if (cmd.equals("#removeline")) {
                        this.removeLine(params);
                    } else if (cmd.equals("#replacetext")) {
                        this.replaceText(params);
                    } else if (cmd.equals("#metadebug")) {
                        this.metaDebug = true;
                        this.save = params.equalsIgnoreCase("save");
                        System.out.println("#metaDebug on " + metaDef.name);
                    } else if (this.isDirectReplaceTag(cmd)) {
                        this.directReplacement(cmd, line);
                    }
                    ++defIndex;
                }
            }
            catch (Exception e) {
                if (this.metaDebug) {
                    e.printStackTrace(System.out);
                }
                throw e;
            }
        }
    }
}

