/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.SerialInterface;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.IconGenerator;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.Support;
import dk.hkj.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class LoadDeviceConfig
implements TableModel {
    public static final String searchAddress = "Search socket";
    private final String tagScanSerialPorts = "ScanSerialPorts:";
    private final String tagExcludedSerialPorts = "ExcludedSerialPorts:";
    private String excludedSerialPorts = "";
    private boolean searchSerialPorts = false;
    private List<LoadDevice> loadDevices = new ArrayList<LoadDevice>();
    private List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private boolean changed = false;

    public void init() {
        this.loadDefault();
    }

    public void disableAll() {
        for (LoadDevice ld : this.loadDevices) {
            ld.setEnabled(false);
        }
        this.changeNotification(0, this.loadDevices.size() - 1);
    }

    public boolean isSearchSerialPorts() {
        return this.searchSerialPorts;
    }

    public void setSearchSerialPorts(Boolean on) {
        if (this.searchSerialPorts != on) {
            this.searchSerialPorts = on;
            this.changed = true;
        }
    }

    public String getExcludedSerialPorts() {
        return this.excludedSerialPorts;
    }

    public boolean isExcluded(String port) {
        String[] ports;
        String[] stringArray = ports = this.excludedSerialPorts.split("[,;| ]+");
        int n = ports.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            if (port.equalsIgnoreCase(p.trim())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setExcludedSerialPorts(String ports) {
        if (!this.excludedSerialPorts.equals(ports)) {
            this.excludedSerialPorts = ports;
            this.changed = true;
        }
    }

    public List<String> getErrors() {
        ArrayList<String> list = new ArrayList<String>();
        for (LoadDevice ld : this.loadDevices) {
            if (!ld.isEnabled() || ld.isValid()) continue;
            if (ld.address.isEmpty()) {
                list.add("Missing address for: " + ld.device);
                continue;
            }
            if (ld.portType != ManageDeviceDefinitions.PortType.GPIB) continue;
            list.add("Format for GPIB is GPIB_id:local_address: " + ld.device);
        }
        return list;
    }

    public List<LoadDevice> getDeviceType(ManageDeviceDefinitions.PortType portType) {
        ArrayList<LoadDevice> list = new ArrayList<LoadDevice>();
        for (LoadDevice ld : this.loadDevices) {
            if (!ld.isEnabled() || !ld.isValid() || ld.getPortType() != portType) continue;
            list.add(ld);
        }
        return list;
    }

    public void removeDevice(int no) {
        this.loadDevices.remove(no);
        this.changed = true;
        this.changeNotification(no, this.loadDevices.size());
    }

    public void removeDevice(String deviceName) {
        ArrayList<Integer> removeList = new ArrayList<Integer>();
        int i = 0;
        while (i < this.loadDevices.size()) {
            if (this.getIndex(i).getDevice().equalsIgnoreCase(deviceName)) {
                removeList.add(i);
            }
            ++i;
        }
        i = removeList.size() - 1;
        while (i >= 0) {
            this.removeDevice((Integer)removeList.get(i));
            this.changeNotification(i, this.loadDevices.size());
            this.changed = true;
            --i;
        }
    }

    public LoadDevice getIndex(int i) {
        return i < this.loadDevices.size() ? this.loadDevices.get(i) : null;
    }

    public List<LoadDevice> getList() {
        return this.loadDevices;
    }

    public LoadDevice findDeviceName(String name, String address) {
        if (address != null && address.length() > 0) {
            for (LoadDevice ld : this.loadDevices) {
                if (!ld.device.equalsIgnoreCase(name) || !ld.address.equalsIgnoreCase(address) && ld.address.length() != 0) continue;
                return ld;
            }
        } else {
            for (LoadDevice ld : this.loadDevices) {
                if (!ld.device.equalsIgnoreCase(name)) continue;
                return ld;
            }
        }
        ManageDeviceDefinitions.DeviceDefinition def = Support.manageDeviceDefinitions.findDeviceDefintionFromName(name);
        if (def == null) {
            return null;
        }
        return this.addDevice(name, def.getPortType());
    }

    public LoadDevice findDeviceHandle(String handle, String address) {
        ManageDeviceDefinitions.DeviceDefinition def = Support.manageDeviceDefinitions.findDeviceDefintionFromHandle(handle);
        return this.findDeviceName(def.getDeviceName(), address);
    }

    public LoadDevice addDeviceSecure(String name) {
        if (name.equals(searchAddress)) {
            return this.addDevice(searchAddress, ManageDeviceDefinitions.PortType.SocketAuto);
        }
        ManageDeviceDefinitions.DeviceDefinition def = Support.manageDeviceDefinitions.findDeviceDefintionFromName(name);
        if (def == null) {
            return null;
        }
        return this.addDeviceSecure(name, def.getPortType());
    }

    public LoadDevice addDeviceSecure(String name, ManageDeviceDefinitions.PortType portType) {
        LoadDevice ld = new LoadDevice(name, portType);
        for (LoadDevice ld1 : this.loadDevices) {
            if (!ld1.equals(ld)) continue;
            return ld1;
        }
        this.loadDevices.add(ld);
        this.changed = true;
        this.changeNotification(0, this.loadDevices.size());
        return ld;
    }

    public LoadDevice addDevice(String name) {
        if (name.equals(searchAddress)) {
            return this.addDevice(searchAddress, ManageDeviceDefinitions.PortType.SocketAuto);
        }
        ManageDeviceDefinitions.DeviceDefinition def = Support.manageDeviceDefinitions.findDeviceDefintionFromName(name);
        if (def == null) {
            return null;
        }
        return this.addDevice(name, def.getPortType());
    }

    private LoadDevice addDevice(String name, ManageDeviceDefinitions.PortType portType) {
        LoadDevice ld = new LoadDevice(name, portType);
        this.loadDevices.add(ld);
        this.changed = true;
        this.changeNotification(0, this.loadDevices.size());
        return ld;
    }

    @Override
    public void addTableModelListener(TableModelListener arg0) {
        this.listeners.add(arg0);
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return JComboBox.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return Boolean.class;
            }
            case 5: {
                return ImageIcon.class;
            }
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Device";
            }
            case 1: {
                return "Type";
            }
            case 2: {
                return "Address";
            }
            case 3: {
                return "Baudrate";
            }
            case 4: {
                return "Enable";
            }
            case 5: {
                return "Notes";
            }
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.loadDevices.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        LoadDevice loadDevice = this.loadDevices.get(row);
        switch (column) {
            case 0: {
                return loadDevice.getDevice();
            }
            case 1: {
                return ManageDeviceDefinitions.portTypeToString(loadDevice.portType);
            }
            case 2: {
                if (loadDevice.getPortType() == ManageDeviceDefinitions.PortType.None) {
                    return "-";
                }
                if (loadDevice.getPortType() == ManageDeviceDefinitions.PortType.USBHID && loadDevice.getAddress().length() == 0) {
                    return "-";
                }
                return loadDevice.getAddress();
            }
            case 3: {
                if (loadDevice.getPortType() == ManageDeviceDefinitions.PortType.Serial) {
                    return loadDevice.getBaudrate();
                }
                return "-";
            }
            case 4: {
                return loadDevice.isEnabled();
            }
            case 5: {
                if (loadDevice.hasNotes()) {
                    return IconGenerator.makeIcon(IconGenerator.IconType.ViewButton);
                }
                return "";
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (column == 4) {
            return true;
        }
        LoadDevice loadDevice = this.loadDevices.get(row);
        if (column == 1) {
            return loadDevice.hasMultiplePorts();
        }
        if (column == 2) {
            switch (loadDevice.getPortType()) {
                case Serial: 
                case SerialFixedBaud: 
                case SerialNoBaud: 
                case SocketAuto: 
                case Socket: 
                case SocketFilter: 
                case Telnet: 
                case LXI: 
                case USBHID: 
                case GPIB: 
                case UDP: {
                    return true;
                }
            }
        } else if (column == 3) {
            switch (loadDevice.getPortType()) {
                case Serial: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void setValueAt(Object val, int row, int column) {
        LoadDevice loadDevice = this.loadDevices.get(row);
        if (column == 4 && val instanceof Boolean) {
            loadDevice.setEnabled((Boolean)val);
        } else if (column == 2) {
            loadDevice.setAddress((String)val);
        } else if (column == 1) {
            loadDevice.setPortType((String)val);
        } else if (column == 3) {
            loadDevice.setBaudrate(SerialInterface.formatSettingString((String)val));
        }
        for (TableModelListener ml : this.listeners) {
            ml.tableChanged(new TableModelEvent(this, row, row, -1, 0));
        }
    }

    private void changeNotificationSync(int firstRow, int lastRow) {
        for (TableModelListener ml : this.listeners) {
            ml.tableChanged(new TableModelEvent(this));
        }
    }

    public void changeNotification(final int firstRow, final int lastRow) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.changeNotificationSync(firstRow, lastRow);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LoadDeviceConfig.this.changeNotificationSync(firstRow, lastRow);
                }
            });
        }
    }

    public void sortDevice() {
        this.loadDevices.sort(null);
        this.changeNotification(0, this.loadDevices.size());
    }

    public void sortAddress() {
        this.loadDevices.sort(new Comparator<LoadDevice>(){

            @Override
            public int compare(LoadDevice arg0, LoadDevice arg1) {
                int i = arg0.getAddress().toLowerCase().compareTo(arg1.getAddress().toLowerCase());
                if (i != 0) {
                    return i;
                }
                return arg0.compareTo(arg1);
            }
        });
        this.changeNotification(0, this.loadDevices.size());
    }

    public void saveToFile(File file) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("ScanSerialPorts:" + (this.searchSerialPorts ? 1 : 0));
        list.add("ExcludedSerialPorts:" + this.excludedSerialPorts);
        for (LoadDevice ld : this.loadDevices) {
            list.add(ld.toString());
        }
        try {
            FileUtil.writeFile(file, list);
        }
        catch (IOException iOException) {}
    }

    public void loadFromFile(File file) {
        try {
            List<String> list = FileUtil.readFileAsList(file);
            for (String line : list) {
                if ((line = line.trim()).startsWith("ScanSerialPorts:")) {
                    this.searchSerialPorts = Integer.parseInt(line.substring("ScanSerialPorts:".length())) != 0;
                    continue;
                }
                if (line.startsWith("ExcludedSerialPorts:")) {
                    this.excludedSerialPorts = line.substring("ExcludedSerialPorts:".length());
                    continue;
                }
                if (line.length() <= 0 || line.startsWith(";") || !line.contains("|")) continue;
                this.loadDevices.add(new LoadDevice(line));
            }
            this.loadDevices.sort(null);
            this.changeNotification(0, this.loadDevices.size());
        }
        catch (IOException iOException) {}
    }

    public void saveDefault() {
        if (!this.changed) {
            return;
        }
        this.loadDevices.sort(null);
        this.saveToFile(new File(String.valueOf(Support.getConfigPath()) + "/settingsLoad.txt"));
        this.changed = false;
    }

    public void loadDefault() {
        this.loadFromFile(new File(String.valueOf(Support.getConfigPath()) + "/settingsLoad.txt"));
        this.loadDevices.sort(null);
        this.changed = false;
    }

    public class LoadDevice
    implements Comparable<LoadDevice> {
        private ManageDeviceDefinitions.PortType portType = ManageDeviceDefinitions.PortType.None;
        private String device = "";
        private String address = "";
        private String baudrate = "9600";
        private boolean enabled = true;
        private Boolean hasNotes = null;
        private ManageDeviceDefinitions.DeviceDefinition def = null;

        private LoadDevice(String line) {
            for (Support.ConfigLineElement element : new Support.ConfigLineSplitter(line)) {
                if (element.name.equals("Device")) {
                    this.setDevice(element.value);
                    continue;
                }
                if (element.name.equals("PortType")) {
                    this.setPortType(element.value);
                    continue;
                }
                if (element.name.equals("Address")) {
                    this.setAddress(element.value);
                    continue;
                }
                if (element.name.equals("Baudrate")) {
                    this.setBaudrate(element.value);
                    continue;
                }
                if (!element.name.equals("Enabled")) continue;
                this.setEnabled(Integer.parseInt(element.value) != 0);
            }
        }

        private ManageDeviceDefinitions.DeviceDefinition getDef() {
            if (this.def == null) {
                this.def = Support.manageDeviceDefinitions.findDeviceDefintionFromName(this.getDevice());
            }
            return this.def;
        }

        public boolean hasMultiplePorts() {
            if (this.getDef() == null) {
                return false;
            }
            return this.def.getPorts().split("[ ]+").length > 1;
        }

        public List<String> getPortList() {
            ArrayList<String> list = new ArrayList<String>();
            for (ManageDeviceDefinitions.PortType p : this.def.getPortList()) {
                list.add(ManageDeviceDefinitions.portTypeToString(p));
            }
            return list;
        }

        public String getBaudrate() {
            return this.baudrate;
        }

        public boolean hasNotes() {
            if (this.hasNotes != null) {
                return this.hasNotes;
            }
            this.hasNotes = false;
            if (this.getDef() == null) {
                return this.hasNotes;
            }
            String s = this.def.getItem("#noteImages");
            if (s != null && s.trim().length() > 0) {
                this.hasNotes = true;
            }
            if ((s = this.def.getItem("#notes")) != null && s.trim().length() > 0) {
                this.hasNotes = true;
            }
            return this.hasNotes;
        }

        public void setBaudrate(String baudrate) {
            this.baudrate = baudrate;
        }

        public boolean equals(Object o) {
            if (!(o instanceof LoadDevice)) {
                return false;
            }
            LoadDevice ld = (LoadDevice)o;
            if (!ld.device.equals(this.device)) {
                return false;
            }
            if (!ld.address.equals(this.address)) {
                return false;
            }
            return ld.portType.equals((Object)this.portType);
        }

        public int hashCode() {
            return this.device.hashCode() ^ this.address.hashCode() ^ this.portType.hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Device:");
            sb.append(this.device);
            sb.append("|PortType:");
            sb.append(ManageDeviceDefinitions.portTypeToString(this.portType));
            sb.append("|Address:");
            sb.append(this.address);
            sb.append("|Baudrate:");
            sb.append(this.baudrate);
            sb.append("|Enabled:");
            sb.append(this.enabled ? 1 : 0);
            return sb.toString();
        }

        private LoadDevice(String device, ManageDeviceDefinitions.PortType portType) {
            this.device = device;
            this.portType = portType;
        }

        public String getAddressWithSearch() {
            if ((this.portType.equals((Object)ManageDeviceDefinitions.PortType.LXI) || this.portType.equals((Object)ManageDeviceDefinitions.PortType.Socket)) && this.address.length() == 0 || this.address.toLowerCase().startsWith("sn:")) {
                InterfaceThreads.discovery.discover();
                ManageDeviceDefinitions.DeviceDefinition def = Support.manageDeviceDefinitions.findDeviceDefintionFromName(this.getDevice());
                if (def != null) {
                    return InterfaceThreads.discovery.findDeviceAddress(def.getIdName(), this.address);
                }
            }
            return this.address;
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address.trim().replace("|", "");
            LoadDeviceConfig.this.changed = true;
        }

        public ManageDeviceDefinitions.PortType getPortType() {
            return this.portType;
        }

        public boolean isValid() {
            if (!this.enabled) {
                return true;
            }
            switch (this.portType) {
                case None: {
                    return true;
                }
                case Serial: {
                    return this.address.length() > 0;
                }
                case SerialFixedBaud: {
                    return this.address.length() > 0;
                }
                case SerialNoBaud: {
                    return this.address.length() > 0;
                }
                case SocketAuto: {
                    return this.address.length() > 0;
                }
                case Socket: {
                    return true;
                }
                case UDP: {
                    return this.address.length() > 0;
                }
                case SocketFilter: {
                    return this.address.length() > 0;
                }
                case Telnet: {
                    return this.address.length() > 0;
                }
                case LXI: {
                    return true;
                }
                case GPIB: {
                    return this.address.split(":").length == 2;
                }
                case USBHID: {
                    return true;
                }
            }
            return false;
        }

        void setPortType(String type) {
            this.setPortType(ManageDeviceDefinitions.stringToPortType(type));
        }

        public void setPortType(ManageDeviceDefinitions.PortType portType) {
            this.portType = portType;
            LoadDeviceConfig.this.changed = true;
        }

        public String getDevice() {
            return this.device;
        }

        public void setDevice(String device) {
            this.device = device.trim().replace("|", "");
            LoadDeviceConfig.this.changed = true;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
            LoadDeviceConfig.this.changeNotification(0, LoadDeviceConfig.this.loadDevices.size());
            LoadDeviceConfig.this.changed = true;
        }

        @Override
        public int compareTo(LoadDevice ld) {
            int i = this.device.compareTo(ld.device);
            if (i != 0) {
                return i;
            }
            i = ManageDeviceDefinitions.portTypeToString(this.portType).compareTo(ManageDeviceDefinitions.portTypeToString(ld.getPortType()));
            if (i != 0) {
                return i;
            }
            return this.address.toLowerCase().compareTo(ld.address.toLowerCase());
        }
    }
}

