/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommDataInterface;
import dk.hkj.comm.CommInterface;
import dk.hkj.comm.LayerInterface;
import dk.hkj.comm.SerialInterface;
import dk.hkj.comm.SerialPacketInterface;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.SCPICommand;
import dk.hkj.main.Support;
import dk.hkj.main.ValueFormat;
import java.util.ArrayList;

public class DeviceVC8145
extends DeviceInterface {
    private VCInterface ci;
    private String selectedMode = "";
    private int overflowCounter = 0;
    private String lastValue = "";
    private String currentMode = "";
    private String outputMessage = null;
    private String lastMessage = null;
    private long rate = 0L;
    private long lastTime = 0L;

    public DeviceVC8145(ManageDeviceDefinitions.DeviceDefinition def) {
        super(def);
        this.valueFormats.add(new ValueFormat("VoltageDC", "V", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("VoltageAC", "V", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("VoltageACDC", "V", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("CurrentDC", "A", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("CurrentAC", "A", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("CurrentACDC", "A", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("Resistance", "ohm", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("Capacitance", "F", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("Frequency", "Hz", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("DutyCycle", "%", ValueFormat.formatD2));
        this.valueFormats.add(new ValueFormat("Temperature", "\u00b0C", ValueFormat.formatD1));
        this.valueFormats.add(new ValueFormat("dBm", "", ValueFormat.formatD2));
        this.valueFormats.add(new ValueFormat("RPM", "/m", ValueFormat.formatSI));
    }

    private void selectMode() {
        this.valueNames = new ArrayList();
        this.selectedMode = this.currentMode;
        if (this.currentMode.equals("VDC") || this.currentMode.equals("V") || this.currentMode.length() == 0) {
            this.valueNames.add("VoltageDC");
        } else if (this.currentMode.equals("VAC")) {
            this.valueNames.add("VoltageAC");
        } else if (this.currentMode.equals("VACDC")) {
            this.valueNames.add("VoltageACDC");
        } else if (this.currentMode.equals("ADC") || this.currentMode.equals("A")) {
            this.valueNames.add("CurrentDC");
        } else if (this.currentMode.equals("AAC")) {
            this.valueNames.add("CurrentAC");
        } else if (this.currentMode.equals("AACDC")) {
            this.valueNames.add("CurrentACDC");
        } else if (this.currentMode.equalsIgnoreCase("Ohm")) {
            this.valueNames.add("Resistance");
        } else if (this.currentMode.equals("F")) {
            this.valueNames.add("Capacitance");
        } else if (this.currentMode.equalsIgnoreCase("Hz")) {
            this.valueNames.add("Frequency");
        } else if (this.currentMode.equalsIgnoreCase("%")) {
            this.valueNames.add("DutyCycle");
        } else if (this.currentMode.equalsIgnoreCase("W")) {
            this.valueNames.add("Watt");
        } else if (this.currentMode.equalsIgnoreCase("TempF") || this.currentMode.equalsIgnoreCase("TempC")) {
            this.valueNames.add("Temperature");
        } else if (this.currentMode.equalsIgnoreCase("%mA")) {
            this.valueNames.add("mA4_20");
        } else if (this.currentMode.equalsIgnoreCase("dBm")) {
            this.valueNames.add("dBm");
        } else if (this.currentMode.equalsIgnoreCase("RPM")) {
            this.valueNames.add("RPM");
        } else {
            System.out.println("Mode not found " + this.currentMode);
        }
    }

    @Override
    public synchronized void initColumns() {
        if (this.valueNames != null) {
            return;
        }
        super.initColumns();
        this.selectMode();
        this.askValueCommand = new SCPICommand((DeviceInterface)this, "VALUE?");
    }

    public static String deviceName() {
        return "UNI-T";
    }

    @Override
    public String getDeviceName() {
        return this.def.getDeviceName();
    }

    @Override
    public String getDeviceId() {
        return this.def.getIdName();
    }

    @Override
    public CommInterface getCommInterface(CommInterface ci) {
        if (!(ci instanceof SerialInterface)) {
            return null;
        }
        ((SerialInterface)ci).setTimeout(1000);
        this.ci = new VCInterface(((SerialInterface)ci).getDataInterface());
        return this.ci;
    }

    private class VCInterface
    extends LayerInterface {
        protected VCInterface(CommInterface ci) {
            super(ci);
        }

        @Override
        public void open() {
            super.open();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        ((SerialPacketInterface)VCInterface.this.originalCommInterface).setPacketFormat(CommDataInterface.PacketFormat.HeaderFixedLength, (byte)-119, 12);
                        while (VCInterface.this.originalCommInterface.isOpen()) {
                            VCInterface.this.readFromSerialPort();
                        }
                    }
                    catch (Exception exception) {}
                }
            };
            new Thread(r).start();
        }

        private synchronized void setMessage(byte[] data) {
            DeviceVC8145.this.lastMessage = this.decoder(data);
            long t = System.currentTimeMillis();
            DeviceVC8145.this.rate = t - DeviceVC8145.this.lastTime;
            DeviceVC8145.this.lastTime = t;
        }

        protected void readFromSerialPort() {
            try {
                this.originalCommInterface.flush();
                ((SerialPacketInterface)this.originalCommInterface).writeData(new byte[]{-119});
                byte[] data = ((SerialPacketInterface)this.originalCommInterface).readData(500);
                if (data != null) {
                    this.setMessage(data);
                }
                SerialInterface.sleep(100);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }

        private double dataToNumber(byte[] data, int from, int bytes) {
            double v = 0.0;
            int i = from;
            while (i < from + bytes) {
                byte c = data[i];
                if (c >= 48 && c <= 57) {
                    v = v * 10.0 + (double)(c - 48);
                } else if (c == 62) {
                    v = Double.POSITIVE_INFINITY;
                }
                ++i;
            }
            return v;
        }

        protected String decoder(byte[] data) {
            if (data[0] != -119) {
                return null;
            }
            double val = this.dataToNumber(data, 5, 5);
            String mode = "";
            int select = data[1] & 3;
            int r = data[2] >> 3 & 7;
            double scaleModifier = (new double[]{1.0E-4, 0.001, 0.01, 0.1, 1.0, 10.0, 100.0, 1000.0})[r];
            if ((data[4] & 0x10) != 0) {
                scaleModifier = -scaleModifier;
            }
            block0 : switch (data[1] >> 3 & 0xF) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    switch (select) {
                        case 0: {
                            mode = "ADC";
                            break;
                        }
                        case 1: 
                        case 3: {
                            mode = "AAC";
                            break;
                        }
                        case 2: {
                            mode = "AACDC";
                        }
                    }
                    break;
                }
                case 6: {
                    mode = "A";
                    scaleModifier *= 0.01;
                    switch (select) {
                        case 0: {
                            mode = "ADC";
                            break;
                        }
                        case 1: 
                        case 3: {
                            mode = "AAC";
                            break;
                        }
                        case 2: {
                            mode = "AACDC";
                        }
                    }
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    mode = "TempC";
                    switch (select) {
                        case 0: {
                            scaleModifier *= 10.0;
                            break;
                        }
                        case 1: {
                            scaleModifier *= 1000.0;
                        }
                    }
                    break;
                }
                case 9: {
                    mode = "F";
                    scaleModifier *= 1.0E-9;
                    break;
                }
                case 10: {
                    switch (select) {
                        case 0: {
                            mode = "Hz";
                            scaleModifier *= 10.0;
                            break;
                        }
                        case 1: {
                            mode = "Hz";
                            scaleModifier *= 10000.0;
                            break;
                        }
                        case 2: {
                            mode = "RPM";
                            scaleModifier *= 10.0;
                        }
                    }
                    break;
                }
                case 11: {
                    mode = "VDC";
                    break;
                }
                case 12: {
                    mode = "Ohm";
                    if (select == 2) {
                        scaleModifier *= 100000.0;
                        break;
                    }
                    scaleModifier *= 100.0;
                    break;
                }
                case 13: {
                    switch (select) {
                        case 0: {
                            mode = "VDC";
                            scaleModifier *= 0.01;
                            break;
                        }
                        case 1: {
                            mode = "VAC";
                            scaleModifier *= 0.01;
                            break;
                        }
                        case 2: {
                            mode = "dBm";
                            scaleModifier *= 100.0;
                        }
                    }
                    break;
                }
                case 14: {
                    switch (select) {
                        case 0: {
                            mode = "VDC";
                            break;
                        }
                        case 1: {
                            mode = "VACDC";
                            break;
                        }
                        case 2: {
                            mode = "dBm";
                            scaleModifier *= 100.0;
                        }
                    }
                    break;
                }
                case 15: {
                    switch (select) {
                        case 0: {
                            mode = "VAC";
                            break block0;
                        }
                        case 1: {
                            mode = "VAC";
                            break block0;
                        }
                        case 2: {
                            mode = "dBm";
                            scaleModifier *= 100.0;
                        }
                    }
                }
            }
            DeviceVC8145.this.currentMode = mode;
            if (!DeviceVC8145.this.selectedMode.equals(mode)) {
                DeviceVC8145.this.requestInitColumns();
            }
            if (!Double.isFinite(val)) {
                DeviceVC8145 deviceVC8145 = DeviceVC8145.this;
                deviceVC8145.overflowCounter = deviceVC8145.overflowCounter + 1;
                if (DeviceVC8145.this.overflowCounter <= Support.systemSettings.delayOverflow) {
                    return DeviceVC8145.this.lastValue;
                }
                return DeviceVC8145.this.overflowValueString(scaleModifier >= 0.0);
            }
            DeviceVC8145.this.lastValue = Double.toString(val * scaleModifier);
            DeviceVC8145.this.overflowCounter = 0;
            return DeviceVC8145.this.lastValue;
        }

        protected boolean stdCommands(String msg) {
            if (msg.equalsIgnoreCase("*idn?")) {
                DeviceVC8145.this.outputMessage = DeviceVC8145.this.def.getIdName();
                return true;
            }
            if (msg.equalsIgnoreCase("rate?")) {
                DeviceVC8145.this.outputMessage = Long.toString(DeviceVC8145.this.rate);
                return true;
            }
            if (msg.equalsIgnoreCase("mode?")) {
                DeviceVC8145.this.outputMessage = DeviceVC8145.this.currentMode;
                return true;
            }
            if (msg.equalsIgnoreCase("value?")) {
                DeviceVC8145.this.outputMessage = System.currentTimeMillis() - DeviceVC8145.this.lastTime < 2000L ? DeviceVC8145.this.lastMessage : null;
                return true;
            }
            return false;
        }

        @Override
        public synchronized boolean write(String msg) {
            this.log("Tx", msg);
            return this.stdCommands(msg);
        }

        @Override
        public boolean isData() {
            return DeviceVC8145.this.outputMessage != null;
        }

        @Override
        public String read() {
            return this.read(300);
        }

        @Override
        public synchronized String read(int timeout) {
            String s = DeviceVC8145.this.outputMessage;
            DeviceVC8145.this.outputMessage = null;
            return s;
        }
    }
}

