/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommDataInterface;
import dk.hkj.comm.CommInterface;
import dk.hkj.comm.HidClass;
import dk.hkj.devices.DecoderClass;
import dk.hkj.devices.DecoderDLM;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.SCPICommand;
import dk.hkj.main.Support;
import dk.hkj.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DeviceUsbHidDevice
extends DeviceInterface {
    private TranslatingInterface ti;
    private int overflowCounter = 0;
    private String lastValue = "";
    protected DecoderClass decoder = null;
    protected String selectedMode = "";
    protected List<String> message = Collections.synchronizedList(new ArrayList());

    public DeviceUsbHidDevice(ManageDeviceDefinitions.DeviceDefinition def) {
        super(def);
    }

    @Override
    public synchronized void initColumns() {
        if (this.valueNames != null) {
            return;
        }
        super.initColumns();
        this.ti.communicate(this.def.getReadingDelay());
        this.askValueCommand = new SCPICommand((DeviceInterface)this, "VALUE?");
    }

    public static String deviceName() {
        return "Device xxx";
    }

    @Override
    public String getDeviceName() {
        return this.def.getDeviceName();
    }

    @Override
    public String getDeviceId() {
        return this.def.getIdName();
    }

    @Override
    protected boolean mayModifyColumns(String cmd) {
        return cmd.equalsIgnoreCase("modeset?");
    }

    @Override
    public CommInterface getCommInterface(CommInterface ci) {
        if (!(ci instanceof HidClass)) {
            return null;
        }
        String driver = this.def.getItem("#subDriver");
        if (driver.equalsIgnoreCase("DLM")) {
            this.decoder = new DecoderDLM();
        }
        ci.setTimeout(this.def.getReadingDelay() - 50);
        ((HidClass)ci).setPacketFormat(CommDataInterface.PacketFormat.FixedLength, this.decoder.messageSize());
        this.ti = new TranslatingInterface((HidClass)ci);
        this.ti.setTimeout(this.def.getReadingDelay());
        return this.ti;
    }

    class TranslatingInterface
    extends CommInterface {
        private HidClass hid;

        public TranslatingInterface(HidClass hid) {
            this.hid = hid;
        }

        @Override
        public ManageDeviceDefinitions.PortType getPortType() {
            return ManageDeviceDefinitions.PortType.USBHID;
        }

        @Override
        public String getName() {
            return this.hid.getName();
        }

        @Override
        public void open() {
            this.hid.open();
            this.communicate(this.timeout);
            if (DeviceUsbHidDevice.this.decoder.getMode().length() == 0) {
                this.close();
            }
        }

        @Override
        public void close() {
            this.hid.close();
        }

        private void communicate(int timeout) {
            byte[] poll = DeviceUsbHidDevice.this.def.getItemBytes("#usbpoll");
            byte[] b = poll != null ? this.hid.writeReadData(poll, timeout) : this.hid.readData(timeout);
            DeviceUsbHidDevice.this.decoder.decode(b);
            if (this.debugLog) {
                this.logLog("TxRx poll" + (b == null || b.length == 0 ? "  Timeout" : ""));
            }
        }

        @Override
        public synchronized boolean write(String msg) {
            if ((msg = msg.trim()).equalsIgnoreCase("value?")) {
                this.communicate(InterfaceThreads.isLogging() && InterfaceThreads.loggingInterval() > 1500L ? DeviceUsbHidDevice.this.def.getReadingDelay() : 300);
                if (!DeviceUsbHidDevice.this.decoder.mode.equals(DeviceUsbHidDevice.this.selectedMode)) {
                    DeviceUsbHidDevice.this.requestInitColumns();
                }
                if (Double.isNaN(DeviceUsbHidDevice.this.decoder.value)) {
                    DeviceUsbHidDevice deviceUsbHidDevice = DeviceUsbHidDevice.this;
                    deviceUsbHidDevice.overflowCounter = deviceUsbHidDevice.overflowCounter + 1;
                    if (DeviceUsbHidDevice.this.overflowCounter <= Support.systemSettings.delayOverflow) {
                        DeviceUsbHidDevice.this.message.add(DeviceUsbHidDevice.this.lastValue);
                        return true;
                    }
                    DeviceUsbHidDevice.this.lastValue = DeviceUsbHidDevice.this.overflowValueString(DeviceUsbHidDevice.this.decoder.value > 0.0);
                    DeviceUsbHidDevice.this.message.add(DeviceUsbHidDevice.this.lastValue);
                    return true;
                }
                DeviceUsbHidDevice.this.overflowCounter = 0;
                DeviceUsbHidDevice.this.lastValue = StringUtil.formatDoubleEE(DeviceUsbHidDevice.this.decoder.value, false);
                DeviceUsbHidDevice.this.message.add(DeviceUsbHidDevice.this.lastValue);
            } else if (msg.equalsIgnoreCase("mode?")) {
                this.communicate(DeviceUsbHidDevice.this.def.getReadingDelay());
                DeviceUsbHidDevice.this.message.add(DeviceUsbHidDevice.this.decoder.mode);
            } else if (msg.equalsIgnoreCase("*idn?")) {
                DeviceUsbHidDevice.this.message.add(DeviceUsbHidDevice.this.def.getIdName());
            } else {
                return false;
            }
            return true;
        }

        @Override
        public boolean isData() {
            return DeviceUsbHidDevice.this.message.size() > 0;
        }

        @Override
        public String read() {
            return this.read(this.timeout);
        }

        @Override
        public void setTimeout(int timeout) {
            this.timeout = timeout;
            this.hid.setTimeout(timeout);
        }

        @Override
        public synchronized String read(int timeout) {
            return DeviceUsbHidDevice.this.message.size() > 0 ? DeviceUsbHidDevice.this.message.remove(0) : null;
        }

        @Override
        public boolean isOpen() {
            return this.hid.isOpen();
        }

        @Override
        public int getSerialId() {
            return this.hid.getSerialId();
        }

        @Override
        public String getAddress() {
            return "";
        }
    }
}

