/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommDataInterface;
import dk.hkj.comm.CommInterface;
import dk.hkj.comm.HidClass;
import dk.hkj.devices.DecoderBrymen525;
import dk.hkj.devices.DecoderBrymen829;
import dk.hkj.devices.DecoderBrymen869;
import dk.hkj.devices.DecoderClass;
import dk.hkj.devices.DecoderDefinition;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.SCPICommand;
import dk.hkj.main.Support;
import dk.hkj.main.ValueFormat;
import dk.hkj.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DeviceUsbHidDMM
extends DeviceInterface {
    private TranslatingInterface ti;
    private int overflowCounter = 0;
    private String lastValue = "";
    protected DecoderClass decoder = null;
    protected String selectedMode = "";
    protected List<String> message = Collections.synchronizedList(new ArrayList());

    public DeviceUsbHidDMM(ManageDeviceDefinitions.DeviceDefinition def) {
        super(def);
        this.valueFormats.add(new ValueFormat("Voltage", "V", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("VoltageDC", "V", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("VoltageAC", "V", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("VoltageACDC", "V", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("Current", "A", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("CurrentDC", "A", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("CurrentAC", "A", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("CurrentACDC", "A", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("Resistance", "ohm", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("Capacitance", "F", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("Temperature", "\u00b0C", ValueFormat.formatD1));
        this.valueFormats.add(new ValueFormat("DeltaTemp", "\u00b0C", ValueFormat.formatD1));
        this.valueFormats.add(new ValueFormat("Conductance", "S", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("Frequency", "Hz", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("dBm", "", ValueFormat.formatD2));
        this.valueFormats.add(new ValueFormat("dBV", "", ValueFormat.formatD2));
        this.valueFormats.add(new ValueFormat("dB", "", ValueFormat.formatD2));
        this.valueFormats.add(new ValueFormat("CrestFactor", "", ValueFormat.formatD1));
        this.valueFormats.add(new ValueFormat("DutyCycle", "%", ValueFormat.formatD2));
        this.valueFormats.add(new ValueFormat("Pulse", "s", ValueFormat.formatSI));
    }

    private void selectMode(String mode) {
        this.valueNames = new ArrayList();
        this.selectedMode = mode;
        if (mode.equals("V")) {
            this.valueNames.add("Voltage");
        } else if (mode.equals("VDC")) {
            this.valueNames.add("VoltageDC");
        } else if (mode.equals("VAC")) {
            this.valueNames.add("VoltageAC");
        } else if (mode.equalsIgnoreCase("VACDC")) {
            this.valueNames.add("VoltageACDC");
        } else if (mode.equals("A")) {
            this.valueNames.add("Current");
        } else if (mode.equalsIgnoreCase("ADC")) {
            this.valueNames.add("CurrentDC");
        } else if (mode.equalsIgnoreCase("AAC")) {
            this.valueNames.add("CurrentAC");
        } else if (mode.equalsIgnoreCase("AACDC")) {
            this.valueNames.add("CurrentACDC");
        } else if (mode.equalsIgnoreCase("ohm")) {
            this.valueNames.add("Resistance");
        } else if (mode.equalsIgnoreCase("Siemens")) {
            this.valueNames.add("Conductance");
        } else if (mode.equalsIgnoreCase("F")) {
            this.valueNames.add("Capacitance");
        } else if (mode.equalsIgnoreCase("T1") || mode.equals("T2") || mode.equals("Temp")) {
            this.valueNames.add("Temperature");
        } else if (mode.equalsIgnoreCase("T2-T1")) {
            this.valueNames.add("DeltaTemp");
        } else if (mode.equalsIgnoreCase("dBm")) {
            this.valueNames.add("dBm");
        } else if (mode.equalsIgnoreCase("dBV")) {
            this.valueNames.add("dBV");
        } else if (mode.equalsIgnoreCase("dB")) {
            this.valueNames.add("dB");
        } else if (mode.equalsIgnoreCase("Hz")) {
            this.valueNames.add("Frequency");
        } else if (mode.equalsIgnoreCase("DutyCycle")) {
            this.valueNames.add("DutyCycle");
        } else {
            mode = "";
            System.out.println("Mode not found " + mode);
        }
    }

    @Override
    public synchronized void initColumns() {
        if (this.valueNames != null) {
            return;
        }
        super.initColumns();
        this.ti.communicate(this.def.getReadingDelay());
        this.selectMode(this.decoder.getMode());
        this.askValueCommand = new SCPICommand((DeviceInterface)this, "VALUE?");
    }

    public static String deviceName() {
        return "Brymen xxx";
    }

    @Override
    public String getDeviceName() {
        return this.def.getDeviceName();
    }

    @Override
    public String getDeviceId() {
        return this.def.getIdName();
    }

    @Override
    protected boolean mayModifyColumns(String cmd) {
        return cmd.equalsIgnoreCase("modeset?");
    }

    @Override
    public CommInterface getCommInterface(CommInterface ci) {
        if (!(ci instanceof HidClass)) {
            return null;
        }
        String s = this.def.getItem("#subDriver");
        if (s.equals("525")) {
            this.decoder = new DecoderBrymen525();
        } else if (s.equals("829")) {
            this.decoder = new DecoderBrymen829();
        } else if (s.equals("869")) {
            this.decoder = new DecoderBrymen869();
        } else if (s.equalsIgnoreCase("Definition")) {
            this.decoder = new DecoderDefinition(this.def);
        }
        ((HidClass)ci).setPacketFormat(CommDataInterface.PacketFormat.FixedLength, this.decoder.messageSize());
        this.ti = new TranslatingInterface((HidClass)ci);
        return this.ti;
    }

    class TranslatingInterface
    extends CommInterface {
        private HidClass hid;

        public TranslatingInterface(HidClass hid) {
            this.hid = hid;
        }

        @Override
        public String getName() {
            return this.hid.getName();
        }

        @Override
        public ManageDeviceDefinitions.PortType getPortType() {
            return ManageDeviceDefinitions.PortType.USBHID;
        }

        @Override
        public void open() {
            this.hid.open();
            this.communicate(this.timeout);
            if (DeviceUsbHidDMM.this.decoder.getMode().length() == 0) {
                this.close();
            }
        }

        @Override
        public void close() {
            this.hid.close();
        }

        private void communicate(int timeout) {
            System.out.println("xx");
            byte[] b = this.hid.writeReadData(DeviceUsbHidDMM.this.def.getItemBytes("#usbpoll"), timeout);
            DeviceUsbHidDMM.this.decoder.decode(b);
            if (this.debugLog) {
                this.logLog("TxRx poll" + (b == null || b.length == 0 ? "  Timeout" : ""));
            }
        }

        @Override
        public synchronized boolean write(String msg) {
            if ((msg = msg.trim()).equalsIgnoreCase("value?")) {
                this.communicate(InterfaceThreads.isLogging() && InterfaceThreads.loggingInterval() > 1500L ? DeviceUsbHidDMM.this.def.getReadingDelay() : 300);
                if (!DeviceUsbHidDMM.this.decoder.mode.equals(DeviceUsbHidDMM.this.selectedMode)) {
                    DeviceUsbHidDMM.this.requestInitColumns();
                }
                if (Double.isNaN(DeviceUsbHidDMM.this.decoder.value)) {
                    DeviceUsbHidDMM deviceUsbHidDMM = DeviceUsbHidDMM.this;
                    deviceUsbHidDMM.overflowCounter = deviceUsbHidDMM.overflowCounter + 1;
                    if (DeviceUsbHidDMM.this.overflowCounter <= Support.systemSettings.delayOverflow) {
                        DeviceUsbHidDMM.this.message.add(DeviceUsbHidDMM.this.lastValue);
                        return true;
                    }
                    DeviceUsbHidDMM.this.lastValue = DeviceUsbHidDMM.this.overflowValueString(DeviceUsbHidDMM.this.decoder.value > 0.0);
                    DeviceUsbHidDMM.this.message.add(DeviceUsbHidDMM.this.lastValue);
                    return true;
                }
                DeviceUsbHidDMM.this.overflowCounter = 0;
                DeviceUsbHidDMM.this.lastValue = StringUtil.formatDoubleEE(DeviceUsbHidDMM.this.decoder.value, false);
                DeviceUsbHidDMM.this.message.add(DeviceUsbHidDMM.this.lastValue);
            } else if (msg.equalsIgnoreCase("mode?")) {
                this.communicate(DeviceUsbHidDMM.this.def.getReadingDelay());
                DeviceUsbHidDMM.this.message.add(DeviceUsbHidDMM.this.decoder.mode);
            } else if (msg.equalsIgnoreCase("*idn?")) {
                DeviceUsbHidDMM.this.message.add(DeviceUsbHidDMM.this.def.getIdName());
            } else {
                return false;
            }
            return true;
        }

        @Override
        public boolean isData() {
            return DeviceUsbHidDMM.this.message.size() > 0;
        }

        @Override
        public String read() {
            return this.read(this.timeout);
        }

        @Override
        public void setTimeout(int timeout) {
            this.hid.setTimeout(timeout);
        }

        @Override
        public synchronized String read(int timeout) {
            return DeviceUsbHidDMM.this.message.size() > 0 ? DeviceUsbHidDMM.this.message.remove(0) : null;
        }

        @Override
        public boolean isOpen() {
            return this.hid.isOpen();
        }

        @Override
        public int getSerialId() {
            return this.hid.getSerialId();
        }

        @Override
        public String getAddress() {
            return "";
        }
    }
}

