/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommDataInterface;
import dk.hkj.comm.CommInterface;
import dk.hkj.comm.SerialInterface;
import dk.hkj.comm.SerialPacketInterface;
import dk.hkj.comm.StreamingInterface;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.SCPICommand;
import dk.hkj.main.Support;
import dk.hkj.main.ValueFormat;
import java.util.ArrayList;

public class DeviceUnitDMM
extends DeviceInterface {
    private CommInterface ci;
    private String selectedMode = "";
    private int overflowCounter = 0;
    private String lastValue = "";
    private String currentMode = "";

    public DeviceUnitDMM(ManageDeviceDefinitions.DeviceDefinition def) {
        super(def);
        this.valueFormats.add(new ValueFormat("VoltageDC", "V", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("VoltageAC", "V", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("VoltageACDC", "V", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("CurrentDC", "A", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("CurrentAC", "A", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("CurrentACDC", "A", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("Resistance", "ohm", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("Capacitance", "F", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("Frequency", "Hz", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("DutyCycle", "%", ValueFormat.formatD2));
        this.valueFormats.add(new ValueFormat("Watt", "W", ValueFormat.formatD1));
        this.valueFormats.add(new ValueFormat("Temperature", "\u00b0C", ValueFormat.formatD1));
        this.valueFormats.add(new ValueFormat("mA4_20", "%", ValueFormat.formatD2));
    }

    private void selectMode() {
        this.valueNames = new ArrayList();
        this.selectedMode = this.currentMode;
        if (this.currentMode.equals("VDC") || this.currentMode.equals("V") || this.currentMode.length() == 0) {
            this.valueNames.add("VoltageDC");
        } else if (this.currentMode.equals("VAC")) {
            this.valueNames.add("VoltageAC");
        } else if (this.currentMode.equals("VACDC")) {
            this.valueNames.add("VoltageACDC");
        } else if (this.currentMode.equals("ADC") || this.currentMode.equals("A")) {
            this.valueNames.add("CurrentDC");
        } else if (this.currentMode.equals("AAC")) {
            this.valueNames.add("CurrentAC");
        } else if (this.currentMode.equals("AACDC")) {
            this.valueNames.add("CurrentACDC");
        } else if (this.currentMode.equalsIgnoreCase("Ohm")) {
            this.valueNames.add("Resistance");
        } else if (this.currentMode.equals("F")) {
            this.valueNames.add("Capacitance");
        } else if (this.currentMode.equalsIgnoreCase("Hz")) {
            this.valueNames.add("Frequency");
        } else if (this.currentMode.equalsIgnoreCase("%")) {
            this.valueNames.add("DutyCycle");
        } else if (this.currentMode.equalsIgnoreCase("W")) {
            this.valueNames.add("Watt");
        } else if (this.currentMode.equalsIgnoreCase("TempF") || this.currentMode.equalsIgnoreCase("TempC")) {
            this.valueNames.add("Temperature");
        } else if (this.currentMode.equalsIgnoreCase("%mA")) {
            this.valueNames.add("mA4_20");
        } else {
            System.out.println("Mode not found " + this.currentMode);
        }
    }

    @Override
    public synchronized void initColumns() {
        if (this.valueNames != null) {
            return;
        }
        super.initColumns();
        this.selectMode();
        this.askValueCommand = new SCPICommand((DeviceInterface)this, "VALUE?");
    }

    public static String deviceName() {
        return "UNI-T";
    }

    @Override
    public String getDeviceName() {
        return this.def.getDeviceName();
    }

    @Override
    public String getDeviceId() {
        return this.def.getIdName();
    }

    @Override
    public CommInterface getCommInterface(CommInterface ci) {
        if (!(ci instanceof SerialInterface)) {
            return null;
        }
        ((SerialInterface)ci).setTimeout(1000);
        ((SerialInterface)ci).setEOL("\r");
        switch (Integer.parseInt(this.def.getItem("#subDriver"))) {
            case 1: {
                this.ci = new UniT1Interface(ci);
                break;
            }
            case 2: {
                this.ci = new UniT2Interface(ci, false);
                break;
            }
            case 3: {
                this.ci = new UniT3Interface(ci);
                break;
            }
            case 4: {
                this.ci = new UniT2Interface(ci, true);
                break;
            }
            case 5: {
                this.ci = new UniT4Interface(((SerialInterface)ci).getDataInterface());
            }
        }
        ((UniTInterface)this.ci).idnResponse = this.def.getIdName();
        return this.ci;
    }

    private class UniT1Interface
    extends UniTInterface {
        public UniT1Interface(CommInterface ci) {
            super(ci);
        }

        @Override
        public String read(int timeout) {
            String s = super.read(timeout);
            if (s == null) {
                return s;
            }
            if (s.length() == 12 && s.matches("[0-9]{6}.*")) {
                double digits = Integer.valueOf(s.substring(1, 6)).intValue();
                double val = 0.0;
                int f = s.charAt(0) - 48;
                double[] factors = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9};
                String mode = "";
                switch (s.charAt(6)) {
                    case ';': {
                        mode = "V";
                        if (f == 4) {
                            val = digits / 100000.0;
                            break;
                        }
                        val = digits * factors[f] / 10000.0;
                        break;
                    }
                    case '3': {
                        mode = "ohm";
                        val = digits * factors[f] / 100.0;
                        break;
                    }
                    case '6': {
                        mode = "F";
                        val = digits * factors[f] / 1.0E12;
                        break;
                    }
                    case '2': {
                        mode = "Hz";
                        val = digits * factors[f] / (double)(f > 2 ? 1000 : 100);
                        break;
                    }
                    case '=': {
                        mode = "A";
                        val = digits * factors[f] / 1.0E8;
                        break;
                    }
                    case '?': {
                        mode = "A";
                        val = digits * factors[f] / 1000000.0;
                        break;
                    }
                    case '0': {
                        mode = "A";
                        val = digits * factors[f] / 1000.0;
                        break;
                    }
                    case '5': {
                        mode = "ohm";
                        val = digits * factors[f] / 100.0;
                        break;
                    }
                    case '1': {
                        mode = "V";
                        val = digits / 10000.0;
                    }
                }
                if ((s.charAt(10) & 8) != 0) {
                    mode = String.valueOf(mode) + "DC";
                }
                if ((s.charAt(10) & 4) != 0) {
                    mode = String.valueOf(mode) + "AC";
                }
                if (((byte)s.charAt(7) & 1) != 0) {
                    val = Double.POSITIVE_INFINITY;
                }
                if (((byte)s.charAt(7) & 4) != 0) {
                    val = -val;
                }
                s.charAt(7);
                if (((byte)s.charAt(7) & 8) != 0) {
                    mode = "%";
                    val = digits / 10.0;
                } else if ((s.charAt(10) & '\u0001') != 0) {
                    mode = "Hz";
                    val = digits * factors[f] / (double)(f > 2 ? 1000 : 100);
                }
                DeviceUnitDMM.this.currentMode = mode;
                if (!DeviceUnitDMM.this.selectedMode.equals(mode)) {
                    DeviceUnitDMM.this.requestInitColumns();
                }
                if (((byte)s.charAt(7) & 1) != 0) {
                    DeviceUnitDMM deviceUnitDMM = DeviceUnitDMM.this;
                    deviceUnitDMM.overflowCounter = deviceUnitDMM.overflowCounter + 1;
                    if (DeviceUnitDMM.this.overflowCounter <= Support.systemSettings.delayOverflow) {
                        return DeviceUnitDMM.this.lastValue;
                    }
                    return DeviceUnitDMM.this.overflowValueString(true);
                }
                if (((byte)s.charAt(9) & 8) != 0) {
                    if (DeviceUnitDMM.this.overflowCounter <= Support.systemSettings.delayOverflow) {
                        return DeviceUnitDMM.this.lastValue;
                    }
                    return DeviceUnitDMM.this.overflowValueString(false);
                }
                DeviceUnitDMM.this.lastValue = Double.toString(val);
                DeviceUnitDMM.this.overflowCounter = 0;
                return DeviceUnitDMM.this.lastValue;
            }
            return s;
        }
    }

    private class UniT2Interface
    extends UniTInterface {
        private boolean ohmRangeAdjust;

        public UniT2Interface(CommInterface ci, boolean ohmRangeAdjust) {
            super(ci);
            this.ohmRangeAdjust = false;
            this.ohmRangeAdjust = ohmRangeAdjust;
        }

        @Override
        public String read(int timeout) {
            String s = super.read(timeout);
            if (s == null || s.length() != 9 || !s.matches("[0-9:;<=>?]{6}.*")) {
                return s;
            }
            String mode = "";
            double val = this.dataToNumber(s.substring(0, 5));
            int f = s.charAt(5) - 48;
            double[] factors = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9};
            switch (s.charAt(6)) {
                case '1': {
                    mode = "V";
                    val *= factors[f] / 100000.0;
                    break;
                }
                case '2': {
                    mode = "V";
                    val *= factors[f] / 100000.0;
                    break;
                }
                case '3': {
                    mode = "V";
                    val *= factors[f] / 100000.0;
                    break;
                }
                case '4': {
                    mode = "ohm";
                    val *= factors[f] / 1000.0;
                    if (!this.ohmRangeAdjust) break;
                    val *= 10.0;
                    break;
                }
                case '5': {
                    mode = "F";
                    val *= factors[f] / 1.0E13;
                    break;
                }
                case '6': {
                    mode = "TempC";
                    val *= 0.1;
                    break;
                }
                case '7': {
                    mode = "A";
                    val *= factors[f] / 1.0E8;
                    break;
                }
                case '8': {
                    mode = "A";
                    val *= factors[f] / 1000000.0;
                    break;
                }
                case '9': {
                    mode = "A";
                    val *= factors[f] / 10000.0;
                    break;
                }
                case ':': {
                    mode = "ohm";
                    val *= 0.01;
                    if (!this.ohmRangeAdjust) break;
                    val *= 10.0;
                    break;
                }
                case ';': {
                    mode = "V";
                    val /= 10000.0;
                    break;
                }
                case '<': {
                    mode = (s.charAt(8) & 4) != 0 ? "%" : "Hz";
                    val *= factors[f] / 1000.0;
                    break;
                }
                case '=': {
                    mode = "TempF";
                    val = (val / 10.0 - 32.0) / 1.8;
                    break;
                }
                case '>': {
                    mode = "W";
                    val *= 0.01;
                    break;
                }
                case '?': {
                    mode = "%mA";
                    val /= 100.0;
                }
            }
            if ((s.charAt(7) & 3) == 3) {
                mode = String.valueOf(mode) + "ACDC";
            } else if ((s.charAt(7) & '\u0001') != 0) {
                mode = String.valueOf(mode) + "AC";
            } else if ((s.charAt(7) & 2) != 0) {
                mode = String.valueOf(mode) + "DC";
            }
            if (s.charAt(6) != '<' && ((byte)s.charAt(8) & 4) != 0) {
                val = -val;
            }
            DeviceUnitDMM.this.currentMode = mode;
            if (!DeviceUnitDMM.this.selectedMode.equals(mode)) {
                DeviceUnitDMM.this.requestInitColumns();
            }
            if (!Double.isFinite(val)) {
                DeviceUnitDMM deviceUnitDMM = DeviceUnitDMM.this;
                deviceUnitDMM.overflowCounter = deviceUnitDMM.overflowCounter + 1;
                if (DeviceUnitDMM.this.overflowCounter <= Support.systemSettings.delayOverflow) {
                    return DeviceUnitDMM.this.lastValue;
                }
                return DeviceUnitDMM.this.overflowValueString(val > 0.0);
            }
            DeviceUnitDMM.this.lastValue = Double.toString(val);
            DeviceUnitDMM.this.overflowCounter = 0;
            return DeviceUnitDMM.this.lastValue;
        }
    }

    private class UniT3Interface
    extends UniTInterface {
        public UniT3Interface(CommInterface ci) {
            super(ci);
        }

        @Override
        public String read(int timeout) {
            String s = super.read(timeout);
            if (s == null) {
                return s;
            }
            if (s.length() == 12 && s.matches("[0-9]{6}.*")) {
                double val = (s.charAt(5) - 48) * 10000 + (s.charAt(4) - 48) * 1000 + (s.charAt(3) - 48) * 100 + (s.charAt(2) - 48) * 10 + (s.charAt(1) - 48);
                int f = s.charAt(0) - 48;
                double scaleModifier = (new double[]{1.0E-4, 0.001, 0.01, 0.1, 1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0})[f];
                String mode = "";
                switch (s.charAt(6)) {
                    case '0': {
                        mode = "A";
                        scaleModifier *= 10.0;
                        break;
                    }
                    case '1': {
                        mode = "V";
                        break;
                    }
                    case '2': {
                        mode = "Hz";
                        scaleModifier *= (double)(f > 2 ? 10 : 100);
                        break;
                    }
                    case '3': {
                        mode = "ohm";
                        scaleModifier *= 100.0;
                        break;
                    }
                    case '4': {
                        mode = "TempC";
                        scaleModifier *= 10000.0;
                        break;
                    }
                    case '5': {
                        mode = "ohm";
                        scaleModifier *= 100.0;
                        break;
                    }
                    case '6': {
                        mode = "F";
                        scaleModifier /= 1.0E8;
                        break;
                    }
                    case ';': {
                        mode = "V";
                        if (f != 4) break;
                        scaleModifier *= 1.0E-5;
                        break;
                    }
                    case '=': {
                        mode = "A";
                        if ((s.charAt(11) & 4) != 0) {
                            scaleModifier *= 100.0;
                            break;
                        }
                        scaleModifier /= 10000.0;
                        break;
                    }
                    case '?': {
                        mode = "A";
                        scaleModifier /= 100.0;
                    }
                }
                if ((s.charAt(10) & 8) != 0) {
                    mode = String.valueOf(mode) + "DC";
                }
                if ((s.charAt(10) & 4) != 0) {
                    mode = String.valueOf(mode) + "AC";
                }
                if (((byte)s.charAt(7) & 4) != 0) {
                    val = -val;
                }
                if ((s.charAt(7) & 8) != 0) {
                    if (s.charAt(6) == '4') {
                        val = (val * scaleModifier - 32.0) / 1.8;
                        scaleModifier = 1.0;
                    } else {
                        mode = "%";
                        scaleModifier = 0.1;
                    }
                } else if ((s.charAt(10) & '\u0001') != 0) {
                    mode = "Hz";
                    scaleModifier *= (double)(f > 2 ? 10 : 100);
                }
                val *= scaleModifier;
                DeviceUnitDMM.this.currentMode = mode;
                if (!DeviceUnitDMM.this.selectedMode.equals(mode)) {
                    DeviceUnitDMM.this.requestInitColumns();
                }
                if (((byte)s.charAt(7) & 1) != 0) {
                    DeviceUnitDMM deviceUnitDMM = DeviceUnitDMM.this;
                    deviceUnitDMM.overflowCounter = deviceUnitDMM.overflowCounter + 1;
                    if (DeviceUnitDMM.this.overflowCounter <= Support.systemSettings.delayOverflow) {
                        return DeviceUnitDMM.this.lastValue;
                    }
                    return DeviceUnitDMM.this.overflowValueString(true);
                }
                if (((byte)s.charAt(9) & 8) != 0) {
                    DeviceUnitDMM deviceUnitDMM = DeviceUnitDMM.this;
                    deviceUnitDMM.overflowCounter = deviceUnitDMM.overflowCounter + 1;
                    if (DeviceUnitDMM.this.overflowCounter <= Support.systemSettings.delayOverflow) {
                        return DeviceUnitDMM.this.lastValue;
                    }
                    return DeviceUnitDMM.this.overflowValueString(false);
                }
                DeviceUnitDMM.this.lastValue = Double.toString(val);
                DeviceUnitDMM.this.overflowCounter = 0;
                return DeviceUnitDMM.this.lastValue;
            }
            return s;
        }
    }

    private class UniT4Interface
    extends UniTInterface {
        public UniT4Interface(SerialPacketInterface ci) {
            super(ci);
            ci.setPacketFormat(CommDataInterface.PacketFormat.HeaderFixedLength, new byte[]{43, 45}, 14);
        }

        @Override
        protected void readFromSerialPort() {
            try {
                this.originalCommInterface.debugLog = false;
                byte[] data = ((SerialPacketInterface)this.originalCommInterface).readData(300);
                if (data != null) {
                    this.setMessage(this.decode(data));
                }
            }
            catch (Exception exception) {}
        }

        private String decode(byte[] data) {
            if (data == null || data.length != 14 || data[12] != 13 || data[13] != 10) {
                return DeviceUnitDMM.this.overflowValueString(true);
            }
            String mode = "";
            double val = 0.0;
            int i = 0;
            while (i < 4) {
                char c = (char)data[i + 1];
                if (c >= '0' && c <= '9') {
                    val = val * 10.0 + (double)(c - 48);
                }
                if (c == '?') {
                    val = Double.POSITIVE_INFINITY;
                    break;
                }
                ++i;
            }
            if (data[0] == 45) {
                val = -val;
            }
            double[] factors = new double[]{1.0, 0.001, 0.01, 0.1, 0.1};
            val *= factors[data[6] - 48];
            int sb1 = data[7] & 0xFF;
            int sb2 = data[8] & 0xFF;
            int sb3 = data[9] & 0xFF;
            int sb4 = data[10] & 0xFF;
            if ((sb4 & 0x80) != 0) {
                if ((sb1 & 0x10) != 0) {
                    mode = "VDC";
                } else if ((sb1 & 8) != 0) {
                    mode = "VAC";
                }
            }
            if ((sb4 & 0x40) != 0) {
                if ((sb1 & 0x10) != 0) {
                    mode = "ADC";
                } else if ((sb1 & 8) != 0) {
                    mode = "AAC";
                }
            }
            if ((sb4 & 0x20) != 0) {
                mode = "Ohm";
            }
            if ((sb4 & 4) != 0) {
                mode = "F";
            }
            if ((sb4 & 8) != 0) {
                mode = "Hz";
            }
            if ((sb4 & 2) != 0) {
                mode = "TempC";
            }
            if ((sb4 & 1) != 0) {
                mode = "TempF";
                val = (val - 32.0) / 1.8;
            }
            if ((sb3 & 8) != 0) {
                mode = "Ohm";
            }
            if ((sb3 & 4) != 0) {
                mode = "V";
            }
            if ((sb3 & 2) != 0) {
                mode = "%";
            }
            if ((sb3 & 0x40) != 0) {
                val *= 0.001;
            } else if ((sb3 & 0x80) != 0) {
                val *= 1.0E-6;
            } else if ((sb2 & 2) != 0) {
                val *= 1.0E-9;
            } else if ((sb3 & 0x20) != 0) {
                val *= 1000.0;
            } else if ((sb3 & 0x10) != 0) {
                val *= 1000000.0;
            }
            DeviceUnitDMM.this.currentMode = mode;
            if (!DeviceUnitDMM.this.selectedMode.equals(mode)) {
                DeviceUnitDMM.this.requestInitColumns();
            }
            if (!Double.isFinite(val)) {
                DeviceUnitDMM deviceUnitDMM = DeviceUnitDMM.this;
                deviceUnitDMM.overflowCounter = deviceUnitDMM.overflowCounter + 1;
                if (DeviceUnitDMM.this.overflowCounter <= Support.systemSettings.delayOverflow) {
                    return DeviceUnitDMM.this.lastValue;
                }
                return DeviceUnitDMM.this.overflowValueString(val > 0.0);
            }
            DeviceUnitDMM.this.lastValue = Double.toString(val);
            DeviceUnitDMM.this.overflowCounter = 0;
            return DeviceUnitDMM.this.lastValue;
        }
    }

    private class UniTInterface
    extends StreamingInterface {
        public UniTInterface(CommInterface ci) {
            super(ci);
        }

        protected double dataToNumber(String data) {
            double v = 0.0;
            int i = 0;
            while (i < data.length()) {
                char c = data.charAt(i);
                if (c >= '0' && c <= '9') {
                    v = v * 10.0 + (double)(c - 48);
                } else if (c == '<') {
                    v = Double.POSITIVE_INFINITY;
                }
                ++i;
            }
            return v;
        }

        @Override
        public boolean write(String msg) {
            if (this.stdCommands(msg)) {
                return true;
            }
            if (msg.equalsIgnoreCase("mode?")) {
                this.outputMessage = DeviceUnitDMM.this.currentMode;
            }
            return true;
        }
    }
}

