/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.SCPICommand;
import dk.hkj.main.ValueFormat;
import java.util.ArrayList;

public class DeviceThermoSensor
extends DeviceInterface {
    private static final String idName = "HKJ,ThermoSensor,";
    private static final String longName = "HKJ ThermoSensor";
    private static final String handleName = "TS";

    public DeviceThermoSensor(ManageDeviceDefinitions.DeviceDefinition def) {
        super(def);
        this.valueFormats.add(new ValueFormat("Temp1", "\u00b0C", ValueFormat.formatD2));
        this.valueFormats.add(new ValueFormat("TempCJ1", "\u00b0C", ValueFormat.formatD2));
        this.valueFormats.add(new ValueFormat("Temp2", "\u00b0C", ValueFormat.formatD2));
        this.valueFormats.add(new ValueFormat("TempCJ2", "\u00b0C", ValueFormat.formatD2));
        this.setHandleName(handleName);
    }

    public static String name() {
        return idName;
    }

    public static String deviceName() {
        return longName;
    }

    public static String handleName() {
        return handleName;
    }

    @Override
    public String getDeviceName() {
        return longName;
    }

    @Override
    public String getDeviceId() {
        return idName;
    }

    @Override
    protected boolean mayModifyColumns(String cmd) {
        return cmd.equalsIgnoreCase("ENABLE");
    }

    @Override
    public synchronized void initColumns() {
        if (this.valueNames != null) {
            return;
        }
        this.valueNames = new ArrayList();
        String s = this.dt.cPort.writeRead("ENABLE?");
        if (s == null) {
            System.out.println("No answer from " + this.getDeviceName());
            return;
        }
        if ((s = s.trim()).equalsIgnoreCase("1")) {
            this.valueNames.add("Temp1");
            this.valueNames.add("TempCJ1");
        } else if (s.equalsIgnoreCase("1")) {
            this.valueNames.add("Temp2");
            this.valueNames.add("TempCJ2");
        } else {
            this.valueNames.add("Temp1");
            this.valueNames.add("TempCJ1");
            this.valueNames.add("Temp2");
            this.valueNames.add("TempCJ2");
        }
        this.askValueCommand = new SCPICommand((DeviceInterface)this, "TEMP?");
    }
}

