/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.SCPICommand;
import dk.hkj.main.ValueFormat;
import java.util.ArrayList;

public class DeviceThermoAndMore
extends DeviceInterface {
    private static final String idName = "HKJ,ThermoAndMore,";
    private static final String longName = "HKJ ThermoAndMore";
    private static final String handleName = "TAM";

    public DeviceThermoAndMore(ManageDeviceDefinitions.DeviceDefinition def) {
        super(def);
        this.valueFormats.add(new ValueFormat("Temp", "\u00b0C", ValueFormat.formatD2));
        this.valueFormats.add(new ValueFormat("LDR", "ohm", ValueFormat.formatInt));
        this.valueFormats.add(new ValueFormat("LDRlog", "", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("Red", "", ValueFormat.formatInt));
        this.valueFormats.add(new ValueFormat("Green", "", ValueFormat.formatInt));
        this.valueFormats.add(new ValueFormat("Blue", "", ValueFormat.formatInt));
        this.valueFormats.add(new ValueFormat("Clean", "", ValueFormat.formatInt));
        this.valueFormats.add(new ValueFormat("Hue", "", ValueFormat.formatInt));
        this.valueFormats.add(new ValueFormat("Ambient", "\u00b0C", ValueFormat.formatD1));
        this.valueFormats.add(new ValueFormat("Humidity", "%RH", ValueFormat.formatD1));
        this.setHandleName(handleName);
    }

    public static String name() {
        return idName;
    }

    public static String deviceName() {
        return longName;
    }

    public static String handleName() {
        return handleName;
    }

    @Override
    public String getDeviceName() {
        return longName;
    }

    @Override
    public String getDeviceId() {
        return idName;
    }

    @Override
    protected boolean mayModifyColumns(String cmd) {
        return cmd.equalsIgnoreCase("INCLUDE");
    }

    @Override
    public synchronized void initColumns() {
        if (this.valueNames != null) {
            return;
        }
        this.valueNames = new ArrayList();
        String s = this.dt.cPort.writeRead("INCLUDE?");
        if (s == null) {
            System.out.println("No answer from " + this.getDeviceName());
            return;
        }
        s = s.trim();
        int i = 0;
        while (i < s.length()) {
            switch (s.charAt(i)) {
                case 'T': {
                    this.valueNames.add("Temp");
                    break;
                }
                case 'L': {
                    this.valueNames.add("LDR");
                    break;
                }
                case 'X': {
                    this.valueNames.add("LDRlog");
                    break;
                }
                case 'R': {
                    this.valueNames.add("Red");
                    break;
                }
                case 'G': {
                    this.valueNames.add("Green");
                    break;
                }
                case 'B': {
                    this.valueNames.add("Blue");
                    break;
                }
                case 'C': {
                    this.valueNames.add("Clean");
                    break;
                }
                case 'H': {
                    this.valueNames.add("Hue");
                    break;
                }
                case 'A': {
                    this.valueNames.add("Ambient");
                    break;
                }
                case 'W': {
                    this.valueNames.add("Humidity");
                }
            }
            ++i;
        }
        this.askValueCommand = new SCPICommand((DeviceInterface)this, "VALUES?");
    }
}

