/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommInterface;
import dk.hkj.comm.VirtualInterface;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.SCPICommand;
import dk.hkj.main.ValueFormat;
import dk.hkj.util.StringUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.swing.Timer;

public class DeviceSoundcardOutput
extends DeviceInterface {
    private static final String idName = "HKJ,Soundcard output,";
    private static final String longName = "Soundcard output";
    private static final String handleName = "SO";
    private NumberFormat nf;

    public DeviceSoundcardOutput(ManageDeviceDefinitions.DeviceDefinition def) {
        super(def);
        this.valueFormats.add(new ValueFormat("Frequency", "Hz", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("Volume", "", ValueFormat.formatD2));
        this.nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        this.nf.setGroupingUsed(false);
        this.nf.setMaximumFractionDigits(5);
        this.setHandleName(handleName);
    }

    public static String name() {
        return idName;
    }

    public static String deviceName() {
        return longName;
    }

    public static String handleName() {
        return handleName;
    }

    @Override
    public String getDeviceName() {
        return longName;
    }

    @Override
    public String getDeviceId() {
        return idName;
    }

    @Override
    public synchronized void initColumns() {
        if (this.valueNames != null) {
            return;
        }
        this.valueNames = new ArrayList();
        this.valueNames.add("Frequency");
        this.valueNames.add("Volume");
        this.askValueCommand = new SCPICommand((DeviceInterface)this, "VALUES?");
    }

    @Override
    public void resetTime() {
        ((VirtualComm)this.dt.cPort).resetTime();
    }

    @Override
    public CommInterface getCommInterface(CommInterface ci) {
        return new VirtualComm();
    }

    public static void resetForReload() {
        VirtualInterface.idNoSeq = 0;
    }

    static enum OutputPort {
        Mono,
        Left,
        Right,
        Stereo;

    }

    static enum SingleSweep {
        None,
        Waiting,
        Sweeping,
        Done;

    }

    private class VirtualComm
    extends VirtualInterface
    implements ActionListener {
        private long startTimeStamp = 0L;
        private int[] SupportedSampleRates = new int[]{16000, 32000, 44100, 48000, 96000, 192000};
        private int[] SupportedBitSizes = new int[]{8, 16, 24, 32};
        private Mixer.Info selectedMixer = null;
        private List<Mixer.Info> mixerList = new ArrayList<Mixer.Info>();
        private int selectedBits = 16;
        private int selectedSampleRate = 44100;
        private double frequency = 1000.0;
        private double currentFrequency = 1000.0;
        private double sweepStart = 20.0;
        private double sweepEnd = 20000.0;
        private double sweepTime = 30.0;
        private boolean sweepMode = false;
        private double phase = 180.0;
        private OutputPort outputPort = OutputPort.Mono;
        private Waveform waveform = Waveform.Sine;
        private Player player = null;
        private boolean on = false;
        private boolean done = false;
        private SingleSweep singleSweep = SingleSweep.None;
        private Timer timer = null;

        VirtualComm() {
            Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
            int n = infoArray.length;
            int n2 = 0;
            while (n2 < n) {
                Mixer.Info mixerInfo = infoArray[n2];
                if (this.getAudioFormat(mixerInfo).size() >= 1) {
                    this.mixerList.add(mixerInfo);
                }
                ++n2;
            }
            if (this.mixerList.size() > 0) {
                this.selectedMixer = this.mixerList.get(0);
            }
            this.timer = new Timer(100, this);
            this.timer.start();
            this.player = new Player();
        }

        private int channels() {
            if (this.outputPort.equals((Object)OutputPort.Mono)) {
                return 1;
            }
            return 2;
        }

        @Override
        public String getName() {
            return "Virtual";
        }

        @Override
        public void open() {
            super.open();
            this.resetTime();
        }

        @Override
        public void close() {
            this.done = true;
            this.timer.stop();
            this.timer = null;
        }

        private void setSweep(String f1, String f2, String t) {
            this.sweepStart = StringUtil.parseDoubleEE(f1);
            this.sweepEnd = StringUtil.parseDoubleEE(f2);
            this.sweepTime = StringUtil.parseDoubleEE(t);
            this.checkFrequencies();
            this.sweepMode = true;
            this.singleSweep = SingleSweep.None;
            this.player.playSample();
        }

        private String getSweep() {
            return String.valueOf(Double.toString(this.sweepStart)) + " " + Double.toString(this.sweepEnd) + " " + Double.toString(this.sweepTime);
        }

        private void checkFrequencies() {
            int max = this.selectedSampleRate / 2;
            int min = 20;
            if (this.sweepStart > (double)max) {
                this.sweepStart = max;
            }
            if (this.sweepEnd > (double)max) {
                this.sweepEnd = max;
            }
            if (this.frequency > (double)max) {
                this.frequency = max;
            }
            if (this.sweepStart < (double)min) {
                this.sweepStart = min;
            }
            if (this.sweepEnd < (double)min) {
                this.sweepEnd = min;
            }
            if (this.frequency < (double)min) {
                this.frequency = min;
            }
        }

        private byte[] generateSample(double freq) {
            int n = (int)freq / 10;
            int samples = (int)((double)(n * this.selectedSampleRate) / freq);
            double f = Math.PI * 2 * (double)n / (double)samples;
            double p = this.phase * Math.PI / 180.0;
            int dataSize = samples * (this.selectedBits / 8) * this.channels();
            byte[] data = new byte[dataSize];
            int i = 0;
            int j = 0;
            while (j < samples) {
                double a = 0.0;
                double a1 = 0.0;
                switch (this.waveform) {
                    case Sine: {
                        a = Math.cos((double)j * f);
                        if (this.outputPort.equals((Object)OutputPort.Stereo) && p != 0.0) {
                            a1 = Math.cos((double)j * f + p);
                            break;
                        }
                        a1 = a;
                        break;
                    }
                    case Square: {
                        double v = Math.IEEEremainder((double)j * f, Math.PI * 2);
                        if (v < 0.0) {
                            v += Math.PI * 2;
                        }
                        a = v < Math.PI ? 1 : -1;
                        if (this.outputPort.equals((Object)OutputPort.Stereo) && p != 0.0) {
                            if ((v = Math.IEEEremainder(v + p, Math.PI * 2)) < 0.0) {
                                v += Math.PI * 2;
                            }
                            a1 = v < Math.PI ? 1 : -1;
                            break;
                        }
                        a1 = a;
                        break;
                    }
                    case Ramp: {
                        double v = Math.IEEEremainder((double)j * f, Math.PI * 2);
                        if (v < 0.0) {
                            v += Math.PI * 2;
                        }
                        a = ((v < Math.PI ? v / Math.PI : (Math.PI * 2 - v) / Math.PI) - 0.5) * 2.0;
                        if (this.outputPort.equals((Object)OutputPort.Stereo) && p != 0.0) {
                            v = Math.IEEEremainder((double)j * f + p, Math.PI * 2);
                            if (v < 0.0) {
                                v += Math.PI * 2;
                            }
                            a1 = ((v < Math.PI ? v / Math.PI : (Math.PI * 2 - v) / Math.PI) - 0.5) * 2.0;
                            break;
                        }
                        a1 = a;
                    }
                }
                block5 : switch (this.selectedBits) {
                    case 8: {
                        byte k = (byte)(a * 127.0);
                        switch (this.outputPort) {
                            case Mono: {
                                data[i++] = k;
                                break;
                            }
                            case Left: {
                                data[i++] = k;
                                data[i++] = 0;
                                break;
                            }
                            case Right: {
                                data[i++] = 0;
                                data[i++] = k;
                                break;
                            }
                            case Stereo: {
                                data[i++] = k;
                                k = (byte)(a1 * 127.0);
                                data[i++] = k;
                            }
                        }
                        break;
                    }
                    case 16: {
                        int k = (int)(a * 32767.0);
                        switch (this.outputPort) {
                            case Mono: {
                                data[i++] = (byte)(k >> 8);
                                data[i++] = (byte)k;
                                break;
                            }
                            case Left: {
                                data[i++] = (byte)(k >> 8);
                                data[i++] = (byte)k;
                                data[i++] = 0;
                                data[i++] = 0;
                                break;
                            }
                            case Right: {
                                data[i++] = 0;
                                data[i++] = 0;
                                data[i++] = (byte)(k >> 8);
                                data[i++] = (byte)k;
                                break;
                            }
                            case Stereo: {
                                data[i++] = (byte)(k >> 8);
                                data[i++] = (byte)k;
                                k = (int)(a1 * 32767.0);
                                data[i++] = (byte)(k >> 8);
                                data[i++] = (byte)k;
                            }
                        }
                        break;
                    }
                    case 24: {
                        long k = (long)(a * 8388607.0);
                        switch (this.outputPort) {
                            case Mono: {
                                data[i++] = (byte)(k >> 16);
                                data[i++] = (byte)(k >> 8);
                                data[i++] = (byte)k;
                                break;
                            }
                            case Left: {
                                data[i++] = (byte)(k >> 16);
                                data[i++] = (byte)(k >> 8);
                                data[i++] = (byte)k;
                                data[i++] = 0;
                                data[i++] = 0;
                                data[i++] = 0;
                                break;
                            }
                            case Right: {
                                data[i++] = 0;
                                data[i++] = 0;
                                data[i++] = 0;
                                data[i++] = (byte)(k >> 16);
                                data[i++] = (byte)(k >> 8);
                                data[i++] = (byte)k;
                                break;
                            }
                            case Stereo: {
                                data[i++] = (byte)(k >> 16);
                                data[i++] = (byte)(k >> 8);
                                data[i++] = (byte)k;
                                k = (long)(a1 * 8388607.0);
                                data[i++] = (byte)(k >> 16);
                                data[i++] = (byte)(k >> 8);
                                data[i++] = (byte)k;
                            }
                        }
                        break;
                    }
                    case 32: {
                        long k = (long)(a * 2.147483647E9);
                        switch (this.outputPort) {
                            case Mono: {
                                data[i++] = (byte)(k >> 24);
                                data[i++] = (byte)(k >> 16);
                                data[i++] = (byte)(k >> 8);
                                data[i++] = (byte)k;
                                break block5;
                            }
                            case Left: {
                                data[i++] = (byte)(k >> 24);
                                data[i++] = (byte)(k >> 16);
                                data[i++] = (byte)(k >> 8);
                                data[i++] = (byte)k;
                                data[i++] = 0;
                                data[i++] = 0;
                                data[i++] = 0;
                                data[i++] = 0;
                                break block5;
                            }
                            case Right: {
                                data[i++] = 0;
                                data[i++] = 0;
                                data[i++] = 0;
                                data[i++] = 0;
                                data[i++] = (byte)(k >> 24);
                                data[i++] = (byte)(k >> 16);
                                data[i++] = (byte)(k >> 8);
                                data[i++] = (byte)k;
                                break block5;
                            }
                            case Stereo: {
                                data[i++] = (byte)(k >> 24);
                                data[i++] = (byte)(k >> 16);
                                data[i++] = (byte)(k >> 8);
                                data[i++] = (byte)k;
                                k = (long)(a1 * 2.147483647E9);
                                data[i++] = (byte)(k >> 24);
                                data[i++] = (byte)(k >> 16);
                                data[i++] = (byte)(k >> 8);
                                data[i++] = (byte)k;
                            }
                        }
                    }
                }
                ++j;
            }
            return data;
        }

        private void sleep100() {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }

        private void calculateFrequency() {
            switch (this.singleSweep) {
                case None: {
                    if (this.sweepMode) {
                        long dt = (System.currentTimeMillis() - this.startTimeStamp) % ((long)this.sweepTime * 1000L);
                        this.currentFrequency = this.sweepStart * Math.pow(Math.pow(this.sweepEnd / this.sweepStart, 0.001 / this.sweepTime), dt);
                        break;
                    }
                    this.currentFrequency = this.frequency;
                    break;
                }
                case Waiting: {
                    this.sweepMode = false;
                    this.currentFrequency = this.sweepStart;
                    if (!InterfaceThreads.isLogging()) break;
                    this.singleSweep = SingleSweep.Sweeping;
                    this.startTimeStamp = System.currentTimeMillis();
                    break;
                }
                case Sweeping: {
                    long dt = System.currentTimeMillis() - this.startTimeStamp;
                    if ((double)dt / 1000.0 <= this.sweepTime) {
                        this.currentFrequency = this.sweepStart * Math.pow(Math.pow(this.sweepEnd / this.sweepStart, 0.001 / this.sweepTime), dt %= (long)this.sweepTime * 1000L);
                        break;
                    }
                    this.currentFrequency = this.sweepEnd;
                    this.singleSweep = SingleSweep.Done;
                    break;
                }
                case Done: {
                    this.sweepMode = false;
                    this.currentFrequency = this.sweepEnd;
                }
            }
        }

        public String getAudioDeviceList() {
            StringBuilder sb = new StringBuilder();
            for (Mixer.Info mixerInfo : this.mixerList) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append("\"");
                sb.append(mixerInfo.getName());
                sb.append("\"");
            }
            return sb.toString();
        }

        public String getBitList() {
            TreeSet<Integer> audioFormats = new TreeSet<Integer>();
            for (AudioFormat af : this.getAudioFormat(this.selectedMixer)) {
                if (af.getSampleSizeInBits() == -1) continue;
                audioFormats.add(af.getSampleSizeInBits());
            }
            if (audioFormats.size() == 0) {
                int[] nArray = this.SupportedBitSizes;
                int n = this.SupportedBitSizes.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    audioFormats.add(i);
                    ++n2;
                }
            }
            StringBuilder sb = new StringBuilder();
            for (Integer i : audioFormats) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(i);
            }
            return sb.toString();
        }

        public String getSampleRateList() {
            TreeSet<Integer> sampleRates = new TreeSet<Integer>();
            for (AudioFormat af : this.getAudioFormat(this.selectedMixer)) {
                if (af.getSampleRate() == -1.0f) continue;
                sampleRates.add((int)af.getSampleRate());
            }
            if (sampleRates.size() == 0) {
                int[] nArray = this.SupportedSampleRates;
                int n = this.SupportedSampleRates.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    try {
                        if (AudioSystem.getSourceDataLine(new AudioFormat(i, this.selectedBits, this.channels(), true, true), this.selectedMixer) != null) {
                            sampleRates.add(i);
                        }
                    }
                    catch (LineUnavailableException lineUnavailableException) {}
                    ++n2;
                }
            }
            StringBuilder sb = new StringBuilder();
            for (Integer i : sampleRates) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(StringUtil.formatDoubleEE(i.intValue(), false));
            }
            return sb.toString();
        }

        public int getSampleRate() {
            return this.selectedSampleRate;
        }

        public void setSampleRate(int rate) {
            if (this.findFormat(rate, this.selectedBits) != null) {
                this.selectedSampleRate = rate;
                this.checkFrequencies();
                this.player.playSample();
            }
        }

        public String getSelectedAudioDevice() {
            if (this.selectedMixer == null) {
                return "None";
            }
            return this.selectedMixer.getName();
        }

        public void setSelectedAudioDevice(String device) {
            for (Mixer.Info mixerInfo : this.mixerList) {
                if (!mixerInfo.getName().startsWith(device)) continue;
                this.selectedMixer = mixerInfo;
                this.player.playSample();
                return;
            }
        }

        private AudioFormat findFormat(int sampleRate, int bits) {
            for (AudioFormat af : this.getAudioFormat(this.selectedMixer)) {
                if (af.getSampleSizeInBits() != -1 && af.getSampleSizeInBits() != bits || af.getSampleRate() != -1.0f && af.getSampleRate() != (float)sampleRate) continue;
                return af;
            }
            return null;
        }

        public String getBit() {
            return Integer.toString(this.selectedBits);
        }

        public void setBit(int bits) {
            if (bits != 8 && bits != 16 && bits != 24 && bits != 32) {
                return;
            }
            if (this.findFormat(this.selectedSampleRate, bits) != null) {
                this.selectedBits = bits;
                this.player.playSample();
            }
        }

        private void setOutputPort(String port) {
            OutputPort[] outputPortArray = OutputPort.values();
            int n = outputPortArray.length;
            int n2 = 0;
            while (n2 < n) {
                OutputPort op = outputPortArray[n2];
                if (op.name().equalsIgnoreCase(port)) {
                    this.outputPort = op;
                    this.player.playSample();
                    return;
                }
                ++n2;
            }
        }

        private void setWaveform(String wave) {
            Waveform[] waveformArray = Waveform.values();
            int n = waveformArray.length;
            int n2 = 0;
            while (n2 < n) {
                Waveform w = waveformArray[n2];
                if (w.name().equalsIgnoreCase(wave)) {
                    this.waveform = w;
                    this.player.playSample();
                    return;
                }
                ++n2;
            }
        }

        private List<AudioFormat> getAudioFormat(Mixer.Info mixerInfo) {
            ArrayList<AudioFormat> list = new ArrayList<AudioFormat>();
            Line.Info[] infoArray = AudioSystem.getMixer(mixerInfo).getSourceLineInfo();
            int n = infoArray.length;
            int n2 = 0;
            while (n2 < n) {
                Line.Info lineInfo = infoArray[n2];
                if (lineInfo instanceof DataLine.Info) {
                    AudioFormat[] audioFormatArray = ((DataLine.Info)lineInfo).getFormats();
                    int n3 = audioFormatArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        AudioFormat af = audioFormatArray[n4];
                        if (!(af.getEncoding() != AudioFormat.Encoding.PCM_SIGNED || !af.isBigEndian() && af.getSampleSizeInBits() != 8 || af.getSampleSizeInBits() != 8 && af.getSampleSizeInBits() != 16 && af.getSampleSizeInBits() != 24 && af.getSampleSizeInBits() != 32)) {
                            list.add(af);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            return list;
        }

        private synchronized void resetTime() {
            this.startTimeStamp = System.currentTimeMillis();
        }

        private double[] calculateOutput() {
            if (!this.on) {
                return new double[]{this.currentFrequency, -100.0};
            }
            if (this.sweepMode && InterfaceThreads.isLogging() || this.singleSweep != SingleSweep.None) {
                this.player.playSample();
            }
            return new double[]{this.currentFrequency, this.player.getVolume()};
        }

        @Override
        public synchronized boolean write(String msg) {
            String[] items = msg.split("[ ;]");
            if (items.length == 0) {
                return true;
            }
            try {
                int i = 0;
                while (i < items.length) {
                    items[i] = items[i].trim();
                    ++i;
                }
                String cmd = items[0].toUpperCase();
                if (cmd.equals("VALUES?")) {
                    double[] v = this.calculateOutput();
                    this.message.add(String.valueOf(DeviceSoundcardOutput.this.nf.format(v[0])) + " " + DeviceSoundcardOutput.this.nf.format(v[1]));
                } else if (cmd.equals("AUDIODEVICES?")) {
                    this.message.add(this.getAudioDeviceList());
                } else if (cmd.equals("SAMPLERATES?")) {
                    this.message.add(this.getSampleRateList());
                } else if (cmd.equals("SAMPLERATE?")) {
                    this.message.add(StringUtil.formatDoubleEE(this.getSampleRate(), false));
                } else if (cmd.equals("SAMPLERATE") && items.length >= 2) {
                    this.setSampleRate((int)StringUtil.parseDoubleEE(items[1]));
                } else if (cmd.equals("BITS?")) {
                    this.message.add(this.getBitList());
                } else if (cmd.equals("BIT?")) {
                    this.message.add(this.getBit());
                } else if (cmd.equals("BIT") && items.length >= 2) {
                    this.setBit(StringUtil.parseInt(items[1]));
                } else if (cmd.equals("AUDIODEVICE?")) {
                    this.message.add(this.getSelectedAudioDevice());
                } else if (cmd.equals("AUDIODEVICE") && items.length >= 2) {
                    this.setSelectedAudioDevice(items[1]);
                } else if (cmd.equals("FREQ") && items.length >= 2) {
                    this.sweepMode = false;
                    this.singleSweep = SingleSweep.None;
                    this.frequency = StringUtil.parseDoubleEE(items[1]);
                    this.checkFrequencies();
                    this.player.playSample();
                } else if (cmd.equals("PERIOD") && items.length >= 2) {
                    this.sweepMode = false;
                    this.singleSweep = SingleSweep.None;
                    this.frequency = 1.0 / StringUtil.parseDoubleEE(items[1]);
                    this.checkFrequencies();
                    this.player.playSample();
                } else if (cmd.equals("PHASE?")) {
                    this.message.add(DeviceSoundcardOutput.this.nf.format(this.phase));
                } else if (cmd.equals("PHASE") && items.length >= 2) {
                    this.phase = StringUtil.parseDoubleEE(items[1]);
                    this.player.playSample();
                } else if (cmd.equals("FREQ?")) {
                    this.message.add(DeviceSoundcardOutput.this.nf.format(this.frequency));
                } else if (cmd.equals("SWEEP") && items.length >= 4) {
                    this.setSweep(items[1], items[2], items[3]);
                } else if (cmd.equals("SWEEP?")) {
                    this.message.add(this.getSweep());
                } else if (cmd.equals("VOLUME") && items.length >= 2) {
                    this.player.setVolume(StringUtil.parseDoubleEE(items[1]));
                } else if (cmd.equals("VOLUME?")) {
                    this.message.add(DeviceSoundcardOutput.this.nf.format(this.player.getVolume()));
                } else if (cmd.equals("PERIOD?")) {
                    this.message.add(DeviceSoundcardOutput.this.nf.format(1.0 / this.frequency));
                } else if (cmd.equals("ON") && items.length >= 2) {
                    switch (StringUtil.parseInt(items[1])) {
                        case 0: {
                            this.on = false;
                            this.singleSweep = SingleSweep.None;
                            break;
                        }
                        case 1: {
                            this.on = true;
                            if (this.singleSweep == SingleSweep.Waiting) break;
                            this.singleSweep = SingleSweep.None;
                            break;
                        }
                        case 2: {
                            this.on = true;
                            if (this.singleSweep == SingleSweep.Waiting) {
                                this.singleSweep = SingleSweep.Sweeping;
                                this.startTimeStamp = System.currentTimeMillis();
                                break;
                            }
                            this.singleSweep = SingleSweep.Waiting;
                        }
                    }
                    this.player.playSample();
                } else if (cmd.equals("CHANNEL") && items.length >= 2) {
                    this.setOutputPort(items[1]);
                } else if (cmd.equals("CHANNEL?")) {
                    this.message.add(this.outputPort.name());
                } else if (cmd.equals("WAVEFORM") && items.length >= 2) {
                    this.setWaveform(items[1]);
                } else if (cmd.equals("WAVEFORM?")) {
                    this.message.add(this.waveform.name());
                } else if (cmd.equals("ON?")) {
                    this.message.add(this.on ? "1" : "0");
                } else if (cmd.equals("SWEEPMODE?")) {
                    String s = "0";
                    switch (this.singleSweep) {
                        case None: {
                            if (!this.sweepMode) break;
                            s = "1";
                            break;
                        }
                        case Waiting: {
                            s = "2";
                            break;
                        }
                        case Sweeping: {
                            s = "3";
                            break;
                        }
                        case Done: {
                            s = "4";
                        }
                    }
                    this.message.add(s);
                } else if (cmd.equals("SWEEPMODE") && items.length >= 2) {
                    switch (StringUtil.parseInt(items[1])) {
                        case 0: {
                            this.sweepMode = false;
                            this.singleSweep = SingleSweep.None;
                            break;
                        }
                        case 1: {
                            this.sweepMode = true;
                            this.singleSweep = SingleSweep.None;
                            break;
                        }
                        case 2: {
                            this.sweepMode = false;
                            this.singleSweep = SingleSweep.Waiting;
                        }
                    }
                    this.player.playSample();
                } else if (cmd.equals("*IDN?")) {
                    this.message.add(DeviceSoundcardOutput.idName);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if ((this.sweepMode || this.singleSweep == SingleSweep.Sweeping) && !InterfaceThreads.isLogging()) {
                this.player.playSample();
            }
        }

        private class Player
        extends Thread {
            private byte[] data = null;
            private byte[] dataNext = null;
            private SourceDataLine line = null;
            private int bufferIndex = 0;
            private int currentBits = 0;
            private int currentSampleRate = 0;
            private int currentChannels = 1;
            private double currentPhase = 0.0;
            private Mixer.Info currentMixer = null;
            private int bufferLimit = 0;
            private double volume = 0.0;

            Player() {
                this.setDaemon(true);
                this.setPriority(10);
                this.setName("SO Player");
                this.start();
            }

            public synchronized void setVolume(double volume) {
                this.volume = volume;
                try {
                    if (this.line != null && this.line.isOpen()) {
                        Mixer mixer;
                        FloatControl control = (FloatControl)this.line.getControl(FloatControl.Type.MASTER_GAIN);
                        if (control == null && (mixer = AudioSystem.getMixer(VirtualComm.this.selectedMixer)) != null && mixer.isOpen()) {
                            control = (FloatControl)mixer.getControl(FloatControl.Type.MASTER_GAIN);
                        }
                        if (control != null) {
                            control.setValue((float)volume);
                        }
                    }
                }
                catch (Exception exception) {}
            }

            public synchronized double getVolume() {
                try {
                    if (this.line != null && this.line.isOpen()) {
                        Mixer mixer;
                        FloatControl control = (FloatControl)this.line.getControl(FloatControl.Type.MASTER_GAIN);
                        if (control == null && (mixer = AudioSystem.getMixer(VirtualComm.this.selectedMixer)) != null && mixer.isOpen()) {
                            control = (FloatControl)mixer.getControl(FloatControl.Type.MASTER_GAIN);
                        }
                        if (control != null) {
                            this.volume = control.getValue();
                        }
                    }
                }
                catch (Exception exception) {}
                return this.volume;
            }

            public void playSample() {
                VirtualComm.this.calculateFrequency();
                if (VirtualComm.this.selectedSampleRate != this.currentSampleRate || VirtualComm.this.selectedBits != this.currentBits || !VirtualComm.this.on || VirtualComm.this.channels() != this.currentChannels || !VirtualComm.this.selectedMixer.equals(this.currentMixer) || VirtualComm.this.phase != this.currentPhase) {
                    if (this.line != null) {
                        this.line.close();
                    }
                } else {
                    this.setDataNext(VirtualComm.this.generateSample(VirtualComm.this.currentFrequency));
                }
            }

            private synchronized void setDataNext(byte[] d) {
                this.dataNext = d;
            }

            private synchronized byte[] getDataNext() {
                byte[] d = this.dataNext;
                this.dataNext = null;
                return d;
            }

            private void fillBuffer() {
                try {
                    int n = this.line.available() - this.bufferLimit;
                    if (n > 0) {
                        if (this.bufferIndex >= this.data.length) {
                            this.bufferIndex = 0;
                            if (this.dataNext != null) {
                                this.data = this.getDataNext();
                            }
                        }
                        if (n + this.bufferIndex > this.data.length) {
                            n = this.data.length - this.bufferIndex;
                        }
                        this.line.write(this.data, this.bufferIndex, n);
                        this.bufferIndex += n;
                    } else {
                        Thread.sleep(10L);
                    }
                }
                catch (Exception e) {
                    this.bufferIndex = 0;
                    e.printStackTrace(System.out);
                }
            }

            private synchronized void setup() {
                AudioFormat af = new AudioFormat(VirtualComm.this.selectedSampleRate, VirtualComm.this.selectedBits, VirtualComm.this.channels(), true, true);
                this.currentBits = VirtualComm.this.selectedBits;
                this.currentSampleRate = VirtualComm.this.selectedSampleRate;
                this.currentChannels = VirtualComm.this.channels();
                this.currentPhase = VirtualComm.this.phase;
                this.currentMixer = VirtualComm.this.selectedMixer;
                this.data = VirtualComm.this.generateSample(VirtualComm.this.currentFrequency);
                try {
                    if (this.line != null && this.line.isOpen()) {
                        this.line.close();
                    }
                    this.line = AudioSystem.getSourceDataLine(af, VirtualComm.this.selectedMixer);
                    this.line.open();
                    this.setVolume(this.volume);
                    this.line.start();
                    this.bufferLimit = this.line.available() - VirtualComm.this.selectedSampleRate / 16;
                    if (this.bufferLimit < 0) {
                        this.bufferLimit = 0;
                    }
                    this.bufferIndex = 0;
                }
                catch (LineUnavailableException lineUnavailableException) {
                    VirtualComm.this.sleep100();
                }
            }

            @Override
            public void run() {
                try {
                    while (!VirtualComm.this.done) {
                        if (this.line == null || !this.line.isOpen()) {
                            if (VirtualComm.this.on) {
                                this.setup();
                                continue;
                            }
                            VirtualComm.this.sleep100();
                            continue;
                        }
                        this.fillBuffer();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                }
                if (this.line != null) {
                    this.line.close();
                }
            }
        }
    }

    static enum Waveform {
        Sine,
        Ramp,
        Square;

    }
}

